/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.escape;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.collect.ImmutableMap;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.alerts.AlertSetBuilder;
import com.google.gxp.compiler.alerts.AlertSink;
import com.google.gxp.compiler.base.AbbrExpression;
import com.google.gxp.compiler.base.AttrBundleParam;
import com.google.gxp.compiler.base.BooleanConstant;
import com.google.gxp.compiler.base.BoundCall;
import com.google.gxp.compiler.base.Call;
import com.google.gxp.compiler.base.CallVisitor;
import com.google.gxp.compiler.base.Callable;
import com.google.gxp.compiler.base.CollapseExpression;
import com.google.gxp.compiler.base.Concatenation;
import com.google.gxp.compiler.base.Conditional;
import com.google.gxp.compiler.base.ConstructedConstant;
import com.google.gxp.compiler.base.ContentType;
import com.google.gxp.compiler.base.DefaultingTypeVisitor;
import com.google.gxp.compiler.base.EscapeExpression;
import com.google.gxp.compiler.base.ExhaustiveExpressionVisitor;
import com.google.gxp.compiler.base.Expression;
import com.google.gxp.compiler.base.ExtractedMessage;
import com.google.gxp.compiler.base.NativeExpression;
import com.google.gxp.compiler.base.ObjectConstant;
import com.google.gxp.compiler.base.OutputElement;
import com.google.gxp.compiler.base.Parameter;
import com.google.gxp.compiler.base.PlaceholderEnd;
import com.google.gxp.compiler.base.PlaceholderNode;
import com.google.gxp.compiler.base.PlaceholderStart;
import com.google.gxp.compiler.base.Root;
import com.google.gxp.compiler.base.StringConstant;
import com.google.gxp.compiler.base.Template;
import com.google.gxp.compiler.base.Type;
import com.google.gxp.compiler.base.TypeVisitor;
import com.google.gxp.compiler.base.UnboundCall;
import com.google.gxp.compiler.base.UnexpectedNodeException;
import com.google.gxp.compiler.base.UnextractedMessage;
import com.google.gxp.compiler.base.Util;
import com.google.gxp.compiler.base.ValidatedCall;
import com.google.gxp.compiler.escape.EscapedTree;
import com.google.gxp.compiler.escape.TypeError;
import com.google.gxp.compiler.escape.UntranslatableMsgError;
import com.google.gxp.compiler.phinsert.PlaceholderInsertedTree;
import com.google.gxp.compiler.reparent.Attribute;
import com.google.gxp.compiler.schema.ContentFamily;
import com.google.gxp.compiler.schema.ContentFamilyVisitor;
import com.google.gxp.compiler.schema.Schema;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Map;

public class Escaper
implements Function<PlaceholderInsertedTree, EscapedTree> {
    private static final ContentFamilyVisitor<String, String> STATIC_ESCAPE_VISITOR = new ContentFamilyVisitor<String, String>(){

        @Override
        public String visitMarkup(String s) {
            return CharEscapers.htmlEscaper().escape(s);
        }

        @Override
        public String visitJavaScript(String s) {
            return s;
        }

        @Override
        public String visitCss(String s) {
            return s;
        }

        @Override
        public String visitPlaintext(String s) {
            return s;
        }
    };

    @Override
    public EscapedTree apply(PlaceholderInsertedTree tree) {
        AlertSetBuilder alertSetBuilder = new AlertSetBuilder(tree.getAlerts());
        Worker worker = new Worker(alertSetBuilder);
        Root root = worker.apply((Root)tree.getRoot());
        return new EscapedTree(tree.getSourcePosition(), alertSetBuilder.buildAndClear(), root);
    }

    private class Worker
    implements Function<Root, Root> {
        private final AlertSink alertSink;
        private final Map<Schema, Visitor> visitors = Maps.newHashMap();

        Worker(AlertSink alertSink) {
            this.alertSink = Preconditions.checkNotNull(alertSink);
        }

        private Visitor visitor(Schema schema) {
            Visitor result = this.visitors.get(schema);
            if (result == null) {
                result = new Visitor(schema);
                this.visitors.put(schema, result);
            }
            return result;
        }

        @Override
        public Root apply(Root root) {
            return root.getSchema() == null ? root : root.acceptVisitor(this.visitor(root.getSchema()));
        }

        private class Visitor
        extends ExhaustiveExpressionVisitor
        implements CallVisitor<Expression> {
            private final Schema schema;
            private final Deque<Attribute> attrStack = new ArrayDeque<Attribute>();
            private final Function<Parameter, Parameter> parameterTransformer = new Function<Parameter, Parameter>(){

                @Override
                public Parameter apply(Parameter param) {
                    Expression defaultValue = param.getDefaultValue();
                    if (defaultValue != null) {
                        Visitor valueVisitor = (Visitor)param.getType().acceptTypeVisitor(Visitor.this.typeVisitor);
                        param = param.withDefaultValue(defaultValue.acceptVisitor(valueVisitor));
                    }
                    return param.withComment(param.getComment().acceptVisitor(Visitor.this));
                }
            };
            private TypeVisitor<Visitor> typeVisitor = new DefaultingTypeVisitor<Visitor>(){

                @Override
                protected Visitor defaultVisitType(Type type) {
                    return Visitor.this;
                }

                @Override
                public Visitor visitContentType(ContentType type) {
                    return Worker.this.visitor(type.getSchema());
                }
            };

            Visitor(Schema schema) {
                this.schema = Preconditions.checkNotNull(schema);
            }

            @Override
            protected Expression postProcess(Expression result) {
                if (!this.schema.allows(result.getSchema())) {
                    Worker.this.alertSink.add(new TypeError(this.schema, result));
                    return new StringConstant(result, this.schema, "");
                }
                return result;
            }

            @Override
            public Template visitTemplate(Template template) {
                Template result = super.visitTemplate(template);
                if (!this.schema.allows(result.getContent().getSchema())) {
                    throw new AssertionError();
                }
                return result;
            }

            @Override
            protected Function<Parameter, Parameter> getParameterTransformer() {
                return this.parameterTransformer;
            }

            @Override
            public Expression visitAbbrExpression(AbbrExpression node) {
                Visitor valueVisitor = node.getType().acceptTypeVisitor(this.typeVisitor);
                return this.postProcess(node.withValueAndContent(valueVisitor.apply(node.getValue()), this.apply(node.getContent())));
            }

            @Override
            public Expression visitStringConstant(StringConstant node) {
                ContentFamily contentFamily = this.schema.getContentFamily();
                return this.postProcess(new StringConstant(node, this.schema, (String)contentFamily.acceptVisitor(STATIC_ESCAPE_VISITOR, node.evaluate())));
            }

            @Override
            public Expression visitAttrBundleParam(AttrBundleParam node) {
                return this.postProcess(node.transform(Worker.this.visitor(node.getSchema())));
            }

            @Override
            public Expression visitBooleanConstant(BooleanConstant node) {
                return this.postProcess(new EscapeExpression(this.schema, node));
            }

            @Override
            public Expression visitObjectConstant(ObjectConstant node) {
                return this.postProcess(new EscapeExpression(this.schema, node));
            }

            @Override
            public Expression visitConstructedConstant(ConstructedConstant node) {
                return this.postProcess(new EscapeExpression(this.schema, node));
            }

            @Override
            public Expression visitNativeExpression(NativeExpression node) {
                return this.postProcess(new EscapeExpression(this.schema, node));
            }

            @Override
            public Expression visitConcatenation(Concatenation node) {
                return this.postProcess(Concatenation.create(node.getSourcePosition(), this.schema, Util.map(node.getValues(), this)));
            }

            @Override
            public Expression visitOutputElement(OutputElement element) {
                Schema innerSchema = element.getInnerSchema();
                Visitor contentVisitor = innerSchema == null ? this : Worker.this.visitor(innerSchema);
                return this.postProcess(element.withAttributesAndContent(Util.map(element.getAttributes(), this.getAttributeFunction()), element.getContent().acceptVisitor(contentVisitor)));
            }

            @Override
            public Attribute visitAttribute(Attribute attr) {
                this.attrStack.push(attr);
                Schema schema = attr.getInnerSchema();
                if (schema != null) {
                    Visitor visitor = Worker.this.visitor(schema);
                    attr = attr.withValue(attr.getValue().acceptVisitor(visitor));
                }
                Attribute result = super.visitAttribute(attr);
                this.attrStack.pop();
                return result;
            }

            @Override
            public Expression visitConditional(Conditional conditional) {
                ArrayList<Conditional.Clause> clauses = Lists.newArrayList();
                for (Conditional.Clause clause : conditional.getClauses()) {
                    clauses.add(this.visitClause(clause));
                }
                Expression elseExpression = this.apply(conditional.getElseExpression());
                return this.postProcess(conditional.withSchemaAndClauses(this.schema, clauses, elseExpression));
            }

            @Override
            public Expression visitUnextractedMessage(UnextractedMessage msg) {
                UnextractedMessage result;
                Schema msgSchema = msg.getSchema();
                if (msgSchema == null) {
                    msgSchema = this.schema.getMsgSchema();
                }
                if (!(result = msg.withContentAndSchema(msg.getContent().acceptVisitor(Worker.this.visitor(msgSchema)), msgSchema)).getSchema().isTranslatable()) {
                    Worker.this.alertSink.add(new UntranslatableMsgError(result));
                }
                return this.postProcess(result.getSchema().equals((Object)this.schema) ? result : new EscapeExpression(this.schema, result));
            }

            @Override
            public Expression visitCall(Call call) {
                return this.postProcess(call.acceptCallVisitor(this));
            }

            @Override
            public Expression visitBoundCall(BoundCall call) {
                Callable callee = call.getCallee();
                ImmutableMap.Builder<String, Attribute> newParams = ImmutableMap.builder();
                for (Map.Entry<String, Attribute> p : call.getAttributes().entrySet()) {
                    String key = p.getKey();
                    Visitor visitor = callee.getParameterByPrimary(key).getType().acceptTypeVisitor(this.typeVisitor);
                    Attribute value = visitor.visitAttribute(p.getValue());
                    newParams.put(key, value);
                }
                Expression result = call.withParams(newParams.build());
                if (!this.attrStack.isEmpty() && !result.getSchema().equals((Object)this.schema) && result.getSchema().equals((Object)this.attrStack.peek().getInnerSchema())) {
                    result = new EscapeExpression(this.schema, result);
                }
                return result;
            }

            @Override
            public Expression visitUnboundCall(UnboundCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public Expression visitValidatedCall(ValidatedCall call) {
                throw new UnexpectedNodeException(call);
            }

            @Override
            public Expression visitPlaceholderStart(PlaceholderStart ph) {
                return this.postProcess(ph.withSchema(this.schema));
            }

            @Override
            public Expression visitPlaceholderEnd(PlaceholderEnd eph) {
                return this.postProcess(eph.withSchema(this.schema));
            }

            @Override
            public Expression visitEscapeExpression(EscapeExpression node) {
                return this.postProcess(new EscapeExpression(this.schema, node));
            }

            @Override
            public Expression visitCollapseExpression(CollapseExpression node) {
                throw new UnexpectedNodeException(node);
            }

            @Override
            public Expression visitExtractedMessage(ExtractedMessage node) {
                throw new UnexpectedNodeException(node);
            }

            @Override
            public Expression visitPlaceholderNode(PlaceholderNode node) {
                throw new UnexpectedNodeException(node);
            }
        }
    }
}

