/*
 * Decompiled with CFR 0.152.
 */
package com.google.transconsole.common.messages;

import com.google.gxp.com.google.common.base.CharEscapers;
import com.google.gxp.com.google.common.base.Objects;
import com.google.transconsole.common.messages.BundleFormat;
import com.google.transconsole.common.messages.MessageFragment;
import java.util.List;
import java.util.regex.Pattern;

public final class TextFragment
implements MessageFragment {
    private static final Pattern ESCAPE_PERCENT = Pattern.compile("%");
    private final String presentation;

    public TextFragment(String presentation) {
        this.presentation = presentation;
    }

    @Override
    public String getOriginal() {
        return ESCAPE_PERCENT.matcher(this.presentation).replaceAll("%%");
    }

    @Override
    public String getPresentation() {
        return this.presentation;
    }

    @Override
    public String toXml(BundleFormat format) {
        return CharEscapers.xmlContentEscaper().escape(this.getPresentation());
    }

    @Override
    public boolean conflictsWith(MessageFragment f) {
        return false;
    }

    @Override
    public void partialNormalize(StringBuilder sb, List<? super MessageFragment> output) {
        sb.append(this.presentation);
    }

    public boolean equals(Object that) {
        return this == that || that instanceof TextFragment && this.equals((TextFragment)that);
    }

    public boolean equals(TextFragment that) {
        return Objects.equal(this.getPresentation(), that.getPresentation());
    }

    public int hashCode() {
        return Objects.hashCode(this.getPresentation());
    }
}

