/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.config.gigaspaces;

import org.springframework.util.StringUtils;
import org.springmodules.cache.CachingModel;
import org.springmodules.cache.FlushingModel;
import org.springmodules.cache.config.AbstractCacheModelParser;
import org.springmodules.cache.provider.gigaspaces.GigaSpacesCachingModel;
import org.springmodules.cache.provider.gigaspaces.GigaSpacesFlushingModel;
import org.w3c.dom.Element;

public final class GigaSpacesModelParser
extends AbstractCacheModelParser {
    public CachingModel parseCachingModel(Element element) {
        String cacheName = element.getAttribute("cacheName");
        GigaSpacesCachingModel model = new GigaSpacesCachingModel(cacheName);
        String timeToLiveAttr = element.getAttribute("timeToLive");
        String waitForResponseAttr = element.getAttribute("waitForResponse");
        if (StringUtils.hasText((String)timeToLiveAttr)) {
            try {
                long timeToLive = Long.parseLong(timeToLiveAttr);
                model.setTimeToLive(timeToLive);
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        if (StringUtils.hasText((String)waitForResponseAttr)) {
            try {
                long waitForResponse = Long.parseLong(waitForResponseAttr);
                model.setWaitForResponse(waitForResponse);
            }
            catch (NumberFormatException exception) {
                // empty catch block
            }
        }
        return model;
    }

    protected FlushingModel doParseFlushingModel(Element element, boolean flushBeforeMethodExecution) {
        String csvCacheNames = element.getAttribute("cacheNames");
        GigaSpacesFlushingModel model = new GigaSpacesFlushingModel(csvCacheNames);
        model.setFlushBeforeMethodExecution(flushBeforeMethodExecution);
        return model;
    }
}

