/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv.bean.validators;

import java.util.ResourceBundle;
import liquibase.repackaged.com.opencsv.bean.BeanField;
import liquibase.repackaged.com.opencsv.bean.validators.StringValidator;
import liquibase.repackaged.com.opencsv.exceptions.CsvValidationException;

public class MustMatchRegexExpression
implements StringValidator {
    private String regex = "";

    @Override
    public boolean isValid(String value) {
        if (this.regex.isEmpty()) {
            return true;
        }
        return value.matches(this.regex);
    }

    @Override
    public void validate(String value, BeanField field) throws CsvValidationException {
        if (!this.isValid(value)) {
            throw new CsvValidationException(String.format(ResourceBundle.getBundle("mustMatchRegex", field.getErrorLocale()).getString("validator.regex.mismatch"), field.getField().getName(), value, this.regex));
        }
    }

    @Override
    public void setParameterString(String value) {
        if (value != null && !value.isEmpty()) {
            this.regex = value;
        }
    }
}

