/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.login;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.flow.actions.BaseCasWebflowAction;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class TicketGrantingTicketCheckAction
extends BaseCasWebflowAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(TicketGrantingTicketCheckAction.class);
    private final TicketRegistry ticketRegistry;

    public Event doExecute(RequestContext requestContext) {
        String tgtId = WebUtils.getTicketGrantingTicketId((RequestContext)requestContext);
        if (StringUtils.isBlank((CharSequence)tgtId)) {
            return new Event((Object)this, "notExists");
        }
        try {
            Ticket ticket = this.ticketRegistry.getTicket(tgtId, Ticket.class);
            LOGGER.trace("Located ticket with id [{}]", (Object)ticket.getId());
            return new Event((Object)this, "valid");
        }
        catch (Exception e) {
            LOGGER.trace("Could not retrieve ticket id [{}] from registry.", (Object)e.getMessage());
            return new Event((Object)this, "invalid");
        }
    }

    @Generated
    public TicketGrantingTicketCheckAction(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }
}

