/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Calendar;
import java.util.concurrent.CountDownLatch;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.api.ConnectorInfoManagerFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.ConnectorInfoManagerFactoryImpl;
import org.identityconnectors.framework.server.ConnectorServer;
import org.identityconnectors.framework.server.impl.ConnectionListener;

public class ConnectorServerImpl
extends ConnectorServer {
    private ConnectionListener listener;
    private CountDownLatch stopLatch;
    private Long startDate = null;
    private static final Log LOG = Log.getLog(ConnectorServerImpl.class);

    @Override
    public Long getStartTime() {
        return this.startDate;
    }

    @Override
    public boolean isStarted() {
        return this.listener != null;
    }

    @Override
    public void start() {
        LOG.info("Starting Connector Server.", new Object[0]);
        if (this.isStarted()) {
            throw new IllegalStateException("Server is already running.");
        }
        if (this.getPort() == 0) {
            throw new IllegalStateException("Port must be set prior to starting server.");
        }
        if (this.getKeyHash() == null) {
            throw new IllegalStateException("Key hash must be set prior to starting server.");
        }
        ConnectorInfoManagerFactoryImpl factory = (ConnectorInfoManagerFactoryImpl)ConnectorInfoManagerFactory.getInstance();
        factory.getLocalManager(this.getBundleURLs(), this.getBundleParentClassLoader());
        ServerSocket socket = this.createServerSocket();
        ConnectionListener listener = new ConnectionListener(this, socket);
        listener.start();
        this.stopLatch = new CountDownLatch(1);
        this.startDate = System.currentTimeMillis();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.startDate);
        LOG.info("Connector Server started at {0}", new Object[]{calendar.getTime()});
        this.listener = listener;
    }

    private ServerSocket createServerSocket() {
        try {
            ServerSocket rv;
            ServerSocketFactory factory;
            if (this.getUseSSL()) {
                LOG.ok("Creating SSL server socket.", new Object[0]);
                factory = this.createSSLServerSocketFactory();
            } else {
                LOG.ok("Creating default (no SSL) server socket.", new Object[0]);
                factory = ServerSocketFactory.getDefault();
            }
            int port = this.getPort();
            int maxConnections = this.getMaxConnections();
            InetAddress ifAddress = this.getIfAddress();
            if (ifAddress == null) {
                LOG.ok("Creating server socket with the following parameters, port = {0}, max connections {1}", new Object[]{String.valueOf(port), String.valueOf(maxConnections)});
                rv = factory.createServerSocket(port, maxConnections);
            } else {
                LOG.ok("Creating server socket with the following parameters, port = {0}, network interface address = {1}, max connections {2}", new Object[]{String.valueOf(port), String.valueOf(maxConnections), ifAddress});
                rv = factory.createServerSocket(port, maxConnections, ifAddress);
            }
            return rv;
        }
        catch (Exception e) {
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    private ServerSocketFactory createSSLServerSocketFactory() throws Exception {
        KeyManager[] keyManagers = null;
        if (this.getKeyManagers().size() > 0) {
            keyManagers = this.getKeyManagers().toArray(new KeyManager[this.getKeyManagers().size()]);
        }
        if (keyManagers == null) {
            LOG.info("No SSL keystore specified, using defaults.", new Object[0]);
            return SSLServerSocketFactory.getDefault();
        }
        LOG.info("Using SSL keystore which was specified.", new Object[0]);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(keyManagers, null, null);
        return context.getServerSocketFactory();
    }

    @Override
    public void stop() {
        LOG.info("About to initialize Connector server stop sequence.", new Object[0]);
        if (this.listener != null) {
            try {
                this.listener.shutdown();
            }
            finally {
                this.stopLatch.countDown();
            }
            this.stopLatch = null;
            this.startDate = null;
            this.listener = null;
        }
        ConnectorFacadeFactory.getManagedInstance().dispose();
    }

    @Override
    public void awaitStop() throws InterruptedException {
        this.stopLatch.await();
    }
}

