/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.bpmn.parser.handler;

import java.util.List;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EventListener;
import org.flowable.bpmn.model.Process;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEventType;
import org.flowable.common.engine.impl.event.FlowableEventSupport;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessParseHandler
extends AbstractBpmnParseHandler<Process> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessParseHandler.class);
    public static final String PROPERTYNAME_DOCUMENTATION = "documentation";

    @Override
    public Class<? extends BaseElement> getHandledType() {
        return Process.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, Process process) {
        if (!process.isExecutable()) {
            LOGGER.info("Ignoring non-executable process with id='{}'. Set the attribute isExecutable=\"true\" to deploy this process.", (Object)process.getId());
        } else {
            bpmnParse.getProcessDefinitions().add(this.transformProcess(bpmnParse, process));
        }
    }

    protected ProcessDefinitionEntity transformProcess(BpmnParse bpmnParse, Process process) {
        ProcessDefinitionEntity currentProcessDefinition = (ProcessDefinitionEntity)CommandContextUtil.getProcessDefinitionEntityManager().create();
        bpmnParse.setCurrentProcessDefinition(currentProcessDefinition);
        currentProcessDefinition.setKey(process.getId());
        currentProcessDefinition.setName(process.getName());
        currentProcessDefinition.setCategory(bpmnParse.getBpmnModel().getTargetNamespace());
        currentProcessDefinition.setDescription(process.getDocumentation());
        currentProcessDefinition.setDeploymentId(bpmnParse.getDeployment().getId());
        if (bpmnParse.getDeployment().getEngineVersion() != null) {
            currentProcessDefinition.setEngineVersion(bpmnParse.getDeployment().getEngineVersion());
        }
        this.createEventListeners(bpmnParse, process.getEventListeners());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Parsing process {}", (Object)currentProcessDefinition.getKey());
        }
        bpmnParse.processFlowElements(process.getFlowElements());
        this.processArtifacts(bpmnParse, process.getArtifacts());
        return currentProcessDefinition;
    }

    protected void createEventListeners(BpmnParse bpmnParse, List<EventListener> eventListeners) {
        if (eventListeners != null && !eventListeners.isEmpty()) {
            for (EventListener eventListener : eventListeners) {
                FlowableEngineEventType[] types = FlowableEngineEventType.getTypesFromString((String)eventListener.getEvents());
                if ("class".equals(eventListener.getImplementationType())) {
                    this.getEventSupport(bpmnParse.getBpmnModel()).addEventListener(bpmnParse.getListenerFactory().createClassDelegateEventListener(eventListener), (FlowableEventType[])types);
                    continue;
                }
                if ("delegateExpression".equals(eventListener.getImplementationType())) {
                    this.getEventSupport(bpmnParse.getBpmnModel()).addEventListener(bpmnParse.getListenerFactory().createDelegateExpressionEventListener(eventListener), (FlowableEventType[])types);
                    continue;
                }
                if ("throwSignalEvent".equals(eventListener.getImplementationType()) || "throwGlobalSignalEvent".equals(eventListener.getImplementationType()) || "throwMessageEvent".equals(eventListener.getImplementationType()) || "throwErrorEvent".equals(eventListener.getImplementationType())) {
                    this.getEventSupport(bpmnParse.getBpmnModel()).addEventListener(bpmnParse.getListenerFactory().createEventThrowingEventListener(eventListener), (FlowableEventType[])types);
                    continue;
                }
                LOGGER.warn("Unsupported implementation type for EventListener: {} for element {}", (Object)eventListener.getImplementationType(), (Object)bpmnParse.getCurrentFlowElement().getId());
            }
        }
    }

    protected FlowableEventSupport getEventSupport(BpmnModel bpmnModel) {
        return (FlowableEventSupport)bpmnModel.getEventSupport();
    }
}

