/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.logging;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.common.engine.impl.logging.LoggingListener;
import org.flowable.common.engine.impl.logging.LoggingSession;
import org.flowable.common.engine.impl.logging.LoggingSessionUtil;

public class LoggingSessionCommandContextCloseListener
implements CommandContextCloseListener {
    protected LoggingSession loggingSession;
    protected LoggingListener loggingListener;
    protected ObjectMapper objectMapper;
    protected String engineType;

    public LoggingSessionCommandContextCloseListener() {
    }

    public LoggingSessionCommandContextCloseListener(LoggingSession loggingSession, LoggingListener loggingListener, ObjectMapper objectMapper) {
        this.loggingSession = loggingSession;
        this.loggingListener = loggingListener;
        this.objectMapper = objectMapper;
    }

    @Override
    public void closing(CommandContext commandContext) {
    }

    @Override
    public void closed(CommandContext commandContext) {
        LoggingSessionUtil.addEngineLoggingData("commandContextClose", "Closed command context for " + this.engineType + " engine", this.engineType, this.objectMapper);
        List<ObjectNode> loggingData = this.loggingSession.getLoggingData();
        this.loggingListener.loggingGenerated(loggingData);
    }

    @Override
    public void closeFailure(CommandContext commandContext) {
        LoggingSessionUtil.addEngineLoggingData("commandContextCloseFailure", "Exception at closing command context for " + this.engineType + " engine", this.engineType, this.objectMapper);
        List<ObjectNode> loggingData = this.loggingSession.getLoggingData();
        this.loggingListener.loggingGenerated(loggingData);
    }

    @Override
    public void afterSessionsFlush(CommandContext commandContext) {
    }

    @Override
    public Integer order() {
        return 500;
    }

    @Override
    public boolean multipleAllowed() {
        return false;
    }

    public LoggingSession getLoggingSession() {
        return this.loggingSession;
    }

    public void setLoggingSession(LoggingSession loggingSession) {
        this.loggingSession = loggingSession;
    }

    public LoggingListener getLoggingListener() {
        return this.loggingListener;
    }

    public void setLoggingListener(LoggingListener loggingListener) {
        this.loggingListener = loggingListener;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }
}

