/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.smtp.commands;

import com.icegreen.greenmail.mail.MailAddress;
import com.icegreen.greenmail.smtp.SmtpConnection;
import com.icegreen.greenmail.smtp.SmtpManager;
import com.icegreen.greenmail.smtp.SmtpState;
import com.icegreen.greenmail.smtp.commands.SmtpCommand;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RcptCommand
extends SmtpCommand {
    static Pattern param = Pattern.compile("RCPT TO:\\s?<([^>]+)>", 2);

    @Override
    public void execute(SmtpConnection conn, SmtpState state, SmtpManager manager, String commandLine) {
        Matcher m = param.matcher(commandLine);
        if (m.matches()) {
            if (state.getMessage().getReturnPath() != null) {
                String to = m.group(1);
                MailAddress toAddr = new MailAddress(to);
                String err = manager.checkRecipient(state, toAddr);
                if (err != null) {
                    conn.send(err);
                    return;
                }
                state.getMessage().addRecipient(toAddr);
                conn.send("250 OK");
            } else {
                conn.send("503 MAIL must come before RCPT");
            }
        } else {
            conn.send("501 Required syntax: 'RCPT TO:<email@host>'");
        }
    }
}

