/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.syncope.common.lib.wa.GoogleMfaAuthToken;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class GoogleMfaAuthTokenLogic
extends AbstractAuthProfileLogic {
    protected final EntityFactory entityFactory;

    public GoogleMfaAuthTokenLogic(EntityFactory entityFactory, AuthProfileDAO authProfileDAO, AuthProfileDataBinder binder) {
        super(authProfileDAO, binder);
        this.entityFactory = entityFactory;
    }

    protected void removeTokenAndSave(AuthProfile profile, Predicate<GoogleMfaAuthToken> criteria) {
        List tokens = profile.getGoogleMfaAuthTokens();
        if (tokens.removeIf(criteria)) {
            profile.setGoogleMfaAuthTokens(tokens);
            this.authProfileDAO.save(profile);
        }
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(LocalDateTime expirationDate) {
        this.authProfileDAO.findAll(-1, -1).forEach(profile -> this.removeTokenAndSave((AuthProfile)profile, token -> token.getIssueDate().compareTo(expirationDate) >= 0));
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(String owner, int otp) {
        this.authProfileDAO.findByOwner(owner).ifPresent(profile -> this.removeTokenAndSave((AuthProfile)profile, token -> token.getOtp() == otp));
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(String owner) {
        this.authProfileDAO.findByOwner(owner).ifPresent(profile -> {
            profile.setGoogleMfaAuthTokens(List.of());
            this.authProfileDAO.save(profile);
        });
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(int otp) {
        this.authProfileDAO.findAll(-1, -1).forEach(profile -> this.removeTokenAndSave((AuthProfile)profile, token -> token.getOtp() == otp));
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void deleteAll() {
        this.authProfileDAO.findAll(-1, -1).forEach(profile -> {
            profile.setGoogleMfaAuthTokens(List.of());
            this.authProfileDAO.save(profile);
        });
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void store(String owner, GoogleMfaAuthToken token) {
        AuthProfile profile = this.authProfileDAO.findByOwner(owner).orElseGet(() -> {
            AuthProfile authProfile = (AuthProfile)this.entityFactory.newEntity(AuthProfile.class);
            authProfile.setOwner(owner);
            return authProfile;
        });
        List tokens = profile.getGoogleMfaAuthTokens();
        tokens.removeIf(t -> t.getOtp() == token.getOtp());
        tokens.add(token);
        profile.setGoogleMfaAuthTokens(tokens);
        this.authProfileDAO.save(profile);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public GoogleMfaAuthToken read(String owner, int otp) {
        return this.authProfileDAO.findByOwner(owner).stream().map(AuthProfile::getGoogleMfaAuthTokens).flatMap(Collection::stream).filter(token -> token.getOtp() == otp).findFirst().orElseThrow(() -> new NotFoundException("Could not find token for owner " + owner + " and otp " + otp));
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<GoogleMfaAuthToken> list() {
        return this.authProfileDAO.findAll(-1, -1).stream().map(AuthProfile::getGoogleMfaAuthTokens).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<GoogleMfaAuthToken> read(String owner) {
        return this.authProfileDAO.findByOwner(owner).map(AuthProfile::getGoogleMfaAuthTokens).orElse(List.of());
    }
}

