/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spring;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.ext.Provider;
import java.util.Collection;
import java.util.Map;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.spring.AbstractJaxRsClientConfiguration;
import org.apache.cxf.jaxrs.client.spring.JAXRSClientFactoryBeanDefinitionParser;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;

public class JaxRsProxyClientConfiguration
extends AbstractJaxRsClientConfiguration {
    @Value(value="${cxf.jaxrs.client.classes-scan-packages:}")
    private String scanPackages;

    @Bean
    protected Client jaxRsProxyClient() {
        return super.createClient();
    }

    protected Class<?> getServiceClass() {
        return null;
    }

    @Override
    protected void setJaxrsResources(JAXRSClientFactoryBean factory) {
        Class<?> serviceClass = this.getServiceClass();
        if (serviceClass != null) {
            factory.setServiceClass(serviceClass);
        } else if (!StringUtils.isEmpty((String)this.scanPackages)) {
            try {
                Map classes = ClasspathScanner.findClasses((String)this.scanPackages, (Class[])new Class[]{Path.class, Provider.class});
                factory.setServiceClass(JAXRSClientFactoryBeanDefinitionParser.getServiceClass((Collection)classes.get(Path.class)));
                factory.setProviders(JAXRSClientFactoryBeanDefinitionParser.getProviders(this.context, (Collection)classes.get(Provider.class)));
            }
            catch (Exception ex) {
                throw new ServiceConstructionException((Throwable)ex);
            }
        }
    }
}

