/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.config;

import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.Initializer;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessor;
import org.opensaml.xmlsec.agreement.KeyAgreementProcessorRegistry;
import org.slf4j.Logger;

public class GlobalKeyAgreementProcessorRegistryInitializer
implements Initializer {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(GlobalKeyAgreementProcessorRegistryInitializer.class);

    public void init() throws InitializationException {
        KeyAgreementProcessorRegistry registry = new KeyAgreementProcessorRegistry();
        ServiceLoader<KeyAgreementProcessor> descriptorsLoader = ServiceLoader.load(KeyAgreementProcessor.class);
        for (KeyAgreementProcessor processor : descriptorsLoader) {
            this.log.debug("Registering KeyAgreementProcessor for algorithm '{}': {}", (Object)processor.getAlgorithm(), (Object)processor.getClass().getName());
            registry.register(processor);
        }
        ConfigurationService.register(KeyAgreementProcessorRegistry.class, (Object)registry);
    }
}

