/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.encoding.impl;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.codec.HTMLEncoder;
import net.shibboleth.shared.codec.StringDigester;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.URLBuilder;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.encoder.HTMLMessageEncoder;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.SAMLArtifactContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLSelfEntityContext;
import org.opensaml.saml.config.SAMLConfigurationSupport;
import org.opensaml.saml.saml2.binding.artifact.SAML2Artifact;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactBuilder;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml.saml2.binding.encoding.impl.BaseSAML2MessageEncoder;
import org.slf4j.Logger;

public class HTTPArtifactEncoder
extends BaseSAML2MessageEncoder
implements HTMLMessageEncoder {
    @Nonnull
    @NotEmpty
    public static final String DEFAULT_TEMPLATE_ID = "/templates/saml2-post-artifact-binding.vm";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPArtifactEncoder.class);
    private boolean postEncoding;
    @Nullable
    private VelocityEngine velocityEngine;
    @Nonnull
    @NotEmpty
    private String velocityTemplateId = "/templates/saml2-post-artifact-binding.vm";
    @Nullable
    private StringDigester cspDigester;
    @Nullable
    private IdentifierGenerationStrategy cspNonceGenerator;
    @NonnullAfterInit
    private SAMLArtifactMap artifactMap;
    @Nonnull
    @NotEmpty
    private byte[] defaultArtifactType = SAML2ArtifactType0004.TYPE_CODE;

    @Nonnull
    @NotEmpty
    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    public boolean isPostEncoding() {
        return this.postEncoding;
    }

    public void setPostEncoding(boolean post) {
        this.checkSetterPreconditions();
        this.postEncoding = post;
    }

    @Nullable
    public VelocityEngine getVelocityEngine() {
        return this.velocityEngine;
    }

    public void setVelocityEngine(@Nullable VelocityEngine newVelocityEngine) {
        this.checkSetterPreconditions();
        this.velocityEngine = newVelocityEngine;
    }

    @Nonnull
    @NotEmpty
    public String getVelocityTemplateId() {
        return this.velocityTemplateId;
    }

    public void setVelocityTemplateId(@Nonnull @NotEmpty String newVelocityTemplateId) {
        this.checkSetterPreconditions();
        this.velocityTemplateId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)newVelocityTemplateId), (String)"Velocity template ID cannot be null or empty");
    }

    public void setCSPDigester(@Nullable StringDigester digester) {
        this.checkSetterPreconditions();
        this.cspDigester = digester;
    }

    public void setCSPNonceGenerator(@Nullable IdentifierGenerationStrategy strategy) {
        this.checkSetterPreconditions();
        this.cspNonceGenerator = strategy;
    }

    @NonnullAfterInit
    public SAMLArtifactMap getArtifactMap() {
        return this.artifactMap;
    }

    public void setArtifactMap(@Nonnull SAMLArtifactMap newArtifactMap) {
        this.checkSetterPreconditions();
        this.artifactMap = (SAMLArtifactMap)Constraint.isNotNull((Object)newArtifactMap, (String)"SAMLArtifactMap cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.artifactMap == null) {
            throw new ComponentInitializationException("SAMLArtifactMap cannot be null");
        }
        if (this.isPostEncoding() && this.velocityEngine == null) {
            throw new ComponentInitializationException("VelocityEngine cannot be null when POST is used");
        }
    }

    protected void doEncode() throws MessageEncodingException {
        this.getHttpServletResponse().setCharacterEncoding("UTF-8");
        if (this.postEncoding) {
            this.postEncode();
        } else {
            this.getEncode();
        }
    }

    protected void postEncode() throws MessageEncodingException {
        String relayState;
        this.log.debug("Performing HTTP POST SAML 2 artifact encoding");
        MessageContext messageContext = this.getMessageContext();
        assert (messageContext != null);
        this.log.debug("Creating velocity context");
        VelocityContext context = new VelocityContext();
        String endpointURL = this.getEndpointURL(messageContext).toString();
        String encodedEndpointURL = HTMLEncoder.encodeForHTMLAttribute((String)endpointURL);
        this.log.debug("Setting action parameter to: '{}', encoded as '{}'", (Object)endpointURL, (Object)encodedEndpointURL);
        context.put("action", (Object)encodedEndpointURL);
        try {
            context.put("SAMLArt", (Object)Base64Support.encode((byte[])this.buildArtifact(messageContext).getArtifactBytes(), (boolean)false));
        }
        catch (EncodingException e) {
            this.log.warn("Unable to base64 encode SAML 2 artifact when creating POST form: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to base64 encode SAML 2 artifact when creating POST form", (Exception)((Object)e));
        }
        context.put("binding", (Object)this.getBindingURI());
        if (this.cspDigester != null) {
            this.log.trace("Adding CSP digester to context");
            context.put("cspDigester", (Object)this.cspDigester);
        }
        if (this.cspNonceGenerator != null) {
            this.log.trace("Adding CSP nonce generator to context");
            context.put("cspNonce", (Object)this.cspNonceGenerator);
        }
        if (SAMLBindingSupport.checkRelayState((String)(relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext)))) {
            String encodedRelayState = HTMLEncoder.encodeForHTMLAttribute((String)relayState);
            this.log.debug("Setting RelayState parameter to: '{}', encoded as '{}'", (Object)relayState, (Object)encodedRelayState);
            context.put("RelayState", (Object)encodedRelayState);
        }
        HttpServletResponse response = this.getHttpServletResponse();
        context.put("response", (Object)response);
        try {
            this.log.debug("Invoking velocity template");
            try (OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)response.getOutputStream());){
                assert (this.velocityEngine != null);
                this.velocityEngine.mergeTemplate(this.velocityTemplateId, "UTF-8", (Context)context, (Writer)outWriter);
                outWriter.flush();
            }
        }
        catch (Exception e) {
            this.log.error("Error invoking velocity template to create POST form: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Error creating output document", e);
        }
    }

    protected void getEncode() throws MessageEncodingException {
        URLBuilder urlBuilder;
        this.log.debug("Performing HTTP GET SAML 2 artifact encoding");
        MessageContext messageContext = this.getMessageContext();
        assert (messageContext != null);
        String endpointUrl = this.getEndpointURL(messageContext).toString();
        assert (endpointUrl != null);
        try {
            urlBuilder = new URLBuilder(endpointUrl);
        }
        catch (MalformedURLException e) {
            throw new MessageEncodingException("Endpoint URL " + endpointUrl + " is not a valid URL", (Exception)e);
        }
        List queryParams = urlBuilder.getQueryParams();
        queryParams.clear();
        SAML2Artifact artifact = this.buildArtifact(messageContext);
        try {
            queryParams.add(new Pair((Object)"SAMLart", (Object)Base64Support.encode((byte[])artifact.getArtifactBytes(), (boolean)false)));
        }
        catch (EncodingException e) {
            this.log.error("Unable to base64 encode artifact for message to relying party: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to base64 encode artifact for message to relying party", (Exception)((Object)e));
        }
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        if (SAMLBindingSupport.checkRelayState((String)relayState)) {
            queryParams.add(new Pair((Object)"RelayState", (Object)relayState));
        }
        HttpServletResponse response = this.getHttpServletResponse();
        try {
            response.sendRedirect(urlBuilder.buildURL());
        }
        catch (IOException e) {
            throw new MessageEncodingException("Problem sending HTTP redirect", (Exception)e);
        }
    }

    @Nonnull
    protected SAML2Artifact buildArtifact(@Nonnull MessageContext messageContext) throws MessageEncodingException {
        SAML2ArtifactBuilder artifactBuilder;
        Object outboundMessage = messageContext.getMessage();
        if (!(outboundMessage instanceof SAMLObject)) {
            throw new MessageEncodingException("Outbound message was not a SAMLObject");
        }
        SAMLObject samlObject = (SAMLObject)outboundMessage;
        String requester = this.getInboundMessageIssuer(messageContext);
        String issuer = this.getOutboundMessageIssuer(messageContext);
        if (requester == null || issuer == null) {
            throw new MessageEncodingException("Unable to obtain issuer or relying party for message encoding");
        }
        byte[] artifactType = this.getSAMLArtifactType(messageContext);
        if (artifactType != null) {
            factory = SAMLConfigurationSupport.getSAML2ArtifactBuilderFactory();
            artifactBuilder = factory != null ? factory.getArtifactBuilder(artifactType) : null;
        } else {
            factory = SAMLConfigurationSupport.getSAML2ArtifactBuilderFactory();
            artifactBuilder = factory != null ? factory.getArtifactBuilder(this.defaultArtifactType) : null;
            this.storeSAMLArtifactType(messageContext, this.defaultArtifactType);
        }
        if (artifactBuilder == null) {
            throw new MessageEncodingException("Unable to obtain SAML2ArtifactBuilder");
        }
        SAML2Artifact artifact = artifactBuilder.buildArtifact(messageContext);
        if (artifact == null) {
            this.log.error("Unable to build artifact for message to relying party");
            throw new MessageEncodingException("Unable to build artifact for message to relying party");
        }
        try {
            String encodedArtifact = Base64Support.encode((byte[])artifact.getArtifactBytes(), (boolean)false);
            this.artifactMap.put(encodedArtifact, requester, issuer, samlObject);
        }
        catch (IOException e) {
            this.log.error("Unable to store message mapping for artifact: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to store message mapping for artifact", (Exception)e);
        }
        catch (EncodingException e) {
            this.log.error("Unable to base64 encode artifact: {}", (Object)e.getMessage());
            throw new MessageEncodingException("Unable to base64 encode artifact", (Exception)((Object)e));
        }
        return artifact;
    }

    @Nullable
    private String getOutboundMessageIssuer(@Nonnull MessageContext messageContext) {
        SAMLSelfEntityContext selfCtx = (SAMLSelfEntityContext)messageContext.getSubcontext(SAMLSelfEntityContext.class);
        if (selfCtx == null) {
            return null;
        }
        return selfCtx.getEntityId();
    }

    @Nullable
    private String getInboundMessageIssuer(@Nonnull MessageContext messageContext) {
        SAMLPeerEntityContext peerCtx = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class);
        if (peerCtx == null) {
            return null;
        }
        return peerCtx.getEntityId();
    }

    private void storeSAMLArtifactType(@Nonnull MessageContext messageContext, @Nonnull @NotEmpty byte[] artifactType) {
        ((SAMLArtifactContext)messageContext.ensureSubcontext(SAMLArtifactContext.class)).setArtifactType(artifactType);
    }

    @Nullable
    private byte[] getSAMLArtifactType(@Nonnull MessageContext messageContext) {
        return ((SAMLArtifactContext)messageContext.ensureSubcontext(SAMLArtifactContext.class)).getArtifactType();
    }
}

