/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.transaction;

import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Lock;
import jakarta.ejb.LockType;
import jakarta.ejb.Stateless;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.inject.Inject;
import jakarta.transaction.TransactionManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.junit.ApplicationComposer;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.testing.Classes;
import org.apache.openejb.testing.Module;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=ApplicationComposer.class)
public class TxPropagationTest {
    private static final Logger logger = Logger.getLogger(TxPropagationTest.class.getName());
    private static final Set<String> TX_IDS = Collections.synchronizedSet(new HashSet());
    private static final CountDownLatch LATCH = new CountDownLatch(10);
    private static final AtomicInteger ERRORS = new AtomicInteger(0);
    @EJB
    private WorkBean workBean;

    @Test
    public void test() throws Exception {
        this.workBean.runAsyncTasksAndWait();
        Assert.assertTrue((boolean)LATCH.await(2L, TimeUnit.SECONDS));
        Assert.assertEquals((long)10L, (long)TX_IDS.size());
        Assert.assertEquals((long)0L, (long)ERRORS.get());
    }

    @Module
    @Classes(cdi=true, value={WorkBean.class, TaskWorker.class, WorkScheduler.class})
    public EjbJar jar() {
        return new EjbJar("tx-prop-test");
    }

    @Stateless
    public static class WorkBean {
        @Resource
        private ManagedExecutorService executorService;
        @Inject
        private WorkScheduler scheduler;

        public void runAsyncTasksAndWait() throws Exception {
            Thread.sleep(500L);
            for (int i = 1; i <= 10; ++i) {
                List list = this.executorService.invokeAll(Set.of(() -> {
                    try {
                        this.scheduler.doWork();
                    }
                    catch (Exception e) {
                        ERRORS.incrementAndGet();
                    }
                    return "OK";
                }));
            }
        }
    }

    @Stateless
    @Lock(value=LockType.READ)
    public static class TaskWorker {
        public void runTask() {
            try {
                TransactionImpl txImpl = (TransactionImpl)SystemInstance.get().getComponent(TransactionManager.class).getTransaction();
                String xid = txImpl.getTransactionKey().toString();
                TX_IDS.add(xid);
                Thread.sleep(500L);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            finally {
                LATCH.countDown();
            }
        }
    }

    @Stateless
    public static class WorkScheduler {
        @Resource
        private ManagedExecutorService executorService;
        @EJB
        private TaskWorker worker;

        public void doWork() {
            try {
                this.worker.runTask();
                Future f = this.executorService.submit(() -> {
                    logger.info("Work scheduler is in a separate thread");
                    return "OK";
                });
                try {
                    f.get(1000L, TimeUnit.MILLISECONDS);
                }
                finally {
                    if (!f.isDone()) {
                        f.cancel(true);
                        logger.severe("Cancelling tread.");
                    }
                }
            }
            catch (Throwable t) {
                ERRORS.incrementAndGet();
                throw new RuntimeException(t);
            }
        }
    }
}

