/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import io.micrometer.core.instrument.Tags;
import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import io.smallrye.metrics.legacyapi.TagsUtils;
import io.smallrye.metrics.legacyapi.interceptors.MetricResolver;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Timed;

public class MetricsMetadata {
    private MetricsMetadata() {
    }

    public static List<MetricID> registerMetrics(MetricRegistry registry, MetricResolver resolver, BeanInfo bean, MemberInfo element) {
        MetricResolver.Of<Timed> timed;
        MetricResolver.Of<Counted> counted = resolver.counted(bean, element);
        ArrayList<MetricID> metricIDs = new ArrayList<MetricID>();
        if (counted.isPresent()) {
            AnnotationInfo t = counted.metricAnnotation();
            registry = SharedMetricRegistries.getOrCreate(t.scope());
            Metadata metadata = MetricsMetadata.getMetadata(element, counted.metricName(), t.unit(), t.description());
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.counter(metadata, tags);
            Tag[] mpTagArray = MetricsMetadata.resolveAppNameTag(registry, tags);
            MetricID metricID = new MetricID(metadata.getName(), mpTagArray);
            metricIDs.add(metricID);
            ((LegacyMetricRegistryAdapter)registry).getMemberToMetricMappings().addCounter(element, metricID);
        }
        if ((timed = resolver.timed(bean, element)).isPresent()) {
            AnnotationInfo t = timed.metricAnnotation();
            registry = SharedMetricRegistries.getOrCreate(t.scope());
            Metadata metadata = MetricsMetadata.getMetadata(element, timed.metricName(), t.unit(), t.description());
            Tag[] tags = TagsUtils.parseTagsAsArray(t.tags());
            registry.timer(metadata, tags);
            Tag[] mpTagArray = MetricsMetadata.resolveAppNameTag(registry, tags);
            MetricID metricID = new MetricID(metadata.getName(), mpTagArray);
            metricIDs.add(metricID);
            ((LegacyMetricRegistryAdapter)registry).getMemberToMetricMappings().addTimer(element, metricID);
        }
        return metricIDs;
    }

    public static Metadata getMetadata(Object origin, String name, String unit, String description) {
        Metadata metadata = Metadata.builder().withName(name).withUnit(unit).withDescription(description).build();
        return new OriginAndMetadata(origin, metadata);
    }

    private static Tag[] resolveAppNameTag(MetricRegistry registry, Tag ... tags) {
        Tags mmTags = ((LegacyMetricRegistryAdapter)registry).withAppTags(tags);
        ArrayList mpListTags = new ArrayList();
        mmTags.forEach(tag -> {
            Tag mpTag = new Tag(tag.getKey(), tag.getValue());
            mpListTags.add(mpTag);
        });
        return mpListTags.toArray(new Tag[0]);
    }
}

