/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.bval;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tomee.microprofile.jwt.bval.Generated;

public class MethodMap {
    private final Map<Method, Method> mapping = new HashMap<Method, Method>();

    public static MethodMap of(Class<?> original, Class<?> generated) {
        MethodMap map = new MethodMap();
        Map methods = Stream.of(original.getMethods()).collect(Collectors.toMap(Method::toString, Function.identity()));
        for (Method generatedMethod : generated.getMethods()) {
            Generated name = generatedMethod.getAnnotation(Generated.class);
            if (name == null) continue;
            String toString = name.value();
            Method originalMethod = (Method)methods.get(toString);
            if (originalMethod == null) {
                throw new IllegalStateException(String.format("Cannot find method '%s' on class '%s'", toString, original.getName()));
            }
            map.mapping.put(originalMethod, generatedMethod);
        }
        return map;
    }

    public Method get(Method orinalMethod) {
        return this.mapping.get(orinalMethod);
    }
}

