/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.codec;

import javax.annotation.Nonnull;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import org.apache.commons.codec.CodecPolicy;
import org.apache.commons.codec.binary.Base32;

public final class Base32Support {
    public static final boolean CHUNKED = true;
    public static final boolean UNCHUNKED = false;
    @Nonnull
    private static final Base32 CHUNKED_ENCODER = new Base32(76, new byte[]{10}, false, 61, CodecPolicy.STRICT);
    @Nonnull
    private static final Base32 UNCHUNKED_ENCODER = new Base32(0, new byte[]{10}, false, 61, CodecPolicy.STRICT);

    private Base32Support() {
    }

    @Nonnull
    public static String encode(@Nonnull byte[] data, boolean chunked) throws EncodingException {
        Constraint.isNotNull(data, "Binary data to be encoded can not be null");
        try {
            String encoded = null;
            encoded = chunked ? StringSupport.trim(CHUNKED_ENCODER.encodeToString(data)) : StringSupport.trim(UNCHUNKED_ENCODER.encodeToString(data));
            if (null == encoded) {
                throw new EncodingException("Base32 encoded string was null");
            }
            return encoded;
        }
        catch (Exception e) {
            throw new EncodingException("Unable to base32 encode data: " + e.getMessage(), e);
        }
    }

    @Nonnull
    public static byte[] decode(@Nonnull String data) throws DecodingException {
        Constraint.isNotNull(data, "Base32 encoded data can not be null");
        try {
            byte[] decoded = CHUNKED_ENCODER.decode(data);
            if (null == decoded) {
                throw new DecodingException("Base32 decoded data was null");
            }
            return decoded;
        }
        catch (Exception e) {
            throw new DecodingException("Unable to Base32 decode input data, input invalid", e);
        }
    }
}

