/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.internal.util;

import java.io.IOException;
import java.lang.reflect.Method;

public class BrowserUtil {
    private static int __osId;
    private static String[] __browserLauncher;
    private static final int WINDOWS_NT = 0;
    private static final int WINDOWS_9x = 1;
    private static final int MAC_OS = 2;
    private static final int OTHER = 3;
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";

    public static void main(String[] args) {
        String url = args.length > 0 ? args[0] : "http://apache.org";
        try {
            Process process = BrowserUtil.openUrlInDefaultBrowser(url);
            if (process != null) {
                process.waitFor();
            }
        }
        catch (Exception e) {
            System.err.println("Error in BrowserUtil.main():");
            e.printStackTrace(System.err);
        }
    }

    private BrowserUtil() {
    }

    public static Process openUrlInDefaultBrowser(String url) throws Exception {
        Process process = null;
        switch (__osId) {
            case 0: 
            case 1: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher[0], FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, "\"" + url + "\""});
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException ie) {
                    throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                }
            }
            case 2: {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
                break;
            }
            case 3: {
                boolean browserAvailableBrowser = false;
                int i = 0;
                while (i < __browserLauncher.length && !browserAvailableBrowser) {
                    process = Runtime.getRuntime().exec(new String[]{"which", __browserLauncher[i]});
                    try {
                        int exitCode = process.waitFor();
                        if (exitCode != 0) continue;
                        browserAvailableBrowser = true;
                        process = Runtime.getRuntime().exec(new String[]{__browserLauncher[i], url});
                    }
                    catch (InterruptedException ie) {
                        throw new IOException("InterruptedException while launching browser: " + ie.getMessage());
                    }
                }
                if (browserAvailableBrowser) break;
                process = null;
            }
        }
        return process;
    }

    static {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            if (osName.indexOf("9") > -1) {
                __osId = 1;
                __browserLauncher = new String[]{"command.com"};
            } else {
                __osId = 0;
                __browserLauncher = new String[]{"cmd.exe"};
            }
        } else if (osName.startsWith("Mac OS")) {
            __osId = 2;
            __browserLauncher = null;
        } else {
            __osId = 3;
            __browserLauncher = new String[]{"mozilla", "firefox", "konqueror", "opera", "netscape"};
        }
    }
}

