# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.managedservices.aio import ManagedServicesClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestManagedServicesRegistrationAssignmentsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ManagedServicesClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.registration_assignments.get(
            scope="str",
            registration_assignment_id="str",
            api_version="2022-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.registration_assignments.begin_delete(
                scope="str",
                registration_assignment_id="str",
                api_version="2022-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.registration_assignments.begin_create_or_update(
                scope="str",
                registration_assignment_id="str",
                request_body={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "registrationDefinitionId": "str",
                        "provisioningState": "str",
                        "registrationDefinition": {
                            "id": "str",
                            "name": "str",
                            "plan": {"name": "str", "product": "str", "publisher": "str", "version": "str"},
                            "properties": {
                                "authorizations": [
                                    {
                                        "principalId": "str",
                                        "roleDefinitionId": "str",
                                        "delegatedRoleDefinitionIds": ["str"],
                                        "principalIdDisplayName": "str",
                                    }
                                ],
                                "description": "str",
                                "eligibleAuthorizations": [
                                    {
                                        "principalId": "str",
                                        "roleDefinitionId": "str",
                                        "justInTimeAccessPolicy": {
                                            "multiFactorAuthProvider": "None",
                                            "managedByTenantApprovers": [
                                                {"principalId": "str", "principalIdDisplayName": "str"}
                                            ],
                                            "maximumActivationDuration": "PT8H",
                                        },
                                        "principalIdDisplayName": "str",
                                    }
                                ],
                                "managedByTenantId": "str",
                                "managedByTenantName": "str",
                                "manageeTenantId": "str",
                                "manageeTenantName": "str",
                                "provisioningState": "str",
                                "registrationDefinitionName": "str",
                            },
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        },
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2022-10-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.registration_assignments.list(
            scope="str",
            api_version="2022-10-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
