// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_profile

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetLogProfileOKCode is the HTTP code returned for type GetLogProfileOK
const GetLogProfileOKCode int = 200

/*
GetLogProfileOK Successful operation

swagger:response getLogProfileOK
*/
type GetLogProfileOK struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.LogProfile `json:"body,omitempty"`
}

// NewGetLogProfileOK creates GetLogProfileOK with default headers values
func NewGetLogProfileOK() *GetLogProfileOK {

	return &GetLogProfileOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get log profile o k response
func (o *GetLogProfileOK) WithConfigurationVersion(configurationVersion string) *GetLogProfileOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log profile o k response
func (o *GetLogProfileOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log profile o k response
func (o *GetLogProfileOK) WithPayload(payload *models.LogProfile) *GetLogProfileOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log profile o k response
func (o *GetLogProfileOK) SetPayload(payload *models.LogProfile) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogProfileOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// GetLogProfileNotFoundCode is the HTTP code returned for type GetLogProfileNotFound
const GetLogProfileNotFoundCode int = 404

/*
GetLogProfileNotFound The specified resource was not found

swagger:response getLogProfileNotFound
*/
type GetLogProfileNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogProfileNotFound creates GetLogProfileNotFound with default headers values
func NewGetLogProfileNotFound() *GetLogProfileNotFound {

	return &GetLogProfileNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the get log profile not found response
func (o *GetLogProfileNotFound) WithConfigurationVersion(configurationVersion string) *GetLogProfileNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log profile not found response
func (o *GetLogProfileNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log profile not found response
func (o *GetLogProfileNotFound) WithPayload(payload *models.Error) *GetLogProfileNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log profile not found response
func (o *GetLogProfileNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogProfileNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
GetLogProfileDefault General Error

swagger:response getLogProfileDefault
*/
type GetLogProfileDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetLogProfileDefault creates GetLogProfileDefault with default headers values
func NewGetLogProfileDefault(code int) *GetLogProfileDefault {
	if code <= 0 {
		code = 500
	}

	return &GetLogProfileDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get log profile default response
func (o *GetLogProfileDefault) WithStatusCode(code int) *GetLogProfileDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get log profile default response
func (o *GetLogProfileDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get log profile default response
func (o *GetLogProfileDefault) WithConfigurationVersion(configurationVersion string) *GetLogProfileDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get log profile default response
func (o *GetLogProfileDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get log profile default response
func (o *GetLogProfileDefault) WithPayload(payload *models.Error) *GetLogProfileDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get log profile default response
func (o *GetLogProfileDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetLogProfileDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
