// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package spoe

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// GetAllSpoeAgentOKCode is the HTTP code returned for type GetAllSpoeAgentOK
const GetAllSpoeAgentOKCode int = 200

/*
GetAllSpoeAgentOK Successful operation

swagger:response getAllSpoeAgentOK
*/
type GetAllSpoeAgentOK struct {
	/*Spoe configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload models.SpoeAgents `json:"body,omitempty"`
}

// NewGetAllSpoeAgentOK creates GetAllSpoeAgentOK with default headers values
func NewGetAllSpoeAgentOK() *GetAllSpoeAgentOK {

	return &GetAllSpoeAgentOK{}
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe agent o k response
func (o *GetAllSpoeAgentOK) WithConfigurationVersion(configurationVersion string) *GetAllSpoeAgentOK {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe agent o k response
func (o *GetAllSpoeAgentOK) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe agent o k response
func (o *GetAllSpoeAgentOK) WithPayload(payload models.SpoeAgents) *GetAllSpoeAgentOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe agent o k response
func (o *GetAllSpoeAgentOK) SetPayload(payload models.SpoeAgents) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeAgentOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(200)
	payload := o.Payload
	if payload == nil {
		// return empty array
		payload = models.SpoeAgents{}
	}

	if err := producer.Produce(rw, payload); err != nil {
		panic(err) // let the recovery middleware deal with this
	}
}

/*
GetAllSpoeAgentDefault General Error

swagger:response getAllSpoeAgentDefault
*/
type GetAllSpoeAgentDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewGetAllSpoeAgentDefault creates GetAllSpoeAgentDefault with default headers values
func NewGetAllSpoeAgentDefault(code int) *GetAllSpoeAgentDefault {
	if code <= 0 {
		code = 500
	}

	return &GetAllSpoeAgentDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the get all spoe agent default response
func (o *GetAllSpoeAgentDefault) WithStatusCode(code int) *GetAllSpoeAgentDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the get all spoe agent default response
func (o *GetAllSpoeAgentDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the get all spoe agent default response
func (o *GetAllSpoeAgentDefault) WithConfigurationVersion(configurationVersion string) *GetAllSpoeAgentDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the get all spoe agent default response
func (o *GetAllSpoeAgentDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the get all spoe agent default response
func (o *GetAllSpoeAgentDefault) WithPayload(payload *models.Error) *GetAllSpoeAgentDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the get all spoe agent default response
func (o *GetAllSpoeAgentDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *GetAllSpoeAgentDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
