/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/event.h>
        #include <wx/event.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxThreadEvent : public ::wxThreadEvent
{
public:
    sipwxThreadEvent(::wxEventType, int);
    sipwxThreadEvent(const ::wxThreadEvent&);
    virtual ~sipwxThreadEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
    ::wxEvent* Clone() const SIP_OVERRIDE;
    ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxThreadEvent(const sipwxThreadEvent &);
    sipwxThreadEvent &operator = (const sipwxThreadEvent &);

    char sipPyMethods[2];
};

sipwxThreadEvent::sipwxThreadEvent(::wxEventType eventType, int id): ::wxThreadEvent(eventType, id), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxThreadEvent::sipwxThreadEvent(const ::wxThreadEvent& a0): ::wxThreadEvent(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxThreadEvent::~sipwxThreadEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

::wxEvent* sipwxThreadEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Clone);

    if (!sipMeth)
        return ::wxThreadEvent::Clone();

    extern ::wxEvent* sipVH__core_103(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_103(sipGILState, 0, sipPySelf, sipMeth);
}

::wxEventCategory sipwxThreadEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetEventCategory);

    if (!sipMeth)
        return ::wxThreadEvent::GetEventCategory();

    extern ::wxEventCategory sipVH__core_104(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__core_104(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxThreadEvent_Clone, "Clone() -> Event\n"
"\n"
"Clones this event making sure that all internal members which use COW (only m_commandString for now; see Reference Counting) are unshared (see wxObject::UnShare).");

extern "C" {static PyObject *meth_wxThreadEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxThreadEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxThreadEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxThreadEvent, &sipCpp))
        {
            ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxThreadEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxEvent, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ThreadEvent, sipName_Clone, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxThreadEvent_GetEventCategory, "GetEventCategory() -> EventCategory\n"
"\n"
"Returns wxEVT_CATEGORY_THREAD.");

extern "C" {static PyObject *meth_wxThreadEvent_GetEventCategory(PyObject *, PyObject *);}
static PyObject *meth_wxThreadEvent_GetEventCategory(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const ::wxThreadEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxThreadEvent, &sipCpp))
        {
            ::wxEventCategory sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp->::wxThreadEvent::GetEventCategory() : sipCpp->GetEventCategory());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxEventCategory);
        }
    }

    sipNoMethod(sipParseErr, sipName_ThreadEvent, sipName_GetEventCategory, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxThreadEvent_GetExtraLong, "GetExtraLong() -> int\n"
"\n"
"Returns extra information integer value.");

extern "C" {static PyObject *meth_wxThreadEvent_GetExtraLong(PyObject *, PyObject *);}
static PyObject *meth_wxThreadEvent_GetExtraLong(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxThreadEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxThreadEvent, &sipCpp))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetExtraLong();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ThreadEvent, sipName_GetExtraLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxThreadEvent_GetInt, "GetInt() -> int\n"
"\n"
"Returns stored integer value.");

extern "C" {static PyObject *meth_wxThreadEvent_GetInt(PyObject *, PyObject *);}
static PyObject *meth_wxThreadEvent_GetInt(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxThreadEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxThreadEvent, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetInt();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_ThreadEvent, sipName_GetInt, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxThreadEvent_GetString, "GetString() -> str\n"
"\n"
"Returns stored string value.");

extern "C" {static PyObject *meth_wxThreadEvent_GetString(PyObject *, PyObject *);}
static PyObject *meth_wxThreadEvent_GetString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxThreadEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxThreadEvent, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_ThreadEvent, sipName_GetString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxThreadEvent_SetExtraLong, "SetExtraLong(extraLong) -> None\n"
"\n"
"Sets the extra information value.");

extern "C" {static PyObject *meth_wxThreadEvent_SetExtraLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxThreadEvent_SetExtraLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        long extraLong;
        ::wxThreadEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_extraLong,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bl", &sipSelf, sipType_wxThreadEvent, &sipCpp, &extraLong))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetExtraLong(extraLong);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ThreadEvent, sipName_SetExtraLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxThreadEvent_SetInt, "SetInt(intCommand) -> None\n"
"\n"
"Sets the integer value.");

extern "C" {static PyObject *meth_wxThreadEvent_SetInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxThreadEvent_SetInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int intCommand;
        ::wxThreadEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_intCommand,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxThreadEvent, &sipCpp, &intCommand))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetInt(intCommand);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ThreadEvent, sipName_SetInt, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxThreadEvent_SetString, "SetString(string) -> None\n"
"\n"
"Sets the string value.");

extern "C" {static PyObject *meth_wxThreadEvent_SetString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxThreadEvent_SetString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* string;
        int stringState = 0;
        ::wxThreadEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_string,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxThreadEvent, &sipCpp, sipType_wxString, &string, &stringState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetString(*string);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(string), sipType_wxString, stringState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_ThreadEvent, sipName_SetString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxThreadEvent(void *, const sipTypeDef *);}
static void *cast_wxThreadEvent(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxThreadEvent *sipCpp = reinterpret_cast< ::wxThreadEvent *>(sipCppV);

    if (targetType == sipType_wxThreadEvent)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxEvent)->ctd_cast(static_cast< ::wxEvent *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxThreadEvent(void *, int);}
static void release_wxThreadEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxThreadEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxThreadEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxThreadEvent(sipSimpleWrapper *);}
static void dealloc_wxThreadEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxThreadEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxThreadEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxThreadEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxThreadEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxThreadEvent *sipCpp = SIP_NULLPTR;

    {
        ::wxEventType eventType = wxEVT_THREAD;
        int id = wxID_ANY;

        static const char *sipKwdList[] = {
            sipName_eventType,
            sipName_id,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|ii", &eventType, &id))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxThreadEvent(eventType, id);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const ::wxThreadEvent* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxThreadEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxThreadEvent(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxThreadEvent[] = {{151, 255, 1}};


static PyMethodDef methods_wxThreadEvent[] = {
    {sipName_Clone, meth_wxThreadEvent_Clone, METH_VARARGS, doc_wxThreadEvent_Clone},
    {sipName_GetEventCategory, meth_wxThreadEvent_GetEventCategory, METH_VARARGS, doc_wxThreadEvent_GetEventCategory},
    {sipName_GetExtraLong, meth_wxThreadEvent_GetExtraLong, METH_VARARGS, doc_wxThreadEvent_GetExtraLong},
    {sipName_GetInt, meth_wxThreadEvent_GetInt, METH_VARARGS, doc_wxThreadEvent_GetInt},
    {sipName_GetString, meth_wxThreadEvent_GetString, METH_VARARGS, doc_wxThreadEvent_GetString},
    {sipName_SetExtraLong, SIP_MLMETH_CAST(meth_wxThreadEvent_SetExtraLong), METH_VARARGS|METH_KEYWORDS, doc_wxThreadEvent_SetExtraLong},
    {sipName_SetInt, SIP_MLMETH_CAST(meth_wxThreadEvent_SetInt), METH_VARARGS|METH_KEYWORDS, doc_wxThreadEvent_SetInt},
    {sipName_SetString, SIP_MLMETH_CAST(meth_wxThreadEvent_SetString), METH_VARARGS|METH_KEYWORDS, doc_wxThreadEvent_SetString}
};

sipVariableDef variables_wxThreadEvent[] = {
    {PropertyVariable, sipName_String, &methods_wxThreadEvent[4], &methods_wxThreadEvent[7], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Int, &methods_wxThreadEvent[3], &methods_wxThreadEvent[6], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ExtraLong, &methods_wxThreadEvent[2], &methods_wxThreadEvent[5], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_EventCategory, &methods_wxThreadEvent[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxThreadEvent, "ThreadEvent(eventType=wxEVT_THREAD, id=ID_ANY) -> None\n"
"\n"
"This class adds some simple functionality to wxEvent to facilitate\n"
"inter-thread communication.");


sipClassTypeDef sipTypeDef__core_wxThreadEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxThreadEvent,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_ThreadEvent,
        {0, 0, 1},
        8, methods_wxThreadEvent,
        0, SIP_NULLPTR,
        4, variables_wxThreadEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxThreadEvent,
    -1,
    -1,
    supers_wxThreadEvent,
    SIP_NULLPTR,
    init_type_wxThreadEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxThreadEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxThreadEvent,
    cast_wxThreadEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::wxThreadEvent),
};
