# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.containerservice import ContainerServiceClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerservice
# USAGE
    python managed_namespaces_create_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerServiceClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.managed_namespaces.begin_create_or_update(
        resource_group_name="rg1",
        resource_name="clustername1",
        managed_namespace_name="namespace1",
        parameters={
            "properties": {
                "adoptionPolicy": "IfIdentical",
                "annotations": {"annatationKey": "annatationValue"},
                "defaultNetworkPolicy": {"egress": "AllowAll", "ingress": "AllowSameNamespace"},
                "defaultResourceQuota": {
                    "cpuLimit": "3m",
                    "cpuRequest": "3m",
                    "memoryLimit": "5Gi",
                    "memoryRequest": "5Gi",
                },
                "deletePolicy": "Keep",
                "labels": {"kubernetes.io/metadata.name": "true"},
            },
            "tags": {"tagKey1": "tagValue1"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2025-09-02-preview/examples/ManagedNamespacesCreate_Update.json
if __name__ == "__main__":
    main()
