# -*- coding: utf-8 -*-
"""Fonts data (part-2)."""

fraktur_dic = {
    ' ': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n',
    '$': u'               \n       .       \n       E       \n    .x+E:..    \n  u8~  E  `b.  \n t8E   E d888> \n 88N.  E\'8888~ \n 88888b&.`""`  \n \'88888888e.   \n   "*8888888N  \n  uu. ^8*8888E \n @888L E `"88E \n\'8888~ E   98~ \n `*.   E  .*"  \n   `~==R=~`    \n',
    '(': u'       .n \n     z8"  \n   x88~   \n  x888    \n :888R    \n 8888R    \n:8888R    \n48888R    \n\'8888R    \n 8888R    \n \'888R    \n  "888    \n   ^88L   \n     "Ru  \n       \'" \n',
    ',': u'       \n       \n       \n       \n       \n       \n       \n       \n  .    \n z8k   \n%888*" \n ?8F   \n .8    \n d"    \n~      \n',
    '0': u'                \n    .n~~%x.     \n  x88X   888.   \n X888X   8888L  \nX8888X   88888  \n88888X   88888X \n88888X   88888X \n88888X   88888f \n48888X   88888  \n ?888X   8888"  \n  "88X   88*`   \n    ^"==="`     \n                \n                \n                \n',
    '4': u'                \n        xeee    \n       d888R    \n      d8888R    \n     @ 8888R    \n   .P  8888R    \n  :F   8888R    \n x"    8888R    \nd8eeeee88888eer \n       8888R    \n       8888R    \n    "*%%%%%%**~ \n                \n                \n                \n',
    '8': u'                \n   u+=~~~+u.    \n z8F      `8N.  \nd88L       98E  \n98888bu.. .@*   \n"88888888NNu.   \n "*8888888888i  \n .zf""*8888888L \nd8F      ^%888E \n88>        `88~ \n\'%N.       d*"  \n   ^"====="`    \n                \n                \n                \n',
    '<': u'              \n              \n              \n              \n         .o@8 \n     .o@8888% \n .o@8888%"    \n8888R"        \n"*8888bu.     \n   ^"*8888bu. \n       ^%*888 \n           ^% \n              \n              \n              \n',
    '@': u'        ...        \n    .uW8***88e.    \n   d8*"     `"8N.  \n .@8F   .ucu.. %8L \n @8E  .@8""988  8N \n\'88>  @8~  98F  98 \n~88  X8E   98~  8E \n\'88> 98&  d88  X8  \n %8N \'88W@"%8ed*`  \n  %8b. `"   ``     \n   `*8bu.. ..u@    \n      ^"***%"`     \n                   \n                   \n                   \n',
    'D': u'       ....          \n   .xH888888Hx.      \n .H8888888888888:    \n 888*"""?""*88888X   \n\'f     d8x.   ^%88k  \n\'>    <88888X   \'?8  \n `:..:`888888>    8> \n        `"*88     X  \n   .xHHhx.."      !  \n  X88888888hx. ..!   \n !   "*888888888"    \n        ^"***"`      \n                     \n                     \n                     \n',
    'H': u'                      \n         .xHL         \n      .-`8888hxxx~    \n   .H8X  `%888*"      \n   888X     ..x..     \n  \'8888k .x8888888x   \n   ?8888X    "88888X  \n    ?8888X    \'88888> \n H8H %8888     `8888> \n\'888> 888"      8888  \n "8` .8" ..     88*   \n    `  x8888h. d*"    \n      !""*888%~       \n      !   `"  .       \n      \'-....:~        \n',
    'L': u'      ...      \n  .zf"` `"tu   \n x88      \'8N. \n 888k     d88& \n 8888N.  @888F \n `88888 9888%  \n   %888 "88F   \n    8"   "*h=~ \n  z8Weu        \n ""88888i.   Z \n"   "8888888*  \n      ^"**""   \n               \n               \n               \n',
    'P': u'    ....      ..     \n  +^""888h. ~"888h   \n 8X.  ?8888X  8888f  \n\'888x  8888X  8888~  \n\'88888 8888X   "88x: \n `8888 8888X  X88x.  \n   `*` 8888X \'88888X \n  ~`...8888X  "88888 \n   x8888888X.   `%8" \n  \'%"*8888888h.   "  \n  ~    888888888!`   \n       X888^"""      \n       `88f          \n        88           \n        ""           \n',
    'T': u'    .....          \n .H8888888h.  ~-.  \n 888888888888x  `> \nX~     `?888888hx~ \n\'      x8.^"*88*"  \n `-:- X8888x       \n      488888>      \n    .. `"88*       \n  x88888nX"      . \n !"*8888888n..  :  \n\'    "*88888888*   \n        ^"***"`    \n                   \n                   \n                   \n',
    'X': u'             ..   \n   .H88x.  :~)88: \n  x888888X ~:8888 \n ~   "8888X  %88" \n      X8888       \n   .xxX8888xxxd>  \n  :88888888888"   \n  ~   \'8888       \n xx.  X8888:    . \nX888  X88888x.x"  \nX88% : \'%8888"    \n "*=~    `""      \n                  \n                  \n                  \n',
    '\\': u"        \n..      \n88.     \n?8b     \n 88     \n 38k    \n  88    \n  98L   \n  '88   \n   *8L  \n   ^88  \n    88r \n    '** \n        \n        \n",
    '`': u'       \n .     \n488b   \n "*8N  \n    \'" \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n',
    'd': u'   ..       \n dF         \n\'88bu.      \n\'*88888bu   \n  ^"*8888N  \n beWE "888L \n 888E  888E \n 888E  888E \n 888E  888F \n.888N..888  \n `"888*""   \n    ""      \n            \n            \n            \n',
    'h': u'            \n  .uef^"    \n:d88E       \n`888E       \n 888E .z8k  \n 888E~?888L \n 888E  888E \n 888E  888E \n 888E  888E \n 888E  888E \nm888N= 888> \n `Y"   888  \n      J88"  \n      @%    \n    :"      \n',
    'l': u'      .. \nx .d88"  \n 5888R   \n \'888R   \n  888R   \n  888R   \n  888R   \n  888R   \n  888R   \n .888B . \n ^*888%  \n   "%    \n         \n         \n         \n',
    'p': u'              \n              \n .d``         \n @8Ne.   .u   \n %8888:u@88N  \n  `888I  888. \n   888I  888I \n   888I  888I \n uW888L  888\' \n\'*88888Nu88P  \n~ \'88888F`    \n   888 ^      \n   *8E        \n   \'8>        \n    "         \n',
    't': u'     s    \n    :8    \n   .88    \n  :888ooo \n-*8888888 \n  8888    \n  8888    \n  8888    \n .8888Lu= \n ^%888*   \n   \'Y"    \n          \n          \n          \n          \n',
    'x': u'             \n             \n   uL   ..   \n .@88b  @88R \n\'"Y888k/"*P  \n   Y888L     \n    8888     \n    `888N    \n .u./"888&   \nd888" Y888*" \n` "Y   Y"    \n             \n             \n             \n             \n',
    '|': u'888 \n888 \n888 \n888 \n888 \n888 \n888 \n888 \n888 \n888 \n888 \n    \n    \n    \n    \n',
    '#': u'             \n    88> :WK  \n   \'88  98E  \n   d8E  88>  \n 98888888888 \n ""88""Y88"" \n  \'88  d8E   \n WW88WW@8NW> \n\'"888""88""~ \n  @8> \'88    \n  88~ d8E    \n \'""  """    \n             \n             \n             \n',
    "'": u'       \n .8u   \nm888R- \n 98P   \n ^8    \n J"    \n+"     \n       \n       \n       \n       \n       \n       \n       \n       \n',
    '+': u'              \n              \n              \n              \n     888      \n     888      \n     888      \n8888888888888 \n8888888888888 \n     888      \n     888      \n     888      \n              \n              \n              \n',
    '/': u"         \n     !8F \n     88' \n    :88  \n   .88F  \n   :88'  \n   88F   \n  .88'   \n  d8F    \n .88     \n d8F     \n:88      \n         \n         \n         \n",
    '3': u'               \n  .x~~"*Weu.   \n d8Nu.  9888c  \n 88888  98888  \n "***"  9888%  \n      ..@8*"   \n   ````"8Weu   \n  ..    ?8888L \n:@88N   \'8888N \n*8888~  \'8888F \n\'*8"`   9888%  \n  `~===*%"`    \n               \n               \n               \n',
    '7': u'              \ndL ud8Nu  :8c \n8Fd888888L %8 \n4N88888888cuR \n4F   ^""%""d  \nd       .z8   \n^     z888    \n    d8888\'    \n   888888     \n  :888888     \n   888888     \n   \'%**%      \n              \n              \n              \n',
    ';': u'       \n       \n       \n  z    \n.d88u  \n^*88"  \n  %"   \n       \n  dL   \nu@88e. \n\'*88"  \n  8%   \n .P    \n *     \n       \n',
    '?': u'    ...     \n u*""888b.  \nJ88N. 8888r \n\'888 .8888> \n \'"  8888%  \n    88*"    \n   48  4    \n   \'h.u*    \n     .      \n    d8b.    \n   "888%    \n     %      \n            \n            \n            \n',
    'C': u'      ...          \n   xH88"`~ .x8X    \n :8888   .f"8888Hf \n:8888>  X8L  ^""`  \nX8888  X888h       \n88888  !88888.     \n88888   %88888     \n88888 \'> `8888>    \n`8888L %  ?888   ! \n `8888  `-*""   /  \n   "888.      :"   \n     `""***~"`     \n                   \n                   \n                   \n',
    'G': u'      ....        .   \n   .x88" `^x~  xH(`   \n  X888   x8 ` 8888h   \n 88888  888.  %8888   \n<8888X X8888   X8?    \nX8888> 488888>"8888x  \nX8888>  888888 \'8888L \n?8888X   ?8888>\'8888X \n 8888X h  8888 \'8888~ \n  ?888  -:8*"  <888"  \n   `*88.      :88%    \n      ^"~====""`      \n                      \n                      \n                      \n',
    'K': u'       ...         \n   .xH8%"```"%.    \n  x888~ xnHhx. ".  \n X888X 8**8888k `. \n 8888X<~  `8888L ! \n 88888!   .!8*"" ` \n `88888!"*888x     \n  `*8888  8888L    \n .x.`888X X888X    \n\'888> %8X !8888..- \n\'888   8  \'8888%`  \n  "*=="     ""     \n                   \n                   \n                   \n',
    'O': u'        ....         \n    .x~X88888Hx.     \n   H8X 888888888h.   \n  8888:`*888888888:  \n  88888:        `%8  \n. `88888          ?> \n`. ?888%           X \n  ~*??.            > \n .x88888h.        <  \n:"""8888888x..  .x   \n`    `*888888888"    \n        ""***""      \n                     \n                     \n                     \n',
    'S': u'       ...         \n   .x888888hx    : \n  d88888888888hxx  \n 8" ... `"*8888%`  \n!  "   ` .xnxx.    \nX X   .H8888888%:  \nX \'hn8888888*"   > \nX: `*88888%`     ! \n\'8h.. ``     ..x8> \n `88888888888888f  \n  \'%8888888888*"   \n     ^"****""`     \n                   \n                   \n                   \n',
    'W': u'     ...    .     ...      \n  .~`"888x.!**h.-``888h.   \n dX   `8888   :X   48888>  \n\'888x  8888  X88.  \'8888>  \n\'88888 8888X:8888:   )?""` \n `8888>8888 \'88888>.88h.   \n   `8" 888f  `8888>X88888. \n  -~` \'8%"     88" `88888X \n  .H888n.      XHn.  `*88! \n :88888888x..x88888X.  `!  \n f  ^%888888% `*88888nx"   \n      `"**"`    `"**""     \n                           \n                           \n                           \n',
    '[': u'        \n4888%"" \n4888    \n4888    \n4888    \n4888    \n4888    \n4888    \n4888    \n4888    \n4888    \n4888    \n4888    \n4888    \n4888u.. \n',
    '_': u'              \n              \n              \n              \n              \n              \n              \n              \n              \n              \n              \n              \n              \n8888888888888 \n              \n',
    'c': u'          \n          \n          \n      .   \n .udR88N  \n<888\'888k \n9888 \'Y"  \n9888      \n9888      \n?8888u../ \n "8888P\'  \n   "P\'    \n          \n          \n          \n',
    'g': u'            \n            \n            \n     uL     \n .ue888Nc.. \nd88E`"888E` \n888E  888E  \n888E  888E  \n888E  888E  \n888& .888E  \n*888" 888&  \n `"   "888E \n.dWi   `88E \n4888~  J8%  \n ^"===*"`   \n',
    'k': u'      ..      \n< .z@8"`      \n !@88E        \n \'888E   u    \n  888E u@8NL  \n  888E`"88*"  \n  888E .dN.   \n  888E~8888   \n  888E \'888&  \n  888E  9888. \n\'"888*" 4888" \n   ""    ""   \n              \n              \n              \n',
    'o': u'            \n            \n       u.   \n ...ue888b  \n 888R Y888r \n 888R I888> \n 888R I888> \n 888R I888> \nu8888cJ888  \n "*888*P"   \n   \'Y"      \n            \n            \n            \n            \n',
    's': u'   .x+=:.   \n  z`    ^%  \n     .   <k \n   .@8Ned8" \n .@^%8888"  \nx88:  `)8b. \n8888N=*8888 \n %8"    R88 \n  @8Wou 9%  \n.888888P`   \n`   ^"F     \n            \n            \n            \n            \n',
    'w': u'                   \n  x=~              \n 88x.   .e.   .e.  \n\'8888X.x888:.x888  \n `8888  888X \'888k \n  X888  888X  888X \n  X888  888X  888X \n  X888  888X  888X \n .X888  888X. 888~ \n `%88%``"*888Y"    \n   `~     `"       \n                   \n                   \n                   \n                   \n',
    '{': u'        \n  .d88\' \n  888   \n  888   \n  888   \n  888   \n  888   \n d88P   \n<88N    \n Y88b   \n  888   \n  888   \n  888   \n  888   \n  "Y88. \n',
    '"': u"         \nd8b  d8b \n888  888 \n888  888 \n888  888 \nY8P  Y8Y \n`8'  `8' \n         \n         \n         \n         \n         \n         \n         \n         \n",
    '&': u'       ...           \n     x88" !.         \n    888X   8  .-=x.  \n   X8888. X" :\'.H88L \n   ?88888X.  f 4888" \n  .x*888888hX   `"`  \n d8  `?8888888.      \nX88L   `%888888k     \n8888x     ?88888>    \n888888hx.x! ?888>    \n\'*8888888"  \'888     \n  `"""""   .88%      \n                     \n                     \n                     \n',
    '*': u'          \n          \n    .     \n   88>    \n88c?R.88> \n\'"?kkT?"  \n88P:k"88> \n\'" 88>\'"  \n   \'"     \n          \n          \n          \n          \n          \n          \n',
    '.': u'       \n       \n       \n       \n       \n       \n       \n       \n   .   \n .@8c  \n\'%888" \n  ^*   \n       \n       \n       \n',
    '2': u'               \n  .--~*teu.    \n dF     988Nx  \nd888b   `8888> \n?8888>  98888F \n "**"  x88888~ \n      d8888*`  \n    z8**"`   : \n  :?.....  ..F \n <""888888888~ \n 8:  "888888*  \n ""    "**"`   \n               \n               \n               \n',
    '6': u'               \n    .ue~~%u.   \n  .d88   z88i  \n x888E  *8888  \n:8888E   ^""   \n98888E.=tWc.   \n98888N  \'888N  \n98888E   8888E \n\'8888E   8888E \n ?888E   8888" \n  "88&   888"  \n    ""==*""    \n               \n               \n               \n',
    ':': u'       \n       \n       \n   .   \n  d8c  \n^*888% \n  "8   \n       \n   .   \n .@8c  \n\'%888" \n  ^*   \n       \n       \n       \n',
    '>': u'              \n              \n              \n.             \n88bu.         \n%*8888eu.     \n   ^%*8888eu  \n       "%8888 \n     .o8888R% \n .o8888R%"    \n8888%"        \n%"            \n              \n              \n              \n',
    'B': u'     ...     ..      \n  .=*8888x <"?88h.   \n X>  \'8888H> \'8888   \n\'88h. `8888   8888   \n\'8888 \'8888    "88>  \n `888 \'8888.xH888x.  \n   X" :88*~  `*8888> \n ~"   !"`      "888> \n  .H8888h.      ?88  \n :"^"88888h.    \'!   \n ^    "88888hx.+"    \n        ^"**""       \n                     \n                     \n                     \n',
    'F': u'    .....          \n .H8888888x.  \'`+  \n:888888888888x.  ! \n8~    `"*88888888" \n!      .  `f""""   \n ~:...-` :8L <)88: \n    .   :888:>X88! \n :~"88x 48888X ^`  \n<  :888k\'88888X    \n  d8888f \'88888X   \n :8888!    ?8888>  \n X888!      8888~  \n \'888       X88f   \n  \'%8:     .8*"    \n     ^----~"`      \n',
    'J': u'      .           \n  .x88888x.       \n :8**888888X.  :> \n f    `888888x./  \n\'       `*88888~  \n \\.    .  `?)X.   \n  `~=-^   X88> ~  \n         X8888  ~ \n         488888   \n .xx.     88888X  \n\'*8888.   \'88888> \n  88888    \'8888> \n  `8888>    `888  \n   "8888     8%   \n    `"888x:-"     \n',
    'N': u'     ...     ...     \n  .=*8888n.."%888:   \n X    ?8888f \'8888   \n 88x. \'8888X  8888>  \n\'8888k 8888X  \'"*8h. \n "8888 X888X .xH8    \n   `8" X888!:888X    \n  =~`  X888 X888X    \n   :h. X8*` !888X    \n  X888xX"   \'8888..: \n:~`888f     \'*888*"  \n    ""        `"`    \n                     \n                     \n                     \n',
    'R': u'     ..      ...     \n  :~"8888x :"%888x   \n 8    8888Xf  8888>  \nX88x. ?8888k  8888X  \n\'8888L\'8888X  \'%88X  \n "888X 8888X:xnHH(`` \n   ?8~ 8888X X8888   \n -~`   8888> X8888   \n :H8x  8888  X8888   \n 8888> 888~  X8888   \n 48"` \'8*~   `8888!` \n  ^-==""      `""    \n                     \n                     \n                     \n',
    'V': u'                     \n                     \n     ...     ..      \n  :~""888h.:^"888:   \n 8X   `8888X  8888>  \nX888n. 8888X  ?888>  \n\'88888 8888X   ?**h. \n  `*88 8888~ x88x.   \n ..<"  88*`  88888X  \n    ..XC.    `*8888k \n  :888888H.    `%88> \n <  `"888888:    X"  \n       %888888x.-`   \n         ""**""      \n                     \n',
    'Z': u'                 \n   :~"""88hx.    \n .~      ?888x   \n X       \'8888k  \n   H8h    8888X  \n  ?888~   8888   \n   %X   .X8*"    \n   .-"``"tnx.    \n  :~      8888.  \n  ~       X8888  \n ...      \'8888L \n\'888k     \'8888f \n 8888>    <8888  \n `888>    X888~  \n  \'"88...x8""    \n',
    '^': u'            \n    oee     \n   d888N    \n  x88"88b   \n .88F \'88L  \n 88P   ?88r \n@8R     %8R \n            \n            \n            \n            \n            \n            \n            \n            \n',
    'b': u'      ..    \n. uW8"      \n`t888       \n 8888   .   \n 9888.z88N  \n 9888  888E \n 9888  888E \n 9888  888E \n 9888  888E \n.8888  888" \n `%888*%"   \n    "`      \n            \n            \n            \n',
    'f': u'          \n   oec :  \n  @88888  \n  8"*88%  \n  8b.     \n u888888> \n  8888R   \n  8888P   \n  *888>   \n  4888    \n  \'888    \n   88R    \n   88>    \n   48     \n   \'8     \n',
    'j': u'        \n   ..   \n  888>  \n  "8P   \n   .    \n u888u. \n`\'888E  \n  888E  \n  888E  \n  888E  \n  888E  \n  888E  \n  888E  \n  888P  \n.J88" " \n',
    'n': u'              \n              \n   u.    u.   \n x@88k u@88c. \n^"8888""8888" \n  8888  888R  \n  8888  888R  \n  8888  888R  \n  8888  888R  \n "*88*" 8888" \n   ""   \'Y"   \n              \n              \n              \n              \n',
    'r': u'             \n             \n   .u    .   \n .d88B :@8c  \n="8888f8888r \n  4888>\'88"  \n  4888> \'    \n  4888>      \n .d888L .+   \n ^"8888*"    \n    "Y"      \n             \n             \n             \n             \n',
    'v': u'   _         \n  u          \n 88Nu.   u.  \n\'88888.o888c \n ^8888  8888 \n  8888  8888 \n  8888  8888 \n  8888  8888 \n .8888b.888P \n  ^Y8888*""  \n    `Y"      \n             \n             \n             \n             \n',
    'z': u'           \n           \n     ..    \n   .@88i   \n  ""%888>  \n    \'88%   \n  ..dILr~` \n \'".-%88b  \n  @  \'888k \n 8F   8888 \n\'8    8888 \n\'8    888F \n %k  <88F  \n  "+:*%`   \n           \n',
    '~': u'             \n             \n ueeu.    u  \n@888888ee88r \n*" ^"*8888"  \n             \n             \n             \n             \n             \n             \n             \n             \n             \n             \n',
    '!': u'  ..   \n 888B. \n48888E \n\'8888\' \n Y88F  \n \'88   \n  8F   \n  4    \n  .    \n u8N.  \n"*88%  \n  ""   \n       \n       \n       \n',
    '%': u'                    \n .z/`mu      xF     \nx88> 98N    xF      \n888> 988E  xF       \n888> 988F xF        \n`88> 98% xF         \n  ^~-"` xF  u>=x.   \n       xF :@8> 98i  \n      xF  888> 988k \n     xF   888> 988E \n    xF    "88> 988  \n   xF       "=-*"   \n                    \n                    \n                    \n',
    ')': u'=u        \n \'%b.     \n   88b    \n   ?88N   \n   4888b  \n   48888r \n   48888k \n   48888R \n   48888F \n   48888  \n   4888F  \n   d88P   \n  .88"    \n .@%      \n"         \n',
    '-': u'         \n         \n         \n         \n         \n         \n         \n         \n88888888 \n88888888 \n         \n         \n         \n         \n         \n',
    '1': u"            \n      oe    \n    .@88    \n==*88888    \n   88888    \n   88888    \n   88888    \n   88888    \n   88888    \n   88888    \n   88888    \n'**%%%%%%** \n            \n            \n            \n",
    '5': u'                \n  cuuu....uK    \n  888888888     \n  8*888**"      \n  >  .....      \n  Lz"  ^888Nu   \n  F     \'8888k  \n  ..     88888> \n @888L   88888  \n\'8888F   8888F  \n %8F"   d888"   \n  ^"===*%"`     \n                \n                \n                \n',
    '9': u'               \n               \n  .xn!~%x.     \n x888   888.   \nX8888   8888:  \n88888   X8888  \n88888   88888> \n`8888  :88888X \n  `"**~ 88888> \n .xx.   88888  \n\'8888>  8888~  \n 888"  :88%    \n  ^"===""      \n               \n               \n',
    '=': u'              \n              \n              \n              \n              \n              \n              \nseeeeeeeeeeee \n8888888888888 \n              \nsoooooooooooo \n8888888888888 \n              \n              \n              \n',
    'A': u'     ..              \n  :**888H: `: .xH""  \n X   `8888k XX888    \n\'8hx  48888 ?8888    \n\'8888 \'8888 `8888    \n %888>\'8888  8888    \n   "8 \'888"  8888    \n  .-` X*"    8888    \n    .xhx.    8888    \n  .H88888h.~`8888.>  \n .~  `%88!` \'888*~   \n       `"     ""     \n                     \n                     \n                     \n',
    'E': u'      ..      .     \n   x88f` `..x88. .> \n :8888   xf`*8888%  \n:8888f .888  `"`    \n88888\' X8888. >"8x  \n88888  ?88888< 888> \n88888   "88888 "8%  \n88888 \'  `8888>     \n`8888> %  X88!      \n `888X  `~""`   :   \n   "88k.      .~    \n     `""*==~~`      \n                    \n                    \n                    \n',
    'I': u'    .....     .  \n  .d88888Neu. \'L \n  F""""*8888888F \n *      `"*88*"  \n  -....    ue=:. \n         :88N  ` \n         9888L   \n  uzu.   `8888L  \n,""888i   ?8888  \n4  9888L   %888> \n\'  \'8888   \'88%  \n     "*8Nu.z*"   \n                 \n                 \n                 \n',
    'M': u'    ...     ..      ..     \n  x*8888x.:*8888: -"888:   \n X   48888X `8888H  8888   \nX8x.  8888X  8888X  !888>  \nX8888 X8888  88888   "*8%- \n\'*888!X8888> X8888  xH8>   \n  `?8 `8888  X888X X888>   \n  -^  \'888"  X888  8888>   \n   dx \'88~x. !88~  8888>   \n .8888Xf.888x:!    X888X.: \n:""888":~"888"     `888*"  \n    "~\'    "~        ""    \n                           \n                           \n                           \n',
    'Q': u'        ....            \n    .n~8888888nx        \n  :88>\'8888888888:      \n :8888 "*888888888k     \n \'88888.         "8>    \n  ?88888          \'X    \n?  %888!           !    \n ".:88"            !    \n   xHH8Hx.        .X  : \n :888888888hx....x\\8..X \n:~  `"8888888888!`\'8888 \n       `""*8*""`   "*"  \n                        \n                        \n                        \n',
    'U': u'                  \n  x8h.     x8.    \n:88888> .x8888x.  \n `8888   `8888f   \n  8888    8888\'   \n  8888    8888    \n  8888    8888    \n  8888    8888    \n  8888    8888    \n-n88888x>"88888x- \n  `%888"  4888!`  \n    `"      ""    \n                  \n                  \n                  \n',
    'Y': u'                   \n   .xnnx.  .xx.    \n .f``"888X< `888.  \n 8L   8888X  8888  \nX88h. `8888  X888k \n\'8888 \'8888  X8888 \n `*88>\'8888  X8888 \n   `! X888~  X8888 \n  -`  X*"    X8888 \n   xH88hx  . X8888 \n .*"*88888~  X888X \n `    "8%    X888> \n    .x..     888f  \n   88888    :88f   \n   "88*"  .x8*~    \n',
    ']': u'        \n"***888 \n   4888 \n   4888 \n   4888 \n   4888 \n   4888 \n   4888 \n   4888 \n   4888 \n   4888 \n   4888 \n   4888 \n   4888 \n...d888 \n',
    'a': u'            \n            \n            \n      u     \n   us888u.  \n.@88 "8888" \n9888  9888  \n9888  9888  \n9888  9888  \n9888  9888  \n"888*""888" \n ^Y"   ^Y\'  \n            \n            \n            \n',
    'e': u'           \n           \n           \n     .u    \n  ud8888.  \n:888\'8888. \nd888 \'88%" \n8888.+"    \n8888L      \n\'8888c. .+ \n "88888%   \n   "YP\'    \n           \n           \n           \n',
    'i': u'   .    \n  @88>  \n  %8P   \n   .    \n .@88u  \n\'\'888E` \n  888E  \n  888E  \n  888E  \n  888&  \n  R888" \n   ""   \n        \n        \n        \n',
    'm': u'                    \n                    \n   ..    .     :    \n .888: x888  x888.  \n~`8888~\'888X`?888f` \n  X888  888X \'888>  \n  X888  888X \'888>  \n  X888  888X \'888>  \n  X888  888X \'888>  \n "*88%""*88" \'888!` \n   `~    "    `"`   \n                    \n                    \n                    \n                    \n',
    'q': u'            \n            \n            \n    .u@u    \n .zWF8888bx \n.888  9888  \nI888  9888  \nI888  9888  \nI888  9888  \n`888Nx?888  \n "88" \'888  \n       88E  \n       98>  \n       \'8   \n        `   \n',
    'u': u'               \n               \n   x.    .     \n .@88k  z88u   \n~"8888 ^8888   \n  8888  888R   \n  8888  888R   \n  8888  888R   \n  8888 ,888B . \n "8888Y 8888"  \n  `Y"   \'YP    \n               \n               \n               \n               \n',
    'y': u'             \n  ..         \n @L          \n9888i   .dL  \n`Y888k:*888. \n  888E  888I \n  888E  888I \n  888E  888I \n  888E  888I \n x888N><888\' \n  "88"  888  \n        88F  \n       98"   \n     ./"     \n    ~`       \n',
    '}': u"        \n`88b.   \n  888   \n  888   \n  888   \n  888   \n  Y88b  \n   %88> \n  d88P  \n  888   \n  888   \n  888   \n  888   \n  888   \n.88P'   \n"}

funface_dic = {
    '!': u'!\n \n \n \n \n \n \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u'"\n \n \n \n \n \n \n',
    '%': u'%\n \n \n \n \n \n \n',
    '$': u' \n \n \n \n \n \n \n',
    "'": u"'\n \n \n \n \n \n \n",
    '&': u'&\n \n \n \n \n \n \n',
    ')': u')\n \n \n \n \n \n \n',
    '(': u'(\n \n \n \n \n \n \n',
    '+': u'+\n \n \n \n \n \n \n',
    '*': u'*\n \n \n \n \n \n \n',
    '-': u'-\n \n \n \n \n \n \n',
    ',': u',\n \n \n \n \n \n \n',
    '/': u'/\n \n \n \n \n \n \n',
    '.': u'.\n \n \n \n \n \n \n',
    '1': u'1\n \n \n \n \n \n \n',
    '0': u'0\n \n \n \n \n \n \n',
    '3': u'3\n \n \n \n \n \n \n',
    '2': u'2\n \n \n \n \n \n \n',
    '5': u'5\n \n \n \n \n \n \n',
    '4': u'4\n \n \n \n \n \n \n',
    '7': u'7\n \n \n \n \n \n \n',
    '6': u'6\n \n \n \n \n \n \n',
    '9': u'9\n \n \n \n \n \n \n',
    '8': u'8\n \n \n \n \n \n \n',
    ';': u';\n \n \n \n \n \n \n',
    ':': u':\n \n \n \n \n \n \n',
    '=': u'=\n \n \n \n \n \n \n',
    '<': u'<\n \n \n \n \n \n \n',
    '?': u'?\n \n \n \n \n \n \n',
    '>': u'>\n \n \n \n \n \n \n',
    '@': u'@\n \n \n \n \n \n \n',
    '[': u'[\n \n \n \n \n \n \n',
    ']': u']\n \n \n \n \n \n \n',
    '\\': u'\\\n \n \n \n \n \n \n',
    '_': u'_\n \n \n \n \n \n \n',
    '^': u'^\n \n \n \n \n \n \n',
    'a': u"        \n   /)   \n (o)(O) \n  //\\\\  \n |(__)| \n /,-. | \n-'   '' \n",
    '`': u'`\n \n \n \n \n \n \n',
    'c': u"   c  c  \n   (OO)  \n ,'.--.) \n/ //_|_\\ \n| \\___   \n'.    )  \n  `-.'   \n",
    'b': u" _     \n/||_   \n /`_)  \n|  `.  \n| (_)) \n(.'-'  \n )     \n",
    'e': u"        \n  wWw   \n  (O)_  \n .' __) \n(  _)   \n `.__)  \n        \n",
    'd': u"    _  \n  _||\\ \n (_'\\  \n .'  | \n((_) | \n `-`.) \n    (  \n",
    'g': u"    \\/    \n   (OO)   \n ,'.--.)  \n/ /|_|_\\  \n| \\_.--.  \n'.   \\) \\ \n  `-.(_.' \n",
    'f': u"        \n  wWw   \n  (O)_  \n .' __) \n(  _)   \n )/     \n(       \n",
    'i': u'wW  Ww \n(O)(O) \n (..)  \n  ||   \n _||_  \n(_/\\_) \n       \n',
    'h': u" \\\\  //  \n (o)(o)  \n ||  ||  \n |(__)|  \n /.--.\\  \n-'    `- \n         \n",
    'k': u"       _  \n(OO) .' ) \n ||_/ .'  \n |   /    \n ||\\ \\    \n(/\\)\\ `.  \n     `._) \n",
    'j': u"    _  \n  _||\\ \n (_'\\  \n  (  | \n(\\_) | \n `-`.) \n    (  \n",
    'm': u'\\\\\\    /// \n((O)  (O)) \n | \\  / |  \n ||\\\\//||  \n || \\/ ||  \n ||    ||  \n(_/    \\_) \n',
    'l': u" W  W    \n(O)(O)   \n  ||     \n  | \\    \n  |  `.  \n (.-.__) \n  `-'    \n",
    'o': u"    .-.     \n  c(O_O)c   \n ,'.---.`,  \n/ /|_|_|\\ \\ \n| \\_____/ | \n'. `---' .` \n  `-...-'   \n",
    'n': u'\\\\\\  /// \n((O)(O)) \n | \\ ||  \n ||\\\\||  \n || \\ |  \n ||  ||  \n(_/  \\_) \n',
    'q': u"    .-.     \n  c(O_O)c   \n ,'.---.`,  \n/ /|_|_|\\ \\ \n| \\___.--.| \n'. `---\\) \\ \n  `-...(_.' \n",
    'p': u" ))     \n(o0)-.  \n | (_)) \n | .-'  \n |(     \n  \\)    \n  (     \n",
    's': u"  oo_    \n /  _)-< \n \\__ `.  \n    `. | \n    _| | \n ,-'   | \n(_..--'  \n",
    'r': u" ))     \n(Oo)-.  \n | (_)) \n |  .'  \n )|\\\\   \n(/  \\)  \n )      \n",
    'u': u" wWw  wWw  \n (O)  (O)  \n / )  ( \\  \n/ /    \\ \\ \n| \\____/ | \n'. `--' .` \n  `-..-'   \n",
    't': u'(o)__(o) \n(__  __) \n  (  )   \n   )(    \n  (  )   \n   )/    \n  (      \n',
    'w': u'(O))  ((O) \n ||    ||  \n || /\\ ||  \n ||//\\\\||  \n / /  \\ \\  \n( /    \\ ) \n )      (  \n',
    'v': u"wWw    wWw \n(O)    (O) \n( \\    / ) \n \\ \\  / /  \n /  \\/  \\  \n \\ `--' /  \n  `-..-'   \n",
    'y': u"wWw  wWw \n(O)  (O) \n( \\  / ) \n \\ \\/ /  \n  \\o /   \n _/ /    \n(_.'     \n",
    'x': u" wW    Ww  \n(O)\\  /(O) \n `. \\/ .'  \n   \\  /    \n   /  \\    \n .' /\\ `.  \n(_.'  `._) \n",
    '{': u'{\n \n \n \n \n \n \n',
    'z': u'   _oo   \n>-(_  \\  \n   / _/  \n  / /    \n / (     \n(   `-.  \n `--.._) \n',
    '}': u'}\n \n \n \n \n \n \n',
    '|': u'|\n \n \n \n \n \n \n',
    '~': u'~\n \n \n \n \n \n \n'}

funfaces_dic = {
    '!': u'  .--.  \n (O)(O) \n | o /  \n |`-/   \n |_/    \n _      \n(_)     \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u'"\n \n \n \n \n \n \n',
    '%': u'%\n \n \n \n \n \n \n',
    '$': u' \n \n \n \n \n \n \n',
    "'": u'     \n __  \n(  ) \n )/  \n /   \n     \n     \n',
    '&': u'&\n \n \n \n \n \n \n',
    ')': u')\n \n \n \n \n \n \n',
    '(': u'(\n \n \n \n \n \n \n',
    '+': u'+\n \n \n \n \n \n \n',
    '*': u'*\n \n \n \n \n \n \n',
    '-': u'        \n        \n        \n _____  \n[_____] \n        \n        \n',
    ',': u'     \n     \n     \n     \n __  \n(  ) \n )/  \n',
    '/': u'/\n \n \n \n \n \n \n',
    '.': u'    \n    \n    \n    \n    \n _  \n(_) \n',
    '1': u' __    \n/\' \\   \n" ||   \n  ||   \n  ||   \n _||_  \n(_/\\_) \n',
    '0': u"   .-.    \n (O)_(O)  \n / .-. \\  \n/ /_|_\\ \\ \n| \\___/ | \n'. `-' .` \n  `-.-'   \n",
    '3': u'  wWw   \n _(O)   \n(__ \\   \n   ) \\  \n  (_  ) \n  _/ /  \n (__/   \n',
    '2': u"           \n (O)-.     \n(_.-. \\    \n     )/    \n    //     \n   /(____; \n  (____.-' \n",
    '5': u"         \n   oo_   \n .' __)  \n | |__   \n |___ \\  \n ____) ) \n(_____/  \n",
    '4': u'\\\\  //   \n(o)(o)   \n/ /\\ \\   \n|(__)|   \n\\___ |   \n   | |_  \n   \\___) \n',
    '7': u' (O)-.   \n(_.-. \\  \n     ) ) \n    / /  \n   / /   \n  / |    \n /_|_\\   \n',
    '6': u' ;(O)   \n"/ __)  \n | |__  \n | __ \\ \n |(__)| \n \\    / \n  `--\'  \n',
    '9': u" ,--.  \n(O)(O) \n|(__)| \n|  __/ \n| /|\\  \n\\ `-.  \n `--'  \n",
    '8': u'  wWwWw   \n  (O)o)   \n  / _ \\   \n / (_) \\  \n(  /"\\  ) \n \\ \\_/ /  \n  \\___/   \n',
    ';': u';\n \n \n \n \n \n \n',
    ':': u'    \n    \n _  \n(_) \n    \n _  \n(_) \n',
    '=': u'=\n \n \n \n \n \n \n',
    '<': u'<\n \n \n \n \n \n \n',
    '?': u' (O)-.  \n(_.-. \\ \n     )/ \n    //  \n   (/   \n   _    \n  (_)   \n',
    '>': u'>\n \n \n \n \n \n \n',
    '@': u'@\n \n \n \n \n \n \n',
    '[': u'[\n \n \n \n \n \n \n',
    ']': u']\n \n \n \n \n \n \n',
    '\\': u'\\\n \n \n \n \n \n \n',
    '_': u'        \n        \n        \n        \n        \n _____  \n[_____] \n',
    '^': u'       \n  /\\   \n /  \\  \n/ /\\ \\ \n\\(  )/ \n       \n       \n',
    'a': u"        \n   /)   \n (o)(O) \n  //\\\\  \n |(__)| \n /,-. | \n-'   '' \n",
    '`': u'     \n __  \n(  ) \n \\(  \n  \\  \n     \n     \n',
    'c': u"   c  c  \n   (OO)  \n ,'.--.) \n/ //_|_\\ \n| \\___   \n'.    )  \n  `-.'   \n",
    'b': u" ___    \n(___)__ \n(O)(O)  \n/  _\\   \n| |_))  \n| |_))  \n(.'-'   \n",
    'e': u'  wWw   \n  (O)_  \n  / __) \n / (    \n(  _)   \n \\ \\_   \n  \\__)  \n',
    'd': u' _     \n/||_   \n /o_)  \n/ |(\\  \n| | )) \n| |//  \n\\__/   \n',
    'g': u"    \\/    \n   (OO)   \n ,'.--.)  \n/ /|_|_\\  \n| \\_.--.  \n'.   \\) \\ \n  `-.(_.' \n",
    'f': u'  wWw   \n  (O)_  \n  / __) \n / (    \n(  _)   \n/ /     \n)/      \n',
    'i': u'wW  Ww \n(O)(O) \n (..)  \n  ||   \n _||_  \n(_/\\_) \n       \n',
    'h': u" \\\\  //  \n (o)(o)  \n ||  ||  \n |(__)|  \n /.--.\\  \n-'    `- \n         \n",
    'k': u"       _  \n(OO) .' ) \n ||_/ .'  \n |   /    \n ||\\ \\    \n(/\\)\\ `.  \n     `._) \n",
    'j': u"    _  \n  _||\\ \n (_'\\  \n  (  | \n   \\ | \n(\\__)| \n `--.) \n",
    'm': u'\\\\\\    /// \n((O)  (O)) \n | \\  / |  \n ||\\\\//||  \n || \\/ ||  \n ||    ||  \n(_/    \\_) \n',
    'l': u" W  W    \n(O)(O)   \n  ||     \n  | \\    \n  |  `.  \n (.-.__) \n  `-'    \n",
    'o': u"    .-.     \n  c(O_O)c   \n ,'.---.`,  \n/ /|_|_|\\ \\ \n| \\_____/ | \n'. `---' .` \n  `-...-'   \n",
    'n': u'\\\\\\  /// \n((O)(O)) \n | \\ ||  \n ||\\\\||  \n || \\ |  \n ||  ||  \n(_/  \\_) \n',
    'q': u"    .-.     \n  c(O_O)c   \n ,'.---.`,  \n/ /|_|_|\\ \\ \n| \\___.--.| \n'. `---\\) \\ \n  `-...(_.' \n",
    'p': u" ))     \n(o0)-.  \n | (_)) \n | .-'  \n |(     \n  \\)    \n  (     \n",
    's': u"  oo_    \n /  _)-< \n \\__ `.  \n    `. | \n    _| | \n ,-'   | \n(_..--'  \n",
    'r': u'()_()  \n(O o)  \n |^_\\  \n |(_)) \n |  /  \n )|\\\\  \n(/  \\) \n',
    'u': u" wWw  wWw  \n (O)  (O)  \n / )  ( \\  \n/ /    \\ \\ \n| \\____/ | \n'. `--' .` \n  `-..-'   \n",
    't': u'(o)__(o) \n(__  __) \n  (  )   \n   )(    \n  (  )   \n   )/    \n  (      \n',
    'w': u'(O))  ((O) \n ||    ||  \n || /\\ ||  \n ||//\\\\||  \n / /  \\ \\  \n( /    \\ ) \n )      (  \n',
    'v': u"wWw    wWw \n(O)    (O) \n( \\    / ) \n \\ \\  / /  \n /  \\/  \\  \n \\ `--' /  \n  `-..-'   \n",
    'y': u"wWw  wWw \n(O)  (O) \n( \\  / ) \n \\ \\/ /  \n  \\o /   \n _/ /    \n(_.'     \n",
    'x': u" wW    Ww  \n(O)\\  /(O) \n `. \\/ .'  \n   \\  /    \n   /  \\    \n .' /\\ `.  \n(_.'  `._) \n",
    '{': u'{\n \n \n \n \n \n \n',
    'z': u'   _oo   \n>-(_  \\  \n   / _/  \n  / /    \n / (     \n(   `-.  \n `--.._) \n',
    '}': u'}\n \n \n \n \n \n \n',
    '|': u'|\n \n \n \n \n \n \n',
    '~': u'~\n \n \n \n \n \n \n'}

georgi16_dic = {
    ' ': u'      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n',
    '$': u"          \n          \n  __M__   \n 6MMMMMb  \n6M' M  Yb \nMM  M     \nYM. M     \n YMMMMMb  \n    M `Mb \n    M  MM \n    M  MM \nYb  M ,M9 \n YMMMMM9  \n    M     \n          \n          \n",
    '(': u"    \n    \n  ,'\n 6P \n,M' \nMM  \nMM  \nMM  \nMM  \nMM  \nMM  \nMM  \nMM  \n`M. \n Yb \n  `.\n",
    ',': u'    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n68b \nY89 \n 9  \n/   \n    \n',
    '0': u"         \n         \n         \n         \n         \n  ____   \n 6MMMMb  \n6M'  `Mb \nMM    MM \nMM    MM \nMM    MM \nYM.  ,M9 \n YMMMM9  \n         \n         \n         \n",
    '4': u'         \n         \n         \n         \n         \n         \n     ,M  \n    ,dM  \n   ,dMM  \n  ,d MM  \n ,d  MM  \n,d   MM  \nMMMMMMMM \n     MM  \n     MM  \n     MM  \n',
    '8': u"         \n         \n  ____   \n 6MMMMb  \n6M'  `Mb \nMM    M9 \nYM.  ,9  \n YMMMMb  \n 6'  `Mb \n6M    MM \nMM    MM \nYM.  ,M9 \n YMMMM9  \n         \n         \n         \n",
    '<': u'      \n      \n      \n      \n      \n   /M/\n  /M/ \n /M/  \n/M/   \n\\M\\   \n \\M\\  \n  \\M\\ \n   \\M\\\n      \n      \n      \n',
    '@': u"               \n               \n               \n               \n  ,88888888b   \n 68        `b  \n,P   o68b69 Yb \n6'  M'  ,M'  8 \nM  dP   dP   8 \nM ,M'  ,M'   8 \nM dP   dP   ,8 \nM Yb  ,M'  d8' \nY  YMM9Yoo6'   \n`b             \n `Y888888'     \n               \n",
    'D': u"           \n           \n________   \n`MMMMMMMb. \n MM    `Mb \n MM     MM \n MM     MM \n MM     MM \n MM     MM \n MM     MM \n MM     MM \n MM    .M9 \n_MMMMMMM9' \n           \n           \n           \n",
    'H': u"            \n            \n____    ____\n`MM'    `MM'\n MM      MM \n MM      MM \n MM      MM \n MMMMMMMMMM \n MM      MM \n MM      MM \n MM      MM \n MM      MM \n_MM_    _MM_\n            \n            \n            \n",
    'L': u"         \n         \n____     \n`MM'     \n MM      \n MM      \n MM      \n MM      \n MM      \n MM      \n MM      \n MM    / \n_MMMMMMM \n         \n         \n         \n",
    'P': u"           \n           \n________   \n`MMMMMMMb. \n MM    `Mb \n MM     MM \n MM     MM \n MM    .M9 \n MMMMMMM9' \n MM        \n MM        \n MM        \n_MM_       \n           \n           \n           \n",
    'T': u'           \n           \n__________ \nMMMMMMMMMM \n/   MM   \\ \n    MM     \n    MM     \n    MM     \n    MM     \n    MM     \n    MM     \n    MM     \n   _MM_    \n           \n           \n           \n',
    'X': u"              \n              \n____      ___ \n`MM(      )M' \n `MM.     d'  \n  `MM.   d'   \n   `MM. d'    \n    `MMd      \n     dMM.     \n    d'`MM.    \n   d'  `MM.   \n  d'    `MM.  \n_M(_    _)MM_ \n              \n              \n              \n",
    '\\': u'          \n          \n`M.       \n Yb       \n `M.      \n  Yb      \n  `M.     \n   Yb     \n   `M.    \n    Yb    \n    `M.   \n     Yb   \n     `M.  \n      Yb  \n      `M. \n       Yb \n',
    '`': u'    \n    \n  / \n 6  \n68b \nY89 \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n',
    'd': u"         \n         \n     ___ \n     `MM \n      MM \n  ____MM \n 6MMMMMM \n6M'  `MM \nMM    MM \nMM    MM \nMM    MM \nYM.  ,MM \n YMMMMMM_\n         \n         \n         \n",
    'h': u"          \n          \n___       \n`MM       \n MM       \n MM  __   \n MM 6MMb  \n MMM9 `Mb \n MM'   MM \n MM    MM \n MM    MM \n MM    MM \n_MM_  _MM_\n          \n          \n          \n",
    'l': u'    \n    \n___ \n`MM \n MM \n MM \n MM \n MM \n MM \n MM \n MM \n MM \n_MM_\n    \n    \n    \n',
    'p': u"          \n          \n          \n          \n          \n__ ____   \n`M6MMMMb  \n MM'  `Mb \n MM    MM \n MM    MM \n MM    MM \n MM.  ,M9 \n MMYMMM9  \n MM       \n MM       \n_MM_      \n",
    't': u'        \n        \n        \n        \n  /     \n /M     \n/MMMMM  \n MM     \n MM     \n MM     \n MM     \n YM.  , \n  YMMM9 \n        \n        \n        \n',
    'x': u"           \n           \n           \n           \n           \n____   ___ \n`MM(   )P' \n `MM` ,P   \n  `MM,P    \n   `MM.    \n   d`MM.   \n  d' `MM.  \n_d_  _)MM_ \n           \n           \n           \n",
    '|': u'   \n   \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \n',
    '#': u"           \n           \n           \n           \n     dP dP \n    ,M',M' \n    dP dP  \n   ,M',M'  \n MMMMMMMM  \n  ,M',M'   \n MMMMMMMM  \n ,M',M'    \n dP dP     \n,M',M'     \ndP dP      \n           \n",
    "'": u'    \n    \n68b \nY89 \n 9  \n/   \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n',
    '+': u'        \n        \n        \n        \n        \n        \n   M    \n   M    \n   M    \nMMMMMMM \n   M    \n   M    \n   M    \n        \n        \n        \n',
    '/': u"         \n         \n      ,M'\n      dP \n     ,M' \n     dP  \n    ,M'  \n    dP   \n   ,M'   \n   dP    \n  ,M'    \n  dP     \n ,M'     \n dP      \n,M'      \ndP       \n",
    '3': u"         \n         \n         \n         \n         \n  ____   \n 6MMMMb  \nMM'  `Mb \n      MM \n     .M9 \n  MMMM   \n     `Mb \n      MM \n      MM \nMM.  ,M9 \n YMMMM9  \n",
    '7': u"         \n         \n         \n         \n         \n________ \nMMMMMMMM \n/     d' \n     ,P  \n     M   \n    d'   \n   ,P    \n   M     \n  d'     \n ,P      \n M       \n",
    ';': u'    \n    \n    \n    \n    \n    \n68b \nY89 \n    \n    \n    \n68b \nY89 \n 9  \n/   \n    \n',
    '?': u"        \n        \n        \n 6MMMb  \n6M' `Mb \n`'   MM \n     MM \n    ,M9 \n   MM9  \n   M    \n        \n  68b   \n  Y89   \n        \n        \n        \n",
    'C': u'          \n          \n   ____   \n  6MMMMb/ \n 8P    YM \n6M      Y \nMM        \nMM        \nMM        \nMM        \nYM      6 \n 8b    d9 \n  YMMMM9  \n          \n          \n          \n',
    'G': u"          \n          \n   ____   \n  6MMMMb/ \n 8P    YM \n6M      Y \nMM        \nMM        \nMM     ___\nMM     `M'\nYM      M \n 8b    d9 \n  YMMMM9  \n          \n          \n          \n",
    'K': u"           \n           \n___    __  \n`MM    d'  \n MM   d'   \n MM  d'    \n MM d'     \n MMd'      \n MMYM.     \n MM YM.    \n MM  YM.   \n MM   YM.  \n_MM_   YM._\n           \n           \n           \n",
    'O': u'           \n           \n   ____    \n  6MMMMb   \n 8P    Y8  \n6M      Mb \nMM      MM \nMM      MM \nMM      MM \nMM      MM \nYM      M9 \n 8b    d8  \n  YMMMM9   \n           \n           \n           \n',
    'S': u"         \n         \n  ____   \n 6MMMMb\\ \n6M'    ` \nMM       \nYM.      \n YMMMMb  \n     `Mb \n      MM \n      MM \nL    ,M9 \nMYMMMM9  \n         \n         \n         \n",
    'W': u"                      \n                      \n____              ___ \n`Mb(      db      )d' \n YM.     ,PM.     ,P  \n `Mb     d'Mb     d'  \n  YM.   ,P YM.   ,P   \n  `Mb   d' `Mb   d'   \n   YM. ,P   YM. ,P    \n   `Mb d'   `Mb d'    \n    YM,P     YM,P     \n    `MM'     `MM'     \n     YP       YP      \n                      \n                      \n                      \n",
    '[': u'     \n     \nMMMM \nMM   \nMM   \nMM   \nMM   \nMM   \nMM   \nMM   \nMM   \nMM   \nMM   \nMM   \nMM   \nMMMM \n',
    '_': u'         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n         \n         \nMMMMMMMM \n         \n',
    'c': u"         \n         \n         \n         \n         \n  ____   \n 6MMMMb. \n6M'   Mb \nMM    `' \nMM       \nMM       \nYM.   d9 \n YMMMM9  \n         \n         \n         \n",
    'g': u"         \n         \n         \n         \n         \n  __     \n 6MMbMMM \n6M'`Mb   \nMM  MM   \nYM.,M9   \n YMM9    \n(M       \n YMMMMb. \n6M    Yb \nYM.   d9 \n YMMMM9  \n",
    'k': u"          \n          \n___       \n`MM       \n MM       \n MM   __  \n MM   d'  \n MM  d'   \n MM d'    \n MMdM.    \n MMPYM.   \n MM  YM.  \n_MM_  YM._\n          \n          \n          \n",
    'o': u"          \n          \n          \n          \n          \n  _____   \n 6MMMMMb  \n6M'   `Mb \nMM     MM \nMM     MM \nMM     MM \nYM.   ,M9 \n YMMMMM9  \n          \n          \n          \n",
    's': u"         \n         \n         \n         \n         \n  ____   \n 6MMMMb\\ \nMM'    ` \nYM.      \n YMMMMb  \n     `Mb \nL    ,MM \nMYMMMM9  \n         \n         \n         \n",
    'w': u"                 \n                 \n                 \n                 \n                 \n____    _    ___ \n`MM(   ,M.   )M' \n `Mb   dMb   d'  \n  YM. ,PYM. ,P   \n  `Mb d'`Mb d'   \n   YM,P  YM,P    \n   `MM'  `MM'    \n    YP    YP     \n                 \n                 \n                 \n",
    '{': u"      \n      \n   ,6'\n  6M  \n  MM  \n  MM  \n  MM  \n  M9  \n,6'   \n`b.   \n  Mb  \n  MM  \n  MM  \n  MM  \n  YM  \n   `b.\n",
    '"': u"        \n        \n68b 68b \nY89 Y89 \n`M' `M' \n V   V  \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n",
    '&': u"           \n           \n  __       \n 6MMb      \n6M' `b     \n8M  ,9     \nYM.,9  ___ \n `Mb   `M' \n,M'MM   P  \nMM  YM. 7  \nMM   `Mb   \nYM.   7MM  \n YMMM9  YM_\n           \n           \n           \n",
    '*': u'        \n        \n        \n 8   8  \n  \\ /   \n(8o*o8) \n  / \\   \n 8   8  \n        \n        \n        \n        \n        \n        \n        \n        \n',
    '.': u'    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n68b \nY89 \n    \n    \n    \n',
    '2': u"         \n         \n         \n         \n         \n  ____   \n 6MMMMb  \nMM'  `Mb \n     ,MM \n    ,MM' \n  ,M'    \n,M'      \nMMMMMMMM \n         \n         \n         \n",
    '6': u"          \n          \n    ,6P   \n  6MM'    \n 6M'      \n6M ____   \nMMMMMMMb  \nMM'   `Mb \nMM     MM \nMM     MM \nMM     MM \nYM.   ,M9 \n YMMMMM9  \n          \n          \n          \n",
    ':': u'    \n    \n    \n    \n    \n    \n68b \nY89 \n    \n    \n    \n68b \nY89 \n    \n    \n    \n',
    '>': u'       \n       \n       \n       \n       \n\\M\\    \n \\M\\   \n  \\M\\  \n   \\M\\ \n   /M/ \n  /M/  \n /M/   \n/M/    \n       \n       \n       \n',
    'B': u"           \n           \n________   \n`MMMMMMMb. \n MM    `Mb \n MM     MM \n MM    .M9 \n MMMMMMM(  \n MM    `Mb \n MM     MM \n MM     MM \n MM    .M9 \n_MMMMMMM9' \n           \n           \n           \n",
    'F': u'         \n         \n________ \n`MMMMMMM \n MM    \\ \n MM      \n MM   ,  \n MMMMMM  \n MM   `  \n MM      \n MM      \n MM      \n_MM_     \n         \n         \n         \n',
    'J': u"         \n         \n     ____\n     `MM'\n      MM \n      MM \n      MM \n      MM \n      MM \n      MM \n(8)   MM \n((   ,M9 \n YMMMM9  \n         \n         \n         \n",
    'N': u"            \n            \n___      ___\n`MM\\     `M'\n MMM\\     M \n M\\MM\\    M \n M \\MM\\   M \n M  \\MM\\  M \n M   \\MM\\ M \n M    \\MM\\M \n M     \\MMM \n M      \\MM \n_M_      \\M \n            \n            \n            \n",
    'R': u"            \n            \n________    \n`MMMMMMMb.  \n MM    `Mb  \n MM     MM  \n MM     MM  \n MM    .M9  \n MMMMMMM9'  \n MM  \\M\\    \n MM   \\M\\   \n MM    \\M\\  \n_MM_    \\M\\_\n            \n            \n            \n",
    'V': u"             \n             \n____     ___ \n`Mb(     )d' \n YM.     ,P  \n `Mb     d'  \n  YM.   ,P   \n  `Mb   d'   \n   YM. ,P    \n   `Mb d'    \n    YM,P     \n    `MM'     \n     YP      \n             \n             \n             \n",
    'Z': u'             \n             \n____________ \nMMMMMMMMMMMP \n/       dMP  \n       dMP   \n      dMP    \n     dMP     \n    dMP      \n   dMP       \n  dMP        \n dMP       / \ndMMMMMMMMMMM \n             \n             \n             \n',
    '^': u'         \n         \n         \n   /M\\   \n  // \\\\  \n //   \\\\ \n//     \\\\\n         \n         \n         \n         \n         \n         \n         \n         \n         \n',
    'b': u"          \n          \n___       \n MM       \n MM       \n MM____   \n MMMMMMb  \n MM'  `Mb \n MM    MM \n MM    MM \n MM    MM \n MM.  ,M9 \n_MYMMMM9  \n          \n          \n          \n",
    'f': u"      \n      \n   __ \n  69MM\n 6M' `\n_MM__ \nMMMMM \n MM   \n MM   \n MM   \n MM   \n MM   \n_MM_  \n      \n      \n      \n",
    'j': u'        \n        \n        \n    68b \n    Y89 \n    ___ \n    `MM \n     MM \n     MM \n     MM \n     MM \n     MM \n     MM \n     MM \n (8) M9 \n  YMM9  \n',
    'n': u"          \n          \n          \n          \n          \n___  __   \n`MM 6MMb  \n MMM9 `Mb \n MM'   MM \n MM    MM \n MM    MM \n MM    MM \n_MM_  _MM_\n          \n          \n          \n",
    'r': u'        \n        \n        \n        \n        \n___  __ \n`MM 6MM \n MM69 " \n MM\'    \n MM     \n MM     \n MM     \n_MM_    \n        \n        \n        \n',
    'v': u"            \n            \n            \n            \n            \n____    ___ \n`MM(    )M' \n `Mb    d'  \n  YM.  ,P   \n   MM  M    \n   `Mbd'    \n    YMP     \n     M      \n            \n            \n            \n",
    'z': u'          \n          \n          \n          \n          \n_________ \nMMMMMMMMP \n/    dMP  \n    dMP   \n   dMP    \n  dMP     \n dMP    / \ndMMMMMMMM \n          \n          \n          \n',
    '~': u"         \n         \n         \n         \n         \n         \n         \n         \n,68b.   ,\n'   `Y89'\n         \n         \n         \n         \n         \n         \n",
    '!': u'    \n    \n 8  \n(M) \n(M) \n(M) \n M  \n M  \n M  \n 8  \n    \n68b \nY89 \n    \n    \n    \n',
    '%': u"              \n              \n              \n ,88.       M \n,M  M.    ,P  \n8(  )8   d'   \n`M  M'  M     \n `88' ,P      \n     d' ,88.  \n    M  ,M  M. \n  ,P   8(  )8 \n d'    `M  M' \nM       `88'  \n              \n              \n              \n",
    ')': u"     \n     \n`.   \n Yb  \n `M. \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n ,M' \n d9  \n,'   \n",
    '-': u'        \n        \n        \n        \n        \n        \n        \n        \n        \nMMMMMMM \n        \n        \n        \n        \n        \n        \n',
    '1': u'    \n    \n    \n    \n    \n__/ \n`MM \n MM \n MM \n MM \n MM \n MM \n_MM_\n    \n    \n    \n',
    '5': u"         \n         \n         \n         \n         \n _______ \n,MMMMMMM \ndM       \nMP       \nM'       \nMMMMMMb  \n     `Mb \n      MM \n      MM \nMM.  ,M9 \n YMMMM9  \n",
    '9': u"         \n         \n         \n         \n         \n  ____   \n 6MMMMb  \n6M'  `Mb \nMM    MM \nMM    MM \nYM.  ,MM \n YMMMMMM \n      M9 \n    ,M9  \n  ,MM9   \n d9'     \n",
    '=': u'        \n        \n        \n        \n        \n        \n        \n        \nMMMMMMM \n        \nMMMMMMM \n        \n        \n        \n        \n        \n',
    'A': u"              \n              \n       _      \n      dM.     \n     ,MMb     \n     d'YM.    \n    ,P `Mb    \n    d'  YM.   \n   ,P   `Mb   \n   d'    YM.  \n  ,MMMMMMMMb  \n  d'      YM. \n_dM_     _dMM_\n              \n              \n              \n",
    'E': u'           \n           \n__________ \n`MMMMMMMMM \n MM      \\ \n MM        \n MM    ,   \n MMMMMMM   \n MM    `   \n MM        \n MM        \n MM      / \n_MMMMMMMMM \n           \n           \n           \n',
    'I': u"    \n    \n____\n`MM'\n MM \n MM \n MM \n MM \n MM \n MM \n MM \n MM \n_MM_\n    \n    \n    \n",
    'M': u"             \n             \n___       ___\n`MMb     dMM'\n MMM.   ,PMM \n M`Mb   d'MM \n M YM. ,P MM \n M `Mb d' MM \n M  YM.P  MM \n M  `Mb'  MM \n M   YP   MM \n M   `'   MM \n_M_      _MM_\n             \n             \n             \n",
    'Q': u'           \n           \n   ____    \n  6MMMMb   \n 8P    Y8  \n6M      Mb \nMM      MM \nMM      MM \nMM      MM \nMM      MM \nYM      M9 \n 8b    d8  \n  YMMMM9   \n    MM     \n    YM.    \n     `Mo   \n',
    'U': u"            \n            \n____     ___\n`MM'     `M'\n MM       M \n MM       M \n MM       M \n MM       M \n MM       M \n MM       M \n YM       M \n  8b     d8 \n   YMMMMM9  \n            \n            \n            \n",
    'Y': u"             \n             \n____     ___ \n`MM(     )M' \n `MM.    d'  \n  `MM.  d'   \n   `MM d'    \n    `MM'     \n     MM      \n     MM      \n     MM      \n     MM      \n    _MM_     \n             \n             \n             \n",
    ']': u'     \n     \nMMMM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \n  MM \nMMMM \n',
    'a': u"          \n          \n          \n          \n          \n   ___    \n 6MMMMb   \n8M'  `Mb  \n    ,oMM  \n,6MM9'MM  \nMM'   MM  \nMM.  ,MM  \n`YMMM9'Yb.\n          \n          \n          \n",
    'e': u"         \n         \n         \n         \n         \n  ____   \n 6MMMMb  \n6M'  `Mb \nMM    MM \nMMMMMMMM \nMM       \nYM    d9 \n YMMMM9  \n         \n         \n         \n",
    'i': u'    \n    \n    \n68b \nY89 \n___ \n`MM \n MM \n MM \n MM \n MM \n MM \n_MM_\n    \n    \n    \n',
    'm': u"                \n                \n                \n                \n                \n___  __    __   \n`MM 6MMb  6MMb  \n MM69 `MM69 `Mb \n MM'   MM'   MM \n MM    MM    MM \n MM    MM    MM \n MM    MM    MM \n_MM_  _MM_  _MM_\n                \n                \n                \n",
    'q': u"         \n         \n         \n         \n         \n  ____   \n 6MMMMb/ \n6M'  `MM \nMM    MM \nMM    MM \nMM    MM \nYM.  ,MM \n YMMMM9M \n      MM \n      MM \n     _MM_\n",
    'u': u'          \n          \n          \n          \n          \n___   ___ \n`MM    MM \n MM    MM \n MM    MM \n MM    MM \n MM    MM \n YM.   MM \n  YMMM9MM_\n          \n          \n          \n',
    'y': u"            \n            \n            \n            \n            \n____    ___ \n`MM(    )M' \n `Mb    d'  \n  YM.  ,P   \n   MM  M    \n   `Mbd'    \n    YMP     \n     M      \n    d'      \n(8),P       \n YMM        \n",
    '}': u"      \n      \n`b.   \n  Mb  \n  MM  \n  MM  \n  MM  \n  YM  \n   `b.\n   ,6'\n  6M  \n  MM  \n  MM  \n  MM  \n  M9  \n,6'   \n"}

georgia11_dic = {
    ' ': u'    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n',
    '$': u'           \n    M      \n ,,,M..    \n\'P  M `db, \n8m._M  `"\' \n`YMMM._    \n   `MYMMb, \nM   M  .M8 \nYbmmMmd9\'  \n    M      \n           \n',
    '(': u"      \n    ..\n  pd' \n 6P   \n6M'   \nMN    \nMN    \nYM.   \n Mb   \n  Yq. \n    ``\n",
    ',': u"    \n    \n    \n    \n    \n    \n    \n ,, \n dg \n ,j \n,'  \n",
    '0': u'           \n           \n           \n           \n ,pP""Yq.  \n6W\'    `Wb \n8M      M8 \nYA.    ,A9 \n `Ybmmd9\'  \n           \n           \n',
    '4': u"           \n           \n           \n           \n     ,AM   \n    AVMM   \n  ,W' MM   \n,W'   MM   \nAmmmmmMMmm \n      MM   \n      MM   \n",
    '8': u'          \n          \n ,6*"*VA. \ndN     V8 \n`MN.  ,g9 \n ,MMMMq.  \n6P   `YMb \n8b    `M9 \n`MmmmmM9  \n          \n          \n',
    '<': u"          \n          \n          \n     ,;//'\n  ,;//'   \n,//'      \n`\\\\.      \n   `\\\\:.  \n      `\\\\.\n          \n          \n",
    '@': u'                 \n                 \n     ,.-==-.     \n  ,pd\'      `g.  \n ,P   ,dMb.A  Y. \n,P   dP  ,MP  j8 \n8:  dM\'  dM   d\' \nWb  YML.dML..d\'  \n Wb  ``""^`"\'    \n  `M..     .,!   \n    `Ybmmd\'      \n',
    'D': u'             \n             \n`7MM"""Yb.   \n  MM    `Yb. \n  MM     `Mb \n  MM      MM \n  MM     ,MP \n  MM    ,dP\' \n.JMMmmmdP\'   \n             \n             \n',
    'H': u"              \n              \n`7MMF'  `7MMF'\n  MM      MM  \n  MM      MM  \n  MMmmmmmmMM  \n  MM      MM  \n  MM      MM  \n.JMML.  .JMML.\n              \n              \n",
    'L': u"            \n            \n`7MMF'      \n  MM        \n  MM        \n  MM        \n  MM      , \n  MM     ,M \n.JMMmmmmMMM \n            \n            \n",
    'P': u'           \n           \n`7MM"""Mq. \n  MM   `MM.\n  MM   ,M9 \n  MMmmdM9  \n  MM       \n  MM       \n.JMML.     \n           \n           \n',
    'T': u'             \n             \nMMP""MM""YMM \nP\'   MM   `7 \n     MM      \n     MM      \n     MM      \n     MM      \n   .JMML.    \n             \n             \n',
    'X': u"             \n             \n`YMM'   `MP' \n  VMb.  ,P   \n   `MM.M'    \n     MMb     \n   ,M'`Mb.   \n  ,P   `MM.  \n.MM:.  .:MMa.\n             \n             \n",
    '\\': u'         \nVM       \n MA      \n `M.     \n  VM     \n   MA    \n   `M.   \n    VM   \n     MA  \n     `M. \n      VM \n',
    '`': u'   \n ,\'\n;\' \nbg \n"" \n   \n   \n   \n   \n   \n   \n',
    'd': u'           \n       ,,  \n     `7MM  \n       MM  \n  ,M""bMM  \n,AP    MM  \n8MI    MM  \n`Mb    MM  \n `Wbmd"MML.\n           \n           \n',
    'h': u'            \n  ,,        \n`7MM        \n  MM        \n  MMpMMMb.  \n  MM    MM  \n  MM    MM  \n  MM    MM  \n.JMML  JMML.\n            \n            \n',
    'l': u'      \n  ,,  \n`7MM  \n  MM  \n  MM  \n  MM  \n  MM  \n  MM  \n.JMML.\n      \n      \n',
    'p': u"           \n           \n           \n           \n`7MMpdMAo. \n  MM   `Wb \n  MM    M8 \n  MM   ,AP \n  MMbmmd'  \n  MM       \n.JMML.     \n",
    't': u'        \n        \n  mm    \n  MM    \nmmMMmm  \n  MM    \n  MM    \n  MM    \n  `Mbmo \n        \n        \n',
    'x': u"           \n           \n           \n           \n`7M'   `MF'\n  `VA ,V'  \n    XMX    \n  ,V' VA.  \n.AM.   .MA.\n           \n           \n",
    '|': u'   \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \nMM \n',
    '#': u"           \n           \n    ,M' dP \n    dP .M' \n mmmMmmMmm \n   MP dP   \nmmdMmmMmmm \n ,M' dP    \n dP ,M'    \n           \n           \n",
    "'": u"   \ngp \n\\/ \n`' \n   \n   \n   \n   \n   \n   \n   \n",
    '+': u'          \n          \n          \n          \n    M     \n    M     \nmmmmMmmmm \n    M     \n    M     \n          \n          \n',
    '/': u"         \n      AW \n     ,M' \n     MV  \n    AW   \n   ,M'   \n   MV    \n  AW     \n ,M'     \n MV      \nAW       \n",
    '3': u'         \n         \n         \n         \n pd""b.  \n(O)  `8b \n     ,89 \n   ""Yb. \n      88 \n(O)  .M\' \n bmmmd\'  \n',
    '7': u"          \n          \n          \n          \nM******A' \nY     A'  \n     A'   \n    A'    \n   A'     \n  A'      \n A'       \n",
    ';': u'    \n    \n    \n    \n gp \n "" \n    \n ,, \n dg \n ,j \n,\'  \n',
    '?': u'         \n         \n,M"""b.  \n89\'  `Mg \n     ,M9 \n  mMMY\'  \n  MM     \n  ,,     \n  db     \n         \n         \n',
    'C': u'            \n            \n  .g8"""bgd \n.dP\'     `M \ndM\'       ` \nMM          \nMM.         \n`Mb.     ,\' \n  `"bmmmd\'  \n            \n            \n',
    'G': u'             \n             \n  .g8"""bgd  \n.dP\'     `M  \ndM\'       `  \nMM           \nMM.    `7MMF\'\n`Mb.     MM  \n  `"bmmmdPY  \n             \n             \n',
    'K': u'             \n             \n`7MMF\' `YMM\' \n  MM   .M\'   \n  MM .d"     \n  MMMMM.     \n  MM  VMA    \n  MM   `MM.  \n.JMML.   MMb.\n             \n             \n',
    'O': u'             \n             \n  .g8""8q.   \n.dP\'    `YM. \ndM\'      `MM \nMM        MM \nMM.      ,MP \n`Mb.    ,dP\' \n  `"bmmd"\'   \n             \n             \n',
    'S': u'          \n          \n .M"""bgd \n,MI    "Y \n`MMb.     \n  `YMMNq. \n.     `MM \nMb     dM \nP"Ybmmd"  \n          \n          \n',
    'W': u"                      \n                      \n`7MMF'     A     `7MF'\n  `MA     ,MA     ,V  \n   VM:   ,VVM:   ,V   \n    MM.  M' MM.  M'   \n    `MM A'  `MM A'    \n     :MM;    :MM;     \n      VF      VF      \n                      \n                      \n",
    '[': u'      \nmmmmm \nMM    \nMM    \nMM    \nMM    \nMM    \nMM    \nMM    \nMM    \nMMmmm \n',
    '_': u'        \n        \n        \n        \n        \n        \n        \n        \n        \n        \nmmmmmmm \n',
    'c': u'         \n         \n         \n         \n ,p6"bo  \n6M\'  OO  \n8M       \nYM.    , \n YMbmd\'  \n         \n         \n',
    'g': u'          \n          \n          \n          \n .P"Ybmmm \n:MI  I8   \n WmmmP"   \n8M        \n YMMMMMb  \n6\'     dP \nYbmmmd\'   \n',
    'k': u"          \n          \n`7MM      \n  MM      \n  MM  ,MP'\n  MM ;Y   \n  MM;Mm   \n  MM `Mb. \n.JMML. YA.\n          \n          \n",
    'o': u'          \n          \n          \n          \n ,pW"Wq.  \n6W\'   `Wb \n8M     M8 \nYA.   ,A9 \n `Ybmd9\'  \n          \n          \n',
    's': u'        \n        \n        \n        \n,pP"Ybd \n8I   `" \n`YMMMa. \nL.   I8 \nM9mmmP\' \n        \n        \n',
    'w': u"                  \n                  \n                  \n                  \n`7M'    ,A    `MF'\n  VA   ,VAA   ,V  \n   VA ,V  VA ,V   \n    VVV    VVV    \n     W      W     \n                  \n                  \n",
    '{': u'        \n    ,pm \n   6M   \n   MM   \n   M9   \n_.d"\'   \n`"bp.   \n   Mb   \n   MM   \n   YM   \n    `bm \n',
    '"': u"       \ngp  gp \n\\/  \\/ \n`'  `' \n       \n       \n       \n       \n       \n       \n       \n",
    '&': u'              \n              \n ,gM""bg      \n 8MI  ,8      \n  WMp,"       \n ,gPMN.  jM"\' \n,M.  YMp.M\'   \n8Mp   ,MMp    \n`YMbmm\'``MMm. \n              \n              \n',
    '*': u'          \n  q   p   \n   \\ /    \no=--*--=o \n   / \\    \n  d   b   \n          \n          \n          \n          \n          \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n,, \ndb \n   \n   \n',
    '2': u'         \n         \n         \n         \n pd*"*b. \n(O)   j8 \n    ,;j9 \n ,-=\'    \nAmmmmmmm \n         \n         \n',
    '6': u'          \n          \n   .6*"   \n ,M\'      \n,Mbmmm.   \n6M\'  `Mb. \nMI     M8 \nWM.   ,M9 \n WMbmmd9  \n          \n          \n',
    ':': u'   \n   \n   \n   \ngp \n"" \n   \n,, \ndb \n   \n   \n',
    '>': u"          \n          \n          \n`\\\\.      \n   `\\\\:.  \n      `\\\\.\n     ,;//'\n  ,;//'   \n,//'      \n          \n          \n",
    'B': u'           \n           \n`7MM"""Yp, \n  MM    Yb \n  MM    dP \n  MM"""bg. \n  MM    `Y \n  MM    ,9 \n.JMMmmmd9  \n           \n           \n',
    'F': u'           \n           \n`7MM"""YMM \n  MM    `7 \n  MM   d   \n  MM""MM   \n  MM   Y   \n  MM       \n.JMML.     \n           \n           \n',
    'J': u"         \n         \n   `7MMF'\n     MM  \n     MM  \n     MM  \n     MM  \n(O)  MM  \n Ymmm9   \n         \n         \n",
    'N': u"             \n             \n`7MN.   `7MF'\n  MMN.    M  \n  M YMb   M  \n  M  `MN. M  \n  M   `MM.M  \n  M     YMM  \n.JML.    YM  \n             \n             \n",
    'R': u'            \n            \n`7MM"""Mq.  \n  MM   `MM. \n  MM   ,M9  \n  MMmmdM9   \n  MM  YM.   \n  MM   `Mb. \n.JMML. .JMM.\n            \n            \n',
    'V': u"              \n              \n`7MMF'   `7MF'\n  `MA     ,V  \n   VM:   ,V   \n    MM.  M'   \n    `MM A'    \n     :MM;     \n      VF      \n              \n              \n",
    'Z': u'          \n          \nMMM"""AMV \nM\'   AMV  \n\'   AMV   \n   AMV    \n  AMV   , \n AMV   ,M \nAMVmmmmMM \n          \n          \n',
    '^': u'      \n  /\\  \n //\\\\ \n//  \\\\\n      \n      \n      \n      \n      \n      \n      \n',
    'b': u"           \n ,,        \n*MM        \n MM        \n MM,dMMb.  \n MM    `Mb \n MM     M8 \n MM.   ,M9 \n P^YbmdP'  \n           \n           \n",
    'f': u'        \n    ,...\n  .d\' ""\n  dM`   \n mMMmm  \n  MM    \n  MM    \n  MM    \n.JMML.  \n        \n        \n',
    'j': u'      \n   ,, \n   db \n      \n `7MM \n   MM \n   MM \n   MM \n   MM \nQO MP \n`bmP  \n',
    'n': u'            \n            \n            \n            \n`7MMpMMMb.  \n  MM    MM  \n  MM    MM  \n  MM    MM  \n.JMML  JMML.\n            \n            \n',
    'r': u'         \n         \n         \n         \n`7Mb,od8 \n  MM\' "\' \n  MM     \n  MM     \n.JMML.   \n         \n         \n',
    'v': u"           \n           \n           \n           \n`7M'   `MF'\n  VA   ,V  \n   VA ,V   \n    VVV    \n     W     \n           \n           \n",
    'z': u'        \n        \n        \n        \nM"""MMV \n\'  AMV  \n  AMV   \n AMV  , \nAMMmmmM \n        \n        \n',
    '~': u'        \n        \n        \n        \n        \n ,og.  ,\n"  `6o" \n        \n        \n        \n        \n',
    '!': u"   \n   \nOO \n88 \n|| \n|| \n`' \n,, \ndb \n   \n   \n",
    '%': u'                \n                \n,M""Yg.    ,M\'  \nMY   Mb  ,M\'    \n8M. ,M9,M\'      \n `""\' ,M\',;:.   \n    ,M\',MP  Yb  \n  ,M\'  `M.  .M: \n,M\'     Ybmmd\'  \n                \n                \n',
    ')': u"       \n..     \n `bq   \n   YA  \n   `Mb \n    8M \n    8M \n   ,M9 \n   dM  \n .pY   \n''     \n",
    '-': u'      \n      \n      \n      \n      \n      \nmmmmm \n      \n      \n      \n      \n',
    '1': u'      \n      \n      \n __,  \n`7MM  \n  MM  \n  MM  \n  MM  \n.JMML.\n      \n      \n',
    '5': u'         \n         \n         \n         \n M****** \n.M       \n|bMMAg.  \n     `Mb \n      jM \n(O)  ,M9 \n 6mmm9   \n',
    '9': u'          \n          \n          \n          \n .d*"*bg. \n6MP    Mb \nYMb    MM \n `MbmmdM9 \n      .M\' \n    .d9   \n  m"\'     \n',
    '=': u'          \n          \n          \n          \n          \nmmmmmmmmm \n          \nmmmmmmmmm \n          \n          \n          \n',
    'A': u"              \n              \n      db      \n     ;MM:     \n    ,V^MM.    \n   ,M  `MM    \n   AbmmmqMA   \n  A'     VML  \n.AMA.   .AMMA.\n              \n              \n",
    'E': u'            \n            \n`7MM"""YMM  \n  MM    `7  \n  MM   d    \n  MMmmMM    \n  MM   Y  , \n  MM     ,M \n.JMMmmmmMMM \n            \n            \n',
    'I': u"      \n      \n`7MMF'\n  MM  \n  MM  \n  MM  \n  MM  \n  MM  \n.JMML.\n      \n      \n",
    'M': u"                \n                \n`7MMM.     ,MMF'\n  MMMb    dPMM  \n  M YM   ,M MM  \n  M  Mb  M' MM  \n  M  YM.P'  MM  \n  M  `YM'   MM  \n.JML. `'  .JMML.\n                \n                \n",
    'Q': u'             \n             \n  .g8""8q.   \n.dP\'    `YM. \ndM\'      `MM \nMM        MM \nMM.      ,MP \n`Mb.    ,dP\' \n  `"bmmd"\'   \n      MMb    \n       `bood\'\n',
    'U': u'              \n              \n`7MMF\'   `7MF\'\n  MM       M  \n  MM       M  \n  MM       M  \n  MM       M  \n  YM.     ,M  \n   `bmmmmd"\'  \n              \n              \n',
    'Y': u"            \n            \n`YMM'   `MM'\n  VMA   ,V  \n   VMA ,V   \n    VMMP    \n     MM     \n     MM     \n   .JMML.   \n            \n            \n",
    ']': u'      \nmmmmm \n   MM \n   MM \n   MM \n   MM \n   MM \n   MM \n   MM \n   MM \nmmmMM \n',
    'a': u'         \n         \n         \n         \n ,6"Yb.  \n8)   MM  \n ,pm9MM  \n8M   MM  \n`Moo9^Yo.\n         \n         \n',
    'e': u'         \n         \n         \n         \n .gP"Ya  \n,M\'   Yb \n8M"""""" \nYM.    , \n `Mbmmd\' \n         \n         \n',
    'i': u'      \n  ,,  \n  db  \n      \n`7MM  \n  MM  \n  MM  \n  MM  \n.JMML.\n      \n      \n',
    'm': u'                  \n                  \n                  \n                  \n`7MMpMMMb.pMMMb.  \n  MM    MM    MM  \n  MM    MM    MM  \n  MM    MM    MM  \n.JMML  JMML  JMML.\n                  \n                  \n',
    'q': u'          \n          \n          \n          \n ,dW"Yvd  \n,W\'   MM  \n8M    MM  \nYA.   MM  \n `MbmdMM  \n      MM  \n    .JMML.\n',
    'u': u'            \n            \n            \n            \n`7MM  `7MM  \n  MM    MM  \n  MM    MM  \n  MM    MM  \n  `Mbod"YML.\n            \n            \n',
    'y': u'           \n           \n           \n           \n`7M\'   `MF\'\n  VA   ,V  \n   VA ,V   \n    VVV    \n    ,V     \n   ,V      \nOOb"       \n',
    '}': u'       \nmq.    \n  Mb   \n  MM   \n  YM   \n  `"b._\n  ,qd"\'\n  6M   \n  MM   \n  M9   \nmd\'    \n'}

ghost_dic = {
    '!': u",---. \n|   | \n|   | \n|   | \n|   | \n|  .' \n`--'  \n.--.  \n'--'  \n",
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u"             \n   ,-. ,-.   \n   | | | |   \n,--| |-| |--.\n'--| |-| |--'\n'--| |-| |--'\n   | | | |   \n   `-' `-'   \n             \n",
    '"': u"         \n,--.,--. \n\\  |\\  | \n `-' `-' \n         \n         \n         \n         \n         \n",
    '%': u"      ,-. \n ,--. / / \n '--'/ /  \n    / /   \n   / /    \n  / /     \n / / ,--. \n/ /  '--' \n`-'       \n",
    '$': u"   ,-.    \n .-| |-.  \n|  | |_/  \n\\  | |.   \n '-| | '. \n.- | |  | \n| `| |  / \n `-| |'`  \n   `-'    \n",
    "'": u"     \n,--. \n\\  | \n `-' \n     \n     \n     \n     \n     \n",
    '&': u"             \n .-----.     \n/  .-.  \\    \n|  \\_.' /    \n/  .-. ',-.  \n| |   | . /_ \n\\  '-'  _.__)\n `----''     \n             \n",
    ')': u",-.   \n|  \\  \n'.  ' \n |  | \n |  | \n |  | \n.'  ' \n|  /  \n`-'   \n",
    '(': u"  ,-. \n /  | \n'  .' \n|  |  \n|  |  \n|  |  \n'  '. \n \\  | \n  `-' \n",
    '+': u"            \n            \n    ,-.     \n    | |     \n,---| |---. \n'---| |---' \n    | |     \n    `-'     \n            \n",
    '*': u"            \n    .-.     \n .-,| |,-.  \n _\\ ' ' /_  \n(__     __) \n  / . . \\   \n `-'| |`-'  \n    `-'     \n            \n",
    '-': u"          \n          \n          \n          \n          \n  (`-.    \n (OO  )_  \n,------.) \n`------'  \n",
    ',': u"    \n    \n    \n    \n    \n    \n    \n.-. \n',/ \n",
    '/': u"      ,-. \n      / / \n     / /  \n    / /   \n   / /    \n  / /     \n / /      \n/ /       \n`-'       \n",
    '.': u"    \n    \n    \n    \n    \n    \n    \n.-. \n`-' \n",
    '1': u"       \n       \n .---. \n/_   | \n |   | \n |   | \n |   | \n |   | \n `---' \n",
    '0': u"           \n           \n  .----.   \n /  ..  \\  \n.  /  \\  . \n|  |  '  | \n'  \\  /  ' \n \\  `'  /  \n  `---''   \n",
    '3': u"          \n          \n .-----.  \n/  -.   \\ \n'-' _'  | \n   |_  <  \n.-.  |  | \n\\ `-'   / \n `----''  \n",
    '2': u"          \n          \n .-----.  \n/ ,-.   \\ \n'-'  |  | \n   .'  /  \n .'  /__  \n|       | \n`-------' \n",
    '5': u"          \n          \n.------.  \n|   ___|  \n|  '--.   \n`---.  '. \n.-   |  | \n| `-'   / \n `----''  \n",
    '4': u"            \n            \n    .---.   \n   / .  |   \n  / /|  |   \n / / |  |_  \n/  '-'    | \n`----|  |-' \n     `--'   \n",
    '7': u"           \n           \n.--------. \n|   __   ' \n`--' .  /  \n    /  /   \n   .  /    \n  /  /     \n `--'      \n",
    '6': u"          \n          \n  ,--.    \n /  .'    \n.  / -.   \n| .-.  '  \n' \\  |  | \n\\  `'  /  \n `----'   \n",
    '9': u"           \n           \n  .----.   \n /  ,.  \\  \n|  |  \\  | \n '  `-'  ' \n  `- /  '  \n   ,'  /   \n  `---'    \n",
    '8': u"            \n            \n  .-----.   \n /  .-.  \\  \n|   \\_.' /  \n /  .-. '.  \n|  |   |  | \n \\  '-'  /  \n  `----''   \n",
    ';': u"    \n    \n.-. \n'-' \n    \n.-. \n',/ \n    \n    \n",
    ':': u"    \n    \n.-. \n`-' \n    \n.-. \n`-' \n    \n    \n",
    '=': u"        \n        \n,-----. \n'-----' \n        \n,-----. \n'-----' \n        \n        \n",
    '<': u"       \n   ,-. \n  / /  \n / /   \n/ /    \n\\ \\    \n \\ \\   \n  \\ \\  \n   `-' \n",
    '?': u" ,------.  \n'  .--.  ' \n|  |  |  | \n'--'  |  | \n    __.  | \n   |   .'  \n   |___|   \n   .---.   \n   '---'   \n",
    '>': u"       \n,-.    \n \\ \\   \n  \\ \\  \n   \\ \\ \n   / / \n  / /  \n / /   \n`-'    \n",
    '@': u"          \n          \n   ____   \n .' __ \\  \n/ .'  \\ | \n| | (_/ | \n\\ `.__.'\\ \n `.___ .' \n          \n",
    '[': u",----. \n|    | \n|  .-' \n|  |   \n|  |   \n|  |   \n|  '-. \n|    | \n`----' \n",
    ']': u",----. \n|    | \n`-.  | \n  |  | \n  |  | \n  |  | \n.-'  | \n|    | \n`----' \n",
    '\\': u",-.       \n\\ \\       \n \\ \\      \n  \\ \\     \n   \\ \\    \n    \\ \\   \n     \\ \\  \n      \\ \\ \n      `-' \n",
    '_': u"          \n          \n          \n   .-')   \n _(  OO)  \n(,------. \n '------' \n          \n          \n",
    '^': u"          \n          \n  ,---.   \n /  \\  \\  \n`--' `--' \n          \n          \n          \n          \n",
    'a': u"   ('-.     \n  ( OO ).-. \n  / . --. / \n  | \\-.  \\  \n.-'-'  |  | \n \\| |_.'  | \n  |  .-.  | \n  |  | |  | \n  `--' `--' \n",
    '`': u"       \n       \n,--.   \n'.  \\  \n  `--' \n       \n       \n       \n       \n",
    'c': u"            \n            \n   .-----.  \n  '  .--./  \n  |  |('-.  \n /_) |OO  ) \n ||  |`-'|  \n(_'  '--'\\  \n   `-----'  \n",
    'b': u".-. .-')   \n\\  ( OO )  \n ;-----.\\  \n | .-.  |  \n | '-' /_) \n | .-. `.  \n | |  \\  | \n | '--'  / \n `------'  \n",
    'e': u"   ('-.   \n _(  OO)  \n(,------. \n |  .---' \n |  |     \n(|  '--.  \n |  .--'  \n |  `---. \n `------' \n",
    'd': u" _ .-') _   \n( (  OO) )  \n \\     .'_  \n ,`'--..._) \n |  |  \\  ' \n |  |   ' | \n |  |   / : \n |  '--'  / \n `-------'  \n",
    'g': u"             \n             \n  ,----.     \n '  .-./-')  \n |  |_( O- ) \n |  | .--, \\ \n(|  | '. (_/ \n |  '--'  |  \n  `------'   \n",
    'f': u"            \n            \n   ,------. \n('-| _.---' \n(OO|(_\\     \n/  |  '--.  \n\\_)|  .--'  \n  \\|  |_)   \n   `--'     \n",
    'i': u"          \n          \n  ,-.-')  \n  |  |OO) \n  |  |  \\ \n  |  |(_/ \n ,|  |_.' \n(_|  |    \n  `--'    \n",
    'h': u" ('-. .-. \n( OO )  / \n,--. ,--. \n|  | |  | \n|   .|  | \n|       | \n|  .-.  | \n|  | |  | \n`--' `--' \n",
    'k': u".-. .-')   \n\\  ( OO )  \n,--. ,--.  \n|  .'   /  \n|      /,  \n|     ' _) \n|  .   \\   \n|  |\\   \\  \n`--' '--'  \n",
    'j': u"          \n          \n     ,--. \n .-')| ,| \n( OO |(_| \n| `-'|  | \n,--. |  | \n|  '-'  / \n `-----'  \n",
    'm': u" _   .-')    \n( '.( OO )_  \n ,--.   ,--.)\n |   `.'   | \n |         | \n |  |'.'|  | \n |  |   |  | \n |  |   |  | \n `--'   `--' \n",
    'l': u"           \n           \n ,--.      \n |  |.-')  \n |  | OO ) \n |  |`-' | \n(|  '---.' \n |      |  \n `------'  \n",
    'o': u"             \n             \n .-'),-----. \n( OO'  .-.  '\n/   |  | |  |\n\\_) |  |\\|  |\n  \\ |  | |  |\n   `'  '-'  '\n     `-----' \n",
    'n': u"     .-') _  \n    ( OO ) ) \n,--./ ,--,'  \n|   \\ |  |\\  \n|    \\|  | ) \n|  .     |/  \n|  |\\    |   \n|  | \\   |   \n`--'  `--'   \n",
    'q': u"     .-')    \n   .(  OO)   \n  (_)---\\_)  \n  '  .-.  '  \n ,|  | |  |  \n(_|  | |  |  \n  |  | |  |  \n  '  '-'  '-.\n   `-----'--'\n",
    'p': u"   _ (`-.  \n  ( (OO  ) \n _.`     \\ \n(__...--'' \n |  /  | | \n |  |_.' | \n |  .___.' \n |  |      \n `--'      \n",
    's': u"  .-')    \n ( OO ).  \n(_)---\\_) \n/    _ |  \n\\  :` `.  \n '..`''.) \n.-._)   \\ \n\\       / \n `-----'  \n",
    'r': u" _  .-')   \n( \\( -O )  \n ,------.  \n |   /`. ' \n |  /  | | \n |  |_.' | \n |  .  '.' \n |  |\\  \\  \n `--' '--' \n",
    'u': u"             \n             \n ,--. ,--.   \n |  | |  |   \n |  | | .-') \n |  |_|( OO )\n |  | | `-' /\n('  '-'(_.-' \n  `-----'    \n",
    't': u" .-') _    \n(  OO) )   \n/     '._  \n|'--...__) \n'--.  .--' \n   |  |    \n   |  |    \n   |  |    \n   `--'    \n",
    'w': u"  (`\\ .-') /`\n   `.( OO ),'\n,--./  .--.  \n|      |  |  \n|  |   |  |, \n|  |.'.|  |_)\n|         |  \n|   ,'.   |  \n'--'   '--'  \n",
    'v': u"      (`-.   \n    _(OO  )_ \n,--(_/   ,. \\\n\\   \\   /(__/\n \\   \\ /   / \n  \\   '   /, \n   \\     /__)\n    \\   /    \n     `-'     \n",
    'y': u"             \n             \n  ,--.   ,--.\n   \\  `.'  / \n .-')     /  \n(OO  \\   /   \n |   /  /\\_  \n `-./  /.__) \n   `--'      \n",
    'x': u") (`-.      \n ( OO ).    \n(_/.  \\_)-. \n \\  `.'  /  \n  \\     /\\  \n   \\   \\ |  \n  .'    \\_) \n /  .'.  \\  \n'--'   '--' \n",
    '{': u"   ,--. \n  |   | \n  |  .' \n .'  /  \n<   <   \n `.  \\  \n  |  '. \n  |   | \n   `--' \n",
    'z': u"   .-') _  \n  (  OO) ) \n,(_)----.  \n|       |  \n'--.   /   \n(_/   /    \n /   /___  \n|        | \n`--------' \n",
    '}': u",--.    \n|   |   \n'.  |   \n  \\  `  \n   >  > \n  /  .  \n.'  |   \n|   |   \n`--'    \n",
    '|': u",-. \n| | \n| | \n| | \n| | \n| | \n| | \n| | \n`-' \n",
    '~': u"           \n      .--, \n  .--'  /  \n /  ---`   \n`--'       \n           \n           \n           \n           \n"}

ghoulish_dic = {
    '!': u'.`(   \n\\_ )  \n  )\\  \n  \\(  \n   _  \n  `.( \n      \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u" _  _  \n).').' \n       \n       \n       \n       \n       \n",
    '%': u'%\n \n \n \n \n \n \n',
    '$': u" )\\.-.    \n(  ,_.'   \n `-.`-.   \n .'/_\\ \\  \n '.__,  ) \n      \\(  \n          \n",
    "'": u"'\n \n \n \n \n \n \n",
    '&': u'&\n \n \n \n \n \n \n',
    ')': u'.`(   \n\\  )  \n \\ (  \n (Oo) \n / (  \n/  )  \n`.(   \n',
    '(': u"  )'. \n (  / \n ) /  \n(oO)  \n ) \\  \n (  \\ \n  ).' \n",
    '+': u"   )`.   \n  (  /   \n.-    -. \n'-    -' \n  /  )   \n  '.(    \n         \n",
    '*': u'*\n \n \n \n \n \n \n',
    '-': u"           \n /(        \n ) \\/(.-,, \n(      _  )\n `._.-' \\( \n           \n           \n",
    ',': u"     \n     \n     \n _)/ \n/  ) \n'.(  \n     \n",
    '/': u'  )\\  \n  \\ ) \n  //  \n ((   \n //   \n/(    \n)/    \n',
    '.': u"     \n     \n     \n ,_  \n(  \\ \n ).' \n     \n",
    '1': u" .'(    \n/_  )   \n ) (    \n \\  )   \n _) \\_  \n)__,__/ \n        \n",
    '0': u'  ,,-,,   \n /,--, \\  \n/ \\  (  \\ \n\\  )  \\ / \n \\ `--`(  \n  ``-`)/  \n          \n',
    '3': u" .---./(  \n(_.-,   ) \n  ,-`  /  \n _'-, (   \n )`-'  )  \n `._..(   \n          \n",
    '2': u".```./(  \n)_,-,  ) \n .-'.-'  \n( (.-.,  \n/      ) \n)/`._.'  \n         \n",
    '5': u"  )\\.--. \n (   ._. \n  `-.`.  \n,_   \\ \\ \n) '.,/ / \n'._,_.'  \n         \n",
    '4': u"  .'`(  \n //`. ) \n//__/(  \n`--,  ) \n    ) \\ \n     )/ \n        \n",
    '7': u".```./(  \n)_,-,  ) \n    / (  \n   _) /  \n  /  /   \n  './    \n         \n",
    '6': u" )`.     \n(  ( _   \n ) `' `. \n(  .-. ( \n `. -  / \n   \\,-'  \n         \n",
    '9': u" .-'\\    \n/  _ `,  \n) `-`  ) \n`._., (  \n    `  ) \n     \\(  \n         \n",
    '8': u"   ,-,-.  \n ,' _   ) \n(  '-' (  \n )  _   ) \n(  '-' /  \n )/._.'   \n          \n",
    ';': u"   _  \n  ).' \n      \n _)/  \n/  )  \n'.(   \n      \n",
    ':': u".'(  \n\\_ ) \n     \n _   \n/  ) \n'.(  \n     \n",
    '=': u" ,,-.      \n(    `-._  \n `._.-._.' \n     .-,,  \n _.-'    ) \n`._.-._.'  \n           \n",
    '<': u'     \n     \n/(_  \n) _( \n\\(   \n     \n     \n',
    '?': u" .```./(  \n(  ,-,  ) \n `-` / /  \n     )/   \n    _     \n   ).'    \n          \n",
    '>': u'     \n     \n _)\\ \n)_ ( \n  )/ \n     \n     \n',
    '@': u'@\n \n \n \n \n \n \n',
    '[': u"  )'. \n ( _/ \n /(   \n<  >  \n \\(_  \n (  \\ \n  ).' \n",
    ']': u".'(   \n\\_ )  \n  )\\  \n <  > \n _)/  \n/  )  \n'.(   \n",
    '\\': u' /(   \n( /   \n \\\\   \n  ))  \n  \\\\  \n   )\\ \n   \\( \n',
    '_': u"           \n        )\\ \n ,,-.)\\/ ( \n(  _      )\n )/ `-._.' \n           \n           \n",
    '^': u'  )\\   \n /_ \\  \n/ )\\ \\ \n\\(  )/ \n       \n       \n       \n',
    'a': u"   /`-.   \n ,' _  \\  \n(  '-' (  \n )   _  ) \n(  ,' ) \\ \n )/    )/ \n          \n",
    '`': u'`\n \n \n \n \n \n \n',
    'c': u"   )\\.-.  \n ,' ,-,_) \n(  .   _  \n ) '..' ) \n(  ,   (  \n )/'._.'  \n          \n",
    'b': u"   /(,-.  \n ,' _   ) \n(  '-' (  \n )  _   ) \n(  '-' /  \n )/._.'   \n          \n",
    'e': u" )\\.---.  \n(   ,-._( \n \\  '-,   \n  ) ,-`   \n (  ``-.  \n  )..-.(  \n          \n",
    'd': u"   )\\.-.  \n ,'     ) \n(  .-, (  \n ) '._\\ ) \n(  ,   (  \n )/ ._.'  \n          \n",
    'g': u"   )\\.-.   \n ,' ,-,_)  \n(  .   __  \n ) '._\\ _) \n(  ,   (   \n )/'._.'   \n           \n",
    'f': u")`-.--. \n) ,-._( \n\\ `-._  \n ) ,_(  \n(  \\    \n ).'    \n        \n",
    'i': u".'(  \n\\  ) \n) (  \n\\  ) \n ) \\ \n  )/ \n     \n",
    'h': u"     .'(  \n ,') \\  ) \n(  '-' (  \n ) .-.  ) \n(  ,  ) \\ \n )/    )/ \n          \n",
    'k': u"    .'(  \n ,')\\  ) \n(  '/ /  \n )   (   \n(  .\\ \\  \n )/  )/  \n         \n",
    'j': u"  .-,.-.,-.\n  ).-, ,-.(\n      ))   \n .-._((    \n(      )   \n '._.\\(    \n           \n",
    'm': u" )\\   )\\  \n(  ',/ /  \n )    (   \n(  \\(\\ \\  \n `.) /  ) \n     '.(  \n          \n",
    'l': u" .')      \n( /       \n ))       \n )'._.-.  \n(       ) \n )/,__.'  \n          \n",
    'o': u"   .-./(  \n ,'     ) \n(  .-, (  \n ) '._\\ ) \n(  ,   (  \n )/ ._.'  \n          \n",
    'n': u" )\\  )\\  \n(  \\, /  \n ) \\ (   \n( ( \\ \\  \n `.)/  ) \n    '.(  \n         \n",
    'q': u"  ,.-.    \n /    `,  \n ) ,-.  ) \n( /_.` (  \n )   ,  ) \n '._. \\(  \n          \n",
    'p': u"   /`-.  \n ,' _  \\ \n(  '-' ( \n ) ,._.' \n(  '     \n )/      \n         \n",
    's': u"  )\\.--.  \n (   ._.' \n  `-.`.   \n ,_ (  \\  \n(  '.)  ) \n '._,_.'  \n          \n",
    'r': u"   /`-.  \n ,' _  \\ \n(  '-' ( \n ) ,_ .' \n(  ' ) \\ \n )/   )/ \n         \n",
    'u': u"     .-.  \n ,'  /  ) \n(  ) | (  \n ) '._\\ ) \n(  ,   (  \n )/ ._.'  \n          \n",
    't': u'.-,.-.,-. \n) ,, ,. ( \n\\( |(  )/ \n   ) \\    \n   \\ (    \n    )/    \n          \n',
    'w': u"     .'(  \n ,') \\  ) \n(  /(/ /  \n )    (   \n(  .'\\ \\  \n )/   )/  \n          \n",
    'v': u"     .-.  \n ,'  /  ) \n(  ) | (  \n ) './ /  \n(  ,  (   \n )/..'    \n          \n",
    'y': u")\\    /( \n\\ (_.' / \n )  _.'  \n / /     \n(  \\     \n ).'     \n         \n",
    'x': u"     .'(  \n ,') \\  ) \n(  '/  /  \n )     )  \n(  .'\\ \\  \n )/   )/  \n          \n",
    '{': u'  )\\ \n ( / \n /(  \n<  > \n \\(  \n ( \\ \n  )/ \n',
    'z': u".```./(    \n)_,-,  )   \n    / / _  \n   / `-` ) \n  (     (  \n   ).',,'  \n           \n",
    '}': u'/(   \n\\ )  \n )\\  \n<  > \n )/  \n/ )  \n\\(   \n',
    '|': u'|\n \n \n \n \n \n \n',
    '~': u'~\n \n \n \n \n \n \n'}

glenyn_dic = {
    '!': u'___  \n|  \\ \n|___\\\n|__/ \n',
    ' ': u'  \n  \n  \n  \n',
    '#': u"_||| \n|_'_]\n|_'_]\n ||| \n",
    '"': u'_ _  \n\\|\\| \n     \n     \n',
    '%': u'__   \n\\ \\[\\\n \\ \\ \n|]\\/ \n',
    '$': u" ||  \n,||= \n'||=,\n=||' \n",
    "'": u'  _  \n  |/ \n     \n     \n',
    '&': u'___  \n| .\\ \n/ .(/\n\\__/\\\n',
    ')': u' __  \n \\ | \n  \\| \n  /| \n',
    '(': u' ___ \n | / \n |/  \n |\\  \n',
    '+': u' __  \n_| | \n|_ _]\n |_| \n',
    '*': u'     \n \\||/\n|_  ]\n /||\\\n',
    '-': u'     \n ___ \n|___\\\n     \n',
    ',': u"     \n     \n ,-. \n '-/ \n",
    '/': u'   __\n  / /\n / / \n/_/  \n',
    '.': u"     \n     \n ,-. \n '-' \n",
    '1': u'   __\n  / |\n /_ |\n   \\|\n',
    '0': u'____ \n|   |\n| \\ |\n|___|\n',
    '3': u'____ \n|__ \\\n _[ |\n|___/\n',
    '2': u"____ \n|   \\\n'-'_/\n|___]\n",
    '5': u'____ \n| __|\n_\\_ \\\n|___/\n',
    '4': u'  _  \n / / \n/_  ]\n  |/ \n',
    '7': u'____ \n|__ |\n  / /\n /_/ \n',
    '6': u'____ \n| __\\\n|  .\\\n|___/\n',
    '9': u'____ \n| . \\\n|__ |\n \\__/\n',
    '8': u'____ \n| . /\n >.< \n|___/\n',
    ';': u" __  \n |_] \n ,-. \n '-/ \n",
    ':': u" __  \n |_] \n ,-. \n '-' \n",
    '=': u' ___ \n|___]\n|__/ \n     \n',
    '<': u' __  \n/ /  \n\\ \\  \n \\_\\ \n',
    '?': u'____ \n|   \\\n|/\\_/\n  |] \n',
    '>': u'  __ \n  \\ \\\n  / /\n /_/ \n',
    '@': u"  _  \n,'_`.\n;(_\\/\n`._, \n",
    '[': u'___  \n| _] \n||_  \n|__] \n',
    ']': u'___  \n|_ | \n _|| \n|__| \n',
    '\\': u'__   \n\\ \\  \n \\ \\ \n  \\_\\\n',
    '_': u'     \n     \n____ \n|___]\n',
    '^': u'     \n /\\  \n//\\\\ \n     \n',
    'a': u'___  \n|  \\ \n| . \\\n|/\\_/\n',
    '`': u'  _  \n  \\| \n     \n     \n',
    'c': u'____ \n| __\\\n| \\__\n|___/\n',
    'b': u'___  \n| .\\ \n| .<_\n|___/\n',
    'e': u'____ \n| __\\\n|  ]_\n|___/\n',
    'd': u'___  \n|  \\ \n| . \\\n|___/\n',
    'g': u'____ \n|  _\\\n| [ \\\n|___/\n',
    'f': u'____ \n|  _\\\n| _\\ \n|/   \n',
    'i': u'____ \n|___\\\n| /  \n|/   \n',
    'h': u'_  _ \n||_|\\\n| _ |\n|/ |/\n',
    'k': u'__ _ \n| V \\\n|  <_\n|/\\_/\n',
    'j': u'____ \n|_  \\\n,_/ /\n\\__/ \n',
    'm': u'_    \n|\\/\\ \n|   \\\n|/v\\/\n',
    'l': u'__   \n| |  \n| |__\n|___/\n',
    'o': u'____ \n|   |\n| . |\n|___/\n',
    'n': u'__   \n| \\|\\\n|  \\|\n|/\\_/\n',
    'q': u'____ \n|   |\n| . |\n|___\\\n',
    'p': u'____ \n| . \\\n| __/\n|/   \n',
    's': u'___  \n| _\\ \n[__ \\\n|___/\n',
    'r': u'____ \n| . \\\n|  <_\n|/\\_/\n',
    'u': u'_    \n|| \\ \n||_|\\\n|___/\n',
    't': u'____ \n|_ _\\\n  || \n  |/ \n',
    'w': u'_  _ \n||| \\\n||\\ /\n|/\\/ \n',
    'v': u'_  _ \n|| |\\\n||/ /\n|__/ \n',
    'y': u'_    \n||_/\\\n| __/\n|/   \n',
    'x': u'_  _ \n|\\/_\\\n_><__\n|/\\_/\n',
    '{': u'{\n \n \n \n',
    'z': u'___  \n|_ \\ \n| __]\n|___/\n',
    '}': u'}\n \n \n \n',
    '|': u' __  \n | | \n | | \n |_| \n',
    '~': u"     \n_,-.,\n|,-.'\n     \n"}

graceful_dic = {
    '!': u' _   \n/ \\  \n\\_/  \n(_)  \n',
    ' ': u'      \n      \n      \n      \n',
    '#': u' _  _ \n/ )( \\\n)    (\n\\_)(_/\n',
    '"': u' _ _ \n(/(/ \n     \n     \n',
    '%': u' _ _  \n(// ) \n / /_ \n(_/(/ \n',
    '$': u' ____ \n/ (__)\n\\__  \\\n(__)_/\n',
    "'": u' _  \n(/  \n    \n    \n',
    '&': u'  ___ \n ( _ \\\n/ _  /\n\\__\\_)\n',
    ')': u' _   \n( \\  \n ) ) \n(_/  \n',
    '(': u'  _  \n / ) \n( (  \n \\_) \n',
    '+': u'  _   \n ( )  \n(_ _) \n (_)  \n',
    '*': u'      \n(\\/\\/)\n )  ( \n(/\\/\\)\n',
    '-': u'      \n ___  \n(___) \n      \n',
    ',': u'     \n _   \n( )  \n(/   \n',
    '/': u'   _  \n  / ) \n / /  \n(_/   \n',
    '.': u'     \n     \n _   \n(_)  \n',
    '1': u'  __  \n /  \\ \n(_/ / \n (__) \n',
    '0': u'  __  \n /  \\ \n(  0 )\n \\__/ \n',
    '3': u' ____ \n( __ \\\n (__ (\n(____/\n',
    '2': u' ____ \n(___ \\\n / __/\n(____)\n',
    '5': u'  ___ \n / __)\n(___ \\\n(____/\n',
    '4': u'  ___ \n / _ \\\n(__  (\n  (__/\n',
    '7': u' ____ \n(__  )\n  / / \n (_/  \n',
    '6': u'  ___ \n / __)\n(  _ \\\n \\___/\n',
    '9': u' ___  \n/ _ \\ \n\\__  )\n(___/ \n',
    '8': u' ____ \n/ _  \\\n) _  (\n\\____/\n',
    ';': u' _   \n(_)  \n( )  \n(/   \n',
    ':': u' _   \n(_)  \n _   \n(_)  \n',
    '=': u' ___  \n(___) \n ___  \n(___) \n',
    '<': u'  __ \n / / \n( (  \n \\_\\ \n',
    '?': u' ___  \n(__ \\ \n (__/ \n (_)  \n',
    '>': u'__   \n\\ \\  \n ) ) \n/_/  \n',
    '@': u'  ___ \n /   \\\n( (__/\n \\___)\n',
    '[': u' ___  \n/  _) \n) (_  \n\\___) \n',
    ']': u' ___ \n(_  \\\n _) (\n(___/\n',
    '\\': u' _    \n( \\   \n \\ \\  \n  \\_) \n',
    '_': u'      \n      \n ____ \n(____)\n',
    '^': u'  __  \n /  \\ \n(_/\\_)\n      \n',
    'a': u'  __  \n / _\\ \n/    \\\n\\_/\\_/\n',
    '`': u'_   \n\\)  \n    \n    \n',
    'c': u'  ___ \n / __)\n( (__ \n \\___)\n',
    'b': u' ____ \n(  _ \\\n ) _ (\n(____/\n',
    'e': u' ____ \n(  __)\n ) _) \n(____)\n',
    'd': u' ____ \n(    \\\n ) D (\n(____/\n',
    'g': u'  ___ \n / __)\n( (_ \\\n \\___/\n',
    'f': u' ____ \n(  __)\n ) _) \n(__)  \n',
    'i': u' __  \n(  ) \n )(  \n(__) \n',
    'h': u' _  _ \n/ )( \\\n) __ (\n\\_)(_/\n',
    'k': u' __ _ \n(  / )\n )  ( \n(__\\_)\n',
    'j': u'   __ \n _(  )\n/ \\) \\\n\\____/\n',
    'm': u' _  _ \n( \\/ )\n/ \\/ \\\n\\_)(_/\n',
    'l': u' __   \n(  )  \n/ (_/\\\n\\____/\n',
    'o': u'  __  \n /  \\ \n(  O )\n \\__/ \n',
    'n': u' __ _ \n(  ( \\\n/    /\n\\_)__)\n',
    'q': u'  __  \n /  \\ \n(  O )\n \\__\\)\n',
    'p': u' ____ \n(  _ \\\n ) __/\n(__)  \n',
    's': u' ____ \n/ ___)\n\\___ \\\n(____/\n',
    'r': u' ____ \n(  _ \\\n )   /\n(__\\_)\n',
    'u': u' _  _ \n/ )( \\\n) \\/ (\n\\____/\n',
    't': u' ____ \n(_  _)\n  )(  \n (__) \n',
    'w': u' _  _ \n/ )( \\\n\\ /\\ /\n(_/\\_)\n',
    'v': u' _  _ \n/ )( \\\n\\ \\/ /\n \\__/ \n',
    'y': u' _  _ \n( \\/ )\n )  / \n(__/  \n',
    'x': u' _  _ \n( \\/ )\n )  ( \n(_/\\_)\n',
    '{': u'  ___ \n (  _)\n(_ (_ \n (___)\n',
    'z': u' ____ \n(__  )\n / _/ \n(____)\n',
    '}': u' ___  \n(_  ) \n _) _)\n(___) \n',
    '|': u' _   \n( \\  \n/ /  \n\\_)  \n',
    '~': u' __   \n(_ \\_ \n  \\__)\n      \n'}

greek_dic = {
    ' ': u' \n \n \n \n \n \n \n \n \n',
    '$': u'    _    \n  _| |_  \n /    _) \n( (| |_  \n \\_    \\ \n  _| |) )\n (_   _/ \n   |_|   \n         \n',
    '(': u'  \n  \n  \n((\n  \n  \n  \n  \n  \n',
    ',': u'   \n   \n   \n   \n   \n _ \n( )\n|/ \n   \n',
    '0': u'       \n  ___  \n / _ \\ \n| | | |\n| | | |\n| |_| |\n \\___/ \n       \n       \n',
    '4': u'        \n    _   \n  /  |  \n / o |_ \n/__   _)\n   | |  \n   |_|  \n        \n        \n',
    '8': u'       \n  ___  \n /   \\ \n \\ O / \n / _ \\ \n( (_) )\n \\___/ \n       \n       \n',
    '<': u'     \n   __\n  / /\n / / \n< <  \n \\ \\ \n  \\_\\\n     \n     \n',
    '@': u'          \n   _____  \n  / ___ \\ \n / /   | |\n( ( () | |\n \\ \\____/_\n  \\______/\n          \n          \n',
    'D': u'          \n          \n    /\\    \n   /  \\   \n  / /\\ \\  \n / /__\\ \\ \n/________\\\n          \n          \n',
    'H': u'       \n _   _ \n| | | |\n| |_| |\n|  _  |\n| | | |\n|_| |_|\n       \n       \n',
    'L': u'          \n          \n    /\\    \n   /  \\   \n  / /\\ \\  \n / /  \\ \\ \n/_/    \\_\\\n          \n          \n',
    'P': u'         \n _______ \n(   _   )\n | | | | \n | | | | \n | | | | \n |_| |_| \n         \n         \n',
    'T': u'       \n _____ \n(_   _)\n  | |  \n  | |  \n  | |  \n  |_|  \n       \n       \n',
    'X': u'       \n _____ \n(_____)\n  ___  \n (___) \n _____ \n(_____)\n       \n       \n',
    '\\': u'       \n__     \n\\ \\    \n \\ \\   \n  \\ \\  \n   \\ \\ \n    \\_\\\n       \n       \n',
    '`': u'   \n   \n\\\\ \n \\\\\n   \n   \n   \n   \n   \n',
    'd': u'       \n   __  \n  / _) \n  \\ \\  \n / _ \\ \n( (_) )\n \\___/ \n       \n       \n',
    'h': u"       \n       \n       \n _ __  \n| '_ \\ \n| | | |\n|_| | |\n    | |\n    |_|\n",
    'l': u'       \n__     \n\\ \\    \n \\ \\   \n  > \\  \n / ^ \\ \n/_/ \\_\\\n       \n       \n',
    'p': u'        \n        \n        \n ______ \n(  __  )\n | || | \n |_||_| \n        \n        \n',
    't': u'     \n     \n     \n ___ \n(   )\n | | \n  \\_)\n     \n     \n',
    'x': u'__     \n\\ \\__  \n > __) \n( (_   \n > _)  \n( (__  \n \\__ \\ \n    ) )\n   (_/ \n',
    '|': u' _ \n| |\n| |\n| |\n| |\n| |\n| |\n|_|\n   \n',
    '#': u'           \n   _   _   \n _| |_| |_ \n(_   _   _)\n _| |_| |_ \n(_   _   _)\n  |_| |_|  \n           \n           \n',
    "'": u'   \n   \n //\n// \n   \n   \n   \n   \n   \n',
    '+': u'       \n       \n   _   \n _| |_ \n(_   _)\n  |_|  \n       \n       \n       \n',
    '/': u'       \n     __\n    / /\n   / / \n  / /  \n / /   \n/_/    \n       \n       \n',
    '3': u'       \n _____ \n(__  / \n  / /  \n (__ \\ \n ___) )\n(____/ \n       \n       \n',
    '7': u'       \n _____ \n(___  )\n  _/ / \n (  _) \n / /   \n/_/    \n       \n       \n',
    ';': u'   \n   \n   \n _ \n(_)\n _ \n( )\n|/ \n   \n',
    '?': u'     \n ___ \n(__ \\\n  / /\n |_| \n  _  \n (_) \n     \n     \n',
    'C': u'       \n__   __\n\\ \\ / /\n \\ v / \n  > <  \n / ^ \\ \n/_/ \\_\\\n       \n       \n',
    'G': u'       \n _____ \n|  ___)\n| |    \n| |    \n| |    \n|_|    \n       \n       \n',
    'K': u'       \n _   __\n| | / /\n| |/ / \n|   <  \n| |\\ \\ \n|_| \\_\\\n       \n       \n',
    'O': u'       \n  ___  \n / _ \\ \n| | | |\n| | | |\n| |_| |\n \\___/ \n       \n       \n',
    'S': u'       \n______ \n\\  ___)\n \\ \\   \n  > >  \n / /__ \n/_____)\n       \n       \n',
    'W': u'          \n   ____   \n  / __ \\  \n | |  | | \n | |  | | \n _\\ \\/ /_ \n(___||___)\n          \n          \n',
    '[': u' ___ \n|  _)\n| |  \n| |  \n| |  \n| |  \n| |_ \n|___)\n     \n',
    '_': u'  \n  \n  \n  \n  \n  \n  \n  \n||\n',
    'c': u'       \n       \n       \n__   __\n\\ \\ / /\n \\ v / \n  > <  \n / ^ \\ \n/_/ \\_\\\n',
    'g': u'       \n       \n       \n _   _ \n( \\ / )\n \\ v / \n  | |  \n  | |  \n  |_|  \n',
    'k': u'      \n      \n      \n _  __\n| |/ /\n|   < \n|_|\\_\\\n      \n      \n',
    'o': u'       \n       \n       \n  ___  \n / _ \\ \n( (_) )\n \\___/ \n       \n       \n',
    's': u'       \n       \n       \n  ____ \n /  ._)\n( () ) \n \\__/  \n       \n       \n',
    'w': u'           \n           \n           \n  __   __  \n / / _ \\ \\ \n| |_/ \\_| |\n \\___^___/ \n           \n           \n',
    '{': u'   __\n  / /\n | | \n | | \n< <  \n | | \n | | \n  \\_\\\n     \n',
    '"': u'      \n _  _ \n( )( )\n V  V \n      \n      \n      \n      \n      \n',
    '&': u'        \n  ___   \n /   \\  \n \\ O /  \n / _ \\/\\\n( (_>  <\n \\___/\\/\n        \n        \n',
    '*': u'      \n      \n__/\\__\n\\    /\n/_  _\\\n  \\/  \n      \n      \n      \n',
    '.': u'   \n   \n   \n   \n   \n _ \n(_)\n   \n   \n',
    '2': u'       \n ____  \n(___ \\ \n  __) )\n / __/ \n| |___ \n|_____)\n       \n       \n',
    '6': u"       \n   __  \n  / /  \n / /_  \n| '_ \\ \n| (_) )\n \\___/ \n       \n       \n",
    ':': u'   \n   \n   \n _ \n(_)\n   \n   \n   \n   \n',
    '>': u'     \n__   \n\\ \\  \n \\ \\ \n  > >\n / / \n/_/  \n     \n     \n',
    'B': u'       \n ____  \n|  _ \\ \n| |_) )\n|  _ ( \n| |_) )\n|____/ \n       \n       \n',
    'F': u'         \n    _    \n  _| |_  \n /     \\ \n( (| |) )\n \\_   _/ \n   |_|   \n         \n         \n',
    'J': u'           \n    ___    \n   / _ \\   \n  ( (_| |_ \n _ \\ _   _)\n| |___| |  \n \\_____/   \n           \n           \n',
    'N': u'       \n _   _ \n| \\ | |\n|  \\| |\n|     |\n| |\\  |\n|_| \\_|\n       \n       \n',
    'R': u'       \n ____  \n|  _ \\ \n| |_) )\n|  __/ \n| |    \n|_|    \n       \n       \n',
    'V': u'       \n       \n       \n  ____ \n / ___)\n( (__  \n \\__ \\ \n   _) )\n  (__/ \n',
    'Z': u'       \n ______\n(___  /\n   / / \n  / /  \n / /__ \n/_____)\n       \n       \n',
    '^': u'       \n _   _ \n(_) (_)\n       \n       \n       \n       \n       \n       \n',
    'b': u'       \n  ___  \n / _ \\ \n| |_) )\n|  _ < \n| |_) )\n|  __/ \n| |    \n|_|    \n',
    'f': u'         \n    _    \n   | |   \n  _| |_  \n /     \\ \n( (| |) )\n \\_   _/ \n   | |   \n   |_|   \n',
    'j': u'         \n         \n         \n _   __  \n| | /  \\ \n| || || )\n \\_   _/ \n   | |   \n   |_|   \n',
    'n': u'      \n      \n      \n _  __\n| |/ /\n| / / \n|__/  \n      \n      \n',
    'r': u'       \n       \n       \n  ___  \n / _ \\ \n| |_) )\n|  __/ \n| |    \n|_|    \n',
    'v': u'           \n           \n           \n _________ \n(  _____  )\n| |_/ \\_| |\n \\___^___/ \n           \n           \n',
    'z': u'       \n_____  \n\\__  ) \n  / /  \n / /   \n| |__  \n \\__ \\ \n    ) )\n   (_/ \n',
    '~': u'     \n /\\/|\n|/\\/ \n     \n     \n     \n     \n     \n     \n',
    '!': u'   \n _ \n| |\n| |\n|_|\n _ \n(_)\n   \n   \n',
    '%': u'       \n _   __\n(_) / /\n   / / \n  / /  \n / / _ \n/_/ (_)\n       \n       \n',
    ')': u'  \n  \n  \n))\n  \n  \n  \n  \n  \n',
    '-': u'       \n       \n       \n _____ \n(_____)\n       \n       \n       \n       \n',
    '1': u'   \n _ \n/ |\n- |\n| |\n| |\n|_|\n   \n   \n',
    '5': u'       \n ____  \n|  __) \n| |__  \n|___ \\ \n ___) )\n(____/ \n       \n       \n',
    '9': u'       \n  ___  \n / _ \\ \n( (_) |\n \\__, |\n   / / \n  /_/  \n       \n       \n',
    '=': u'       \n       \n _____ \n(_____)\n _____ \n(_____)\n       \n       \n       \n',
    'A': u'       \n  ___  \n / _ \\ \n| |_| |\n|  _  |\n| | | |\n|_| |_|\n       \n       \n',
    'E': u'       \n _____ \n|  ___)\n| |_   \n|  _)  \n| |___ \n|_____)\n       \n       \n',
    'I': u'     \n ___ \n(   )\n | | \n | | \n | | \n(___)\n     \n     \n',
    'M': u'         \n __   __ \n|  \\ /  |\n|   v   |\n| |\\_/| |\n| |   | |\n|_|   |_|\n         \n         \n',
    'Q': u'        \n  ____  \n / __ \\ \n| |__| |\n|  __  |\n| |__| |\n \\____/ \n        \n        \n',
    'U': u'         \n __   __ \n(_ \\ / _)\n  \\ v /  \n   | |   \n   | |   \n   |_|   \n         \n         \n',
    'Y': u'         \n _  _  _ \n| || || |\n| \\| |/ |\n \\_   _/ \n   | |   \n   |_|   \n         \n         \n',
    ']': u' ___ \n(_  |\n  | |\n  | |\n  | |\n  | |\n _| |\n(___|\n     \n',
    'a': u'        \n        \n        \n  __  __\n /  \\/ /\n( ()  < \n \\__/\\_\\\n        \n        \n',
    'e': u'     \n     \n     \n ___ \n/ __)\n> _) \n\\___)\n     \n     \n',
    'i': u'    \n    \n    \n _  \n| | \n| | \n \\_)\n    \n    \n',
    'm': u'       \n       \n       \n _   _ \n| | | |\n| |_| |\n| ._,_|\n| |    \n|_|    \n',
    'q': u'       \n  ___  \n / _ \\ \n| |_| |\n|  _  |\n| |_| |\n \\___/ \n       \n       \n',
    'u': u'       \n       \n       \n _   _ \n| | | |\n| |_| |\n \\___/ \n       \n       \n',
    'y': u'         \n         \n         \n _  _  _ \n| || || |\n| \\| |/ |\n \\_   _/ \n   | |   \n   |_|   \n',
    '}': u'__   \n\\ \\  \n | | \n | | \n  > >\n | | \n | | \n/_/  \n     \n'}

heartleft_dic = {
    ' ': u"      \n.-.-. \n'._.' \n      \n",
    '$': u" .-.-. \n( $ .' \n '.(   \n       \n",
    '(': u" .-.-. \n( ( .' \n '.(   \n       \n",
    ',': u" .-.-. \n( , .' \n '.(   \n       \n",
    '0': u" .-.-. \n( 0 .' \n `.(   \n       \n",
    '4': u" .-.-. \n( 4 .' \n `.(   \n       \n",
    '8': u" .-.-. \n( 8 .' \n `.(   \n       \n",
    '<': u" .-.-. \n( < .' \n '.(   \n       \n",
    '@': u" .-.-. \n( @ .' \n `.(   \n       \n",
    'D': u" .-.-. \n( D .' \n `.(   \n       \n",
    'H': u" .-.-. \n( H .' \n `.(   \n       \n",
    'L': u" .-.-. \n( L .' \n `.(   \n       \n",
    'P': u" .-.-. \n( P .' \n `.(   \n       \n",
    'T': u" .-.-. \n( T .' \n `.(   \n       \n",
    'X': u" .-.-. \n( X .' \n `.(   \n       \n",
    '\\': u" .-.-. \n( \\ .' \n '.(   \n       \n",
    '`': u" .-.-. \n( ` .' \n '.(   \n       \n",
    'd': u" .-.-. \n( d .' \n `.(   \n       \n",
    'h': u" .-.-. \n( h .' \n `.(   \n       \n",
    'l': u" .-.-. \n( l .' \n `.(   \n       \n",
    'p': u" .-.-. \n( p .' \n `.(   \n       \n",
    't': u" .-.-. \n( t .' \n `.(   \n       \n",
    'x': u" .-.-. \n( x .' \n `.(   \n       \n",
    '|': u" .-.-. \n( | .' \n '.(   \n       \n",
    '#': u" .-.-. \n( # .' \n '.(   \n       \n",
    "'": u" .-.-. \n( ' .' \n '.(   \n       \n",
    '+': u" .-.-. \n( + .' \n '.(   \n       \n",
    '/': u" .-.-. \n( / .' \n '.(   \n       \n",
    '3': u" .-.-. \n( 3 .' \n `.(   \n       \n",
    '7': u" .-.-. \n( 7 .' \n `.(   \n       \n",
    ';': u" .-.-. \n( ; .' \n '.(   \n       \n",
    '?': u" .-.-. \n(   .' \n `.(   \n       \n",
    'C': u" .-.-. \n( C .' \n `.(   \n       \n",
    'G': u" .-.-. \n( G .' \n `.(   \n       \n",
    'K': u" .-.-. \n( K .' \n `.(   \n       \n",
    'O': u" .-.-. \n( O .' \n `.(   \n       \n",
    'S': u" .-.-. \n( S .' \n `.(   \n       \n",
    'W': u" .-.-. \n( W .' \n `.(   \n       \n",
    '[': u" .-.-. \n( [ .' \n '.(   \n       \n",
    '_': u" .-.-. \n( _ .' \n '.(   \n       \n",
    'c': u" .-.-. \n( c .' \n `.(   \n       \n",
    'g': u" .-.-. \n( g .' \n `.(   \n       \n",
    'k': u" .-.-. \n( k .' \n `.(   \n       \n",
    'o': u" .-.-. \n( o .' \n `.(   \n       \n",
    's': u" .-.-. \n( s .' \n `.(   \n       \n",
    'w': u" .-.-. \n( w .' \n `.(   \n       \n",
    '{': u" .-.-. \n( { .' \n '.(   \n       \n",
    '"': u' .-.-. \n( " .\' \n \'.(   \n       \n',
    '&': u" .-.-. \n( & .' \n '.(   \n       \n",
    '*': u" .-.-. \n( * .' \n '.(   \n       \n",
    '.': u" .-.-. \n( . .' \n '.(   \n       \n",
    '2': u" .-.-. \n( 2 .' \n `.(   \n       \n",
    '6': u" .-.-. \n( 6 .' \n `.(   \n       \n",
    ':': u" .-.-. \n( : .' \n '.(   \n       \n",
    '>': u" .-.-. \n( > .' \n '.(   \n       \n",
    'B': u" .-.-. \n( B .' \n `.(   \n       \n",
    'F': u" .-.-. \n( F .' \n `.(   \n       \n",
    'J': u" .-.-. \n( J .' \n `.(   \n       \n",
    'N': u" .-.-. \n( N .' \n `.(   \n       \n",
    'R': u" .-.-. \n( R .' \n `.(   \n       \n",
    'V': u" .-.-. \n( V .' \n `.(   \n       \n",
    'Z': u" .-.-. \n( Z .' \n `.(   \n       \n",
    '^': u" .-.-. \n( ^ .' \n '.(   \n       \n",
    'b': u" .-.-. \n( b .' \n `.(   \n       \n",
    'f': u" .-.-. \n( f .' \n `.(   \n       \n",
    'j': u" .-.-. \n( j .' \n `.(   \n       \n",
    'n': u" .-.-. \n( n .' \n `.(   \n       \n",
    'r': u" .-.-. \n( r .' \n `.(   \n       \n",
    'v': u" .-.-. \n( v .' \n `.(   \n       \n",
    'z': u" .-.-. \n( z .' \n `.(   \n       \n",
    '~': u" .-.-. \n( ~ .' \n '.(   \n       \n",
    '!': u" .-.-. \n( ! .' \n `.(   \n       \n",
    '%': u" .-.-. \n( % .' \n '.(   \n       \n",
    ')': u" .-.-. \n( ) .' \n '.(   \n       \n",
    '-': u" .-.-. \n( - .' \n '.(   \n       \n",
    '1': u" .-.-. \n( 1 .' \n `.(   \n       \n",
    '5': u" .-.-. \n( 5 .' \n `.(   \n       \n",
    '9': u" .-.-. \n( 9 .' \n `.(   \n       \n",
    '=': u" .-.-. \n( = .' \n '.(   \n       \n",
    'A': u" .-.-. \n( A .' \n `.(   \n       \n",
    'E': u" .-.-. \n( E .' \n `.(   \n       \n",
    'I': u" .-.-. \n( I .' \n `.(   \n       \n",
    'M': u" .-.-. \n( M .' \n `.(   \n       \n",
    'Q': u" .-.-. \n( Q .' \n `.(   \n       \n",
    'U': u" .-.-. \n( U .' \n `.(   \n       \n",
    'Y': u" .-.-. \n( Y .' \n `.(   \n       \n",
    ']': u" .-.-. \n( ] .' \n '.(   \n       \n",
    'a': u" .-.-. \n( a .' \n `.(   \n       \n",
    'e': u" .-.-. \n( e .' \n `.(   \n       \n",
    'i': u" .-.-. \n( i .' \n `.(   \n       \n",
    'm': u" .-.-. \n( m .' \n `.(   \n       \n",
    'q': u" .-.-. \n( q .' \n `.(   \n       \n",
    'u': u" .-.-. \n( u .' \n `.(   \n       \n",
    'y': u" .-.-. \n( y .' \n `.(   \n       \n",
    '}': u" .-.-. \n( } .' \n '.(   \n       \n"}

heartright_dic = {
    ' ': u"      \n.-.-. \n'._.' \n      \n",
    '$': u".-.-.  \n'. $ ) \n  ).'  \n       \n",
    '(': u".-.-.  \n'. ( ) \n  ).'  \n       \n",
    ',': u".-.-.  \n'. , ) \n  ).'  \n       \n",
    '0': u".-.-.  \n'. 0 ) \n  ).'  \n       \n",
    '4': u".-.-.  \n'. 4 ) \n  ).'  \n       \n",
    '8': u".-.-.  \n'. 8 ) \n  ).'  \n       \n",
    '<': u".-.-.  \n'. < ) \n  ).'  \n       \n",
    '@': u".-.-.  \n'. @ ) \n  ).'  \n       \n",
    'D': u".-.-.  \n'. D ) \n  ).'  \n       \n",
    'H': u".-.-.  \n'. H ) \n  ).'  \n       \n",
    'L': u".-.-.  \n'. L ) \n  ).'  \n       \n",
    'P': u".-.-.  \n'. P ) \n  ).'  \n       \n",
    'T': u".-.-.  \n'. T ) \n  ).'  \n       \n",
    'X': u".-.-.  \n'. X ) \n  ).'  \n       \n",
    '\\': u".-.-.  \n'. \\ ) \n  ).'  \n       \n",
    '`': u".-.-.  \n'. ` ) \n  ).'  \n       \n",
    'd': u".-.-.  \n'. d ) \n  ).'  \n       \n",
    'h': u".-.-.  \n'. h ) \n  ).'  \n       \n",
    'l': u".-.-.  \n'. l ) \n  ).'  \n       \n",
    'p': u".-.-.  \n'. p ) \n  ).'  \n       \n",
    't': u".-.-.  \n'. t ) \n  ).'  \n       \n",
    'x': u".-.-.  \n'. x ) \n  ).'  \n       \n",
    '|': u".-.-.  \n'. | ) \n  ).'  \n       \n",
    '#': u".-.-.  \n'. # ) \n  ).'  \n       \n",
    "'": u".-.-.  \n'. ' ) \n  ).'  \n       \n",
    '+': u".-.-.  \n'. + ) \n  ).'  \n       \n",
    '/': u".-.-.  \n'. / ) \n  ).'  \n       \n",
    '3': u".-.-.  \n'. 3 ) \n  ).'  \n       \n",
    '7': u".-.-.  \n'.7  ) \n  ).'  \n       \n",
    ';': u".-.-.  \n'. ; ) \n  ).'  \n       \n",
    '?': u".-.-.  \n'.   ) \n  ).'  \n       \n",
    'C': u".-.-.  \n'. C ) \n  ).'  \n       \n",
    'G': u".-.-.  \n'. G ) \n  ).'  \n       \n",
    'K': u".-.-.  \n'. K ) \n  ).'  \n       \n",
    'O': u".-.-.  \n'. O ) \n  ).'  \n       \n",
    'S': u".-.-.  \n'. S ) \n  ).'  \n       \n",
    'W': u".-.-.  \n'. W ) \n  ).'  \n       \n",
    '[': u".-.-.  \n'. [ ) \n  ).'  \n       \n",
    '_': u".-.-.  \n'. _ ) \n  ).'  \n       \n",
    'c': u".-.-.  \n'. c ) \n  ).'  \n       \n",
    'g': u".-.-.  \n'. g ) \n  ).'  \n       \n",
    'k': u".-.-.  \n'. k ) \n  ).'  \n       \n",
    'o': u".-.-.  \n'. o ) \n  ).'  \n       \n",
    's': u".-.-.  \n'. s ) \n  ).'  \n       \n",
    'w': u".-.-.  \n'. w ) \n  ).'  \n       \n",
    '{': u".-.-.  \n'. { ) \n  ).'  \n       \n",
    '"': u'.-.-.  \n\'. " ) \n  ).\'  \n       \n',
    '&': u".-.-.  \n'. & ) \n  ).'  \n       \n",
    '*': u".-.-.  \n'. * ) \n  ).'  \n       \n",
    '.': u".-.-.  \n'. . ) \n  ).'  \n       \n",
    '2': u".-.-.  \n'. 2 ) \n  ).'  \n       \n",
    '6': u".-.-.  \n'. 6 ) \n  ).'  \n       \n",
    ':': u".-.-.  \n'. : ) \n  ).'  \n       \n",
    '>': u".-.-.  \n'. > ) \n  ).'  \n       \n",
    'B': u".-.-.  \n'. B ) \n  ).'  \n       \n",
    'F': u".-.-.  \n'. F ) \n  ).'  \n       \n",
    'J': u".-.-.  \n'. J ) \n  ).'  \n       \n",
    'N': u".-.-.  \n'. N ) \n  ).'  \n       \n",
    'R': u".-.-.  \n'. R ) \n  ).'  \n       \n",
    'V': u".-.-.  \n'. V ) \n  ).'  \n       \n",
    'Z': u".-.-.  \n'. Z ) \n  ).'  \n       \n",
    '^': u".-.-.  \n'. ^ ) \n  ).'  \n       \n",
    'b': u".-.-.  \n'. b ) \n  ).'  \n       \n",
    'f': u".-.-.  \n'. f ) \n  ).'  \n       \n",
    'j': u".-.-.  \n'. j ) \n  ).'  \n       \n",
    'n': u".-.-.  \n'. n ) \n  ).'  \n       \n",
    'r': u".-.-.  \n'. r ) \n  ).'  \n       \n",
    'v': u".-.-.  \n'. v ) \n  ).'  \n       \n",
    'z': u".-.-.  \n'. z ) \n  ).'  \n       \n",
    '~': u".-.-.  \n'. ~ ) \n  ).'  \n       \n",
    '!': u".-.-.  \n'. ! ) \n  ).'  \n       \n",
    '%': u".-.-.  \n'. % ) \n  ).'  \n       \n",
    ')': u".-.-.  \n'. ) ) \n  ).'  \n       \n",
    '-': u".-.-.  \n'. - ) \n  ).'  \n       \n",
    '1': u".-.-.  \n'. 1 ) \n  ).'  \n       \n",
    '5': u".-.-.  \n'. 5 ) \n  ).'  \n       \n",
    '9': u".-.-.  \n'. 9 ) \n  ).'  \n       \n",
    '=': u".-.-.  \n'. = ) \n  ).'  \n       \n",
    'A': u".-.-.  \n'. A ) \n  ).'  \n       \n",
    'E': u".-.-.  \n'. E ) \n  ).'  \n       \n",
    'I': u".-.-.  \n'. I ) \n  ).'  \n       \n",
    'M': u".-.-.  \n'. M ) \n  ).'  \n       \n",
    'Q': u".-.-.  \n'. Q ) \n  ).'  \n       \n",
    'U': u".-.-.  \n'. U ) \n  ).'  \n       \n",
    'Y': u".-.-.  \n'. Y ) \n  ).'  \n       \n",
    ']': u".-.-.  \n'. ] ) \n  ).'  \n       \n",
    'a': u".-.-.  \n'. a ) \n  ).'  \n       \n",
    'e': u".-.-.  \n'. e ) \n  ).'  \n       \n",
    'i': u".-.-.  \n'. i ) \n  ).'  \n       \n",
    'm': u".-.-.  \n'. m ) \n  ).'  \n       \n",
    'q': u".-.-.  \n'. q ) \n  ).'  \n       \n",
    'u': u".-.-.  \n'. u ) \n  ).'  \n       \n",
    'y': u".-.-.  \n'. y ) \n  ).'  \n       \n",
    '}': u".-.-.  \n'. } ) \n  ).'  \n       \n"}

henry3d_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'   _F]_  \n  F ___L \n J (___| \n J\\___ \\ \n.--___) \\\nJ\\__  __J\n J__LJ__F\n    LJ   \n',
    '(': u"   _  \n .'_| \n/ /-' \n| L   \n\\ \\__ \n\\'.__L\n '.__|\n      \n",
    ',': u'    \n    \n    \n    \n __ \nJ  L\n|_F \n|_F \n',
    '0': u'   ____   \n  F _  ]  \n J |/ | L \n | | /| | \n F  /_J J \nJ\\______/F\n J______F \n          \n',
    '4': u'  _  _   \n FJ  L]  \nJ |__| L \n|____  | \nL____J J \n     J__L\n     J__|\n         \n',
    '8': u"   ____   \n  F __ J  \n J `--' L \n / ,--. \\ \n F L__J J \nJ\\______/L\n J______F \n          \n",
    '<': u'      _  \n  _-""_L \n," .""-\' \n|"-_"--_ \n "-_"--_L\n    "--_|\n         \n         \n',
    '@': u"   ____   \n  F __ ]  \n J |  | L \n | |[L' | \n F L_-_/_ \nJ\\______/L\n J______F \n          \n",
    'D': u'   ___   \n  F __". \n J |--\\ L\n | |  J |\n F L__J |\nJ______/F\n|______F \n         \n',
    'H': u'   _  _   \n  FJ  L]  \n J |__| L \n |  __  | \n F L__J J \nJ__L  J__L\n|__L  J__|\n          \n',
    'L': u'   _      \n  FJ      \n J |      \n | |      \n F L_____ \nJ________L\n|________|\n          \n',
    'P': u'   ___  \n  F _ ",\n J `-\' |\n |  __/F\n F |__/ \nJ__|    \n|__L    \n        \n',
    'T': u' ____ \n/_  _\\\n[J  L]\n |  | \n F  J \nJ____L\n|____|\n      \n',
    'X': u'   _  _   \n  FJ  LJ  \n  J \\/ F  \n  /    \\  \n /  /\\  \\ \nJ__//\\\\__L\n|__/  \\__|\n          \n',
    '\\': u"_      \n\\\\     \nJ \\    \n'\\ \\   \n J  \\  \n J\\__\\ \n  |___L\n       \n",
    '`': u'_  \n\\\\ \n\\\\\\\n   \n   \n   \n   \n   \n',
    'd': u'      _   \n   ___FJ  \n  F __  L \n | |--| | \n F L__J J \nJ\\____,__L\n J____,__F\n          \n',
    'h': u'   _      \n  FJ___   \n J  __ `. \n | |--| | \n F L  J J \nJ__L  J__L\n|__L  J__|\n          \n',
    'l': u' __ \n LJ \n FJ \nJ  L\nJ  L\nJ__L\n|__|\n    \n',
    'p': u"          \n  _ ___   \n J '__ J  \n | |--| | \n F L__J J \nJ  _____/L\n|_J_____F \nL_J       \n",
    't': u"  _    \n FJ_   \nJ  _|  \n| |-'  \nF |__-.\n\\_____/\nJ_____F\n       \n",
    'x': u"         \n  _   _  \n J \\ / F \n  \\ ' /  \n .' . `. \nJ__/:\\__L\n|__/ \\__|\n         \n",
    '|': u' [] \n LJ \n FJ \nJ  L\nJ  L\nJ  L\n|__|\n|__|\n',
    '#': u'    _  _    \n  _FJ__L]_  \n |   __   | \n _| |__| |_ \nL_   __   _J\nLJ__F__J__LJ\n |__L  J__| \n            \n',
    "'": u'__\nFJ\nL-\n- \n  \n  \n  \n  \n',
    '+': u'        \n   __   \n __FJ__ \n|__  __|\nL_J__L_J\n  J__L  \n        \n        \n',
    '/': u"      _\n     //\n    / F\n   / /'\n  /  F \n /__/F \nJ___|  \n       \n",
    '3': u'   ____   \n  F___ J  \n  `-__| L \n   |__  ( \n.-____] J \nJ\\______/F\n J______F \n          \n',
    '7': u' ____ \nF___ ]\n`--7 /\n  / //\n J  L \n J__L \n |__| \n      \n',
    ';': u'    \n __ \n LJ \n -- \n __ \nJ  L\n|_F \n|_F \n',
    '?': u'  ____  \n,"__  ".\nFJ--/ J|\n-- /_// \n  J__/  \n  J__L  \n  |__|  \n        \n',
    'C': u'   ___   \n ,"___". \n FJ---L] \nJ |   LJ \n| \\___--.\nJ\\_____/F\n J_____F \n         \n',
    'G': u'   ___   \n ,"___". \n FJ---L] \nJ |  [""L\n| \\___] |\nJ\\_____/F\n J_____F \n         \n',
    'K': u'   _  _   \n  FJ / ;  \n J |/ (|  \n |     L  \n F L:\\  L \nJ__L \\\\__L\n|__L  \\L_|\n          \n',
    'O': u'   ____   \n  F __ ]  \n J |--| L \n | |  | | \n F L__J J \nJ\\______/F\n J______F \n          \n',
    'S': u'   ___   \n  F __". \n J (___| \n J\\___ \\ \n.--___) \\\nJ\\______J\n J______F\n         \n',
    'W': u'   _    _   \n  F L  J J  \n J J .. L L \n | |/  \\| | \n F   /\\   J \nJ___//\\\\___L\n|___/  \\___|\n            \n',
    '[': u"   ____   \n  F ___J  \n J |---'  \n | |      \n F L_____ \nJ________L\n|________|\n          \n",
    '_': u'          \n          \n          \n          \n          \n ________ \n|________|\nL________J\n',
    'c': u'          \n   ____   \n  F ___J. \n | |---LJ \n F L___--.\nJ\\______/F\n J______F \n          \n',
    'g': u'          \n   ___ _  \n  F __` L \n | |--| | \n F L__J J \n )-____  L\nJ\\______/F\n J______F \n',
    'k': u'   _      \n  FJ __   \n J |/ /L  \n |    \\   \n F L:\\ J  \nJ__L \\\\_J.\n|__L  \\L_|\n          \n',
    'o': u'          \n   ____   \n  F __ J  \n | |--| | \n F L__J J \nJ\\______/F\n J______F \n          \n',
    's': u"          \n   ____   \n  F ___J  \n | '----_ \n )-____  L\nJ\\______/F\n J______F \n          \n",
    'w': u'            \n   _    _   \n  FJ .. L]  \n | |/  \\| | \n F   /\\   J \nJ\\__//\\\\__/L\n \\__/  \\__/ \n            \n',
    '{': u'     _   \n   ."_J  \n _/ /-\'  \n|_ (/    \nL_L."-__ \n  "_"-__L\n    "-__|\n         \n',
    '"': u' _  _ \nEJ  LJ\n--  --\n      \n      \n      \n      \n      \n',
    '&': u'   ___    \n  F _ ",  \n J \'-\'(|  \n / ,-, V\\ \n F L_/  < \nJ\\____,_-L\n J____,_-\'\n          \n',
    '*': u"    __    \n  /\\FJ/\\  \n  \\    /  \n .'    '. \nJ\\.n  n./L\n \\/J__L\\/ \n   |__|   \n          \n",
    '.': u'    \n    \n    \n    \n __ \nJ__L\n|__|\n    \n',
    '2': u"   ____   \n  / _  `. \n J_/-7 .' \n `-:'.'.' \n .' ;_J__ \nJ________L\n|________|\n          \n",
    '6': u'   ____   \n  F ___]  \n J `--_]  \n | ,--. L \n F L__J | \nJ\\______/L\n J______F \n          \n',
    ':': u'    \n __ \n LJ \n -- \n __ \nJ__L\n|__|\n    \n',
    '>': u'   _      \n  J_""-_  \n  `-"". ",\n __--"_-"|\nJ_--""_-" \n |_--"    \n          \n          \n',
    'B': u'   ___   \n  F _ ", \n J `-\'(| \n | ,--.\\ \n F L__J \\\nJ_______J\n|_______F\n         \n',
    'F': u'   ____  \n  F ___J \n J |___: \n | _____|\n F |____J\nJ__F     \n|__|     \n         \n',
    'J': u'     _  \n     L] \n     | L\n     | |\n.--__J J\nJ\\_____/\n J_____/\n        \n',
    'N': u'   _  _   \n  F L L]  \n J   \\| L \n | |\\   | \n F L\\\\  J \nJ__L \\\\__L\n|__L  J__|\n          \n',
    'R': u'   ___    \n  F _ ",  \n J `-\'(|  \n |  _  L  \n F |_\\  L \nJ__| \\\\__L\n|__|  J__|\n          \n',
    'V': u'  _  _  \n FJ  L] \nJ |  | L\nJ J  F L\nJ\\ \\/ /F\n \\\\__// \n  \\__/  \n        \n',
    'Z': u"   ____   \n  [__  '. \n  `--7 .' \n   .'.'.' \n .' (_(__ \nJ________L\n|________|\n          \n",
    '^': u'  /\\  \n /  \\ \n/_/\\_\\\nL_/\\_J\n      \n      \n      \n      \n',
    'b': u'   _      \n  FJ___   \n J  __ J  \n | |--| | \n F L__J J \nJ__,____/L\nJ__,____F \n          \n',
    'f': u"   ____ \n  / ___J\n J |_--'\n |  _|  \n F |_J  \nJ__F    \n|__|    \n        \n",
    'j': u'   __  \n   LJ  \n    _  \n   J J \n   J  L\n,-_J  |\n\\_____/\n\\_____/\n',
    'n': u"          \n  _ ___   \n J '__ J  \n | |__| | \n F L  J J \nJ__L  J__L\n|__L  J__|\n          \n",
    'r': u'         \n  _ ___  \n J \'__ ",\n | |__|-J\n F L  `-\'\nJ__L     \n|__L     \n         \n',
    'v': u'        \n _    _ \nJ |  | L\nJ J  F L\nJ\\ \\/ /F\n \\\\__// \n  \\__/  \n        \n',
    'z': u"         \n  _____  \n [__   F \n `-.'.'/ \n .' (_(_ \nJ_______L\n|_______|\n         \n",
    '~': u'     \n /\\/]\n/   /\nL/\\//\nL/\\/ \n     \n     \n     \n',
    '!': u' __ \n LJ \n FJ \nJ__L\n __ \nJ__L\n|__|\n    \n',
    '%': u"   _  _   \n  FJ //   \n  --/ F   \n   / /'   \n  /  F __ \n /__/F L_|\nJ___|  L_J\n          \n",
    ')': u"  _   \n |_'. \n '-\\ \\\n   J |\n __/ /\nJ__.'/\n|__.' \n      \n",
    '-': u'        \n        \n ______ \n|______|\nL______J\n        \n        \n        \n',
    '1': u' __ \n/ J \nLFJ \nJ  L\nJ  L\nJ__L\n|__|\n    \n',
    '5': u'   ____  \n  F ___L \n J |___| \n |____ \\ \n.--___) \\\nJ\\______J\n J______F\n         \n',
    '9': u"  ____   \n F __ J  \nJ '--' L \nJ`---. | \n `---J J \n     J__L\n     J__|\n         \n",
    '=': u'         \n  _____  \n |_____| \n_:_____:_\nL_______J\nL_______J\n         \n         \n',
    'A': u'     _     \n    /.\\    \n   //_\\\\   \n  / ___ \\  \n / L___J \\ \nJ__L   J__L\n|__L   J__|\n           \n',
    'E': u'   ____   \n  F ___J  \n J |___:  \n | _____| \n F L____: \nJ________L\n|________|\n          \n',
    'I': u'  __  \n  FJ  \n J  L \n |  | \n F  J \nJ____L\n|____|\n      \n',
    'M': u"   __  __   \n  F  \\/  ]  \n J |\\__/| L \n | |`--'| | \n F L    J J \nJ__L    J__L\n|__L    J__|\n            \n",
    'Q': u'   ____   \n  F __ ]  \n J |--| L \n | | _| | \n F L_F  J \nJ\\_____  \\\n J_____\\J]\n       \\J \n',
    'U': u'   _  _   \n  FJ  L]  \n J |  | L \n | |  | | \n F L__J J \nJ\\______/F\n J______F \n          \n',
    'Y': u' _  _ \nFJ  LJ\nJ \\/ F\nJ\\  /L\n F  J \n|____|\n|____|\n      \n',
    ']': u'   ____   \n  L___ ]  \n  `---| L \n      | | \n _____J J \nJ________L\n|________|\n          \n',
    'a': u'          \n   ___ _  \n  F __` L \n | |--| | \n F L__J J \nJ\\____,__L\n J____,__F\n          \n',
    'e': u'          \n   ____   \n  F __ J  \n | _____J \n F L___--.\nJ\\______/F\n J______F \n          \n',
    'i': u' __ \n LJ \n    \n FJ \nJ  L\nJ__L\n|__|\n    \n',
    'm': u"            \n  _ _____   \n J '_  _ `, \n | |_||_| | \n F L LJ J J \nJ__L LJ J__L\n|__L LJ J__|\n            \n",
    'q': u'          \n   ___ _  \n  F __` L \n | |--| | \n F L__J J \nJ\\_____  L\n J_____L_|\n       L_J\n',
    'u': u'          \n  _    _  \n J |  | L \n | |  | | \n F L__J J \nJ\\____,__L\n J____,__F\n          \n',
    'y': u'          \n  _    _  \n J |  | L \n | |  | | \n F L__J J \n )-____  L\nJ\\______/F\n J______F \n',
    '}': u'   _     \n  F_".   \n  \'-\\ \\_ \n    \\) _|\n __-".J_J\nJ__-"_"  \n|__-"    \n         \n'}

horizontalleft_dic = {
    '!': u' _  \n| | \n| | \n| | \n(_) \n    \n',
    ' ': u'  \n  \n  \n  \n  \n  \n',
    '#': u' _  _     \n\\ \\\\ \\ _  \n[\\ \\\\ \\_] \n[_\\ \\\\ \\] \n   \\_\\\\_\\ \n          \n',
    '"': u'"\n \n \n \n \n \n',
    '%': u'     _   \n _  / /  \n(_)/ /_  \n  / /(_) \n /_/     \n         \n',
    '$': u'      _   \n _.-./ \\  \n[/ _ \\ |] \n |_\\`._/  \n          \n          \n',
    "'": u' _  \n|_| \n    \n    \n    \n    \n',
    '&': u'&\n \n \n \n \n \n',
    ')': u' __   \n|_ \\  \n  \\ \\ \n _/ / \n|__/  \n      \n',
    '(': u'  __  \n / _| \n/ /   \n\\ \\_  \n \\__| \n      \n',
    '+': u'   _    \n _| |_  \n|_   _| \n  |_|   \n        \n        \n',
    '*': u'*\n \n \n \n \n \n',
    '-': u'       \n ____  \n[____] \n       \n       \n       \n',
    ',': u'    \n    \n    \n _  \n)_/ \n    \n',
    '/': u'    _  \n   / / \n  / /  \n / /   \n/_/    \n       \n',
    '.': u'    \n    \n _  \n(_) \n    \n    \n',
    '1': u' _     _  \n| /___\\ | \n\\______ | \n      /_| \n          \n          \n',
    '0': u"  _____   \n.' ___ '. \n| (___) | \n'._____.' \n          \n          \n",
    '3': u' _     _  \n/ \\   \\ \\ \n| //\\_| | \n\\_______/ \n          \n          \n',
    '2': u" _    __  \n| /_.`_ | \n\\   .'| | \n `-`  |_| \n          \n          \n",
    '5': u" __    _  \n|  `._\\ | \n| |`.   / \n|_|  '-'  \n          \n          \n",
    '4': u'   __     \n  /_ |    \n //_||__  \n/__   __| \n   |_|    \n          \n',
    '7': u' _        \n/ \\       \n| /_____  \n\\ ______/ \n          \n          \n',
    '6': u' _______  \n|__ ___ \\ \n  | \\_/ | \n  `,___,` \n          \n          \n',
    '9': u'  __      \n.` _`.    \n| /_\\|__  \n\\_______| \n          \n          \n',
    '8': u"  __  __  \n.'  ''  '.\n| ()  () |\n'.__..__.'\n          \n          \n",
    ';': u' _  \n(_) \n    \n _  \n)_/ \n    \n',
    ':': u' _  \n(_) \n    \n _  \n(_) \n    \n',
    '=': u' ____  \n[____] \n ____  \n[____] \n       \n       \n',
    '<': u'<\n \n \n \n \n \n',
    '?': u"   __  \n .`__/ \n/_'-.  \n  |_|  \n  (_)  \n       \n",
    '>': u'>\n \n \n \n \n \n',
    '@': u'@\n \n \n \n \n \n',
    '[': u' ___  \n|  _| \n| |   \n| |_  \n|___| \n      \n',
    ']': u' ___  \n|_  | \n  | | \n _| | \n|___| \n      \n',
    '\\': u' _     \n\\ \\    \n \\ \\   \n  \\ \\  \n   \\_\\ \n       \n',
    '_': u'          \n          \n          \n          \n ________ \n[________]\n',
    '^': u'  __   \n /  \\  \n/_/\\_\\ \n       \n       \n       \n',
    'a': u'  ______  \n.`  _ ._| \n\\  \\_||_  \n `._____| \n          \n          \n',
    '`': u'__  \n\\_\\ \n    \n    \n    \n    \n',
    'c': u' _______  \n/ _____ \\ \n| \\   / | \n\\_/   \\_/ \n          \n          \n',
    'b': u" _______  \n|       | \n| o v o | \n'._.'._.' \n          \n          \n",
    'e': u' _______  \n| ._ _. | \n| \\ v / | \n|_/   \\_| \n          \n          \n',
    'd': u" _______  \n|  ___  | \n| '._.' | \n'._____.' \n          \n          \n",
    'g': u' _______  \n/ .---. \\ \n| \\ .-`_/ \n\\_/ |.`   \n          \n          \n',
    'f': u' _______  \n|  _ ___| \n| ||_\\    \n|_/       \n          \n          \n',
    'i': u' _     _  \n| |___| | \n|  ___  | \n|_|   |_| \n          \n          \n',
    'h': u' _______  \n\\__   __\\ \n __| |__  \n\\_______\\ \n          \n          \n',
    'k': u' _______  \n|_     _| \n.`  _ `.  \n|_.` `._| \n          \n          \n',
    'j': u' _    __  \n| /___\\ \\ \n| ______/ \n|_\\       \n          \n          \n',
    'm': u' _______  \n`._   __| \n _<  <__  \n/_______| \n          \n          \n',
    'l': u' _______  \n/______ \\ \n      / | \n      \\_| \n          \n          \n',
    'o': u' _______  \n/  ____ \\ \n| /___/ | \n\\_______/ \n          \n          \n',
    'n': u' _______  \n`._   __| \n _`. `._  \n|_______| \n          \n          \n',
    'q': u'  _______ \n / ____  \\\n | \\___\\ |\n \\_____\\_(\n          \n          \n',
    'p': u' _______  \n/ ___ __| \n| \\_/ |   \n`.___.`   \n          \n          \n',
    's': u'      __  \n .-. \\  \\ \n/ _ \\_\\ | \n|_\\`.___/ \n          \n          \n',
    'r': u' _______  \n/ ___  _| \n| \\_/  \\  \n`.__.`\\_| \n          \n          \n',
    'u': u' ______   \n/_____ `. \n _____\\ | \n\\______.` \n          \n          \n',
    't': u' _        \n| /_____  \n| ______/ \n|_\\       \n          \n          \n',
    'w': u' _______  \n`._   __| \n  _> >__  \n.`______| \n          \n          \n',
    'v': u' _____    \n`-.___ \\  \n ____.` | \n/______/  \n          \n          \n',
    'y': u' _        \n|_`.____  \n .` .___| \n|_.`      \n          \n          \n',
    'x': u" _     _  \n\\_'._.'_/ \n _> _ <_  \n/_.' '._\\ \n          \n          \n",
    '{': u'  ___  \n |  _| \n / |   \n \\ |_  \n |___| \n       \n',
    'z': u' _     _  \n| |  .` | \n| |.`_. | \n|__.` |_| \n          \n          \n',
    '}': u'  ___  \n |_  | \n   | \\ \n  _| / \n |___| \n       \n',
    '|': u' _  \n| | \n| | \n| | \n|_| \n    \n',
    '~': u'~\n \n \n \n \n \n'}

horizontalright_dic = {
    '!': u' _  \n| | \n| | \n| | \n(_) \n    \n',
    ' ': u'  \n  \n  \n  \n  \n  \n',
    '#': u'    _  _  \n _ / // / \n[_/ // /] \n[/ // /_] \n/_//_/    \n          \n',
    '"': u'"\n \n \n \n \n \n',
    '%': u'     _   \n _  / /  \n(_)/ /_  \n  / /(_) \n /_/     \n         \n',
    '$': u"  _       \n / \\.-._  \n[| / _ \\] \n \\_.'/_|  \n          \n          \n",
    "'": u' _  \n|_| \n    \n    \n    \n    \n',
    '&': u'&\n \n \n \n \n \n',
    ')': u' __   \n|_ \\  \n  \\ \\ \n _/ / \n|__/  \n      \n',
    '(': u'  __  \n / _| \n/ /   \n\\ \\_  \n \\__| \n      \n',
    '+': u'   _    \n _| |_  \n|_   _| \n  |_|   \n        \n        \n',
    '*': u'*\n \n \n \n \n \n',
    '-': u'       \n ____  \n[____] \n       \n       \n       \n',
    ',': u'    \n    \n    \n _  \n)_/ \n    \n',
    '/': u'    _  \n   / / \n  / /  \n / /   \n/_/    \n       \n',
    '.': u'    \n    \n _  \n(_) \n    \n    \n',
    '1': u' _     _  \n| /___\\ | \n| ______/ \n|_\\       \n          \n          \n',
    '0': u"  _____   \n.' ___ '. \n| (___) | \n'._____.' \n          \n          \n",
    '3': u' _     _  \n/ /   / \\ \n| |_/\\\\ | \n\\_______/ \n          \n          \n',
    '2': u" __    _  \n| _'._\\ | \n| |`.   / \n|_|  '-'  \n          \n          \n",
    '5': u" _    __  \n| /_.'  | \n\\   .'| | \n `-`  |_| \n          \n          \n",
    '4': u'    __    \n   | _\\   \n __||_\\\\  \n|__   __\\ \n   |_|    \n          \n',
    '7': u'       _  \n      / \\ \n _____\\ | \n\\______ / \n          \n          \n',
    '6': u" _______  \n/ ___ __| \n| \\_/ |   \n',___,'   \n          \n          \n",
    '9': u"     __   \n   .'_ '. \n __|/_\\ | \n|_______/ \n          \n          \n",
    '8': u"  __  __  \n.'  ''  '.\n| ()  () |\n'.__..__.'\n          \n          \n",
    ';': u' _  \n(_) \n    \n _  \n)_/ \n    \n',
    ':': u' _  \n(_) \n    \n _  \n(_) \n    \n',
    '=': u' ____  \n[____] \n ____  \n[____] \n       \n       \n',
    '<': u'<\n \n \n \n \n \n',
    '?': u" __    \n\\__'.  \n .-`_\\ \n |_|   \n (_)   \n       \n",
    '>': u'>\n \n \n \n \n \n',
    '@': u'@\n \n \n \n \n \n',
    '[': u' ___  \n|  _| \n| |   \n| |_  \n|___| \n      \n',
    ']': u' ___  \n|_  | \n  | | \n _| | \n|___| \n      \n',
    '\\': u' _     \n\\ \\    \n \\ \\   \n  \\ \\  \n   \\_\\ \n       \n',
    '_': u'          \n          \n          \n          \n ________ \n[________]\n',
    '^': u'  __   \n /  \\  \n/_/\\_\\ \n       \n       \n       \n',
    'a': u" ______   \n|_. _  '. \n _||_/  / \n|_____.'  \n          \n          \n",
    '`': u'__  \n\\_\\ \n    \n    \n    \n    \n',
    'c': u' _______  \n/ _____ \\ \n| \\   / | \n\\_/   \\_/ \n          \n          \n',
    'b': u" _______  \n|       | \n| o v o | \n'._.'._.' \n          \n          \n",
    'e': u' _______  \n| ._ _. | \n| \\ v / | \n|_/   \\_| \n          \n          \n',
    'd': u" _______  \n|  ___  | \n| '._.' | \n'._____.' \n          \n          \n",
    'g': u" _______  \n/ .---. \\ \n\\_'-. / | \n  '.| \\_/ \n          \n          \n",
    'f': u' _______  \n|___ _  | \n   /_|| | \n      \\_| \n          \n          \n',
    'i': u' _     _  \n| |___| | \n|  ___  | \n|_|   |_| \n          \n          \n',
    'h': u' _______  \n\\__   __\\ \n __| |__  \n\\_______\\ \n          \n          \n',
    'k': u" _______  \n|_     _| \n .' _  '. \n|_.' '._| \n          \n          \n",
    'j': u' __    _  \n/ /___\\ | \n\\______ | \n      /_| \n          \n          \n',
    'm': u" _______  \n|__   _.' \n __>  >_  \n|_______\\ \n          \n          \n",
    'l': u' _______  \n/ ______\\ \n| \\       \n|_/       \n          \n          \n',
    'o': u' _______  \n/  ____ \\ \n| /___/ | \n\\_______/ \n          \n          \n',
    'n': u" _______  \n|__   _.' \n _.' .'_  \n|_______| \n          \n          \n",
    'q': u'  _______ \n /  ____ \\\n | /___/ |\n )_/_____/\n          \n          \n',
    'p': u" _______  \n|__ ___ \\ \n  | \\_/ | \n  '.___.' \n          \n          \n",
    's': u" __       \n/  / .-.  \n| /_/ _ \\ \n\\___.'/_| \n          \n          \n",
    'r': u" _______  \n|_  ___ \\ \n /  \\_/ | \n|_/'.__.' \n          \n          \n",
    'u': u"  ______  \n.' _____\\ \n| /_____  \n'.______/ \n          \n          \n",
    't': u'       _  \n _____\\ | \n\\______ | \n      /_| \n          \n          \n',
    'w': u" _______  \n|__   _.' \n __< <_   \n|______'. \n          \n          \n",
    'v': u"   _____  \n / ___.-' \n| '.____  \n \\______\\ \n          \n          \n",
    'y': u"       _  \n ____.'_| \n|___. '.  \n     '._| \n          \n          \n",
    'x': u" _     _  \n\\_'._.'_/ \n _> _ <_  \n/_.' '._\\ \n          \n          \n",
    '{': u'  ___  \n |  _| \n / |   \n \\ |_  \n |___| \n       \n',
    'z': u" _     _  \n| '.  | | \n| ._'.| | \n|_| '.__| \n          \n          \n",
    '}': u'  ___  \n |_  | \n   | \\ \n  _| / \n |___| \n       \n',
    '|': u' _  \n| | \n| | \n| | \n|_| \n    \n',
    '~': u'~\n \n \n \n \n \n'}


ICL_1900_dic = {
    '!': u'!\n*\n \n \n \n \n \n \n \n \n*\n*\n \n',
    ' ': u' \n \n \n \n \n \n \n \n \n \n \n \n \n',
    '#': u'#\n \n \n \n \n \n*\n \n \n \n \n*\n \n',
    '"': u'"\n \n*\n*\n \n \n \n \n \n \n \n \n \n',
    '%': u'%\n \n \n*\n \n \n \n*\n \n \n \n*\n \n',
    '$': u'$\n \n*\n \n \n \n*\n \n \n \n \n*\n \n',
    "'": u"'\n \n \n*\n \n \n*\n \n \n \n \n*\n \n",
    '&': u'&\n*\n \n \n \n \n \n \n \n \n \n \n \n',
    ')': u')\n \n \n \n \n \n \n \n \n*\n \n*\n \n',
    '(': u'(\n \n \n \n \n \n \n \n*\n \n \n*\n \n',
    '+': u'+\n*\n \n \n \n*\n \n \n \n \n \n*\n \n',
    '*': u'*\n \n*\n \n \n \n \n*\n \n \n \n*\n \n',
    '-': u'-\n \n*\n \n \n \n \n \n \n \n \n \n \n',
    ',': u',\n*\n \n \n \n \n \n \n \n*\n \n*\n \n',
    '/': u'/\n \n \n*\n*\n \n \n \n \n \n \n \n \n',
    '.': u'.\n*\n \n \n \n \n*\n \n \n \n \n*\n \n',
    '1': u'1\n \n \n \n*\n \n \n \n \n \n \n \n \n',
    '0': u'0\n \n \n*\n \n \n \n \n \n \n \n \n \n',
    '3': u'3\n \n \n \n \n \n*\n \n \n \n \n \n \n',
    '2': u'2\n \n \n \n \n*\n \n \n \n \n \n \n \n',
    '5': u'5\n \n \n \n \n \n \n \n*\n \n \n \n \n',
    '4': u'4\n \n \n \n \n \n \n*\n \n \n \n \n \n',
    '7': u'7\n \n \n \n \n \n \n \n \n \n*\n \n \n',
    '6': u'6\n \n \n \n \n \n \n \n \n*\n \n \n \n',
    '9': u'9\n \n \n \n \n \n \n \n \n \n \n \n*\n',
    '8': u'8\n \n \n \n \n \n \n \n \n \n \n*\n \n',
    ';': u';\n*\n \n \n \n \n \n*\n \n \n \n*\n \n',
    ':': u':\n*\n \n \n \n \n \n \n*\n \n \n*\n \n',
    '=': u'=\n \n \n*\n \n \n \n \n \n*\n \n*\n \n',
    '<': u'<\n \n*\n \n \n \n \n \n*\n \n \n*\n \n',
    '?': u'?\n \n \n*\n \n \n \n \n*\n \n \n*\n \n',
    '>': u'>\n \n*\n \n \n \n \n \n \n*\n \n*\n \n',
    '@': u'@\n \n \n \n \n \n \n*\n \n \n \n*\n \n',
    '[': u'[\n \n*\n \n \n*\n \n \n \n \n \n*\n \n',
    ']': u']\n \n \n \n \n \n \n \n \n \n*\n*\n \n',
    '\\': u'\\\n \n \n*\n \n*\n \n \n \n \n \n*\n \n',
    '_': u'_\nR\nX\n0\n1\n2\n3\n4\n5\n6\n7\n8\n9\n',
    '^': u'^\n \n*\n \n \n \n \n \n \n \n*\n*\n \n',
    'a': u'a\n*\n \n \n*\n \n \n \n \n \n \n \n \n',
    '`': u'',
    'c': u'c\n*\n \n \n \n \n*\n \n \n \n \n \n \n',
    'b': u'b\n*\n \n \n \n*\n \n \n \n \n \n \n \n',
    'e': u'e\n*\n \n \n \n \n \n \n*\n \n \n \n \n',
    'd': u'd\n*\n \n \n \n \n \n*\n \n \n \n \n \n',
    'g': u'g\n*\n \n \n \n \n \n \n \n \n*\n \n \n',
    'f': u'f\n*\n \n \n \n \n \n \n \n*\n \n \n \n',
    'i': u'i\n*\n \n \n \n \n \n \n \n \n \n \n*\n',
    'h': u'h\n*\n \n \n \n \n \n \n \n \n \n*\n \n',
    'k': u'k\n \n*\n \n \n*\n \n \n \n \n \n \n \n',
    'j': u'j\n \n*\n \n*\n \n \n \n \n \n \n \n \n',
    'm': u'm\n \n*\n \n \n \n \n*\n \n \n \n \n \n',
    'l': u'l\n \n*\n \n \n \n*\n \n \n \n \n \n \n',
    'o': u'o\n \n*\n \n \n \n \n \n \n*\n \n \n \n',
    'n': u'n\n \n*\n \n \n \n \n \n*\n \n \n \n \n',
    'q': u'q\n \n*\n \n \n \n \n \n \n \n \n*\n \n',
    'p': u'p\n \n*\n \n \n \n \n \n \n \n*\n \n \n',
    's': u's\n \n \n*\n \n*\n \n \n \n \n \n \n \n',
    'r': u'r\n \n*\n \n \n \n \n \n \n \n \n \n*\n',
    'u': u'u\n \n \n*\n \n \n \n*\n \n \n \n \n \n',
    't': u't\n \n \n*\n \n \n*\n \n \n \n \n \n \n',
    'w': u'w\n \n \n*\n \n \n \n \n \n*\n \n \n \n',
    'v': u'v\n \n \n*\n \n \n \n \n*\n \n \n \n \n',
    'y': u'y\n \n \n*\n \n \n \n \n \n \n \n*\n \n',
    'x': u'x\n \n \n*\n \n \n \n \n \n \n*\n \n \n',
    '{': u' \n \n \n \n \n \n \n \n \n \n \n \n \n',
    'z': u'z\n \n \n*\n \n \n \n \n \n \n \n \n*\n',
    '}': u'}\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '|': u'|\n \n \n*\n \n \n \n \n \n \n*\n*\n \n',
    '~': u'~\n \n \n \n \n \n \n \n \n \n \n \n \n'}

impossible_dic = {
    '!': u'    _     \n   /\\_\\   \n  / / /   \n / / /_   \n/ /___/\\  \n\\____ \\ \\ \n    / / / \n   / / /  \n  _\\/_/   \n /\\_\\     \n \\/_/     \n          \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u'      _       \n __  /\\ \\     \n/_/\\_\\ \\_\\    \n\\ \\__/\\/_/_   \n \\/_/\\/___/\\  \n   /\\/___ \\ \\ \n  / /_/ /_/ / \n  \\ \\_\\ \\_\\/  \n   \\/_/       \n              \n              \n              \n',
    '"': u'  _    _   \n/_/\\ /_/\\  \n\\_\\ \\\\_\\ \\ \n/\\_\\//\\_\\/ \n\\/_/ \\/_/  \n           \n           \n           \n           \n           \n           \n           \n',
    '%': u'   _________     \n  / _________\\   \n / / _______ /   \n/ /_/_/\\/ / /    \n\\ \\ \\_\\/\\/_/_    \n \\ \\___\\/___ \\   \n  \\/___/\\__ \\ \\  \n    /\\_\\/  \\_\\ \\ \n   / / /___/ / / \n  / /_______/ /  \n  \\/________\\/   \n                 \n',
    '$': u'   _________     \n  / _________\\   \n / / _______ /   \n/ /_/_/\\/ / /    \n\\ \\ \\_\\/\\/_/_    \n \\ \\___\\/___ \\   \n  \\/___/\\__ \\ \\  \n    /\\_\\/  \\_\\ \\ \n   / / /___/ / / \n  / /_______/ /  \n  \\/________\\/   \n                 \n',
    "'": u'  _   \n/_/\\  \n\\_\\ \\ \n/\\_\\/ \n\\/_/  \n      \n      \n      \n      \n      \n      \n      \n',
    '&': u'   _________     \n  / _________\\   \n / / _______ /   \n/ /_/_/\\/ / /    \n\\ \\ \\_\\/\\/_/_    \n \\ \\___\\/___ \\   \n  \\/___/\\__ \\ \\  \n    /\\_\\/  \\_\\ \\ \n   / / /___/ / / \n  / /_______/ /  \n  \\/________\\/   \n                 \n',
    ')': u'    _      \n  /\\ \\     \n /  \\ \\    \n/ /\\ \\ \\   \n\\/_/\\ \\ \\  \n     \\ \\ \\ \n _   / / / \n/\\ \\/ / /  \n\\ \\/ / /   \n \\  / /    \n  \\/_/     \n           \n',
    '(': u'     _     \n    / /\\   \n   / /  \\  \n  / / /\\ \\ \n / / /\\_\\/ \n/ / /      \n\\ \\ \\   _  \n \\ \\ \\/ /\\ \n  \\ \\ \\/ / \n   \\ \\  /  \n    \\_\\/   \n           \n',
    '+': u'            \n     _      \n    /\\ \\    \n ___\\ \\_\\   \n/___/\\/_/_  \n\\__ \\/___/\\ \n  /\\/____\\/ \n  \\ \\_\\     \n   \\/_/     \n            \n            \n            \n',
    '*': u'              \n      _       \n __  /\\ \\     \n/_/\\_\\ \\_\\    \n\\ \\__/\\/_/_   \n \\/_/\\/___/\\  \n   /\\/___ \\ \\ \n   \\/_/ /_/ / \n        \\_\\/  \n              \n              \n              \n',
    '-': u'         \n         \n         \n         \n  ____   \n/\\____/\\ \n\\/____\\/ \n         \n         \n         \n         \n         \n',
    ',': u'      \n      \n      \n      \n      \n      \n  _   \n/\\_\\  \n\\/ /\\ \n/_/ / \n\\_\\/  \n      \n',
    '/': u'         _   \n        /\\_\\ \n       / / / \n      / / /  \n     / / /   \n    / / /    \n   / / /     \n  / / /      \n / / /       \n/ / /        \n\\/_/         \n             \n',
    '.': u'     \n     \n     \n     \n     \n     \n     \n     \n _   \n/\\_\\ \n\\/_/ \n     \n',
    '1': u'   _              \n  / /\\            \n / /  \\           \n/_/ /\\ \\          \n\\_\\/\\ \\ \\         \n     \\ \\ \\        \n      \\ \\ \\       \n       \\ \\ \\      \n      __\\ \\ \\___  \n     /___\\_\\/__/\\ \n     \\_________\\/ \n                  \n',
    '0': u'      _          \n    / /\\         \n   / /  \\        \n  / / /\\ \\       \n / / /\\ \\ \\      \n/_/ /  \\ \\ \\     \n\\ \\ \\   \\ \\ \\    \n \\ \\ \\   \\ \\ \\   \n  \\ \\ \\___\\ \\ \\  \n   \\ \\/____\\ \\ \\ \n    \\_________\\/ \n                 \n',
    '3': u'      _          \n    /\\ \\         \n   /  \\ \\        \n  / /\\ \\ \\       \n / / /\\ \\ \\      \n \\/_//_\\ \\ \\     \n   __\\___ \\ \\    \n  / /\\   \\ \\ \\   \n / /_/____\\ \\ \\  \n/__________\\ \\ \\ \n\\_____________\\/ \n                 \n',
    '2': u'    _       \n  /\\ \\      \n /  \\ \\     \n/ /\\ \\ \\    \n\\/_/\\ \\ \\   \n    / / /   \n   / / /    \n  / / /  _  \n / / /_/\\_\\ \n/ /_____/ / \n\\________/  \n            \n',
    '5': u'       _______   \n      / ___  /\\  \n     / /\\__\\ \\ \\ \n    / / /   \\_\\/ \n   / / /         \n   \\ \\ \\         \n    \\ \\ \\        \n     \\ \\ \\       \n ____/ / /       \n/_____/ /        \n\\_____\\/         \n                 \n',
    '4': u'       _           \n   _  /\\ \\         \n  /\\_\\\\ \\ \\        \n / / / \\ \\ \\       \n/ / /   \\ \\ \\      \n\\ \\ \\____\\ \\ \\     \n \\ \\________\\ \\    \n  \\/________/\\ \\   \n            \\ \\ \\  \n             \\ \\_\\ \n              \\/_/ \n                   \n',
    '7': u'      _          \n    / /\\         \n   / /  \\        \n  / / /\\ \\       \n / / /\\ \\ \\      \n/_/ /  \\ \\ \\     \n\\_\\/    \\ \\ \\    \n         \\ \\ \\   \n          \\ \\ \\  \n           \\ \\ \\ \n            \\_\\/ \n                 \n',
    '6': u'          _    \n        /\\ \\   \n       /  \\ \\  \n      / /\\ \\_\\ \n     / / /\\/_/ \n    / /_/_     \n   / /___/\\    \n  / /\\__ \\ \\   \n / / /__\\ \\ \\  \n/ / /____\\ \\ \\ \n\\/__________\\/ \n               \n',
    '9': u'     _          \n   / /\\         \n  / /  \\        \n / / /\\ \\       \n/_/ /\\ \\ \\      \n\\ \\ \\_\\ \\ \\     \n \\ \\/__\\ \\ \\    \n  \\_____\\ \\ \\   \n         \\ \\ \\  \n          \\ \\ \\ \n           \\_\\/ \n                \n',
    '8': u'     _          \n   / /\\         \n  / /  \\        \n / / /\\ \\       \n/_/ /\\ \\ \\      \n\\ \\ \\_\\ \\ \\     \n \\ \\/__\\ \\ \\    \n  \\_____\\ \\ \\   \n   \\ \\ \\_\\ \\ \\  \n    \\ \\___\\ \\ \\ \n     \\_______\\/ \n                \n',
    ';': u'      \n  _   \n/_/\\  \n\\_\\ \\ \n/\\_\\/ \n\\/_/  \n      \n _    \n/\\_\\  \n\\/_/  \n      \n      \n',
    ':': u'     \n _   \n/\\_\\ \n\\/_/ \n     \n     \n     \n  _  \n/_/\\ \n\\_\\/ \n     \n     \n',
    '=': u'         \n         \n         \n  ____   \n/\\____/\\ \n\\/____\\/ \n/\\____/\\ \n\\/____\\/ \n         \n         \n         \n         \n',
    '<': u'   ____  \n  / ___\\ \n / / __/ \n/ /_/    \n\\ \\ \\__  \n \\ \\___\\ \n  \\/___/ \n         \n         \n         \n         \n         \n',
    '?': u'     _           \n    / /\\         \n   / /  \\        \n  / / /\\ \\___    \n / / /\\ \\__  /\\  \n/_/ /  \\__/ / /  \n\\ \\ \\    /_/ /   \n \\_\\/    \\ \\ \\   \n          \\_\\/_  \n            /_/\\ \n            \\_\\/ \n                 \n',
    '>': u' ____    \n/___ \\   \n\\__ \\ \\  \n   \\_\\ \\ \n __/ / / \n/___/ /  \n\\___\\/   \n         \n         \n         \n         \n         \n',
    '@': u'               \n               \n               \n               \n       ____    \n      /___ \\   \n   __ \\__ \\ \\  \n  /\\_\\   \\_\\ \\ \n / / /___/ / / \n/ /_______/ /  \n\\/________\\/   \n               \n',
    '[': u'       _       \n      /\\ \\     \n     /  \\ \\__  \n    / /\\ \\___\\ \n   / / /\\/___/ \n  / / /        \n / / /         \n/ / /          \n\\ \\ \\__        \n \\ \\___\\       \n  \\/___/       \n               \n',
    ']': u'      _        \n    / /\\       \n __/ /  \\      \n/___/ /\\ \\     \n\\___\\/\\ \\ \\    \n       \\ \\ \\   \n        \\ \\ \\  \n         \\ \\ \\ \n       __/ / / \n      /___/ /  \n      \\___\\/   \n               \n',
    '\\': u'  _          \n/_/\\         \n\\ \\ \\        \n \\ \\ \\       \n  \\ \\ \\      \n   \\ \\ \\     \n    \\ \\ \\    \n     \\ \\ \\   \n      \\ \\ \\  \n       \\ \\ \\ \n        \\_\\/ \n             \n',
    '_': u'                   \n                   \n                   \n                   \n                   \n                   \n                   \n     ___________   \n ___/__________/\\  \n/__________    \\ \\ \n\\____\\/    \\____\\/ \n                   \n',
    '^': u'     _       \n    / /\\     \n   / /  \\    \n  / / /\\ \\   \n / / /\\ \\ \\  \n/ / /  \\ \\_\\ \n\\/_/    \\/_/ \n             \n             \n             \n             \n             \n',
    'a': u'         _          \n        / /\\        \n       / /  \\       \n      / / /\\ \\      \n     / / /\\ \\ \\     \n    / / /  \\ \\ \\    \n   / / /___/ /\\ \\   \n  / / /_____/ /\\ \\  \n / /_________/\\ \\ \\ \n/ / /_       __\\ \\_\\\n\\_\\___\\     /____/_/\n                    \n',
    '`': u'  _   \n/_/\\  \n\\ \\ \\ \n \\_\\/ \n      \n      \n      \n      \n      \n      \n      \n      \n',
    'c': u'          _      \n        /\\ \\     \n       /  \\ \\    \n      / /\\ \\ \\   \n     / / /\\ \\ \\  \n    / / /  \\ \\_\\ \n   / / /    \\/_/ \n  / / /          \n / / /________   \n/ / /_________\\  \n\\/____________/  \n                 \n',
    'b': u'         _        \n        / /\\      \n       / /  \\     \n      / / /\\ \\    \n     / / /\\ \\ \\   \n    / / /\\ \\_\\ \\  \n   / / /\\ \\ \\___\\ \n  / / /  \\ \\ \\__/ \n / / /____\\_\\ \\   \n/ / /__________\\  \n\\/_____________/  \n                  \n',
    'e': u'         _      \n        /\\ \\    \n       /  \\ \\   \n      / /\\ \\ \\  \n     / / /\\ \\_\\ \n    / /_/_ \\/_/ \n   / /____/\\    \n  / /\\____\\/    \n / / /______    \n/ / /_______\\   \n\\/__________/   \n                \n',
    'd': u'       _         \n      /\\ \\       \n     /  \\ \\____  \n    / /\\ \\_____\\ \n   / / /\\/___  / \n  / / /   / / /  \n / / /   / / /   \n/ / /   / / /    \n\\ \\ \\__/ / /     \n \\ \\___\\/ /      \n  \\/_____/       \n                 \n',
    'g': u'         _        \n        /\\ \\      \n       /  \\ \\     \n      / /\\ \\_\\    \n     / / /\\/_/    \n    / / / ______  \n   / / / /\\_____\\ \n  / / /  \\/____ / \n / / /_____/ / /  \n/ / /______\\/ /   \n\\/___________/    \n                  \n',
    'f': u'         _      \n        /\\ \\    \n       /  \\ \\   \n      / /\\ \\ \\  \n     / / /\\ \\_\\ \n    / /_/_ \\/_/ \n   / /____/\\    \n  / /\\____\\/    \n / / /          \n/ / /           \n\\/_/            \n                \n',
    'i': u'          _     \n         /\\ \\   \n         \\ \\ \\  \n         /\\ \\_\\ \n        / /\\/_/ \n       / / /    \n      / / /     \n     / / /      \n ___/ / /__     \n/\\__\\/_/___\\    \n\\/_________/    \n                \n',
    'h': u'         _       _  \n        / /\\    / /\\\n       / / /   / / /\n      / /_/   / / / \n     / /\\ \\__/ / /  \n    / /\\ \\___\\/ /   \n   / / /\\/___/ /    \n  / / /   / / /     \n / / /   / / /      \n/ / /   / / /       \n\\/_/    \\/_/        \n                    \n',
    'k': u'         _        \n        /\\_\\      \n       / / /  _   \n      / / /  /\\_\\ \n     / / /__/ / / \n    / /\\_____/ /  \n   / /\\_______/   \n  / / /\\ \\ \\      \n / / /  \\ \\ \\     \n/ / /    \\ \\ \\    \n\\/_/      \\_\\_\\   \n                  \n',
    'j': u'             _     \n            /\\ \\   \n            \\ \\ \\  \n            /\\ \\_\\ \n           / /\\/_/ \n  _       / / /    \n /\\ \\    / / /     \n \\ \\_\\  / / /      \n / / /_/ / /       \n/ / /__\\/ /        \n\\/_______/         \n                   \n',
    'm': u'        _   _       \n       /\\_\\/\\_\\ _   \n      / / / / //\\_\\ \n     /\\ \\/ \\ \\/ / / \n    /  \\____\\__/ /  \n   / /\\/________/   \n  / / /\\/_// / /    \n / / /    / / /     \n/ / /    / / /      \n\\/_/    / / /       \n        \\/_/        \n                    \n',
    'l': u'         _     \n        _\\ \\   \n       /\\__ \\  \n      / /_ \\_\\ \n     / / /\\/_/ \n    / / /      \n   / / /       \n  / / / ____   \n / /_/_/ ___/\\ \n/_______/\\__\\/ \n\\_______\\/     \n               \n',
    'o': u'         _       \n        /\\ \\     \n       /  \\ \\    \n      / /\\ \\ \\   \n     / / /\\ \\ \\  \n    / / /  \\ \\_\\ \n   / / /   / / / \n  / / /   / / /  \n / / /___/ / /   \n/ / /____\\/ /    \n\\/_________/     \n                 \n',
    'n': u'         _          \n        /\\ \\     _  \n       /  \\ \\   /\\_\\\n      / /\\ \\ \\_/ / /\n     / / /\\ \\___/ / \n    / / /  \\/____/  \n   / / /    / / /   \n  / / /    / / /    \n / / /    / / /     \n/ / /    / / /      \n\\/_/     \\/_/       \n                    \n',
    'q': u'         _       \n        /\\ \\     \n       /  \\ \\    \n      / /\\ \\ \\   \n     / / /\\ \\ \\  \n    / / /  \\ \\_\\ \n   / / / _ / / / \n  / / / /\\ \\/ /  \n / / /__\\ \\ \\/   \n/ / /____\\ \\ \\   \n\\/________\\_\\/   \n                 \n',
    'p': u'         _      \n        /\\ \\    \n       /  \\ \\   \n      / /\\ \\ \\  \n     / / /\\ \\_\\ \n    / / /_/ / / \n   / / /__\\/ /  \n  / / /_____/   \n / / /          \n/ / /           \n\\/_/            \n                \n',
    's': u'        _        \n       / /\\      \n      / /  \\     \n     / / /\\ \\__  \n    / / /\\ \\___\\ \n    \\ \\ \\ \\/___/ \n     \\ \\ \\       \n _    \\ \\ \\      \n/_/\\__/ / /      \n\\ \\/___/ /       \n \\_____\\/        \n                 \n',
    'r': u'         _      \n        /\\ \\    \n       /  \\ \\   \n      / /\\ \\ \\  \n     / / /\\ \\_\\ \n    / / /_/ / / \n   / / /__\\/ /  \n  / / /_____/   \n / / /\\ \\ \\     \n/ / /  \\ \\ \\    \n\\/_/    \\_\\/    \n                \n',
    'u': u'   _               \n  /\\_\\             \n / / /         _   \n \\ \\ \\__      /\\_\\ \n  \\ \\___\\    / / / \n   \\__  /   / / /  \n   / / /   / / /   \n  / / /   / / /    \n / / /___/ / /     \n/ / /____\\/ /      \n\\/_________/       \n                   \n',
    't': u'       _       \n      /\\ \\     \n      \\_\\ \\    \n      /\\__ \\   \n     / /_ \\ \\  \n    / / /\\ \\ \\ \n   / / /  \\/_/ \n  / / /        \n / / /         \n/_/ /          \n\\_\\/           \n               \n',
    'w': u'        _           \n       / /\\      _  \n      / / /    / /\\ \n     / / /    / / / \n    / / /_   / / /  \n   / /_//_/\\/ / /   \n  / _______/\\/ /    \n / /  \\____\\  /     \n/_/ /\\ \\ /\\ \\/      \n\\_\\//_/ /_/ /       \n    \\_\\/\\_\\/        \n                    \n',
    'v': u' _          _  \n/\\ \\    _ / /\\ \n\\ \\ \\  /_/ / / \n \\ \\ \\ \\___\\/  \n / / /  \\ \\ \\  \n \\ \\ \\   \\_\\ \\ \n  \\ \\ \\  / / / \n   \\ \\ \\/ / /  \n    \\ \\ \\/ /   \n     \\ \\  /    \n      \\_\\/     \n               \n',
    'y': u' _        _   \n/\\ \\     /\\_\\ \n\\ \\ \\   / / / \n \\ \\ \\_/ / /  \n  \\ \\___/ /   \n   \\ \\ \\_/    \n    \\ \\ \\     \n     \\ \\ \\    \n      \\ \\ \\   \n       \\ \\_\\  \n        \\/_/  \n              \n',
    'x': u'  _      _      \n/_/\\    /\\ \\    \n\\ \\ \\   \\ \\_\\   \n \\ \\ \\__/ / /   \n  \\ \\__ \\/_/    \n   \\/_/\\__/\\    \n    _/\\/__\\ \\   \n   / _/_/\\ \\ \\  \n  / / /   \\ \\ \\ \n / / /    /_/ / \n \\/_/     \\_\\/  \n                \n',
    '{': u'    _     \n   / /\\   \n  / /  \\  \n / / /\\ \\ \n/ / /\\_\\/ \n\\ \\ \\     \n/ / /  _  \n\\ \\ \\/ /\\ \n \\ \\ \\/ / \n  \\ \\  /  \n   \\_\\/   \n          \n',
    'z': u'       _         \n     /\\ \\        \n    /  \\ \\       \n __/ /\\ \\ \\      \n/___/ /\\ \\ \\     \n\\___\\/ / / /     \n      / / /      \n     / / /    _  \n     \\ \\ \\__/\\_\\ \n      \\ \\___\\/ / \n       \\/___/_/  \n                 \n',
    '}': u'    _     \n  /\\ \\    \n /  \\ \\   \n/ /\\ \\ \\  \n\\/_/\\ \\ \\ \n    / / / \n _  \\ \\ \\ \n/\\ \\/ / / \n\\ \\/ / /  \n \\  / /   \n  \\/_/    \n          \n',
    '|': u' __   \n/_/\\  \n\\ \\ \\ \n/ / / \n\\ \\ \\ \n/ / / \n\\ \\ \\ \n/ / / \n\\ \\ \\ \n/_/ / \n\\_\\/  \n      \n',
    '~': u'   ________      \n  /_______/\\__   \n _\\   __  \\/__/\\ \n/__\\   /\\_____\\/ \n\\_____/          \n                 \n                 \n                 \n                 \n                 \n                 \n                 \n'}

jacky_dic = {
    '!': u'_______ \n\\     / \n \\   /  \n  ) (   \n  \\_/   \n   _    \n  (_)   \n        \n',
    ' ': u'   \n   \n   \n   \n   \n   \n   \n   \n',
    '#': u'   _   _    \n _| |_| |_  \n(_   _   _) \n  | | | |   \n _| |_| |_  \n(_   _   _) \n  |_| |_|   \n            \n',
    '"': u' _  _  \n(( ((  \n )) )) \n       \n       \n       \n       \n       \n',
    '%': u' __   _  \n(__) / ) \n    / /  \n   / /   \n  / /    \n / / __  \n(_/ (__) \n         \n',
    '$': u'     _      \n   _| |____ \n  / | |___/ \n (_(| |___  \n ___| |_) ) \n/___| |__/  \n    |_|     \n            \n',
    "'": u' __  \n(  ) \n \\/  \n     \n     \n     \n     \n     \n',
    '&': u'  ___      \n / _ \\     \n( (_) )    \n \\/  /     \n / _/\\     \n( (_)_\\__  \n \\_______) \n      \\_\\  \n',
    ')': u'___    \n)_ \\   \n  \\ \\  \n   ) ) \n   ) ) \n__/ /  \n)__/   \n       \n',
    '(': u'   ___ \n  / _( \n / /   \n( (    \n( (    \n \\ \\__ \n  \\__( \n       \n',
    '+': u'     _      \n    | |     \n ___| |___  \n(___   ___) \n    | |     \n    |_|     \n            \n            \n',
    '*': u'       \n(\\/\\/) \n<(())> \n(/\\/\\) \n       \n       \n       \n       \n',
    '-': u'           \n           \n ________  \n(________) \n           \n           \n           \n           \n',
    ',': u'     \n     \n     \n     \n     \n __  \n(  ) \n/_/  \n',
    '/': u'      _  \n     / ) \n    / /  \n   / /   \n  / /    \n / /     \n(_/      \n         \n',
    '.': u'     \n     \n     \n     \n     \n __  \n(__) \n     \n',
    '1': u'   ____ \n  /   / \n / /) ) \n/_/( (  \n    ) ) \n   ( (  \n   /__\\ \n        \n',
    '0': u'  ____   \n / __ \\  \n( (  ) ) \n( (  ) ) \n( (  ) ) \n( (__) ) \n \\____/  \n         \n',
    '3': u'_____   \n)__  \\  \n __) /  \n(__ (   \n   \\ \\  \n___/  ) \n)____/  \n        \n',
    '2': u'   ______   \n  (____  \\  \n       ) /  \n  __  / /   \n /  \\/ / __ \n( () \\__/ / \n \\__\\____(  \n            \n',
    '5': u' ______  \n|  ___(  \n| |__    \n|___ \\   \n    \\ \\  \n_____) ) \n)_____/  \n         \n',
    '4': u'  _   _     \n / / / \\    \n( (__) (___ \n \\___   __( \n     ) (    \n     ) (    \n    /___\\   \n            \n',
    '7': u'_________ \n)____   / \n  ___) /  \n  )__ (   \n     ) )  \n    ( (   \n    /__\\  \n          \n',
    '6': u'   ______ \n  / ____( \n / /      \n( (_____  \n(   ___ \\ \n \\ (___) )\n  \\_____/ \n          \n',
    '9': u'  _____    \n / __  \\   \n( (__)  \\  \n \\_____  ) \n       ) ) \n  ____/ /  \n )_____/   \n           \n',
    '8': u'  _____   \n /  _  \\  \n(  (_)  ) \n \\  _  /  \n / / \\ \\  \n( (___) ) \n \\_____/  \n          \n',
    ';': u'     \n __  \n(__) \n     \n     \n __  \n ) ) \n/_/  \n',
    ':': u'     \n __  \n(__) \n     \n     \n __  \n(__) \n     \n',
    '=': u'          \n _______  \n(_______) \n _______  \n(_______) \n          \n          \n          \n',
    '<': u'   _  \n  / ) \n / /  \n/ /   \n\\ \\   \n \\ \\  \n  \\_) \n      \n',
    '?': u' ______   \n(_____ \\  \n   ___) ) \n  (  __/  \n   )_)    \n   __     \n  (__)    \n          \n',
    '>': u' _    \n( \\   \n \\ \\  \n  \\ \\ \n  / / \n / /  \n(_/   \n      \n',
    '@': u'  _______    \n //    _\\\\   \n//  ___)|\\\\  \n(  / _  | )) \n\\\\( (_) |//  \n \\\\\\___/\\/   \n  \\____      \n             \n',
    '[': u' _______ \n(  ____( \n( (      \n( (      \n( (      \n( (____  \n(______( \n         \n',
    ']': u'_______  \n)____  ) \n     ) ) \n     ) ) \n     ) ) \n_____) ) \n)______) \n         \n',
    '\\': u' _       \n( \\      \n \\ \\     \n  \\ \\    \n   \\ \\   \n    \\ \\  \n     \\_) \n         \n',
    '_': u'              \n              \n              \n              \n              \n ___________  \n|___________| \n              \n',
    '^': u'       \n  /\\   \n /  \\  \n/_/\\_\\ \n       \n       \n       \n       \n',
    'a': u'   ____    \n  (    )   \n  / /\\ \\   \n ( (__) )  \n  )    (   \n /  /\\  \\  \n/__(  )__\\ \n           \n',
    '`': u'_   \n\\\\  \n \\) \n    \n    \n    \n    \n    \n',
    'c': u'   ____  \n  / ___) \n / /     \n( (      \n( (      \n \\ \\___  \n  \\____) \n         \n',
    'b': u' ______   \n(_   _ \\  \n  ) (_) ) \n  \\   _/  \n  /  _ \\  \n _) (_) ) \n(______/  \n          \n',
    'e': u'  _____  \n / ___/  \n( (__    \n ) __)   \n( (      \n \\ \\___  \n  \\____\\ \n         \n',
    'd': u' ______    \n(_  __ \\   \n  ) ) \\ \\  \n ( (   ) ) \n  ) )  ) ) \n / /__/ /  \n(______/   \n           \n',
    'g': u'    _____   \n   / ___ \\  \n  / /   \\_) \n ( (  ____  \n ( ( (__  ) \n  \\ \\__/ /  \n   \\____/   \n            \n',
    'f': u' _________  \n(_   _____) \n  ) (___    \n (   ___)   \n  ) (       \n (   )      \n  \\_/       \n            \n',
    'i': u'  _____  \n (_   _) \n   | |   \n   | |   \n   | |   \n  _| |__ \n /_____( \n         \n',
    'h': u' __    __  \n(  \\  /  ) \n \\ (__) /  \n  ) __ (   \n ( (  ) )  \n  ) )( (   \n /_/  \\_\\  \n           \n',
    'k': u'  __   ___  \n () ) / __) \n ( (_/ /    \n ()   (     \n () /\\ \\    \n ( (  \\ \\   \n ()_)  \\_\\  \n            \n',
    'j': u'  ________  \n (___  ___) \n     ) )    \n    ( (     \n __  ) )    \n( (_/ /     \n \\___/      \n            \n',
    'm': u'   __    __    \n   \\ \\  / /    \n   () \\/ ()    \n   / _  _ \\    \n  / / \\/ \\ \\   \n /_/      \\_\\  \n(/          \\) \n               \n',
    'l': u' _____      \n(_   _)     \n  | |       \n  | |       \n  | |   __  \n__| |___) ) \n\\________/  \n            \n',
    'o': u'   ____    \n  / __ \\   \n / /  \\ \\  \n( ()  () ) \n( ()  () ) \n \\ \\__/ /  \n  \\____/   \n           \n',
    'n': u'    __      _  \n   /  \\    / ) \n  / /\\ \\  / /  \n  ) ) ) ) ) )  \n ( ( ( ( ( (   \n / /  \\ \\/ /   \n(_/    \\__/    \n               \n',
    'q': u'   ____     \n  / __ \\    \n / /  \\ \\   \n( (    ) )  \n( (  /\\) )  \n \\ \\_\\ \\/   \n  \\___\\ \\_  \n       \\__) \n',
    'p': u' _____   \n(  __ \\  \n ) )_) ) \n(  ___/  \n ) )     \n( (      \n/__\\     \n         \n',
    's': u'  _____  \n / ____\\ \n( (___   \n \\___ \\  \n     ) ) \n ___/ /  \n/____/   \n         \n',
    'r': u' ______    \n(   __ \\   \n ) (__) )  \n(    __/   \n ) \\ \\  _  \n( ( \\ \\_)) \n )_) \\__/  \n           \n',
    'u': u' __    __  \n ) )  ( (  \n( (    ) ) \n ) )  ( (  \n( (    ) ) \n ) \\__/ (  \n \\______/  \n           \n',
    't': u' ________  \n(___  ___) \n    ) )    \n   ( (     \n    ) )    \n   ( (     \n   /__\\    \n           \n',
    'w': u' ___       ___  \n(  (       )  ) \n \\  \\  _  /  /  \n  \\  \\/ \\/  /   \n   )   _   (    \n   \\  ( )  /    \n    \\_/ \\_/     \n                \n',
    'v': u' __    __  \n ) )  ( (  \n( (    ) ) \n \\ \\  / /  \n  \\ \\/ /   \n   \\  /    \n    \\/     \n           \n',
    'y': u'__      __ \n) \\    / ( \n \\ \\  / /  \n  \\ \\/ /   \n   \\  /    \n    )(     \n   /__\\    \n           \n',
    'x': u' __     __  \n(_ \\   / _) \n  \\ \\_/ /   \n   \\   /    \n   / _ \\    \n _/ / \\ \\_  \n(__/   \\__) \n            \n',
    '{': u'  _____ \n / ___( \n ) )    \n/ /     \n\\ \\     \n ) )___ \n(_____( \n        \n',
    'z': u'  ______   \n (____  )  \n     / /   \n ___/ /_   \n/__  ___)  \n  / /____  \n (_______) \n           \n',
    '}': u'______   \n)____ \\  \n    ( (  \n     \\ \\ \n     / / \n____( (  \n)______) \n         \n',
    '|': u' _  \n( ) \n( ) \n( ) \n( ) \n( ) \n(_) \n    \n',
    '~': u'           \n  ___   _  \n / _ \\_/ ) \n(_/ \\___/  \n           \n           \n           \n           \n'}


katakana_dic = {
    ' ': u'   \n   \n   \n   \n   \n   \n   \n   \n',
    '$': u' #####  \n#  #  # \n#  #    \n #####  \n   #  # \n#  #  # \n #####  \n        \n',
    '(': u'  ## \n #   \n#    \n#    \n#    \n #   \n  ## \n     \n',
    ',': u'    \n    \n    \n    \n### \n### \n #  \n#   \n',
    '0': u'  ###   \n #   #  \n#     # \n#     # \n#     # \n #   #  \n  ###   \n        \n',
    '4': u'#       \n#    #  \n#    #  \n#    #  \n####### \n     #  \n     #  \n        \n',
    '8': u' #####  \n#     # \n#     # \n #####  \n#     # \n#     # \n #####  \n        \n',
    '<': u'   # \n  #  \n #   \n#    \n #   \n  #  \n   # \n     \n',
    '@': u' #####  \n#     # \n# ### # \n# ### # \n# ####  \n#       \n #####  \n        \n',
    'D': u'           \n  #######  \n     #     \n     #     \n     #     \n     #     \n########## \n           \n',
    'H': u'   #       \n  ######## \n #       # \n#      ##  \n     ##    \n   ##      \n ##        \n           \n',
    'L': u'  #       # \n#  #     #  \n #      #   \n      ##    \n    ##      \n  ##        \n##          \n            \n',
    'P': u'   #      \n  ####### \n #     #  \n# #   #   \n   ###    \n  ##      \n##        \n          \n',
    'T': u'#    \n#    \n##   \n# #  \n#  # \n#    \n#    \n     \n',
    'X': u'     #     \n########## \n        #  \n     ###   \n  ######   \n##   #  ## \n     #     \n           \n',
    '\\': u'#       \n #      \n  #     \n   #    \n    #   \n     #  \n      # \n        \n',
    '`': u'### \n### \n #  \n  # \n    \n    \n    \n    \n',
    'd': u'     #     \n########## \n     #     \n  #  # #   \n #   #  #  \n#   ##   # \n     #     \n           \n',
    'h': u'         # \n        #  \n   #   #   \n    # #    \n     #     \n   ## #    \n ##    #   \n           \n',
    'l': u'           \n  ######   \n      #    \n     #     \n     #     \n########## \n           \n           \n',
    'p': u'   # #     \n   # #     \n   # #     \n   # #   # \n  #  #  #  \n #   # #   \n#    ##    \n           \n',
    't': u'     #     \n  #######  \n   # #     \n   # #     \n########## \n     #     \n     #     \n           \n',
    'x': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '|': u'# \n# \n# \n  \n# \n# \n# \n  \n',
    '#': u'  # #   \n  # #   \n####### \n  # #   \n####### \n  # #   \n  # #   \n        \n',
    "'": u'### \n### \n #  \n#   \n    \n    \n    \n    \n',
    '+': u'      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n',
    '/': u'      # \n     #  \n    #   \n   #    \n  #     \n #      \n#       \n        \n',
    '3': u' #####  \n#     # \n      # \n #####  \n      # \n#     # \n #####  \n        \n',
    '7': u'####### \n#    #  \n    #   \n   #    \n  #     \n  #     \n  #     \n        \n',
    ';': u'    \n### \n### \n    \n### \n### \n #  \n#   \n',
    '?': u' #####  \n#     # \n      # \n   ###  \n   #    \n        \n   #    \n        \n',
    'C': u'    #      \n########## \n#        # \n       ##  \n     ##    \n   ##      \n ##        \n           \n',
    'G': u'# #     \n #   #  \n# # #   \n   #    \n  # #   \n #   #  \n      # \n        \n',
    'K': u'  #    #   \n########## \n  #    #   \n       #   \n      #    \n     #     \n   #       \n           \n',
    'O': u'#       # \n#       # \n       #  \n      #   \n    ##    \n  ##      \n##        \n          \n',
    'S': u'  ######   \n           \n########## \n     #     \n     #     \n    #      \n  ##       \n           \n',
    'W': u'########## \n         # \n   #    #  \n    # ##   \n    ##     \n  ##  #    \n##     #   \n           \n',
    '[': u'##### \n#     \n#     \n#     \n#     \n#     \n##### \n      \n',
    '_': u'        \n        \n        \n        \n        \n        \n        \n####### \n',
    'c': u'           \n           \n  ##       \n #  ##     \n#     ##   \n        ## \n           \n           \n',
    'g': u'     #     \n    #      \n   #       \n  #        \n #     #   \n#########  \n         # \n           \n',
    'k': u'           \n  ######   \n       #   \n       #   \n       #   \n########## \n           \n           \n',
    'o': u'#   # \n#   # \n#   # \n#   # \n   #  \n  #   \n##    \n      \n',
    's': u'########## \n#        # \n        #  \n       #   \n      #    \n    ##     \n  ##       \n           \n',
    'w': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '{': u'  ### \n #    \n #    \n##    \n #    \n #    \n  ### \n      \n',
    '"': u'### ### \n### ### \n #   #  \n        \n        \n        \n        \n        \n',
    '&': u'  ##    \n #  #   \n  ##    \n ###    \n#   # # \n#    #  \n ###  # \n        \n',
    '*': u'        \n #   #  \n  # #   \n####### \n  # #   \n #   #  \n        \n        \n',
    '.': u'    \n    \n    \n    \n### \n### \n### \n    \n',
    '2': u' #####  \n#     # \n      # \n #####  \n#       \n#       \n####### \n        \n',
    '6': u' #####  \n#     # \n#       \n######  \n#     # \n#     # \n #####  \n        \n',
    ':': u' #  \n### \n #  \n    \n #  \n### \n #  \n    \n',
    '>': u'#    \n #   \n  #  \n   # \n  #  \n #   \n#    \n     \n',
    'B': u'      ## \n    ##   \n  ## #   \n##   #   \n     #   \n     #   \n     #   \n         \n',
    'F': u'     #     \n########## \n    #    # \n    #    # \n   #     # \n  #   # #  \n #     #   \n           \n',
    'J': u'           \n########## \n         # \n         # \n         # \n         # \n#########  \n           \n',
    'N': u'  #        \n  #        \n########## \n  #     #  \n  #        \n  #        \n   ######  \n           \n',
    'R': u'# #     # \n# #     # \n       #  \n      #   \n    ##    \n  ##      \n##        \n          \n',
    'V': u'           \n           \n  ######   \n           \n           \n########## \n           \n           \n',
    'Z': u'          \n          \n   #  #   \n  #    #  \n #      # \n#         \n          \n          \n',
    '^': u'  #   \n # #  \n#   # \n      \n      \n      \n      \n      \n',
    'b': u'######## \n       # \n       # \n      #  \n    ##   \n  ##     \n##       \n         \n',
    'f': u'####   \n    ## \n###    \n   ### \n       \n###    \n   ### \n       \n',
    'j': u'#     ##   \n #  ## #   \n ###       \n#  #       \n    #      \n     #     \n      #    \n           \n',
    'n': u'  ######   \n           \n########## \n#        # \n       ##  \n     ##    \n   ##      \n           \n',
    'r': u'          \n######### \n#       # \n#       # \n#       # \n######### \n          \n          \n',
    'v': u'        # \n#       # \n #     #  \n      #   \n    ##    \n  ##      \n##        \n          \n',
    'z': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '~': u' ##     \n#  #  # \n    ##  \n        \n        \n        \n        \n        \n',
    '!': u'### \n### \n### \n #  \n    \n### \n### \n    \n',
    '%': u'###   # \n# #  #  \n### #   \n   #    \n  # ### \n #  # # \n#   ### \n        \n',
    ')': u'##   \n  #  \n   # \n   # \n   # \n  #  \n##   \n     \n',
    '-': u'      \n      \n      \n##### \n      \n      \n      \n      \n',
    '1': u'   #   \n  ##   \n # #   \n   #   \n   #   \n   #   \n ##### \n       \n',
    '5': u'####### \n#       \n#       \n######  \n      # \n#     # \n #####  \n        \n',
    '9': u' #####  \n#     # \n#     # \n ###### \n      # \n#     # \n #####  \n        \n',
    '=': u'      \n      \n##### \n      \n##### \n      \n      \n      \n',
    'A': u'########## \n      ###  \n     #     \n    #      \n   #       \n  #        \n #         \n           \n',
    'E': u'       #   \n########## \n      ##   \n    ## #   \n  ##   #   \n##    ##   \n       #   \n           \n',
    'I': u'   #       \n  ######## \n #    #    \n#    #     \n    #      \n   #       \n  #        \n           \n',
    'M': u'######## \n       # \n      #  \n    ##   \n  ## #   \n ##   #  \n#      # \n         \n',
    'Q': u'       ##  \n ######    \n     #     \n########## \n     #     \n     #     \n   ##      \n           \n',
    'U': u'     #     \n########## \n     #     \n     #     \n    #      \n   #       \n ##        \n           \n',
    'Y': u'        # \n        # \n       #  \n      #   \n    ##    \n  ##      \n##        \n          \n',
    ']': u'##### \n    # \n    # \n    # \n    # \n    # \n##### \n      \n',
    'a': u'#        \n#   ###  \n####     \n#        \n#        \n#        \n ####### \n         \n',
    'e': u'           \n########## \n        #  \n       #   \n    # #    \n     #     \n      #    \n           \n',
    'i': u'  ######   \n    #      \n########## \n    #      \n    #      \n    #      \n     ####  \n           \n',
    'm': u'######### \n        # \n        # \n########  \n       #  \n       #  \n########  \n          \n',
    'q': u'#        \n#        \n#        \n#     ## \n#   ##   \n# ##     \n##       \n         \n',
    'u': u'########## \n         # \n        #  \n########   \n    ##     \n  ##       \n##         \n           \n',
    'y': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '}': u'###   \n   #  \n   #  \n   ## \n   #  \n   #  \n###   \n      \n'}

keyboard_dic = {
    ' ': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n',
    '$': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |   | |\n| +---+ |\n|/_____\\|\n         \n',
    '(': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |(  | |\n| +---+ |\n|/_____\\|\n         \n',
    ',': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |,  | |\n| +---+ |\n|/_____\\|\n         \n',
    '0': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |0  | |\n| +---+ |\n|/_____\\|\n         \n',
    '4': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |4  | |\n| +---+ |\n|/_____\\|\n         \n',
    '8': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |8  | |\n| +---+ |\n|/_____\\|\n         \n',
    '<': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |<  | |\n| +---+ |\n|/_____\\|\n         \n',
    '@': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |@  | |\n| +---+ |\n|/_____\\|\n         \n',
    'D': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |D  | |\n| +---+ |\n|/_____\\|\n         \n',
    'H': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |H  | |\n| +---+ |\n|/_____\\|\n         \n',
    'L': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |L  | |\n| +---+ |\n|/_____\\|\n         \n',
    'P': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |P  | |\n| +---+ |\n|/_____\\|\n         \n',
    'T': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |T  | |\n| +---+ |\n|/_____\\|\n         \n',
    'X': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |X  | |\n| +---+ |\n|/_____\\|\n         \n',
    '\\': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |\\  | |\n| +---+ |\n|/_____\\|\n         \n',
    '`': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |`  | |\n| +---+ |\n|/_____\\|\n         \n',
    'd': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |d  | |\n| +---+ |\n|/_____\\|\n         \n',
    'h': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |h  | |\n| +---+ |\n|/_____\\|\n         \n',
    'l': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |l  | |\n| +---+ |\n|/_____\\|\n         \n',
    'p': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |p  | |\n| +---+ |\n|/_____\\|\n         \n',
    't': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |t  | |\n| +---+ |\n|/_____\\|\n         \n',
    'x': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |x  | |\n| +---+ |\n|/_____\\|\n         \n',
    '|': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| ||  | |\n| +---+ |\n|/_____\\|\n         \n',
    '#': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |#  | |\n| +---+ |\n|/_____\\|\n         \n',
    "'": u"         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |'  | |\n| +---+ |\n|/_____\\|\n         \n",
    '+': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |+  | |\n| +---+ |\n|/_____\\|\n         \n',
    '/': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |/  | |\n| +---+ |\n|/_____\\|\n         \n',
    '3': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |3  | |\n| +---+ |\n|/_____\\|\n         \n',
    '7': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |7  | |\n| +---+ |\n|/_____\\|\n         \n',
    ';': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |;  | |\n| +---+ |\n|/_____\\|\n         \n',
    '?': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |?  | |\n| +---+ |\n|/_____\\|\n         \n',
    'C': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |C  | |\n| +---+ |\n|/_____\\|\n         \n',
    'G': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |G  | |\n| +---+ |\n|/_____\\|\n         \n',
    'K': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |K  | |\n| +---+ |\n|/_____\\|\n         \n',
    'O': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |O  | |\n| +---+ |\n|/_____\\|\n         \n',
    'S': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |S  | |\n| +---+ |\n|/_____\\|\n         \n',
    'W': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |W  | |\n| +---+ |\n|/_____\\|\n         \n',
    '[': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |[  | |\n| +---+ |\n|/_____\\|\n         \n',
    '_': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |_  | |\n| +---+ |\n|/_____\\|\n         \n',
    'c': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |c  | |\n| +---+ |\n|/_____\\|\n         \n',
    'g': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |g  | |\n| +---+ |\n|/_____\\|\n         \n',
    'k': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |k  | |\n| +---+ |\n|/_____\\|\n         \n',
    'o': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |o  | |\n| +---+ |\n|/_____\\|\n         \n',
    's': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |s  | |\n| +---+ |\n|/_____\\|\n         \n',
    'w': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |w  | |\n| +---+ |\n|/_____\\|\n         \n',
    '{': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |{  | |\n| +---+ |\n|/_____\\|\n         \n',
    '"': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |"  | |\n| +---+ |\n|/_____\\|\n         \n',
    '&': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |&  | |\n| +---+ |\n|/_____\\|\n         \n',
    '*': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |*  | |\n| +---+ |\n|/_____\\|\n         \n',
    '.': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |.  | |\n| +---+ |\n|/_____\\|\n         \n',
    '2': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |2  | |\n| +---+ |\n|/_____\\|\n         \n',
    '6': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |6  | |\n| +---+ |\n|/_____\\|\n         \n',
    ':': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |:  | |\n| +---+ |\n|/_____\\|\n         \n',
    '>': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |>  | |\n| +---+ |\n|/_____\\|\n         \n',
    'B': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |B  | |\n| +---+ |\n|/_____\\|\n         \n',
    'F': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |F  | |\n| +---+ |\n|/_____\\|\n         \n',
    'J': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |J  | |\n| +---+ |\n|/_____\\|\n         \n',
    'N': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |N  | |\n| +---+ |\n|/_____\\|\n         \n',
    'R': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |R  | |\n| +---+ |\n|/_____\\|\n         \n',
    'V': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |V  | |\n| +---+ |\n|/_____\\|\n         \n',
    'Z': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |Z  | |\n| +---+ |\n|/_____\\|\n         \n',
    '^': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |^  | |\n| +---+ |\n|/_____\\|\n         \n',
    'b': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |b  | |\n| +---+ |\n|/_____\\|\n         \n',
    'f': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |f  | |\n| +---+ |\n|/_____\\|\n         \n',
    'j': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |j  | |\n| +---+ |\n|/_____\\|\n         \n',
    'n': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |n  | |\n| +---+ |\n|/_____\\|\n         \n',
    'r': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |r  | |\n| +---+ |\n|/_____\\|\n         \n',
    'v': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |v  | |\n| +---+ |\n|/_____\\|\n         \n',
    'z': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |z  | |\n| +---+ |\n|/_____\\|\n         \n',
    '~': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |~  | |\n| +---+ |\n|/_____\\|\n         \n',
    '!': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |!  | |\n| +---+ |\n|/_____\\|\n         \n',
    '%': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |%  | |\n| +---+ |\n|/_____\\|\n         \n',
    ')': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |)  | |\n| +---+ |\n|/_____\\|\n         \n',
    '-': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |-  | |\n| +---+ |\n|/_____\\|\n         \n',
    '1': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |1  | |\n| +---+ |\n|/_____\\|\n         \n',
    '5': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |5  | |\n| +---+ |\n|/_____\\|\n         \n',
    '9': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |9  | |\n| +---+ |\n|/_____\\|\n         \n',
    '=': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |=  | |\n| +---+ |\n|/_____\\|\n         \n',
    'A': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |A  | |\n| +---+ |\n|/_____\\|\n         \n',
    'E': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |E  | |\n| +---+ |\n|/_____\\|\n         \n',
    'I': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |I  | |\n| +---+ |\n|/_____\\|\n         \n',
    'M': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |M  | |\n| +---+ |\n|/_____\\|\n         \n',
    'Q': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |Q  | |\n| +---+ |\n|/_____\\|\n         \n',
    'U': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |U  | |\n| +---+ |\n|/_____\\|\n         \n',
    'Y': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |Y  | |\n| +---+ |\n|/_____\\|\n         \n',
    ']': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |]  | |\n| +---+ |\n|/_____\\|\n         \n',
    'a': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |a  | |\n| +---+ |\n|/_____\\|\n         \n',
    'e': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |e  | |\n| +---+ |\n|/_____\\|\n         \n',
    'i': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |i  | |\n| +---+ |\n|/_____\\|\n         \n',
    'm': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |m  | |\n| +---+ |\n|/_____\\|\n         \n',
    'q': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |q  | |\n| +---+ |\n|/_____\\|\n         \n',
    'u': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |u  | |\n| +---+ |\n|/_____\\|\n         \n',
    'y': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |y  | |\n| +---+ |\n|/_____\\|\n         \n',
    '}': u'         \n _______ \n|\\     /|\n| +---+ |\n| |   | |\n| |}  | |\n| +---+ |\n|/_____\\|\n         \n'}

knob_dic = {
    '!': u' _ _______ \n(_)_______)\n           \n           \n',
    ' ': u'  \n  \n  \n  \n',
    '#': u'',
    '"': u'       __  \n      (__) \n      (__) \n           \n',
    '%': u'%\n \n \n \n',
    '$': u'$\n \n \n \n',
    "'": u'       __  \n      (__) \n           \n           \n',
    '&': u'&\n \n \n \n',
    ')': u' _       _ \n( )_____( )\n(_________)\n           \n',
    '(': u' _________ \n(  _____  )\n(_)     (_)\n           \n',
    '+': u'+\n \n \n \n',
    '*': u'*\n \n \n \n',
    '-': u'     _  \n    ( ) \n    | | \n    (_) \n',
    ',': u',\n \n \n \n',
    '/': u'/\n \n \n \n',
    '.': u' _  \n(_) \n    \n    \n',
    '1': u'        _  \n ______( \\ \n(_________)\n           \n',
    '0': u' _________ \n(  _____  )\n| |_____| |\n(_________)\n',
    '3': u' _   _   _ \n( ) ( ) ( )\n| |_| |_| |\n(_________)\n',
    '2': u' _____   _ \n(  _  ) ( )\n| | | |_| |\n(_) (_____)\n',
    '5': u' _   _____ \n( ) (  _  )\n| |_| | | |\n(_____) (_)\n',
    '4': u'     _____ \n    (  ___)\n ___| |___ \n(_________)\n',
    '7': u'         _ \n        ( )\n _______| |\n(_________)\n',
    '6': u' _________ \n(  _   _  )\n| |_| | | |\n(_____) (_)\n',
    '9': u' _   _____ \n( ) (  _  )\n| |_| |_| |\n(_________)\n',
    '8': u" ____ ____ \n(  _ ' _  )\n| |_| |_| |\n(____.____)\n",
    ';': u' __     _  \n(__)   (_) \n           \n           \n',
    ':': u'  _     _  \n (_)   (_) \n           \n           \n',
    '=': u'=\n \n \n \n',
    '<': u'<\n \n \n \n',
    '?': u' _  __   _ \n(_)(  ) ( )\n    | |_| |\n    (_____)\n',
    '>': u'>\n \n \n \n',
    '@': u'@\n \n \n \n',
    '[': u'[\n \n \n \n',
    ']': u']\n \n \n \n',
    '\\': u'\\\n \n \n \n',
    '_': u'_\n \n \n \n',
    '^': u'       __  \n      (__) \n       _(_)\n      (__) \n',
    'a': u' _________ \n(____  _  )\n ___| |_| |\n(_________)\n',
    '`': u'        _  \n      _(_) \n     (__)  \n           \n',
    'c': u' _________ \n(  _____  )\n| |     | |\n(_)     (_)\n',
    'b': u' _________ \n(  _   _  )\n| |_| |_| |\n(____/\\___)\n',
    'e': u' _________ \n(  _   _  )\n| | | | | |\n(_) (_) (_)\n',
    'd': u' _________ \n(  _____  )\n \\ \\___/ / \n  (_____)  \n',
    'g': u' _________ \n(  _____  )\n| |_    | |\n(___)   (_)\n',
    'f': u' _________ \n(___   _  )\n    | | | |\n    (_) (_)\n',
    'i': u' _______ _ \n(_______(_)\n           \n           \n',
    'h': u' _________ \n(___   ___)\n ___| |___ \n(_________)\n',
    'k': u' _________ \n(___    __)\n __/ __ \\_ \n(___/  \\__)\n',
    'j': u' ___       \n(  _)      \n| |_______ \n(_________)\n',
    'm': u' _________ \n(______   )\n _____(   )\n(_________)\n',
    'l': u' _________ \n(  _______)\n| |        \n(_)        \n',
    'o': u' _________ \n(  _____  )\n| |_____| |\n(_________)\n',
    'n': u' _________ \n(______  _)\n _____/ /_ \n(_________)\n',
    'q': u' _________ \n(  _____  )\n| |_____| |\n(_)_______)\n',
    'p': u' _________ \n(___   _  )\n    | |_| |\n    (_____)\n',
    's': u' _   _____ \n( ) (  _  )\n| |_| | | |\n(_____) (_)\n',
    'r': u' _________ \n(___   _  )\n _/   |_| |\n(__/(_____)\n',
    'u': u' _________ \n(  _______)\n| |_______ \n(_________)\n',
    't': u'         _ \n _______| |\n(_______  |\n        |_|\n',
    'w': u' _________ \n(  _______)\n(  __)____ \n(_________)\n',
    'v': u'  ________ \n / _______)\n| (_______ \n \\________)\n',
    'y': u'     _____ \n ___/  ___)\n(___  (___ \n    \\_____)\n',
    'x': u' ____  ___ \n(__  \\/  _)\n __)    (_ \n(____/\\___)\n',
    '{': u'{\n \n \n \n',
    'z': u' _____   _ \n(  _  ) ( )\n| | | |_| |\n(_) (_____)\n',
    '}': u'}\n \n \n \n',
    '|': u'|\n \n \n \n',
    '~': u'~\n \n \n \n'}

lildevil_dic = {
    '!': u",---. \n|   | \n|   | \n|   | \n|  .' \n`--'  \n.--.  \n`--'  \n",
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u"           \n           \n  ,-.,-.   \n,-| || |-. \n,-| || |-. \n'-| || |-' \n  `-'`-'   \n           \n",
    '"': u"         \n,--.,--. \n\\  |\\  | \n `-' `-' \n         \n         \n         \n         \n",
    '%': u"     ,-. \n ,-. / / \n '-'/ /  \n   / /   \n  / /    \n / /,-.  \n/ / '-'  \n`-'      \n",
    '$': u"  ,-.    \n.-|-|-.  \n| | |_|  \n`-|.| '. \n.-| |  | \n| |-|  / \n `|-|''  \n  `-'    \n",
    "'": u"     \n,--. \n\\  | \n `-' \n     \n     \n     \n     \n",
    '&': u"           \n .---.     \n/ .-. \\    \n\\ '-' ,-.  \n/ /'.   /  \n\\ '-' .__) \n `---'     \n           \n",
    ')': u",-.   \n|  \\  \n'.  ' \n |  | \n |  | \n.'  ' \n|  /  \n`-'   \n",
    '(': u"  ,-. \n /  | \n'  .' \n|  |  \n|  |  \n'  '. \n \\  | \n  `-' \n",
    '+': u"        \n        \n  ,-.   \n,-| |-. \n'-| |-' \n  `-'   \n        \n        \n",
    '*': u"           \n     _     \n .-,| |,-. \n _\\ ' ' /_ \n(__     __)\n  / . . \\  \n `-'|_|`-' \n           \n",
    '-': u"          \n          \n (`-')    \n ( OO).-> \n(,------. \n `------' \n          \n          \n",
    ',': u"    \n    \n    \n    \n    \n    \n,-. \n'./ \n",
    '/': u"     ,-. \n     / / \n    / /  \n   / /   \n  / /    \n / /     \n/ /      \n`-'      \n",
    '.': u"    \n    \n    \n    \n    \n    \n,-. \n'-' \n",
    '1': u"      \n      \n .--. \n/_  | \n |  | \n |  | \n |  | \n `--' \n",
    '0': u"           \n           \n  .----.   \n /  ..  \\  \n|  /  \\  . \n'  \\  /  ' \n \\  `'  /  \n  `---''   \n",
    '3': u"         \n         \n .----.  \n\\_.-,  | \n  |_  <  \n.-. \\  | \n\\ `-'  / \n `---''  \n",
    '2': u"         \n         \n .----.  \n\\_,-.  | \n   .' .' \n .'  /_  \n|      | \n`------' \n",
    '5': u"         \n         \n.-----.  \n|   __|  \n`--.  '. \n.-  |  | \n| `-'  / \n `---''  \n",
    '4': u"          \n          \n   .---.  \n  / .  |  \n / /|  |  \n/ '-'  || \n`---|  |' \n    `--'  \n",
    '7': u"          \n          \n.-------. \n|   _   ' \n`-' /  /  \n   .  /   \n  /  /    \n `--'     \n",
    '6': u"         \n         \n  ,--.   \n /  .'   \n.  / -.  \n'  .-. \\ \n\\  `-' / \n `----'  \n",
    '9': u"          \n          \n .----.   \n/ ,-.  \\  \n\\ '-'   . \n `- /  .' \n  .'  /   \n  `--'    \n",
    '8': u"         \n         \n .----.  \n/ .-.  \\ \n\\ '-'  / \n/ /`.  \\ \n\\ '-'  / \n `---''  \n",
    ';': u"    \n    \n,-. \n'-' \n,-. \n'./ \n    \n    \n",
    ':': u"    \n    \n,-. \n'-' \n,-. \n'-' \n    \n    \n",
    '=': u"        \n        \n,-----. \n'-----' \n,-----. \n'-----' \n        \n        \n",
    '<': u"   ,-. \n  /  | \n /  .' \n/  /   \n\\  \\   \n \\  '. \n  \\  | \n   `-' \n",
    '?': u" ,------.  \n/  .--.  ' \n|  |  |  | \n`--'__.  | \n   |   .'  \n   |___|   \n   .---.   \n   `---'   \n",
    '>': u",-.    \n|  \\   \n'.  \\  \n  \\  \\ \n  /  / \n.'  /  \n|  /   \n`-'    \n",
    '@': u"         \n    <-.  \n ,----.' \n' (`-')| \n| (OO /  \n'  '-'\\  \n `----'  \n         \n",
    '[': u",----. \n|    | \n|  .-' \n|  |   \n|  |   \n|  '-. \n|    | \n`----' \n",
    ']': u",----. \n|    | \n`-.  | \n  |  | \n  |  | \n.-'  | \n|    | \n`----' \n",
    '\\': u",-.      \n\\ \\      \n \\ \\     \n  \\ \\    \n   \\ \\   \n    \\ \\  \n     \\ \\ \n     `-' \n",
    '_': u"          \n          \n          \n          \n   (`-')  \n<-.(OO )  \n,------.) \n`------'  \n",
    '^': u"        \n  ,--.  \n / \\  \\ \n`--'`-- \n        \n        \n        \n        \n",
    'a': u" (`-')  _  \n (OO ).-/  \n / ,---.   \n | \\ /`.\\  \n '-'|_.' | \n(|  .-.  | \n |  | |  | \n `--' `--' \n",
    '`': u"       \n,--.   \n'.  \\  \n  `--' \n       \n       \n       \n       \n",
    'c': u"           \n _         \n \\-,-----. \n  |  .--./ \n /_) (`-') \n ||  |OO ) \n(_'  '--'\\ \n   `-----' \n",
    'b': u"<-.(`-')  \n __( OO)  \n'-'---.\\  \n| .-. (/  \n| '-' `.) \n| /`'.  | \n| '--'  / \n`------'  \n",
    'e': u" (`-')  _ \n ( OO).-/ \n(,------. \n |  .---' \n(|  '--.  \n |  .--'  \n |  `---. \n `------' \n",
    'd': u" _(`-')    \n( (OO ).-> \n \\    .'_  \n '`'-..__) \n |  |  ' | \n |  |  / : \n |  '-'  / \n `------'  \n",
    'g': u"           \n    .->    \n ,---(`-') \n'  .-(OO ) \n|  | .-, \\ \n|  | '.(_/ \n|  '-'  |  \n `-----'   \n",
    'f': u"           \n   <-.     \n(`-')-----.\n(OO|(_\\---'\n / |  '--. \n \\_)  .--' \n  `|  |_)  \n   `--'    \n",
    'i': u"  _      \n (_)     \n ,-(`-') \n | ( OO) \n |  |  ) \n(|  |_/  \n |  |'-> \n `--'    \n",
    'h': u" (`-').-> \n (OO )__  \n,--. ,'-' \n|  | |  | \n|  `-'  | \n|  .-.  | \n|  | |  | \n`--' `--' \n",
    'k': u"<-.(`-')  \n __( OO)  \n'-'. ,--. \n|  .'   / \n|      /) \n|  .   '  \n|  |\\   \\ \n`--' '--' \n",
    'j': u"          \n          \n   <-.--. \n (`-'| ,| \n (OO |(_| \n,--. |  | \n|  '-'  / \n `-----'  \n",
    'm': u"<-. (`-')  \n   \\(OO )_ \n,--./  ,-.)\n|   `.'   |\n|  |'.'|  |\n|  |   |  |\n|  |   |  |\n`--'   `--'\n",
    'l': u"          \n   <-.    \n ,--. )   \n |  (`-') \n |  |OO ) \n(|  '__ | \n |     |' \n `-----'  \n",
    'o': u"           \n     .->   \n(`-')----. \n( OO).-.  '\n( _) | |  |\n \\|  |)|  |\n  '  '-'  '\n   `-----' \n",
    'n': u"<-. (`-')_ \n   \\( OO) )\n,--./ ,--/ \n|   \\ |  | \n|  . '|  |)\n|  |\\    | \n|  | \\   | \n`--'  `--' \n",
    'q': u" <-.(`-')  \n  __( OO)  \n '-'---\\_) \n|  .-.  |  \n|  | | <-' \n|  | |  |  \n'  '-'  '-.\n `-----'--'\n",
    'p': u" _  (`-') \n \\-.(OO ) \n _.'    \\ \n(_...--'' \n|  |_.' | \n|  .___.' \n|  |      \n`--'      \n",
    's': u" (`-').-> \n ( OO)_   \n(_)--\\_)  \n/    _ /  \n\\_..`--.  \n.-._)   \\ \n\\       / \n `-----'  \n",
    'r': u"   (`-')  \n<-.(OO )  \n,------,) \n|   /`. ' \n|  |_.' | \n|  .   .' \n|  |\\  \\  \n`--' '--' \n",
    'u': u"           \n     .->   \n,--.(,--.  \n|  | |(`-')\n|  | |(OO )\n|  | | |  \\\n\\  '-'(_ .'\n `-----'   \n",
    't': u"(`-')      \n( OO).->   \n/    '._   \n|'--...__) \n`--.  .--' \n   |  |    \n   |  |    \n   `--'    \n",
    'w': u"     .->   \n (`(`-')/`)\n,-`( OO).',\n|  |\\  |  |\n|  | '.|  |\n|  |.'.|  |\n|   ,'.   |\n`--'   '--'\n",
    'v': u"      (`-')\n     _(OO )\n,--.(_/,-.\\\n\\   \\ / (_/\n \\   /   / \n_ \\     /_)\n\\-'\\   /   \n    `-'    \n",
    'y': u"           \n     .->   \n ,--.'  ,-.\n(`-')'.'  /\n(OO \\    / \n |  /   /) \n `-/   /`  \n   `--'    \n",
    'x': u" (`-')     \n (OO )_.-> \n (_| \\_)--.\n \\  `.'  / \n  \\    .') \n  .'    \\  \n /  .'.  \\ \n`--'   '--'\n",
    '{': u"  ,--. \n |   | \n |  .' \n/  /   \n\\  \\   \n |  '. \n |   | \n  `--' \n",
    'z': u"  (`-')    \n  ( OO).-> \n,(_/----.  \n|__,    |  \n (_/   /   \n .'  .'_   \n|       |  \n`-------'  \n",
    '}': u",--.   \n|   |  \n'.  |  \n  \\  \\ \n  /  / \n.'  |  \n|   |  \n`--'   \n",
    '|': u",-. \n| | \n| | \n| | \n| | \n| | \n| | \n`-' \n",
    '~': u"     .--, \n  .-'  /  \n /  --`   \n`--'      \n          \n          \n          \n          \n"}

lineblocks_dic = {
    '!': u'!\n \n \n \n \n',
    ' ': u'  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u'"\n \n \n \n \n',
    '%': u'%\n \n \n \n \n',
    '$': u' \n \n \n \n \n',
    "'": u"'\n \n \n \n \n",
    '&': u'&\n \n \n \n \n',
    ')': u')\n \n \n \n \n',
    '(': u'(\n \n \n \n \n',
    '+': u'+\n \n \n \n \n',
    '*': u'*\n \n \n \n \n',
    '-': u'-\n \n \n \n \n',
    ',': u',\n \n \n \n \n',
    '/': u'/\n \n \n \n \n',
    '.': u'.\n \n \n \n \n',
    '1': u'1\n \n \n \n \n',
    '0': u'0\n \n \n \n \n',
    '3': u'3\n \n \n \n \n',
    '2': u'2\n \n \n \n \n',
    '5': u'5\n \n \n \n \n',
    '4': u'4\n \n \n \n \n',
    '7': u'7\n \n \n \n \n',
    '6': u'6\n \n \n \n \n',
    '9': u'9\n \n \n \n \n',
    '8': u'8\n \n \n \n \n',
    ';': u';\n \n \n \n \n',
    ':': u':\n \n \n \n \n',
    '=': u'=\n \n \n \n \n',
    '<': u'<\n \n \n \n \n',
    '?': u' ______  \n|_|  | | \n   __|_| \n  |_|    \n   _     \n',
    '>': u'>\n \n \n \n \n',
    '@': u'@\n \n \n \n \n',
    '[': u'[\n \n \n \n \n',
    ']': u']\n \n \n \n \n',
    '\\': u'\\\n \n \n \n \n',
    '_': u'_\n \n \n \n \n',
    '^': u'^\n \n \n \n \n',
    'a': u' ______  \n| |  | | \n| |__| | \n|_|  |_| \n         \n',
    '`': u'`\n \n \n \n \n',
    'c': u' ______ \n| |     \n| |     \n|_|____ \n        \n',
    'b': u' ______  \n| |  | \\ \n| |--| < \n|_|__|_/ \n         \n',
    'e': u' ______ \n| |     \n| |---- \n|_|____ \n        \n',
    'd': u' _____   \n| | \\ \\  \n| |  | | \n|_|_/_/  \n         \n',
    'g': u' ______  \n| | ____ \n| |  | | \n|_|__|_| \n         \n',
    'f': u' ______ \n| |     \n| |---- \n|_|     \n        \n',
    'i': u'_____ \n | |  \n | |  \n_|_|_ \n      \n',
    'h': u' _    _  \n| |  | | \n| |--| | \n|_|  |_| \n         \n',
    'k': u' _    __ \n| |  / / \n| |-< <  \n|_|  \\_\\ \n         \n',
    'j': u'      _  \n     | | \n _   | | \n|_|__|_| \n         \n',
    'm': u' _________  \n| | | | | \\ \n| | | | | | \n|_| |_| |_| \n            \n',
    'l': u' _       \n| |      \n| |   _  \n|_|__|_| \n         \n',
    'o': u' ______  \n/ |  | \\ \n| |  | | \n\\_|__|_/ \n         \n',
    'n': u' ______  \n| |  \\ \\ \n| |  | | \n|_|  |_| \n         \n',
    'q': u' ______   \n/ | _| \\  \n| | \\  |  \n\\_|__|__\\ \n          \n',
    'p': u' ______  \n| |  | \\ \n| |__|_/ \n|_|      \n         \n',
    's': u" ______  \n/ |      \n'------. \n ____|_/ \n         \n",
    'r': u' ______  \n| |  | \\ \n| |__| | \n|_|  \\_\\ \n         \n',
    'u': u' _    _  \n| |  | | \n| |  | | \n\\_|__|_| \n         \n',
    't': u'_______ \n  | |   \n  | |   \n  |_|   \n        \n',
    'w': u' _   _   _  \n| | | | | | \n| | | | | | \n|_|_|_|_|_/ \n            \n',
    'v': u' _     _  \n| |   | | \n\\ \\   / / \n \\_\\_/_/  \n          \n',
    'y': u'__    _  \n\\ \\  | | \n \\_\\_| | \n ____|_| \n         \n',
    'x': u' _    _  \n\\ \\  / / \n >|--|<  \n/_/  \\_\\ \n         \n',
    '{': u'{\n \n \n \n \n',
    'z': u" ______ \n    / / \n .---'  \n/_/___  \n        \n",
    '}': u'}\n \n \n \n \n',
    '|': u'|\n \n \n \n \n',
    '~': u'~\n \n \n \n \n'}

merlin1_dic = {
    '!': u'    ___  \n   |"  | \n   ||  | \n   |:  | \n  _|  /  \n / |_/ ) \n(_____/  \n         \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u'  ____ _____  \n ))_ ")))_ ") \n(____((____(  \n              \n              \n              \n              \n              \n',
    '%': u'  ____  ___   \n ))_ ")/"  |  \n(____(/  //   \n     /\'  /    \n    //  /____ \n   /  //))_ ")\n  |___/(____( \n              \n',
    '$': u' \n \n \n \n \n \n \n \n',
    "'": u'  ____  \n ))_ ") \n(____(  \n        \n        \n        \n        \n        \n',
    '&': u'&\n \n \n \n \n \n \n \n',
    ')': u'  ____    \n (  " \\   \n  \\__. \\  \n     ) :) \n  __/ //  \n /"   /   \n(____/    \n          \n',
    '(': u'    ____  \n   /   ") \n  /. __/  \n // /     \n(: (___   \n \\     )  \n  \\"__/   \n          \n',
    '+': u'  _______  \n ))_    ") \n(_______(  \n ________  \n ))_    ") \n(_______(  \n           \n           \n',
    '*': u'*\n \n \n \n \n \n \n \n',
    '-': u'-\n \n \n \n \n \n \n \n',
    ',': u'         \n         \n         \n         \n  _____  \n //   ") \n(_____/  \n         \n',
    '/': u'      ___  \n     /"  | \n    /  //  \n   /\'  /   \n  //  /    \n /  //     \n|___/      \n           \n',
    '.': u'         \n         \n         \n         \n  _____  \n ))_  ") \n(_____(  \n         \n',
    '1': u'  ____    \n /  " \\   \n/__|| |   \n   |: |   \n  _\\  |   \n /" \\_|\\  \n(_______) \n          \n',
    '0': u'    ______    \n   /    " \\   \n  // ____  \\  \n /  /    ) :) \n(: (____/ //  \n \\        /   \n  \\"_____/    \n              \n',
    '3': u'  _______  \n /" __   ) \n(__/ _) ./ \n    /  //  \n __ \\_ \\\\  \n(: \\__) :\\ \n \\_______) \n           \n',
    '2': u'  _______    \n /"     "\\   \n(__/\\    :)  \n    / ___/   \n   // \\___   \n  (:  /  "\\  \n   \\_______) \n             \n',
    '5': u'   ________  \n  /"      ") \n (:   //\\_/  \n  \\___ \\     \n  __ | \\\\    \n /" \\/  :)   \n(_______/    \n             \n',
    '4': u' ___  ___    \n(: "||_  |   \n|  (__) :|   \n \\____  ||   \n     _\\ \'|   \n    /" \\_|\\  \n   (_______) \n             \n',
    '7': u' _________  \n("       "\\ \n \\___/   :/ \n    /   //  \n  __\\  ./   \n (:  \\_/ \\  \n  \\_______) \n            \n',
    '6': u'    ___     \n   /. ")    \n  /:  /     \n //  /___   \n(   / _  \\  \n|:   /_) :) \n \\_______/  \n            \n',
    '9': u'  _______    \n /" _   "\\   \n(: (_/  :|   \n \\____/ |)   \n    _\\  \'|   \n   /" \\__|\\  \n  (________) \n             \n',
    '8': u'  _______   \n /"  _  \\\\  \n|:  _ /  :| \n \\___/___/  \n //  /_ \\\\  \n|:  /_   :| \n \\_______/  \n            \n',
    ';': u'   ____  \n  ))_ ") \n (____(  \n  ____   \n //  ")  \n(____/   \n         \n         \n',
    ':': u'  ____  \n ))_ ") \n(____(  \n _____  \n ))_ ") \n(____(  \n        \n        \n',
    '=': u'=\n \n \n \n \n \n \n \n',
    '<': u'            \n   _______  \n _/"     ") \n//   /___/  \n\\\\   \\   \\  \n  \\_______) \n            \n            \n',
    '?': u' ________   \n("      "\\  \n \\___/   :) \n   /  ___/  \n  //  \\     \n (\'___/     \n  (___)     \n            \n',
    '>': u'            \n _______    \n("     "\\_  \n \\___\\   \\\\ \n /   /   // \n(_______/   \n            \n            \n',
    '@': u'@\n \n \n \n \n \n \n \n',
    '[': u'  ________  \n /"      ") \n(:   \\___/  \n//   /      \n\\\\   \\___   \n(:   /  "\\  \n \\________) \n            \n',
    ']': u' ________   \n("      "\\  \n \\___/   :) \n     \\   \\\\ \n  ___/   // \n /"  \\   :) \n(________/  \n            \n',
    '\\': u' ___       \n|  "\\      \n \\\\  \\     \n  \\  \'\\    \n   \\  \\\\   \n    \\\\  \\  \n     \\___| \n           \n',
    '_': u'_\n \n \n \n \n \n \n \n',
    '^': u'   __    \n  /""\\   \n //   \\  \n/\'_/\\_\\\\ \n         \n         \n         \n         \n',
    'a': u'      __      \n     /""\\     \n    /    \\    \n   /\' /\\  \\   \n  //  __\'  \\  \n /   /  \\\\  \\ \n(___/    \\___)\n              \n',
    '`': u' _____   \n("   \\\\  \n \\_____) \n         \n         \n         \n         \n         \n',
    'c': u'  ______   \n /" _  "\\  \n(: ( \\___) \n \\/ \\      \n //  \\ _   \n(:   _) \\  \n \\_______) \n           \n',
    'b': u' _______   \n|   _  "\\  \n(. |_)  :) \n|:     \\/  \n(|  _  \\\\  \n|: |_)  :) \n(_______/  \n           \n',
    'e': u'  _______  \n /"     "| \n(: ______) \n \\/    |   \n // ___)_  \n(:      "| \n \\_______) \n           \n',
    'd': u' ________   \n|"      "\\  \n(.  ___  :) \n|: \\   ) || \n(| (___\\ || \n|:       :) \n(________/  \n            \n',
    'g': u'  _______   \n /" _   "|  \n(: ( \\___)  \n \\/ \\       \n //  \\ ___  \n(:   _(  _| \n \\_______)  \n            \n',
    'f': u'  _______  \n /"     "| \n(: ______) \n \\/    |   \n // ___)   \n(:  (      \n \\__/      \n           \n',
    'i': u'  __     \n |" \\    \n ||  |   \n |:  |   \n |.  |   \n /\\  |\\  \n(__\\_|_) \n         \n',
    'h': u'  __    __   \n /" |  | "\\  \n(:  (__)  :) \n \\/      \\/  \n //  __  \\\\  \n(:  (  )  :) \n \\__|  |__/  \n             \n',
    'k': u' __   ___  \n|/"| /  ") \n(: |/   /  \n|    __/   \n(// _  \\   \n|: | \\  \\  \n(__|  \\__) \n           \n',
    'j': u'      ___  \n     |"  | \n     ||  | \n     |:  | \n  ___|  /  \n /  :|_/ ) \n(_______/  \n           \n',
    'm': u' ___      ___ \n|"  \\    /"  |\n \\   \\  //   |\n /\\\\  \\/.    |\n|: \\.        |\n|.  \\    /:  |\n|___|\\__/|___|\n              \n',
    'l': u' ___       \n|"  |      \n||  |      \n|:  |      \n \\  |___   \n( \\_|:  \\  \n \\_______) \n           \n',
    'o': u'    ______    \n   /    " \\   \n  // ____  \\  \n /  /    ) :) \n(: (____/ //  \n \\        /   \n  \\"_____/    \n              \n',
    'n': u' _____  ___   \n(\\"   \\|"  \\  \n|.\\\\   \\    | \n|: \\.   \\\\  | \n|.  \\    \\. | \n|    \\    \\ | \n \\___|\\____\\) \n              \n',
    'q': u'    ______    \n   /    " \\   \n  // ____  \\  \n /  /    )  ) \n(: (____/ //  \n \\         \\  \n  \\"____/\\__\\ \n              \n',
    'p': u'   _______   \n  |   __ "\\  \n  (. |__) :) \n  |:  ____/  \n  (|  /      \n /|__/ \\     \n(_______)    \n             \n',
    's': u'  ________  \n /"       ) \n(:   \\___/  \n \\___  \\    \n  __/  \\\\   \n /" \\   :)  \n(_______/   \n            \n',
    'r': u'  _______   \n /"      \\  \n|:        | \n|_____/   ) \n //      /  \n|:  __   \\  \n|__|  \\___) \n            \n',
    'u': u' ____  ____  \n("  _||_ " | \n|   (  ) : | \n(:  |  | . ) \n \\\\ \\__/ //  \n /\\\\ __ //\\  \n(__________) \n             \n',
    't': u' ___________  \n("     _   ") \n )__/  \\\\__/  \n    \\\\_ /     \n    |.  |     \n    \\:  |     \n     \\__|     \n              \n',
    'w': u' __   __  ___ \n|"  |/  \\|  "|\n|\'  /    \\:  |\n|: /\'        |\n \\//  /\\\'    |\n /   /  \\\\   |\n|___/    \\___|\n              \n',
    'v': u' ___      ___ \n|"  \\    /"  |\n \\   \\  //  / \n  \\\\  \\/. ./  \n   \\.    //   \n    \\\\   /    \n     \\__/     \n              \n',
    'y': u' ___  ___  \n|"  \\/"  | \n \\   \\  /  \n  \\\\  \\/   \n  /   /    \n /   /     \n|___/      \n           \n',
    'x': u' ___  ___  \n|"  \\/"  | \n \\   \\  /  \n  \\\\  \\/   \n  /\\.  \\   \n /  \\   \\  \n|___/\\___| \n           \n',
    '{': u'  ________  \n /"      ") \n(:   \\___/  \n \\\\  /      \n //  \\___   \n(:   /  "\\  \n \\________) \n            \n',
    'z': u' ________   \n("      "\\  \n \\___/   :) \n   /  ___/  \n  //  \\__   \n (:   / "\\  \n  \\_______) \n            \n',
    '}': u' ________   \n("      "\\  \n \\___/   :) \n     \\  //  \n  ___/  \\\\  \n /"  \\   :) \n(________/  \n            \n',
    '|': u' __   \n|" \\  \n||  | \n|:  | \n|.  | \n|   | \n\\___) \n      \n',
    '~': u'~\n \n \n \n \n \n \n \n'}

merlin2_dic = {
    '!': u'   _    \n _/\\\\_  \n(_  _)) \n /  \\\\  \n/ \\ :\\\\ \n\\__/\\// \n   \\//  \n        \n        \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u'"\n \n \n \n \n \n \n \n \n',
    '%': u'%\n \n \n \n \n \n \n \n \n',
    '$': u'   _     \n  /\\\\_   \n /  _ \\\\ \n \\:.\\\\// \n/\\\\  \\\\  \n\\_  _//  \n  \\//    \n         \n         \n',
    "'": u' ____   \n(:. _)) \n  \\//   \n        \n        \n        \n        \n        \n        \n',
    '&': u'&\n \n \n \n \n \n \n \n \n',
    ')': u"    _   \n __/\\\\  \n/_   \\\\ \n  /':// \n _\\.:\\\\ \n\\__  // \n   \\//  \n        \n        \n",
    '(': u'  _     \n //\\__  \n//   _\\ \n\\\\:`\\   \n//:./_  \n\\\\  __/ \n \\\\/    \n        \n        \n',
    '+': u'+\n \n \n \n \n \n \n \n \n',
    '*': u'*\n \n \n \n \n \n \n \n \n',
    '-': u'-\n \n \n \n \n \n \n \n \n',
    ',': u'       \n       \n       \n       \n  ___  \n((:. ) \n  \\\\/  \n       \n       \n',
    '/': u'      _  \n     //\\ \n    // / \n   // /  \n _//./   \n((_ _)   \n  \\\\/    \n         \n         \n',
    '.': u'        \n        \n        \n        \n   _    \n _/\\\\_  \n(:.__)) \n        \n        \n',
    '1': u'   _    \n _/\\\\_  \n(____)) \n /  \\\\  \n/:.  \\\\ \n\\__  // \n   \\//  \n        \n        \n',
    '0': u'    _      \n __/\\\\__   \n(_    __)) \n /  _  \\\\  \n/:.(_)) \\\\ \n\\  _____// \n \\//       \n           \n           \n',
    '3': u"    _   \n __/\\\\  \n/    \\\\ \n\\_/':// \n/ \\.:\\\\ \n\\__  // \n   \\//  \n        \n        \n",
    '2': u'    _      \n __//\\     \n//    \\    \n\\\\_/  /    \n  /.:/_/\\\\ \n  \\  ___// \n   \\//     \n           \n           \n',
    '5': u"   _      \n  /\\\\__   \n /   _ \\\\ \n \\':\\\\\\// \n/ \\  \\\\   \n\\__  //   \n   \\//    \n          \n          \n",
    '4': u'   _     \n  /\\\\ _  \n / ///\\\\ \n \\ \\/ // \n _\\:.//  \n(_   _)  \n  \\//    \n         \n         \n',
    '7': u'     _   \n ___/\\\\  \n/     \\\\ \n\\_/ .:// \n  \\  //  \n (_  _)) \n   \\//   \n         \n         \n',
    '6': u'   _     \n _/\\\\_   \n(____))  \n /  \\_   \n/:. / \\\\ \n\\  ___// \n \\//     \n         \n         \n',
    '9': u'     _   \n ___/\\\\  \n/     \\\\ \n\\__/ :// \n  \\  //  \n (_  _)) \n   \\//   \n         \n         \n',
    '8': u'  _     \n /\\\\__  \n/:.  \\\\ \n\\  \\_// \n/_\\  \\\\ \n\\__.:// \n   \\//  \n        \n        \n',
    ';': u' ____   \n(:. _)) \n  \\//   \n        \n  ___   \n((:. )  \n  \\\\/   \n        \n        \n',
    ':': u' ____   \n(:. _)) \n  \\//   \n        \n   _    \n _/\\\\_  \n(:.__)) \n        \n        \n',
    '=': u'=\n \n \n \n \n \n \n \n \n',
    '<': u'        \n  _     \n //\\__  \n//.  _\\ \n\\\\: __/ \n \\\\/    \n        \n        \n        \n',
    '?': u'     _   \n ___/\\\\  \n/     \\\\ \n\\_/\\.:// \n  _/ //  \n (_  _)) \n   \\//   \n         \n         \n',
    '>': u"        \n    _   \n __/\\\\  \n/_  :\\\\ \n\\__ '// \n   \\//  \n        \n        \n        \n",
    '@': u'@\n \n \n \n \n \n \n \n \n',
    '[': u'  _     \n //\\__  \n//   _\\ \n||:`|   \n||:.|_  \n\\\\  __/ \n \\\\/    \n        \n        \n',
    ']': u"    _   \n __/\\\\  \n/_   \\\\ \n  |':|| \n _|.:|| \n\\__  // \n   \\//  \n        \n        \n",
    '\\': u' _       \n/\\\\      \n\\ \\\\     \n \\ \\\\    \n  \\:\\\\_  \n  (_ _)) \n    \\//  \n         \n         \n',
    '_': u'_\n \n \n \n \n \n \n \n \n',
    '^': u'^\n \n \n \n \n \n \n \n \n',
    'a': u'    _     \n __/\\\\__  \n(_  ____) \n /  _ \\\\  \n/:./_\\ \\\\ \n\\  _   // \n \\// \\//  \n          \n          \n',
    '`': u'  ___  \n((:. ) \n  \\\\/  \n       \n       \n       \n       \n       \n       \n',
    'c': u'    _      \n __/\\\\___  \n(_  ____)) \n /  ||     \n/:. ||___  \n\\  _____)) \n \\//       \n           \n           \n',
    'b': u'    _       \n __/\\\\___   \n(_     __)) \n / ._))//   \n/: ._))\\\\   \n\\  ____//   \n \\//        \n            \n            \n',
    'e': u'    _      \n __/\\\\___  \n(_  ____)) \n /  ._))   \n/:. ||___  \n\\  _____)) \n \\//       \n           \n           \n',
    'd': u'    _      \n __/\\\\___  \n(_  ____)) \n /   _ \\\\  \n/:. |_\\ \\\\ \n\\  _____// \n \\//       \n           \n           \n',
    'g': u'    _     \n __/\\\\__  \n(_  ___)) \n / || _   \n/:. \\/ \\\\ \n\\  ____// \n \\//      \n          \n          \n',
    'f': u'    _      \n __/\\\\___  \n(_  ____)) \n / ||__    \n/:. ._))   \n\\  _))     \n \\//       \n           \n           \n',
    'i': u'   _    \n _/\\\\_  \n(____)) \n /  \\\\  \n/:.  \\\\ \n\\__  // \n   \\//  \n        \n        \n',
    'h': u'   _        \n _/\\\\___    \n(_ __ __))  \n /  |_| \\\\  \n/:.  _   \\\\ \n\\___| |  // \n       \\//  \n            \n            \n',
    'k': u'           \n _/\\\\___   \n(_    __)) \n /  : \\\\   \n/:. | //   \n\\___| \\\\   \n     \\//   \n           \n           \n',
    'j': u'    _     \n __/\\\\__  \n(_    _)) \n  \\  \\\\   \n/\\/ .:\\\\  \n\\__  _//  \n   \\//    \n          \n          \n',
    'm': u'   _            \n _/\\\\___ _____  \n(_      v    )) \n /  :   <\\   \\\\ \n/:. |   //   // \n\\___|  //\\  //  \n     \\//  \\//   \n                \n                \n',
    'l': u'   _        \n _/\\\\_      \n(_  _))     \n /  \\\\      \n/:.  \\\\__   \n\\__  ____)) \n   \\//      \n            \n            \n',
    'o': u'    _      \n __/\\\\___  \n(_     _)) \n /  _  \\\\  \n/:.(_)) \\\\ \n\\  _____// \n \\//       \n           \n           \n',
    'n': u'   _       \n _/\\\\___   \n(_      )) \n /  :   \\\\ \n/:. |   // \n\\___|  //  \n     \\//   \n           \n           \n',
    'q': u'    _        \n __/\\\\___    \n(_     __))  \n /  _  \\\\    \n/:.(_)) \\\\_  \n\\  _______// \n \\//         \n             \n             \n',
    'p': u'   _       \n _/\\\\___   \n(_   _ _)) \n /  |))\\\\  \n/:. ___//  \n\\_ \\\\      \n  \\//      \n           \n           \n',
    's': u'    _     \n   /\\\\__  \n  /    \\\\ \n _\\  \\_// \n// \\:.\\   \n\\\\__  /   \n   \\\\/    \n          \n          \n',
    'r': u'   _       \n _/\\\\___   \n(_   _  )) \n /  |))//  \n/:.    \\\\  \n\\___|  //  \n     \\//   \n           \n           \n',
    'u': u'      _    \n ___ /\\\\   \n/  //\\ \\\\  \n\\:.\\\\_\\ \\\\ \n \\  :.  // \n(_   ___)) \n  \\//      \n           \n           \n',
    't': u'    _     \n __/\\\\__  \n(__  __)) \n  /  \\\\   \n /:.  \\\\  \n \\__  //  \n    \\//   \n          \n          \n',
    'w': u"      _    _    \n ___ /\\\\  /\\\\   \n/   |  \\\\/  \\\\  \n\\:' |   \\\\   \\\\ \n \\  :   </   // \n(_   ___^____)) \n  \\//           \n                \n                \n",
    'v': u"    _   \n _ /\\\\  \n/ \\\\ \\\\ \n\\:'/ // \n \\  //  \n(_  _)) \n  \\//   \n        \n        \n",
    'y': u'       _  \n  _   /\\\\ \n /\\\\ / // \n \\ \\/ //  \n _\\:.//   \n(_  _))   \n  \\//     \n          \n          \n',
    'x': u'    _  _    \n  _/\\\\/\\\\_  \n (_  / __)) \n   \\/ \\\\    \n __/./.\\\\_  \n(_  _)  _)) \n  \\// \\//   \n            \n            \n',
    '{': u'  _     \n //\\__  \n//   _\\ \n\\\\:`\\   \n//:./_  \n\\\\  __/ \n \\\\/    \n        \n        \n',
    'z': u'    _     \n __//\\    \n//    \\   \n\\\\_/  /_  \n  /.:/ \\\\ \n  \\  __// \n   \\//    \n          \n          \n',
    '}': u"    _   \n __/\\\\  \n/_   \\\\ \n  /':// \n _\\.:\\\\ \n\\__  // \n   \\//  \n        \n        \n",
    '|': u'   _    \n _/\\\\_  \n(_  _)) \n  / \\\\  \n /:. \\\\ \n \\  _// \n  \\//   \n        \n        \n',
    '~': u'~\n \n \n \n \n \n \n \n \n'}

modular_dic = {
    '!': u' __  \n|  | \n|  | \n|  | \n|__| \n __  \n|__| \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u' _  _  \n| || | \n|_||_| \n       \n       \n       \n       \n',
    '%': u'%\n \n \n \n \n \n \n',
    '$': u' \n \n \n \n \n \n \n',
    "'": u' __  \n|  | \n|__| \n     \n     \n     \n     \n',
    '&': u'&\n \n \n \n \n \n \n',
    ')': u' ____   \n|    |  \n|_    | \n  |   | \n  |   | \n _|   | \n|____|  \n',
    '(': u'  ____  \n |    | \n|    _| \n|   |   \n|   |   \n|   |_  \n |____| \n',
    '+': u'   _    \n _| |_  \n|_   _| \n  |_|   \n        \n        \n        \n',
    '*': u'*\n \n \n \n \n \n \n',
    '-': u'       \n       \n ____  \n|____| \n       \n       \n       \n',
    ',': u'      \n      \n      \n      \n ___  \n|_  | \n  |_| \n',
    '/': u'/\n \n \n \n \n \n \n',
    '.': u'      \n      \n      \n      \n ___  \n|   | \n|___| \n',
    '1': u' ____  \n|    | \n |   | \n |   | \n |   | \n |   | \n |___| \n',
    '0': u' _______ \n|  _    |\n| | |   |\n| | |   |\n| |_|   |\n|       |\n|_______|\n',
    '3': u' _______ \n|       |\n|___    |\n ___|   |\n|___    |\n ___|   |\n|_______|\n',
    '2': u' _______ \n|       |\n|____   |\n ____|  |\n| ______|\n| |_____ \n|_______|\n',
    '5': u' _______ \n|       |\n|   ____|\n|  |____ \n|_____  |\n _____| |\n|_______|\n',
    '4': u' _   ___ \n| | |   |\n| |_|   |\n|       |\n|___    |\n    |   |\n    |___|\n',
    '7': u' _______ \n|       |\n|___    |\n    |   |\n    |   |\n    |   |\n    |___|\n',
    '6': u' ___     \n|   |    \n|   |___ \n|    _  |\n|   | | |\n|   |_| |\n|_______|\n',
    '9': u' _______ \n|  _    |\n| | |   |\n| |_|   |\n|___    |\n    |   |\n    |___|\n',
    '8': u'  _____  \n |  _  | \n | |_| | \n|   _   |\n|  | |  |\n|  |_|  |\n|_______|\n',
    ';': u' ___  \n|   | \n|___| \n ___  \n|_  | \n  |_| \n      \n',
    ':': u' ___  \n|   | \n|___| \n ___  \n|   | \n|___| \n      \n',
    '=': u' ____  \n|____| \n ____  \n|____| \n       \n       \n       \n',
    '<': u'<\n \n \n \n \n \n \n',
    '?': u' ______  \n|      | \n|___   | \n  __|  | \n |_____| \n   __    \n  |__|   \n',
    '>': u'>\n \n \n \n \n \n \n',
    '@': u'@\n \n \n \n \n \n \n',
    '[': u' _____  \n|     | \n|    _| \n|   |   \n|   |   \n|   |_  \n|_____| \n',
    ']': u' _____  \n|     | \n|_    | \n  |   | \n  |   | \n _|   | \n|_____| \n',
    '\\': u'\\\n \n \n \n \n \n \n',
    '_': u'        \n        \n        \n        \n        \n _____  \n|_____| \n',
    '^': u'  ___   \n |   |  \n|  _  | \n|_| |_| \n        \n        \n        \n',
    'a': u' _______ \n|   _   |\n|  |_|  |\n|       |\n|       |\n|   _   |\n|__| |__|\n',
    '`': u' ___   \n|   |  \n|_   | \n  |__| \n       \n       \n       \n',
    'c': u' _______ \n|       |\n|       |\n|       |\n|      _|\n|     |_ \n|_______|\n',
    'b': u' _______ \n|  _    |\n| |_|   |\n|       |\n|  _   | \n| |_|   |\n|_______|\n',
    'e': u' _______ \n|       |\n|    ___|\n|   |___ \n|    ___|\n|   |___ \n|_______|\n',
    'd': u' ______  \n|      | \n|  _    |\n| | |   |\n| |_|   |\n|       |\n|______| \n',
    'g': u' _______ \n|       |\n|    ___|\n|   | __ \n|   ||  |\n|   |_| |\n|_______|\n',
    'f': u' _______ \n|       |\n|    ___|\n|   |___ \n|    ___|\n|   |    \n|___|    \n',
    'i': u' ___  \n|   | \n|   | \n|   | \n|   | \n|   | \n|___| \n',
    'h': u' __   __ \n|  | |  |\n|  |_|  |\n|       |\n|       |\n|   _   |\n|__| |__|\n',
    'k': u' ___   _ \n|   | | |\n|   |_| |\n|      _|\n|     |_ \n|    _  |\n|___| |_|\n',
    'j': u'     ___ \n    |   |\n    |   |\n    |   |\n    |   |\n   |    |\n   |____|\n',
    'm': u' __   __ \n|  |_|  |\n|       |\n|       |\n|       |\n| ||_|| |\n|_|   |_|\n',
    'l': u' ___     \n|   |    \n|   |    \n|   |    \n|   |___ \n|       |\n|_______|\n',
    'o': u' _______ \n|       |\n|   _   |\n|  | |  |\n|  |_|  |\n|       |\n|_______|\n',
    'n': u' __    _ \n|  |  | |\n|   |_| |\n|       |\n|  _    |\n| | |   |\n|_|  |__|\n',
    'q': u' _______ \n|       |\n|   _   |\n|  | |  |\n|  |_|  |\n|      | \n|____||_|\n',
    'p': u' _______ \n|       |\n|    _  |\n|   |_| |\n|    ___|\n|   |    \n|___|    \n',
    's': u' _______ \n|       |\n|  _____|\n| |_____ \n|_____  |\n _____| |\n|_______|\n',
    'r': u' ______  \n|    _ | \n|   | || \n|   |_|| \n|    __ |\n|   |  ||\n|___|  ||\n',
    'u': u' __   __ \n|  | |  |\n|  | |  |\n|  |_|  |\n|       |\n|       |\n|_______|\n',
    't': u' _______ \n|       |\n|_     _|\n  |   |  \n  |   |  \n  |   |  \n  |___|  \n',
    'w': u' _     _ \n| | _ | |\n| || || |\n|       |\n|       |\n|   _   |\n|__| |__|\n',
    'v': u' __   __ \n|  | |  |\n|  |_|  |\n|       |\n|       |\n |     | \n  |___|  \n',
    'y': u' __   __ \n|  | |  |\n|  |_|  |\n|       |\n|_     _|\n  |   |  \n  |___|  \n',
    'x': u' __   __ \n|  |_|  |\n|       |\n|       |\n |     | \n|   _   |\n|__| |__|\n',
    '{': u'{\n \n \n \n \n \n \n',
    'z': u' _______ \n|       |\n|____   |\n ____|  |\n| ______|\n| |_____ \n|_______|\n',
    '}': u'}\n \n \n \n \n \n \n',
    '|': u'|\n \n \n \n \n \n \n',
    '~': u'~\n \n \n \n \n \n \n'}

morse_dic = {
    '!': u'.-.-.- \n',
    ' ': u'   \n',
    '#': u'........ \n',
    '"': u'.-..-. \n',
    '%': u'? \n',
    '$': u'? \n',
    "'": u'.----. \n',
    '&': u'? \n',
    ')': u'-.--.- \n',
    '(': u'-.--.- \n',
    '+': u'? \n',
    '*': u'---- \n',
    '-': u'-....- \n',
    ',': u'--..-- \n',
    '/': u'-..-. \n',
    '.': u'.-.-.- \n',
    '1': u'.---- \n',
    '0': u'----- \n',
    '3': u'...-- \n',
    '2': u'..--- \n',
    '5': u'..... \n',
    '4': u'....- \n',
    '7': u'--... \n',
    '6': u'-.... \n',
    '9': u'----. \n',
    '8': u'---.. \n',
    ';': u'---... \n',
    ':': u'---... \n',
    '=': u'? \n',
    '<': u'? \n',
    '?': u'..--.. \n',
    '>': u'? \n',
    '@': u'? \n',
    '[': u'-.--.- \n',
    ']': u'-.--.- \n',
    '\\': u'? \n',
    '_': u'? \n',
    '^': u'? \n',
    'a': u'.- \n',
    '`': u'? \n',
    'c': u'-.-. \n',
    'b': u'-... \n',
    'e': u'. \n',
    'd': u'-.. \n',
    'g': u'--. \n',
    'f': u'..-. \n',
    'i': u'.. \n',
    'h': u'.... \n',
    'k': u'-.- \n',
    'j': u'.--- \n',
    'm': u'-- \n',
    'l': u'.-.. \n',
    'o': u'--- \n',
    'n': u'-. \n',
    'q': u'--.- \n',
    'p': u'.--. \n',
    's': u'... \n',
    'r': u'.-. \n',
    'u': u'..- \n',
    't': u'- \n',
    'w': u'.-- \n',
    'v': u'...- \n',
    'y': u'-.-- \n',
    'x': u'-..- \n',
    '{': u'-.--.- \n',
    'z': u'--.. \n',
    '}': u'-.--.- \n',
    '|': u'? \n',
    '~': u'? \n'}

moscow_dic = {
    '!': u'    \n #  \n #  \n #  \n    \n #  \n',
    ' ': u'    \n    \n    \n    \n    \n    \n',
    '#': u'    \n# # \n### \n# # \n### \n# # \n',
    '"': u'    \n# # \n# # \n    \n    \n    \n',
    '%': u'    \n# # \n  # \n #  \n#   \n# # \n',
    '$': u'    \n ## \n##  \n### \n ## \n##  \n',
    "'": u'    \n  # \n #  \n#   \n    \n    \n',
    '&': u'    \n #  \n#   \n ## \n# # \n### \n',
    ')': u'    \n#   \n #  \n #  \n #  \n#   \n',
    '(': u'    \n  # \n #  \n #  \n #  \n  # \n',
    '+': u'    \n    \n #  \n### \n #  \n    \n',
    '*': u'    \n #  \n### \n #  \n### \n #  \n',
    '-': u'    \n    \n    \n### \n    \n    \n',
    ',': u'    \n    \n    \n    \n #  \n#   \n',
    '/': u'    \n#   \n#   \n##  \n# # \n##  \n',
    '.': u'    \n    \n    \n    \n    \n #  \n',
    '1': u'    \n #  \n##  \n #  \n #  \n### \n',
    '0': u'    \n### \n# # \n# # \n# # \n### \n',
    '3': u'    \n### \n  # \n ## \n  # \n### \n',
    '2': u'    \n### \n  # \n### \n#   \n### \n',
    '5': u'    \n### \n#   \n### \n  # \n### \n',
    '4': u'    \n# # \n# # \n### \n  # \n  # \n',
    '7': u'    \n### \n  # \n  # \n  # \n  # \n',
    '6': u'    \n### \n#   \n### \n# # \n### \n',
    '9': u'    \n### \n# # \n### \n  # \n### \n',
    '8': u'    \n### \n# # \n### \n# # \n### \n',
    ';': u'    \n    \n #  \n    \n #  \n#   \n',
    ':': u'    \n    \n #  \n    \n #  \n    \n',
    '=': u'    \n    \n### \n    \n### \n    \n',
    '<': u'    \n  # \n #  \n#   \n #  \n  # \n',
    '?': u'    \n### \n  # \n ## \n    \n #  \n',
    '>': u'      \n# # # \n#  ## \n# # # \n##  # \n#   # \n',
    '@': u'    \n### \n# # \n#   \n### \n    \n',
    '[': u'    \n ## \n #  \n #  \n #  \n ## \n',
    ']': u'    \n##  \n #  \n #  \n #  \n##  \n',
    '\\': u'    \n##  \n#   \n##  \n# # \n##  \n',
    '_': u'    \n    \n    \n    \n    \n### \n',
    '^': u'    \n #  \n# # \n    \n    \n    \n',
    'a': u'      \n  #   \n # #  \n##### \n#   # \n#   # \n',
    '`': u'       \n#  ##  \n# #  # \n###  # \n# #  # \n#  ##  \n',
    'c': u'      \n#   # \n#   # \n #### \n    # \n    # \n',
    'b': u'      \n####  \n #    \n #### \n #  # \n##### \n',
    'e': u'      \n##### \n#     \n####  \n#     \n##### \n',
    'd': u'       \n#####  \n #  #  \n #  #  \n ####  \n#    # \n',
    'g': u'      \n##### \n#   # \n#     \n#     \n#     \n',
    'f': u'      \n  #   \n ###  \n# # # \n ###  \n  #   \n',
    'i': u'      \n#   # \n#  ## \n# # # \n##  # \n#   # \n',
    'h': u'      \n#   # \n # #  \n  #   \n # #  \n#   # \n',
    'k': u'      \n#   # \n#  #  \n###   \n#  #  \n#   # \n',
    'j': u'      \n# # # \n ###  \n  #   \n ###  \n# # # \n',
    'm': u'      \n#   # \n## ## \n# # # \n#   # \n#   # \n',
    'l': u'      \n##### \n #  # \n #  # \n #  # \n#   # \n',
    'o': u'      \n ###  \n#   # \n#   # \n#   # \n ###  \n',
    'n': u'      \n#   # \n#   # \n##### \n#   # \n#   # \n',
    'q': u'      \n#   # \n#   # \n#   # \n##### \n    # \n',
    'p': u'      \n##### \n#   # \n#   # \n#   # \n#   # \n',
    's': u'      \n #### \n#     \n#     \n#     \n #### \n',
    'r': u'      \n####  \n#   # \n####  \n#     \n#     \n',
    'u': u'      \n#   # \n # #  \n  #   \n #    \n#     \n',
    't': u'      \n##### \n  #   \n  #   \n  #   \n  #   \n',
    'w': u'      \n#   # \n# # # \n# # # \n# # # \n ###  \n',
    'v': u'      \n####  \n#   # \n####  \n#   # \n####  \n',
    'y': u'      \n #### \n#   # \n #### \n #  # \n#   # \n',
    'x': u'       \n#   #  \n# # #  \n# # #  \n# # #  \n ##### \n',
    '{': u'    \n ## \n #  \n##  \n #  \n ## \n',
    'z': u'      \n####  \n    # \n ###  \n    # \n####  \n',
    '}': u'    \n##  \n #  \n ## \n #  \n##  \n',
    '|': u'      \n#   # \n#   # \n##  # \n# # # \n##  # \n',
    '~': u'      \n####  \n    # \n##### \n    # \n####  \n'}

muzzle_dic = {
    '!': u'  \n| \n| \n> \n',
    ' ': u'  \n  \n  \n  \n',
    '#': u'',
    '"': u'   \n>> \n   \n   \n',
    '%': u'%\n \n \n \n',
    '$': u' \n \n \n \n',
    "'": u"'\n \n \n \n",
    '&': u'&\n \n \n \n',
    ')': u')\n \n \n \n',
    '(': u'(\n \n \n \n',
    '+': u'    \n |  \n-<- \n |  \n',
    '*': u'*\n \n \n \n',
    '-': u'    \n    \n-<- \n    \n',
    ',': u',\n \n \n \n',
    '/': u'/\n \n \n \n',
    '.': u'.\n \n \n \n',
    '1': u'1\n \n \n \n',
    '0': u'0\n \n \n \n',
    '3': u'3\n \n \n \n',
    '2': u'2\n \n \n \n',
    '5': u'5\n \n \n \n',
    '4': u'4\n \n \n \n',
    '7': u'7\n \n \n \n',
    '6': u'6\n \n \n \n',
    '9': u'9\n \n \n \n',
    '8': u'8\n \n \n \n',
    ';': u'  \n< \n/ \n  \n',
    ':': u'  \n< \n< \n  \n',
    '=': u'    \n>-- \n>-- \n    \n',
    '<': u'<\n \n \n \n',
    '?': u'?\n \n \n \n',
    '>': u'>\n \n \n \n',
    '@': u'@\n \n \n \n',
    '[': u'[\n \n \n \n',
    ']': u']\n \n \n \n',
    '\\': u'\\\n \n \n \n',
    '_': u'_\n \n \n \n',
    '^': u'^\n \n \n \n',
    'a': u' __  \n|  | \n|><| \n|  | \n',
    '`': u'`\n \n \n \n',
    'c': u' __ \n|<< \n|   \n|__ \n',
    'b': u" __  \n|  | \n|<>' \n|__' \n",
    'e': u' __ \n|   \n|<< \n|__ \n',
    'd': u'     \n __| \n|<<| \n|__| \n',
    'g': u" __  \n|    \n| >> \n'__| \n",
    'f': u' __ \n|   \n|<< \n|   \n',
    'i': u'  \n> \n| \n| \n',
    'h': u'     \n|  | \n|><| \n|  | \n',
    'k': u'     \n|  / \n|<<  \n|  \\ \n',
    'j': u" __  \n   | \n<< | \n|__' \n",
    'm': u'      \n|\\ /| \n| < | \n|   | \n',
    'l': u'    \n|   \n|   \n|<< \n',
    'o': u'     \n >>  \n|  | \n <<  \n',
    'n': u'    \n| | \n|\\| \n| | \n',
    'q': u'     \n >>  \n|  | \n <<\\ \n',
    'p': u"     \n|<<' \n|>>| \n|    \n",
    's': u'    \n|<< \n--  \n>>| \n',
    'r': u'     \n|<<  \n|>>| \n|  \\ \n',
    'u': u"     \n|  | \n|  | \n'<<' \n",
    't': u'      \n>>|<< \n  |   \n  |   \n',
    'w': u'      \n|   | \n| < | \n|/ \\| \n',
    'v': u'     \n|  | \n|  | \n \\/  \n',
    'y': u'    \n| | \n\\</ \n |  \n',
    'x': u'    \n\\ / \n <  \n/ \\ \n',
    '{': u'{\n \n \n \n',
    'z': u'    \n>>> \n /  \n/<< \n',
    '}': u'}\n \n \n \n',
    '|': u'|\n \n \n \n',
    '~': u'~\n \n \n \n'}

nscript_dic = {
    ' ': u'    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n',
    '$': u'    8 8      \n ad88888ba   \nd8" 8 8 "8b  \nY8, 8 8      \n`Y8a8a8a,    \n  `"8"8"8b,  \n    8 8 `8b  \nY8a 8 8 a8P  \n "Y88888P"   \n    8 8      \n             \n             \n             \n             \n             \n             \n',
    '(': u'       \n,dPYb, \nIP\'`Yb \nI8  8I \nI8  8\' \nI8,dP  \nI8P"   \nI8,    \nI8b,_  \nI8"8888\nI8 `8, \nI8  `8,\nI8   8I\nI8   8I\nI8, ,8\'\n "Y8P\' \n',
    ',': u'      \n      \n      \n      \n      \n      \n      \n      \n  aaa \n  "88 \n  d8\' \n 8"   \n      \n      \n      \n      \n',
    '0': u'   ,a888a,    \n ,8P"\' `"Y8,  \n,8P       Y8, \n88         88 \n88         88 \n88         88 \n88         88 \n`8b       d8\' \n `8ba, ,ad8\'  \n   "Y888P"    \n              \n              \n              \n              \n              \n              \n',
    '4': u'        a8   \n      ,d88   \n     a8P88   \n   ,d8" 88   \n  a8P\'  88   \n,d8"    88   \n888888888888 \n        88   \n        88   \n        88   \n             \n             \n             \n             \n             \n             \n',
    '8': u' ad88888ba  \nd8"     "8b \n88       88 \nY8a     a8P \n "Y8aaa8P"  \n ,d8"""8b,  \nd8"     "8b \n88       88 \nY8a     a8P \n "Y88888P"  \n            \n            \n            \n            \n            \n            \n',
    '<': u'      \n,dPYb,\nIP\'`Yb\nI8  8I\nI8  8\'\nI8,dP \nI8P"  \nI8,   \n`Yb,_ \n  "Y88\n      \n      \n      \n      \n      \n      \n',
    '@': u'            \n            \n            \n            \n            \n  ,ggggg,   \ngdP"  "Y8ggg\nI8\'    ,8I  \nY8,   ,d8\'  \n`Y8888P"    \n            \n            \n            \n            \n            \n            \n',
    'D': u' ,gggggggggggg,   \ndP"""88""""""Y8b, \nYb,  88       `8b,\n `"  88        `8b\n     88         Y8\n     88         d8\n     88        ,8P\n     88       ,8P\'\n     88______,dP\' \n    888888888P"   \n                  \n                  \n                  \n                  \n                  \n                  \n',
    'H': u' ,ggg,        gg \ndP""Y8b       88 \nYb, `88       88 \n `"  88       88 \n     88aaaaaaa88 \n     88"""""""88 \n     88       88 \n     88       88 \n     88       Y8,\n     88       `Y8\n                 \n                 \n                 \n                 \n                 \n                 \n',
    'L': u'       ,gggg,  \n      d8" "8I  \n      88  ,dP  \n   8888888P"   \n      88       \n      88       \n ,aa,_88       \ndP" "88P       \nYb,_,d88b,,_   \n "Y8P"  "Y88888\n               \n               \n               \n               \n               \n               \n',
    'P': u' ,ggggggggggg,  \ndP"""88""""""Y8,\nYb,  88      `8b\n `"  88      ,8P\n     88aaaad8P" \n     88"""""    \n     88         \n     88         \n     88         \n     88         \n                \n                \n                \n                \n                \n                \n',
    'T': u' ,ggggggggggggggg\ndP""""""88"""""""\nYb,_    88       \n `""    88       \n        88       \n        88       \n        88       \n  gg,   88       \n   "Yb,,8P       \n     "Y8P\'       \n                 \n                 \n                 \n                 \n                 \n                 \n',
    'X': u' ,ggg,          ,gg\ndP"""Y8,      ,dP\' \nYb,_  "8b,   d8"   \n `""    Y8,,8P\'    \n         Y88"      \n        ,888b      \n       d8" "8b,    \n     ,8P\'    Y8,   \n    d8"       "Yb, \n  ,8P\'          "Y8\n                   \n                   \n                   \n                   \n                   \n                   \n',
    '\\': u'           \n           \n           \n           \n           \n  ,gggg,gg \ngdP"  "Y8I \nI8\'    ,8I \nY8,   ,d8b \n`Y8888P"88d\n        I8P\n        I8\'\n        I8 \n        I8 \n        I8 \n        I8 \n',
    '`': u'           \n           \n           \n           \n           \ngg      gg \n88      8I \nI8,    ,8I \n`8b,  ,d8b,\n  "Y88P"`Y8\n           \n           \n           \n           \n           \n           \n',
    'd': u'            \n         8I \n         8I \n         8I \n         8I \n   ,gggg,8I \n  dP"  "Y8I \n i8\'    ,8I \n,d8,   ,d8b,\nP"Y8888P"`Y8\n            \n            \n            \n            \n            \n            \n',
    'h': u'           \n ,dPYb,    \n IP\'`Yb    \n I8  8I    \n I8  8\'    \n I8 dPgg,  \n I8dP" "8I \n I8P    I8 \n,d8     I8,\n88P     `Y8\n           \n           \n           \n           \n           \n           \n',
    'l': u'       \n ,dPYb,\n IP\'`Yb\n I8  8I\n I8  8\'\n I8 dP \n I8dP  \n I8P   \n,d8b,_ \n8P\'"Y88\n       \n       \n       \n       \n       \n       \n',
    'p': u'            \n            \n            \n            \n            \n gg,gggg,   \n I8P"  "Yb  \n I8\'    ,8i \n,I8 _  ,d8\' \nPI8 YY88888P\n I8         \n I8         \n I8         \n I8         \n I8         \n I8         \n',
    't': u'        \n   I8   \n   I8   \n88888888\n   I8   \n   I8   \n   I8   \n  ,I8,  \n ,d88b, \n88P""Y88\n        \n        \n        \n        \n        \n        \n',
    'x': u'              \n              \n              \n              \n              \n    ,gg,   ,gg\n   d8""8b,dP" \n  dP   ,88"   \n,dP  ,dP"Y8,  \n8"  dP"   "Y88\n              \n              \n              \n              \n              \n              \n',
    '|': u'                \n                \n                \n                \n                \ngg    gg    gg  \n88    I8    88bg\nI8    I8    8I  \nI8,  ,d8,  ,8I  \n "Y88P""Y88P"   \n                \n                \n                \n                \n                \n                \n',
    '#': u'         \n         \n         \n         \n         \n  ,gggg, \ngdP"  "Yb\nI8\'      \nY8,_    _\n "Y8888PP\n         \n         \n         \n         \n         \n         \n',
    "'": u'   d8\'\n  d8\' \n ""   \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n',
    '+': u'          \n,dPYb,    \nIP\'`Yb    \nI8  8I    \nI8  8\'    \nI8,dPgg,  \nI88P" "8I \nI8P    I8 \nI8     I8,\nI8     `Y8\n          \n          \n          \n          \n          \n          \n',
    '/': u'    \n    \n    \ngg  \n""  \ngg  \n88  \n88  \n88,_\n"Y88\n    \n    \n    \n    \n    \n    \n',
    '3': u' ad888888b, \nd8"     "88 \n        a88 \n       ,88P \n     aad8"  \n     ""Y8,  \n       `88b \n        "88 \nY8,     a88 \n "Y888888P\' \n            \n            \n            \n            \n            \n            \n',
    '7': u'888888888888 \n       ,88\'  \n     ,88"    \n    ,88\'     \n aaa888aa    \n  ,8P        \n ,88         \n 88\'         \n 88          \n 88          \n             \n             \n             \n             \n             \n             \n',
    ';': u'          \n,dPYb,    \nIP\'`Yb    \nI8  8I    \nI8  8bgg, \nI8,dP" "8 \nI888bggP" \nI8\'  "Yb, \nI8    `Yb,\nI8      Y8\n          \n          \n          \n          \n          \n          \n',
    '?': u' ad88888ba   \nd8"     "8b  \n""      a8P  \n     ,a8P"   \n    d8"      \n    88       \n    88       \n             \n    aa       \n    88       \n             \n             \n             \n             \n             \n             \n',
    'C': u'     ,gggg,  \n   ,88"""Y8b,\n  d8"     `Y8\n d8\'   8b  d8\n,8I    "Y88P\'\nI8\'          \nd8           \nY8,          \n`Yba,,_____, \n  `"Y8888888 \n             \n             \n             \n             \n             \n             \n',
    'G': u'    ,gg,      \n   i8""8i     \n   `8,,8\'     \n    `Y88aaad8 \n     d8""""Y8,\n    ,8P     8b\n    dP      Y8\n_ ,dP\'      I8\n"888,,_____,dP\na8P"Y888888P" \n              \n              \n              \n              \n              \n              \n',
    'K': u' ,ggg,        gg \ndP""Y8b       dP \nYb, `88      d8\' \n `"  88    ,dP\'  \n     88aaad8"    \n     88""""Yb,   \n     88     "8b  \n     88      `8i \n     88       Yb,\n     88        Y8\n                 \n                 \n                 \n                 \n                 \n                 \n',
    'O': u'   _,gggggg,_     \n ,d8P""d8P"Y8b,   \n,d8\'   Y8   "8b,dP\nd8\'    `Ybaaad88P\'\n8P       `""""Y8  \n8b            d8  \nY8,          ,8P  \n`Y8,        ,8P\'  \n `Y8b,,__,,d8P\'   \n   `"Y8888P"\'     \n                  \n                  \n                  \n                  \n                  \n                  \n',
    'S': u'      ,gg,   \n     i8""8i  \n     `8,,8\'  \n      `88\'   \n      dP"8,  \n     dP\' `8a \n    dP\'   `Yb\n_ ,dP\'     I8\n"888,,____,dP\na8P"Y88888P" \n             \n             \n             \n             \n             \n             \n',
    'W': u' ,ggg,      gg      ,gg\ndP""Y8a     88     ,8P \nYb, `88     88     d8\' \n `"  88     88     88  \n     88     88     88  \n     88     88     88  \n     88     88     88  \n     Y8    ,88,    8P  \n      Yb,,d8""8b,,dP   \n       "88"    "88"    \n                       \n                       \n                       \n                       \n                       \n                       \n',
    '[': u'           \n           \n           \n           \n           \ngg,gggg,   \n88P"  "Yb  \nI8\'    ,8i \nI8 _  ,d8\' \nI8 YY88888P\nI8         \nI8         \nI8         \nI8         \nI8         \nI8         \n',
    '_': u'        \n   I8   \n   I8   \n88888888\n   I8   \n ,dI8   \n8P"I8   \n   I8,  \n   `8b,_\n    "Y88\n        \n        \n        \n        \n        \n        \n',
    'c': u'          \n          \n          \n          \n          \n   ,gggg, \n  dP"  "Yb\n i8\'      \n,d8,_    _\nP""Y8888PP\n          \n          \n          \n          \n          \n          \n',
    'g': u'            \n            \n            \n            \n            \n   ,gggg,gg \n  dP"  "Y8I \n i8\'    ,8I \n,d8,   ,d8I \nP"Y8888P"888\n       ,d8I\'\n     ,dP\'8I \n    ,8"  8I \n    I8   8I \n    `8, ,8I \n     `Y8P"  \n',
    'k': u'           \n ,dPYb,    \n IP\'`Yb    \n I8  8I    \n I8  8bgg, \n I8 dP" "8 \n I8d8bggP" \n I8P\' "Yb, \n,d8    `Yb,\n88P      Y8\n           \n           \n           \n           \n           \n           \n',
    'o': u'             \n             \n             \n             \n             \n   ,ggggg,   \n  dP"  "Y8ggg\n i8\'    ,8I  \n,d8,   ,d8\'  \nP"Y8888P"    \n             \n             \n             \n             \n             \n             \n',
    's': u'          \n          \n          \n          \n          \n   ,g,    \n  ,8\'8,   \n ,8\'  Yb  \n,8\'_   8) \nP\' "YY8P8P\n          \n          \n          \n          \n          \n          \n',
    'w': u'                 \n                 \n                 \n                 \n                 \n gg    gg    gg  \n I8    I8    88bg\n I8    I8    8I  \n,d8,  ,d8,  ,8I  \nP""Y88P""Y88P"   \n                 \n                 \n                 \n                 \n                 \n                 \n',
    '{': u'           \n           \n           \n           \n           \n,gg    gg  \nP"Yb   88bg\n  I8   8I  \n  I8, ,8I  \n   "Y8P"   \n           \n           \n           \n           \n           \n           \n',
    '"': u'           \n,dPYb,     \nIP\'`Yb     \nI8  8I     \nI8  8\'     \nI8,dP      \nI8P"   88gg\nI8,    8I  \nI8b,  ,8I  \n "Y888P"\'  \n           \n           \n           \n           \n           \n           \n',
    '&': u'        \n        \n        \n        \n        \n ,ggg,  \ni8" "8i \nI8baaP\' \nY8,_    \n`"Y8888P\n        \n        \n        \n        \n        \n        \n',
    '*': u'             \n             \n I8a    a8I  \n  "Yb,,dP"   \naaaa8888aaaa \n""""8888"""" \n  ,dP\'`Yb,   \n I8"    "8I  \n             \n             \n             \n             \n             \n             \n             \n             \n',
    '.': u'     \n     \n     \n     \n     \n     \n     \n     \n d8b \n Y8P \n     \n     \n     \n     \n     \n     \n',
    '2': u' ad888888b, \nd8"     "88 \n         88 \n        d8P \n       a8P  \n     ,d8P   \n   ,d8P\'    \n ,d8P\'      \na88"        \n88888888888 \n            \n            \n            \n            \n            \n            \n',
    '6': u'  ad8888ba, \n 8P\'    "Y8 \nd8          \n88          \n88,dd888bb, \n88P\'    `8b \n88       88 \n88       88 \n88a     a8P \n "Y88888P"  \n            \n            \n            \n            \n            \n            \n',
    ':': u'        \n        \n        \n     gg \n     "" \n    ,gg \n  gP"8I \n     8I \n     8I \n     888\n   ,d8I\'\n ,dP\'8I \n,8"  8I \nI8   8I \n`8, ,8I \n `Y8P"  \n',
    '>': u'           \n           \n           \n           \n           \n,gg,,ggg,  \nP""8P" "8, \n   8I   8I \n   8I   Yb,\n   8I   `Y8\n           \n           \n           \n           \n           \n           \n',
    'B': u' ,ggggggggggg,  \ndP"""88""""""Y8,\nYb,  88      `8b\n `"  88      ,8P\n     88aaaad8P" \n     88""""Y8ba \n     88      `8b\n     88      ,8P\n     88_____,d8\'\n    88888888P"  \n                \n                \n                \n                \n                \n                \n',
    'F': u' ,gggggggggggggg\ndP""""""88""""""\nYb,_    88      \n `""    88      \n     ggg88gggg  \n        88   8  \n        88      \n  gg,   88      \n   "Yb,,8P      \n     "Y8P\'      \n                \n                \n                \n                \n                \n                \n',
    'J': u'     gg     \n    dP8,    \n   dP Yb    \n  ,8  `8,   \n  I8   Yb   \n  `8b, `8,  \n   `"Y88888 \n       "Y8  \n        ,88,\n    ,ad88888\n  ,dP"\'   Yb\n ,8\'      I8\n,8\'       I8\nI8,      ,8\'\n`Y8,___,d8\' \n  "Y888P"   \n',
    'N': u' ,ggg, ,ggggggg,  \ndP""Y8,8P"""""Y8b \nYb, `8dP\'     `88 \n `"  88\'       88 \n     88        88 \n     88        88 \n     88        88 \n     88        88 \n     88        Y8,\n     88        `Y8\n                  \n                  \n                  \n                  \n                  \n                  \n',
    'R': u' ,ggggggggggg,   \ndP"""88""""""Y8, \nYb,  88      `8b \n `"  88      ,8P \n     88aaaad8P"  \n     88""""Yb,   \n     88     "8b  \n     88      `8i \n     88       Yb,\n     88        Y8\n                 \n                 \n                 \n                 \n                 \n                 \n',
    'V': u' ,ggg,         ,gg\ndP""Y8a       ,8P \nYb, `88       d8\' \n `"  88       88  \n     88       88  \n     I8       8I  \n     `8,     ,8\'  \n      Y8,   ,8P   \n       Yb,_,dP    \n        "Y8P"     \n                  \n                  \n                  \n                  \n                  \n                  \n',
    'Z': u' ,gggggggg,    \nd8P""""""Y8b,  \n88,_a     `8b  \n`Y8P"      88  \n           88  \n          d8\'  \n       _,d8\'   \n     d8888ba,  \n         "Y88b,\n         ,d8888\n       ,8P"  88\n      d8\'    88\n     d8\'    ,88\n     88     d8\'\n     Y8,_ _,8P \n      "Y888P"  \n',
    '^': u'         \n         \n         \n         \n         \n  ,g,    \ngdP\'8,   \n8,   Yb  \n`Ya, ,8) \n  "Y88P88\n         \n         \n         \n         \n         \n         \n',
    'b': u'            \n ,dPYb,     \n IP\'`Yb     \n I8  8I     \n I8  8\'     \n I8 dP      \n I8dP   88gg\n I8P    8I  \n,d8b,  ,8I  \n8P\'"Y88P"\'  \n            \n            \n            \n            \n            \n            \n',
    'f': u'        \n ,dPYb, \n IP\'`Yb \n I8  8I \n I8  8\' \n I8 dP  \n I8dP   \n I8P    \n,d8b,_  \nPI8"8888\n I8 `8, \n I8  `8,\n I8   8I\n I8   8I\n I8, ,8\'\n  "Y8P\' \n',
    'j': u'        \n        \n        \n     gg \n     "" \n     gg \n     8I \n    ,8I \n  _,d8I \n888P"888\n   ,d8I\'\n ,dP\'8I \n,8"  8I \nI8   8I \n`8, ,8I \n `Y8P"  \n',
    'n': u'              \n              \n              \n              \n              \n  ,ggg,,ggg,  \n ,8" "8P" "8, \n I8   8I   8I \n,dP   8I   Yb,\n8P\'   8I   `Y8\n              \n              \n              \n              \n              \n              \n',
    'r': u'           \n           \n           \n           \n           \n  ,gggggg, \n  dP""""8I \n ,8\'    8I \n,dP     Y8,\n8P      `Y8\n           \n           \n           \n           \n           \n           \n',
    'v': u'               \n               \n               \n               \n               \n    ggg    gg  \n   d8"Yb   88bg\n  dP  I8   8I  \n,dP   I8, ,8I  \n8"     "Y8P"   \n               \n               \n               \n               \n               \n               \n',
    'z': u'           \n           \n           \n           \n           \n    ,gggg, \n   d8"  Yb \n  dP    dP \n,dP  ,adP\' \n8"   ""Y8d8\n      ,d8I\'\n    ,dP\'8I \n   ,8"  8I \n   I8   8I \n   `8, ,8I \n    `Y8P"  \n',
    '~': u'          \n          \n          \n          \n          \ngg     gg \n88     8I \nI8,   ,8I \nI8b, ,d8I \n "Y88P"888\n     ,d8I\'\n   ,dP\'8I \n  ,8"  8I \n  I8   8I \n  `8, ,8I \n   `Y8P"  \n',
    '!': u'           \n           \n           \n           \n           \n  ,gggg,gg \ngdP"  "Y8I \nI8\'    ,8I \nY8,   ,d8b,\n`Y8888P"`Y8\n           \n           \n           \n           \n           \n           \n',
    '%': u'           \n        8I \n        8I \n        8I \n        8I \n  ,gggg,8I \ngdP"  "Y8I \nI8\'    ,8I \nY8,   ,d8b,\n`Y8888P"`Y8\n           \n           \n           \n           \n           \n           \n',
    ')': u'           \n           \n           \n           \n           \n  ,gggg,gg \ngdP"  "Y8I \nI8\'    ,8I \nY8,   ,d8I \n`Y8888P"888\n      ,d8I\'\n    ,dP\'8I \n   ,8"  8I \n   I8   8I \n   `8, ,8I \n    `Y8P"  \n',
    '-': u'          \n          \n          \n          \n          \n aaaaaaaa \n """""""" \n          \n          \n          \n          \n          \n          \n          \n          \n          \n',
    '1': u'    88 \n  ,d88 \n888888 \n    88 \n    88 \n    88 \n    88 \n    88 \n    88 \n    88 \n       \n       \n       \n       \n       \n       \n',
    '5': u'88888888888 \n88          \n88          \n88  ____    \n88a8PPPP8b, \nPP"     `8b \n         88 \n         88 \nY8a     a8P \n "Y88888P"  \n            \n            \n            \n            \n            \n            \n',
    '9': u' ad88888ba  \nd8"     "88 \n88       88 \n88       88 \nY8,    ,d88 \n "PPPPPP"88 \n         88 \n         8P \n8b,    a8P  \n`"Y8888P\'   \n            \n            \n            \n            \n            \n            \n',
    '=': u'                \n                \n                \n                \n                \n,gg,,ggg,,ggg,  \nP""8P" "8P" "8, \n   8I   8I   8I \n   8I   8I   Yb,\n   8I   8I   `Y8\n                \n                \n                \n                \n                \n                \n',
    'A': u'           ,ggg,  \n          dP""8I  \n         dP   88  \n        dP    88  \n       ,8\'    88  \n       d88888888  \n __   ,8"     88  \ndP"  ,8P      Y8  \nYb,_,dP       `8b,\n "Y8P"         `Y8\n                  \n                  \n                  \n                  \n                  \n                  \n',
    'E': u'   ,ggggggg, \n ,dP""""""Y8b\n d8\'    a  Y8\n 88     "Y8P\'\n `8baaaa     \n,d8P""""     \nd8"          \nY8,          \n`Yba,,_____, \n  `"Y8888888 \n             \n             \n             \n             \n             \n             \n',
    'I': u'      ,a8a, \n     ,8" "8,\n     d8   8b\n     88   88\n     88   88\n     Y8   8P\n     `8, ,8\'\n8888  "8,8" \n`8b,  ,d8b, \n  "Y88P" "Y8\n            \n            \n            \n            \n            \n            \n',
    'M': u' ,ggg, ,ggg,_,ggg,  \ndP""Y8dP""Y88P""Y8b \nYb, `88\'  `88\'  `88 \n `"  88    88    88 \n     88    88    88 \n     88    88    88 \n     88    88    88 \n     88    88    88 \n     88    88    Y8,\n     88    88    `Y8\n                    \n                    \n                    \n                    \n                    \n                    \n',
    'Q': u'     _,ggg,_    \n    d8P"""Y8b,  \n    88,    "8b, \n     "Y8baaa`8b \n        `""" Y8 \n             d8 \n,ad8888b,   ,8P \nI8P\'  `"Y8a,8P\' \nI8b,,___,,888b,_\n `"Y88888P"\' "Y8\n                \n                \n                \n                \n                \n                \n',
    'U': u' ,ggg,         gg \ndP""Y8a        88 \nYb, `88        88 \n `"  88        88 \n     88        88 \n     88        88 \n     88        88 \n     88        88 \n     Y8b,____,d88,\n      "Y888888P"Y8\n                  \n                  \n                  \n                  \n                  \n                  \n',
    'Y': u' ,ggg,         gg \ndP""Y8a        88 \nYb, `88        88 \n `"  88        88 \n     88        88 \n     88        88 \n     88       ,88 \n     Y8b,___,d888 \n      "Y88888P"88,\n           ,ad8888\n          d8P" 88 \n        ,d8\'   88 \n        d8\'    88 \n        88     88 \n        Y8,_ _,88 \n         "Y888P"  \n',
    ']': u'        \n        \n        \n        \n        \n,ggggg, \n8""""8I \n     8I \n     Y8,\n     `Y8\n        \n        \n        \n        \n        \n        \n',
    'a': u'            \n            \n            \n            \n            \n   ,gggg,gg \n  dP"  "Y8I \n i8\'    ,8I \n,d8,   ,d8b,\nP"Y8888P"`Y8\n            \n            \n            \n            \n            \n            \n',
    'e': u'         \n         \n         \n         \n         \n  ,ggg,  \n i8" "8i \n I8, ,8I \n `YbadP\' \n888P"Y888\n         \n         \n         \n         \n         \n         \n',
    'i': u'      \n      \n      \n  gg  \n  ""  \n  gg  \n  88  \n  88  \n_,88,_\n8P""Y8\n      \n      \n      \n      \n      \n      \n',
    'm': u'                   \n                   \n                   \n                   \n                   \n  ,ggg,,ggg,,ggg,  \n ,8" "8P" "8P" "8, \n I8   8I   8I   8I \n,dP   8I   8I   Yb,\n8P\'   8I   8I   `Y8\n                   \n                   \n                   \n                   \n                   \n                   \n',
    'q': u'            \n            \n            \n            \n            \n   ,gggg,gg \n  dP"  "Y8I \n i8\'    ,8I \n,d8,   ,d8b \nP"Y8888P"88d\n         I8P\n         I8\'\n         I8 \n         I8 \n         I8 \n         I8 \n',
    'u': u'            \n            \n            \n            \n            \n gg      gg \n I8      8I \n I8,    ,8I \n,d8b,  ,d8b,\n8P\'"Y88P"`Y8\n            \n            \n            \n            \n            \n            \n',
    'y': u'           \n           \n           \n           \n           \n gg     gg \n I8     8I \n I8,   ,8I \n,d8b, ,d8I \nP""Y88P"888\n      ,d8I\'\n    ,dP\'8I \n   ,8"  8I \n   I8   8I \n   `8, ,8I \n    `Y8P"  \n',
    '}': u'          \n          \n          \n          \n          \n,gg,   ,gg\nP""8b,dP" \n   ,88"   \n ,dP"Y8,  \ndP"   "Y88\n          \n          \n          \n          \n          \n          \n'}

nvscript_dic = {
    ' ': u'        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n',
    '$': u'',
    '(': u'',
    ',': u'',
    '0': u'',
    '4': u'',
    '8': u'',
    '<': u'',
    '@': u'',
    'D': u' ,gggggggggggg,   \ndP"""88""""""Y8b, \nYb,  88       `8b,\n `"  88        `8b\n     88         Y8\n     88         d8\n     88        ,8P\n     88       ,8P\'\n     88______,dP\' \n    888888888P"   \n                  \n                  \n                  \n                  \n                  \n                  \n',
    'H': u' ,ggg,        gg \ndP""Y8b       88 \nYb, `88       88 \n `"  88       88 \n     88aaaaaaa88 \n     88"""""""88 \n     88       88 \n     88       88 \n     88       Y8,\n     88       `Y8\n                 \n                 \n                 \n                 \n                 \n                 \n',
    'L': u'       ,gggg,  \n      d8" "8I  \n      88  ,dP  \n   8888888P"   \n      88       \n      88       \n ,aa,_88       \ndP" "88P       \nYb,_,d88b,,_   \n "Y8P"  "Y88888\n               \n               \n               \n               \n               \n               \n',
    'P': u' ,ggggggggggg,  \ndP"""88""""""Y8,\nYb,  88      `8b\n `"  88      ,8P\n     88aaaad8P" \n     88"""""    \n     88         \n     88         \n     88         \n     88         \n                \n                \n                \n                \n                \n                \n',
    'T': u' ,ggggggggggggggg\ndP""""""88"""""""\nYb,_    88       \n `""    88       \n        88       \n        88       \n        88       \n  gg,   88       \n   "Yb,,8P       \n     "Y8P\'       \n                 \n                 \n                 \n                 \n                 \n                 \n',
    'X': u' ,ggg,          ,gg\ndP"""Y8,      ,dP\' \nYb,_  "8b,   d8"   \n `""    Y8,,8P\'    \n         Y88"      \n        ,888b      \n       d8" "8b,    \n     ,8P\'    Y8,   \n    d8"       "Yb, \n  ,8P\'          "Y8\n                   \n                   \n                   \n                   \n                   \n                   \n',
    '\\': u'',
    '`': u'',
    'd': u'            \n         8I \n         8I \n         8I \n         8I \n   ,gggg,8I \n  dP"  "Y8I \n i8\'    ,8I \n,d8,   ,d8b,\nP"Y8888P"`Y8\n            \n            \n            \n            \n            \n            \n',
    'h': u'           \n ,dPYb,    \n IP\'`Yb    \n I8  8I    \n I8  8\'    \n I8 dPgg,  \n I8dP" "8I \n I8P    I8 \n,d8     I8,\n88P     `Y8\n           \n           \n           \n           \n           \n           \n',
    'l': u'       \n ,dPYb,\n IP\'`Yb\n I8  8I\n I8  8\'\n I8 dP \n I8dP  \n I8P   \n,d8b,_ \n8P\'"Y88\n       \n       \n       \n       \n       \n       \n',
    'p': u'            \n            \n            \n            \n            \n gg,gggg,   \n I8P"  "Yb  \n I8\'    ,8i \n,I8 _  ,d8\' \nPI8 YY88888P\n I8         \n I8         \n I8         \n I8         \n I8         \n I8         \n',
    't': u'        \n   I8   \n   I8   \n88888888\n   I8   \n   I8   \n   I8   \n  ,I8,  \n ,d88b, \n 8P""Y8 \n        \n        \n        \n        \n        \n        \n',
    'x': u'              \n              \n              \n              \n              \n    ,gg,   ,gg\n   d8""8b,dP" \n  dP   ,88"   \n,dP  ,dP"Y8,  \n8"  dP"   "Y8 \n              \n              \n              \n              \n              \n              \n',
    '|': u'',
    '#': u'',
    "'": u'',
    '+': u'',
    '/': u'',
    '3': u'',
    '7': u'',
    ';': u'',
    '?': u'',
    'C': u'     ,gggg,  \n   ,88"""Y8b,\n  d8"     `Y8\n d8\'   8b  d8\n,8I    "Y88P\'\nI8\'          \nd8           \nY8,          \n`Yba,,_____, \n  `"Y8888888 \n             \n             \n             \n             \n             \n             \n',
    'G': u'    ,gg,      \n   i8""8i     \n   `8,,8\'     \n    `Y88aaad8 \n     d8""""Y8,\n    ,8P     8b\n    dP      Y8\n_ ,dP\'      I8\n"888,,_____,dP\na8P"Y888888P" \n              \n              \n              \n              \n              \n              \n',
    'K': u' ,ggg,        gg \ndP""Y8b       dP \nYb, `88      d8\' \n `"  88    ,dP\'  \n     88aaad8"    \n     88""""Yb,   \n     88     "8b  \n     88      `8i \n     88       Yb,\n     88        Y8\n                 \n                 \n                 \n                 \n                 \n                 \n',
    'O': u'   _,gggggg,_     \n ,d8P""d8P"Y8b,   \n,d8\'   Y8   "8b,dP\nd8\'    `Ybaaad88P\'\n8P       `""""Y8  \n8b            d8  \nY8,          ,8P  \n`Y8,        ,8P\'  \n `Y8b,,__,,d8P\'   \n   `"Y8888P"\'     \n                  \n                  \n                  \n                  \n                  \n                  \n',
    'S': u'      ,gg,   \n     i8""8i  \n     `8,,8\'  \n      `88\'   \n      dP"8,  \n     dP\' `8a \n    dP\'   `Yb\n_ ,dP\'     I8\n"888,,____,dP\na8P"Y88888P" \n             \n             \n             \n             \n             \n             \n',
    'W': u' ,ggg,      gg      ,gg\ndP""Y8a     88     ,8P \nYb, `88     88     d8\' \n `"  88     88     88  \n     88     88     88  \n     88     88     88  \n     88     88     88  \n     Y8    ,88,    8P  \n      Yb,,d8""8b,,dP   \n       "88"    "88"    \n                       \n                       \n                       \n                       \n                       \n                       \n',
    '[': u'',
    '_': u'',
    'c': u'          \n          \n          \n          \n          \n   ,gggg, \n  dP"  "Yb\n i8\'      \n,d8,_    _\nP""Y8888PP\n          \n          \n          \n          \n          \n          \n',
    'g': u'            \n            \n            \n            \n            \n   ,gggg,gg \n  dP"  "Y8I \n i8\'    ,8I \n,d8,   ,d8I \nP"Y8888P"888\n       ,d8I\'\n     ,dP\'8I \n    ,8"  8I \n    I8   8I \n    `8, ,8I \n     `Y8P"  \n',
    'k': u'           \n ,dPYb,    \n IP\'`Yb    \n I8  8I    \n I8  8bgg, \n I8 dP" "8 \n I8d8bggP" \n I8P\' "Yb, \n,d8    `Yb,\n88P      Y8\n           \n           \n           \n           \n           \n           \n',
    'o': u'             \n             \n             \n             \n             \n   ,ggggg,   \n  dP"  "Y8ggg\n i8\'    ,8I  \n,d8,   ,d8\'  \nP"Y8888P"    \n             \n             \n             \n             \n             \n             \n',
    's': u'          \n          \n          \n          \n          \n   ,g,    \n  ,8\'8,   \n ,8\'  Yb  \n,8\'_   8) \nP\' "YY8P8P\n          \n          \n          \n          \n          \n          \n',
    'w': u'                 \n                 \n                 \n                 \n                 \n gg    gg    gg  \n I8    I8    88bg\n I8    I8    8I  \n,d8,  ,d8,  ,8I  \nP""Y88P""Y88P"   \n                 \n                 \n                 \n                 \n                 \n                 \n',
    '{': u'',
    '"': u'',
    '&': u'',
    '*': u'',
    '.': u'',
    '2': u'',
    '6': u'',
    ':': u'',
    '>': u'',
    'B': u' ,ggggggggggg,  \ndP"""88""""""Y8,\nYb,  88      `8b\n `"  88      ,8P\n     88aaaad8P" \n     88""""Y8ba \n     88      `8b\n     88      ,8P\n     88_____,d8\'\n    88888888P"  \n                \n                \n                \n                \n                \n                \n',
    'F': u' ,gggggggggggggg\ndP""""""88""""""\nYb,_    88      \n `""    88      \n     ggg88gggg  \n        88   8  \n        88      \n  gg,   88      \n   "Yb,,8P      \n     "Y8P\'      \n                \n                \n                \n                \n                \n                \n',
    'J': u'     gg     \n    dP8,    \n   dP Yb    \n  ,8  `8,   \n  I8   Yb   \n  `8b, `8,  \n   `"Y88888 \n       "Y8  \n        ,88,\n    ,ad88888\n  ,dP"\'   Yb\n ,8\'      I8\n,8\'       I8\nI8,      ,8\'\n`Y8,___,d8\' \n  "Y888P"   \n',
    'N': u' ,ggg, ,ggggggg,  \ndP""Y8,8P"""""Y8b \nYb, `8dP\'     `88 \n `"  88\'       88 \n     88        88 \n     88        88 \n     88        88 \n     88        88 \n     88        Y8,\n     88        `Y8\n                  \n                  \n                  \n                  \n                  \n                  \n',
    'R': u' ,ggggggggggg,   \ndP"""88""""""Y8, \nYb,  88      `8b \n `"  88      ,8P \n     88aaaad8P"  \n     88""""Yb,   \n     88     "8b  \n     88      `8i \n     88       Yb,\n     88        Y8\n                 \n                 \n                 \n                 \n                 \n                 \n',
    'V': u' ,ggg,         ,gg\ndP""Y8a       ,8P \nYb, `88       d8\' \n `"  88       88  \n     88       88  \n     I8       8I  \n     `8,     ,8\'  \n      Y8,   ,8P   \n       Yb,_,dP    \n        "Y8P"     \n                  \n                  \n                  \n                  \n                  \n                  \n',
    'Z': u' ,gggggggg,    \nd8P""""""Y8b,  \n88,_a     `8b  \n`Y8P"      88  \n           88  \n          d8\'  \n       _,d8\'   \n     d8888ba,  \n         "Y88b,\n         ,d8888\n       ,8P"  88\n      d8\'    88\n     d8\'    ,88\n     88     d8\'\n     Y8,_ _,8P \n      "Y888P"  \n',
    '^': u'',
    'b': u'            \n ,dPYb,     \n IP\'`Yb     \n I8  8I     \n I8  8\'     \n I8 dP      \n I8dP   88gg\n I8P    8I  \n,d8b,  ,8I  \n8P\'"Y88P"\'  \n            \n            \n            \n            \n            \n            \n',
    'f': u'        \n ,dPYb, \n IP\'`Yb \n I8  8I \n I8  8\' \n I8 dP  \n I8dP   \n I8P    \n,d8b,_  \nPI8"888 \n I8 `8, \n I8  `8,\n I8   8I\n I8   8I\n I8, ,8\'\n  "Y8P\' \n',
    'j': u'        \n        \n        \n     gg \n     "" \n     gg \n     8I \n    ,8I \n  _,d8I \n888P"888\n   ,d8I\'\n ,dP\'8I \n,8"  8I \nI8   8I \n`8, ,8I \n `Y8P"  \n',
    'n': u'              \n              \n              \n              \n              \n  ,ggg,,ggg,  \n ,8" "8P" "8, \n I8   8I   8I \n,dP   8I   Yb,\n8P\'   8I   `Y8\n              \n              \n              \n              \n              \n              \n',
    'r': u'           \n           \n           \n           \n           \n  ,gggggg, \n  dP""""8I \n ,8\'    8I \n,dP     Y8,\n8P      `Y8\n           \n           \n           \n           \n           \n           \n',
    'v': u'               \n               \n               \n               \n               \n    ggg    gg  \n   d8"Yb   88bg\n  dP  I8   8I  \n,dP   I8, ,8I  \n8"     "Y8P"   \n               \n               \n               \n               \n               \n               \n',
    'z': u'           \n           \n           \n           \n           \n    ,gggg, \n   d8"  Yb \n  dP    dP \n,dP  ,adP\' \n8"   ""Y8d8\n      ,d8I\'\n    ,dP\'8I \n   ,8"  8I \n   I8   8I \n   `8, ,8I \n    `Y8P"  \n',
    '~': u'',
    '!': u'',
    '%': u'',
    ')': u'',
    '-': u'',
    '1': u'',
    '5': u'',
    '9': u'',
    '=': u'',
    'A': u'           ,ggg,  \n          dP""8I  \n         dP   88  \n        dP    88  \n       ,8\'    88  \n       d88888888  \n __   ,8"     88  \ndP"  ,8P      Y8  \nYb,_,dP       `8b,\n "Y8P"         `Y8\n                  \n                  \n                  \n                  \n                  \n                  \n',
    'E': u'   ,ggggggg, \n ,dP""""""Y8b\n d8\'    a  Y8\n 88     "Y8P\'\n `8baaaa     \n,d8P""""     \nd8"          \nY8,          \n`Yba,,_____, \n  `"Y8888888 \n             \n             \n             \n             \n             \n             \n',
    'I': u'      ,a8a, \n     ,8" "8,\n     d8   8b\n     88   88\n     88   88\n     Y8   8P\n     `8, ,8\'\n8888  "8,8" \n`8b,  ,d8b, \n  "Y88P" "Y8\n            \n            \n            \n            \n            \n            \n',
    'M': u' ,ggg, ,ggg,_,ggg,  \ndP""Y8dP""Y88P""Y8b \nYb, `88\'  `88\'  `88 \n `"  88    88    88 \n     88    88    88 \n     88    88    88 \n     88    88    88 \n     88    88    88 \n     88    88    Y8,\n     88    88    `Y8\n                    \n                    \n                    \n                    \n                    \n                    \n',
    'Q': u'     _,ggg,_    \n    d8P"""Y8b,  \n    88,    "8b, \n     "Y8baaa`8b \n        `""" Y8 \n             d8 \n,ad8888b,   ,8P \nI8P\'  `"Y8a,8P\' \nI8b,,___,,888b,_\n `"Y88888P"\' "Y8\n                \n                \n                \n                \n                \n                \n',
    'U': u' ,ggg,         gg \ndP""Y8a        88 \nYb, `88        88 \n `"  88        88 \n     88        88 \n     88        88 \n     88        88 \n     88        88 \n     Y8b,____,d88,\n      "Y888888P"Y8\n                  \n                  \n                  \n                  \n                  \n                  \n',
    'Y': u' ,ggg,         gg \ndP""Y8a        88 \nYb, `88        88 \n `"  88        88 \n     88        88 \n     88        88 \n     88       ,88 \n     Y8b,___,d888 \n      "Y88888P"88,\n           ,ad8888\n          d8P" 88 \n        ,d8\'   88 \n        d8\'    88 \n        88     88 \n        Y8,_ _,88 \n         "Y888P"  \n',
    ']': u'',
    'a': u'            \n            \n            \n            \n            \n   ,gggg,gg \n  dP"  "Y8I \n i8\'    ,8I \n,d8,   ,d8b,\nP"Y8888P"`Y8\n            \n            \n            \n            \n            \n            \n',
    'e': u'         \n         \n         \n         \n         \n  ,ggg,  \n i8" "8i \n I8, ,8I \n `YbadP\' \n888P"Y888\n         \n         \n         \n         \n         \n         \n',
    'i': u'      \n      \n      \n  gg  \n  ""  \n  gg  \n  88  \n  88  \n_,88,_\n8P""Y8\n      \n      \n      \n      \n      \n      \n',
    'm': u'                   \n                   \n                   \n                   \n                   \n  ,ggg,,ggg,,ggg,  \n ,8" "8P" "8P" "8, \n I8   8I   8I   8I \n,dP   8I   8I   Yb,\n8P\'   8I   8I   `Y8\n                   \n                   \n                   \n                   \n                   \n                   \n',
    'q': u'            \n            \n            \n            \n            \n   ,gggg,gg \n  dP"  "Y8I \n i8\'    ,8I \n,d8,   ,d8b \nP"Y8888P"88d\n         I8P\n         I8\'\n         I8 \n         I8 \n         I8 \n         I8 \n',
    'u': u'            \n            \n            \n            \n            \n gg      gg \n I8      8I \n I8,    ,8I \n,d8b,  ,d8b,\n8P\'"Y88P"`Y8\n            \n            \n            \n            \n            \n            \n',
    'y': u'           \n           \n           \n           \n           \n gg     gg \n I8     8I \n I8,   ,8I \n,d8b, ,d8I \nP""Y88P"888\n      ,d8I\'\n    ,dP\'8I \n   ,8"  8I \n   I8   8I \n   `8, ,8I \n    `Y8P"  \n',
    '}': u''}

octal_dic = {
    ' ': u' \n',
    '$': u'044 \n',
    '(': u'050 \n',
    ',': u'054 \n',
    '0': u'060 \n',
    '4': u'064 \n',
    '8': u'070 \n',
    '<': u'074 \n',
    '@': u'100 \n',
    'D': u'104 \n',
    'H': u'110 \n',
    'L': u'114 \n',
    'P': u'120 \n',
    'T': u'124 \n',
    'X': u'130 \n',
    '\\': u'134 \n',
    '`': u'140 \n',
    'd': u'144 \n',
    'h': u'150 \n',
    'l': u'154 \n',
    'p': u'160 \n',
    't': u'164 \n',
    'x': u'170 \n',
    '|': u'174 \n',
    '#': u'043 \n',
    "'": u'047 \n',
    '+': u'053 \n',
    '/': u'057 \n',
    '3': u'063 \n',
    '7': u'067 \n',
    ';': u'073 \n',
    '?': u'077 \n',
    'C': u'103 \n',
    'G': u'107 \n',
    'K': u'113 \n',
    'O': u'117 \n',
    'S': u'123 \n',
    'W': u'127 \n',
    '[': u'133 \n',
    '_': u'137 \n',
    'c': u'143 \n',
    'g': u'147 \n',
    'k': u'153 \n',
    'o': u'157 \n',
    's': u'163 \n',
    'w': u'167 \n',
    '{': u'173 \n',
    '"': u'042 \n',
    '&': u'046 \n',
    '*': u'052 \n',
    '.': u'056 \n',
    '2': u'062 \n',
    '6': u'066 \n',
    ':': u'072 \n',
    '>': u'076 \n',
    'B': u'102 \n',
    'F': u'106 \n',
    'J': u'112 \n',
    'N': u'116 \n',
    'R': u'122 \n',
    'V': u'126 \n',
    'Z': u'132 \n',
    '^': u'136 \n',
    'b': u'142 \n',
    'f': u'146 \n',
    'j': u'152 \n',
    'n': u'156 \n',
    'r': u'162 \n',
    'v': u'166 \n',
    'z': u'172 \n',
    '~': u'176 \n',
    '!': u'041 \n',
    '%': u'045 \n',
    ')': u'051 \n',
    '-': u'055 \n',
    '1': u'061 \n',
    '5': u'065 \n',
    '9': u'071 \n',
    '=': u'075 \n',
    'A': u'101 \n',
    'E': u'105 \n',
    'I': u'111 \n',
    'M': u'115 \n',
    'Q': u'121 \n',
    'U': u'125 \n',
    'Y': u'131 \n',
    ']': u'135 \n',
    'a': u'141 \n',
    'e': u'145 \n',
    'i': u'151 \n',
    'm': u'155 \n',
    'q': u'161 \n',
    'u': u'165 \n',
    'y': u'171 \n',
    '}': u'175 \n'}

oldbanner_dic = {
    ' ': u'   \n   \n   \n   \n   \n   \n   \n',
    '$': u' #####  \n#  #  # \n#  #    \n #####  \n   #  # \n#  #  # \n #####  \n',
    '(': u'  ## \n #   \n#    \n#    \n#    \n #   \n  ## \n',
    ',': u'    \n    \n    \n### \n### \n #  \n#   \n',
    '0': u'  ###   \n #   #  \n#     # \n#     # \n#     # \n #   #  \n  ###   \n',
    '4': u'#       \n#    #  \n#    #  \n#    #  \n####### \n     #  \n     #  \n',
    '8': u' #####  \n#     # \n#     # \n #####  \n#     # \n#     # \n #####  \n',
    '<': u'   # \n  #  \n #   \n#    \n #   \n  #  \n   # \n',
    '@': u' #####  \n#     # \n# ### # \n# ### # \n# ####  \n#       \n #####  \n',
    'D': u'######  \n#     # \n#     # \n#     # \n#     # \n#     # \n######  \n',
    'H': u'#     # \n#     # \n#     # \n####### \n#     # \n#     # \n#     # \n',
    'L': u'#       \n#       \n#       \n#       \n#       \n#       \n####### \n',
    'P': u'######  \n#     # \n#     # \n######  \n#       \n#       \n#       \n',
    'T': u'####### \n   #    \n   #    \n   #    \n   #    \n   #    \n   #    \n',
    'X': u'#     # \n #   #  \n  # #   \n   #    \n  # #   \n #   #  \n#     # \n',
    '\\': u'#       \n #      \n  #     \n   #    \n    #   \n     #  \n      # \n',
    '`': u'### \n### \n #  \n  # \n    \n    \n    \n',
    'd': u'       \n#####  \n#    # \n#    # \n#    # \n#    # \n#####  \n',
    'h': u'       \n#    # \n#    # \n###### \n#    # \n#    # \n#    # \n',
    'l': u'       \n#      \n#      \n#      \n#      \n#      \n###### \n',
    'p': u'       \n#####  \n#    # \n#    # \n#####  \n#      \n#      \n',
    't': u'      \n##### \n  #   \n  #   \n  #   \n  #   \n  #   \n',
    'x': u'       \n#    # \n #  #  \n  ##   \n  ##   \n #  #  \n#    # \n',
    '|': u'# \n# \n# \n  \n# \n# \n# \n',
    '#': u'  # #   \n  # #   \n####### \n  # #   \n####### \n  # #   \n  # #   \n',
    "'": u'### \n### \n #  \n#   \n    \n    \n    \n',
    '+': u'      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n',
    '/': u'      # \n     #  \n    #   \n   #    \n  #     \n #      \n#       \n',
    '3': u' #####  \n#     # \n      # \n #####  \n      # \n#     # \n #####  \n',
    '7': u'####### \n#    #  \n    #   \n   #    \n  #     \n  #     \n  #     \n',
    ';': u'### \n### \n    \n### \n### \n #  \n#   \n',
    '?': u' #####  \n#     # \n      # \n   ###  \n   #    \n        \n   #    \n',
    'C': u' #####  \n#     # \n#       \n#       \n#       \n#     # \n #####  \n',
    'G': u' #####  \n#     # \n#       \n#  #### \n#     # \n#     # \n #####  \n',
    'K': u'#    # \n#   #  \n#  #   \n###    \n#  #   \n#   #  \n#    # \n',
    'O': u'####### \n#     # \n#     # \n#     # \n#     # \n#     # \n####### \n',
    'S': u' #####  \n#     # \n#       \n #####  \n      # \n#     # \n #####  \n',
    'W': u'#     # \n#  #  # \n#  #  # \n#  #  # \n#  #  # \n#  #  # \n ## ##  \n',
    '[': u'##### \n#     \n#     \n#     \n#     \n#     \n##### \n',
    '_': u'        \n        \n        \n        \n        \n        \n####### \n',
    'c': u'       \n ####  \n#    # \n#      \n#      \n#    # \n ####  \n',
    'g': u'       \n ####  \n#    # \n#      \n#  ### \n#    # \n ####  \n',
    'k': u'       \n#    # \n#   #  \n####   \n#  #   \n#   #  \n#    # \n',
    'o': u'       \n ####  \n#    # \n#    # \n#    # \n#    # \n ####  \n',
    's': u'       \n ####  \n#      \n ####  \n     # \n#    # \n ####  \n',
    'w': u'       \n#    # \n#    # \n#    # \n# ## # \n##  ## \n#    # \n',
    '{': u'  ### \n #    \n #    \n##    \n #    \n #    \n  ### \n',
    '"': u'### ### \n### ### \n #   #  \n        \n        \n        \n        \n',
    '&': u'  ##    \n #  #   \n  ##    \n ###    \n#   # # \n#    #  \n ###  # \n',
    '*': u'        \n #   #  \n  # #   \n####### \n  # #   \n #   #  \n        \n',
    '.': u'    \n    \n    \n    \n### \n### \n### \n',
    '2': u' #####  \n#     # \n      # \n #####  \n#       \n#       \n####### \n',
    '6': u' #####  \n#     # \n#       \n######  \n#     # \n#     # \n #####  \n',
    ':': u' #  \n### \n #  \n    \n #  \n### \n #  \n',
    '>': u'#    \n #   \n  #  \n   # \n  #  \n #   \n#    \n',
    'B': u'######  \n#     # \n#     # \n######  \n#     # \n#     # \n######  \n',
    'F': u'####### \n#       \n#       \n#####   \n#       \n#       \n#       \n',
    'J': u'      # \n      # \n      # \n      # \n#     # \n#     # \n #####  \n',
    'N': u'#     # \n##    # \n# #   # \n#  #  # \n#   # # \n#    ## \n#     # \n',
    'R': u'######  \n#     # \n#     # \n######  \n#   #   \n#    #  \n#     # \n',
    'V': u'#     # \n#     # \n#     # \n#     # \n #   #  \n  # #   \n   #    \n',
    'Z': u'####### \n     #  \n    #   \n   #    \n  #     \n #      \n####### \n',
    '^': u'  #   \n # #  \n#   # \n      \n      \n      \n      \n',
    'b': u'       \n#####  \n#    # \n#####  \n#    # \n#    # \n#####  \n',
    'f': u'       \n###### \n#      \n#####  \n#      \n#      \n#      \n',
    'j': u'       \n     # \n     # \n     # \n     # \n#    # \n ####  \n',
    'n': u'       \n#    # \n##   # \n# #  # \n#  # # \n#   ## \n#    # \n',
    'r': u'       \n#####  \n#    # \n#    # \n#####  \n#   #  \n#    # \n',
    'v': u'       \n#    # \n#    # \n#    # \n#    # \n #  #  \n  ##   \n',
    'z': u'       \n###### \n    #  \n   #   \n  #    \n #     \n###### \n',
    '~': u' ##     \n#  #  # \n    ##  \n        \n        \n        \n        \n',
    '!': u'### \n### \n### \n #  \n    \n### \n### \n',
    '%': u'###   # \n# #  #  \n### #   \n   #    \n  # ### \n #  # # \n#   ### \n',
    ')': u'##   \n  #  \n   # \n   # \n   # \n  #  \n##   \n',
    '-': u'      \n      \n      \n##### \n      \n      \n      \n',
    '1': u'   #   \n  ##   \n # #   \n   #   \n   #   \n   #   \n ##### \n',
    '5': u'####### \n#       \n#       \n######  \n      # \n#     # \n #####  \n',
    '9': u' #####  \n#     # \n#     # \n ###### \n      # \n#     # \n #####  \n',
    '=': u'      \n      \n##### \n      \n##### \n      \n      \n',
    'A': u'   #    \n  # #   \n #   #  \n#     # \n####### \n#     # \n#     # \n',
    'E': u'####### \n#       \n#       \n#####   \n#       \n#       \n####### \n',
    'I': u'### \n #  \n #  \n #  \n #  \n #  \n### \n',
    'M': u'#     # \n##   ## \n# # # # \n#  #  # \n#     # \n#     # \n#     # \n',
    'Q': u' #####  \n#     # \n#     # \n#     # \n#   # # \n#    #  \n #### # \n',
    'U': u'#     # \n#     # \n#     # \n#     # \n#     # \n#     # \n #####  \n',
    'Y': u'#     # \n #   #  \n  # #   \n   #    \n   #    \n   #    \n   #    \n',
    ']': u'##### \n    # \n    # \n    # \n    # \n    # \n##### \n',
    'a': u'       \n  ##   \n #  #  \n#    # \n###### \n#    # \n#    # \n',
    'e': u'       \n###### \n#      \n#####  \n#      \n#      \n###### \n',
    'i': u'  \n# \n# \n# \n# \n# \n# \n',
    'm': u'       \n#    # \n##  ## \n# ## # \n#    # \n#    # \n#    # \n',
    'q': u'       \n ####  \n#    # \n#    # \n#  # # \n#   #  \n ### # \n',
    'u': u'       \n#    # \n#    # \n#    # \n#    # \n#    # \n ####  \n',
    'y': u'      \n#   # \n # #  \n  #   \n  #   \n  #   \n  #   \n',
    '}': u'###   \n   #  \n   #  \n   ## \n   #  \n   #  \n###   \n'}

os2_dic = {
    ' ': u'____\n____\n____\n____\n____\n____\n____\n',
    '$': u'_ooooo__\noo_o_oo_\n_ooo____\n___oo___\noo_o_oo_\n_ooooo__\n___o____\n',
    '(': u'___oo_\n_oo___\noo____\noo____\n_oo___\n___oo_\n______\n',
    ',': u'____\n____\n____\n____\n_oo_\n_oo_\noo__\n',
    '0': u'___ooo_o__\n_oo___oo__\noo___o_oo_\noo__o__oo_\n_ooo__oo__\n__oooo____\n_o________\n',
    '4': u'_____ooo_\n___oo_oo_\n_oo___oo_\noooooooo_\n______oo_\n______oo_\n_________\n',
    '8': u'_oooooo__\noo____oo_\n_oooooo__\noo____oo_\noo____oo_\n_oooooo__\n_________\n',
    '<': u'___oo_\n__oo__\n_oo___\noo____\n_oo___\n__oo__\n___oo_\n',
    '@': u'____ooooo__\n__oo_oo_oo_\n_oo_o__o_o_\noo_o__oo_o_\noo__oo_ooo_\n_oo________\n__oooooo___\n',
    'D': u'oooooo____\noo____oo__\noo_____oo_\noo_____oo_\noo____oo__\noooooo____\n__________\n',
    'H': u'oo____oo_\noo____oo_\noo____oo_\noooooooo_\noo____oo_\noo____oo_\n_________\n',
    'L': u'oo______\noo______\noo______\noo______\noo______\nooooooo_\n________\n',
    'P': u'ooooooo__\noo____oo_\noo____oo_\noooooo___\noo_______\noo_______\n_________\n',
    'T': u'oooooooo_\n___oo____\n___oo____\n___oo____\n___oo____\n___oo____\n_________\n',
    'X': u'oo_____oo_\n_oo___oo__\n__oo_oo___\n___ooo____\n__oo_oo___\n_oo___oo__\n__________\n',
    '\\': u'oo______\n_oo_____\n__oo____\n___oo___\n____oo__\n_____oo_\n______oo\n',
    '`': u'oo__\noo__\n_oo_\n____\n____\n____\n____\n',
    'd': u'_____oo_\n_oooooo_\noo___oo_\noo___oo_\noo___oo_\n_oooooo_\n________\n',
    'h': u'oo______\noo_ooo__\nooo___o_\noo____o_\noo____o_\noo____o_\n________\n',
    'l': u'ooo___\n_oo___\n_oo___\n_oo___\n_oo___\nooooo_\n______\n',
    'p': u'__________\n___ooooo__\n___o___oo_\n__oo___oo_\n__oo___oo_\no_ooooo___\noooo______\n',
    't': u'_oo____\n_oo____\noooo___\n_oo____\n_oo__o_\n__ooo__\n_______\n',
    'x': u'_______\no____o_\n_oo_o__\n__oo___\n_o_oo__\no___oo_\n_______\n',
    '|': u'oo_\noo_\noo_\noo_\noo_\noo_\noo_\n',
    '#': u'__o_o___\n__o_o___\nooo_ooo_\n__o_o___\nooo_ooo_\n__o_o___\n__o_o___\n',
    "'": u'_oo_\n_oo_\noo__\n____\n____\n____\n____\n',
    '+': u'______\n__o___\n__o___\nooooo_\n__o___\n__o___\n______\n',
    '/': u'______oo_\n_____oo__\n____oo___\n___oo____\n__oo_____\n_oo______\noo_______\n',
    '3': u'__ooooo__\noo____oo_\n______oo_\n____ooo__\noo____oo_\n_oooooo__\n_________\n',
    '7': u'ooooooo_\n_____oo_\n____oo__\n___oo___\n__oo____\n_oo_____\n________\n',
    ';': u'____\n_oo_\n_oo_\n____\n_oo_\n_oo_\noo__\n',
    '?': u'_oooo__\noo__oo_\n____oo_\n__ooo__\n__oo___\n_______\n__oo___\n',
    'C': u'___oooo___\n_oo____oo_\noo________\noo________\n_oo____oo_\n___oooo___\n__________\n',
    'G': u'___oooo___\n_oo____oo_\noo________\noo____ooo_\n_oo____oo_\n___oooo___\n__________\n',
    'K': u'oo____oo_\noo___oo__\noo__oo___\noooooo___\noo___oo__\noo____oo_\n_________\n',
    'O': u'___oooo____\n_oo____oo__\noo______oo_\noo______oo_\n_oo____oo__\n___oooo____\n___________\n',
    'S': u'_ooooo__\noo___oo_\n_oo_____\n___oo___\noo___oo_\n_ooooo__\n________\n',
    'W': u'oo____oo____oo_\noo____oo____oo_\noo____oo____oo_\n_oo__oooo__oo__\n__oooo__oooo___\n___oo____oo____\n_______________\n',
    '[': u'ooo_\noo__\noo__\noo__\noo__\noo__\nooo_\n',
    '_': u'________\n________\n________\n________\n________\noooooooo\n________\n',
    'c': u'________\n_ooooo__\noo___oo_\noo______\noo______\n_ooooo__\n________\n',
    'g': u'________\n_oooo___\noo__oo__\noo___o__\n_oooooo_\no____oo_\n_ooooo__\n',
    'k': u'oo_____\noo___o_\noo__o__\noooo___\noo__o__\noo___o_\n_______\n',
    'o': u'________\n_ooooo__\noo___oo_\noo___oo_\noo___oo_\n_ooooo__\n________\n',
    's': u'_______\n_oooo__\noo___o_\n__oo___\no___oo_\n_oooo__\n_______\n',
    'w': u'___________\noo_______o_\noo__oo___o_\noo__oo___o_\n_oo_oo__o__\n__oo__oo___\n___________\n',
    '{': u'___oo_\n_oo___\n_o____\noo____\n_o____\n_oo___\n___oo_\n',
    '"': u'o_o_\no_o_\no_o_\n____\n____\n____\n____\n',
    '&': u'___oo_____\n__oo_o____\n___oo_____\n_oo_oo____\noo___oo_o_\noo___ooo__\n_oooo__oo_\n',
    '*': u'________\no__o__o_\n_o_o_o__\n__ooo___\n_o_o_o__\no__o__o_\n________\n',
    '.': u'___\n___\n___\n___\noo_\noo_\n___\n',
    '2': u'__ooooo__\noo____oo_\n______oo_\n____ooo__\n__ooo____\noooooooo_\n_________\n',
    '6': u'_oooooo__\noo_______\nooooooo__\noo____oo_\noo____oo_\n_oooooo__\n_________\n',
    ':': u'___\noo_\noo_\n___\noo_\noo_\n___\n',
    '>': u'oo____\n_oo___\n__oo__\n___oo_\n__oo__\n_oo___\noo____\n',
    'B': u'ooooooo__\noo____oo_\noooooooo_\noo____oo_\noo____oo_\nooooooo__\n_________\n',
    'F': u'ooooooo_\noo______\noooo____\noo______\noo______\noo______\n________\n',
    'J': u'_____ooo_\n______oo_\n______oo_\noo____oo_\noo____oo_\n_ooooo___\n_________\n',
    'N': u'ooo____oo_\noooo___oo_\noo_oo__oo_\noo__oo_oo_\noo___oooo_\noo____ooo_\n__________\n',
    'R': u'ooooooo___\noo____oo__\noo____oo__\nooooooo___\noo____oo__\noo_____oo_\n__________\n',
    'V': u'oo____oo_\noo____oo_\noo____oo_\n_oo__oo__\n__oooo___\n___oo____\n_________\n',
    'Z': u'ooooooo_\n_____oo_\n____oo__\n___o____\n_oo_____\nooooooo_\n________\n',
    '^': u'__ooo___\n_oo_oo__\noo___oo_\n________\n________\n________\n________\n',
    'b': u'oo______\noooooo__\noo___oo_\noo___oo_\noo___oo_\noooooo__\n________\n',
    'f': u'__oooo_\n_oo____\nooooo__\noo_____\noo_____\noo_____\n_______\n',
    'j': u'_____oo_\n________\n_____oo_\n_____oo_\noo___oo_\n_oo__oo_\n__oooo__\n',
    'n': u'________\noo_ooo__\nooo___o_\noo____o_\noo____o_\noo____o_\n________\n',
    'r': u'________\noo_ooo__\nooo___o_\noo______\noo______\noo______\n________\n',
    'v': u'________\noo____o_\noo____o_\noo___o__\n_oo_o___\n__oo____\n________\n',
    'z': u'_______\noooooo_\n_____o_\n___oo__\n_oo____\noooooo_\n_______\n',
    '~': u'___ooo____\n_oo__oo_o_\noo____oo__\n__________\n__________\n__________\n__________\n',
    '!': u'oo_\noo_\noo_\noo_\n___\noo_\noo_\n',
    '%': u'_o____oo_\no_o__oo__\n_o__oo___\n___oo____\n__oo__o__\n_oo__o_o_\noo____o__\n',
    ')': u'oo____\n__oo__\n___oo_\n___oo_\n__oo__\noo____\n______\n',
    '-': u'______\n______\n______\nooooo_\n______\n______\n______\n',
    '1': u'___oo__\n_oooo__\n___oo__\n___oo__\n___oo__\n_ooooo_\n_______\n',
    '5': u'ooooooo__\noo_______\nooooooo__\n______oo_\noo____oo_\n_oooooo__\n_________\n',
    '9': u'_oooooo__\noo____oo_\noo____oo_\n_ooooooo_\no_____oo_\n_oooooo__\n_________\n',
    '=': u'_______\n_______\noooooo_\n_______\noooooo_\n_______\n_______\n',
    'A': u'___ooo____\n_oo___oo__\noo_____oo_\nooooooooo_\noo_____oo_\noo_____oo_\n__________\n',
    'E': u'ooooooo_\noo______\noooo____\noo______\noo______\nooooooo_\n________\n',
    'I': u'oooo_\n_oo__\n_oo__\n_oo__\n_oo__\noooo_\n_____\n',
    'M': u'ooo_____ooo_\noooo___oooo_\noo_oo_oo_oo_\noo__ooo__oo_\noo_______oo_\noo_______oo_\n____________\n',
    'Q': u'___oooo____\n_oo____oo__\noo______oo_\noo___o__oo_\n_oo___ooo__\n___oooo_o__\n_________oo\n',
    'U': u'oo______oo_\noo______oo_\noo______oo_\noo______oo_\n_oo____oo__\n___oooo____\n___________\n',
    'Y': u'oo____oo_\noo____oo_\n_oo__oo__\n___oo____\n___oo____\n___oo____\n_________\n',
    ']': u'ooo_\n_oo_\n_oo_\n_oo_\n_oo_\n_oo_\nooo_\n',
    'a': u'________\n_ooooo__\noo___oo_\noo___oo_\noo___oo_\n_oooo_o_\n________\n',
    'e': u'________\n_ooooo__\noo____o_\nooooooo_\noo______\n_ooooo__\n________\n',
    'i': u'_oo__\n_____\n_oo__\n_oo__\n_oo__\noooo_\n_____\n',
    'm': u'__________\noo_oo_oo__\nooo_oo__o_\noo__oo__o_\noo__oo__o_\noo______o_\n__________\n',
    'q': u'__________\n_ooooo____\noo___o____\noo___oo___\noo___oo___\n__ooooo_o_\n_____oooo_\n',
    'u': u'________\noo____o_\noo____o_\noo____o_\nooo___o_\noo_ooo__\n________\n',
    'y': u'________\n_o___oo_\n_o___oo_\n_o___oo_\n__ooooo_\no____oo_\n_ooooo__\n',
    '}': u'oo____\n__oo__\n___o__\n___oo_\n___o__\n__oo__\noo____\n'}

puzzle_dic = {
    '!': u'     _    \n   _( )__ \n _|     _|\n(_ ! _ (_ \n  |_( )__|\n',
    ' ': u'     _    \n   _( )__ \n _|     _|\n(_   _ (_ \n  |_( )__|\n',
    '#': u'',
    '"': u'     _    \n   _( )__ \n _|     _|\n(_ " _ (_ \n  |_( )__|\n',
    '%': u'%\n \n \n \n \n',
    '$': u' \n \n \n \n \n',
    "'": u"'\n \n \n \n \n",
    '&': u'&\n \n \n \n \n',
    ')': u')\n \n \n \n \n',
    '(': u'(\n \n \n \n \n',
    '+': u'     _    \n   _( )__ \n _|     _|\n(_ + _ (_ \n  |_( )__|\n',
    '*': u'*\n \n \n \n \n',
    '-': u'     _    \n   _( )__ \n _|     _|\n(_ - _ (_ \n  |_( )__|\n',
    ',': u',\n \n \n \n \n',
    '/': u'/\n \n \n \n \n',
    '.': u'.\n \n \n \n \n',
    '1': u'     _    \n   _( )__ \n _|     _|\n(_ 1 _ (_ \n  |_( )__|\n',
    '0': u'     _    \n   _( )__ \n _|     _|\n(_ 0 _ (_ \n  |_( )__|\n',
    '3': u'     _    \n   _( )__ \n _|     _|\n(_ 3 _ (_ \n  |_( )__|\n',
    '2': u'     _    \n   _( )__ \n _|     _|\n(_ 2 _ (_ \n  |_( )__|\n',
    '5': u'     _    \n   _( )__ \n _|     _|\n(_ 5 _ (_ \n  |_( )__|\n',
    '4': u'     _    \n   _( )__ \n _|     _|\n(_ 4 _ (_ \n  |_( )__|\n',
    '7': u'     _    \n   _( )__ \n _|     _|\n(_ 7 _ (_ \n  |_( )__|\n',
    '6': u'     _    \n   _( )__ \n _|     _|\n(_ 6 _ (_ \n  |_( )__|\n',
    '9': u'     _    \n   _( )__ \n _|     _|\n(_ 9 _ (_ \n  |_( )__|\n',
    '8': u'     _    \n   _( )__ \n _|     _|\n(_ 8 _ (_ \n  |_( )__|\n',
    ';': u'     _    \n   _( )__ \n _|     _|\n(_ ; _ (_ \n  |_( )__|\n',
    ':': u'     _    \n   _( )__ \n _|     _|\n(_ : _ (_ \n  |_( )__|\n',
    '=': u'     _    \n   _( )__ \n _|     _|\n(_ = _ (_ \n  |_( )__|\n',
    '<': u'<\n \n \n \n \n',
    '?': u'     _    \n   _( )__ \n _|     _|\n(_ ? _ (_ \n  |_( )__|\n',
    '>': u'>\n \n \n \n \n',
    '@': u'@\n \n \n \n \n',
    '[': u'[\n \n \n \n \n',
    ']': u']\n \n \n \n \n',
    '\\': u'\\\n \n \n \n \n',
    '_': u'     _    \n   _( )__ \n _|     _|\n(_ _ _ (_ \n  |_( )__|\n',
    '^': u'     _    \n   _( )__ \n _|     _|\n(_ ^ _ (_ \n  |_( )__|\n',
    'a': u'     _    \n   _( )__ \n _|     _|\n(_ A _ (_ \n  |_( )__|\n',
    '`': u'`\n \n \n \n \n',
    'c': u'     _    \n   _( )__ \n _|     _|\n(_ C _ (_ \n  |_( )__|\n',
    'b': u'     _    \n   _( )__ \n _|     _|\n(_ B _ (_ \n  |_( )__|\n',
    'e': u'     _    \n   _( )__ \n _|     _|\n(_ E _ (_ \n  |_( )__|\n',
    'd': u'     _    \n   _( )__ \n _|     _|\n(_ D _ (_ \n  |_( )__|\n',
    'g': u'     _    \n   _( )__ \n _|     _|\n(_ G _ (_ \n  |_( )__|\n',
    'f': u'     _    \n   _( )__ \n _|     _|\n(_ F _ (_ \n  |_( )__|\n',
    'i': u'     _    \n   _( )__ \n _|     _|\n(_ I _ (_ \n  |_( )__|\n',
    'h': u'     _    \n   _( )__ \n _|     _|\n(_ H _ (_ \n  |_( )__|\n',
    'k': u'     _    \n   _( )__ \n _|     _|\n(_ K _ (_ \n  |_( )__|\n',
    'j': u'     _    \n   _( )__ \n _|     _|\n(_ J _ (_ \n  |_( )__|\n',
    'm': u'     _    \n   _( )__ \n _|     _|\n(_ M _ (_ \n  |_( )__|\n',
    'l': u'     _    \n   _( )__ \n _|     _|\n(_ L _ (_ \n  |_( )__|\n',
    'o': u'     _    \n   _( )__ \n _|     _|\n(_ O _ (_ \n  |_( )__|\n',
    'n': u'     _    \n   _( )__ \n _|     _|\n(_ N _ (_ \n  |_( )__|\n',
    'q': u'     _    \n   _( )__ \n _|     _|\n(_ Q _ (_ \n  |_( )__|\n',
    'p': u'     _    \n   _( )__ \n _|     _|\n(_ P _ (_ \n  |_( )__|\n',
    's': u'     _    \n   _( )__ \n _|     _|\n(_ S _ (_ \n  |_( )__|\n',
    'r': u'     _    \n   _( )__ \n _|     _|\n(_ R _ (_ \n  |_( )__|\n',
    'u': u'     _    \n   _( )__ \n _|     _|\n(_ U _ (_ \n  |_( )__|\n',
    't': u'     _    \n   _( )__ \n _|     _|\n(_ T _ (_ \n  |_( )__|\n',
    'w': u'     _    \n   _( )__ \n _|     _|\n(_ W _ (_ \n  |_( )__|\n',
    'v': u'     _    \n   _( )__ \n _|     _|\n(_ V _ (_ \n  |_( )__|\n',
    'y': u'     _    \n   _( )__ \n _|     _|\n(_ Y _ (_ \n  |_( )__|\n',
    'x': u'     _    \n   _( )__ \n _|     _|\n(_ X _ (_ \n  |_( )__|\n',
    '{': u'{\n \n \n \n \n',
    'z': u'     _    \n   _( )__ \n _|     _|\n(_ Z _ (_ \n  |_( )__|\n',
    '}': u'}\n \n \n \n \n',
    '|': u'|\n \n \n \n \n',
    '~': u'~\n \n \n \n \n'}

rammstein_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '$': u' \n \n \n \n \n \n \n',
    '(': u'  __  \n | _| \n| |   \n| |   \n| |_  \n |__| \n      \n',
    ',': u'    \n    \n    \n __ \n/_/ \n    \n    \n',
    '0': u'        \n _____  \n/     | \n|  /  | \n|_____/ \n        \n        \n',
    '4': u"         \n __   _  \n|  | | | \n|  |_| | \n'----__| \n         \n         \n",
    '8': u'        \n _____  \n<  -  > \n/  _  \\ \n\\_____/ \n        \n        \n',
    '<': u'     \n __  \n/ /  \n\\ \\  \n \\_\\ \n     \n     \n',
    '@': u'@\n \n \n \n \n \n \n',
    'D': u'    _____     \n __|__   |__  \n|     \\     | \n|      \\    | \n|______/  __| \n   |_____|    \n              \n',
    'H': u'    _____     \n __|  _  |__  \n|  |_| |    | \n|   _  |    | \n|__| |_|  __| \n   |_____|    \n              \n',
    'L': u'    _____     \n __|_    |__  \n|    |      | \n|    |_     | \n|______|  __| \n   |_____|    \n              \n',
    'P': u'    _____     \n __|__   |__  \n|     |     | \n|    _|     | \n|___|     __| \n   |_____|    \n              \n',
    'T': u'     _____     \n ___|__   |__  \n|_    _|     | \n |    |      | \n |____|    __| \n    |_____|    \n               \n',
    'X': u'    _____     \n __|__   |__  \n \\ ` /      | \n /   \\      | \n/__/\\_\\   __| \n   |_____|    \n              \n',
    '\\': u' _    \n| \\   \n \\ \\  \n  \\_\\ \n      \n      \n      \n',
    '`': u'__  \n\\_| \n    \n    \n    \n    \n    \n',
    'd': u'         \n _____   \n|     \\  \n|      \\ \n|______/ \n         \n         \n',
    'h': u'         \n __   _  \n|  |_| | \n|   _  | \n|__| |_| \n         \n         \n',
    'l': u'         \n ____    \n|    |   \n|    |_  \n|______| \n         \n         \n',
    'p': u'        \n _____  \n|     | \n|    _| \n|___|   \n        \n        \n',
    't': u'         \n   __    \n _|  |_  \n|_    _| \n  |__|   \n         \n         \n',
    'x': u'        \n __ __  \n \\ ` /  \n /   \\  \n/__/\\_\\ \n        \n        \n',
    '|': u' _  \n| | \n| | \n| | \n| | \n|_| \n    \n',
    '#': u'',
    "'": u' _  \n|_| \n    \n    \n    \n    \n    \n',
    '+': u'      \n  _   \n | |  \n|   | \n |_|  \n      \n      \n',
    '/': u'   _  \n  / | \n / /  \n|_/   \n      \n      \n      \n',
    '3': u'         \n ______  \n|___   | \n|___   | \n|______| \n         \n         \n',
    '7': u'         \n ______  \n|___   | \n  /   /  \n |___|   \n         \n         \n',
    ';': u'    \n _  \n|_| \n __ \n/_/ \n    \n    \n',
    '?': u'?\n \n \n \n \n \n \n',
    'C': u'    _____     \n __|___  |__  \n|   ___|    | \n|   |__     | \n|______|  __| \n   |_____|    \n              \n',
    'G': u'    _____     \n __|___  |__  \n|   ___|    | \n|   |  |    | \n|______|  __| \n   |_____|    \n              \n',
    'K': u'    _____     \n __| __  |__  \n|  |/ /     | \n|     \\     | \n|__|\\__\\  __| \n   |_____|    \n              \n',
    'O': u'    _____     \n __|__   |__  \n/     \\     | \n|     |     | \n\\_____/   __| \n   |_____|    \n              \n',
    'S': u'    _____     \n __|___  |__  \n|   ___|    | \n `-.`-.     | \n|______|  __| \n   |_____|    \n              \n',
    'W': u'     _____     \n ___|__  _|__  \n|  \\/  \\|  | | \n|     /\\   | | \n|____/  \\__|_| \n    |_____|    \n               \n',
    '[': u' __  \n| _| \n| |  \n| |  \n| |  \n|__| \n     \n',
    '_': u'      \n      \n      \n      \n ___  \n|___| \n      \n',
    'c': u'         \n ______  \n|   ___| \n|   |__  \n|______| \n         \n         \n',
    'g': u'         \n ______  \n|   ___| \n|   |  | \n|______| \n         \n         \n',
    'k': u'         \n __  __  \n|  |/ /  \n|     \\  \n|__|\\__\\ \n         \n         \n',
    'o': u'        \n _____  \n/     \\ \n|     | \n\\_____/ \n        \n        \n',
    's': u'         \n ______  \n|   ___| \n `-.`-.  \n|______| \n         \n         \n',
    'w': u'             \n __  __  __  \n|  \\/  \\|  | \n|     /\\   | \n|____/  \\__| \n             \n             \n',
    '{': u'  __  \n | _| \n | |  \n< <   \n | |  \n |__| \n      \n',
    '"': u'____  \n\\_\\_| \n      \n      \n      \n      \n      \n',
    '&': u'&\n \n \n \n \n \n \n',
    '*': u'*\n \n \n \n \n \n \n',
    '.': u'    \n    \n    \n _  \n|_| \n    \n    \n',
    '2': u'         \n ______  \n|____  | \n|    --| \n|______| \n         \n         \n',
    '6': u'         \n  ____   \n /   /_  \n|   _  | \n|______| \n         \n         \n',
    ':': u'    \n _  \n|_| \n _  \n|_| \n    \n    \n',
    '>': u'     \n__   \n\\ \\  \n \\ \\ \n /_/ \n     \n     \n',
    'B': u'    _____     \n __|___  |__  \n|      >    | \n|     <     | \n|______>  __| \n   |_____|    \n              \n',
    'F': u'    _____     \n __|___  |__  \n|   ___|    | \n|   ___|    | \n|___|     __| \n   |_____|    \n              \n',
    'J': u'      _____    \n   __|_    |__ \n  |    |      |\n _|    |      |\n|______|    __|\n     |_____|   \n               \n',
    'N': u'     _____     \n ___|   _ |__  \n|    \\ | |   | \n|     \\| |   | \n|__/\\____| __| \n    |_____|    \n               \n',
    'R': u'    _____     \n __|__   |__  \n|     |     | \n|     \\     | \n|__|\\__\\  __| \n   |_____|    \n              \n',
    'V': u'    _____     \n __|   _ |__  \n\\  \\  //    | \n|\\  \\//     | \n|_\\__/    __| \n   |_____|    \n              \n',
    'Z': u'    _____     \n __|___  |__  \n|___   |    | \n .-`.-`     | \n|______|  __| \n   |_____|    \n              \n',
    '^': u'^\n \n \n \n \n \n \n',
    'b': u'         \n ______  \n|      > \n|     <  \n|______> \n         \n         \n',
    'f': u'         \n ______  \n|   ___| \n|   ___| \n|___|    \n         \n         \n',
    'j': u'         \n   ____  \n  |    | \n _|    | \n|______| \n         \n         \n',
    'n': u'           \n ____   _  \n|    \\ | | \n|     \\| | \n|__/\\____| \n           \n           \n',
    'r': u'         \n _____   \n|     |  \n|     \\  \n|__|\\__\\ \n         \n         \n',
    'v': u'         \n __    _ \n\\  \\  // \n \\  \\//  \n  \\__/   \n         \n         \n',
    'z': u'         \n ______  \n|___   | \n .-`.-`  \n|______| \n         \n         \n',
    '~': u'~\n \n \n \n \n \n \n',
    '!': u'      \n ___  \n|   | \n|___| \n|___| \n      \n      \n',
    '%': u'%\n \n \n \n \n \n \n',
    ')': u' __   \n|_ |  \n  | | \n  | | \n _| | \n|__|  \n      \n',
    '-': u'      \n      \n ___  \n|___| \n      \n      \n      \n',
    '1': u'        \n _____  \n|_    | \n |    | \n |____| \n        \n        \n',
    '5': u'         \n ______  \n|  ____| \n|___   \\ \n|______/ \n         \n         \n',
    '9': u'         \n ______  \n|   _  | \n|____  | \n    |__| \n         \n         \n',
    '=': u'      \n ___  \n|___| \n ___  \n|___| \n      \n      \n',
    'A': u'    _____     \n __|_    |__  \n|    \\      | \n|     \\     | \n|__|\\__\\  __| \n   |_____|    \n              \n',
    'E': u'    _____     \n __|___  |__  \n|   ___|    | \n|   ___|    | \n|______|  __| \n   |_____|    \n              \n',
    'I': u'    _____     \n __|_    |__  \n|    |      | \n|    |      | \n|____|    __| \n   |_____|    \n              \n',
    'M': u'     _____     \n ___|    _|__  \n|    \\  /  | | \n|     \\/   | | \n|__/\\__/|__|_| \n    |_____|    \n               \n',
    'Q': u'    _____     \n __|__   |__  \n/     \\     | \n|     |     | \n\\___/\\_\\  __| \n   |_____|    \n              \n',
    'U': u'    _____     \n __|  _  |__  \n|  | | |    | \n|  |_| |    | \n|______|  __| \n   |_____|    \n              \n',
    'Y': u'    _____     \n___|  _  |__  \n\\ \\  //     | \n|\\ \\//      | \n|/__/     __| \n   |_____|    \n              \n',
    ']': u' __  \n|_ | \n | | \n | | \n | | \n|__| \n     \n',
    'a': u'         \n ____    \n|    \\   \n|     \\  \n|__|\\__\\ \n         \n         \n',
    'e': u'         \n ______  \n|   ___| \n|   ___| \n|______| \n         \n         \n',
    'i': u'       \n ____  \n|    | \n|    | \n|____| \n       \n       \n',
    'm': u'             \n ____    __  \n|    \\  /  | \n|     \\/   | \n|__/\\__/|__| \n             \n             \n',
    'q': u'         \n _____   \n/     \\  \n|     |  \n\\___/\\_\\ \n         \n         \n',
    'u': u'         \n __   _  \n|  | | | \n|  |_| | \n|______| \n         \n         \n',
    'y': u'        \n__    _ \n\\ \\  // \n \\ \\//  \n /__/   \n        \n        \n',
    '}': u' __   \n|_ |  \n | |  \n  > > \n | |  \n|__|  \n      \n'}

red_phoenix_dic = {
    ' ': u'    \n    \n    \n    \n    \n    \n    \n',
    '$': u'  ____/\\__ \n /   / /_/ \n \\__/ / \\  \n / / /   \\ \n/_/ /__  / \n  \\/   \\/  \n           \n',
    '(': u'   ___ \n  /  / \n /  /  \n(  (   \n \\  \\  \n  \\__\\ \n       \n',
    ',': u'    \n    \n    \n    \n /\\ \n )/ \n    \n',
    '0': u'_______    \n\\   _  \\   \n/  /_\\  \\  \n\\  \\_/   \\ \n \\_____  / \n       \\/  \n           \n',
    '4': u'   _____   \n  /  |  |  \n /   |  |_ \n/    ^   / \n\\____   |  \n     |__|  \n           \n',
    '8': u'  ______   \n /  __  \\  \n >      <  \n/   --   \\ \n\\______  / \n       \\/  \n           \n',
    '<': u'  __ \n / / \n/ /  \n\\ \\  \n \\_\\ \n     \n     \n',
    '@': u'   _____   \n  / ___ \\  \n / / ._\\ \\ \n<  \\_____/ \n \\_____\\   \n           \n           \n',
    'D': u'________    \n\\______ \\   \n |    |  \\  \n |    `   \\ \n/_______  / \n        \\/  \n            \n',
    'H': u'  ___ ___   \n /   |   \\  \n/    ~    \\ \n\\    Y    / \n \\___|_  /  \n       \\/   \n            \n',
    'L': u'.____      \n|    |     \n|    |     \n|    |___  \n|_______ \\ \n        \\/ \n           \n',
    'P': u'__________  \n\\______   \\ \n |     ___/ \n |    |     \n |____|     \n            \n            \n',
    'T': u'___________ \n\\__    ___/ \n  |    |    \n  |    |    \n  |____|    \n            \n            \n',
    'X': u'____  ___ \n\\   \\/  / \n \\     /  \n /     \\  \n/___/\\  \\ \n      \\_/ \n          \n',
    '\\': u'/\\     \n\\ \\    \n \\ \\   \n  \\ \\  \n   \\ \\ \n    \\/ \n       \n',
    '`': u'/\\ \n\\( \n   \n   \n   \n   \n   \n',
    'd': u'    .___ \n  __| _/ \n / __ |  \n/ /_/ |  \n\\____ |  \n     \\/  \n         \n',
    'h': u'.__      \n|  |__   \n|  |  \\  \n|   Y  \\ \n|___|  / \n     \\/  \n         \n',
    'l': u'.__    \n|  |   \n|  |   \n|  |__ \n|____/ \n       \n       \n',
    'p': u'         \n______   \n\\____ \\  \n|  |_> > \n|   __/  \n|__|     \n         \n',
    't': u'  __    \n_/  |_  \n\\   __\\ \n |  |   \n |__|   \n        \n        \n',
    'x': u'         \n___  ___ \n\\  \\/  / \n >    <  \n/__/\\_ \\ \n      \\/ \n         \n',
    '|': u'._. \n| | \n|_| \n|-| \n| | \n|_| \n    \n',
    '#': u'   _  _    \n__| || |__ \n\\   __   / \n |  ||  |  \n/_  ~~  _\\ \n  |_||_|   \n           \n',
    "'": u'/\\ \n\\( \n   \n   \n   \n   \n   \n',
    '+': u'          \n  .__     \n__|  |___ \n__    __/ \n  |__|    \n          \n          \n',
    '/': u'    /\\ \n   / / \n  / /  \n / /   \n/ /    \n\\/     \n       \n',
    '3': u'________   \n\\_____  \\  \n  _(__  <  \n /       \\ \n/______  / \n       \\/  \n           \n',
    '7': u'_________  \n\\______  \\ \n    /    / \n   /    /  \n  /____/   \n           \n           \n',
    ';': u'   \n/\\ \n\\/ \n/\\ \n)/ \n   \n   \n',
    '?': u'_________  \n\\_____   \\ \n   /   __/ \n  |   |    \n  |___|    \n  <___>    \n           \n',
    'C': u'_________   \n\\_   ___ \\  \n/    \\  \\/  \n\\     \\____ \n \\______  / \n        \\/  \n            \n',
    'G': u'  ________  \n /  _____/  \n/   \\  ___  \n\\    \\_\\  \\ \n \\______  / \n        \\/  \n            \n',
    'K': u' ____  __. \n|    |/ _| \n|      <   \n|    |  \\  \n|____|__ \\ \n        \\/ \n           \n',
    'O': u'________    \n\\_____  \\   \n /   |   \\  \n/    |    \\ \n\\_______  / \n        \\/  \n            \n',
    'S': u'  _________ \n /   _____/ \n \\_____  \\  \n /        \\ \n/_______  / \n        \\/  \n            \n',
    'W': u' __      __  \n/  \\    /  \\ \n\\   \\/\\/   / \n \\        /  \n  \\__/\\  /   \n       \\/    \n             \n',
    '[': u'.____  \n|   _| \n|  |   \n|  |   \n|  |_  \n|____| \n       \n',
    '_': u'        \n        \n        \n        \n ______ \n/_____/ \n        \n',
    'c': u'         \n  ____   \n_/ ___\\  \n\\  \\___  \n \\___  > \n     \\/  \n         \n',
    'g': u'   ____   \n  / ___\\  \n / /_/  > \n \\___  /  \n/_____/   \n          \n          \n',
    'k': u' __     \n|  | __ \n|  |/ / \n|    <  \n|__|_ \\ \n     \\/ \n        \n',
    'o': u'         \n  ____   \n /  _ \\  \n(  <_> ) \n \\____/  \n         \n         \n',
    's': u'         \n  ______ \n /  ___/ \n \\___ \\  \n/____  > \n     \\/  \n         \n',
    'w': u'          \n__  _  __ \n\\ \\/ \\/ / \n \\     /  \n  \\/\\_/   \n          \n          \n',
    '{': u' ___ \n/ /  \n\\ \\  \n< <  \n/ /  \n\\_\\_ \n     \n',
    '"': u'/\\/\\ \n)/)/ \n     \n     \n     \n     \n     \n',
    '&': u'   ____    \n  /  _ \\   \n  >  _ </\\ \n /  <_\\ \\/ \n \\_____\\ \\ \n        \\/ \n           \n',
    '*': u'           \n  /\\|\\/\\   \n _)    (__ \n \\_     _/ \n   )    \\  \n   \\/\\|\\/  \n           \n',
    '.': u'   \n   \n   \n   \n/\\ \n\\/ \n   \n',
    '2': u'________   \n\\_____  \\  \n /  ____/  \n/       \\  \n\\_______ \\ \n        \\/ \n           \n',
    '6': u'  ________ \n /  _____/ \n/   __  \\  \n\\  |__\\  \\ \n \\_____  / \n       \\/  \n           \n',
    ':': u'   \n/\\ \n\\/ \n/\\ \n\\/ \n   \n   \n',
    '>': u'__   \n\\ \\  \n \\ \\ \n / / \n/_/  \n     \n     \n',
    'B': u'__________  \n\\______   \\ \n |    |  _/ \n |    |   \\ \n |______  / \n        \\/  \n            \n',
    'F': u'___________ \n\\_   _____/ \n |    __)   \n |     \\    \n \\___  /    \n     \\/     \n            \n',
    'J': u'     ____. \n    |    | \n    |    | \n/\\__|    | \n\\________| \n           \n           \n',
    'N': u' _______    \n \\      \\   \n /   |   \\  \n/    |    \\ \n\\____|__  / \n        \\/  \n            \n',
    'R': u'__________  \n\\______   \\ \n |       _/ \n |    |   \\ \n |____|_  / \n        \\/  \n            \n',
    'V': u'____   ____ \n\\   \\ /   / \n \\   Y   /  \n  \\     /   \n   \\___/    \n            \n            \n',
    'Z': u'__________ \n\\____    / \n  /     /  \n /     /_  \n/_______ \\ \n        \\/ \n           \n',
    '^': u' /\\  \n/  \\ \n\\/\\/ \n     \n     \n     \n     \n',
    'b': u'___.     \n\\_ |__   \n | __ \\  \n | \\_\\ \\ \n |___  / \n     \\/  \n         \n',
    'f': u'  _____  \n_/ ____\\ \n\\   __\\  \n |  |    \n |__|    \n         \n         \n',
    'j': u'     __  \n    |__| \n    |  | \n    |  | \n/\\__|  | \n\\______| \n         \n',
    'n': u'         \n  ____   \n /    \\  \n|   |  \\ \n|___|  / \n     \\/  \n         \n',
    'r': u'         \n_______  \n\\_  __ \\ \n |  | \\/ \n |__|    \n         \n         \n',
    'v': u'        \n___  __ \n\\  \\/ / \n \\   /  \n  \\_/   \n        \n        \n',
    'z': u'         \n________ \n\\___   / \n /    /  \n/_____ \\ \n      \\/ \n         \n',
    '~': u' ___     \n/ _ \\_/\\ \n\\/ \\___/ \n         \n         \n         \n         \n',
    '!': u'._. \n| | \n| | \n \\| \n __ \n \\/ \n    \n',
    '%': u' _   /\\  \n/ \\ / /  \n\\_// /_  \n  / // \\ \n / / \\_/ \n \\/      \n         \n',
    ')': u' ___    \n \\  \\   \n  \\  \\  \n   )  ) \n  /  /  \n /__/   \n        \n',
    '-': u'         \n         \n  ______ \n /_____/ \n         \n         \n         \n',
    '1': u' ____  \n/_   | \n |   | \n |   | \n |___| \n       \n       \n',
    '5': u' .________ \n |   ____/ \n |____  \\  \n /       \\ \n/______  / \n       \\/  \n           \n',
    '9': u' ________  \n/   __   \\ \n\\____    / \n   /    /  \n  /____/   \n           \n           \n',
    '=': u'        \n ______ \n/_____/ \n/_____/ \n        \n        \n        \n',
    'A': u'   _____    \n  /  _  \\   \n /  /_\\  \\  \n/    |    \\ \n\\____|__  / \n        \\/  \n            \n',
    'E': u'___________ \n\\_   _____/ \n |    __)_  \n |        \\ \n/_______  / \n        \\/  \n            \n',
    'I': u'.___  \n|   | \n|   | \n|   | \n|___| \n      \n      \n',
    'M': u'   _____    \n  /     \\   \n /  \\ /  \\  \n/    Y    \\ \n\\____|__  / \n        \\/  \n            \n',
    'Q': u'________    \n\\_____  \\   \n /  / \\  \\  \n/   \\_/.  \\ \n\\_____\\ \\_/ \n       \\__> \n            \n',
    'U': u' ____ ___  \n|    |   \\ \n|    |   / \n|    |  /  \n|______/   \n           \n           \n',
    'Y': u'_____.___. \n\\__  |   | \n /   |   | \n \\____   | \n / ______| \n \\/        \n           \n',
    ']': u' ____. \n|_   | \n  |  | \n  |  | \n _|  | \n|____| \n       \n',
    'a': u'         \n_____    \n\\__  \\   \n / __ \\_ \n(____  / \n     \\/  \n         \n',
    'e': u'         \n  ____   \n_/ __ \\  \n\\  ___/  \n \\___  > \n     \\/  \n         \n',
    'i': u'.__  \n|__| \n|  | \n|  | \n|__| \n     \n     \n',
    'm': u'          \n  _____   \n /     \\  \n|  Y Y  \\ \n|__|_|  / \n      \\/  \n          \n',
    'q': u'         \n  ______ \n / ____/ \n< <_|  | \n \\__   | \n    |__| \n         \n',
    'u': u'        \n __ __  \n|  |  \\ \n|  |  / \n|____/  \n        \n        \n',
    'y': u'         \n ___.__. \n<   |  | \n \\___  | \n / ____| \n \\/      \n         \n',
    '}': u'___  \n \\ \\ \n / / \n > > \n \\ \\ \n_/_/ \n     \n'}

runyc_dic = {
    ' ': u'     \n     \n  _  \n |_| \n     \n     \n',
    '$': u'',
    '(': u'',
    ',': u'',
    '0': u'',
    '4': u'',
    '8': u'',
    '<': u'',
    '@': u'',
    'D': u'|\\    /| \n| \\  / | \n|  \\/  | \n|  /\\  | \n| /  \\ | \n|/    \\| \n',
    'H': u'|    | \n|\\   | \n| \\  | \n|  \\ | \n|   \\| \n|    | \n',
    'L': u'|\\   \n| \\  \n|  \\ \n|    \n|    \n|    \n',
    'P': u'|\\  / \n| \\/  \n|     \n|     \n| /\\  \n|/  \\ \n',
    'T': u'  /|\\   \n / | \\  \n/  |  \\ \n   |    \n   |    \n   |    \n',
    'X': u'',
    '\\': u'',
    '`': u'',
    'd': u'      \n      \n      \n|\\ /| \n| X | \n|/ \\| \n',
    'h': u'    \n    \n    \n| | \n|\\| \n| | \n',
    'l': u'   \n   \n   \n|\\ \n|  \n|  \n',
    'p': u'    \n    \n    \n|\\/ \n|   \n|/\\ \n',
    't': u'    \n    \n    \n/|\\ \n |  \n |  \n',
    'x': u'',
    '|': u'',
    '#': u'',
    "'": u'',
    '+': u'',
    '/': u'',
    '3': u'',
    '7': u'',
    ';': u'',
    '?': u'',
    'C': u'|    \n|    \n|    \n|\\   \n| \\  \n|  \\ \n',
    'G': u'\\    / \n \\  /  \n  \\/   \n  /\\   \n /  \\  \n/    \\ \n',
    'K': u'  / \n /  \n/   \n\\   \n \\  \n  \\ \n',
    'O': u' /~\\  \n/   \\ \n\\   / \n \\ /  \n / \\  \n/   \\ \n',
    'S': u'  /   \n /    \n/____ \n    / \n   /  \n  /   \n',
    'W': u'|\\  \n| > \n|/  \n|   \n|   \n|   \n',
    '[': u'',
    '_': u'',
    'c': u'   \n   \n   \n|  \n|  \n|\\ \n',
    'g': u'    \n    \n    \n\\ / \n X  \n/ \\ \n',
    'k': u'   \n   \n   \n / \n<  \n \\ \n',
    'o': u'   \n   \n   \n/\\ \n\\/ \n/\\ \n',
    's': u'   \n   \n   \n/  \n-- \n / \n',
    'w': u'   \n   \n   \n|\\ \n|/ \n|  \n',
    '{': u'',
    '"': u'',
    '&': u'',
    '*': u'      \n__/\\__\n\\    /\n/_  _\\\n  \\/  \n      \n',
    '.': u' _ \n|_|\n _ \n|_|\n _ \n|_|\n',
    '2': u'',
    '6': u'',
    ':': u'   \n _ \n(_)\n   \n(_)\n   \n',
    '>': u'',
    'B': u'|~\\  \n|  > \n|_/  \n|~\\  \n|  > \n|_/  \n',
    'F': u'| / / \n|/ /  \n| /   \n|/    \n|     \n|     \n',
    'J': u' /     \n/      \n\\   \\  \n \\   \\ \n     / \n    /  \n',
    'N': u'  |   \n\\ |   \n \\|   \n  |\\  \n  | \\ \n  |   \n',
    'R': u'|~\\  \n|  \\ \n|  / \n|_/  \n| \\  \n|  \\ \n',
    'V': u'|\\    \n| \\   \n|  \\  \n|   | \n|   | \n|   | \n',
    'Z': u'',
    '^': u'',
    'b': u'   \n   \n   \n|\\ \n|< \n|/ \n',
    'f': u'    \n    \n    \n|// \n|/  \n|   \n',
    'j': u'    \n    \n    \n/   \n\\ \\ \n  / \n',
    'n': u'    \n    \n    \n |  \n`|  \n |` \n',
    'r': u'   \n   \n   \n|\\ \n|/ \n|\\ \n',
    'v': u'    \n    \n    \n|\\  \n| | \n| | \n',
    'z': u'',
    '~': u'',
    '!': u'',
    '%': u'',
    ')': u'',
    '-': u'',
    '1': u'',
    '5': u'',
    '9': u'',
    '=': u'',
    'A': u'|\\  \n| \\ \n|\\  \n| \\ \n|   \n|   \n',
    'E': u'|\\    /| \n| \\  / | \n|  \\/  | \n|      | \n|      | \n|      | \n',
    'I': u'| \n| \n| \n| \n| \n| \n',
    'M': u'|\\  /| \n| \\/ | \n| /\\ | \n|/  \\| \n|    | \n|    | \n',
    'Q': u'',
    'U': u'|\\    \n| \\   \n|  \\  \n|   | \n|   | \n|   | \n',
    'Y': u'|~~-__  \n|     | \n|_____| \n|  |  | \n|  |  | \n|  |  | \n',
    ']': u'',
    'a': u'   \n   \n   \n|\\ \n|\\ \n|  \n',
    'e': u'     \n     \n     \n|\\/| \n|  | \n|  | \n',
    'i': u'  \n  \n  \n| \n| \n| \n',
    'm': u'     \n     \n     \n|\\/| \n|/\\| \n|  | \n',
    'q': u'',
    'u': u'    \n    \n    \n|\\  \n| | \n| | \n',
    'y': u'    \n    \n    \n|~\\ \n|_| \n||| \n',
    '}': u''}


santaclara_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n',
    '$': u"  ,-/-\n (_/  \n  / ) \n-/-'  \n      \n      \n",
    '(': u'  _/\n /  \n/   \n/   \n    \n    \n',
    ',': u"  \n  \n  \no \n' \n  \n",
    '0': u'   __ \n  /  )\n /  / \n(__/  \n      \n      \n',
    '4': u"     \n /  /\n'--/ \n  /  \n     \n     \n",
    '8': u"  __ \n (  )\n ./' \n(__) \n     \n     \n",
    '<': u' /\n/ \n\\ \n \\\n  \n  \n',
    '@': u'     \n  _  \n /o\\ \n(____\n     \n     \n',
    'D': u'  ___ \n ( / \\\n  /  /\n(/\\_/ \n      \n      \n',
    'H': u' __   \n( /  /\n /--/ \n/  /_ \n      \n      \n',
    'L': u'  __  \n ( /  \n  /   \n(/___/\n      \n      \n',
    'P': u" _ __ \n( /  )\n /--' \n/     \n      \n      \n",
    'T': u' ______\n(  /   \n  /    \n_/     \n       \n       \n',
    'X': u"  _,  ,\n ( |,' \n   +   \n_,'|__ \n       \n       \n",
    '\\': u'\\   \n \\  \n  \\ \n   \\\n    \n    \n',
    '`': u' \no\n`\n \n \n \n',
    'd': u'     \n    /\n __/ \n(_/_ \n     \n     \n',
    'h': u'    \n  / \n /_ \n/ /_\n    \n    \n',
    'l': u'   _\n  //\n // \n(/_ \n    \n    \n',
    'p': u'      \n      \n  ,_  \n_/|_)_\n /|   \n(/    \n',
    't': u'    \n _/_\n /  \n(__ \n    \n    \n',
    'x': u'     \n     \n _., \n/ /\\_\n     \n     \n',
    '|': u'   /\n  / \n /  \n/   \n    \n    \n',
    '#': u'   / /\n -/-/-\n-/-/- \n/ /   \n      \n      \n',
    "'": u" \no\n'\n \n \n \n",
    '+': u'     \n   / \n--/--\n /   \n     \n     \n',
    '/': u'   /\n  / \n /  \n/   \n    \n    \n',
    '3': u'   __ \n     )\n   -/ \n___/  \n      \n      \n',
    '7': u'___\n  /\n-/-\n/  \n   \n   \n',
    ';': u"   \n   \n  o\n   \no  \n'  \n",
    '?': u'  __ \n  __)\n /   \no    \n     \n     \n',
    'C': u'   ,___\n  /   /\n /     \n(___/  \n       \n       \n',
    'G': u'   ,___\n  /   /\n /  __ \n(___/  \n       \n       \n',
    'K': u' __  ,\n( /,/ \n /<   \n/  \\_ \n      \n      \n',
    'O': u'   ___ \n  /  ()\n /   / \n(___/  \n       \n       \n',
    'S': u'  __,\n (   \n  `. \n(___)\n     \n     \n',
    'W': u' __    _\n( /   / \n / / /  \n(_/_/   \n        \n        \n',
    '[': u'   _\n  / \n /  \n/_  \n    \n    \n',
    '_': u'   \n   \n   \n   \n___\n   \n',
    'c': u'   \n   \n _,\n(__\n   \n   \n',
    'g': u'    \n    \n _, \n(_)_\n /| \n(/  \n',
    'k': u'    \n  / \n /< \n/ |_\n    \n    \n',
    'o': u'   \n   \n __\n(_)\n   \n   \n',
    's': u'    \n    \n (  \n/_)_\n    \n    \n',
    'w': u'      \n      \n , , ,\n(_(_/_\n      \n      \n',
    '{': u'  _/\n_/  \n/   \n/   \n    \n    \n',
    '"': u"   \no o\n' '\n   \n   \n   \n",
    '&': u' ()  \n /\\  \n(  X \n \\/ \\\n     \n     \n',
    '*': u'     \n \\ / \n--X--\n / \\ \n     \n     \n',
    '.': u' \n \n \no\n \n \n',
    '2': u"   __ \n     )\n .--' \n(__   \n      \n      \n",
    '6': u'    \n  / \n /_ \n(__)\n    \n    \n',
    ':': u'   \n   \n  o\n   \no  \n   \n',
    '>': u'\\ \n \\\n /\n/ \n  \n  \n',
    'B': u' _ __ \n( /  )\n /--< \n/___/ \n      \n      \n',
    'F': u' ______\n(  /   \n -/--  \n_/     \n       \n       \n',
    'J': u'    ___ \n   ( /  \n    /   \n  _/_   \n //     \n(/      \n',
    'N': u' _ __ \n( /  )\n /  / \n/  (_ \n      \n      \n',
    'R': u' _ __ \n( /  )\n /--< \n/   \\_\n      \n      \n',
    'V': u' _,   _\n( |  / \n  | /  \n  |/   \n       \n       \n',
    'Z': u'  __ \n /  )\n  -< \n  _/_\n //  \n(/   \n',
    '^': u'/\\\n  \n  \n  \n  \n  \n',
    'b': u'    \n  / \n /  \n/_) \n    \n    \n',
    'f': u'      \n    /)\n   // \n  //_ \n /)   \n(/    \n',
    'j': u'    \n   o\n  , \n_/|_\n /) \n(/  \n',
    'n': u'      \n      \n _ _  \n/ / /_\n      \n      \n',
    'r': u'    \n    \n _  \n/ (_\n    \n    \n',
    'v': u'      \n      \n _  ,_\n/ |/  \n      \n      \n',
    'z': u'    \n    \n __,\n/_/_\n(/  \n    \n',
    '~': u' _   \n/ \\_/\n     \n     \n     \n     \n',
    '!': u"    \n   /\n  / \n '  \no   \n    \n",
    '%': u'() /\n  / \n /  \n/ ()\n    \n    \n',
    ')': u'   /\n   /\n _/ \n/   \n    \n    \n',
    '-': u'   \n   \n   \n---\n   \n   \n',
    '1': u'  _\n  /\n / \n/  \n   \n   \n',
    '5': u"  ___\n /   \n'--. \n___) \n     \n     \n",
    '9': u' __ \n(__)\n  / \n /  \n    \n    \n',
    '=': u'   \n   \n---\n---\n   \n   \n',
    'A': u'    _, \n   / | \n  /--| \n_/   |_\n       \n       \n',
    'E': u' ______\n(  /   \n  /--  \n(/____/\n       \n       \n',
    'I': u'  ___ \n ( /  \n  /   \n_/_   \n      \n      \n',
    'M': u' _ _ _ \n( / ) )\n / / / \n/ / (_ \n       \n       \n',
    'Q': u'   ___ \n  /   )\n /_  / \n(__\\/  \n    \\_ \n       \n',
    'U': u' __   ,\n( /  / \n /  /  \n(_,/_  \n       \n       \n',
    'Y': u' __   _\n( /  / \n (__/  \n  _/_  \n //    \n(/     \n',
    ']': u'   _\n   /\n  / \n_/  \n    \n    \n',
    'a': u'     \n     \n __, \n(_/(_\n     \n     \n',
    'e': u'   \n   \n _ \n(/_\n   \n   \n',
    'i': u'  \n o\n, \n(_\n  \n  \n',
    'm': u'        \n        \n _ _ _  \n/ / / /_\n        \n        \n',
    'q': u'    \n    \n _, \n(_/_\n /| \n(/  \n',
    'u': u'    \n    \n , ,\n(_/_\n    \n    \n',
    'y': u"      \n      \n __  ,\n/ (_/_\n   /  \n  '   \n",
    '}': u'   / \n   /_\n _/  \n/    \n     \n     \n'}

shimrod_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n',
    '$': u" ,+.  \n( | ` \n `+.  \n. | ) \n `+'  \n      \n",
    '(': u' , \n/  \n|  \n\\  \n ` \n   \n',
    ',': u'  \n  \n  \n  \np \n  \n',
    '0': u" ,-.  \n/  /\\ \n| / | \n\\/  / \n `-'  \n      \n",
    '4': u"  ,. \n / | \n'--| \n   | \n   ' \n     \n",
    '8': u" ,-.  \n(   ) \n ;-:  \n(   ) \n `-'  \n      \n",
    '<': u"    \n ,' \n<   \n `. \n    \n    \n",
    '@': u" ,-.  \n/ ,-\\ \n| | | \n\\ `-' \n `--' \n      \n",
    'D': u",-.  \n|  \\ \n|  | \n|  / \n`-'  \n     \n",
    'H': u".  . \n|  | \n|--| \n|  | \n'  ' \n     \n",
    'L': u",    \n|    \n|    \n|    \n`--' \n     \n",
    'P': u";-.  \n|  ) \n|-'  \n|    \n'    \n     \n",
    'T': u",---. \n  |   \n  |   \n  |   \n  '   \n      \n",
    'X': u".   , \n \\ /  \n  X   \n / \\  \n'   ` \n      \n",
    '\\': u'\\     \n \\    \n  \\   \n   \\  \n    \\ \n      \n',
    '`': u'q \n  \n  \n  \n  \n  \n',
    'd': u"  . \n  | \n,-| \n| | \n`-' \n    \n",
    'h': u".   \n|   \n|-. \n| | \n' ' \n    \n",
    'l': u". \n| \n| \n| \n' \n  \n",
    'p': u"    \n    \n;-. \n| | \n|-' \n'   \n",
    't': u".   \n|   \n|-  \n|   \n`-' \n    \n",
    'x': u"    \n    \n. , \n X  \n' ` \n    \n",
    '|': u'| \n| \n| \n| \n| \n  \n',
    '#': u' | |  \n-+-+- \n | |  \n-+-+- \n | |  \n      \n',
    "'": u'p \n  \n  \n  \n  \n  \n',
    '+': u'    \n |  \n-+- \n |  \n    \n    \n',
    '/': u'    / \n   /  \n  /   \n /    \n/     \n      \n',
    '3': u",--, \n  /  \n `.  \n   ) \n`-'  \n     \n",
    '7': u",---, \n   /  \n  /   \n /    \n'     \n      \n",
    ';': u'  \no \n  \np \n  \n  \n',
    '?': u" ,-.  \n(   ) \n  ,'  \n  '   \n  o   \n      \n",
    'C': u" ,-. \n/    \n|    \n\\    \n `-' \n     \n",
    'G': u" ,-. \n/    \n| -. \n\\  | \n `-' \n     \n",
    'K': u",  , \n| /  \n|<   \n| \\  \n'  ` \n     \n",
    'O': u" ,-.  \n/   \\ \n|   | \n\\   / \n `-'  \n      \n",
    'S': u" ,-.  \n(   ` \n `-.  \n.   ) \n `-'  \n      \n",
    'W': u",   . \n| . | \n| ) ) \n|/|/  \n' '   \n      \n",
    '[': u',- \n|  \n|  \n|  \n`- \n   \n',
    '_': u'    \n    \n    \n    \n    \n--- \n',
    'c': u"    \n    \n,-. \n|   \n`-' \n    \n",
    'g': u"    \n    \n,-: \n| | \n`-| \n`-' \n",
    'k': u",   \n|   \n| , \n|<  \n' ` \n    \n",
    'o': u"    \n    \n,-. \n| | \n`-' \n    \n",
    's': u"    \n    \n,-. \n`-. \n`-' \n    \n",
    'w': u"      \n      \n, , , \n|/|/  \n' '   \n      \n",
    '{': u',- \n\\  \n<  \n/  \n`- \n   \n',
    '"': u'p q \n    \n    \n    \n    \n    \n',
    '&': u" ,-.   \n(   )  \n ;-: , \n(   X  \n `-' ` \n       \n",
    '*': u"  .   \n`.|,' \n / \\  \n      \n      \n      \n",
    '.': u'  \n  \n  \n  \no \n  \n',
    '2': u",-.  \n   ) \n  /  \n /   \n'--' \n     \n",
    '6': u" ,-.  \n/     \n|,-.  \n(   ) \n `-'  \n      \n",
    ':': u'  \no \n  \no \n  \n  \n',
    '>': u"    \n`.  \n  > \n,'  \n    \n    \n",
    'B': u",-.  \n|  ) \n|-<  \n|  ) \n`-'  \n     \n",
    'F': u",--. \n|    \n|-   \n|    \n'    \n     \n",
    'J': u" , \n | \n | \n | \n-' \n   \n",
    'N': u".  . \n|\\ | \n| \\| \n|  | \n'  ' \n     \n",
    'R': u",-.  \n|  ) \n|-<  \n|  \\ \n'  ' \n     \n",
    'V': u".   , \n|  /  \n| /   \n|/    \n'     \n      \n",
    'Z': u",---, \n   /  \n  /   \n /    \n'---' \n      \n",
    '^': u' A  \n/ \\ \n    \n    \n    \n    \n',
    'b': u".   \n|   \n|-. \n| | \n`-' \n    \n",
    'f': u"    \n ,- \n |  \n |- \n |  \n-'  \n",
    'j': u"   \n o \n , \n | \n | \n-' \n",
    'n': u"    \n    \n;-. \n| | \n' ' \n    \n",
    'r': u"    \n    \n;-. \n|   \n'   \n    \n",
    'v': u"    \n    \n. , \n|/  \n'   \n    \n",
    'z': u"    \n    \n,-, \n /  \n'-' \n    \n",
    '~': u"    \n'\\, \n    \n    \n    \n    \n",
    '!': u'. \n| \n| \n  \no \n  \n',
    '%': u" _  , \n(_)/  \n  /_  \n /(_) \n'     \n      \n",
    ')': u".  \n \\ \n | \n / \n'  \n   \n",
    '-': u'    \n    \n--- \n    \n    \n    \n',
    '1': u" , \n'| \n | \n | \n ' \n   \n",
    '5': u";--' \n|    \n`-.  \n   ) \n`-'  \n     \n",
    '9': u" ,-.  \n(   ) \n `-'| \n    / \n `-'  \n      \n",
    '=': u'    \n--- \n    \n--- \n    \n    \n',
    'A': u" ,.  \n/  \\ \n|--| \n|  | \n'  ' \n     \n",
    'E': u",--. \n|    \n|-   \n|    \n`--' \n     \n",
    'I': u", \n| \n| \n| \n' \n  \n",
    'M': u".   , \n|\\ /| \n| V | \n|   | \n'   ' \n      \n",
    'Q': u" ,-.   \n/   \\  \n|   |  \n\\   X  \n `-' ` \n       \n",
    'U': u'.  . \n|  | \n|  | \n|  | \n`--` \n     \n',
    'Y': u".   , \n \\ /  \n  Y   \n  |   \n  '   \n      \n",
    ']': u"-. \n | \n | \n | \n-' \n   \n",
    'a': u'    \n    \n,-: \n| | \n`-` \n    \n',
    'e': u"    \n    \n,-. \n|-' \n`-' \n    \n",
    'i': u"  \no \n. \n| \n' \n  \n",
    'm': u"      \n      \n;-.-. \n| | | \n' ' ' \n      \n",
    'q': u'    \n    \n,-: \n| | \n`-| \n  ` \n',
    'u': u'    \n    \n. . \n| | \n`-` \n    \n',
    'y': u"    \n    \n. . \n| | \n`-| \n`-' \n",
    '}': u"-. \n / \n > \n \\ \n-' \n   \n"}

smallcaps_dic = {
    '!': u' _  \n) | \n|_( \n)_/ \n    \n',
    ' ': u'  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u'  _ _  \n / / ( \n)_/_/  \n       \n       \n',
    '%': u' _  _  \n(_)/ ( \n  / /_ \n )_/(_)\n       \n',
    '$': u' \n \n \n \n \n',
    "'": u')| \n   \n   \n   \n   \n',
    '&': u'&\n \n \n \n \n',
    ')': u' _   \n\\ (  \n ) ) \n/_(  \n     \n',
    '(': u'  _  \n ) / \n( (  \n )_\\ \n     \n',
    '+': u'   _   \n _/ (_ \n)_   _(\n  )_/  \n       \n',
    '*': u'*\n \n \n \n \n',
    '-': u'       \n ____  \n)____( \n       \n       \n',
    ',': u'   \n   \n   \n)/ \n   \n',
    '/': u'   _  \n  / ( \n / /  \n)_/   \n      \n',
    '.': u'    \n    \n _  \n(_) \n    \n',
    '1': u'  _  \n/_ ( \n ) | \n/__( \n     \n',
    '0': u' ___  \n/ _ \\ \n))_(( \n\\___/ \n      \n',
    '3': u' ___  \n(__ \\ \n (_ | \n(___/ \n      \n',
    '2': u' ___  \n/__ ( \n ( /  \n/___\\ \n      \n',
    '5': u"  ___  \n ) __\\ \n '- )  \n )___\\ \n       \n",
    '4': u' _  _  \n) () ( \n \\_  | \n   )_( \n       \n',
    '7': u' ___  \n\\_  ( \n  / | \n  )_( \n      \n',
    '6': u' _    \n) |_  \n| ( \\ \n\\___/ \n      \n',
    '9': u' ___  \n/ _ \\ \n`-_(( \n  )_/ \n      \n',
    '8': u' ___  \n/ _ \\ \n) _ ( \n\\___/ \n      \n',
    ';': u' _  \n(_) \n _  \n)_( \n    \n',
    ':': u' _  \n(_) \n _  \n(_) \n    \n',
    '=': u' ____  \n)____( \n ____  \n)____( \n       \n',
    '<': u"  __  \n.' _/ \n'.__\\ \n      \n      \n",
    '?': u" ___  \n/ _ \\ \n`-'(( \n   )/ \n      \n",
    '>': u' __   \n\\_ `. \n/__.` \n      \n      \n',
    '@': u'@\n \n \n \n \n',
    '[': u' __  \n) _| \n|(_  \n)__| \n     \n',
    ']': u' __  \n|_ ( \n _)| \n|__( \n     \n',
    '\\': u' _    \n) \\   \n \\ \\  \n  \\_( \n      \n',
    '_': u'       \n       \n       \n _____ \n)_____(\n',
    '^': u'^\n \n \n \n \n',
    'a': u'   _   \n  )_\\  \n /( )\\ \n)_/ \\_(\n       \n',
    '`': u'\\( \n   \n   \n   \n   \n',
    'c': u' ___ \n/ _( \n))_  \n\\__( \n     \n',
    'b': u' ___  \n\\  _) \n|  (  \n/__o) \n      \n',
    'e': u' ___  \n) __( \n| _)  \n)___( \n      \n',
    'd': u' ___  \n\\   \\ \n| ) ( \n/___/ \n      \n',
    'g': u' ____  \n).-._( \n|( ,-. \n)_`__( \n       \n',
    'f': u' ___  \n) __( \n| _)  \n)_(   \n      \n',
    'i': u'  ___  \n )_ _( \n _| |_ \n)_____(\n       \n',
    'h': u' _  _  \n) () ( \n| -- | \n)_()_( \n       \n',
    'k': u' _  _  \n) |) / \n| ( (  \n)_|)_\\ \n       \n',
    'j': u'  ___  \n )_ _( \n _) |  \n)___(  \n       \n',
    'm': u' _   _ \n) \\_/ (\n|  _  |\n)_( )_(\n       \n',
    'l': u' _     \n) |    \n| (__  \n)____( \n       \n',
    'o': u' ____  \n/ __ \\ \n))__(( \n\\____/ \n       \n',
    'n': u' _  _  \n) \\/ ( \n|  \\ | \n)_()_( \n       \n',
    'q': u' ____  \n/ __ \\ \n))__(( \n\\___\\( \n       \n',
    'p': u" ____  \n)  _)\\ \n| '__/ \n)_(    \n       \n",
    's': u'  ___  \n (  _( \n _) \\  \n)____) \n       \n',
    'r': u" ____  \n/  _ \\ \n)  ' / \n|_()_\\ \n       \n",
    'u': u' _  _  \n) () ( \n| \\/ | \n)____( \n       \n',
    't': u' _____ \n)__ __(\n  | |  \n  )_(  \n       \n',
    'w': u'__   __\n) (_) (\n\\  _  /\n )/ \\( \n       \n',
    'v': u' _   _ \n\\ ( ) /\n )\\_/( \n  \\_/  \n       \n',
    'y': u" _  _  \n) () ( \n'.  /  \n /_(   \n       \n",
    'x': u' _   _ \n) ( ) (\n ) | ( \n)_( )_(\n       \n',
    '{': u'  _  \n ) | \n( (  \n )_| \n     \n',
    'z': u' ____  \n)___ ( \n  / /_ \n )____(\n       \n',
    '}': u' _   \n| (  \n ) ) \n|_(  \n     \n',
    '|': u' _  \n) | \n| ( \n)_| \n    \n',
    '~': u'       \n)`-._  \n `-._( \n       \n       \n'}

smpoison_dic = {
    '!': u'    \n@@@ \n@@@ \n!@! \n    \n:.: \n    \n',
    ' ': u'   \n   \n   \n   \n   \n   \n   \n',
    '#': u'          \n @@@ @@@  \n@@@!@@@@@ \n @!@ !@!  \n!!!:!!!!: \n ::  : :  \n          \n',
    '"': u'        \n@@@ @@@ \n!@  !@  \n        \n        \n        \n        \n',
    '%': u'        \n @@  @@ \n    @@! \n   @@!  \n !!:    \n :.  :: \n        \n',
    '$': u'   @@   \n @@@@@  \n!@@!!   \n !@@!!  \n   !!:! \n :.:.:  \n    :   \n',
    "'": u'    \n@@@ \n!@  \n    \n    \n    \n    \n',
    '&': u'          \n @@@@@    \n@@! @@@   \n !@!@!    \n!!: !!!   \n :.: : .: \n          \n',
    ')': u'@@@  \n @@@ \n @@@ \n !@! \n !!! \n !:! \n: :  \n',
    '(': u' @@@ \n@@@  \n@@@  \n!@!  \n!!!  \n!:!  \n : : \n',
    '+': u'          \n   @@@    \n   @@@    \n@!@!@!@!@ \n   !!!    \n   : :    \n          \n',
    '*': u'           \n @@@  @@@  \n  @@!!@@   \n!!!@@!@!!! \n  !:::!!   \n :.:  .::  \n           \n',
    '-': u'         \n         \n         \n@!@!@!@! \n         \n         \n         \n',
    ',': u'    \n    \n    \n    \n!:! \n::  \n:   \n',
    '/': u'      @@@ \n     @@@  \n    @@@   \n   !!@    \n  !!!     \n :!:      \n: :       \n',
    '.': u'    \n    \n    \n    \n!:! \n::: \n    \n',
    '1': u'     \n @@@ \n@@@@ \n !@! \n !!! \n ::  \n     \n',
    '0': u'         \n @@@@@@  \n@@!  @@@ \n@!@  !@! \n!!:  !!! \n : : ::  \n         \n',
    '3': u'        \n@@@@@@  \n    @@! \n @!!!:  \n    !!: \n::: ::  \n        \n',
    '2': u'         \n @@@@@@  \n@@   @@@ \n  .!!@!  \n !!:     \n:.:: ::: \n         \n',
    '5': u'        \n@@@@@@@ \n!@@     \n!!@@!!  \n    !:! \n:: : :  \n        \n',
    '4': u'         \n@@@  @@@ \n@@@  @@@ \n@!@!@!@! \n     !!! \n     : : \n         \n',
    '7': u'         \n@@@@@@@@ \n     @@! \n    @!!  \n .!!:    \n: :      \n         \n',
    '6': u'         \n  @@@@@  \n@@!@     \n@!@!@!@  \n!!:  !!! \n : : ::  \n         \n',
    '9': u'         \n @@@@@@  \n@@!  @@@ \n @!@@!@! \n     !!: \n : :::   \n         \n',
    '8': u'         \n @@@@@@  \n@@!  @@@ \n !@!@!@  \n!!:  !!! \n :.:: :  \n         \n',
    ';': u'    \n@@@ \n@@! \n    \n!:! \n::  \n:   \n',
    ':': u'    \n@@@ \n@@! \n    \n!:! \n::: \n    \n',
    '=': u'         \n         \n@@@!@@@@ \n         \n!!!:!!!! \n         \n         \n',
    '<': u'      @@@ \n    @@@   \n  @@!     \n!@!       \n  !!!     \n    :!:   \n      : : \n',
    '?': u'         \n @@@@@@  \n@@!  @@@ \n   .!@!  \n   ""    \n   ::    \n         \n',
    '>': u'@@@       \n  @@@     \n    @@!   \n      !@! \n    !!!   \n  :!:     \n: :       \n',
    '@': u'          \n @@@@@@@  \n!@@   !@@ \n!@! @!@!@ \n:!!       \n :: :: :  \n          \n',
    '[': u'@@@@@ \n@@@   \n@@!   \n!!@   \n!!!   \n:!:   \n: :.: \n',
    ']': u'@@@@@ \n  @@@ \n  @@! \n  !!@ \n  !!! \n  :!: \n:.: : \n',
    '\\': u'@@@       \n @@@      \n  @@!     \n   !!@    \n    !!!   \n     :!:  \n      : : \n',
    '_': u'         \n         \n         \n         \n         \n.......  \n: :: : : \n',
    '^': u'         \n  @@@@   \n@!@  !@@ \n         \n         \n         \n         \n',
    'a': u'         \n @@@@@@  \n@@!  @@@ \n@!@!@!@! \n!!:  !!! \n :   : : \n         \n',
    '`': u'    \n@@@ \n !@ \n    \n    \n    \n    \n',
    'c': u'         \n @@@@@@@ \n!@@      \n!@!      \n:!!      \n :: :: : \n         \n',
    'b': u'         \n@@@@@@@  \n@@!  @@@ \n@!@!@!@  \n!!:  !!! \n:: : ::  \n         \n',
    'e': u'         \n@@@@@@@@ \n@@!      \n@!!!:!   \n!!:      \n: :: ::  \n         \n',
    'd': u'         \n@@@@@@@  \n@@!  @@@ \n@!@  !@! \n!!:  !!! \n:: :  :  \n         \n',
    'g': u'          \n @@@@@@@  \n!@@       \n!@! @!@!@ \n:!!   !!: \n :: :: :  \n          \n',
    'f': u'         \n@@@@@@@@ \n@@!      \n@!!!:!   \n!!:      \n :       \n         \n',
    'i': u'    \n@@@ \n@@! \n!!@ \n!!: \n:   \n    \n',
    'h': u'         \n@@@  @@@ \n@@!  @@@ \n@!@!@!@! \n!!:  !!! \n :   : : \n         \n',
    'k': u'         \n@@@  @@@ \n@@!  !@@ \n@!@@!@!  \n!!: :!!  \n :   ::: \n         \n',
    'j': u'        \n    @@@ \n    @@! \n    !!@ \n.  .!!  \n::.::   \n        \n',
    'm': u'            \n@@@@@@@@@@  \n@@! @@! @@! \n@!! !!@ @!@ \n!!:     !!: \n :      :   \n            \n',
    'l': u'         \n@@@      \n@@!      \n@!!      \n!!:      \n: ::.: : \n         \n',
    'o': u'         \n @@@@@@  \n@@!  @@@ \n@!@  !@! \n!!:  !!! \n : :. :  \n         \n',
    'n': u'         \n@@@  @@@ \n@@!@!@@@ \n@!@@!!@! \n!!:  !!! \n::    :  \n         \n',
    'q': u'          \n @@@@@@   \n@@!  @@@  \n@!@  !@!  \n!!:!!:!:  \n : :. ::: \n          \n',
    'p': u'         \n@@@@@@@  \n@@!  @@@ \n@!@@!@!  \n!!:      \n :       \n         \n',
    's': u'        \n @@@@@@ \n!@@     \n !@@!!  \n    !:! \n::.: :  \n        \n',
    'r': u'         \n@@@@@@@  \n@@!  @@@ \n@!@!!@!  \n!!: :!!  \n :   : : \n         \n',
    'u': u'         \n@@@  @@@ \n@@!  @@@ \n@!@  !@! \n!!:  !!! \n :.:: :  \n         \n',
    't': u'        \n@@@@@@@ \n  @!!   \n  @!!   \n  !!:   \n   :    \n        \n',
    'w': u'              \n@@@  @@@  @@@ \n@@!  @@!  @@! \n@!!  !!@  @!@ \n !:  !!:  !!  \n  ::.:  :::   \n              \n',
    'v': u'         \n@@@  @@@ \n@@!  @@@ \n@!@  !@! \n !: .:!  \n   ::    \n         \n',
    'y': u'        \n@@@ @@@ \n@@! !@@ \n !@!@!  \n  !!:   \n  .:    \n        \n',
    'x': u'         \n@@@  @@@ \n@@!  !@@ \n !@@!@!  \n !: :!!  \n:::  ::: \n         \n',
    '{': u'  @@@ \n @@@  \n @@!  \n!!@   \n !!!  \n :!:  \n  : : \n',
    'z': u'         \n@@@@@@@@ \n     @@! \n   @!!   \n !!:     \n:.::.: : \n         \n',
    '}': u'@@@   \n @@@  \n @@!  \n  !!@ \n !!!  \n :!:  \n: :   \n',
    '|': u'@@@ \n@@@ \n@@! \n    \n!!! \n:!: \n: : \n',
    '~': u'        \n @@@ @@ \n@@ @@@  \n        \n        \n        \n        \n'}

soft_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '$': u"   ,--.   \n ,-|  |-. \n|  |  |-' \n '-|  |`\\ \n.--|  | / \n`--|  |'  \n   `--'   \n",
    '(': u"      \n  ,-. \n / .' \n|  |  \n|  |  \n \\ '. \n  `-' \n",
    ',': u"     \n     \n     \n     \n,--. \n'-,/ \n     \n",
    '0': u"         \n  ,--.   \n /    \\  \n|  ()  | \n \\    /  \n  `--'   \n         \n",
    '4': u"        \n  ,---. \n /    | \n/  '  | \n'--|  | \n   `--' \n        \n",
    '8': u"        \n ,---.  \n|  o  | \n.'   '. \n|  o  | \n `---'  \n        \n",
    '<': u"      \n  ,-. \n /  / \n/  /  \n\\  \\  \n \\  \\ \n  `-' \n",
    '@': u"         \n ,----.  \n'   ,  | \n|  |   / \n'  '--'| \n `----'  \n         \n",
    'D': u"           \n,------.   \n|  .-.  \\  \n|  |  \\  : \n|  '--'  / \n`-------'  \n           \n",
    'H': u"           \n,--.  ,--. \n|  '--'  | \n|  .--.  | \n|  |  |  | \n`--'  `--' \n           \n",
    'L': u"        \n,--.    \n|  |    \n|  |    \n|  '--. \n`-----' \n        \n",
    'P': u"          \n,------.  \n|  .--. ' \n|  '--' | \n|  | --'  \n`--'      \n          \n",
    'T': u"           \n,--------. \n'--.  .--' \n   |  |    \n   |  |    \n   `--'    \n           \n",
    'X': u"            \n,--.   ,--. \n \\  `.'  /  \n  .'    \\   \n /  .'.  \\  \n'--'   '--' \n            \n",
    '\\': u",--.       \n \\  \\      \n  \\  \\     \n   \\  \\    \n    \\  \\   \n     \\  \\  \n      `--' \n",
    '`': u"       \n,--.   \n'.  \\  \n  `--' \n       \n       \n       \n",
    'd': u"        \n   ,--. \n ,-|  | \n' .-. | \n\\ `-' | \n `---'  \n        \n",
    'h': u"          \n,--.      \n|  ,---.  \n|  .-.  | \n|  | |  | \n`--' `--' \n          \n",
    'l': u"     \n,--. \n|  | \n|  | \n|  | \n`--' \n     \n",
    'p': u"        \n        \n ,---.  \n| .-. | \n| '-' ' \n|  |-'  \n`--'    \n",
    't': u"         \n  ,--.   \n,-'  '-. \n'-.  .-' \n  |  |   \n  `--'   \n         \n",
    'x': u"           \n           \n,--.  ,--. \n \\  `'  /  \n /  /.  \\  \n'--'  '--' \n           \n",
    '|': u",--. \n|  | \n|  | \n|  | \n|  | \n|  | \n`--' \n",
    '#': u"  ,--. ,--.  \n,-|  |-|  |-.\n'-|  |-|  |-'\n,-|  |-|  |-.\n'-|  |-|  |-'\n  `--' `--'  \n             \n",
    "'": u"     \n,--. \n|  | \n`-'  \n     \n     \n     \n",
    '+': u"    ,--.     \n    |  |     \n,---|  |---. \n'---|  |---' \n    |  |     \n    `--'     \n             \n",
    '/': u"      ,--. \n     /  /  \n    /  /   \n   /  /    \n  /  /     \n /  /      \n`--'       \n",
    '3': u"        \n,----.  \n'.-.  | \n  .' <  \n/'-'  | \n`----'  \n        \n",
    '7': u"        \n,-----. \n'--,  / \n .'  /  \n/   /   \n`--'    \n        \n",
    ';': u"     \n     \n.--. \n'--' \n.--. \n'-,/ \n     \n",
    '?': u" ,------.  \n'  .--.  ' \n'--' _|  | \n .--' __'  \n `---'     \n .---.     \n '---'     \n",
    'C': u"         \n ,-----. \n'  .--./ \n|  |     \n'  '--'\\ \n `-----' \n         \n",
    'G': u"           \n ,----.    \n'  .-./    \n|  | .---. \n'  '--'  | \n `------'  \n           \n",
    'K': u"          \n,--. ,--. \n|  .'   / \n|  .   '  \n|  |\\   \\ \n`--' '--' \n          \n",
    'O': u"          \n ,-----.  \n'  .-.  ' \n|  | |  | \n'  '-'  ' \n `-----'  \n          \n",
    'S': u"         \n ,---.   \n'   .-'  \n`.  `-.  \n.-'    | \n`-----'  \n         \n",
    'W': u"            \n,--.   ,--. \n|  |   |  | \n|  |.'.|  | \n|   ,'.   | \n'--'   '--' \n            \n",
    '[': u"       \n,----. \n|  .-' \n|  |   \n|  |   \n|  '-. \n`----' \n",
    '_': u"       \n       \n       \n       \n,----. \n'----' \n       \n",
    'c': u"       \n       \n ,---. \n| .--' \n\\ `--. \n `---' \n       \n",
    'g': u"        \n        \n ,---.  \n| .-. | \n' '-' ' \n.`-  /  \n`---'   \n",
    'k': u"         \n,--.     \n|  |,-.  \n|     /  \n|  \\  \\  \n`--'`--' \n         \n",
    'o': u"        \n        \n ,---.  \n| .-. | \n' '-' ' \n `---'  \n        \n",
    's': u"        \n        \n ,---.  \n(  .-'  \n.-'  `) \n`----'  \n        \n",
    'w': u"            \n            \n,--.   ,--. \n|  |.'.|  | \n|   .'.   | \n'--'   '--' \n            \n",
    '{': u"        \n   ,--. \n  |  .' \n.'  /   \n'.  \\   \n  |  '. \n   `--' \n",
    '"': u"          \n,--. ,--. \n|  | |  | \n`-'  `-'  \n          \n          \n          \n",
    '&': u"           \n ,---.     \n|  o ,-.   \n.'     /_  \n|  o  .__) \n `---'     \n           \n",
    '*': u"    ,--.     \n .-,|  |,-.  \n _\\ '  ' /_  \n(__      __) \n  / .  . \\   \n `-'|  |`-'  \n    `--'     \n",
    '.': u"     \n     \n     \n     \n.--. \n'--' \n     \n",
    '2': u"        \n ,---.  \n'.-.  \\ \n .-' .' \n/   '-. \n'-----' \n        \n",
    '6': u"        \n  ,--.  \n /  .'  \n|  .-.  \n\\   o | \n `---'  \n        \n",
    ':': u"     \n     \n.--. \n'--' \n.--. \n'--' \n     \n",
    '>': u"      \n,-.   \n\\  \\  \n \\  \\ \n /  / \n/  /  \n`-'   \n",
    'B': u"          \n,-----.   \n|  |) /_  \n|  .-.  \\ \n|  '--' / \n`------'  \n          \n",
    'F': u"         \n,------. \n|  .---' \n|  `--,  \n|  |`    \n`--'     \n         \n",
    'J': u"          \n     ,--. \n     |  | \n,--. |  | \n|  '-'  / \n `-----'  \n          \n",
    'N': u"           \n,--.  ,--. \n|  ,'.|  | \n|  |' '  | \n|  | `   | \n`--'  `--' \n           \n",
    'R': u"          \n,------.  \n|  .--. ' \n|  '--'.' \n|  |\\  \\  \n`--' '--' \n          \n",
    'V': u"            \n,--.   ,--. \n \\  `.'  /  \n  \\     /   \n   \\   /    \n    `-'     \n            \n",
    'Z': u"          \n,-------. \n`--.   /  \n  /   /   \n /   `--. \n`-------' \n          \n",
    '^': u"          \n  ,---.   \n /  \\  \\  \n`--' `--' \n          \n          \n          \n",
    'b': u"        \n,--.    \n|  |-.  \n| .-. ' \n| `-' | \n `---'  \n        \n",
    'f': u"       \n ,---. \n/  .-' \n|  `-, \n|  .-' \n`--'   \n       \n",
    'j': u"       \n  ,--. \n  `--' \n  ,--. \n  |  | \n.-'  / \n'---'  \n",
    'n': u"         \n         \n,--,--,  \n|      \\ \n|  ||  | \n`--''--' \n         \n",
    'r': u"        \n        \n,--.--. \n|  .--' \n|  |    \n`--'    \n        \n",
    'v': u"           \n           \n,--.  ,--. \n \\  `'  /  \n  \\    /   \n   `--'    \n           \n",
    'z': u"        \n        \n,-----. \n`-.  /  \n /  `-. \n`-----' \n        \n",
    '~': u"           \n      .--, \n  .--'  /  \n /  ---`   \n`--'       \n           \n           \n",
    '!': u",---. \n|   | \n|  .' \n|  |  \n`--'  \n.--.  \n'--'  \n",
    '%': u"      ,--. \n .-. /  /  \n '-'/  /   \n   /  /    \n  /  /.-.  \n /  / '-'  \n`--'       \n",
    ')': u"      \n,-.   \n'. \\  \n |  | \n |  | \n.' /  \n`-'   \n",
    '-': u"        \n        \n,-----. \n'-----' \n        \n        \n        \n",
    '1': u"      \n ,--. \n/   | \n`|  | \n |  | \n `--' \n      \n",
    '5': u"        \n,-----. \n|  .--' \n'--. `\\ \n.--'  / \n`----'  \n        \n",
    '9': u"        \n ,---.  \n| o   \\ \n`..'  | \n .'  /  \n `--'   \n        \n",
    '=': u"      \n      \n,---. \n'---' \n,---. \n'---' \n      \n",
    'A': u"          \n  ,---.   \n /  O  \\  \n|  .-.  | \n|  | |  | \n`--' `--' \n          \n",
    'E': u"         \n,------. \n|  .---' \n|  `--,  \n|  `---. \n`------' \n         \n",
    'I': u"     \n,--. \n|  | \n|  | \n|  | \n`--' \n     \n",
    'M': u"            \n,--.   ,--. \n|   `.'   | \n|  |'.'|  | \n|  |   |  | \n`--'   `--' \n            \n",
    'Q': u"            \n ,-----.    \n'  .-.  '   \n|  | |  |   \n'  '-'  '-. \n `-----'--' \n            \n",
    'U': u"          \n,--. ,--. \n|  | |  | \n|  | |  | \n'  '-'  ' \n `-----'  \n          \n",
    'Y': u"            \n,--.   ,--. \n \\  `.'  /  \n  '.    /   \n    |  |    \n    `--'    \n            \n",
    ']': u"       \n,----. \n`-.  | \n  |  | \n  |  | \n.-'  | \n`----' \n",
    'a': u"         \n         \n ,--,--. \n' ,-.  | \n\\ '-'  | \n `--`--' \n         \n",
    'e': u"        \n        \n ,---.  \n| .-. : \n\\   --. \n `----' \n        \n",
    'i': u"     \n,--. \n`--' \n,--. \n|  | \n`--' \n     \n",
    'm': u"           \n           \n,--,--,--. \n|        | \n|  |  |  | \n`--`--`--' \n           \n",
    'q': u"        \n        \n ,---.  \n| .-. | \n' '-' | \n `-|  | \n   `--' \n",
    'u': u"         \n         \n,--.,--. \n|  ||  | \n'  ''  ' \n `----'  \n         \n",
    'y': u"          \n          \n,--. ,--. \n \\  '  /  \n  \\   '   \n.-'  /    \n`---'     \n",
    '}': u"        \n,--.    \n'.  |   \n  \\  `. \n  /  .' \n.'  |   \n'--'    \n"}

spliff_dic = {
    '!': u' ___ \n/   \\\n\\___/\n<___>\n     \n',
    ' ': u'  \n  \n  \n  \n  \n',
    '#': u'   _ _   \n _| |_|_ \n|_|_|___|\n|___| |_|\n  |_|_|  \n',
    '"': u' _ _  \n| | | \n\\_|_/ \n      \n      \n',
    '%': u' _  __ \n<_>/ / \n  / /_ \n /_/<_>\n       \n',
    '$': u' _/_/\n/ __>\n\\__ \\\n<___/\n/_/  \n',
    "'": u' _ \n< >\n|/ \n   \n   \n',
    '&': u' ___  \n< _ > \n/ _ \\/\n\\__\\ \\\n     /\n',
    ')': u'___ \n\\  \\\n | |\n/__/\n    \n',
    '(': u' ___\n/  /\n| | \n\\__\\\n    \n',
    '+': u'   _   \n _| |_ \n|_   _|\n  |_|  \n       \n',
    '*': u'__A__\n\\   /\n/_ _\\\n  V  \n     \n',
    '-': u'     \n ___ \n<___>\n     \n     \n',
    ',': u'   \n   \n _ \n< >\n|/ \n',
    '/': u'   ___\n  /  /\n /  / \n/__/  \n      \n',
    '.': u'   \n   \n _ \n<_>\n   \n',
    '1': u' ___  \n/   | \n |  | \n<____>\n      \n',
    '0': u' _____ \n/  _  \\\n|  |  |\n\\_____/\n       \n',
    '3': u' _____ \n/  _  \\\n>-<_  <\n\\_____/\n       \n',
    '2': u' _____ \n<___  \\\n /  __/\n<_____|\n       \n',
    '5': u' _____ \n|  ___|\n|___  \\\n<_____/\n       \n',
    '4': u' __ __ \n/  |  \\\n\\_    |\n  \\___/\n       \n',
    '7': u' _____ \n<__   \\\n  /   /\n <___/ \n       \n',
    '6': u' ____  \n/  __| \n|  _  \\\n\\_____/\n       \n',
    '9': u' _____ \n/  _  \\\n\\___  |\n|_____/\n       \n',
    '8': u' _____ \n/  _  \\\n>  _  <\n\\_____/\n       \n',
    ';': u' _ \n<_>\n _ \n< >\n|/ \n',
    ':': u' _ \n<_>\n _ \n<_>\n   \n',
    '=': u'      \n ___  \n<___> \n<___> \n      \n',
    '<': u'  ___\n /  /\n<  < \n \\__\\\n     \n',
    '?': u' _____ \n<___  \\\n  |__ /\n <___> \n       \n',
    '>': u'___  \n\\  \\ \n >  >\n/__/ \n     \n',
    '@': u' _____ \n/  __ \\\n| |___|\n\\_____/\n       \n',
    '[': u' ___ \n|  _|\n| |_ \n|___|\n     \n',
    ']': u' ___ \n|_  |\n _| |\n|___|\n     \n',
    '\\': u'___   \n\\  \\  \n \\  \\ \n  \\__\\\n      \n',
    '_': u'      \n      \n      \n ____ \n<____>\n',
    '^': u'  __  \n /  \\ \n/_/\\_\\\n      \n      \n',
    'a': u' _____ \n/  _  \\\n|  _  |\n\\__|__/\n       \n',
    '`': u' _ \n< >\n \\|\n   \n   \n',
    'c': u' _____ \n/     \\\n|  |--|\n\\_____/\n       \n',
    'b': u' _____ \n/  _  \\\n|  _  <\n\\_____/\n       \n',
    'e': u' _____ \n/   __\\\n|   __|\n\\_____/\n       \n',
    'd': u' _____ \n|  _  \\\n|  |  |\n|_____/\n       \n',
    'g': u' _____ \n/   __\\\n|  |_ |\n\\_____/\n       \n',
    'f': u' _____ \n/   __\\\n|   __|\n\\__/   \n       \n',
    'i': u' ___ \n/___\\\n|   |\n\\___/\n     \n',
    'h': u' __ __ \n/  |  \\\n|  _  |\n\\__|__/\n       \n',
    'k': u' __ ___\n|  |  /\n|  _ < \n|__|__\\\n       \n',
    'j': u'  ____ \n  \\_  \\\n---|  |\n\\_____/\n       \n',
    'm': u' __  __ \n/  \\/  \\\n|  \\/  |\n\\__ \\__/\n        \n',
    'l': u' ____  \n/  _/  \n|  |---\n\\_____/\n       \n',
    'o': u' _____ \n/  _  \\\n|  |  |\n\\_____/\n       \n',
    'n': u' _____ \n/  _  \\\n|  |  |\n\\__|__/\n       \n',
    'q': u' _____ \n/  _  \\\n|  |  |\n\\___\\ \\\n      /\n',
    'p': u' _____ \n/  _  \\\n|   __/\n\\__/   \n       \n',
    's': u' _____ \n/  ___>\n|___  |\n<_____/\n       \n',
    'r': u' _____ \n/  _  \\\n|  _  <\n\\__|\\_/\n       \n',
    'u': u' __ __ \n/  |  \\\n|  |  |\n\\_____/\n       \n',
    't': u' ____ \n/    \\\n\\-  -/\n |__| \n      \n',
    'w': u' __  __ \n/   /  \\\n|  /\\  |\n\\__/\\__/\n        \n',
    'v': u' __ __ \n/  |  \\\n\\  |  /\n \\___/ \n       \n',
    'y': u'___ ___\n\\  |  /\n |   | \n \\___/ \n       \n',
    'x': u' __  __ \n/  \\/  \\\n>-    -<\n\\__/\\__/\n        \n',
    '{': u'  ___\n |  /\n<  | \n |__\\\n     \n',
    'z': u' _____ \n|__   /\n /  _/ \n/_____|\n       \n',
    '}': u'___  \n\\  | \n |  >\n/__| \n     \n',
    '|': u' _ \n| |\n| |\n|_|\n   \n',
    '~': u'  _  _ \n / \\/ >\n<_/\\_/ \n       \n       \n'}

stacey_dic = {
    '!': u'____\n7  7\n|  |\n!__!\n____\n7__7\n    \n',
    ' ': u'     \n     \n     \n     \n     \n     \n     \n',
    '#': u'',
    '"': u'___ ___\n7 7 7 7\n!/  !/ \n       \n       \n       \n       \n',
    '%': u'',
    '$': u'',
    "'": u'___\n7 7\n!/ \n   \n   \n   \n   \n',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'   \n   \n   \n   \n___\n7 7\n!/ \n',
    '/': u'',
    '.': u'    \n    \n    \n    \n____\n7__7\n    \n',
    '1': u'_____\n7   7\n!_  |\n 7  |\n |  |\n !__!\n     \n',
    '0': u'_______\n7     7\n|  7  |\n|  |  |\n|  !  |\n!_____!\n       \n',
    '3': u'_______\n7     7\n|___  !\n |__  |\n|     |\n!_____!\n       \n',
    '2': u'_______\n7     7\n!___  !\n|  ___|\n|     7\n!_____!\n       \n',
    '5': u'_______\n7  ___7\n|     7\n!___  |\n7     |\n!_____!\n       \n',
    '4': u'_______\n7  7  7\n|  !  |\n!___  |\n   7  |\n   !__!\n       \n',
    '7': u'_______\n7     7\n!___  |\n   7  |\n   |  |\n   !__!\n       \n',
    '6': u'_______\n7     7\n|  ___!\n|     7\n|  -  |\n!_____!\n       \n',
    '9': u'_______\n7     7\n|  -  |\n!___  |\n7     |\n!_____!\n       \n',
    '8': u'_______\n7  _  7\n!_   _!\n|     |\n|  -  |\n!_____!\n       \n',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'_______\n7     7\n!__!  |\n   !__!\n   ____\n   7__7\n       \n',
    '>': u'',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u'_______\n7  _  7\n|  _  |\n|  7  |\n|  |  |\n!__!__!\n       \n',
    '`': u'___\n7 7\n \\!\n   \n   \n   \n   \n',
    'c': u'_______\n7     7\n|  ___!\n|  7___\n|     7\n!_____!\n       \n',
    'b': u'_______\n7  _  7\n|   __|\n|  _  |\n|  7  |\n!_____!\n       \n',
    'e': u'_______\n7     7\n|  ___!\n|  __|_\n|     7\n!_____!\n       \n',
    'd': u'_____  \n7    \\ \n|  7  |\n|  |  |\n|  !  |\n!_____!\n       \n',
    'g': u'_______\n7     7\n|   __!\n|  !  7\n|     |\n!_____!\n       \n',
    'f': u'_______\n7     7\n|  ___!\n|  __| \n|  7   \n!__!   \n       \n',
    'i': u'____\n7  7\n|  |\n|  |\n|  |\n!__!\n    \n',
    'h': u'_______\n7  7  7\n|  !  |\n|     |\n|  7  |\n!__!__!\n       \n',
    'k': u'_______\n7  7  7\n|   __!\n|     |\n|  7  |\n!__!__!\n       \n',
    'j': u'   ____\n   7  7\n___|  |\n7  !  |\n|     |\n!_____!\n       \n',
    'm': u'__________\n7        7\n|  _  _  |\n|  7  7  |\n|  |  |  |\n!__!__!__!\n          \n',
    'l': u'____   \n7  7   \n|  |   \n|  !___\n|     7\n!_____!\n       \n',
    'o': u'_______\n7     7\n|  7  |\n|  |  |\n|  !  |\n!_____!\n       \n',
    'n': u'_______\n7     7\n|  _  |\n|  7  |\n|  |  |\n!__!__!\n       \n',
    'q': u'_______  \n7     7  \n|  7  |  \n|  |  |  \n|  !  |_ \n!_______!\n         \n',
    'p': u'_______\n7     7\n|  -  |\n|  ___!\n|  7   \n!__!   \n       \n',
    's': u'_______\n7     7\n|  ___!\n!__   7\n7     |\n!_____!\n       \n',
    'r': u'_______\n7  _  7\n|    _|\n|  _ \\ \n|  7  |\n!__!__!\n       \n',
    'u': u'_______\n7  7  7\n|  |  |\n|  |  |\n|  !  |\n!_____!\n       \n',
    't': u'________\n7      7\n!__  __!\n  7  7  \n  |  |  \n  !__!  \n        \n',
    'w': u'___ __ ___\n7  V  V  7\n|  |  |  |\n|  !  !  |\n|        |\n!________!\n          \n',
    'v': u'___ ___\n7  V  7\n|  |  |\n|  !  |\n|     |\n!_____!\n       \n',
    'y': u'_______\n7  7  7\n|  !  |\n!_   _!\n 7   7 \n !___! \n       \n',
    'x': u'_______\n7  7  7\n!_   _!\n|     |\n|  7  |\n!__!__!\n       \n',
    '{': u'',
    'z': u'_______\n7     7\n!___  |\n|   __!\n|     7\n!_____!\n       \n',
    '}': u'',
    '|': u'',
    '~': u''}

stampate_dic = {
    ' ': u'   \n   \n   \n   \n   \n   \n',
    '$': u"    \n,|. \n`+. \n`|' \n    \n    \n",
    '(': u' ,- \n/   \n|   \n\\   \n `- \n    \n',
    ',': u'   \n   \n,. \n|/ \n   \n   \n',
    '0': u",--. \n|  | \n|  | \n`--' \n     \n     \n",
    '4': u"  ,  \n /|  \n'-+- \n  `  \n     \n     \n",
    '8': u",--. \n\\__/ \n/  \\ \n`--' \n     \n     \n",
    '<': u' , \n/  \n\\  \n ` \n   \n   \n',
    '@': u" ,-.  \n/,-.\\ \n|,-|| \n\\`-^/ \n `-'  \n      \n",
    'D': u".-,--.  \n' |   \\ \n, |   / \n`-^--'  \n        \n        \n",
    'H': u",-_/,. \n' |_|/ \n /| |  \n `' `' \n       \n       \n",
    'L': u".    \n|    \n|    \n`--' \n     \n     \n",
    'P': u".-,--. \n '|__/ \n .|    \n `'    \n       \n       \n",
    'T': u",--,--'\n`- |   \n , |   \n `-'   \n       \n       \n",
    'X': u",.  ,. \n` \\/   \n  /\\   \n`'  `' \n       \n       \n",
    '\\': u'    \n.   \n \\  \n  ` \n    \n    \n',
    '`': u'.  \n ` \n   \n   \n   \n   \n',
    'd': u"  . \n,-| \n| | \n`-' \n    \n    \n",
    'h': u".   \n|-. \n| | \n' ' \n    \n    \n",
    'l': u".  \n|  \n|  \n`' \n   \n   \n",
    'p': u"    \n,-. \n| | \n|-' \n|   \n'   \n",
    't': u".  \n|- \n|  \n`' \n   \n   \n",
    'x': u"    \n. , \n X  \n' ` \n    \n    \n",
    '|': u'| \n| \n| \n| \n| \n  \n',
    '#': u" . .  \n-|-|- \n-|-|- \n ' `  \n      \n      \n",
    "'": u"   \n,' \n   \n   \n   \n   \n",
    '+': u"    \n .  \n-|- \n '  \n    \n    \n",
    '/': u"    \n  , \n /  \n'   \n    \n    \n",
    '3': u",--. \n __| \n   | \n`--' \n     \n     \n",
    '7': u",--, \n  /  \n /   \n'    \n     \n     \n",
    ';': u",. \n`' \n,. \n|/ \n   \n   \n",
    '?': u",--. \n  /  \n ,.  \n `'  \n     \n     \n",
    'C': u",---. \n|  -' \n|  -. \n`---' \n      \n      \n",
    'G': u",---.  \n|  -'  \n|  ,-' \n`---|  \n ,-.|  \n `-+'  \n",
    'K': u",-, , \n '|/  \n  |\\  \n ,' ` \n      \n      \n",
    'O': u",---. \n|   | \n|   | \n`---' \n      \n      \n",
    'S': u".---. \n\\___  \n    \\ \n`---' \n      \n      \n",
    'W': u",.   ,   ,. \n`|  /|  /   \n | / | /    \n `'  `'     \n            \n            \n",
    '[': u'.- \n|  \n|  \n|  \n`- \n   \n',
    '_': u'  \n  \n  \n  \n~~\n  \n',
    'c': u"    \n,-. \n|   \n`-' \n    \n    \n",
    'g': u"    \n,-. \n| | \n`-| \n ,| \n `' \n",
    'k': u"    \n. , \n|/  \n|\\  \n' ` \n    \n",
    'o': u"    \n,-. \n| | \n`-' \n    \n    \n",
    's': u"    \n,-. \n`-. \n`-' \n    \n    \n",
    'w': u"      \n. , , \n|/|/  \n' '   \n      \n      \n",
    '{': u".- \n ) \n<  \n ) \n'- \n   \n",
    '"': u';; \n   \n   \n   \n   \n   \n',
    '&': u"     \n,.   \n>-:, \n`-'` \n     \n     \n",
    '*': u"    \n. , \n-X- \n' ` \n    \n    \n",
    '.': u"   \n   \n,. \n`' \n   \n   \n",
    '2': u",--. \n   / \n,-'  \n`--- \n     \n     \n",
    '6': u",--. \n|__  \n|  \\ \n`--' \n     \n     \n",
    ':': u",. \n`' \n,. \n`' \n   \n   \n",
    '>': u".  \n \\ \n / \n'  \n   \n   \n",
    'B': u",-,---. \n '|___/ \n ,|   \\ \n`-^---' \n        \n        \n",
    'F': u"`.--- \n |__  \n,|    \n`'    \n      \n      \n",
    'J': u",-_/ \n'  | \n   | \n   | \n/  | \n`--' \n",
    'N': u",-,-.   \n` | |   \n  | |-. \n ,' `-' \n        \n        \n",
    'R': u".-,--. \n `|__/ \n  | \\  \n`-'  ` \n       \n       \n",
    'V': u",.   ,. \n`|  /   \n | /    \n `'     \n        \n        \n",
    'Z': u',-_/ \n  /  \n /   \n/--, \n     \n     \n',
    '^': u'   \n/\\ \n   \n   \n   \n   \n',
    'b': u".   \n|-. \n| | \n`-' \n    \n    \n",
    'f': u",_ \n|_ \n|  \n|  \n'  \n   \n",
    'j': u"   \n . \n | \n | \n | \n`' \n",
    'n': u"    \n,-. \n| | \n' ' \n    \n    \n",
    'r': u"    \n,-. \n|   \n'   \n    \n    \n",
    'v': u"     \n.  , \n| /  \n`'   \n     \n     \n",
    'z': u'    \n,_, \n /  \n\'"\' \n    \n    \n',
    '~': u",',' \n     \n     \n     \n     \n     \n",
    '!': u"/\\ \n\\/ \n,. \n`' \n   \n   \n",
    '%': u"      \n,. ,  \n`'/,. \n ' `' \n      \n      \n",
    ')': u"-.  \n  \\ \n  | \n  / \n-'  \n    \n",
    '-': u'   \n   \n-- \n   \n   \n   \n',
    '1': u"  ,  \n /|  \n' |  \n -^- \n     \n     \n",
    '5': u",--- \n|__  \n   \\ \n`--' \n     \n     \n",
    '9': u",--. \n\\__| \n   | \n`--' \n     \n     \n",
    '=': u'   \n-- \n-- \n   \n   \n   \n',
    'A': u"    ,.   \n   / |   \n  /~~|-. \n,'   `-' \n         \n         \n",
    'E': u'`.--- \n |__  \n,|    \n`^--- \n      \n      \n',
    'I': u",-_/ \n'  | \n.- | \n`--' \n     \n     \n",
    'M': u",-,-,-.   \n`,| | |   \n  | ; | . \n  '   `-' \n          \n          \n",
    'Q': u',--. \n|  | \n| \\| \n`--\\ \n     \n     \n',
    'U': u",-.  .   \n  |  |   \n  |  | . \n  `--^-' \n         \n         \n",
    'Y': u".  . \n|  | \n|  | \n`--| \n.- | \n`--' \n",
    ']': u"-. \n | \n | \n | \n-' \n   \n",
    'a': u'    \n,-. \n,-| \n`-^ \n    \n    \n',
    'e': u"    \n,-. \n|-' \n`-' \n    \n    \n",
    'i': u"  \n. \n| \n' \n  \n  \n",
    'm': u"      \n,-,-. \n| | | \n' ' ' \n      \n      \n",
    'q': u'    \n,-. \n| | \n`-| \n  | \n  ` \n',
    'u': u"    \n. . \n| | \n`-' \n    \n    \n",
    'y': u"    \n. . \n| | \n`-| \n /| \n`-' \n",
    '}': u'-, \n(  \n > \n(  \n-` \n   \n'}


stforek_dic = {
    '!': u' _  \n/ \\ \n\\_/ \n(_) \n',
    ' ': u'  \n  \n  \n  \n',
    '#': u'',
    '"': u'___ \n|// \n    \n    \n',
    '%': u' _ _  \n[// | \n / /  \n|_//] \n',
    '$': u"  ||_ \n/'__/ \n`._`. \n\\_||/ \n",
    "'": u' _  \n`.\\ \n    \n    \n',
    '&': u'  __,   \n (_ /_  \n /`X\\/ |\n`\\_/\\| |\n',
    ')': u' _   \n| \\  \n ) ) \n|_/  \n',
    '(': u'  _  \n / | \n( (  \n \\_| \n',
    '+': u'   _    \n _| |_  \n|_   _| \n  |_|   \n',
    '*': u"      \n //\\  \n`\\//' \n      \n",
    '-': u'     \n __  \n|__| \n     \n',
    ',': u'    \n    \n _, \n[_/ \n',
    '/': u'   _  \n  / | \n / /  \n|_/   \n',
    '.': u'   \n   \n__ \n\\/ \n',
    '1': u' __  \n/  | \n`7 | \n |_| \n',
    '0': u'  __   \n /  \\  \n| // | \n \\__/  \n',
    '3': u" __   \n|__`. \n |_ | \n|__.' \n",
    '2': u' ___  \n(_  | \n / /  \n|___| \n',
    '5': u" ___  \n| __| \n`._`. \n!__.' \n",
    '4': u' _  _   \n| || |  \n`._  _| \n   |_|  \n',
    '7': u' ___  \n|_  | \n / /  \n|_/   \n',
    '6': u'  ___  \n / __| \n| ,_ \\ \n \\___/ \n',
    '9': u' ___  \n/ _ \\ \n\\__ / \n /_/  \n',
    '8': u' ___  \n/ _ \\ \n) _ ( \n\\___/ \n',
    ';': u'_  \n\\| \n_] \n   \n',
    ':': u'_  \n\\| \n\\| \n   \n',
    '=': u' ____ \n)___/ \n/___( \n      \n',
    '<': u'  __ \n / / \n< <  \n`\\_\\ \n',
    '?': u'____  \n\\_  | \n /_(  \n (_)  \n',
    '>': u'__   \n\\ \\  \n > > \n/_/  \n',
    '@': u"   _    \n /.-.\\  \n( \\_(l_,\n `---'` \n",
    '[': u' ___  \n| __| \n| |_  \n|___| \n',
    ']': u' ___  \n|_  | \n _| | \n|___| \n',
    '\\': u' _    \n| \\   \n \\ \\  \n  \\_| \n',
    '_': u'       \n       \n ____  \n|____| \n',
    '^': u' /\\  \n|/\\| \n     \n     \n',
    'a': u'  __   \n /  \\  \n| /\\ | \n|_||_| \n',
    '`': u'`\n \n \n \n',
    'c': u'  ___ \n / _/ \n| \\__ \n \\__/ \n',
    'b': u' __  \n|  \\ \n| -< \n|__/ \n',
    'e': u' ___  \n| __| \n| _|  \n|___| \n',
    'd': u' __   \n| _\\  \n| v | \n|__/  \n',
    'g': u'  __  \n / _] \n| [/\\ \n \\__/ \n',
    'f': u' ___  \n| __| \n| _|  \n|_|   \n',
    'i': u' _  \n| | \n| | \n|_| \n',
    'h': u' _  _  \n| || | \n| >< | \n|_||_| \n',
    'k': u' _  __ \n| |/ / \n|   <  \n|_|\\_\\ \n',
    'j': u' __   \n|_ \\  \n _\\ | \n/___| \n',
    'm': u' __ __  \n|  V  | \n| \\_/ | \n|_| |_| \n',
    'l': u' _    \n| |   \n| |_  \n|___| \n',
    'o': u'  __   \n /__\\  \n| \\/ | \n \\__/  \n',
    'n': u" __  _  \n|  \\| | \n| | ' | \n|_|\\__| \n",
    'q': u'  __   \n /__\\  \n| \\/ | \n \\_V_\\ \n',
    'p': u' ___  \n| _,\\ \n| v_/ \n|_|   \n',
    's': u"  __  \n/' _/ \n`._`. \n|___/ \n",
    'r': u' ___  \n| _ \\ \n| v / \n|_|_\\ \n',
    'u': u' _  _  \n| || | \n| \\/ | \n \\__/  \n',
    't': u' _____  \n|_   _| \n  | |   \n  |_|   \n',
    'w': u" _   _  \n| | | | \n| 'V' | \n!_/ \\_! \n",
    'v': u" _   _  \n| \\ / | \n`\\ V /' \n  \\_/   \n",
    'y': u"__   __\n\\ `v' /\n `. .' \n  !_!  \n",
    'x': u'__   __ \n\\ \\_/ / \n > , <  \n/_/ \\_\\ \n',
    '{': u'  _  \n / | \n{ {  \n \\_| \n',
    'z': u' ___  \n|_  | \n / /  \n|___| \n',
    '}': u' _   \n| \\  \n } } \n|_/  \n',
    '|': u' _  \n| | \n| | \n|_| \n',
    '~': u'  _     \n./ \\_/| \n|/`\\_/  \n        \n'}

sub_zero_dic = {
    '!': u'',
    ' ': u'   \n   \n   \n   \n   \n   \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u' ______    \n/\\  __ \\   \n\\ \\  __ \\  \n \\ \\_\\ \\_\\ \n  \\/_/\\/_/ \n           \n',
    '`': u'',
    'c': u' ______    \n/\\  ___\\   \n\\ \\ \\____  \n \\ \\_____\\ \n  \\/_____/ \n           \n',
    'b': u' ______    \n/\\  == \\   \n\\ \\  __<   \n \\ \\_____\\ \n  \\/_____/ \n           \n',
    'e': u' ______    \n/\\  ___\\   \n\\ \\  __\\   \n \\ \\_____\\ \n  \\/_____/ \n           \n',
    'd': u' _____    \n/\\  __-.  \n\\ \\ \\/\\ \\ \n \\ \\____- \n  \\/____/ \n          \n',
    'g': u' ______    \n/\\  ___\\   \n\\ \\ \\__ \\  \n \\ \\_____\\ \n  \\/_____/ \n           \n',
    'f': u' ______  \n/\\  ___\\ \n\\ \\  __\\ \n \\ \\_\\   \n  \\/_/   \n         \n',
    'i': u' __    \n/\\ \\   \n\\ \\ \\  \n \\ \\_\\ \n  \\/_/ \n       \n',
    'h': u' __  __    \n/\\ \\_\\ \\   \n\\ \\  __ \\  \n \\ \\_\\ \\_\\ \n  \\/_/\\/_/ \n           \n',
    'k': u' __  __    \n/\\ \\/ /    \n\\ \\  _"-.  \n \\ \\_\\ \\_\\ \n  \\/_/\\/_/ \n           \n',
    'j': u'   __    \n  /\\ \\   \n _\\_\\ \\  \n/\\_____\\ \n\\/_____/ \n         \n',
    'm': u' __    __    \n/\\ "-./  \\   \n\\ \\ \\-./\\ \\  \n \\ \\_\\ \\ \\_\\ \n  \\/_/  \\/_/ \n             \n',
    'l': u' __        \n/\\ \\       \n\\ \\ \\____  \n \\ \\_____\\ \n  \\/_____/ \n           \n',
    'o': u' ______    \n/\\  __ \\   \n\\ \\ \\/\\ \\  \n \\ \\_____\\ \n  \\/_____/ \n           \n',
    'n': u' __   __    \n/\\ "-.\\ \\   \n\\ \\ \\-.  \\  \n \\ \\_\\\\"\\_\\ \n  \\/_/ \\/_/ \n            \n',
    'q': u' ______    \n/\\  __ \\   \n\\ \\ \\/\\_\\  \n \\ \\___\\_\\ \n  \\/___/_/ \n           \n',
    'p': u' ______  \n/\\  == \\ \n\\ \\  _-/ \n \\ \\_\\   \n  \\/_/   \n         \n',
    's': u' ______    \n/\\  ___\\   \n\\ \\___  \\  \n \\/\\_____\\ \n  \\/_____/ \n           \n',
    'r': u' ______    \n/\\  == \\   \n\\ \\  __<   \n \\ \\_\\ \\_\\ \n  \\/_/ /_/ \n           \n',
    'u': u' __  __    \n/\\ \\/\\ \\   \n\\ \\ \\_\\ \\  \n \\ \\_____\\ \n  \\/_____/ \n           \n',
    't': u' ______  \n/\\__  _\\ \n\\/_/\\ \\/ \n   \\ \\_\\ \n    \\/_/ \n         \n',
    'w': u' __     __    \n/\\ \\  _ \\ \\   \n\\ \\ \\/ ".\\ \\  \n \\ \\__/".~\\_\\ \n  \\/_/   \\/_/ \n              \n',
    'v': u" __   __  \n/\\ \\ / /  \n\\ \\ \\'/   \n \\ \\__|   \n  \\/_/    \n          \n",
    'y': u' __  __    \n/\\ \\_\\ \\   \n\\ \\____ \\  \n \\/\\_____\\ \n  \\/_____/ \n           \n',
    'x': u' __  __    \n/\\_\\_\\_\\   \n\\/_/\\_\\/_  \n  /\\_\\/\\_\\ \n  \\/_/\\/_/ \n           \n',
    '{': u'',
    'z': u' ______    \n/\\___  \\   \n\\/_/  /__  \n  /\\_____\\ \n  \\/_____/ \n           \n',
    '}': u'',
    '|': u'',
    '~': u''}

swampland_dic = {
    '!': u' __       \n/__/\\     \n\\.:\\ \\    \n \\::\\ \\   \n  \\__\\/_  \n    /__/\\ \n    \\__\\/ \n          \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u' ___  ___   \n/__/\\/__/\\  \n\\::\\ \\::\\ \\ \n \\:_\\/\\:_\\/ \n            \n            \n            \n            \n',
    '%': u'%\n \n \n \n \n \n \n \n',
    '$': u' \n \n \n \n \n \n \n \n',
    "'": u' ___   \n/__/\\  \n\\::\\ \\ \n \\:_\\/ \n       \n       \n       \n       \n',
    '&': u'&\n \n \n \n \n \n \n \n',
    ')': u')\n \n \n \n \n \n \n \n',
    '(': u'(\n \n \n \n \n \n \n \n',
    '+': u'+\n \n \n \n \n \n \n \n',
    '*': u'*\n \n \n \n \n \n \n \n',
    '-': u'          \n          \n _______  \n/______/\\ \n\\__::::\\/ \n          \n          \n          \n',
    ',': u'        \n        \n        \n ____   \n/___/\\  \n\\:::\\ \\ \n  \\::\\/ \n        \n',
    '/': u'/\n \n \n \n \n \n \n \n',
    '.': u'       \n       \n       \n ___   \n/__/\\  \n\\::\\ \\ \n \\:_\\/ \n       \n',
    '1': u' ____        \n/___/\\       \n\\_::\\ \\      \n  \\::\\ \\     \n  _\\: \\ \\__  \n /__\\: \\__/\\ \n \\________\\/ \n             \n',
    '0': u' ______      \n/_____/\\     \n\\:::_ \\ \\    \n \\:\\ \\ \\ \\   \n  \\:\\ \\ \\ \\  \n   \\:\\_\\ \\ \\ \n    \\_____\\/ \n             \n',
    '3': u" ______      \n/_____/\\     \n\\:::_:\\ \\    \n   /_\\:\\ \\   \n   \\::_:\\ \\  \n   /___\\:\\ ' \n   \\______/  \n             \n",
    '2': u' _____       \n/_____/\\     \n\\:::_:\\ \\    \n    _\\:\\|    \n   /::_/__   \n   \\:\\____/\\ \n    \\_____\\/ \n             \n',
    '5': u' ______     \n/_____/\\    \n\\::::_\\/_   \n \\:\\/___/\\  \n  \\_::._\\:\\ \n   /_____\\/ \n   \\_____/  \n            \n',
    '4': u' __   __       \n/__/\\/__/\\     \n\\  \\ \\: \\ \\__  \n \\::\\_\\::\\/_/\\ \n  \\_:::   __\\/ \n       \\::\\ \\  \n        \\__\\/  \n               \n',
    '7': u' _______      \n/______/\\     \n\\__::::\\ \\    \n     \\::\\ \\   \n      \\::\\ \\  \n       \\: \\ \\ \n        \\:_\\/ \n              \n',
    '6': u' ______      \n/_____/\\     \n\\:::__\\/     \n \\:\\ \\____   \n  \\::__::/\\  \n   \\:\\_\\:\\ \\ \n    \\_____\\/ \n             \n',
    '9': u' ______      \n/_____/\\     \n\\:::_:\\ \\    \n \\:\\_\\:\\ \\   \n  \\::__:\\ \\  \n       \\ \\ \\ \n        \\_\\/ \n             \n',
    '8': u' ______      \n/_____/\\     \n\\:::_:\\ \\    \n \\:\\_\\:\\ \\   \n  \\::__:\\ \\  \n   \\:\\_\\:\\ \\ \n    \\_____\\/ \n             \n',
    ';': u';\n \n \n \n \n \n \n \n',
    ':': u' ___  \n/__/\\ \n\\::\\/ \n ___  \n/__/\\ \n\\::\\/ \n      \n      \n',
    '=': u'=\n \n \n \n \n \n \n \n',
    '<': u'<\n \n \n \n \n \n \n \n',
    '?': u' ______    \n/_____/\\   \n\\__:::\\ \\  \n   /::/ /  \n   \\::\\/_  \n     /__/\\ \n     \\__\\/ \n           \n',
    '>': u'>\n \n \n \n \n \n \n \n',
    '@': u'@\n \n \n \n \n \n \n \n',
    '[': u'[\n \n \n \n \n \n \n \n',
    ']': u']\n \n \n \n \n \n \n \n',
    '\\': u'\\\n \n \n \n \n \n \n \n',
    '_': u'          \n          \n          \n          \n _______  \n/______/\\ \n\\__::::\\/ \n          \n',
    '^': u'   __   \n  /\\ \\  \n /::\\ \\ \n/:/\\_\\/ \n        \n        \n        \n        \n',
    'a': u' ________      \n/_______/\\     \n\\::: _  \\ \\    \n \\::(_)  \\ \\   \n  \\:: __  \\ \\  \n   \\:.\\ \\  \\ \\ \n    \\__\\/\\__\\/ \n               \n',
    '`': u' _____    \n/____/\\   \n\\_:::\\ \\  \n   \\ :\\ \\ \n    \\__\\/ \n          \n          \n          \n',
    'c': u' ______      \n/_____/\\     \n\\:::__\\/     \n \\:\\ \\  __   \n  \\:\\ \\/_/\\  \n   \\:\\_\\ \\ \\ \n    \\_____\\/ \n             \n',
    'b': u'  _______      \n/_______/\\     \n\\::: _  \\ \\    \n \\::(_)  \\/_   \n  \\::  _  \\ \\  \n   \\::(_)  \\ \\ \n    \\_______\\/ \n               \n',
    'e': u' ______      \n/_____/\\     \n\\::::_\\/_    \n \\:\\/___/\\   \n  \\::___\\/_  \n   \\:\\____/\\ \n    \\_____\\/ \n             \n',
    'd': u' ______      \n/_____/\\     \n\\:::_ \\ \\    \n \\:\\ \\ \\ \\   \n  \\:\\ \\ \\ \\  \n   \\:\\/.:| | \n    \\____/_/ \n             \n',
    'g': u' _______     \n/______/\\    \n\\::::__\\/__  \n \\:\\ /____/\\ \n  \\:\\\\_  _\\/ \n   \\:\\_\\ \\ \\ \n    \\_____\\/ \n             \n',
    'f': u' ______    \n/_____/\\   \n\\::::_\\/_  \n \\:\\/___/\\ \n  \\:::._\\/ \n   \\:\\ \\   \n    \\_\\/   \n           \n',
    'i': u' ________     \n/_______/\\    \n\\__.::._\\/    \n   \\::\\ \\     \n   _\\::\\ \\__  \n  /__\\::\\__/\\ \n  \\________\\/ \n              \n',
    'h': u' ___   ___     \n/__/\\ /__/\\    \n\\::\\ \\\\  \\ \\   \n \\::\\/_\\ .\\ \\  \n  \\:: ___::\\ \\ \n   \\: \\ \\\\::\\ \\\n    \\__\\/ \\::\\/\n               \n',
    'k': u' ___   ___     \n/___/\\/__/\\    \n\\::.\\ \\\\ \\ \\   \n \\:: \\/_) \\ \\  \n  \\:. __  ( (  \n   \\: \\ )  \\ \\ \n    \\__\\/\\__\\/ \n               \n',
    'j': u' _________   \n/________/\\  \n\\__.::.__\\/  \n  /_\\::\\ \\   \n  \\:.\\::\\ \\  \n   \\: \\  \\ \\ \n    \\_____\\/ \n             \n',
    'm': u' ___ __ __     \n/__//_//_/\\    \n\\::\\| \\| \\ \\   \n \\:.      \\ \\  \n  \\:.\\-/\\  \\ \\ \n   \\. \\  \\  \\ \\\n    \\__\\/ \\__\\/\n               \n',
    'l': u' __          \n/_/\\         \n\\:\\ \\        \n \\:\\ \\       \n  \\:\\ \\____  \n   \\:\\/___/\\ \n    \\_____\\/ \n             \n',
    'o': u' ______      \n/_____/\\     \n\\:::_ \\ \\    \n \\:\\ \\ \\ \\   \n  \\:\\ \\ \\ \\  \n   \\:\\_\\ \\ \\ \n    \\_____\\/ \n             \n',
    'n': u' ___   __      \n/__/\\ /__/\\    \n\\::\\_\\\\  \\ \\   \n \\:. `-\\  \\ \\  \n  \\:. _    \\ \\ \n   \\. \\`-\\  \\ \\\n    \\__\\/ \\__\\/\n               \n',
    'q': u' ______        \n/_____/\\       \n\\:::_ \\ \\      \n \\:\\ \\ \\ \\_    \n  \\:\\ \\ /_ \\   \n   \\:\\_-  \\ \\  \n    \\___|\\_\\_/ \n               \n',
    'p': u' ______    \n/_____/\\   \n\\:::_ \\ \\  \n \\:(_) \\ \\ \n  \\: ___\\/ \n   \\ \\ \\   \n    \\_\\/   \n           \n',
    's': u' ______      \n/_____/\\     \n\\::::_\\/_    \n \\:\\/___/\\   \n  \\_::._\\:\\  \n    /____\\:\\ \n    \\_____\\/ \n             \n',
    'r': u' ______       \n/_____/\\      \n\\:::_ \\ \\     \n \\:(_) ) )_   \n  \\: __ `\\ \\  \n   \\ \\ `\\ \\ \\ \n    \\_\\/ \\_\\/ \n              \n',
    'u': u' __  __      \n/_/\\/_/\\     \n\\:\\ \\:\\ \\    \n \\:\\ \\:\\ \\   \n  \\:\\ \\:\\ \\  \n   \\:\\_\\:\\ \\ \n    \\_____\\/ \n             \n',
    't': u' _________  \n/________/\\ \n\\__.::.__\\/ \n   \\::\\ \\   \n    \\::\\ \\  \n     \\::\\ \\ \n      \\__\\/ \n            \n',
    'w': u' __ __ __      \n/_//_//_/\\     \n\\:\\\\:\\\\:\\ \\    \n \\:\\\\:\\\\:\\ \\   \n  \\:\\\\:\\\\:\\ \\  \n   \\:\\\\:\\\\:\\ \\ \n    \\_______\\/ \n               \n',
    'v': u' __   __     \n/_/\\ /_/\\    \n\\:\\ \\\\ \\ \\   \n \\:\\ \\\\ \\ \\  \n  \\:\\_/.:\\ \\ \n   \\ ..::/ / \n    \\___/_(  \n             \n',
    'y': u' __  __    \n/_/\\/_/\\   \n\\ \\ \\ \\ \\  \n \\:\\_\\ \\ \\ \n  \\::::_\\/ \n    \\::\\ \\ \n     \\__\\/ \n           \n',
    'x': u' __     __     \n/__/\\ /__/\\    \n\\ \\::\\\\:.\\ \\   \n \\_\\::_\\:_\\/   \n   _\\/__\\_\\_/\\ \n   \\ \\ \\ \\::\\ \\\n    \\_\\/  \\__\\/\n               \n',
    '{': u'   _____  \n  /____/\\ \n _\\:::_\\/ \n/____/\\   \n\\::__\\/_  \n  | ___/\\ \n   \\::_\\/ \n          \n',
    'z': u' ______     \n/_____/\\    \n\\:::__\\/    \n   /: /     \n  /::/___   \n /_:/____/\\ \n \\_______\\/ \n            \n',
    '}': u' _____      \n/____/\\     \n\\_:::\\ \\__  \n    /____/\\ \n   _\\__::\\/ \n  /___/ |   \n  \\_::\\/    \n            \n',
    '|': u'|\n \n \n \n \n \n \n \n',
    '~': u'/""--__    \n\\"::-__/\\  \n \\ ::: \\ \\ \n  ""-::_\\/ \n           \n           \n           \n           \n'}

sweet_dic = {
    '!': u" ___  \n(   ) \n | |  \n | |  \n | |  \n | |  \n | |  \n | |  \n |_|  \n .-.  \n(   ) \n '-'  \n      \n",
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u".--. .--. \n|  | |  | \n'..' '..' \n          \n          \n          \n          \n          \n          \n          \n          \n          \n          \n",
    '%': u'%\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '$': u' \n \n \n \n \n \n \n \n \n \n \n \n \n',
    "'": u".--. \n|  | \n'..' \n     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n",
    '&': u'&\n \n \n \n \n \n \n \n \n \n \n \n \n',
    ')': u"         \n    .-.  \n  / .  \\ \n(___). | \n     | | \n     | | \n     | | \n     | | \n     | | \n ___ ' | \n(   )' ' \n '.__.'  \n         \n",
    '(': u'         \n .-.     \n/  . \\   \n| .(___) \n| |      \n| |      \n| |      \n| |      \n| |      \n| ` ___  \n` `(   ) \n `.__.`  \n         \n',
    '+': u"            \n            \n    .-.     \n    | |     \n.---| |---. \n'---| |---` \n    | |     \n    '-'     \n            \n            \n            \n            \n            \n",
    '*': u'*\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '-': u'            \n            \n            \n            \n  .------.  \n (________) \n            \n            \n            \n            \n            \n            \n            \n',
    ',': u'       \n       \n       \n       \n       \n       \n       \n       \n ,-.   \n(   \\  \n `.__) \n       \n       \n',
    '/': u'/\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '.': u"      \n      \n      \n      \n      \n      \n      \n      \n .-.  \n(   ) \n `-'  \n      \n      \n",
    '1': u'       \n       \n .--.  \n(_  |  \n  | |  \n  | |  \n  | |  \n  | |  \n  | |  \n  | |  \n (___) \n       \n       \n',
    '0': u"         \n         \n   .-.   \n /    \\  \n|  .-. ; \n| |  | | \n| |  | | \n| |  | | \n| '  | | \n'  `-' / \n `.__,'  \n         \n         \n",
    '3': u"          \n          \n   .--.   \n /     \\  \n(___)`. | \n   .-' /  \n   '. \\   \n ___ \\ '  \n(   ) ; | \n \\ `-'  / \n  ',__.'  \n          \n          \n",
    '2': u"          \n          \n  .--.    \n ;  _  \\  \n(___)` |  \n     ' '  \n    / /   \n   / /    \n  / /     \n / '____  \n(_______) \n          \n          \n",
    '5': u"          \n          \n,-----.   \n|   ___)  \n|  |      \n|  '-.    \n'---.  .  \n ___ `  \\ \n(   ) | | \n ; `-'  / \n  '.__.'  \n          \n          \n",
    '4': u"            \n            \n     ,--.   \n    /   |   \n   / .' |   \n  / / | |   \n / /  | |   \n/  `--' |-. \n`-----| |-' \n      | |   \n     (___)  \n            \n            \n",
    '7': u'         \n         \n .----.  \n(___  |  \n    | |  \n    | |  \n    | |  \n    | |  \n    | |  \n    | |  \n   (___) \n         \n         \n',
    '6': u"         \n         \n  .--.   \n / ,  ;  \n| .(___) \n| | _    \n| '` `.  \n| .-,  . \n| |  | | \n. `-'  ; \n '.__.'  \n         \n         \n",
    '9': u"         \n         \n  .--.   \n /    \\  \n;  ,-. ' \n| |  | | \n'  `-' | \n `.__. | \n ___ | | \n(   )' / \n `,__.'  \n         \n         \n",
    '8': u"          \n          \n   .--.   \n /  _  \\  \n. .' `. ; \n| \\   | | \n \\ `.(_.' \n /`'. '.  \n| |  `\\ | \n; '._,' ' \n '.___.'  \n          \n          \n",
    ';': u"       \n       \n       \n       \n .-.   \n(   )  \n `-'   \n ,-.   \n(   \\  \n `.__) \n       \n       \n       \n",
    ':': u"      \n      \n      \n      \n .-.  \n(   ) \n `-'  \n .-.  \n(   ) \n `-'  \n      \n      \n      \n",
    '=': u'=\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '<': u'<\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '?': u"               \n   .---.       \n  /  _   \\    (\n | |   `. .    \n(___)   | |    \n     .-'_/     \n     | |       \n     |_|       \n               \n     .-.       \n    (   )      \n     `-'       \n               \n",
    '>': u'>\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '@': u'@\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '[': u'[\n \n \n \n \n \n \n \n \n \n \n \n \n',
    ']': u']\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '\\': u'\\\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '_': u'_\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '^': u"  ,--.    \n /    \\   \n__.'`.__) \n          \n          \n          \n          \n          \n          \n          \n          \n          \n          \n",
    'a': u"         \n         \n  .---.  \n / .-, \\ \n(__) ; | \n  .'`  | \n / .'| | \n| /  | | \n; |  ; | \n' `-'  | \n`.__.'_. \n         \n         \n",
    '`': u' ,-.   \n(   \\  \n `.__) \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n',
    'c': u"          \n          \n  .--.    \n /    \\   \n|  .-. ;  \n|  |(___) \n|  |      \n|  | ___  \n|  '(   ) \n'  `-' |  \n `.__,'   \n          \n          \n",
    'b': u" ___      \n(   )     \n | |.-.   \n | /   \\  \n |  .-. | \n | |  | | \n | |  | | \n | |  | | \n | '  | | \n ' `-' ;  \n  `.__.   \n          \n          \n",
    'e': u"         \n         \n  .--.   \n /    \\  \n|  .-. ; \n|  | | | \n|  |/  | \n|  ' _.' \n|  .'.-. \n'  `-' / \n `.__.'  \n         \n         \n",
    'd': u"     ___  \n    (   ) \n  .-.| |  \n /   \\ |  \n|  .-. |  \n| |  | |  \n| |  | |  \n| |  | |  \n| '  | |  \n' `-'  /  \n `.__,'   \n          \n          \n",
    'g': u"         \n         \n  .--.   \n /    \\  \n;  ,-. ' \n| |  | | \n| |  | | \n| |  | | \n| '  | | \n'  `-' | \n `.__. | \n ( `-' ; \n  `.__.  \n",
    'f': u'  .-.     \n /    \\   \n | .`. ;  \n | |(___) \n | |_     \n(   __)   \n | |      \n | |      \n | |      \n | |      \n(___)     \n          \n          \n',
    'i': u'      \n .-.  \n( __) \n(\'\'") \n | |  \n | |  \n | |  \n | |  \n | |  \n | |  \n(___) \n      \n      \n',
    'h': u' ___       \n(   )      \n | | .-.   \n | |/   \\  \n |  .-. .  \n | |  | |  \n | |  | |  \n | |  | |  \n | |  | |  \n | |  | |  \n(___)(___) \n           \n           \n',
    'k': u" ___         \n(   )        \n | |   ___   \n | |  (   )  \n | |  ' /    \n | |,' /     \n | .  '.     \n | | `. \\    \n | |   \\ \\   \n | |    \\ .  \n(___ ) (___) \n             \n             \n",
    'j': u'          \n          \n     .-.  \n    ( __) \n    (\'\'") \n     | |  \n     | |  \n     | |  \n     | |  \n ___ | |  \n(   )\' |  \n ; `-\' \'  \n  .__.\'   \n',
    'm': u"               \n               \n ___ .-. .-.   \n(   )   '   \\  \n |  .-.  .-. ; \n | |  | |  | | \n | |  | |  | | \n | |  | |  | | \n | |  | |  | | \n | |  | |  | | \n(___)(___)(___)\n               \n               \n",
    'l': u' ___  \n(   ) \n | |  \n | |  \n | |  \n | |  \n | |  \n | |  \n | |  \n | |  \n(___) \n      \n      \n',
    'o': u"         \n         \n  .--.   \n /    \\  \n|  .-. ; \n| |  | | \n| |  | | \n| |  | | \n| '  | | \n'  `-' / \n `.__.'  \n         \n         \n",
    'n': u'           \n           \n ___ .-.   \n(   )   \\  \n |  .-. .  \n | |  | |  \n | |  | |  \n | |  | |  \n | |  | |  \n | |  | |  \n(___)(___) \n           \n           \n',
    'q': u"          \n          \n  .--.    \n /    \\   \n|  .-. '  \n| |  | |  \n| |  | |  \n| |  | |  \n| '  | |  \n' `-'  |  \n `._ / |  \n     | |  \n    (___) \n",
    'p': u"          \n          \n   .-..   \n  /    \\  \n ' .-,  ; \n | |  . | \n | |  | | \n | |  | | \n | |  ' | \n | `-'  ' \n | \\__.'  \n | |      \n(___)     \n",
    's': u"            \n            \n    .--.    \n  /  _  \\   \n . .' `. ;  \n | '   | |  \n _\\_`.(___) \n(   ). '.   \n | |  `\\ |  \n ; '._,' '  \n  '.___.'   \n            \n            \n",
    'r': u"            \n            \n ___ .-.    \n(   )   \\   \n | ' .-. ;  \n |  / (___) \n | |        \n | |        \n | |        \n | |        \n(___)       \n            \n            \n",
    'u': u"           \n           \n ___  ___  \n(   )(   ) \n | |  | |  \n | |  | |  \n | |  | |  \n | |  | |  \n | |  ; '  \n ' `-'  /  \n  '.__.'   \n           \n           \n",
    't': u" ___      \n(   )     \n | |_     \n(   __)   \n | |      \n | | ___  \n | |(   ) \n | | | |  \n | ' | |  \n ' `-' ;  \n  `.__.   \n          \n          \n",
    'w': u"               \n               \n ___  ___  ___ \n(   )(   )(   )\n | |  | |  | | \n | |  | |  | | \n | |  | |  | | \n | |  | |  | | \n | |  ; '  | | \n ' `-'   `-' ' \n  '.__.'.__.'  \n               \n               \n",
    'v': u"           \n           \n ___  ___  \n(   )(   ) \n | |  | |  \n | |  | |  \n | |  | |  \n | |  | |  \n ' '  ; '  \n  \\ `' /   \n   '_.'    \n           \n           \n",
    'y': u"           \n           \n ___  ___  \n(   )(   ) \n | |  | |  \n | |  | |  \n | '  | |  \n '  `-' |  \n  `.__. |  \n  ___ | |  \n (   )' |  \n  ; `-' '  \n   .__.'   \n",
    'x': u"           \n           \n ___  ___  \n(   )(   ) \n | |  | |  \n  \\ `' /   \n  / ,. \\   \n ' .  ; .  \n | |  | |  \n | |  | |  \n(___)(___) \n           \n           \n",
    '{': u'{\n \n \n \n \n \n \n \n \n \n \n \n \n',
    'z': u"           \n           \n   .--.    \n  /    \\   \n .  .-. |  \n | |  | |  \n | |  | |  \n(___)-` /  \n    '. \\   \n  ___ \\ '  \n (   ) ; | \n  \\ `-'  / \n   ',__.'  \n",
    '}': u'}\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '|': u'|\n \n \n \n \n \n \n \n \n \n \n \n \n',
    '~': u'~\n \n \n \n \n \n \n \n \n \n \n \n \n'}

ticks_dic = {
    ' ': u'____\n____\n____\n____\n____\n____\n',
    '$': u'_____/\\/\\_____\n___/\\/\\/\\/\\/\\_\n_/\\/\\/\\/\\_____\n_____/\\/\\/\\/\\_\n_/\\/\\/\\/\\/\\___\n_____/\\/\\_____\n',
    '(': u'___/\\/\\/\\_\n_/\\/\\/\\___\n_/\\/\\_____\n_/\\/\\/\\___\n___/\\/\\/\\_\n__________\n',
    ',': u'______\n______\n______\n_/\\/\\_\n_/\\/\\_\n_/\\___\n',
    '0': u'___/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\__/\\/\\/\\_\n_/\\/\\/\\__/\\/\\_\n___/\\/\\/\\/\\___\n______________\n',
    '4': u'_____/\\/\\/\\___\n___/\\/\\/\\/\\___\n_/\\/\\__/\\/\\___\n_/\\/\\/\\/\\/\\/\\_\n_______/\\/\\___\n______________\n',
    '8': u'___/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n______________\n',
    '<': u'_____/\\/\\_\n___/\\/\\___\n_/\\/\\_____\n___/\\/\\___\n_____/\\/\\_\n__________\n',
    '@': u'___/\\/\\/\\/\\___\n_/\\/\\__/\\/\\/\\_\n_/\\/\\__/\\/\\/\\_\n_/\\/\\_________\n___/\\/\\/\\/\\___\n______________\n',
    'D': u'_/\\/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\/\\/\\/\\___\n______________\n',
    'H': u'_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\/\\/\\/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n______________\n',
    'L': u'_/\\/\\_______\n_/\\/\\_______\n_/\\/\\_______\n_/\\/\\_______\n_/\\/\\/\\/\\/\\_\n____________\n',
    'P': u'_/\\/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\/\\/\\/\\___\n_/\\/\\_________\n_/\\/\\_________\n______________\n',
    'T': u'_/\\/\\/\\/\\/\\/\\_\n_____/\\/\\_____\n_____/\\/\\_____\n_____/\\/\\_____\n_____/\\/\\_____\n______________\n',
    'X': u'_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n_____/\\/\\_____\n___/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n______________\n',
    '\\': u'_/\\/\\_________\n___/\\/\\_______\n_____/\\/\\_____\n_______/\\/\\___\n_________/\\/\\_\n______________\n',
    '`': u'_/\\/\\_\n_/\\/\\_\n___/\\_\n______\n______\n______\n',
    'd': u'_______/\\/\\_\n_______/\\/\\_\n___/\\/\\/\\/\\_\n_/\\/\\__/\\/\\_\n___/\\/\\/\\/\\_\n____________\n',
    'h': u'_/\\/\\_______\n_/\\/\\_______\n_/\\/\\/\\/\\___\n_/\\/\\__/\\/\\_\n_/\\/\\__/\\/\\_\n____________\n',
    'l': u'_/\\/\\___\n_/\\/\\___\n_/\\/\\___\n_/\\/\\___\n_/\\/\\/\\_\n________\n',
    'p': u'____________\n_/\\/\\/\\/\\___\n_/\\/\\__/\\/\\_\n_/\\/\\/\\/\\___\n_/\\/\\_______\n_/\\/\\_______\n',
    't': u'___/\\/\\_____\n_/\\/\\/\\/\\/\\_\n___/\\/\\_____\n___/\\/\\_____\n___/\\/\\/\\___\n____________\n',
    'x': u'____________\n_/\\/\\__/\\/\\_\n___/\\/\\/\\___\n___/\\/\\/\\___\n_/\\/\\__/\\/\\_\n____________\n',
    '|': u'_/\\/\\_\n_/\\/\\_\n_/\\/\\_\n_/\\/\\_\n_/\\/\\_\n_/\\/\\_\n',
    '#': u'___/\\/\\__/\\/\\___\n_/\\/\\/\\/\\/\\/\\/\\_\n___/\\/\\__/\\/\\___\n_/\\/\\/\\/\\/\\/\\/\\_\n___/\\/\\__/\\/\\___\n________________\n',
    "'": u'_/\\/\\_\n_/\\/\\_\n_/\\___\n______\n______\n______\n',
    '+': u'______________\n_____/\\/\\_____\n_/\\/\\/\\/\\/\\/\\_\n_____/\\/\\_____\n______________\n______________\n',
    '/': u'_________/\\/\\_\n_______/\\/\\___\n_____/\\/\\_____\n___/\\/\\_______\n_/\\/\\_________\n______________\n',
    '3': u'_/\\/\\/\\/\\/\\___\n_________/\\/\\_\n___/\\/\\/\\/\\___\n_________/\\/\\_\n_/\\/\\/\\/\\/\\___\n______________\n',
    '7': u'_/\\/\\/\\/\\/\\/\\_\n_______/\\/\\___\n_____/\\/\\_____\n___/\\/\\_______\n_/\\/\\_________\n______________\n',
    ';': u'_/\\/\\_\n_/\\/\\_\n______\n_/\\/\\_\n_/\\/\\_\n_/\\___\n',
    '?': u'_/\\/\\/\\/\\/\\___\n_________/\\/\\_\n_____/\\/\\/\\___\n______________\n_____/\\/\\_____\n______________\n',
    'C': u'___/\\/\\/\\/\\/\\_\n_/\\/\\_________\n_/\\/\\_________\n_/\\/\\_________\n___/\\/\\/\\/\\/\\_\n______________\n',
    'G': u'___/\\/\\/\\/\\/\\_\n_/\\/\\_________\n_/\\/\\__/\\/\\/\\_\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\/\\_\n______________\n',
    'K': u'_/\\/\\____/\\/\\_\n_/\\/\\__/\\/\\___\n_/\\/\\/\\/\\_____\n_/\\/\\__/\\/\\___\n_/\\/\\____/\\/\\_\n______________\n',
    'O': u'___/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n______________\n',
    'S': u'___/\\/\\/\\/\\/\\_\n_/\\/\\_________\n___/\\/\\/\\/\\___\n_________/\\/\\_\n_/\\/\\/\\/\\/\\___\n______________\n',
    'W': u'_/\\/\\______/\\/\\_\n_/\\/\\__/\\__/\\/\\_\n_/\\/\\/\\/\\/\\/\\/\\_\n_/\\/\\/\\__/\\/\\/\\_\n_/\\/\\______/\\/\\_\n________________\n',
    '[': u'_/\\/\\/\\/\\_\n_/\\/\\_____\n_/\\/\\_____\n_/\\/\\_____\n_/\\/\\/\\/\\_\n__________\n',
    '_': u'______________\n______________\n______________\n______________\n______________\n_/\\/\\/\\/\\/\\/\\_\n',
    'c': u'____________\n___/\\/\\/\\/\\_\n_/\\/\\_______\n_/\\/\\_______\n___/\\/\\/\\/\\_\n____________\n',
    'g': u'____________\n___/\\/\\/\\/\\_\n_/\\/\\__/\\/\\_\n___/\\/\\/\\/\\_\n_______/\\/\\_\n_/\\/\\/\\/\\___\n',
    'k': u'_/\\/\\_______\n_/\\/\\__/\\/\\_\n_/\\/\\/\\/\\___\n_/\\/\\/\\/\\___\n_/\\/\\__/\\/\\_\n____________\n',
    'o': u'____________\n___/\\/\\/\\___\n_/\\/\\__/\\/\\_\n_/\\/\\__/\\/\\_\n___/\\/\\/\\___\n____________\n',
    's': u'____________\n___/\\/\\/\\/\\_\n_/\\/\\/\\/\\___\n_______/\\/\\_\n_/\\/\\/\\/\\___\n____________\n',
    'w': u'________________\n_/\\/\\______/\\/\\_\n_/\\/\\__/\\__/\\/\\_\n_/\\/\\/\\/\\/\\/\\/\\_\n___/\\/\\__/\\/\\___\n________________\n',
    '{': u'___/\\/\\/\\/\\_\n___/\\/\\_____\n_/\\/\\_______\n___/\\/\\_____\n___/\\/\\/\\/\\_\n____________\n',
    '"': u'_/\\/\\/\\/\\_\n_/\\/\\/\\/\\_\n_/\\__/\\___\n__________\n__________\n__________\n',
    '&': u'_____/\\/\\_______\n_____/\\/\\_______\n___/\\/\\/\\__/\\/\\_\n_/\\/\\____/\\/\\___\n___/\\/\\/\\__/\\/\\_\n________________\n',
    '*': u'___/\\/\\__/\\/\\___\n_____/\\/\\/\\_____\n_/\\/\\/\\/\\/\\/\\/\\_\n_____/\\/\\/\\_____\n___/\\/\\__/\\/\\___\n________________\n',
    '.': u'______\n______\n______\n_/\\/\\_\n_/\\/\\_\n______\n',
    '2': u'_/\\/\\/\\/\\/\\___\n_________/\\/\\_\n___/\\/\\/\\/\\___\n_/\\/\\_________\n_/\\/\\/\\/\\/\\/\\_\n______________\n',
    '6': u'___/\\/\\/\\/\\___\n_/\\/\\_________\n_/\\/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n______________\n',
    ':': u'_/\\/\\_\n_/\\/\\_\n______\n_/\\/\\_\n_/\\/\\_\n______\n',
    '>': u'_/\\/\\_____\n___/\\/\\___\n_____/\\/\\_\n___/\\/\\___\n_/\\/\\_____\n__________\n',
    'B': u'_/\\/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\/\\/\\/\\___\n______________\n',
    'F': u'_/\\/\\/\\/\\/\\/\\_\n_/\\/\\_________\n_/\\/\\/\\/\\/\\___\n_/\\/\\_________\n_/\\/\\_________\n______________\n',
    'J': u'_________/\\/\\_\n_________/\\/\\_\n_________/\\/\\_\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n______________\n',
    'N': u'_/\\/\\____/\\/\\_\n_/\\/\\/\\__/\\/\\_\n_/\\/\\/\\/\\/\\/\\_\n_/\\/\\__/\\/\\/\\_\n_/\\/\\____/\\/\\_\n______________\n',
    'R': u'_/\\/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\/\\/\\/\\___\n_/\\/\\__/\\/\\___\n_/\\/\\____/\\/\\_\n______________\n',
    'V': u'_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n_____/\\/\\_____\n______________\n',
    'Z': u'_/\\/\\/\\/\\/\\/\\_\n_______/\\/\\___\n_____/\\/\\_____\n___/\\/\\_______\n_/\\/\\/\\/\\/\\/\\_\n______________\n',
    '^': u'___/\\/\\___\n_/\\/\\/\\/\\_\n_/\\____/\\_\n__________\n__________\n__________\n',
    'b': u'_/\\/\\_______\n_/\\/\\_______\n_/\\/\\/\\/\\___\n_/\\/\\__/\\/\\_\n_/\\/\\/\\/\\___\n____________\n',
    'f': u'___/\\/\\/\\_\n_/\\/\\_____\n_/\\/\\/\\___\n_/\\/\\_____\n_/\\/\\_____\n__________\n',
    'j': u'_____/\\/\\_\n__________\n_____/\\/\\_\n_____/\\/\\_\n_____/\\/\\_\n_/\\/\\/\\___\n',
    'n': u'____________\n_/\\/\\/\\/\\___\n_/\\/\\__/\\/\\_\n_/\\/\\__/\\/\\_\n_/\\/\\__/\\/\\_\n____________\n',
    'r': u'____________\n_/\\/\\__/\\/\\_\n_/\\/\\/\\/\\___\n_/\\/\\_______\n_/\\/\\_______\n____________\n',
    'v': u'____________\n_/\\/\\__/\\/\\_\n_/\\/\\__/\\/\\_\n___/\\/\\/\\___\n_____/\\_____\n____________\n',
    'z': u'____________\n_/\\/\\/\\/\\/\\_\n_____/\\/\\___\n___/\\/\\_____\n_/\\/\\/\\/\\/\\_\n____________\n',
    '~': u'___/\\/\\__/\\/\\_\n_/\\/\\/\\/\\/\\/\\_\n_/\\/\\__/\\/\\___\n______________\n______________\n______________\n',
    '!': u'_/\\/\\_\n_/\\/\\_\n_/\\/\\_\n______\n_/\\/\\_\n______\n',
    '%': u'_/\\/\\____/\\/\\_\n_/\\/\\__/\\/\\___\n_____/\\/\\_____\n___/\\/\\__/\\/\\_\n_/\\/\\____/\\/\\_\n______________\n',
    ')': u'_/\\/\\/\\___\n___/\\/\\/\\_\n_____/\\/\\_\n___/\\/\\/\\_\n_/\\/\\/\\___\n__________\n',
    '-': u'__________\n__________\n_/\\/\\/\\/\\_\n__________\n__________\n__________\n',
    '1': u'___/\\/\\_\n_/\\/\\/\\_\n___/\\/\\_\n___/\\/\\_\n___/\\/\\_\n________\n',
    '5': u'_/\\/\\/\\/\\/\\/\\_\n_/\\/\\_________\n_/\\/\\/\\/\\/\\___\n_________/\\/\\_\n_/\\/\\/\\/\\/\\___\n______________\n',
    '9': u'___/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\/\\_\n_________/\\/\\_\n___/\\/\\/\\/\\___\n______________\n',
    '=': u'__________\n_/\\/\\/\\/\\_\n__________\n_/\\/\\/\\/\\_\n__________\n__________\n',
    'A': u'_____/\\/\\_____\n___/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\/\\/\\/\\/\\_\n_/\\/\\____/\\/\\_\n______________\n',
    'E': u'_/\\/\\/\\/\\/\\/\\_\n_/\\___________\n_/\\/\\/\\/\\/\\___\n_/\\/\\_________\n_/\\/\\/\\/\\/\\/\\_\n______________\n',
    'I': u'_/\\/\\/\\/\\_\n___/\\/\\___\n___/\\/\\___\n___/\\/\\___\n_/\\/\\/\\/\\_\n__________\n',
    'M': u'_/\\/\\______/\\/\\_\n_/\\/\\/\\__/\\/\\/\\_\n_/\\/\\/\\/\\/\\/\\/\\_\n_/\\/\\__/\\__/\\/\\_\n_/\\/\\______/\\/\\_\n________________\n',
    'Q': u'___/\\/\\/\\/\\___\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\__/\\/\\___\n___/\\/\\/\\/\\/\\_\n______________\n',
    'U': u'_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n______________\n',
    'Y': u'_/\\/\\____/\\/\\_\n_/\\/\\____/\\/\\_\n___/\\/\\/\\/\\___\n_____/\\/\\_____\n_____/\\/\\_____\n______________\n',
    ']': u'_/\\/\\/\\/\\_\n_____/\\/\\_\n_____/\\/\\_\n_____/\\/\\_\n_/\\/\\/\\/\\_\n__________\n',
    'a': u'____________\n_/\\/\\/\\_____\n_____/\\/\\___\n_/\\/\\/\\/\\___\n_/\\/\\/\\/\\/\\_\n____________\n',
    'e': u'____________\n___/\\/\\/\\___\n_/\\/\\/\\/\\/\\_\n_/\\/\\_______\n___/\\/\\/\\/\\_\n____________\n',
    'i': u'_/\\/\\___\n________\n_/\\/\\___\n_/\\/\\___\n_/\\/\\/\\_\n________\n',
    'm': u'________________\n_/\\/\\/\\__/\\/\\___\n_/\\/\\/\\/\\/\\/\\/\\_\n_/\\/\\__/\\__/\\/\\_\n_/\\/\\______/\\/\\_\n________________\n',
    'q': u'____________\n___/\\/\\/\\/\\_\n_/\\/\\__/\\/\\_\n___/\\/\\/\\/\\_\n_______/\\/\\_\n_______/\\/\\_\n',
    'u': u'____________\n_/\\/\\__/\\/\\_\n_/\\/\\__/\\/\\_\n_/\\/\\__/\\/\\_\n___/\\/\\/\\/\\_\n____________\n',
    'y': u'____________\n_/\\/\\__/\\/\\_\n_/\\/\\__/\\/\\_\n___/\\/\\/\\/\\_\n_______/\\/\\_\n_/\\/\\/\\/\\___\n',
    '}': u'_/\\/\\/\\/\\___\n_____/\\/\\___\n_______/\\/\\_\n_____/\\/\\___\n_/\\/\\/\\/\\___\n____________\n'}

ticksslant_dic = {
    ' ': u'     ____\n    ____ \n   ____  \n  ____   \n ____    \n____     \n',
    '$': u'     _____/\\/\\_____\n    ___/\\/\\/\\/\\/\\_ \n   _/\\/\\/\\/\\_____  \n  _____/\\/\\/\\/\\_   \n _/\\/\\/\\/\\/\\___    \n_____/\\/\\_____     \n',
    '(': u'     ___/\\/\\/\\_\n    _/\\/\\/\\___ \n   _/\\/\\_____  \n  _/\\/\\/\\___   \n ___/\\/\\/\\_    \n__________     \n',
    ',': u'     ______\n    ______ \n   ______  \n  _/\\/\\_   \n _/\\/\\_    \n_/\\___     \n',
    '0': u'     ___/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   _/\\/\\__/\\/\\/\\_  \n  _/\\/\\/\\__/\\/\\_   \n ___/\\/\\/\\/\\___    \n______________     \n',
    '4': u'     _____/\\/\\/\\___\n    ___/\\/\\/\\/\\___ \n   _/\\/\\__/\\/\\___  \n  _/\\/\\/\\/\\/\\/\\_   \n _______/\\/\\___    \n______________     \n',
    '8': u'     ___/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   ___/\\/\\/\\/\\___  \n  _/\\/\\____/\\/\\_   \n ___/\\/\\/\\/\\___    \n______________     \n',
    '<': u'     _____/\\/\\_\n    ___/\\/\\___ \n   _/\\/\\_____  \n  ___/\\/\\___   \n _____/\\/\\_    \n__________     \n',
    '@': u'     ___/\\/\\/\\/\\___\n    _/\\/\\__/\\/\\/\\_ \n   _/\\/\\__/\\/\\/\\_  \n  _/\\/\\_________   \n ___/\\/\\/\\/\\___    \n______________     \n',
    'D': u'     _/\\/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   _/\\/\\____/\\/\\_  \n  _/\\/\\____/\\/\\_   \n _/\\/\\/\\/\\/\\___    \n______________     \n',
    'H': u'     _/\\/\\____/\\/\\_\n    _/\\/\\____/\\/\\_ \n   _/\\/\\/\\/\\/\\/\\_  \n  _/\\/\\____/\\/\\_   \n _/\\/\\____/\\/\\_    \n______________     \n',
    'L': u'     _/\\/\\_______\n    _/\\/\\_______ \n   _/\\/\\_______  \n  _/\\/\\_______   \n _/\\/\\/\\/\\/\\_    \n____________     \n',
    'P': u'     _/\\/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   _/\\/\\/\\/\\/\\___  \n  _/\\/\\_________   \n _/\\/\\_________    \n______________     \n',
    'T': u'     _/\\/\\/\\/\\/\\/\\_\n    _____/\\/\\_____ \n   _____/\\/\\_____  \n  _____/\\/\\_____   \n _____/\\/\\_____    \n______________     \n',
    'X': u'     _/\\/\\____/\\/\\_\n    ___/\\/\\/\\/\\___ \n   _____/\\/\\_____  \n  ___/\\/\\/\\/\\___   \n _/\\/\\____/\\/\\_    \n______________     \n',
    '\\': u'     _/\\/\\_________\n    ___/\\/\\_______ \n   _____/\\/\\_____  \n  _______/\\/\\___   \n _________/\\/\\_    \n______________     \n',
    '`': u'     _/\\/\\_\n    _/\\/\\_ \n   ___/\\_  \n  ______   \n ______    \n______     \n',
    'd': u'     _______/\\/\\_\n    _______/\\/\\_ \n   ___/\\/\\/\\/\\_  \n  _/\\/\\__/\\/\\_   \n ___/\\/\\/\\/\\_    \n____________     \n',
    'h': u'     _/\\/\\_______\n    _/\\/\\_______ \n   _/\\/\\/\\/\\___  \n  _/\\/\\__/\\/\\_   \n _/\\/\\__/\\/\\_    \n____________     \n',
    'l': u'     _/\\/\\___\n    _/\\/\\___ \n   _/\\/\\___  \n  _/\\/\\___   \n _/\\/\\/\\_    \n________     \n',
    'p': u'     ____________\n    _/\\/\\/\\/\\___ \n   _/\\/\\__/\\/\\_  \n  _/\\/\\/\\/\\___   \n _/\\/\\_______    \n_/\\/\\_______     \n',
    't': u'     ___/\\/\\_____\n    _/\\/\\/\\/\\/\\_ \n   ___/\\/\\_____  \n  ___/\\/\\_____   \n ___/\\/\\/\\___    \n____________     \n',
    'x': u'     ____________\n    _/\\/\\__/\\/\\_ \n   ___/\\/\\/\\___  \n  ___/\\/\\/\\___   \n _/\\/\\__/\\/\\_    \n____________     \n',
    '|': u'     _/\\/\\_\n    _/\\/\\_ \n   _/\\/\\_  \n  _/\\/\\_   \n _/\\/\\_    \n_/\\/\\_     \n',
    '#': u'     ___/\\/\\__/\\/\\___\n    _/\\/\\/\\/\\/\\/\\/\\_ \n   ___/\\/\\__/\\/\\___  \n  _/\\/\\/\\/\\/\\/\\/\\_   \n ___/\\/\\__/\\/\\___    \n________________     \n',
    "'": u'     _/\\/\\_\n    _/\\/\\_ \n   _/\\___  \n  ______   \n ______    \n______     \n',
    '+': u'     ______________\n    _____/\\/\\_____ \n   _/\\/\\/\\/\\/\\/\\_  \n  _____/\\/\\_____   \n ______________    \n______________     \n',
    '/': u'     _________/\\/\\_\n    _______/\\/\\___ \n   _____/\\/\\_____  \n  ___/\\/\\_______   \n _/\\/\\_________    \n______________     \n',
    '3': u'     _/\\/\\/\\/\\/\\___\n    _________/\\/\\_ \n   ___/\\/\\/\\/\\___  \n  _________/\\/\\_   \n _/\\/\\/\\/\\/\\___    \n______________     \n',
    '7': u'     _/\\/\\/\\/\\/\\/\\_\n    _______/\\/\\___ \n   _____/\\/\\_____  \n  ___/\\/\\_______   \n _/\\/\\_________    \n______________     \n',
    ';': u'     _/\\/\\_\n    _/\\/\\_ \n   ______  \n  _/\\/\\_   \n _/\\/\\_    \n_/\\___     \n',
    '?': u'     _/\\/\\/\\/\\/\\___\n    _________/\\/\\_ \n   _____/\\/\\/\\___  \n  ______________   \n _____/\\/\\_____    \n______________     \n',
    'C': u'     ___/\\/\\/\\/\\/\\_\n    _/\\/\\_________ \n   _/\\/\\_________  \n  _/\\/\\_________   \n ___/\\/\\/\\/\\/\\_    \n______________     \n',
    'G': u'     ___/\\/\\/\\/\\/\\_\n    _/\\/\\_________ \n   _/\\/\\__/\\/\\/\\_  \n  _/\\/\\____/\\/\\_   \n ___/\\/\\/\\/\\/\\_    \n______________     \n',
    'K': u'     _/\\/\\____/\\/\\_\n    _/\\/\\__/\\/\\___ \n   _/\\/\\/\\/\\_____  \n  _/\\/\\__/\\/\\___   \n _/\\/\\____/\\/\\_    \n______________     \n',
    'O': u'     ___/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   _/\\/\\____/\\/\\_  \n  _/\\/\\____/\\/\\_   \n ___/\\/\\/\\/\\___    \n______________     \n',
    'S': u'     ___/\\/\\/\\/\\/\\_\n    _/\\/\\_________ \n   ___/\\/\\/\\/\\___  \n  _________/\\/\\_   \n _/\\/\\/\\/\\/\\___    \n______________     \n',
    'W': u'     _/\\/\\______/\\/\\_\n    _/\\/\\__/\\__/\\/\\_ \n   _/\\/\\/\\/\\/\\/\\/\\_  \n  _/\\/\\/\\__/\\/\\/\\_   \n _/\\/\\______/\\/\\_    \n________________     \n',
    '[': u'     _/\\/\\/\\/\\_\n    _/\\/\\_____ \n   _/\\/\\_____  \n  _/\\/\\_____   \n _/\\/\\/\\/\\_    \n__________     \n',
    '_': u'     ______________\n    ______________ \n   ______________  \n  ______________   \n ______________    \n_/\\/\\/\\/\\/\\/\\_     \n',
    'c': u'     ____________\n    ___/\\/\\/\\/\\_ \n   _/\\/\\_______  \n  _/\\/\\_______   \n ___/\\/\\/\\/\\_    \n____________     \n',
    'g': u'     ____________\n    ___/\\/\\/\\/\\_ \n   _/\\/\\__/\\/\\_  \n  ___/\\/\\/\\/\\_   \n _______/\\/\\_    \n_/\\/\\/\\/\\___     \n',
    'k': u'     _/\\/\\_______\n    _/\\/\\__/\\/\\_ \n   _/\\/\\/\\/\\___  \n  _/\\/\\/\\/\\___   \n _/\\/\\__/\\/\\_    \n____________     \n',
    'o': u'     ____________\n    ___/\\/\\/\\___ \n   _/\\/\\__/\\/\\_  \n  _/\\/\\__/\\/\\_   \n ___/\\/\\/\\___    \n____________     \n',
    's': u'     ____________\n    ___/\\/\\/\\/\\_ \n   _/\\/\\/\\/\\___  \n  _______/\\/\\_   \n _/\\/\\/\\/\\___    \n____________     \n',
    'w': u'     ________________\n    _/\\/\\______/\\/\\_ \n   _/\\/\\__/\\__/\\/\\_  \n  _/\\/\\/\\/\\/\\/\\/\\_   \n ___/\\/\\__/\\/\\___    \n________________     \n',
    '{': u'     ___/\\/\\/\\/\\_\n    ___/\\/\\_____ \n   _/\\/\\_______  \n  ___/\\/\\_____   \n ___/\\/\\/\\/\\_    \n____________     \n',
    '"': u'     _/\\/\\/\\/\\_\n    _/\\/\\/\\/\\_ \n   _/\\__/\\___  \n  __________   \n __________    \n__________     \n',
    '&': u'     _____/\\/\\_______\n    _____/\\/\\_______ \n   ___/\\/\\/\\__/\\/\\_  \n  _/\\/\\____/\\/\\___   \n ___/\\/\\/\\__/\\/\\_    \n________________     \n',
    '*': u'     ___/\\/\\__/\\/\\___\n    _____/\\/\\/\\_____ \n   _/\\/\\/\\/\\/\\/\\/\\_  \n  _____/\\/\\/\\_____   \n ___/\\/\\__/\\/\\___    \n________________     \n',
    '.': u'     ______\n    ______ \n   ______  \n  _/\\/\\_   \n _/\\/\\_    \n______     \n',
    '2': u'     _/\\/\\/\\/\\/\\___\n    _________/\\/\\_ \n   ___/\\/\\/\\/\\___  \n  _/\\/\\_________   \n _/\\/\\/\\/\\/\\/\\_    \n______________     \n',
    '6': u'     ___/\\/\\/\\/\\___\n    _/\\/\\_________ \n   _/\\/\\/\\/\\/\\___  \n  _/\\/\\____/\\/\\_   \n ___/\\/\\/\\/\\___    \n______________     \n',
    ':': u'     _/\\/\\_\n    _/\\/\\_ \n   ______  \n  _/\\/\\_   \n _/\\/\\_    \n______     \n',
    '>': u'     _/\\/\\_____\n    ___/\\/\\___ \n   _____/\\/\\_  \n  ___/\\/\\___   \n _/\\/\\_____    \n__________     \n',
    'B': u'     _/\\/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   _/\\/\\/\\/\\/\\___  \n  _/\\/\\____/\\/\\_   \n _/\\/\\/\\/\\/\\___    \n______________     \n',
    'F': u'     _/\\/\\/\\/\\/\\/\\_\n    _/\\/\\_________ \n   _/\\/\\/\\/\\/\\___  \n  _/\\/\\_________   \n _/\\/\\_________    \n______________     \n',
    'J': u'     _________/\\/\\_\n    _________/\\/\\_ \n   _________/\\/\\_  \n  _/\\/\\____/\\/\\_   \n ___/\\/\\/\\/\\___    \n______________     \n',
    'N': u'     _/\\/\\____/\\/\\_\n    _/\\/\\/\\__/\\/\\_ \n   _/\\/\\/\\/\\/\\/\\_  \n  _/\\/\\__/\\/\\/\\_   \n _/\\/\\____/\\/\\_    \n______________     \n',
    'R': u'     _/\\/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   _/\\/\\/\\/\\/\\___  \n  _/\\/\\__/\\/\\___   \n _/\\/\\____/\\/\\_    \n______________     \n',
    'V': u'     _/\\/\\____/\\/\\_\n    _/\\/\\____/\\/\\_ \n   _/\\/\\____/\\/\\_  \n  ___/\\/\\/\\/\\___   \n _____/\\/\\_____    \n______________     \n',
    'Z': u'     _/\\/\\/\\/\\/\\/\\_\n    _______/\\/\\___ \n   _____/\\/\\_____  \n  ___/\\/\\_______   \n _/\\/\\/\\/\\/\\/\\_    \n______________     \n',
    '^': u'     ___/\\/\\___\n    _/\\/\\/\\/\\_ \n   _/\\____/\\_  \n  __________   \n __________    \n__________     \n',
    'b': u'     _/\\/\\_______\n    _/\\/\\_______ \n   _/\\/\\/\\/\\___  \n  _/\\/\\__/\\/\\_   \n _/\\/\\/\\/\\___    \n____________     \n',
    'f': u'     ___/\\/\\/\\_\n    _/\\/\\_____ \n   _/\\/\\/\\___  \n  _/\\/\\_____   \n _/\\/\\_____    \n__________     \n',
    'j': u'     _____/\\/\\_\n    __________ \n   _____/\\/\\_  \n  _____/\\/\\_   \n _____/\\/\\_    \n_/\\/\\/\\___     \n',
    'n': u'     ____________\n    _/\\/\\/\\/\\___ \n   _/\\/\\__/\\/\\_  \n  _/\\/\\__/\\/\\_   \n _/\\/\\__/\\/\\_    \n____________     \n',
    'r': u'     ____________\n    _/\\/\\__/\\/\\_ \n   _/\\/\\/\\/\\___  \n  _/\\/\\_______   \n _/\\/\\_______    \n____________     \n',
    'v': u'     ____________\n    _/\\/\\__/\\/\\_ \n   _/\\/\\__/\\/\\_  \n  ___/\\/\\/\\___   \n _____/\\_____    \n____________     \n',
    'z': u'     ____________\n    _/\\/\\/\\/\\/\\_ \n   _____/\\/\\___  \n  ___/\\/\\_____   \n _/\\/\\/\\/\\/\\_    \n____________     \n',
    '~': u'     ___/\\/\\__/\\/\\_\n    _/\\/\\/\\/\\/\\/\\_ \n   _/\\/\\__/\\/\\___  \n  ______________   \n ______________    \n______________     \n',
    '!': u'     _/\\/\\_\n    _/\\/\\_ \n   _/\\/\\_  \n  ______   \n _/\\/\\_    \n______     \n',
    '%': u'     _/\\/\\____/\\/\\_\n    _/\\/\\__/\\/\\___ \n   _____/\\/\\_____  \n  ___/\\/\\__/\\/\\_   \n _/\\/\\____/\\/\\_    \n______________     \n',
    ')': u'     _/\\/\\/\\___\n    ___/\\/\\/\\_ \n   _____/\\/\\_  \n  ___/\\/\\/\\_   \n _/\\/\\/\\___    \n__________     \n',
    '-': u'     __________\n    __________ \n   _/\\/\\/\\/\\_  \n  __________   \n __________    \n__________     \n',
    '1': u'     ___/\\/\\_\n    _/\\/\\/\\_ \n   ___/\\/\\_  \n  ___/\\/\\_   \n ___/\\/\\_    \n________     \n',
    '5': u'     _/\\/\\/\\/\\/\\/\\_\n    _/\\/\\_________ \n   _/\\/\\/\\/\\/\\___  \n  _________/\\/\\_   \n _/\\/\\/\\/\\/\\___    \n______________     \n',
    '9': u'     ___/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   ___/\\/\\/\\/\\/\\_  \n  _________/\\/\\_   \n ___/\\/\\/\\/\\___    \n______________     \n',
    '=': u'     __________\n    _/\\/\\/\\/\\_ \n   __________  \n  _/\\/\\/\\/\\_   \n __________    \n__________     \n',
    'A': u'     _____/\\/\\_____\n    ___/\\/\\/\\/\\___ \n   _/\\/\\____/\\/\\_  \n  _/\\/\\/\\/\\/\\/\\_   \n _/\\/\\____/\\/\\_    \n______________     \n',
    'E': u'     _/\\/\\/\\/\\/\\/\\_\n    _/\\___________ \n   _/\\/\\/\\/\\/\\___  \n  _/\\/\\_________   \n _/\\/\\/\\/\\/\\/\\_    \n______________     \n',
    'I': u'     _/\\/\\/\\/\\_\n    ___/\\/\\___ \n   ___/\\/\\___  \n  ___/\\/\\___   \n _/\\/\\/\\/\\_    \n__________     \n',
    'M': u'     _/\\/\\______/\\/\\_\n    _/\\/\\/\\__/\\/\\/\\_ \n   _/\\/\\/\\/\\/\\/\\/\\_  \n  _/\\/\\__/\\__/\\/\\_   \n _/\\/\\______/\\/\\_    \n________________     \n',
    'Q': u'     ___/\\/\\/\\/\\___\n    _/\\/\\____/\\/\\_ \n   _/\\/\\____/\\/\\_  \n  _/\\/\\__/\\/\\___   \n ___/\\/\\/\\/\\/\\_    \n______________     \n',
    'U': u'     _/\\/\\____/\\/\\_\n    _/\\/\\____/\\/\\_ \n   _/\\/\\____/\\/\\_  \n  _/\\/\\____/\\/\\_   \n ___/\\/\\/\\/\\___    \n______________     \n',
    'Y': u'     _/\\/\\____/\\/\\_\n    _/\\/\\____/\\/\\_ \n   ___/\\/\\/\\/\\___  \n  _____/\\/\\_____   \n _____/\\/\\_____    \n______________     \n',
    ']': u'     _/\\/\\/\\/\\_\n    _____/\\/\\_ \n   _____/\\/\\_  \n  _____/\\/\\_   \n _/\\/\\/\\/\\_    \n__________     \n',
    'a': u'     ____________\n    _/\\/\\/\\_____ \n   _____/\\/\\___  \n  _/\\/\\/\\/\\___   \n _/\\/\\/\\/\\/\\_    \n____________     \n',
    'e': u'     ____________\n    ___/\\/\\/\\___ \n   _/\\/\\/\\/\\/\\_  \n  _/\\/\\_______   \n ___/\\/\\/\\/\\_    \n____________     \n',
    'i': u'     _/\\/\\___\n    ________ \n   _/\\/\\___  \n  _/\\/\\___   \n _/\\/\\/\\_    \n________     \n',
    'm': u'     ________________\n    _/\\/\\/\\__/\\/\\___ \n   _/\\/\\/\\/\\/\\/\\/\\_  \n  _/\\/\\__/\\__/\\/\\_   \n _/\\/\\______/\\/\\_    \n________________     \n',
    'q': u'     ____________\n    ___/\\/\\/\\/\\_ \n   _/\\/\\__/\\/\\_  \n  ___/\\/\\/\\/\\_   \n _______/\\/\\_    \n_______/\\/\\_     \n',
    'u': u'     ____________\n    _/\\/\\__/\\/\\_ \n   _/\\/\\__/\\/\\_  \n  _/\\/\\__/\\/\\_   \n ___/\\/\\/\\/\\_    \n____________     \n',
    'y': u'     ____________\n    _/\\/\\__/\\/\\_ \n   _/\\/\\__/\\/\\_  \n  ___/\\/\\/\\/\\_   \n _______/\\/\\_    \n_/\\/\\/\\/\\___     \n',
    '}': u'     _/\\/\\/\\/\\___\n    _____/\\/\\___ \n   _______/\\/\\_  \n  _____/\\/\\___   \n _/\\/\\/\\/\\___    \n____________     \n'}

tiles_dic = {
    ' ': u' \n \n \n \n \n \n \n \n',
    '$': u'   [..  \n [. [.. \n[..     \n  [..   \n     [..\n[.. [.. \n   [..  \n        \n',
    '(': u'  [..\n [.. \n[..  \n[..  \n[..  \n [.. \n  [..\n     \n',
    ',': u'   \n   \n   \n   \n   \n   \n[..\n [.\n',
    '0': u'            \n    [..     \n  [..  [..  \n[..     [.. \n[..      [..\n [..    [.. \n   [...     \n            \n',
    '4': u'            \n      [..   \n    [ [..   \n   [. [..   \n [..  [..   \n[.... [. [..\n      [..   \n            \n',
    '8': u'           \n    [.     \n [..  [..  \n[..     [. \n  [.. [.   \n[..     [..\n  [....    \n           \n',
    '<': u'      [..\n    [..  \n  [..    \n[..      \n  [..    \n    [..  \n      [..\n         \n',
    '@': u'             \n    [...     \n  [.    [..  \n [.  [..  [..\n[.. [..[  [..\n [..   ```   \n    [..      \n             \n',
    'D': u'[.....    \n[..   [.. \n[..    [..\n[..    [..\n[..    [..\n[..   [.. \n[.....    \n          \n',
    'H': u'[..     [..\n[..     [..\n[..     [..\n[...... [..\n[..     [..\n[..     [..\n[..     [..\n           \n',
    'L': u'[..      \n[..      \n[..      \n[..      \n[..      \n[..      \n[........\n         \n',
    'P': u'[.......  \n[..    [..\n[..    [..\n[.......  \n[..       \n[..       \n[..       \n          \n',
    'T': u'[... [......\n     [..    \n     [..    \n     [..    \n     [..    \n     [..    \n     [..    \n            \n',
    'X': u'[..      [..\n [..   [..  \n  [.. [..   \n    [..     \n  [.. [..   \n [..   [..  \n[..      [..\n            \n',
    '\\': u'[..      \n [..     \n  [..    \n   [..   \n    [..  \n     [.. \n      [..\n         \n',
    '`': u'[..\n[. \n   \n   \n   \n   \n   \n   \n',
    'd': u'     [..\n     [..\n     [..\n [.. [..\n[.   [..\n[.   [..\n [.. [..\n        \n',
    'h': u'        \n[..     \n[..     \n[. [.   \n[..  [..\n[.   [..\n[..  [..\n        \n',
    'l': u' [..\n [..\n [..\n [..\n [..\n [..\n[...\n    \n',
    'p': u'        \n        \n[. [..  \n[.  [.. \n[.   [..\n[.. [.. \n[..     \n[..     \n',
    't': u'  [..  \n  [..  \n[.[. [.\n  [..  \n  [..  \n  [..  \n   [.. \n       \n',
    'x': u'         \n         \n[..   [..\n  [. [.. \n   [.    \n [.  [.. \n[..   [..\n         \n',
    '|': u'[.\n[.\n[.\n  \n[.\n[.\n[.\n  \n',
    '#': u'             \n  [..   [..  \n[...... [....\n  [..   [..  \n  [..   [..  \n[...... [....\n  [..   [..  \n             \n',
    "'": u'[..\n [.\n   \n   \n   \n   \n   \n   \n',
    '+': u'           \n     [..   \n     [..   \n[... [.....\n     [..   \n     [..   \n           \n           \n',
    '/': u'      [..\n     [.. \n    [..  \n   [..   \n  [..    \n [..     \n[..      \n         \n',
    '3': u'         \n[.. [..  \n   [..   \n [..     \n    [..  \n      [..\n[.....   \n         \n',
    '7': u'          \n[..... [..\n      [.. \n     [..  \n    [..   \n    [..   \n    [..   \n          \n',
    ';': u'   \n   \n   \n   \n[..\n   \n[..\n [.\n',
    '?': u'[...    \n    [.. \n     [..\n    [.. \n [..    \n        \n [..    \n        \n',
    'C': u'    [..   \n [..   [..\n[..       \n[..       \n[..       \n [..   [..\n   [....  \n          \n',
    'G': u'   [....   \n [.    [.. \n[..        \n[..        \n[..   [....\n [..    [. \n  [.....   \n           \n',
    'K': u'[..   [..  \n[..  [..   \n[.. [..    \n[. [.      \n[..  [..   \n[..   [..  \n[..     [..\n           \n',
    'O': u'    [....     \n  [..    [..  \n[..        [..\n[..        [..\n[..        [..\n  [..     [.. \n    [....     \n              \n',
    'S': u'  [.. ..  \n[..    [..\n [..      \n   [..    \n      [.. \n[..    [..\n  [.. ..  \n          \n',
    'W': u'[..        [..\n[..        [..\n[..   [.   [..\n[..  [..   [..\n[.. [. [.. [..\n[. [.    [....\n[..        [..\n              \n',
    '[': u'[....\n[..  \n[..  \n[..  \n[..  \n[..  \n[....\n     \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \n[.....\n',
    'c': u'       \n       \n   [...\n [..   \n[..    \n [..   \n   [...\n       \n',
    'g': u'         \n         \n   [..   \n [..  [..\n[..   [..\n [..  [..\n     [.. \n  [..    \n',
    'k': u'[..     \n[..     \n[..  [..\n[.. [.. \n[.[..   \n[.. [.. \n[..  [..\n        \n',
    'o': u'          \n          \n   [..    \n [..  [.. \n[..    [..\n [..  [.. \n   [..    \n          \n',
    's': u'       \n       \n [.... \n[..    \n  [... \n    [..\n[.. [..\n       \n',
    'w': u'            \n            \n[..     [...\n [..  .  [..\n [.. [.  [..\n [. [. [.[..\n[...    [...\n            \n',
    '{': u'    [..\n  [..  \n  [..  \n[..    \n  [..  \n  [..  \n    [..\n       \n',
    '"': u'[. [.\n[. [.\n     \n     \n     \n     \n     \n     \n',
    '&': u'   [.   \n [.. [..\n[..     \n [...   \n[..     \n [.. [..\n   [.   \n        \n',
    '*': u'      [..     \n [..  [..  [..\n   [. [. [..  \n[.... [.......\n   [. [. [..  \n [..  [..  [..\n      [..     \n              \n',
    '.': u'   \n   \n   \n   \n   \n   \n[..\n   \n',
    '2': u'          \n [. [..   \n[.     [..\n     [..  \n   [..    \n [..      \n[........ \n          \n',
    '6': u'           \n    [..    \n   [..     \n  [..      \n[.    [..  \n[..     [..\n  [.. [..  \n           \n',
    ':': u'   \n   \n   \n   \n[..\n   \n[..\n   \n',
    '>': u'[..      \n  [..    \n    [..  \n      [..\n    [..  \n  [..    \n[..      \n         \n',
    'B': u'[.. [..   \n[.    [.. \n[.     [..\n[... [.   \n[.     [..\n[.      [.\n[.... [.. \n          \n',
    'F': u'[........\n[..      \n[..      \n[......  \n[..      \n[..      \n[..      \n         \n',
    'J': u'     [..\n     [..\n     [..\n     [..\n     [..\n[.   [..\n [....  \n        \n',
    'N': u'[...     [..\n[. [..   [..\n[.. [..  [..\n[..  [.. [..\n[..   [. [..\n[..    [. ..\n[..      [..\n            \n',
    'R': u'[.......    \n[..    [..  \n[..    [..  \n[. [..      \n[..  [..    \n[..    [..  \n[..      [..\n            \n',
    'V': u'[..         [..\n [..       [.. \n  [..     [..  \n   [..   [..   \n    [.. [..    \n     [....     \n      [..      \n               \n',
    'Z': u'[....... [..\n       [..  \n      [..   \n    [..     \n   [..      \n [..        \n[...........\n            \n',
    '^': u'    [..    \n  [.. [..  \n[..     [..\n           \n           \n           \n           \n           \n',
    'b': u'[..      \n[..      \n[..      \n[.. [..  \n[..   [..\n[..   [..\n[.. [..  \n         \n',
    'f': u'    [..\n  [.   \n[.[. [.\n  [..  \n  [..  \n  [..  \n  [..  \n       \n',
    'j': u'      \n   [..\n      \n   [..\n   [..\n   [..\n   [..\n[...  \n',
    'n': u'         \n         \n[.. [..  \n [..  [..\n [..  [..\n [..  [..\n[...  [..\n         \n',
    'r': u'       \n       \n[. [...\n [..   \n [..   \n [..   \n[...   \n       \n',
    'v': u'           \n           \n[..     [..\n [..   [.. \n  [.. [..  \n   [.[..   \n    [..    \n           \n',
    'z': u'         \n         \n[.... [..\n     [.. \n   [..   \n  [..    \n[........\n         \n',
    '~': u'[..  [.   \n   [.  [..\n          \n          \n          \n          \n          \n          \n',
    '!': u'[..\n[..\n[..\n[. \n[. \n   \n[..\n   \n',
    '%': u'         \n[..  [.. \n    [..  \n   [..   \n  [..    \n [..     \n[..  [.. \n         \n',
    ')': u'[..  \n [.. \n  [..\n  [..\n  [..\n [.. \n[..  \n     \n',
    '-': u'      \n      \n      \n[.....\n      \n      \n      \n      \n',
    '1': u'     \n[..  \n [.. \n [.. \n [.. \n [.. \n[....\n     \n',
    '5': u'         \n[.. [... \n[..      \n[...     \n    [..  \n      [..\n[... [.. \n         \n',
    '9': u'            \n   [. [..   \n [..     [..\n[.      [.. \n  [.  [..   \n     [..    \n   [..      \n            \n',
    '=': u'       \n       \n[......\n       \n[......\n       \n       \n       \n',
    'A': u'      [.       \n     [. ..     \n    [.  [..    \n   [..   [..   \n  [...... [..  \n [..       [.. \n[..         [..\n               \n',
    'E': u'[........\n[..      \n[..      \n[......  \n[..      \n[..      \n[........\n         \n',
    'I': u'[..\n[..\n[..\n[..\n[..\n[..\n[..\n   \n',
    'M': u'[..       [..\n[. [..   [...\n[.. [.. [ [..\n[..  [..  [..\n[..   [.  [..\n[..       [..\n[..       [..\n             \n',
    'Q': u'    [....    \n  [..    [.. \n[..       [..\n[..       [..\n[..       [..\n  [.. [. [.. \n    [.. ..   \n         [.  \n',
    'U': u'[..     [..\n[..     [..\n[..     [..\n[..     [..\n[..     [..\n[..     [..\n  [.....   \n           \n',
    'Y': u'[..      [..\n [..    [.. \n  [.. [..   \n    [..     \n    [..     \n    [..     \n    [..     \n            \n',
    ']': u'[....\n  [..\n  [..\n  [..\n  [..\n  [..\n[....\n     \n',
    'a': u'          \n          \n   [..    \n [..  [.. \n[..   [.. \n[..   [.. \n  [.. [...\n          \n',
    'e': u'          \n          \n   [..    \n [.   [.. \n[..... [..\n[.        \n  [....   \n          \n',
    'i': u'   \n [.\n   \n[..\n[..\n[..\n[..\n   \n',
    'm': u'             \n             \n[... [.. [.. \n [..  [.  [..\n [..  [.  [..\n [..  [.  [..\n[...  [.  [..\n             \n',
    'q': u'        \n        \n  [..   \n[.  [.. \n[.  [.. \n [..[.. \n    [.. \n    [...\n',
    'u': u'        \n        \n[..  [..\n[..  [..\n[..  [..\n[..  [..\n  [..[..\n        \n',
    'y': u'         \n         \n[..   [..\n [.. [.. \n   [...  \n    [..  \n   [..   \n [..     \n',
    '}': u'[..    \n  [..  \n  [..  \n    [..\n  [..  \n  [..  \n[..    \n       \n'}

tsalagi_dic = {
    ' ': u'       \n       \n       \n       \n       \n',
    '$': u'_  _   \n|  |   \n|__|   \n|  |   \n|  |   \n',
    '(': u'  ___  \n | |   \n   |   \n  /|   \n@/ |_  \n',
    ',': u'       \n       \n       \n |     \n/      \n',
    '0': u'___    \n |     \n |     \n |     \n_|__|  \n',
    '4': u'  _    \n / \\ | \n|   \\| \n|   /| \n \\_/ | \n',
    '8': u"  __   \n /  '  \n \\_    \n   \\   \n`__/   \n",
    '<': u' ___   \n| |  | \n  |  / \n  | /  \n  |/   \n',
    '@': u'   _   \n  / \\  \n  |_|  \n  | |  \n@/ @/  \n',
    'D': u"       \n   /\\  \n  | |  \n| | | _\n \\_\\'_/\n",
    'H': u" __    \n/  '   \n\\_     \n/  _   \n\\__,   \n",
    'L': u'____   \n |  \\  \n |__/  \n |     \n.|__   \n',
    'P': u"    _  \n /\\/ \\ \n_| \\ ' \n  /|   \n  \\/   \n",
    'T': u'    __ \n \\  /  \n  \\/   \n_ /    \n\\/     \n',
    'X': u"  __,  \n /  '  \n|      \n|  -+- \n \\__|  \n",
    '\\': u"  __   \n |  |  \n |-<   \n |  |  \n>|__'  \n",
    '`': u' ___   \n |  \\  \n |__/  \n | \\   \n |  \\  \n',
    'd': u' ___   \n  |    \n(>|__  \n  | /  \n  |/   \n',
    'h': u'  __   \n /  \\  \n|____| \n|    | \n \\__/  \n',
    'l': u" ___   \n  |    \n  |    \n  |  . \n  `__' \n",
    'p': u"  ___  \n   |   \n(|_|_  \n | |   \n `_'   \n",
    't': u' ___   \n / \\   \n `  |  \n    |  \n \\_/   \n',
    'x': u"  __   \n / '~  \n|      \n|  _   \n \\__|  \n",
    '|': u"   ___ \n    |  \n   / \\ \n  /   |\n\\/ ('/ \n",
    '#': u"  __   \n |  |  \n | `'  \n |     \n_|_    \n",
    "'": u'  | |  \n   ^   \n       \n       \n       \n',
    '+': u'  _    \n / \\   \n|~| |  \n| |_|  \n \\_/   \n',
    '/': u'       \n| | | |\n| | | |\n|  \\  /\n \\/ \\/ \n',
    '3': u'    /\\ \n  _|  @\n / |   \n|  |   \n \\_|   \n',
    '7': u"       \n /|    \n/_|_,  \n  | '  \n _|_   \n",
    ';': u'/\\     \n\\/     \n       \n |     \n/      \n',
    '?': u' /~~\\  \n     | \n   ~~  \n  /\\   \n  \\/   \n',
    'C': u'   __  \n  /  \\ \n  _   |\n/\\|   |\n\\/ \\_/ \n',
    'G': u'  __   \n /  \\  \n|    |"\n|    | \n \\__/  \n',
    'K': u"     _ \n  /\\/ '\n /\\    \n|  |   \n \\/    \n",
    'O': u'  __   \n /  |  \n \\_    \n   \\   \n|__/   \n',
    'S': u'       \n |--\\  \n |_    \n |     \n |--/  \n',
    'W': u'   ___ \n    |  \n    |  \n .  |  \n  \\_/  \n',
    '[': u'___ _  \n | /   \n |/\\   \n |  \\  \n_|_ _\\_\n',
    '_': u"___    \n |     \n |     \n |/|'  \n_| |   \n",
    'c': u'____   \n |  >  \n |-<   \n |  \\  \n_|__/  \n',
    'g': u'  ___  \n   |_-_\n`\\/\\   \n |  |  \n  \\/   \n',
    'k': u'___  _ \n |   | \n |---| \n |   | \n  \\_/  \n',
    'o': u'___  __\n |    |\n \\    |\n  \\  / \n   \\/  \n',
    's': u'   __  \n  /  \\ \n__\\___ \n    \\  \n \\__/  \n',
    'w': u'       \n       \n   /|  \n  /_|  \n_/   \\_\n',
    '{': u"  ___  \n   |   \n  _|   \n / |   \n \\_'   \n",
    '"': u"  | |  \n  ` '  \n       \n       \n       \n",
    '&': u'___    \n |     \n |_    \n | \\   \n_|_/   \n',
    '*': u'  ___  \n   |   \n   |   \n  /|   \n@/ |_  \n',
    '.': u'       \n       \n       \n/\\     \n\\/     \n',
    '2': u" ____  \n`___ \\ \n  |  | \n  |--' \n _|_   \n",
    '6': u'       \n   __  \n  /  \\ \n     | \n(_|_/  \n',
    ':': u'/\\     \n\\/     \n       \n/\\     \n\\/     \n',
    '>': u'     /\\\n  /\\ `|\n/ | | |\n| |/  |\n \\|__/ \n',
    'B': u"  __   \n / _'_ \n|      \n|   @  \n \\__/  \n",
    'F': u'  _    \n ` |   \n|-_|   \n   |   \n  _|_  \n',
    'J': u'_____  \n |  \\  \n |__/  \n | \\   \n_|  \\_ \n',
    'N': u'  __   \n /  ~~ \n|      \n|    ~ \n \\__/  \n',
    'R': u'     _ \n |\\ /| \n | | | \n |   | \n.|   |_\n',
    'V': u'  /\\   \n  \\/\\_ \n /  / \\\n/\\  | |\n\\/  \\_/\n',
    'Z': u"  _    \n | '   \n |     \n |     \n_|__|  \n",
    '^': u" _     \n/ \\/\\  \n  /\\'  \n |  |  \n  \\/   \n",
    'b': u'   __  \n  `  \\ \n   _  |\n|  |  |\n \\_|_/ \n',
    'f': u'_ _  _ \n| |  | \n| |  | \n\\ \\  / \n \\/\\/  \n',
    'j': u' ___   \n| | |  \n  |    \n  |    \n|_|_|  \n',
    'n': u'  __   \n `  \\  \n     | \n|)  /  \n \\_/   \n',
    'r': u"  __   \n /  '  \n| ,_   \n| ' |  \n \\__/  \n",
    'v': u"  __   \n /  '  \n|   _  \n|   |  \n \\_/|` \n",
    'z': u"   _   \n  / '  \n /_    \n | |   \n_| |   \n",
    '~': u' _____ \n|  |  |\n   |   \n   |   \n  _|_  \n',
    '!': u'__  __ \n \\  /  \n  \\/   \n  /    \n @     \n',
    '%': u'___    \n |     \n |__   \n |  |  \n_|  |_ \n',
    ')': u"  __,  \n /  '  \n|      \n|      \n \\__/  \n",
    '-': u'       \n       \n ---   \n       \n       \n',
    '1': u' _____ \n   |   \n   |/u \n   |   \n __|__ \n',
    '5': u'       \n  /\\   \n |  \\  \n |   \\ \n@|  _|_\n',
    '9': u' ____  \n| |    \n  | _  \n  |  \\ \n   \\_/ \n',
    '=': u'       \n       \n  ---  \n  ---  \n       \n',
    'A': u'  _    \n <_>   \n       \n  |    \n _|_   \n',
    'E': u' ____  \n  |  | \n  |    \n  |    \n _|_   \n',
    'I': u"      _ \n  () / '\n /~\\    \n|   |   \n \\_/    \n",
    'M': u"  _    \n / '   \n| __   \n|'  \\  \n \\__/  \n",
    'Q': u'  _    \n / \\   \n|   |) \n|   |  \n \\_/   \n',
    'U': u"    _  \n / ` \\ \n|  _  |\n| | ' |\n \\_\\_/ \n",
    'Y': u'  _    \n / |   \n _ |   \n `-|   \n  _|_  \n',
    ']': u'  _  _ \n /| ` \\\n|/    |\n|     |\n \\___/ \n',
    'a': u'  __   \n |  \\  \n |   \\ \n |   / \n |__/  \n',
    'e': u" ___   \n  |    \n  |_,  \n  | '  \n _|_   \n",
    'i': u" ___   \n  |    \n .|()  \n()|'   \n _|_   \n",
    'm': u'-|-    \n |     \n |     \n | _   \n  _|   \n',
    'q': u'  ___  \n   |__ \n _/   \\\n/ \\   |\n\\ / `_/\n',
    'u': u'       \n ,  |~,\n@|  |  \n |  /  \n  \\/   \n',
    'y': u' ____  \n|  /   \n  /    \n /     \n/___|  \n',
    '}': u'  _    \n / \\   \n|  |   \n \\ |   \n@_/    \n'}

tubular_dic = {
    ' ': u' \n \n \n \n \n \n \n \n',
    '$': u'   O~~  \n O~ O~~ \nO~~     \n  O~~   \n     O~~\nO~~ O~~ \n   O~~  \n        \n',
    '(': u'  O~~\n O~~ \nO~~  \nO~~  \nO~~  \n O~~ \n  O~~\n     \n',
    ',': u'   \n   \n   \n   \n   \n   \nO~~\n O~\n',
    '0': u'            \n    O~~     \n  O~~  O~~  \nO~~     O~~ \nO~~      O~~\n O~~    O~~ \n   O~~~     \n            \n',
    '4': u'            \n      O~~   \n    O O~~   \n   O~ O~~   \n O~~  O~~   \nO~~~~ O~ O~~\n      O~~   \n            \n',
    '8': u'           \n    O~     \n O~~  O~~  \nO~~     O~ \n  O~~ O~   \nO~~     O~~\n  O~~~~    \n           \n',
    '<': u'      O~~\n    O~~  \n  O~~    \nO~~      \n  O~~    \n    O~~  \n      O~~\n         \n',
    '@': u'             \n    O~~~     \n  O~    O~~  \n O~  O~~  O~~\nO~~ O~~O  O~~\n O~~   ```   \n    O~~      \n             \n',
    'D': u'O~~~~~    \nO~~   O~~ \nO~~    O~~\nO~~    O~~\nO~~    O~~\nO~~   O~~ \nO~~~~~    \n          \n',
    'H': u'O~~     O~~\nO~~     O~~\nO~~     O~~\nO~~~~~~ O~~\nO~~     O~~\nO~~     O~~\nO~~     O~~\n           \n',
    'L': u'O~~      \nO~~      \nO~~      \nO~~      \nO~~      \nO~~      \nO~~~~~~~~\n         \n',
    'P': u'O~~~~~~~  \nO~~    O~~\nO~~    O~~\nO~~~~~~~  \nO~~       \nO~~       \nO~~       \n          \n',
    'T': u'O~~~ O~~~~~~\n     O~~    \n     O~~    \n     O~~    \n     O~~    \n     O~~    \n     O~~    \n            \n',
    'X': u'O~~      O~~\n O~~   O~~  \n  O~~ O~~   \n    O~~     \n  O~~ O~~   \n O~~   O~~  \nO~~      O~~\n            \n',
    '\\': u'O~~      \n O~~     \n  O~~    \n   O~~   \n    O~~  \n     O~~ \n      O~~\n         \n',
    '`': u'O~~\nO~ \n   \n   \n   \n   \n   \n   \n',
    'd': u'     O~~\n     O~~\n     O~~\n O~~ O~~\nO~   O~~\nO~   O~~\n O~~ O~~\n        \n',
    'h': u'        \nO~~     \nO~~     \nO~ O~   \nO~~  O~~\nO~   O~~\nO~~  O~~\n        \n',
    'l': u' O~~\n O~~\n O~~\n O~~\n O~~\n O~~\nO~~~\n    \n',
    'p': u'        \n        \nO~ O~~  \nO~  O~~ \nO~   O~~\nO~~ O~~ \nO~~     \nO~~     \n',
    't': u'  O~~  \n  O~~  \nO~O~ O~\n  O~~  \n  O~~  \n  O~~  \n   O~~ \n       \n',
    'x': u'         \n         \nO~~   O~~\n  O~ O~~ \n   O~    \n O~  O~~ \nO~~   O~~\n         \n',
    '|': u'O~\nO~\nO~\n  \nO~\nO~\nO~\n  \n',
    '#': u'             \n  O~~   O~~  \nO~~~~~~ O~~~~\n  O~~   O~~  \n  O~~   O~~  \nO~~~~~~ O~~~~\n  O~~   O~~  \n             \n',
    "'": u'O~~\n O~\n   \n   \n   \n   \n   \n   \n',
    '+': u'           \n     O~~   \n     O~~   \nO~~~ O~~~~~\n     O~~   \n     O~~   \n           \n           \n',
    '/': u'      O~~\n     O~~ \n    O~~  \n   O~~   \n  O~~    \n O~~     \nO~~      \n         \n',
    '3': u'         \nO~~ O~~  \n   O~~   \n O~~     \n    O~~  \n      O~~\nO~~~~~   \n         \n',
    '7': u'          \nO~~~~~ O~~\n      O~~ \n     O~~  \n    O~~   \n    O~~   \n    O~~   \n          \n',
    ';': u'   \n   \n   \n   \nO~~\n   \nO~~\n O~\n',
    '?': u'O~~~    \n    O~~ \n     O~~\n    O~~ \n O~~    \n        \n O~~    \n        \n',
    'C': u'    O~~   \n O~~   O~~\nO~~       \nO~~       \nO~~       \n O~~   O~~\n   O~~~~  \n          \n',
    'G': u'   O~~~~   \n O~    O~~ \nO~~        \nO~~        \nO~~   O~~~~\n O~~    O~ \n  O~~~~~   \n           \n',
    'K': u'O~~   O~~  \nO~~  O~~   \nO~~ O~~    \nO~ O~      \nO~~  O~~   \nO~~   O~~  \nO~~     O~~\n           \n',
    'O': u'    O~~~~     \n  O~~    O~~  \nO~~        O~~\nO~~        O~~\nO~~        O~~\n  O~~     O~~ \n    O~~~~     \n              \n',
    'S': u'  O~~ ~~  \nO~~    O~~\n O~~      \n   O~~    \n      O~~ \nO~~    O~~\n  O~~ ~~  \n          \n',
    'W': u'O~~        O~~\nO~~        O~~\nO~~   O~   O~~\nO~~  O~~   O~~\nO~~ O~ O~~ O~~\nO~ O~    O~~~~\nO~~        O~~\n              \n',
    '[': u'O~~~~\nO~~  \nO~~  \nO~~  \nO~~  \nO~~  \nO~~~~\n     \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \nO~~~~~\n',
    'c': u'       \n       \n   O~~~\n O~~   \nO~~    \n O~~   \n   O~~~\n       \n',
    'g': u'         \n         \n   O~~   \n O~~  O~~\nO~~   O~~\n O~~  O~~\n     O~~ \n  O~~    \n',
    'k': u'O~~     \nO~~     \nO~~  O~~\nO~~ O~~ \nO~O~~   \nO~~ O~~ \nO~~  O~~\n        \n',
    'o': u'          \n          \n   O~~    \n O~~  O~~ \nO~~    O~~\n O~~  O~~ \n   O~~    \n          \n',
    's': u'       \n       \n O~~~~ \nO~~    \n  O~~~ \n    O~~\nO~~ O~~\n       \n',
    'w': u'            \n            \nO~~      O~~\n O~~  ~  O~~\n O~~ O~  O~~\n O~ O~ O~O~~\nO~~~     O~~\n            \n',
    '{': u'    O~~\n  O~~  \n  O~~  \nO~~    \n  O~~  \n  O~~  \n    O~~\n       \n',
    '"': u'O~ O~\nO~ O~\n     \n     \n     \n     \n     \n     \n',
    '&': u'   O~   \n O~~ O~~\nO~~     \n O~~~   \nO~~     \n O~~ O~~\n   O~   \n        \n',
    '*': u'      O~~     \n O~~  O~~  O~~\n   O~ O~ O~~  \nO~~~~ O~~~~~~~\n   O~ O~ O~~  \n O~~  O~~  O~~\n      O~~     \n              \n',
    '.': u'   \n   \n   \n   \n   \n   \nO~~\n   \n',
    '2': u'          \n  O~ O~~  \nO~     O~~\n     O~~  \n   O~~    \n O~~      \nO~~~~~~~~ \n          \n',
    '6': u'           \n    O~~    \n   O~~     \n  O~~      \nO~    O~~  \nO~~     O~~\n  O~~ O~~  \n           \n',
    ':': u'   \n   \n   \n   \nO~~\n   \nO~~\n   \n',
    '>': u'O~~      \n  O~~    \n    O~~  \n      O~~\n    O~~  \n  O~~    \nO~~      \n         \n',
    'B': u'O~~ O~~   \nO~    O~~ \nO~     O~~\nO~~~ O~   \nO~     O~~\nO~      O~\nO~~~~ O~~ \n          \n',
    'F': u'O~~~~~~~~\nO~~      \nO~~      \nO~~~~~~  \nO~~      \nO~~      \nO~~      \n         \n',
    'J': u'     O~~\n     O~~\n     O~~\n     O~~\n     O~~\nO~   O~~\n O~~~~  \n        \n',
    'N': u'O~~~     O~~\nO~ O~~   O~~\nO~~ O~~  O~~\nO~~  O~~ O~~\nO~~   O~ O~~\nO~~    O~ ~~\nO~~      O~~\n            \n',
    'R': u'O~~~~~~~    \nO~~    O~~  \nO~~    O~~  \nO~ O~~      \nO~~  O~~    \nO~~    O~~  \nO~~      O~~\n            \n',
    'V': u'O~~         O~~\n O~~       O~~ \n  O~~     O~~  \n   O~~   O~~   \n    O~~ O~~    \n     O~~~~     \n      O~~      \n               \n',
    'Z': u'O~~~~~~~ O~~\n       O~~  \n      O~~   \n    O~~     \n   O~~      \n O~~        \nO~~~~~~~~~~~\n            \n',
    '^': u'    O~~    \n  O~~ O~~  \nO~~     O~~\n           \n           \n           \n           \n           \n',
    'b': u'O~~      \nO~~      \nO~~      \nO~~ O~~  \nO~~   O~~\nO~~   O~~\nO~~ O~~  \n         \n',
    'f': u'    O~~\n  O~   \nO~O~ O~\n  O~~  \n  O~~  \n  O~~  \n  O~~  \n       \n',
    'j': u'      \n   O~~\n      \n   O~~\n   O~~\n   O~~\n   O~~\nO~~~  \n',
    'n': u'         \n         \nO~~ O~~  \n O~~  O~~\n O~~  O~~\n O~~  O~~\nO~~~  O~~\n         \n',
    'r': u'       \n       \nO~ O~~~\n O~~   \n O~~   \n O~~   \nO~~~   \n       \n',
    'v': u'           \n           \nO~~     O~~\n O~~   O~~ \n  O~~ O~~  \n   O~O~~   \n    O~~    \n           \n',
    'z': u'         \n         \nO~~~~ O~~\n     O~~ \n   O~~   \n  O~~    \nO~~~~~~~~\n         \n',
    '~': u'O~~  O~   \n   O~  O~~\n          \n          \n          \n          \n          \n          \n',
    '!': u'O~~\nO~~\nO~~\nO~ \nO~ \n   \nO~~\n   \n',
    '%': u'         \nO~~  O~~ \n    O~~  \n   O~~   \n  O~~    \n O~~     \nO~~  O~~ \n         \n',
    ')': u'O~~  \n O~~ \n  O~~\n  O~~\n  O~~\n O~~ \nO~~  \n     \n',
    '-': u'      \n      \n      \nO~~~~~\n      \n      \n      \n      \n',
    '1': u'     \nO~~  \n O~~ \n O~~ \n O~~ \n O~~ \nO~~~~\n     \n',
    '5': u'         \nO~~ O~~~ \nO~~      \nO~~~     \n    O~~  \n      O~~\nO~~~ O~~ \n         \n',
    '9': u'            \n   O~ O~~   \n O~~     O~~\nO~      O~~ \n  O~  O~~   \n     O~~    \n   O~~      \n            \n',
    '=': u'       \n       \nO~~~~~~\n       \nO~~~~~~\n       \n       \n       \n',
    'A': u'      O~       \n     O~ ~~     \n    O~  O~~    \n   O~~   O~~   \n  O~~~~~~ O~~  \n O~~       O~~ \nO~~         O~~\n               \n',
    'E': u'O~~~~~~~~\nO~~      \nO~~      \nO~~~~~~  \nO~~      \nO~~      \nO~~~~~~~~\n         \n',
    'I': u'O~~\nO~~\nO~~\nO~~\nO~~\nO~~\nO~~\n   \n',
    'M': u'O~~       O~~\nO~ O~~   O~~~\nO~~ O~~ O O~~\nO~~  O~~  O~~\nO~~   O~  O~~\nO~~       O~~\nO~~       O~~\n             \n',
    'Q': u'    O~~~~    \n  O~~    O~~ \nO~~       O~~\nO~~       O~~\nO~~       O~~\n  O~~ O~ O~~ \n    O~~ ~~   \n         O~  \n',
    'U': u'O~~     O~~\nO~~     O~~\nO~~     O~~\nO~~     O~~\nO~~     O~~\nO~~     O~~\n  O~~~~~   \n           \n',
    'Y': u'O~~      O~~\n O~~    O~~ \n  O~~ O~~   \n    O~~     \n    O~~     \n    O~~     \n    O~~     \n            \n',
    ']': u'O~~~~\n  O~~\n  O~~\n  O~~\n  O~~\n  O~~\nO~~~~\n     \n',
    'a': u'          \n          \n   O~~    \n O~~  O~~ \nO~~   O~~ \nO~~   O~~ \n  O~~ O~~~\n          \n',
    'e': u'          \n          \n   O~~    \n O~   O~~ \nO~~~~~ O~~\nO~        \n  O~~~~   \n          \n',
    'i': u'   \n O~\n   \nO~~\nO~~\nO~~\nO~~\n   \n',
    'm': u'             \n             \nO~~~ O~~ O~~ \n O~~  O~  O~~\n O~~  O~  O~~\n O~~  O~  O~~\nO~~~  O~  O~~\n             \n',
    'q': u'        \n        \n  O~~   \nO~  O~~ \nO~  O~~ \n O~~O~~ \n    O~~ \n    O~~~\n',
    'u': u'        \n        \nO~~  O~~\nO~~  O~~\nO~~  O~~\nO~~  O~~\n  O~~O~~\n        \n',
    'y': u'         \n         \nO~~   O~~\n O~~ O~~ \n   O~~~  \n    O~~  \n   O~~   \n O~~     \n',
    '}': u'O~~    \n  O~~  \n  O~~  \n    O~~\n  O~~  \n  O~~  \nO~~    \n       \n'}

twisted_dic = {
    '!': u'  _    \n /_/\\  \n ) ) ) \n/_/ /  \n\\_\\_\\  \n /_/\\  \n )_)/  \n       \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u'"\n \n \n \n \n \n \n \n',
    '%': u'%\n \n \n \n \n \n \n \n',
    '$': u' \n \n \n \n \n \n \n \n',
    "'": u' _   \n/_/\\ \n\\_\\/ \n     \n     \n     \n     \n     \n',
    '&': u'&\n \n \n \n \n \n \n \n',
    ')': u'  __   \n /_/\\  \n ) ) ) \n/_/ /  \n\\ \\ \\  \n )_) ) \n \\_\\/  \n       \n',
    '(': u'  __   \n /\\_\\  \n( ( (  \n \\ \\_\\ \n / / / \n( (_(  \n \\/_/  \n       \n',
    '+': u'+\n \n \n \n \n \n \n \n',
    '*': u'*\n \n \n \n \n \n \n \n',
    '-': u'-\n \n \n \n \n \n \n \n',
    ',': u'     \n     \n     \n     \n _   \n/_/\\ \n)_)/ \n     \n',
    '/': u'   __   \n  /_/\\  \n  ) ) ) \n /_/ /  \n ) ) )  \n/ / /   \n\\/_/    \n        \n',
    '.': u'     \n     \n     \n     \n _   \n/_/\\ \n\\_\\/ \n     \n',
    '1': u' _ __     \n/_ \\ \\    \n  ) ) )   \n / / /    \n \\ \\ \\_   \n  ) )__/\\ \n  \\/___\\/ \n          \n',
    '0': u'   _____    \n  / ___ \\   \n / /\\_/\\ \\  \n/ /_/ (_\\ \\ \n\\ \\ )_/ / / \n \\ \\/_\\/ /  \n  \\ ____/   \n            \n',
    '3': u'  _____    \n /\\__  /\\  \n(_( _)( (  \n    __ \\ \\ \n __ _  / / \n( (__)( (  \n \\/____\\/  \n           \n',
    '2': u'  _ __     \n /_ \\ \\    \n(/_) ) )   \n  / / /    \n  \\ \\ \\_   \n   ) )__/\\ \n   \\/___\\/ \n           \n',
    '5': u' __ ____   \n/ /  __/\\  \n) ) ( _\\/  \n\\_\\____ (  \n   __\\ \\ \\ \n /\\__/ / / \n \\/____\\/  \n           \n',
    '4': u'   ____    \n  /\\__/\\   \n / /_ \\ \\  \n/ /(_)/ /  \n\\/___ \\ \\  \n     )_) ) \n     \\_\\/  \n           \n',
    '7': u' ___ __   \n/___ \\ \\  \n    ) ) ) \n   / / /  \n   \\ \\ \\  \n    ) ) ) \n    \\/_/  \n          \n',
    '6': u'     _    \n    /_/\\  \n    )_) ) \n _ _// /  \n/\\(_)\\ \\  \n\\ \\__/ /  \n \\/__\\/   \n          \n',
    '9': u'  _____    \n /\\___/\\   \n/ / _ \\ \\  \n\\ \\( )/ /  \n \\/_/ \\ \\  \n     )_) ) \n     \\_\\/  \n           \n',
    '8': u'  ____    \n /\\___/\\  \n/ / _ \\ \\ \n\\ \\( )/ / \n/ /(_)\\ \\ \n\\ \\___/ / \n \\/___\\/  \n          \n',
    ';': u' _   \n/_/\\ \n\\_\\/ \n     \n _   \n/_/\\ \n)_)/ \n     \n',
    ':': u' _   \n/_/\\ \n\\_\\/ \n     \n _   \n/_/\\ \n\\_\\/ \n     \n',
    '=': u'=\n \n \n \n \n \n \n \n',
    '<': u'  __  \n /\\_\\ \n/ / / \n\\ \\_\\ \n \\/_/ \n      \n      \n      \n',
    '?': u' _ ___    \n/_/  _/\\  \n)_) ) ) ) \n\\_\\/_/ /  \n   \\_\\_\\  \n    /_/\\  \n    \\_\\/  \n          \n',
    '>': u' __   \n/_/\\  \n\\ \\ \\ \n/_/ / \n\\_\\/  \n      \n      \n      \n',
    '@': u'@\n \n \n \n \n \n \n \n',
    '[': u'   __   \n  /\\_\\  \n / ( (  \n/   \\_\\ \n\\   / / \n \\ (_(  \n  \\/_/  \n        \n',
    ']': u'  __    \n /_/\\   \n ) ) \\  \n/_/   \\ \n\\ \\   / \n )_) /  \n \\_\\/   \n        \n',
    '\\': u'  __    \n /\\_\\   \n( ( (   \n \\ \\_\\  \n ( ( (  \n  \\ \\ \\ \n   \\_\\/ \n        \n',
    '_': u'_\n \n \n \n \n \n \n \n',
    '^': u'  _ __   \n /_ \\ \\  \n(/ \\_)_) \n         \n         \n         \n         \n         \n',
    'a': u'   _____    \n  /\\___/\\   \n / / _ \\ \\  \n \\ \\(_)/ /  \n / / _ \\ \\  \n( (_( )_) ) \n \\/_/ \\_\\/  \n            \n',
    '`': u' _   \n/_/\\ \n)_)/ \n     \n     \n     \n     \n     \n',
    'c': u'  _____  \n /\\ __/\\ \n ) )__\\/ \n/ / /    \n\\ \\ \\_   \n ) )__/\\ \n \\/___\\/ \n         \n',
    'b': u'   _____   \n /\\  __/\\  \n ) )(_ ) ) \n/ / __/ /  \n\\ \\  _\\ \\  \n ) )(__) ) \n \\/____\\/  \n           \n',
    'e': u'   _____  \n /\\_____\\ \n( (_____/ \n \\ \\__\\   \n / /__/_  \n( (_____\\ \n \\/_____/ \n          \n',
    'd': u'  _____    \n /\\ __/\\   \n ) )  \\ \\  \n/ / /\\ \\ \\ \n\\ \\ \\/ / / \n ) )__/ /  \n \\/___\\/   \n           \n',
    'g': u'  ______    \n /_/\\___\\   \n ) ) ___/   \n/_/ /  ___  \n\\ \\ \\_/\\__\\ \n )_)  \\/ _/ \n \\_\\____/   \n            \n',
    'f': u'   _____  \n /\\_____\\ \n( (  ___/ \n \\ \\ \\_   \n / / /_\\  \n/ /____/  \n\\/_/      \n          \n',
    'i': u'  __   \n /\\_\\  \n \\/_/  \n  /\\_\\ \n / / / \n( (_(  \n \\/_/  \n       \n',
    'h': u'  __   __   \n /\\_\\ /_/\\  \n( ( (_) ) ) \n \\ \\___/ /  \n / / _ \\ \\  \n( (_( )_) ) \n \\/_/ \\_\\/  \n            \n',
    'k': u'  __  __   \n /\\_\\\\  /\\ \n( ( (/ / / \n \\ \\_ / /  \n / /  \\ \\  \n( (_(\\ \\ \\ \n \\/_//__\\/ \n           \n',
    'j': u'     __   \n    /_/\\  \n    ) ) ) \n _ /_/ /  \n/_/\\ \\ \\  \n)_) ) ) ) \n\\_\\___\\/  \n          \n',
    'm': u'  __    __   \n /_/\\  /\\_\\  \n ) ) \\/ ( (  \n/_/ \\  / \\_\\ \n\\ \\ \\\\// / / \n )_) )( (_(  \n \\_\\/  \\/_/  \n             \n',
    'l': u'  __      \n /\\_\\     \n( ( (     \n \\ \\_\\    \n / / /__  \n( (_____( \n \\/_____/ \n          \n',
    'o': u'   _____    \n  ) ___ (   \n / /\\_/\\ \\  \n/ /_/ (_\\ \\ \n\\ \\ )_/ / / \n \\ \\/_\\/ /  \n  )_____(   \n            \n',
    'n': u'  __   __   \n /_/\\ /\\_\\  \n ) ) \\ ( (  \n/_/   \\ \\_\\ \n\\ \\ \\   / / \n )_) \\ (_(  \n \\_\\/ \\/_/  \n            \n',
    'q': u'   _____     \n  / ___ (    \n / /\\_/\\ \\   \n/ /_/ (_\\ \\  \n\\ \\ )_/ / (  \n \\ \\/_\\/ \\_\\ \n  \\_____\\/_/ \n             \n',
    'p': u'  __ __    \n /_/\\__/\\  \n ) ) ) ) ) \n/_/ /_/ /  \n\\ \\ \\_\\/   \n )_) )     \n \\_\\/      \n           \n',
    's': u' ______  \n/ ____/\\ \n) ) __\\/ \n \\ \\ \\   \n _\\ \\ \\  \n)____) ) \n\\____\\/  \n         \n',
    'r': u'  __ __    \n /_/\\__/\\  \n ) ) ) ) ) \n/_/ /_/_/  \n\\ \\ \\ \\ \\  \n )_) ) \\ \\ \n \\_\\/ \\_\\/ \n           \n',
    'u': u'  __    __   \n /\\_\\  /_/\\  \n( ( (  ) ) ) \n \\ \\ \\/ / /  \n  \\ \\  / /   \n  ( (__) )   \n   \\/__\\/    \n             \n',
    't': u'  _______   \n/\\_______)\\ \n\\(___  __\\/ \n  / / /     \n ( ( (      \n  \\ \\ \\     \n  /_/_/     \n            \n',
    'w': u'  _      _   \n /_/\\  /\\_\\  \n ) ) )( ( (  \n/_/ //\\\\ \\_\\ \n\\ \\ /  \\ / / \n )_) /\\ (_(  \n \\_\\/  \\/_/  \n             \n',
    'v': u'  _     _   \n /_/\\ /\\_\\  \n ) ) ) ( (  \n/_/ / \\ \\_\\ \n\\ \\ \\_/ / / \n \\ \\   / /  \n  \\_\\_/_/   \n            \n',
    'y': u'  __  __   \n/\\  /\\  /\\ \n\\ \\ \\/ / / \n \\ \\__/ /  \n  \\__/ /   \n  / / /    \n  \\/_/     \n           \n',
    'x': u'  __  __   \n/\\  /\\  /\\ \n\\ \\ \\/ / / \n \\ \\  / /  \n / /  \\ \\  \n/ / /\\ \\ \\ \n\\/__\\/__\\/ \n           \n',
    '{': u'  __   \n /\\_\\  \n( ( (  \n \\ \\_\\ \n / / / \n( (_(  \n \\/_/  \n       \n',
    'z': u' _____     \n/\\____\\    \n\\/_ ( (    \n   \\ \\_\\   \n   / / /__ \n  ( (____( \n   \\/____/ \n           \n',
    '}': u'  __   \n /_/\\  \n ) ) ) \n/_/ /  \n\\ \\ \\  \n )_) ) \n \\_\\/  \n       \n',
    '|': u'|\n \n \n \n \n \n \n \n',
    '~': u'~\n \n \n \n \n \n \n \n'}

varsity_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '$': u"     _      \n .--| |--.  \n| (_| |_\\_| \n'_._| |_'.  \n| \\_| |_) | \n '--|_|--'  \n            \n",
    '(': u"  __  \n.' _| \n| |   \n| |   \n| |_  \n`.__| \n      \n",
    ',': u'    \n    \n    \n    \n _  \n)_/ \n    \n',
    '0': u"   ____    \n .'    '.  \n|  .--.  | \n| |    | | \n|  `--'  | \n '.____.'  \n           \n",
    '4': u' _    _    \n| |  | |   \n| |__| |_  \n|____   _| \n    _| |_  \n   |_____| \n           \n',
    '8': u"   ____    \n .' __ '.  \n | (__) |  \n .`____'.  \n| (____) | \n`.______.' \n           \n",
    '<': u'   _  \n  / / \n / /  \n< <   \n \\ \\  \n  \\_\\ \n      \n',
    '@': u"   ____   \n .' __ \\  \n/ .'  \\ | \n| | (_/ | \n\\ `.__.'\\ \n `.___ .' \n          \n",
    'D': u" ______    \n|_   _ `.  \n  | | `. \\ \n  | |  | | \n _| |_.' / \n|______.'  \n           \n",
    'H': u' ____  ____  \n|_   ||   _| \n  | |__| |   \n  |  __  |   \n _| |  | |_  \n|____||____| \n             \n',
    'L': u' _____     \n|_   _|    \n  | |      \n  | |   _  \n _| |__/ | \n|________| \n           \n',
    'P': u' _______   \n|_   __ \\  \n  | |__) | \n  |  ___/  \n _| |_     \n|_____|    \n           \n',
    'T': u' _________  \n|  _   _  | \n|_/ | | \\_| \n    | |     \n   _| |_    \n  |_____|   \n            \n',
    'X': u" ____  ____  \n|_  _||_  _| \n  \\ \\  / /   \n   > `' <    \n _/ /'`\\ \\_  \n|____||____| \n             \n",
    '\\': u'__      \n\\ \\     \n \\ \\    \n  \\ \\   \n   \\ \\  \n    \\_\\ \n        \n',
    '`': u' __  \n|  | \n \\_| \n     \n     \n     \n     \n',
    'd': u"       __  \n      |  ] \n  .--.| |  \n/ /'`\\' |  \n| \\__/  |  \n '.__.;__] \n           \n",
    'h': u' __       \n[  |      \n | |--.   \n | .-. |  \n | | | |  \n[___]|__] \n          \n',
    'l': u' __   \n[  |  \n | |  \n | |  \n | |  \n[___] \n      \n',
    'p': u"          \n          \n _ .--.   \n[ '/'`\\ \\ \n | \\__/ | \n | ;.__/  \n[__|      \n",
    't': u"  _    \n / |_  \n`| |-' \n | |   \n | |,  \n \\__/  \n       \n",
    'x': u"         \n         \n _   __  \n[ \\ [  ] \n > '  <  \n[__]`\\_] \n         \n",
    '|': u' _  \n| | \n| | \n| | \n| | \n|_| \n    \n',
    '#': u'           \n   _  _    \n _| || |_  \n|_| || |_| \n|_| || |_| \n  |_||_|   \n           \n',
    "'": u' _  \n| | \n\\_| \n    \n    \n    \n    \n',
    '+': u"          \n   .-.    \n __| |__  \n|__   __| \n   | |    \n   '-'    \n          \n",
    '/': u'     __ \n    / / \n   / /  \n  / /   \n / /    \n/_/     \n        \n',
    '3': u"  ______   \n / ____ `. \n `'  __) | \n _  |__ '. \n| \\____) | \n \\______.' \n           \n",
    '7': u' _______  \n|  ___  | \n|_/  / /  \n    / /   \n   / /    \n  /_/     \n          \n',
    ';': u'    \n _  \n(_) \n _  \n| ) \n)/  \n    \n',
    '?': u"  _____   \n / ___ `. \n|_/___) | \n  /  __.' \n  |_|     \n  (_)     \n          \n",
    'C': u"   ______  \n .' ___  | \n/ .'   \\_| \n| |        \n\\ `.___.'\\ \n `.____ .' \n           \n",
    'G': u"   ______   \n .' ___  |  \n/ .'   \\_|  \n| |   ____  \n\\ `.___]  | \n `._____.'  \n            \n",
    'K': u" ___  ____   \n|_  ||_  _|  \n  | |_/ /    \n  |  __'.    \n _| |  \\ \\_  \n|____||____| \n             \n",
    'O': u"   ___    \n .'   `.  \n/  .-.  \\ \n| |   | | \n\\  `-'  / \n `.___.'  \n          \n",
    'S': u"  ______   \n.' ____ \\  \n| (___ \\_| \n _.____`.  \n| \\____) | \n \\______.' \n           \n",
    'W': u' ____      ____ \n|_  _|    |_  _|\n  \\ \\  /\\  / /  \n   \\ \\/  \\/ /   \n    \\  /\\  /    \n     \\/  \\/     \n                \n',
    '[': u' ___  \n|  _| \n| |   \n| |   \n| |_  \n|___| \n      \n',
    '_': u'          \n          \n          \n          \n _______  \n|_______| \n          \n',
    'c': u"        \n        \n .---.  \n/ /'`\\] \n| \\__.  \n'.___.' \n        \n",
    'g': u"         \n         \n  .--./) \n / /'`\\; \n \\ \\._// \n .',__`  \n( ( __)) \n",
    'k': u" __       \n[  |  _   \n | | / ]  \n | '' <   \n | |`\\ \\  \n[__|  \\_] \n          \n",
    'o': u"         \n         \n  .--.   \n/ .'`\\ \\ \n| \\__. | \n '.__.'  \n         \n",
    's': u"        \n        \n .--.   \n( (`\\]  \n `'.'.  \n[\\__) ) \n        \n",
    'w': u'             \n             \n _   _   __  \n[ \\ [ \\ [  ] \n \\ \\/\\ \\/ /  \n  \\__/\\__/   \n             \n',
    '{': u"   __  \n .' _/ \n | |   \n< <    \n | |_  \n `.__\\ \n       \n",
    '"': u' _  _  \n| || | \n\\_|\\_| \n       \n       \n       \n       \n',
    '&': u"   ___       \n .' _ '.     \n | (_) '___  \n .`___'/ _/  \n| (___)  \\_  \n`._____.\\__| \n             \n",
    '*': u"    _     \n .-| |-.  \n \\     /  \n|_     _| \n /     \\  \n '-|_|-'  \n          \n",
    '.': u'    \n    \n    \n    \n _  \n(_) \n    \n',
    '2': u"  _____   \n / ___ `. \n|_/___) | \n .'____.' \n/ /_____  \n|_______| \n          \n",
    '6': u"  ______   \n.' ____ \\  \n| |____\\_| \n| '____`'. \n| (____) | \n'.______.' \n           \n",
    ':': u'    \n _  \n(_) \n _  \n(_) \n    \n    \n',
    '>': u' _    \n\\ \\   \n \\ \\  \n  > > \n / /  \n/_/   \n      \n',
    'B': u" ______    \n|_   _ \\   \n  | |_) |  \n  |  __'.  \n _| |__) | \n|_______/  \n           \n",
    'F': u' ________  \n|_   __  | \n  | |_ \\_| \n  |  _|    \n _| |_     \n|_____|    \n           \n',
    'J': u"    _____  \n   |_   _| \n     | |   \n _   | |   \n| |__' |   \n`.____.'   \n           \n",
    'N': u' ____  _____  \n|_   \\|_   _| \n  |   \\ | |   \n  | |\\ \\| |   \n _| |_\\   |_  \n|_____|\\____| \n              \n',
    'R': u' _______     \n|_   __ \\    \n  | |__) |   \n  |  __ /    \n _| |  \\ \\_  \n|____| |___| \n             \n',
    'V': u" ____   ____  \n|_  _| |_  _| \n  \\ \\   / /   \n   \\ \\ / /    \n    \\ ' /     \n     \\_/      \n              \n",
    'Z': u" ________  \n|  __   _| \n|_/  / /   \n   .'.' _  \n _/ /__/ | \n|________| \n           \n",
    '^': u'  ___   \n / _ \\  \n|_/ \\_| \n        \n        \n        \n        \n',
    'b': u" __        \n[  |       \n | |.--.   \n | '/'`\\ \\ \n |  \\__/ | \n[__;.__.'  \n           \n",
    'f': u"    ___  \n  .' ..] \n _| |_   \n'-| |-'  \n  | |    \n [___]   \n         \n",
    'j': u'     _  \n    (_) \n    __  \n   [  | \n _  | | \n[ \\_| | \n \\____/ \n',
    'n': u'          \n          \n _ .--.   \n[ `.-. |  \n | | | |  \n[___||__] \n          \n',
    'r': u"         \n         \n _ .--.  \n[ `/'`\\] \n | |     \n[___]    \n         \n",
    'v': u'         \n         \n _   __  \n[ \\ [  ] \n \\ \\/ /  \n  \\__/   \n         \n',
    'z': u"        \n        \n ____   \n[_   ]  \n .' /_  \n[_____] \n        \n",
    '~': u" ___.-. \n|  ___| \n'-'     \n        \n        \n        \n        \n",
    '!': u' _  \n| | \n| | \n| | \n|_| \n(_) \n    \n',
    '%': u'     __  \n _  / /  \n(_)/ /   \n  / / _  \n / / (_) \n/_/      \n         \n',
    ')': u" __   \n|_ `. \n  | | \n  | | \n _| | \n|__,' \n      \n",
    '-': u'         \n         \n ______  \n|______| \n         \n         \n         \n',
    '1': u'  __    \n /  |   \n `| |   \n  | |   \n _| |_  \n|_____| \n        \n',
    '5': u" _______   \n|  _____|  \n| |____    \n'_.____''. \n| \\____) | \n \\______.' \n           \n",
    '9': u"  ______   \n.' ____ '. \n| (____) | \n'_.____. | \n| \\____| | \n \\______,' \n           \n",
    '=': u'         \n ______  \n|______| \n ______  \n|______| \n         \n         \n',
    'A': u'      _       \n     / \\      \n    / _ \\     \n   / ___ \\    \n _/ /   \\ \\_  \n|____| |____| \n              \n',
    'E': u' ________  \n|_   __  | \n  | |_ \\_| \n  |  _| _  \n _| |__/ | \n|________| \n           \n',
    'I': u' _____  \n|_   _| \n  | |   \n  | |   \n _| |_  \n|_____| \n        \n',
    'M': u' ____    ____  \n|_   \\  /   _| \n  |   \\/   |   \n  | |\\  /| |   \n _| |_\\/_| |_  \n|_____||_____| \n               \n',
    'Q': u"   ___      \n .'   `.    \n/  .-.  \\   \n| |   | |   \n\\  `-'  \\_  \n `.___.\\__| \n            \n",
    'U': u" _____  _____  \n|_   _||_   _| \n  | |    | |   \n  | '    ' |   \n   \\ \\__/ /    \n    `.__.'     \n               \n",
    'Y': u' ____  ____  \n|_  _||_  _| \n  \\ \\  / /   \n   \\ \\/ /    \n   _|  |_    \n  |______|   \n             \n',
    ']': u' ___  \n|_  | \n  | | \n  | | \n _| | \n|___| \n      \n',
    'a': u"        \n        \n ,--.   \n`'_\\ :  \n// | |, \n\\'-;__/ \n        \n",
    'e': u"        \n        \n .---.  \n/ /__\\\\ \n| \\__., \n '.__.' \n        \n",
    'i': u'  _   \n (_)  \n __   \n[  |  \n | |  \n[___] \n      \n',
    'm': u'              \n              \n _ .--..--.   \n[ `.-. .-. |  \n | | | | | |  \n[___||__||__] \n              \n',
    'q': u"          \n          \n  .--. _  \n/ /'`\\' ] \n| \\__/ |  \n \\__.; |  \n     |__] \n",
    'u': u"          \n          \n __   _   \n[  | | |  \n | \\_/ |, \n '.__.'_/ \n          \n",
    'y': u"          \n          \n  _   __  \n [ \\ [  ] \n  \\ '/ /  \n[\\_:  /   \n \\__.'    \n",
    '}': u" __    \n\\_ `.  \n  | |  \n   > > \n _| |  \n/__.'  \n       \n"}

wavy_dic = {
    ' ': u'  \n  \n  \n  \n',
    '$': u'    \n(I` \n.I) \n    \n',
    '(': u' / \n(  \n \\ \n   \n',
    ',': u'  \n  \no \n/ \n',
    '0': u' _   \n(.\\  \n \\_) \n     \n',
    '4': u'     \n/_(_ \n   ) \n     \n',
    '8': u' _  \n(_) \n(_) \n    \n',
    '<': u'  \n/ \n\\ \n  \n',
    '@': u'  ___  \n / _ ) \n( (_(  \n \\___/ \n',
    'D': u' __  \n ) ) \n/_/  \n     \n',
    'H': u'     \n )_) \n( (  \n     \n',
    'L': u'    \n )  \n(__ \n    \n',
    'P': u' __  \n )_) \n/    \n     \n',
    'T': u'___ \n )  \n(   \n    \n',
    'X': u'   \n(/ \n/) \n   \n',
    '\\': u'   \n\\  \n \\ \n   \n',
    '`': u'  \n\\ \n  \n  \n',
    'd': u'     \n _ ) \n(_(  \n     \n',
    'h': u'     \n( _  \n ) ) \n     \n',
    'l': u'   \n ) \n(  \n   \n',
    'p': u'     \n  _  \n )_) \n(    \n',
    't': u'    \n_)_ \n(_  \n    \n',
    'x': u'   \n   \n\\) \n(\\ \n',
    '|': u'  \n| \n| \n| \n',
    '#': u'       \n _/_/_ \n-/-/-  \n       \n',
    "'": u'  \n| \n  \n  \n',
    '+': u'     \n _|_ \n  |  \n     \n',
    '/': u'   \n / \n/  \n   \n',
    '3': u'_  \n_) \n_) \n   \n',
    '7': u'__  \n  ) \n (  \n    \n',
    ';': u'  \no \no \n/ \n',
    '?': u'_  \n ) \no  \n   \n',
    'C': u'  _  \n / ` \n(_.  \n     \n',
    'G': u'  _  \n / _ \n(__/ \n     \n',
    'K': u'     \n )_/ \n/  ) \n     \n',
    'O': u'  _  \n / ) \n(_/  \n     \n',
    'S': u'  __  \n (_ ` \n.__)  \n      \n',
    'W': u'        \n\\  X  / \n \\/ \\/  \n        \n',
    '[': u' _ \n|  \n|_ \n   \n',
    '_': u'   \n   \n   \n__ \n',
    'c': u'   \n _ \n(_ \n   \n',
    'g': u'     \n _   \n(_(  \n  _) \n',
    'k': u'    \n( _ \n )\\ \n    \n',
    'o': u'    \n _  \n(_) \n    \n',
    's': u'   \n _ \n(  \n_) \n',
    'w': u'      \n      \n)_)_) \n      \n',
    '{': u'  _ \n_|  \n |_ \n    \n',
    '"': u'   \n|| \n   \n   \n',
    '&': u'_  \n\\) \n(X \n   \n',
    '*': u'     \n_\\/_ \n /\\  \n     \n',
    '.': u'  \n  \no \n  \n',
    '2': u'_  \n ) \n/_ \n   \n',
    '6': u' _   \n(__  \n \\_) \n     \n',
    ':': u'  \no \no \n  \n',
    '>': u'  \n\\ \n/ \n  \n',
    'B': u' __  \n )_) \n/__) \n     \n',
    'F': u' ___ \n )_  \n(    \n     \n',
    'J': u'___  \n  (  \n\\__) \n     \n',
    'N': u'      \n )\\ ) \n(  (  \n      \n',
    'R': u' __  \n )_) \n/ \\  \n     \n',
    'V': u'     \n\\  / \n \\/  \n     \n',
    'Z': u'__ \n / \n/_ \n   \n',
    '^': u'   \n/\\ \n   \n   \n',
    'b': u'     \n( _  \n )_) \n     \n',
    'f': u'    \n_(_ \n  ) \n    \n',
    'j': u'   \no  \n(  \n_) \n',
    'n': u'    \n _  \n) ) \n    \n',
    'r': u'   \n _ \n)  \n   \n',
    'v': u'   \n   \n\\) \n   \n',
    'z': u'     \n__   \n  )  \n (__ \n',
    '~': u'    \n/\\/ \n    \n    \n',
    '!': u'  \n| \no \n  \n',
    '%': u'   \no/ \n/o \n   \n',
    ')': u'\\  \n ) \n/  \n   \n',
    '-': u'    \n __ \n    \n    \n',
    '1': u'     \n/(   \n _)_ \n     \n',
    '5': u'__  \n)_  \n _) \n    \n',
    '9': u' _   \n(_\\  \n  _) \n     \n',
    '=': u'   \n__ \n-- \n   \n',
    'A': u'  _  \n /_) \n/ /  \n     \n',
    'E': u' ___ \n )_  \n(__  \n     \n',
    'I': u' ___ \n  )  \n_(_  \n     \n',
    'M': u'      \n )\\/) \n(  (  \n      \n',
    'Q': u'  _  \n / ) \n(_X  \n     \n',
    'U': u'     \n / / \n(_/  \n     \n',
    'Y': u'    \n\\_) \n /  \n    \n',
    ']': u'_  \n | \n_| \n   \n',
    'a': u'    \n _  \n(_( \n    \n',
    'e': u'     \n  _  \n )_) \n(_   \n',
    'i': u'  \no \n( \n  \n',
    'm': u'      \n _ _  \n) ) ) \n      \n',
    'q': u'     \n _   \n(_(  \n   ) \n',
    'u': u'    \n    \n(_( \n    \n',
    'y': u'     \n     \n(_(  \n  _) \n',
    '}': u'_   \n |_ \n_|  \n    \n'}

wetletter_dic = {
    '!': u' .-.  \n |  ) \n | /  \n |/   \n (    \n(_)   \n      \n',
    ' ': u'  \n  \n  \n  \n  \n  \n  \n',
    '#': u'',
    '"': u'       \n )  )  \n(_)(_) \n       \n       \n       \n       \n',
    '%': u'%\n \n \n \n \n \n \n',
    '$': u' \n \n \n \n \n \n \n',
    "'": u"'\n \n \n \n \n \n \n",
    '&': u'&\n \n \n \n \n \n \n',
    ')': u')\n \n \n \n \n \n \n',
    '(': u'(\n \n \n \n \n \n \n',
    '+': u'       \n _||_  \n[_  _] \n  ||   \n  ||   \n       \n       \n',
    '*': u'*\n \n \n \n \n \n \n',
    '-': u"         \n         \n____.___ \n`----==='\n         \n         \n         \n",
    ',': u',\n \n \n \n \n \n \n',
    '/': u'/\n \n \n \n \n \n \n',
    '.': u'.\n \n \n \n \n \n \n',
    '1': u'1\n \n \n \n \n \n \n',
    '0': u'0\n \n \n \n \n \n \n',
    '3': u'3\n \n \n \n \n \n \n',
    '2': u'2\n \n \n \n \n \n \n',
    '5': u'5\n \n \n \n \n \n \n',
    '4': u'4\n \n \n \n \n \n \n',
    '7': u'7\n \n \n \n \n \n \n',
    '6': u'6\n \n \n \n \n \n \n',
    '9': u'9\n \n \n \n \n \n \n',
    '8': u'8\n \n \n \n \n \n \n',
    ';': u'    \n _  \n(_) \n    \n (  \n(_) \n    \n',
    ':': u'    \n _  \n(_) \n    \n _  \n(_) \n    \n',
    '=': u"         \n____.___ \n`----==='\n ___.____\n`===----'\n         \n         \n",
    '<': u'<\n \n \n \n \n \n \n',
    '?': u'?\n \n \n \n \n \n \n',
    '>': u'>\n \n \n \n \n \n \n',
    '@': u'@\n \n \n \n \n \n \n',
    '[': u'[\n \n \n \n \n \n \n',
    ']': u']\n \n \n \n \n \n \n',
    '\\': u'\\\n \n \n \n \n \n \n',
    '_': u'_\n \n \n \n \n \n \n',
    '^': u'^\n \n \n \n \n \n \n',
    'a': u'  .--.   \n / /\\ \\  \n/ /__\\ \\ \n|  __  | \n| |  |)| \n|_|  (_) \n         \n',
    '`': u'`\n \n \n \n \n \n \n',
    'c': u"  ,--,   \n.' .')   \n|  |(_)  \n\\  \\     \n \\  `-.  \n  \\____\\ \n         \n",
    'b': u" ,---.   \n | .-.\\  \n | |-' \\ \n | |--. \\\n | |`-' /\n /( `--' \n(__)     \n",
    'e': u" ,---.   \n | .-'   \n | `-.   \n | .-'   \n |  `--. \n /( __.' \n(__)     \n",
    'd': u' ,\'|"\\   \n | |\\ \\  \n | | \\ \\ \n | |  \\ \\\n /(|`-\' /\n(__)`--\' \n         \n',
    'g': u"  ,--,   \n.' .'    \n|  |  __ \n\\  \\ ( _)\n \\  `-) )\n )\\____/ \n(__)     \n",
    'f': u" ,---. \n | .-' \n | `-. \n | .-' \n | |   \n )\\|   \n(__)   \n",
    'i': u",-. \n|(| \n(_) \n| | \n| | \n`-' \n    \n",
    'h': u" .-. .-. \n | | | | \n | `-' | \n | .-. | \n | | |)| \n /(  (_) \n(__)     \n",
    'k': u",-. .-. \n| |/ /  \n| | /   \n| | \\   \n| |) \\  \n|((_)-' \n(_)     \n",
    'j': u"   .-, \n   | | \n   | | \n   | | \n(`-' | \n \\_ )| \n   (_) \n",
    'm': u"         \n|\\    /| \n|(\\  / | \n(_)\\/  | \n| \\  / | \n| |\\/| | \n'-'  '-' \n",
    'l': u",-.     \n| |     \n| |     \n| |     \n| `--.  \n|( __.' \n(_)     \n",
    'o': u" .---.   \n/ .-. )  \n| | |(_) \n| | | |  \n\\ `-' /  \n )---'   \n(_)      \n",
    'n': u' .-. .-. \n |  \\| | \n |   | | \n | |\\  | \n | | |)| \n /(  (_) \n(__)     \n',
    'q': u'  .---.  \n ( .-. \\ \n(_)| | | \n | ||\\ | \n \\ `-\\\\/ \n  `---\\| \n         \n',
    'p': u" ,---.   \n | .-.\\  \n | |-' ) \n | |--'  \n | |     \n /(      \n(__)     \n",
    's': u"   .---. \n  ( .-._)\n (_) \\   \n _  \\ \\  \n( `-'  ) \n `----'  \n         \n",
    'r': u",---.    \n| .-.\\   \n| `-'/   \n|   (    \n| |\\ \\   \n|_| \\)\\  \n    (__) \n",
    'u': u".-. .-. \n| | | | \n| | | | \n| | | | \n| `-')| \n`---(_) \n        \n",
    't': u" _______ \n|__   __|\n  )| |   \n (_) |   \n   | |   \n   `-'   \n         \n",
    'w': u'.-.  .-. \n| |/\\| | \n| /  \\ | \n|  /\\  | \n|(/  \\ | \n(_)   \\| \n         \n',
    'v': u'.-.   .-.\n \\ \\ / / \n  \\ V /  \n   ) /   \n  (_)    \n         \n         \n',
    'y': u'.-.   .-.\n \\ \\_/ )/\n  \\   (_)\n   ) (   \n   | |   \n  /(_|   \n (__)    \n',
    'x': u".-.   .-.\n ) \\_/ / \n(_)   /  \n  / _ \\  \n / / ) \\ \n`-' (_)-'\n         \n",
    '{': u'{\n \n \n \n \n \n \n',
    'z': u' _____   \n/___  /  \n   / /)  \n  / /(_) \n / /___  \n(_____/  \n         \n',
    '}': u'}\n \n \n \n \n \n \n',
    '|': u'|\n \n \n \n \n \n \n',
    '~': u'~\n \n \n \n \n \n \n'}

whimsy_dic = {
    '!': u'',
    ' ': u'    \n    \n    \n    \n    \n    \n    \n    \n    \n    \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u"          \n          \n          \n d888b8b  \nd8P' ?88  \n88b  ,88b \n`?88P'`88b\n          \n          \n          \n",
    '`': u'',
    'c': u"       \n       \n       \n d8888b\nd8P' `P\n88b    \n`?888P'\n       \n       \n       \n",
    'b': u" d8b      \n ?88      \n  88b     \n  888888b \n  88P `?8b\n d88,  d88\nd88'`?88P'\n          \n          \n          \n",
    'e': u"       \n       \n       \n d8888b\nd8b_,dP\n88b    \n`?888P'\n       \n       \n       \n",
    'd': u"      d8b \n      88P \n     d88  \n d888888  \nd8P' ?88  \n88b  ,88b \n`?88P'`88b\n          \n          \n          \n",
    'g': u"          \n          \n          \n d888b8b  \nd8P' ?88  \n88b  ,88b \n`?88P'`88b\n       )88\n      ,88P\n  `?8888P \n",
    'f': u"   ,d8888b\n   88P'   \nd888888P  \n  ?88'    \n  88P     \n d88      \nd88'      \n          \n          \n          \n",
    'i': u"  d8,\n `8P \n     \n  88b\n  88P\n d88 \nd88' \n     \n     \n     \n",
    'h': u" d8b      \n ?88      \n  88b     \n  888888b \n  88P `?8b\n d88   88P\nd88'   88b\n          \n          \n          \n",
    'k': u" d8b       \n ?88       \n  88b      \n  888  d88'\n  888bd8P' \n d88888b   \nd88' `?88b,\n           \n           \n           \n",
    'j': u'   d8, \n  `8P  \n       \n  d88  \n  ?88  \n   88b \n   `88b\n    )88\n   ,88P\n`?888P \n',
    'm': u"              \n              \n              \n  88bd8b,d88b \n  88P'`?8P'?8b\n d88  d88  88P\nd88' d88'  88b\n              \n              \n              \n",
    'l': u' d8b \n 88P \nd88  \n888  \n?88  \n 88b \n  88b\n     \n     \n     \n',
    'o': u"        \n        \n        \n d8888b \nd8P' ?88\n88b  d88\n`?8888P'\n        \n        \n        \n",
    'n': u"          \n          \n          \n  88bd88b \n  88P' ?8b\n d88   88P\nd88'   88b\n          \n          \n          \n",
    'q': u"          \n          \n          \n.d88b,.88P\n88P  `88P'\n?8b  d88  \n`?888888  \n    `?88  \n      88b \n      ?8P \n",
    'p': u"          \n          \n          \n?88,.d88b,\n`?88'  ?88\n  88b  d8P\n  888888P'\n  88P'    \n d88      \n ?8P      \n",
    's': u"        \n        \n        \n .d888b,\n ?8b,   \n   `?8b \n`?888P' \n        \n        \n        \n",
    'r': u"         \n         \n         \n  88bd88b\n  88P'  `\n d88     \nd88'     \n         \n         \n         \n",
    'u': u"         \n         \n         \n?88   d8P\nd88   88 \n?8(  d88 \n`?88P'?8b\n         \n         \n         \n",
    't': u"        \n   d8P  \nd888888P\n  ?88'  \n  88P   \n  88b   \n  `?8b  \n        \n        \n        \n",
    'w': u"               \n               \n               \n ?88   d8P  d8P\n d88  d8P' d8P'\n ?8b ,88b ,88' \n `?888P'888P'  \n               \n               \n               \n",
    'v': u"         \n         \n         \n?88   d8P\nd88  d8P'\n?8b ,88' \n`?888P'  \n         \n         \n         \n",
    'y': u"          \n          \n          \n?88   d8P \nd88   88  \n?8(  d88  \n`?88P'?8b \n       )88\n      ,d8P\n   `?888P'\n",
    'x': u"         \n         \n         \n?88,  88P\n `?8bd8P'\n d8P?8b, \nd8P' `?8b\n         \n         \n         \n",
    '{': u'',
    'z': u"        \n        \n        \nd88888P \n   d8P' \n d8P'   \nd88888P'\n        \n        \n        \n",
    '}': u'',
    '|': u'',
    '~': u''}

wow_dic = {
    '!': u'!!1 \n',
    ' ': u'  \n',
    '#': u'#\n',
    '"': u"'' \n",
    '%': u'%\n',
    '$': u' \n',
    "'": u"'\n",
    '&': u'&\n',
    ')': u')\n',
    '(': u'(\n',
    '+': u'+ \n',
    '*': u'*\n',
    '-': u'-- \n',
    ',': u',\n',
    '/': u'/\n',
    '.': u'.\n',
    '1': u'1\n',
    '0': u'0\n',
    '3': u'3\n',
    '2': u'2\n',
    '5': u'5\n',
    '4': u'4\n',
    '7': u'7\n',
    '6': u'6\n',
    '9': u'9\n',
    '8': u'8\n',
    ';': u':; \n',
    ':': u':: \n',
    '=': u'::: \n',
    '<': u'<\n',
    '?': u'?\n',
    '>': u'>\n',
    '@': u'@\n',
    '[': u'[\n',
    ']': u']\n',
    '\\': u'\\\n',
    '_': u'_\n',
    '^': u'^\n',
    'a': u'//-\\ \n',
    '`': u'`\n',
    'c': u'<< \n',
    'b': u'][3 \n',
    'e': u']E \n',
    'd': u'][_) \n',
    'g': u'((6 \n',
    'f': u'][= \n',
    'i': u']][ \n',
    'h': u'][-][ \n',
    'k': u'][< \n',
    'j': u';_][ \n',
    'm': u'][\\/][ \n',
    'l': u'][_ \n',
    'o': u'[[]] \n',
    'n': u'][\\][ \n',
    'q': u'[[]]. \n',
    'p': u']]P \n',
    's': u'((5 \n',
    'r': u'][2 \n',
    'u': u'][_][ \n',
    't': u'`][` \n',
    'w': u'\\\\/\\\\/ \n',
    'v': u'\\\\/ \n',
    'y': u'``// \n',
    'x': u'>><< \n',
    '{': u'{\n',
    'z': u'``//. \n',
    '}': u'}\n',
    '|': u'|\n',
    '~': u'~\n'}

alligator3_dic = {
    '!': u'::: \n:+: \n+:+ \n+#+ \n+#+ \n    \n### \n',
    ' ': u'   \n   \n   \n   \n   \n   \n   \n',
    '#': u'   :::   :::    \n   :+:   :+:    \n+:+:+:+:+:+:+:+ \n   +#+   +:+    \n+#+#+#+#+#+#+#+ \n   #+#   #+#    \n   ###   ###    \n',
    '"': u'::: ::: \n:+: :+: \n        \n        \n        \n        \n        \n',
    '%': u':::   :::       \n:+:   :+:       \n      +:+       \n      +#+       \n      +#+       \n      #+#   #+# \n      ###   ### \n',
    '$': u'     :::     \n  :+:+:+:+:  \n+:+  +:+     \n  +#++:++#+  \n     +#+ +#+ \n  #+#+#+#+#  \n     ###     \n',
    "'": u'::: \n:+  \n    \n    \n    \n    \n    \n',
    '&': u' :::::::     \n:+:   :+:    \n +:+ +:+     \n  +#++:  ++# \n +#+ +#+#+#  \n#+#   #+#+   \n ##########  \n',
    ')': u':::   \n :+:  \n  +:+ \n  +#+ \n  +#+ \n #+#  \n###   \n',
    '(': u'  ::: \n :+:  \n+:+   \n+#+   \n+#+   \n #+#  \n  ### \n',
    '+': u'              \n     :+:      \n     +:+      \n+#++:++#++:++ \n     +#+      \n     #+#      \n              \n',
    '*': u'              \n :+:     :+:  \n   +:+ +:+    \n+#++:++#++:++ \n   +#+ +#+    \n #+#     #+#  \n              \n',
    '-': u'              \n              \n              \n+#++:++#++:++ \n              \n              \n              \n',
    ',': u'    \n    \n    \n    \n    \n#+# \n##  \n',
    '/': u'      ::: \n     :+:  \n    +:+   \n   +#+    \n  +#+     \n #+#      \n###       \n',
    '.': u'    \n    \n    \n    \n    \n#+# \n### \n',
    '1': u'  :::   \n:+:+:   \n  +:+   \n  +#+   \n  +#+   \n  #+#   \n####### \n',
    '0': u' :::::::  \n:+:   :+: \n+:+  :+:+ \n+#+ + +:+ \n+#+#  +#+ \n#+#   #+# \n #######  \n',
    '3': u' ::::::::  \n:+:    :+: \n       +:+ \n    +#++:  \n       +#+ \n#+#    #+# \n ########  \n',
    '2': u' ::::::::  \n:+:    :+: \n      +:+  \n    +#+    \n  +#+      \n #+#       \n########## \n',
    '5': u':::::::::: \n:+:    :+: \n+:+        \n+#++:++#+  \n       +#+ \n#+#    #+# \n ########  \n',
    '4': u'    :::     \n   :+:      \n  +:+ +:+   \n +#+  +:+   \n+#+#+#+#+#+ \n      #+#   \n      ###   \n',
    '7': u'::::::::::: \n:+:     :+: \n       +:+  \n      +#+   \n     +#+    \n    #+#     \n    ###     \n',
    '6': u' ::::::::  \n:+:    :+: \n+:+        \n+#++:++#+  \n+#+    +#+ \n#+#    #+# \n ########  \n',
    '9': u' ::::::::  \n:+:    :+: \n+:+    +:+ \n +#++:++#+ \n       +#+ \n#+#    #+# \n ########  \n',
    '8': u' ::::::::  \n:+:    :+: \n+:+    +:+ \n +#++:++#  \n+#+    +#+ \n#+#    #+# \n ########  \n',
    ';': u'    \n:+: \n    \n    \n    \n#+# \n##  \n',
    ':': u'    \n:+: \n    \n    \n    \n#+# \n    \n',
    '=': u'              \n              \n+:+:+:+:+:+:+ \n              \n+#+#+#+#+#+#+ \n              \n              \n',
    '<': u'   ::: \n  :+:  \n +:+   \n+#+    \n +#+   \n  #+#  \n   ### \n',
    '?': u' :::::::::  \n:+:     :+: \n       +:+  \n      +#+   \n    +#+     \n            \n    ###     \n',
    '>': u' :::    \n  :+:   \n   +:+  \n    +#+ \n   +#+  \n  #+#   \n###     \n',
    '@': u'   :::::::::::    \n :+: :+:+:+:+:+:  \n+:+ +:+   +:+ +:+ \n+#+ +:+   +#+ +:+ \n+#+ +#+   +#+ +#+ \n #+# #+#+#+#+#+   \n   #####          \n',
    '[': u':::::: \n:+:    \n+:+    \n+#+    \n+#+    \n#+#    \n###### \n',
    ']': u':::::: \n   :+: \n   +:+ \n   +#+ \n   +#+ \n   #+# \n###### \n',
    '\\': u':::       \n :+:      \n  +:+     \n   +#+    \n    +#+   \n     #+#  \n      ### \n',
    '_': u'           \n           \n           \n           \n           \n           \n########## \n',
    '^': u'    :::     \n  :+: :+:   \n+:+     +:+ \n            \n            \n            \n            \n',
    'a': u'    :::     \n  :+: :+:   \n +:+   +:+  \n+#++:++#++: \n+#+     +#+ \n#+#     #+# \n###     ### \n',
    '`': u'::: \n :+ \n    \n    \n    \n    \n    \n',
    'c': u' ::::::::  \n:+:    :+: \n+:+        \n+#+        \n+#+        \n#+#    #+# \n ########  \n',
    'b': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#+  \n+#+    +#+ \n#+#    #+# \n#########  \n',
    'e': u':::::::::: \n:+:        \n+:+        \n+#++:++#   \n+#+        \n#+#        \n########## \n',
    'd': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n#########  \n',
    'g': u' ::::::::  \n:+:    :+: \n+:+        \n:#:        \n+#+   +#+# \n#+#    #+# \n ########  \n',
    'f': u':::::::::: \n:+:        \n+:+        \n:#::+::#   \n+#+        \n#+#        \n###        \n',
    'i': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n    #+#     \n########### \n',
    'h': u':::    ::: \n:+:    :+: \n+:+    +:+ \n+#++:++#++ \n+#+    +#+ \n#+#    #+# \n###    ### \n',
    'k': u':::    ::: \n:+:   :+:  \n+:+  +:+   \n+#++:++    \n+#+  +#+   \n#+#   #+#  \n###    ### \n',
    'j': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n#+# #+#     \n #####      \n',
    'm': u'::::    ::::  \n+:+:+: :+:+:+ \n+:+ +:+:+ +:+ \n+#+  +:+  +#+ \n+#+       +#+ \n#+#       #+# \n###       ### \n',
    'l': u':::        \n:+:        \n+:+        \n+#+        \n+#+        \n#+#        \n########## \n',
    'o': u' ::::::::  \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n ########  \n',
    'n': u'::::    ::: \n:+:+:   :+: \n:+:+:+  +:+ \n+#+ +:+ +#+ \n+#+  +#+#+# \n#+#   #+#+# \n###    #### \n',
    'q': u' ::::::::   \n:+:    :+:  \n+:+    +:+  \n+#+    +:+  \n+#+  # +#+  \n#+#   +#+   \n ###### ### \n',
    'p': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#+  \n+#+        \n#+#        \n###        \n',
    's': u' ::::::::  \n:+:    :+: \n+:+        \n+#++:++#++ \n       +#+ \n#+#    #+# \n ########  \n',
    'r': u':::::::::  \n:+:    :+: \n+:+    +:+ \n+#++:++#:  \n+#+    +#+ \n#+#    #+# \n###    ### \n',
    'u': u':::    ::: \n:+:    :+: \n+:+    +:+ \n+#+    +:+ \n+#+    +#+ \n#+#    #+# \n ########  \n',
    't': u'::::::::::: \n    :+:     \n    +:+     \n    +#+     \n    +#+     \n    #+#     \n    ###     \n',
    'w': u':::       ::: \n:+:       :+: \n+:+       +:+ \n+#+  +:+  +#+ \n+#+ +#+#+ +#+ \n #+#+# #+#+#  \n  ###   ###   \n',
    'v': u':::     ::: \n:+:     :+: \n+:+     +:+ \n+#+     +:+ \n +#+   +#+  \n  #+#+#+#   \n    ###     \n',
    'y': u':::   ::: \n:+:   :+: \n +:+ +:+  \n  +#++:   \n   +#+    \n   #+#    \n   ###    \n',
    'x': u':::    ::: \n:+:    :+: \n +:+  +:+  \n  +#++:+   \n +#+  +#+  \n#+#    #+# \n###    ### \n',
    '{': u'   :::: \n  :+:   \n  +:+   \n+#+     \n  +#+   \n  #+#   \n   #### \n',
    'z': u'::::::::: \n     :+:  \n    +:+   \n   +#+    \n  +#+     \n #+#      \n######### \n',
    '}': u'::::    \n  :+:   \n  +:+   \n    +#+ \n  +#+   \n  #+#   \n####    \n',
    '|': u'::: \n:+: \n+:+ \n    \n+#+ \n#+# \n### \n',
    '~': u'  :::::   ::: \n:+:   :+:+:   \n              \n              \n              \n              \n              \n'}

alpha_dic = {
    '!': u'         /\\         \n        /  \\        \n       /    \\       \n      /      \\      \n     /        \\     \n    /          \\    \n   /            \\   \n  /              \\  \n /     Lennert    \\ \n/       Stock      \\\n\\       1994       /\n \\                / \n  \\              /  \n   \\            /   \n    \\          /    \n     \\        /     \n      \\      /      \n       \\    /       \n        \\  /        \n         \\/         \n                    \n                    \n',
    ' ': u'        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n        \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'',
    '1': u'',
    '0': u'',
    '3': u'',
    '2': u'',
    '5': u'',
    '4': u'',
    '7': u'',
    '6': u'',
    '9': u'',
    '8': u'',
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/__\\:::\\    \\    \n   /::::\\   \\:::\\    \\   \n  /::::::\\   \\:::\\    \\  \n /:::/\\:::\\   \\:::\\    \\ \n/:::/  \\:::\\   \\:::\\____\\\n\\::/    \\:::\\  /:::/    /\n \\/____/ \\:::\\/:::/    / \n          \\::::::/    /  \n           \\::::/    /   \n           /:::/    /    \n          /:::/    /     \n         /:::/    /      \n        /:::/    /       \n        \\::/    /        \n         \\/____/         \n                         \n',
    '`': u'',
    'c': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/  \\:::\\    \\    \n   /:::/    \\:::\\    \\   \n  /:::/    / \\:::\\    \\  \n /:::/    /   \\:::\\    \\ \n/:::/____/     \\:::\\____\\\n\\:::\\    \\      \\::/    /\n \\:::\\    \\      \\/____/ \n  \\:::\\    \\             \n   \\:::\\    \\            \n    \\:::\\    \\           \n     \\:::\\    \\          \n      \\:::\\    \\         \n       \\:::\\____\\        \n        \\::/    /        \n         \\/____/         \n                         \n',
    'b': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/__\\:::\\    \\    \n   /::::\\   \\:::\\    \\   \n  /::::::\\   \\:::\\    \\  \n /:::/\\:::\\   \\:::\\ ___\\ \n/:::/__\\:::\\   \\:::|    |\n\\:::\\   \\:::\\  /:::|____|\n \\:::\\   \\:::\\/:::/    / \n  \\:::\\   \\::::::/    /  \n   \\:::\\   \\::::/    /   \n    \\:::\\  /:::/    /    \n     \\:::\\/:::/    /     \n      \\::::::/    /      \n       \\::::/    /       \n        \\::/____/        \n         ~~              \n                         \n',
    'e': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/__\\:::\\    \\    \n   /::::\\   \\:::\\    \\   \n  /::::::\\   \\:::\\    \\  \n /:::/\\:::\\   \\:::\\    \\ \n/:::/__\\:::\\   \\:::\\____\\\n\\:::\\   \\:::\\   \\::/    /\n \\:::\\   \\:::\\   \\/____/ \n  \\:::\\   \\:::\\    \\     \n   \\:::\\   \\:::\\____\\    \n    \\:::\\   \\::/    /    \n     \\:::\\   \\/____/     \n      \\:::\\    \\         \n       \\:::\\____\\        \n        \\::/    /        \n         \\/____/         \n                         \n',
    'd': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/  \\:::\\    \\    \n   /:::/    \\:::\\    \\   \n  /:::/    / \\:::\\    \\  \n /:::/    /   \\:::\\ ___\\ \n/:::/____/     \\:::|    |\n\\:::\\    \\     /:::|____|\n \\:::\\    \\   /:::/    / \n  \\:::\\    \\ /:::/    /  \n   \\:::\\    /:::/    /   \n    \\:::\\  /:::/    /    \n     \\:::\\/:::/    /     \n      \\::::::/    /      \n       \\::::/    /       \n        \\::/____/        \n         ~~              \n                         \n',
    'g': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/  \\:::\\    \\    \n   /:::/    \\:::\\    \\   \n  /:::/    / \\:::\\    \\  \n /:::/    /   \\:::\\ ___\\ \n/:::/____/  ___\\:::|    |\n\\:::\\    \\ /\\  /:::|____|\n \\:::\\    /::\\ \\::/    / \n  \\:::\\   \\:::\\ \\/____/  \n   \\:::\\   \\:::\\____\\    \n    \\:::\\  /:::/    /    \n     \\:::\\/:::/    /     \n      \\::::::/    /      \n       \\::::/    /       \n        \\::/____/        \n                         \n                         \n',
    'f': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/__\\:::\\    \\    \n   /::::\\   \\:::\\    \\   \n  /::::::\\   \\:::\\    \\  \n /:::/\\:::\\   \\:::\\    \\ \n/:::/  \\:::\\   \\:::\\____\\\n\\::/    \\:::\\   \\::/    /\n \\/____/ \\:::\\   \\/____/ \n          \\:::\\    \\     \n           \\:::\\____\\    \n            \\::/    /    \n             \\/____/     \n                         \n                         \n                         \n                         \n                         \n',
    'i': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n        \\:::\\    \\       \n         \\:::\\    \\      \n          \\:::\\    \\     \n           \\:::\\    \\    \n           /::::\\    \\   \n  ____    /::::::\\    \\  \n /\\   \\  /:::/\\:::\\    \\ \n/::\\   \\/:::/  \\:::\\____\\\n\\:::\\  /:::/    \\::/    /\n \\:::\\/:::/    / \\/____/ \n  \\::::::/    /          \n   \\::::/____/           \n    \\:::\\    \\           \n     \\:::\\    \\          \n      \\:::\\    \\         \n       \\:::\\____\\        \n        \\::/    /        \n         \\/____/         \n                         \n',
    'h': u'          _____          \n         /\\    \\         \n        /::\\____\\        \n       /:::/    /        \n      /:::/    /         \n     /:::/    /          \n    /:::/____/           \n   /::::\\    \\           \n  /::::::\\    \\   _____  \n /:::/\\:::\\    \\ /\\    \\ \n/:::/  \\:::\\    /::\\____\\\n\\::/    \\:::\\  /:::/    /\n \\/____/ \\:::\\/:::/    / \n          \\::::::/    /  \n           \\::::/    /   \n           /:::/    /    \n          /:::/    /     \n         /:::/    /      \n        /:::/    /       \n        \\::/    /        \n         \\/____/         \n                         \n',
    'k': u'          _____          \n         /\\    \\         \n        /::\\____\\        \n       /:::/    /        \n      /:::/    /         \n     /:::/    /          \n    /:::/____/           \n   /::::\\    \\           \n  /::::::\\____\\________  \n /:::/\\:::::::::::\\    \\ \n/:::/  |:::::::::::\\____\\\n\\::/   |::|~~~|~~~~~     \n \\/____|::|   |          \n       |::|   |          \n       |::|   |          \n       |::|   |          \n       |::|   |          \n       |::|   |          \n       \\::|   |          \n        \\:|   |          \n         \\|___|          \n                         \n',
    'j': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n        \\:::\\    \\       \n         \\:::\\    \\      \n          \\:::\\    \\     \n           \\:::\\    \\    \n           /::::\\    \\   \n  _____   /::::::\\    \\  \n /\\    \\ /:::/\\:::\\    \\ \n/::\\    /:::/  \\:::\\____\\\n\\:::\\  /:::/    \\::/    /\n \\:::\\/:::/    / \\/____/ \n  \\::::::/    /          \n   \\::::/    /           \n    \\::/    /            \n     \\/____/             \n                         \n                         \n                         \n                         \n                         \n',
    'm': u'          _____          \n         /\\    \\         \n        /::\\____\\        \n       /::::|   |        \n      /:::::|   |        \n     /::::::|   |        \n    /:::/|::|   |        \n   /:::/ |::|   |        \n  /:::/  |::|___|______  \n /:::/   |::::::::\\    \\ \n/:::/    |:::::::::\\____\\\n\\::/    / ~~~~~/:::/    /\n \\/____/      /:::/    / \n             /:::/    /  \n            /:::/    /   \n           /:::/    /    \n          /:::/    /     \n         /:::/    /      \n        /:::/    /       \n        \\::/    /        \n         \\/____/         \n                         \n',
    'l': u'          _____  \n         /\\    \\ \n        /::\\____\\\n       /:::/    /\n      /:::/    / \n     /:::/    /  \n    /:::/    /   \n   /:::/    /    \n  /:::/    /     \n /:::/    /      \n/:::/____/       \n\\:::\\    \\       \n \\:::\\    \\      \n  \\:::\\    \\     \n   \\:::\\    \\    \n    \\:::\\    \\   \n     \\:::\\    \\  \n      \\:::\\    \\ \n       \\:::\\____\\\n        \\::/    /\n         \\/____/ \n                 \n',
    'o': u'         _______         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /::::::::\\    \\     \n    /:::/~~\\:::\\    \\    \n   /:::/    \\:::\\    \\   \n  /:::/    / \\:::\\    \\  \n /:::/____/   \\:::\\____\\ \n|:::|    |     |:::|    |\n|:::|____|     |:::|    |\n \\:::\\    \\   /:::/    / \n  \\:::\\    \\ /:::/    /  \n   \\:::\\    /:::/    /   \n    \\:::\\__/:::/    /    \n     \\::::::::/    /     \n      \\::::::/    /      \n       \\::::/    /       \n        \\::/____/        \n         ~~              \n                         \n                         \n',
    'n': u'          _____          \n         /\\    \\         \n        /::\\____\\        \n       /::::|   |        \n      /:::::|   |        \n     /::::::|   |        \n    /:::/|::|   |        \n   /:::/ |::|   |        \n  /:::/  |::|   | _____  \n /:::/   |::|   |/\\    \\ \n/:: /    |::|   /::\\____\\\n\\::/    /|::|  /:::/    /\n \\/____/ |::| /:::/    / \n         |::|/:::/    /  \n         |::::::/    /   \n         |:::::/    /    \n         |::::/    /     \n         /:::/    /      \n        /:::/    /       \n        \\::/    /        \n         \\/____/         \n                         \n',
    'q': u'         _______         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /::::::::\\    \\     \n    /:::/~~\\:::\\    \\    \n   /:::/    \\:::\\    \\   \n  /:::/    / \\:::\\    \\  \n /:::/____/   \\:::\\____\\ \n|:::|    |     |:::|    |\n|:::|____|     |:::|____|\n \\:::\\   _\\___/:::/    / \n  \\:::\\ |::| /:::/    /  \n   \\:::\\|::|/:::/    /   \n    \\::::::::::/    /    \n     \\::::::::/    /     \n      \\::::::/    /      \n       \\::::/____/       \n        |::|    |        \n        |::|____|        \n         ~~              \n                         \n',
    'p': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/__\\:::\\    \\    \n   /::::\\   \\:::\\    \\   \n  /::::::\\   \\:::\\    \\  \n /:::/\\:::\\   \\:::\\____\\ \n/:::/  \\:::\\   \\:::|    |\n\\::/    \\:::\\  /:::|____|\n \\/_____/\\:::\\/:::/    / \n          \\::::::/    /  \n           \\::::/    /   \n            \\::/____/    \n             ~~          \n                         \n                         \n                         \n                         \n                         \n',
    's': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/__\\:::\\    \\    \n    \\:::\\   \\:::\\    \\   \n  ___\\:::\\   \\:::\\    \\  \n /\\   \\:::\\   \\:::\\    \\ \n/::\\   \\:::\\   \\:::\\____\\\n\\:::\\   \\:::\\   \\::/    /\n \\:::\\   \\:::\\   \\/____/ \n  \\:::\\   \\:::\\    \\     \n   \\:::\\   \\:::\\____\\    \n    \\:::\\  /:::/    /    \n     \\:::\\/:::/    /     \n      \\::::::/    /      \n       \\::::/    /       \n        \\::/    /        \n         \\/____/         \n                         \n',
    'r': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n       /::::\\    \\       \n      /::::::\\    \\      \n     /:::/\\:::\\    \\     \n    /:::/__\\:::\\    \\    \n   /::::\\   \\:::\\    \\   \n  /::::::\\   \\:::\\    \\  \n /:::/\\:::\\   \\:::\\____\\ \n/:::/  \\:::\\   \\:::|    |\n\\::/   |::::\\  /:::|____|\n \\/____|:::::\\/:::/    / \n       |:::::::::/    /  \n       |::|\\::::/    /   \n       |::| \\::/____/    \n       |::|  ~|          \n       |::|   |          \n       \\::|   |          \n        \\:|   |          \n         \\|___|          \n                         \n',
    'u': u'          _____          \n         /\\    \\         \n        /::\\____\\        \n       /:::/    /        \n      /:::/    /         \n     /:::/    /          \n    /:::/    /           \n   /:::/    /            \n  /:::/    /      _____  \n /:::/____/      /\\    \\ \n|:::|    /      /::\\____\\\n|:::|____\\     /:::/    /\n \\:::\\    \\   /:::/    / \n  \\:::\\    \\ /:::/    /  \n   \\:::\\    /:::/    /   \n    \\:::\\__/:::/    /    \n     \\::::::::/    /     \n      \\::::::/    /      \n       \\::::/    /       \n        \\::/____/        \n         ~~              \n                         \n',
    't': u'      _____          \n     /\\    \\         \n    /::\\    \\        \n    \\:::\\    \\       \n     \\:::\\    \\      \n      \\:::\\    \\     \n       \\:::\\    \\    \n       /::::\\    \\   \n      /::::::\\    \\  \n     /:::/\\:::\\    \\ \n    /:::/  \\:::\\____\\\n   /:::/    \\::/    /\n  /:::/    / \\/____/ \n /:::/    /          \n/:::/    /           \n\\::/    /            \n \\/____/             \n                     \n                     \n                     \n                     \n                     \n',
    'w': u'          _____          \n         /\\    \\         \n        /::\\____\\        \n       /:::/    /        \n      /:::/   _/___      \n     /:::/   /\\    \\     \n    /:::/   /::\\____\\    \n   /:::/   /:::/    /    \n  /:::/   /:::/   _/___  \n /:::/___/:::/   /\\    \\ \n|:::|   /:::/   /::\\____\\\n|:::|__/:::/   /:::/    /\n \\:::\\/:::/   /:::/    / \n  \\::::::/   /:::/    /  \n   \\::::/___/:::/    /   \n    \\:::\\__/:::/    /    \n     \\::::::::/    /     \n      \\::::::/    /      \n       \\::::/    /       \n        \\::/____/        \n         ~~              \n                         \n',
    'v': u'          _____          \n         /\\    \\         \n        /::\\____\\        \n       /:::/    /        \n      /:::/    /         \n     /:::/    /          \n    /:::/____/           \n    |::|    |            \n    |::|    |     _____  \n    |::|    |    /\\    \\ \n    |::|    |   /::\\____\\\n    |::|    |  /:::/    /\n    |::|    | /:::/    / \n    |::|____|/:::/    /  \n    |:::::::::::/    /   \n    \\::::::::::/____/    \n     ~~~~~~~~~~          \n                         \n                         \n                         \n                         \n                         \n',
    'y': u'      _____          \n     |\\    \\         \n     |:\\____\\        \n     |::|   |        \n     |::|   |        \n     |::|   |        \n     |::|   |        \n     |::|   |        \n     |::|___|______  \n     /::::::::\\    \\ \n    /::::::::::\\____\\\n   /:::/~~~~/~~      \n  /:::/    /         \n /:::/    /          \n/:::/    /           \n\\::/    /            \n \\/____/             \n                     \n                     \n                     \n                     \n                     \n',
    'x': u'                        \n        ______          \n       |::|   |         \n       |::|   |         \n       |::|   |         \n       |::|   |         \n       |::|   |         \n       |::|   |         \n       |::|   |         \n ______|::|___|___ ____ \n|:::::::::::::::::|    |\n|:::::::::::::::::|____|\n ~~~~~~|::|~~~|~~~      \n       |::|   |         \n       |::|   |         \n       |::|   |         \n       |::|   |         \n       |::|   |         \n       |::|   |         \n       |::|___|         \n        ~~              \n                        \n',
    '{': u'',
    'z': u'          _____          \n         /\\    \\         \n        /::\\    \\        \n        \\:::\\    \\       \n         \\:::\\    \\      \n          \\:::\\    \\     \n           \\:::\\    \\    \n            \\:::\\    \\   \n             \\:::\\    \\  \n              \\:::\\    \\ \n_______________\\:::\\____\\\n\\::::::::::::::::::/    /\n \\::::::::::::::::/____/ \n  \\:::\\~~~~\\~~~~~~       \n   \\:::\\    \\            \n    \\:::\\    \\           \n     \\:::\\    \\          \n      \\:::\\    \\         \n       \\:::\\____\\        \n        \\::/    /        \n         \\/____/         \n                         \n',
    '}': u'',
    '|': u'',
    '~': u''}

amc3liv1_dic = {
    '!': u'        \n.:;s ;: \n        \n        \n',
    ' ': u'     \n     \n     \n     \n',
    '#': u'',
    '"': u'',
    '%': u'',
    '$': u'',
    "'": u'',
    '&': u'',
    ')': u'',
    '(': u'',
    '+': u'',
    '*': u'',
    '-': u'',
    ',': u'',
    '/': u'',
    '.': u'        \n     ;: \n        \n        \n',
    '1': u"      . \n.:;s;:: \n`     ' \n        \n",
    '0': u".:;S;:. \nS ./' S \n`:;S;:' \n        \n",
    '3': u".:;.;:. \nS  S  S \n`     ' \n        \n",
    '2': u".:;.  . \nS  S  S \n`  `::' \n        \n",
    '5': u".  .;:. \nS  S  S \n`:;'  ' \n        \n",
    '4': u".:;.;:. \n   S    \n`:;'    \n        \n",
    '7': u".:;.    \nS  S    \n`  `;:' \n        \n",
    '6': u".  .;:. \nS  S  S \n`:;;;:' \n        \n",
    '9': u".:;;;:. \nS  S  S \n`:;'  ' \n        \n",
    '8': u".:;.;:. \nS  S  S \n`:;';:' \n        \n",
    ';': u'',
    ':': u'',
    '=': u'',
    '<': u'',
    '?': u'',
    '>': u'',
    '@': u'',
    '[': u'',
    ']': u'',
    '\\': u'',
    '_': u'',
    '^': u'',
    'a': u".:;S;:. \nS  S    \n`:;S;:' \n        \n",
    '`': u'',
    'c': u"        \nS     S \n`:;S;:' \n        \n",
    'b': u".:;.;:. \nS  S  S \n`:;S;:' \n        \n",
    'e': u"        \nS  S  S \n`:;S;:' \n        \n",
    'd': u" .:;:.  \nS     S \n`:;S;:' \n        \n",
    'g': u".:  ;:. \nS   ' S \n`:;S;:' \n        \n",
    'f': u"        \nS  S    \n`:;S;:' \n        \n",
    'i': u"        \n.:;s;:' \n        \n        \n",
    'h': u".:;S;:. \n   S    \n`:;S;:' \n        \n",
    'k': u".     . \n `:s:'  \n`:;S;:' \n        \n",
    'j': u".:;.;:. \n      S \n     :' \n        \n",
    'm': u".:;S;:. \n )      \n`:;S;:' \n        \n",
    'l': u"     :. \n      S \n`:;S;:' \n        \n",
    'o': u".:;S;:. \nS     S \n`:;S;:' \n        \n",
    'n': u".:;S;:. \n /      \n`:;S;:' \n        \n",
    'q': u".:;S;:/ \nS     S \n`:;S;:' \n        \n",
    'p': u".::.    \nS  S    \n`:;S;:' \n        \n",
    's': u".: S;:. \nS  S  S \n`:;S :' \n        \n",
    'r': u".:;.;:. \nS  S    \n`:;S;:' \n        \n",
    'u': u".:;S;:. \n      S \n`:;S;:' \n        \n",
    't': u".       \nS:;s;:' \n`       \n        \n",
    'w': u".:;S;:. \n     (  \n`:;S;:' \n        \n",
    'v': u".:;S;.  \n     :: \n`:;S;'  \n        \n",
    'y': u".:;.    \n   S;;: \n`::'    \n        \n",
    'x': u".:;.;:. \n   S    \n`:;';:' \n        \n",
    '{': u'',
    'z': u".:;S  . \nS  S  S \n`  S;:' \n        \n",
    '}': u'',
    '|': u'',
    '~': u''}

ascii_new_roman_dic = {
    '!': u' __, \n(-V  \n _o  \n(    \n',
    ' ': u'  \n  \n  \n  \n',
    '#': u'',
    '"': u'"\n \n \n \n',
    '%': u" _,  _,\n(-o ,' \n _,',o'\n(      \n",
    '$': u' _||_, \n(-(__  \n _||_) \n(      \n',
    "'": u' __, \n(-/  \n     \n     \n',
    '&': u'&\n \n \n \n',
    ')': u' ___, \n(-\\\\  \n _//_ \n(     \n',
    '(': u' ____, \n(-//   \n _\\\\_  \n(      \n',
    '+': u' ___,  \n(-_|_. \n  _|   \n (     \n',
    '*': u'*\n \n \n \n',
    '-': u'       \n ____, \n(      \n       \n',
    ',': u',\n \n \n \n',
    '/': u'  ___, \n (-//  \n _//_  \n(      \n',
    '.': u'.\n \n \n \n',
    '1': u" ___, \n(-/|  \n '_|, \n (    \n",
    '0': u' _____,\n(-/ /\\ \n _\\/_/ \n(      \n',
    '3': u' __, \n(-_) \n __) \n(    \n',
    '2': u" __,  \n(- )  \n ,'_, \n(     \n",
    '5': u' ____, \n(-|_   \n  __)  \n (     \n',
    '4': u' ____, \n(-/_|_,\n   _|, \n  (    \n',
    '7': u' ___, \n(- /  \n _/,  \n(     \n',
    '6': u'  ___, \n (-/_  \n _(__) \n(      \n',
    '9': u' _____,\n(-(__) \n  __/, \n (     \n',
    '8': u' _____,\n(-(__) \n _(__) \n(      \n',
    ';': u' __, \n(-o  \n _p  \n(    \n',
    ':': u' __, \n(-o  \n _o  \n(    \n',
    '=': u'=\n \n \n \n',
    '<': u'<\n \n \n \n',
    '?': u' _____,\n(-(  _)\n   _(, \n  (    \n',
    '>': u'>\n \n \n \n',
    '@': u'  ___, \n (-/_\\ \n _((_/_\n(      \n',
    '[': u'[\n \n \n \n',
    ']': u']\n \n \n \n',
    '\\': u' _,    \n(-\\\\   \n  _\\\\, \n (     \n',
    '_': u'_\n \n \n \n',
    '^': u" ___, \n(-/\\  \n '  ` \n      \n",
    'a': u'  ____,\n (-/_| \n _/  |,\n(      \n',
    '`': u'`\n \n \n \n',
    'c': u' ____, \n(-/    \n _\\__, \n(      \n',
    'b': u' ____  \n(-|__) \n _|__) \n(      \n',
    'e': u' ____, \n(-|_,  \n _|__, \n(      \n',
    'd': u' ____, \n(-|  \\ \n _|__/ \n(      \n',
    'g': u' ____, \n(-/ _, \n _\\__| \n(      \n',
    'f': u' ____, \n(-|_,  \n _|    \n(      \n',
    'i': u' __,  \n(-|   \n _|_, \n(     \n',
    'h': u' __, _,\n(-|__| \n _|  |,\n(      \n',
    'k': u' __, , \n( |_/  \n _| \\, \n(      \n',
    'j': u'  _,  \n (-|  \n __|, \n(     \n',
    'm': u' __, _,\n(-|\\/| \n _| _|,\n(      \n',
    'l': u' __,   \n(-|    \n _|__, \n(      \n',
    'o': u' ____, \n(-/  \\ \n _\\__/,\n(      \n',
    'n': u' _,  _,\n(-|\\ | \n _| \\|,\n(      \n',
    'q': u' ____, \n(-/  \\ \n _\\_\\/,\n(      \n',
    'p': u' ____, \n(-|__) \n _|    \n(      \n',
    's': u' ____, \n(-(__  \n ____) \n(      \n',
    'r': u' ____, \n(-|__) \n _|  \\,\n(      \n',
    'u': u' _, _, \n(-|  \\ \n _|__/ \n(      \n',
    't': u' ____, \n(-|    \n _|,   \n(      \n',
    'w': u' _   _,\n(-|  | \n _|/\\|,\n(      \n',
    'v': u' __  _,\n(-\\  / \n  _\\/  \n (     \n',
    'y': u' _  _, \n(-\\_/  \n  _|,  \n (     \n',
    'x': u' _, _, \n(-\\_/  \n _/ \\, \n(      \n',
    '{': u'{\n \n \n \n',
    'z': u' ___,  \n(- /   \n _/__, \n(      \n',
    '}': u'}\n \n \n \n',
    '|': u' __, \n(-|  \n  |  \n _|, \n',
    '~': u'~\n \n \n \n'}

B1FF_dic = {
    '!': u'!\n',
    ' ': u' \n',
    '#': u'#\n',
    '"': u'"\n',
    '%': u'%\n',
    '$': u'$\n',
    "'": u"'\n",
    '&': u'&\n',
    ')': u')\n',
    '(': u'(\n',
    '+': u'+\n',
    '*': u'*\n',
    '-': u'-\n',
    ',': u',\n',
    '/': u'/\n',
    '.': u'.\n',
    '1': u'1\n',
    '0': u'0\n',
    '3': u'3\n',
    '2': u'2\n',
    '5': u'5\n',
    '4': u'4\n',
    '7': u'7\n',
    '6': u'6\n',
    '9': u'9\n',
    '8': u'8\n',
    ';': u';\n',
    ':': u':\n',
    '=': u'=\n',
    '<': u'<\n',
    '?': u'?\n',
    '>': u'>\n',
    '@': u'@\n',
    '[': u'[\n',
    ']': u']\n',
    '\\': u'\\\n',
    '_': u'_\n',
    '^': u'^\n',
    'a': u'/-\\\n',
    '`': u'`\n',
    'c': u'(\n',
    'b': u'|3\n',
    'e': u'3\n',
    'd': u'|)\n',
    'g': u'6\n',
    'f': u'F\n',
    'i': u'1\n',
    'h': u'H\n',
    'k': u'/<\n',
    'j': u'_/\n',
    'm': u'/\\/\\\n',
    'l': u'|_\n',
    'o': u'0\n',
    'n': u'/\\/\n',
    'q': u'Q\n',
    'p': u'P\n',
    's': u'5\n',
    'r': u'R\n',
    'u': u'|_|\n',
    't': u'T\n',
    'w': u'\\/\\/\n',
    'v': u'\\/\n',
    'y': u'Y\n',
    'x': u'X\n',
    '{': u'{\n',
    'z': u'Z\n',
    '}': u'}\n',
    '|': u'|\n',
    '~': u'~\n'}

dwhistled_dic = {
    ' ': u' \n \n \n \n \n \n \n \n \n \n',
    '$': u' \n \n \n \n \n \n \n \n \n \n',
    '(': u'(\n \n \n \n \n \n \n \n(\n \n',
    ',': u',\n \n \n \n \n \n \n \n,\n \n',
    '0': u'0\n \n \n \n \n \n \n \n0\n \n',
    '4': u'4\n \n \n \n \n \n \n \n4\n \n',
    '8': u'8\n \n \n \n \n \n \n \n8\n \n',
    '<': u'<\n \n \n \n \n \n \n \n<\n \n',
    '@': u'',
    'D': u' \nx\nx\nx\nx\nx\nx\n \nD\n \n',
    'H': u'H\n \n \n \n \n \n \n \nH\n \n',
    'L': u'L\n \n \n \n \n \n \n \nL\n \n',
    'P': u'P\n \n \n \n \n \n \n \nP\n \n',
    'T': u'T\n \n \n \n \n \n \n \nT\n \n',
    'X': u'X\n \n \n \n \n \n \n \nX\n \n',
    '\\': u'\\\n \n \n \n \n \n \n \n\\\n \n',
    '`': u'`\n \n \n \n \n \n \n \n`\n \n',
    'd': u' \nX\nX\nX\nX\nX\nX\n \nd\n \n',
    'h': u'h\n \n \n \n \n \n \n \nh\n \n',
    'l': u'l\n \n \n \n \n \n \n \nl\n \n',
    'p': u'p\n \n \n \n \n \n \n \np\n \n',
    't': u't\n \n \n \n \n \n \n \nt\n \n',
    'x': u'x\n \n \n \n \n \n \n \nx\n \n',
    '|': u'|\n|\n|\n|\n|\n|\n|\n|\n|\n \n',
    '#': u'#\n \n \n \n \n \n \n \n#\n \n',
    "'": u"'\n \n \n \n \n \n \n \n'\n \n",
    '+': u'+\n \n \n \n \n \n \n \n+\n \n',
    '/': u'/\n \n \n \n \n \n \n \n/\n \n',
    '3': u'3\n \n \n \n \n \n \n \n3\n \n',
    '7': u'7\n \n \n \n \n \n \n \n7\n \n',
    ';': u';\n \n \n \n \n \n \n \n;\n \n',
    '?': u'?\n \n \n \n \n \n \n \n?\n \n',
    'C': u' \n.\n.\n.\n.\n.\n.\n \nC\n \n',
    'G': u' \nx\nx\nx\n.\n.\n.\n \nG\n \n',
    'K': u'K\n \n \n \n \n \n \n \nK\n \n',
    'O': u'O\n \n \n \n \n \n \n \nO\n \n',
    'S': u'S\n \n \n \n \n \n \n \nS\n \n',
    'W': u'W\n \n \n \n \n \n \n \nW\n \n',
    '[': u'[\n \n \n \n \n \n \n \n[\n \n',
    '_': u'_\n \n \n \n \n \n \n \n_\n \n',
    'c': u' \n.\n.\n.\n.\n.\n.\n \nc\n \n',
    'g': u' \nX\nX\nX\n.\n.\n.\n \ng\n \n',
    'k': u'k\n \n \n \n \n \n \n \nk\n \n',
    'o': u'o\n \n \n \n \n \n \n \no\n \n',
    's': u's\n \n \n \n \n \n \n \ns\n \n',
    'w': u'w\n \n \n \n \n \n \n \nw\n \n',
    '{': u'{\n \n \n \n \n \n \n \n{\n \n',
    '"': u'"\n \n \n \n \n \n \n \n"\n \n',
    '&': u'&\n \n \n \n \n \n \n \n&\n \n',
    '*': u'*\n \n \n \n \n \n \n \n*\n \n',
    '.': u'.\n \n \n \n \n \n \n \n.\n \n',
    '2': u'2\n \n \n \n \n \n \n \n2\n \n',
    '6': u'6\n \n \n \n \n \n \n \n6\n \n',
    ':': u':\n \n \n \n \n \n \n \n:\n \n',
    '>': u'>\n \n \n \n \n \n \n \n>\n \n',
    'B': u' \nx\n.\n.\n.\n.\n.\n \nB\n \n',
    'F': u' \nx\nx\nx\nx\n.\n.\n \nF\n \n',
    'J': u'J\n \n \n \n \n \n \n \nJ\n \n',
    'N': u'N\n \n \n \n \n \n \n \nN\n \n',
    'R': u'R\n \n \n \n \n \n \n \nR\n \n',
    'V': u'V\n \n \n \n \n \n \n \nV\n \n',
    'Z': u'Z\n \n \n \n \n \n \n \nZ\n \n',
    '^': u'^\n \n \n \n \n \n \n \n^\n \n',
    'b': u' \nX\n.\n.\n.\n.\n.\n \nb\n \n',
    'f': u' \nX\nX\nX\nX\n.\n.\n \nf\n \n',
    'j': u'j\n \n \n \n \n \n \n \nj\n \n',
    'n': u'n\n \n \n \n \n \n \n \nn\n \n',
    'r': u'r\n \n \n \n \n \n \n \nr\n \n',
    'v': u'v\n \n \n \n \n \n \n \nv\n \n',
    'z': u'z\n \n \n \n \n \n \n \nz\n \n',
    '~': u'~\n \n \n \n \n \n \n \n~\n \n',
    '!': u' \n \n \n \n \n \n \n \n!\n \n',
    '%': u'%\n \n \n \n \n \n \n \n%\n \n',
    ')': u')\n \n \n \n \n \n \n \n)\n \n',
    '-': u'-\n \n \n \n \n \n \n \n-\n \n',
    '1': u'1\n \n \n \n \n \n \n \n1\n \n',
    '5': u'5\n \n \n \n \n \n \n \n5\n \n',
    '9': u'9\n \n \n \n \n \n \n \n9\n \n',
    '=': u'=\n \n \n \n \n \n \n \n=\n \n',
    'A': u' \nx\nx\n.\n.\n.\n.\n \nA\n \n',
    'E': u' \nx\nx\nx\nx\nx\n.\n \nE\n \n',
    'I': u'I\n \n \n \n \n \n \n \nI\n \n',
    'M': u'M\n \n \n \n \n \n \n \nM\n \n',
    'Q': u'Q\n \n \n \n \n \n \n \nQ\n \n',
    'U': u'U\n \n \n \n \n \n \n \nU\n \n',
    'Y': u'Y\n \n \n \n \n \n \n \nY\n \n',
    ']': u']\n \n \n \n \n \n \n \n]\n \n',
    'a': u' \nX\nX\n.\n.\n.\n.\n \na\n \n',
    'e': u' \nX\nX\nX\nX\nX\n.\n \ne\n \n',
    'i': u'i\n \n \n \n \n \n \n \ni\n \n',
    'm': u'm\n \n \n \n \n \n \n \nm\n \n',
    'q': u'q\n \n \n \n \n \n \n \nq\n \n',
    'u': u'u\n \n \n \n \n \n \n \nu\n \n',
    'y': u'y\n \n \n \n \n \n \n \ny\n \n',
    '}': u'}\n \n \n \n \n \n \n \n}\n \n'}

eftiwall_dic = {
    ' ': u'   \n   \n   \n---\n',
    '$': u'.      .  \n  *  (   *\n *  .  *  \n----------\n',
    '(': u',------.\n| Hi ! |\n`-----(_\n------  \n',
    ',': u",----------------------------.\n| Ask for other 'efti' fonts |\n_)---------------------------'\n  ----------------------------\n",
    '0': u'              \n     ...      \n    (. .)     \nooO--(_)--Ooo-\n',
    '4': u'              \n     ...      \n    (- -)     \nooO--(_)--Ooo-\n',
    '8': u'              \n     ...      \n    (O o)     \nooO--(_)--Ooo-\n',
    '<': u',---------------------------.\n| Write your message here ! |\n`--------------------------(_\n---------------------------  \n',
    '@': u"      \n      \n  __  \n-'  `-\n",
    'D': u'              \n     ===      \n    (o o)     \nooO--(_)--Ooo-\n',
    'H': u'              \n     ***      \n    (o o)     \nooO--(_)--Ooo-\n',
    'L': u'              \n     _/7      \n    (o o)     \nooO--(_)--Ooo-\n',
    'P': u"              \n  `  ___  '   \n -  (O o)  -  \nooO--(_)--Ooo-\n",
    'T': u"              \n     '*`      \n    (o o)     \nooO--(_)--Ooo-\n",
    'X': u'              \n     \\|/      \n    (o o)     \nooO--(_)--Ooo-\n',
    '\\': u' __________ \n|Look  Here|\n|__________|\n-----||-----\n',
    '`': u'           |            \n    \\\\\\\\   |   ////     \n    ( oo)  |  (oo )     \nooO--(_)-OoooO-(_)--Ooo-\n',
    'd': u'        ...      \n   o,*,(o o)     \n  8(o o)(_)Ooo   \nooO-(_)---Ooo----\n',
    'h': u'     ___      \n    .|||.     \n    (o o)     \nooO--(_)--Ooo-\n',
    'l': u"   _     _    \n o' \\,=./ `o  \n    (o o)     \nooO--(_)--Ooo-\n",
    'p': u'#                 #\n#=ooO=========Ooo=#\n#  \\\\  (o o)  //  #\n--------(_)--------\n',
    't': u"              \n    ()_()     \n    (o o)     \nooO--`o'--Ooo-\n",
    'x': u'    _   _     \n   (_)-(_)    \n    (o o)     \nooO--(_)--Ooo-\n',
    '|': u'',
    '#': u' \n \n \n-\n',
    "'": u" `  _  ' \n-  (_)  -\n  '   `  \n---------\n",
    '+': u'  ___            \n / _()- - - - - >\n | |   !!        \n-----------------\n',
    '/': u'    * _   *   \n *   (_)   *  \n  * ( o )*   *\nooO-------Ooo-\n',
    '3': u'              \n     ...      \n    (o -)     \nooO--(_)--Ooo-\n',
    '7': u'              \n     ...      \n    (o O)     \nooO--(_)--Ooo-\n',
    ';': u'           \n     "     \n `       \' \n-ooO---Ooo-\n',
    '?': u'     \n     \n     \n-._,-\n',
    'C': u'              \n     ooo      \n    (o o)     \nooO--(_)--Ooo-\n',
    'G': u'              \n    -*~*-     \n    (o o)     \nooO--(_)--Ooo-\n',
    'K': u'              \n     /777     \n    (o o)     \nooO--(_)--Ooo-\n',
    'O': u'              \n     xxx      \n    (o o)     \nooO--(_)--Ooo-\n',
    'S': u'              \n     >X<      \n    (o o)     \nooO--(_)--Ooo-\n',
    'W': u'              \n     )|(      \n    (o o)     \nooO--(_)--Ooo-\n',
    '[': u" __________   \n|Look There`. \n|__________,' \n-----||-------\n",
    '_': u"  '\\/`  \n  (oo)  \n (_`'_) \n--_!!_--\n",
    'c': u'              \n    ,,,,,     \n   /(o o)\\    \nooO--(_)--Ooo-\n',
    'g': u'              \n   __MMM__    \n    (o o)     \nooO--(_)--Ooo-\n',
    'k': u'     ___      \n    /\\#/\\     \n   /(o o)\\    \nooO--(_)--Ooo-\n',
    'o': u' #   ___      \n #  <_*_>     \n #  (o o)     \n-8---(_)--Ooo-\n',
    's': u"              \n  `  _ ,  '   \n -  (o)o)  -  \n-ooO'(_)--Ooo-\n",
    'w': u' #  #  #  #   \n #  #..#  #   \n #  #O #) #   \no#O-#(_#--#oo-\n',
    '{': u'',
    '"': u'     \\/ \n v      \n    v   \n--------\n',
    '&': u'     ___   \n  __(   )  \n (_______) \n-----------\n',
    '*': u'   _    \n  oo\\   \n (__)\\  \n--------\n',
    '.': u',---------------------------.\n| (c) Michel Eftimakis 1995 |\n`--------------------------(_\n---------------------------  \n',
    '2': u'              \n     ...      \n    (- o)     \nooO--(_)--Ooo-\n',
    '6': u'              \n     ...      \n    (x x)     \nooO--(_)--Ooo-\n',
    ':': u'           \n     "     \n `  ___  \' \n-ooO---Ooo-\n',
    '>': u",---------------------------.\n| Write your message here ! |\n_)--------------------------'\n  ---------------------------\n",
    'B': u'              \n     ,,,      \n    (o o)     \nooO--(_)--Ooo-\n',
    'F': u'              \n     ###      \n    (o o)     \nooO--(_)--Ooo-\n',
    'J': u"              \n    -`^'-     \n    (o o)     \nooO--(_)--Ooo-\n",
    'N': u'              \n     (((      \n    (o o)     \nooO--(_)--Ooo-\n',
    'R': u'      _       \n     ((_      \n    (o o)     \nooO--(_)--Ooo-\n',
    'V': u'              \n     ^^^      \n    (o o)     \nooO--(_)--Ooo-\n',
    'Z': u'     (        \n     _)_      \n    (o o)     \nooO--(_)--Ooo-\n',
    '^': u' \\|/ ____ \\|/ \n  @~/ ,. \\~@  \n /_( \\__/ )_\\ \n----\\__U_/----\n',
    'b': u"    ( ( (     \n  '. ___ .'   \n '  (> <) '   \nooO--(_)--Ooo-\n",
    'f': u'      _       \n    _|_|_     \n    (o o)     \nooO--(_)--Ooo-\n',
    'j': u'              \n     vvv      \n    (0~0)     \nooO--(_)--Ooo-\n',
    'n': u"    _   _     \n   '\\\\-//`    \n    (o o)     \nooO--(_)--Ooo-\n",
    'r': u"     !!!      \n  `  _ _  '   \n -  (OXO)  -  \nooO--(_)--Ooo-\n",
    'v': u"     ___      \n   .'_#_`.    \n   |[o o]|    \nooO--(_)--Ooo-\n",
    'z': u'               \n    ((__))     \n     (00)      \nnn--(o__o)--nn-\n',
    '~': u'',
    '!': u'        \n        \n        \n--------\n',
    '%': u'     /\\     \n    /  \\/\\  \n /`/   /  \\ \n------------\n',
    ')': u",------.\n| Hi ! |\n_)-----'\n  ------\n",
    '-': u'            ___  \n< - - - - -()_ \\ \n        !!   | | \n-----------------\n',
    '1': u'              \n     ...      \n    (o o)     \nooO--(_)--Ooo-\n',
    '5': u'              \n     ...      \n    (* *)     \nooO--(_)--Ooo-\n',
    '9': u'              \n     ...      \n    ( oo)     \nooO--(_)--Ooo-\n',
    '=': u'      n       \n ____/_\\____  \n    (z z)     \nooO--(_)--Ooo-\n',
    'A': u'              \n     ___      \n    (o o)     \nooO--(_)--Ooo-\n',
    'E': u'              \n     +++      \n    (o o)     \nooO--(_)--Ooo-\n',
    'I': u'              \n     |||      \n    (o o)     \nooO--(_)--Ooo-\n',
    'M': u'              \n     )))      \n    (o o)     \nooO--(_)--Ooo-\n',
    'Q': u'              \n     @__      \n    (o o)     \nooO--(_)--Ooo-\n',
    'U': u'              \n    \\-^-/     \n    (o o)     \nooO--(_)--Ooo-\n',
    'Y': u'              \n     &&&      \n    (o o)     \nooO--(_)--Ooo-\n',
    ']': u"   __________ \n ,'Look There|\n `.__________|\n-------||-----\n",
    'a': u'   |          \n   |.===.     \n   {}o o{}    \nooO--(_)--Ooo-\n',
    'e': u'     |"|      \n    _|_|_     \n    (o o)     \nooO--(_)--Ooo-\n',
    'i': u'   .      .   \n .  .:::.     \n   :(o o):  . \nooO--(_)--Ooo-\n',
    'm': u'      ___     \n     /_\\ `*   \n    (o o)     \nooO--(_)--Ooo-\n',
    'q': u"     ___      \n    '/_\\      \n    (o o)     \nooO--(_)--Ooo-\n",
    'u': u"      o       \n   ` /_\\ '    \n  - (o o) -   \nooO--(_)--Ooo-\n",
    'y': u'        .     \n    ,-_-|     \n   ([o o])    \nooO--(_)--Ooo-\n',
    '}': u''}

fire_font_s_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'     \n     \n ||_ \n(_-< \n/ _/ \n ||  \n     \n     \n     \n',
    '(': u'     \n     \n     \n  __ \n / / \n| |  \n| |  \n \\_\\ \n     \n',
    ',': u'     \n     \n     \n     \n     \n  )  \n /(  \n(_)) \n     \n',
    '0': u'        \n     )  \n  ( /(  \n  )\\()) \n ((_)\\  \n /  (_) \n| () |  \n \\__/   \n        \n',
    '4': u'        \n     )  \n  ( /(  \n  )\\()) \n ((_)\\  \n| | (_) \n|_  _|  \n  |_|   \n        \n',
    '8': u'        \n (      \n )\\ (   \n((_))\\  \n  _((_) \n ( _ )  \n / _ \\  \n \\___/  \n        \n',
    '<': u'     \n     \n     \n     \n  __ \n / / \n< <  \n \\_\\ \n     \n',
    '@': u'         \n         \n   (     \n   )\\    \n  ((_)   \n /__ _\\  \n// _` |\\ \n\\\\__,_|/ \n \\____/  \n',
    'D': u' (      \n )\\ )   \n(()/(   \n /(_))  \n(_))_   \n |   \\  \n | |) | \n |___/  \n        \n',
    'H': u'    )  \n ( /(  \n )\\()) \n((_)\\  \n _((_) \n| || | \n| __ | \n|_||_| \n       \n',
    'L': u' (     \n )\\ )  \n(()/(  \n /(_)) \n(_))   \n| |    \n| |__  \n|____| \n       \n',
    'P': u' (     \n )\\ )  \n(()/(  \n /(_)) \n(_))   \n| _ \\  \n|  _/  \n|_|    \n       \n',
    'T': u'         \n  *   )  \n` )  /(  \n ( )(_)) \n(_(_())  \n|_   _|  \n  | |    \n  |_|    \n         \n',
    'X': u'    )  \n ( /(  \n )\\()) \n((_)\\  \n__((_) \n\\ \\/ / \n >  <  \n/_/\\_\\ \n       \n',
    '\\': u'      \n      \n      \n      \n__    \n\\ \\   \n \\ \\  \n  \\_\\ \n      \n',
    '`': u'`\n \n \n \n \n \n \n \n \n',
    'd': u'        \n  (     \n  )\\ )  \n (()/(  \n  ((_)) \n  _| |  \n/ _` |  \n\\__,_|  \n        \n',
    'h': u"       \n    )  \n ( /(  \n )\\()) \n((_)\\  \n| |(_) \n| ' \\  \n|_||_| \n       \n",
    'l': u'     \n (   \n )\\  \n((_) \n _   \n| |  \n| |  \n|_|  \n     \n',
    'p': u"        \n        \n        \n `  )   \n /(/(   \n((_)_\\  \n| '_ \\) \n| .__/  \n|_|     \n",
    't': u'       \n    )  \n ( /(  \n )\\()) \n(_))/  \n| |_   \n|  _|  \n \\__|  \n       \n',
    'x': u'       \n       \n    )  \n ( /(  \n )\\()) \n((_)\\  \n\\ \\ /  \n/_\\_\\  \n       \n',
    '|': u'    \n    \n    \n    \n _  \n| | \n| | \n| | \n|_| \n',
    '#': u'          \n   _ _    \n _| | |_  \n|_  .  _| \n|_     _| \n  |_|_|   \n          \n          \n          \n',
    "'": u'     \n (   \n )\\  \n((_) \n     \n     \n     \n     \n     \n',
    '+': u'        \n        \n        \n   _    \n _| |_  \n|_   _| \n  |_|   \n        \n        \n',
    '/': u'      \n      \n      \n   __ \n  / / \n / /  \n/_/   \n      \n      \n',
    '3': u'        \n     )  \n  ( /(  \n  )\\()) \n ((_)\\  \n|__ (_) \n |_ \\   \n|___/   \n        \n',
    '7': u'        \n     )  \n  ( /(  \n  )\\()) \n ((_)\\  \n|__  /  \n  / /   \n /_/    \n        \n',
    ';': u'     \n     \n     \n     \n  _  \n (_) \n (   \n )\\  \n((_) \n',
    '?': u'      \n      \n (    \n )\\   \n((_)  \n|__ \\ \n  /_/ \n (_)  \n      \n',
    'C': u'        \n   (    \n   )\\   \n (((_)  \n )\\___  \n((/ __| \n | (__  \n  \\___| \n        \n',
    'G': u'         \n (       \n )\\ )    \n(()/(    \n /(_))_  \n(_)) __| \n  | (_ | \n   \\___| \n         \n',
    'K': u"     )  \n  ( /(  \n  )\\()) \n|((_)\\  \n|_ ((_) \n| |/ /  \n  ' <   \n _|\\_\\  \n        \n",
    'O': u'    )   \n ( /(   \n )\\())  \n((_)\\   \n  ((_)  \n / _ \\  \n| (_) | \n \\___/  \n        \n',
    'S': u' (     \n )\\ )  \n(()/(  \n /(_)) \n(_))   \n/ __|  \n\\__ \\  \n|___/  \n       \n',
    'W': u"          \n (  (     \n )\\))(   '\n((_)()\\ ) \n_(())\\_)()\n\\ \\((_)/ /\n \\ \\/\\/ / \n  \\_/\\_/  \n          \n",
    '[': u'     \n     \n     \n     \n __  \n| _| \n| |  \n| |  \n|__| \n',
    '_': u'        \n        \n        \n        \n        \n        \n        \n _____  \n|_____| \n',
    'c': u'      \n      \n      \n  (   \n  )\\  \n ((_) \n/ _|  \n\\__|  \n      \n',
    'g': u'        \n        \n (  (   \n )\\))(  \n((_))\\  \n (()(_) \n/ _` |  \n\\__, |  \n|___/   \n',
    'k': u'       \n    )  \n ( /(  \n )\\()) \n((_)\\  \n| |(_) \n| / /  \n|_\\_\\  \n       \n',
    'o': u'      \n      \n      \n  (   \n  )\\  \n ((_) \n/ _ \\ \n\\___/ \n      \n',
    's': u'     \n     \n     \n (   \n )\\  \n((_) \n(_-< \n/__/ \n     \n',
    'w': u'         \n         \n (  (    \n )\\))(   \n((_)()\\  \n_(()((_) \n\\ V  V / \n \\_/\\_/  \n         \n',
    '{': u'      \n      \n      \n      \n   __ \n  / / \n_| |  \n | |  \n  \\_\\ \n',
    '"': u'         \n (   (   \n )\\  )\\  \n((_)((_) \n         \n         \n         \n         \n         \n',
    '&': u'         \n         \n     (   \n __  )\\  \n/ _|((_) \n> _|_ _| \n\\_____|  \n         \n         \n',
    '*': u'_/\\_ \n>  < \n \\/  \n     \n     \n     \n     \n     \n     \n',
    '.': u'    \n    \n    \n    \n    \n    \n _  \n(_) \n    \n',
    '2': u'       \n    )  \n ( /(  \n )(_)) \n((_)   \n|_  )  \n / /   \n/___|  \n       \n',
    '6': u'       \n (     \n )\\ )  \n(()/(  \n /(_)) \n(_) /  \n / _ \\ \n \\___/ \n       \n',
    ':': u'    \n    \n    \n    \n _  \n(_) \n _  \n(_) \n    \n',
    '>': u'     \n     \n     \n     \n__   \n\\ \\  \n > > \n/_/  \n     \n',
    'B': u'       \n   (   \n ( )\\  \n )((_) \n((_)_  \n | _ ) \n | _ \\ \n |___/ \n       \n',
    'F': u' (     \n )\\ )  \n(()/(  \n /(_)) \n(_))_| \n| |_   \n| __|  \n|_|    \n       \n',
    'J': u'       \n       \n   (   \n   )\\  \n  ((_) \n _ | | \n| || | \n \\__/  \n       \n',
    'N': u'    )  \n ( /(  \n )\\()) \n((_)\\  \n _((_) \n| \\| | \n| .` | \n|_|\\_| \n       \n',
    'R': u' (     \n )\\ )  \n(()/(  \n /(_)) \n(_))   \n| _ \\  \n|   /  \n|_|_\\  \n       \n',
    'V': u'         \n         \n (   (   \n )\\  )\\  \n((_)((_) \n\\ \\ / /  \n \\ V /   \n  \\_/    \n         \n',
    'Z': u'    )  \n ( /(  \n )\\()) \n((_)\\  \n _((_) \n|_  /  \n / /   \n/___|  \n       \n',
    '^': u'     \n /\\  \n|/\\| \n     \n     \n     \n     \n     \n     \n',
    'b': u"       \n    )  \n ( /(  \n )\\()) \n((_)\\  \n| |(_) \n| '_ \\ \n|_.__/ \n       \n",
    'f': u'       \n (     \n )\\ )  \n(()/(  \n /(_)) \n(_) _| \n |  _| \n |_|   \n       \n',
    'j': u'      \n      \n  (   \n  )\\  \n ((_) \n   !  \n  | | \n _/ | \n|__/  \n',
    'n': u"        \n        \n        \n  (     \n  )\\ )  \n _(_/(  \n| ' \\)) \n|_||_|  \n        \n",
    'r': u"      \n      \n (    \n )(   \n(()\\  \n ((_) \n| '_| \n|_|   \n      \n",
    'v': u'       \n       \n  )    \n /((   \n(_))\\  \n_)((_) \n\\ V /  \n \\_/   \n       \n',
    'z': u'     \n     \n     \n (   \n )\\  \n((_) \n|_ / \n/__| \n     \n',
    '~': u'      \n /\\/| \n|/\\/  \n      \n      \n      \n      \n      \n      \n',
    '!': u'   ____ \n  |   / \n  |  /  \n  | /   \n  |/    \n (      \n )\\     \n((_)    \n        \n',
    '%': u'        \n        \n        \n _  __  \n(_)/ /  \n  / /_  \n /_/(_) \n        \n        \n',
    ')': u'     \n     \n     \n__   \n\\ \\  \n | | \n | | \n/_/  \n     \n',
    '-': u'      \n      \n      \n ___  \n|___| \n      \n      \n      \n      \n',
    '1': u'       \n    )  \n ( /(  \n )\\()) \n((_)\\  \n / (_) \n | |   \n |_|   \n       \n',
    '5': u'         \n (  (    \n )\\))(   \n((_)()\\  \n (()((_) \n  | __|  \n  |__ \\  \n  |___/  \n         \n',
    '9': u'       \n    )  \n ( /(  \n )\\()) \n((_)\\  \n/ _(_) \n\\_, /  \n /_/   \n       \n',
    '=': u'      \n      \n      \n      \n      \n ___  \n|___| \n|___| \n      \n',
    'A': u'          \n   (      \n   )\\     \n((((_)(   \n )\\ _ )\\  \n (_)_\\(_) \n  / _ \\   \n /_/ \\_\\  \n          \n',
    'E': u'      \n      \n (    \n )\\   \n((_)  \n| __| \n| _|  \n|___| \n      \n',
    'I': u' (     \n )\\ )  \n(()/(  \n /(_)) \n(_))   \n|_ _|  \n | |   \n|___|  \n       \n',
    'M': u'   *     \n (  `    \n )\\))(   \n((_)()\\  \n(_()((_) \n|  \\/  | \n| |\\/| | \n|_|  |_| \n         \n',
    'Q': u'        \n   (    \n ( )\\   \n )((_)  \n((_)_   \n / _ \\  \n| (_) | \n \\__\\_\\ \n        \n',
    'U': u'        \n        \n    (   \n    )\\  \n _ ((_) \n| | | | \n| |_| | \n \\___/  \n        \n',
    'Y': u'     )  \n  ( /(  \n  )\\()) \n ((_)\\  \n__ ((_) \n\\ \\ / / \n \\ V /  \n  |_|   \n        \n',
    ']': u'     \n     \n     \n     \n __  \n|_ | \n | | \n | | \n|__| \n',
    'a': u'       \n       \n    )  \n ( /(  \n )(_)) \n((_)_  \n/ _` | \n\\__,_| \n       \n',
    'e': u'       \n       \n   (   \n  ))\\  \n /((_) \n(_))   \n/ -_)  \n\\___|  \n       \n',
    'i': u'     \n     \n (   \n )\\  \n((_) \n (_) \n | | \n |_| \n     \n',
    'm': u"         \n         \n    )    \n   (     \n   )\\  ' \n _((_))  \n| '  \\() \n|_|_|_|  \n         \n",
    'q': u'       \n       \n   (   \n ( )\\  \n )(( ) \n((_)_) \n/ _` | \n\\__, | \n   |_| \n',
    'u': u'       \n       \n   (   \n  ))\\  \n /((_) \n(_))(  \n| || | \n \\_,_| \n       \n',
    'y': u'       \n       \n (     \n )\\ )  \n(()/(  \n )(_)) \n| || | \n \\_, | \n |__/  \n',
    '}': u'      \n      \n      \n      \n__    \n\\ \\   \n | |_ \n | |  \n/_/   \n'}

gradient_dic = {
    '!': u'.e..\n@@@:\n%%%-\n&&&+\n|||*\n====\n:::#\n...@\n    \n',
    ' ': u'...\n:::\n---\n+++\n***\n===\n###\n@@@\n   \n',
    '#': u'..eee..eee...\n@@@@@@@@@@@@:\n%%%%%%%%%%%%-\n++&&&++&&&+++\n**|||**|||***\n!!!!!!!!!!!!=\n::::::::::::#\n@@...@@...@@@\n             \n',
    '"': u'eee..eee.\n@@@::@@@:\n-%----%--\n+++++++++\n*********\n=========\n#########\n@@@@@@@@@\n         \n',
    '%': u'eeee...eee.\n@@@@::@@@::\n%%%%-%%%---\n++++&&&++++\n***|||*****\n==!!!=!!!!=\n#:::##::::#\n...@@@....@\n           \n',
    '$': u'....eee.....\n:@@@@@@@@@::\n%%%%%----%%-\n+&&&&&++++++\n****||||||**\n!!====!!!!!=\n#::::::::::#\n@@@@...@@@@@\n            \n',
    "'": u'.eee.\n:@@@:\n%%%--\n+++++\n*****\n=====\n#####\n@@@@@\n     \n',
    '&': u'....eee.....\n:::@@:@@::::\n----%%%-----\n+++&&&&+++++\n**|||*|||***\n=!!!===!!!==\n:::::::::::#\n@......@@..@\n            \n',
    ')': u'eee...\n:@@@::\n--%%%-\n++&&&+\n**|||*\n==!!!=\n#:::##\n...###\n      \n',
    '(': u'..eee.\n:@@@::\n%%%---\n&&&+++\n|||***\n!!!===\n#:::##\n@@...@\n      \n',
    '+': u'..........\n:::@@@::::\n---%%%----\n&&&&&&&&&+\n|||||||||*\n===!!!====\n###:::####\n@@@@@@@@@@\n          \n',
    '*': u'eeee....eeee.\n:@@@@::@@@@::\n--%%%%%%%%---\n&&&&&&&&&&&&+\n||||||||||||*\n==!!!!!!!!===\n#::::##::::##\n....@@@@....@\n             \n',
    '-': u'........\n::::::::\n--------\n&&&&&&&+\n|||||||*\n========\n########\n@@@@@@@@\n        \n',
    ',': u'.....\n:::::\n-----\n+++++\n*****\n=!!!=\n#:::#\n...@@\n     \n',
    '/': u'.......eee.\n::::::@@@::\n-----%%%---\n++++&&&++++\n***|||*****\n==!!!======\n#:::#######\n...@@@@@@@@\n           \n',
    '.': u'....\n::::\n----\n++++\n****\n====\n:::#\n...@\n    \n',
    '1': u'..ee.\n:@@@:\n%%%%-\n+&&&+\n*|||*\n=!!!=\n#:::#\n@...@\n     \n',
    '0': u'.eeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&++&&&+\n|||**|||*\n!!!==!!!=\n::::::::#\n@......@@\n         \n',
    '3': u'.eeeeee..\n@@@@@@@@:\n%%%--%%%-\n++++&&&++\n****|||**\n!!!==!!!=\n::::::::#\n@......@@\n         \n',
    '2': u'.eeeeee..\n@@@@@@@@:\n%%%--%%%-\n++++&&&++\n***|||***\n==!!!====\n#:::::::#\n........@\n         \n',
    '5': u'eeeeeeeee.\n@@@@@@@@@:\n%%%-------\n&&&&&&&&++\n|||||||||*\n======!!!=\n:::::::::#\n@.......@@\n          \n',
    '4': u'.....eeeee...\n::::@@@@@@:::\n---%%%-%%%---\n++&&&++&&&+++\n*|||||||||||*\n!!!!!!!!!!!!=\n#######:::###\n@@@@@@@...@@@\n             \n',
    '7': u'eeeeeeee.\n@@@@@@@@:\n----%%%--\n+++&&&+++\n**|||****\n=!!!=====\n:::######\n...@@@@@@\n         \n',
    '6': u'.eeeeee..\n@@@@@@@@:\n%%%------\n&&&&&&&++\n||||||||*\n!!!==!!!=\n::::::::#\n@......@@\n         \n',
    '9': u'.eeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&&&&&&+\n*|||||||*\n=====!!!=\n::::::::#\n@......@@\n         \n',
    '8': u'.eeeeee..\n@@@@@@@@:\n%%%--%%%-\n+&&&&&&++\n*||||||**\n!!!==!!!=\n::::::::#\n@......@@\n         \n',
    ';': u'.....\n:@@@:\n-%%%-\n+++++\n*****\n=!!!=\n#:::#\n...@@\n     \n',
    ':': u'....\n@@@:\n%%%-\n++++\n****\n!!!=\n:::#\n@@@@\n    \n',
    '=': u'..........\n::::::::::\n%%%%%%%%%-\n&&&&&&&&&+\n**********\n!!!!!!!!!=\n:::::::::#\n@@@@@@@@@@\n          \n',
    '<': u'...eee.\n::@@@::\n-%%%---\n&&&++++\n|||****\n=!!!===\n##:::##\n@@@...@\n       \n',
    '?': u'.eeeeee..\n@@@@@@@@:\n%%%--%%%-\n++++&&&++\n***|||***\n==!!!====\n#########\n@...@@@@@\n         \n',
    '>': u'eee....\n:@@@:::\n--%%%--\n+++&&&+\n***|||*\n==!!!==\n#:::###\n...@@@@\n       \n',
    '@': u'.eeeeeeeeeee..\n@@@@@@@@@@@@@:\n%%%-------%%%-\n&&&++&&&++&&&+\n|||**|||**|||*\n!!!===!!!!!!==\n:::###########\n@...........@@\n              \n',
    '[': u'eeeeee.\n@@@@@@:\n%%%----\n&&&++++\n|||****\n!!!====\n::::::#\n......@\n       \n',
    ']': u'eeeeee.\n@@@@@@:\n---%%%-\n+++&&&+\n***|||*\n===!!!=\n::::::#\n......@\n       \n',
    '\\': u'eee........\n:@@@:::::::\n--%%%------\n+++&&&+++++\n****|||****\n=====!!!===\n######:::##\n@@@@@@@...@\n           \n',
    '_': u'.........\n:::::::::\n---------\n+++++++++\n*********\n=========\n::::::::#\n........@\n         \n',
    '^': u'..eeee...\n:@@@@@@::\n%%%--%%%-\n+++++++++\n*********\n=========\n#########\n@@@@@@@@@\n         \n',
    'a': u'.eeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&&&&&&+\n||||||||*\n!!!==!!!=\n:::##:::#\n...@@...@\n         \n',
    '`': u'eee..\n@@@::\n-%%%-\n+++++\n*****\n=====\n:::::\n.....\n     \n',
    'c': u'.eeeee.\n@@@@@@:\n%%%----\n&&&++++\n|||****\n!!!====\n::::::#\n@.....@\n       \n',
    'b': u'eeeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&&&&&++\n||||||||*\n!!!==!!!=\n::::::::#\n.......@@\n         \n',
    'e': u'eeeeee.\n@@@@@@:\n%%%----\n&&&&&++\n|||||**\n!!!====\n::::::#\n......@\n       \n',
    'd': u'eeeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&++&&&+\n|||**|||*\n!!!==!!!=\n::::::::#\n.......@@\n         \n',
    'g': u'.eeeeee..\n@@@@@@@@:\n%%%------\n&&&++++++\n|||*||||*\n!!!==!!!=\n::::::::#\n@......@@\n         \n',
    'f': u'eeeeee.\n@@@@@@:\n%%%----\n&&&&&++\n|||||**\n!!!====\n:::####\n...@@@@\n       \n',
    'i': u'eee.\n@@@:\n%%%-\n&&&+\n|||*\n!!!=\n:::#\n...@\n    \n',
    'h': u'eee..eee.\n@@@::@@@:\n%%%--%%%-\n&&&&&&&&+\n||||||||*\n!!!==!!!=\n:::##:::#\n...@@...@\n         \n',
    'k': u'eee..eee.\n@@@::@@@:\n%%%-%%%--\n&&&&&&+++\n||||||***\n!!!=!!!==\n:::##:::#\n...@@...@\n         \n',
    'j': u'eeeeeee.\n@@@@@@@:\n----%%%-\n++++&&&+\n****|||*\n!!==!!!=\n:::::::#\n@.....@@\n        \n',
    'm': u'eee......eee.\n@@@@::::@@@@:\n%%%%%--%%%%%-\n&&&&&&&&&&&&+\n|||*||||*|||*\n!!!==!!==!!!=\n:::######:::#\n...@@@@@@...@\n             \n',
    'l': u'eee....\n@@@::::\n%%%----\n&&&++++\n|||****\n!!!====\n::::::#\n......@\n       \n',
    'o': u'.eeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&++&&&+\n|||**|||*\n!!!==!!!=\n::::::::#\n@......@@\n         \n',
    'n': u'eeeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&++&&&+\n|||**|||*\n!!!==!!!=\n:::##:::#\n...@@...@\n         \n',
    'q': u'.eeeeeeee...\n@@@@@@@@@@::\n%%%----%%%--\n&&&++++&&&++\n|||*||*|||**\n!!!==!!!!!==\n::::::::::##\n@......@...@\n            \n',
    'p': u'eeeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&&&&&&+\n|||||||**\n!!!======\n:::######\n...@@@@@@\n         \n',
    's': u'.eeeeee.\n@@@@@@@:\n%%%-----\n&&&&&&++\n*||||||*\n====!!!=\n:::::::#\n......@@\n        \n',
    'r': u'eeeeeee..\n@@@@@@@@:\n%%%--%%%-\n&&&&&&&++\n||||||***\n!!!=!!!==\n:::##:::#\n...@@...@\n         \n',
    'u': u'eee..eee.\n@@@::@@@:\n%%%--%%%-\n&&&++&&&+\n|||**|||*\n!!!==!!!=\n::::::::#\n@......@@\n         \n',
    't': u'eeeeeeeee.\n@@@@@@@@@:\n---%%%----\n+++&&&++++\n***|||****\n===!!!====\n###:::####\n@@@...@@@@\n          \n',
    'w': u'eee..eee..eee.\n@@@::@@@::@@@:\n%%%--%%%--%%%-\n&&&++&&&++&&&+\n|||**|||**|||*\n!!!==!!!==!!!=\n:::::::::::::#\n@...........@@\n              \n',
    'v': u'eee....eee.\n@@@::::@@@:\n%%%----%%%-\n&&&++++&&&+\n*|||**|||**\n==!!!!!!===\n###::::####\n@@@@..@@@@@\n           \n',
    'y': u'eee...eee.\n@@@:::@@@.\n%%%---%%%-\n+&&&&&&&++\n**|||||***\n===!!!====\n###:::####\n@@@...@@@@\n          \n',
    'x': u'eee..eee.\n@@@::@@@:\n%%%--%%%-\n+&&&&&&++\n*||||||**\n!!!==!!!=\n:::##:::#\n...@@...@\n         \n',
    '{': u'...eeeee.\n::@@@@@@:\n-%%%-----\n&&&++++++\n|||******\n=!!!=====\n##::::::#\n@@@.....@\n         \n',
    'z': u'eeeeeeee.\n@@@@@@@@:\n----%%%--\n+++&&&+++\n**|||****\n=!!!=====\n::::::::#\n........@\n         \n',
    '}': u'eeeee....\n@@@@@@:::\n----%%%--\n+++++&&&+\n====!!!==\n::::::###\n.....@@@@\n..eeee...\n         \n',
    '|': u'eee.\n@@@:\n%%%-\n&&&+\n|||*\n!!!=\n:::#\n...@\n    \n',
    '~': u':@@@@@@::@@@::\n%%%--%%%%%%---\n++++++++++++++\n**************\n==============\n##############\n@@@@@@@@@@@@@@\neee...ee...eee\n              \n'}

dic_1943 = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'         \n####     \n#  #     \n## #     \n## #     \n## #     \n## #     \n## #     \n',
    '(': u'### #  # \n### #  # \n### #  # \n### #  # \n### #    \n### #    \n### #    \n### #    \n',
    ',': u'### #    \n### #    \n### #    \n### #    \n### #    \n### #    \n### #    \n### #    \n',
    '0': u' ## ##   \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n ## ##   \n         \n',
    '4': u'    ##   \n  # ##   \n ## ##   \n##  ##   \n### ###  \n    ##   \n    ##   \n         \n',
    '8': u' ## ##   \n##   ##  \n##   ##  \n ## ##   \n##   ##  \n #   ##  \n ## ##   \n         \n',
    '<': u'## ##### \n##       \n######## \n######## \n ####### \n         \n         \n         \n',
    '@': u'         \n         \n         \n # #   # \n       # \n##       \n         \n # #     \n',
    'D': u'### ##   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n### ##   \n         \n',
    'H': u'###  ##  \n ##  ##  \n ##  ##  \n ## ###  \n ##  ##  \n ##  ##  \n###  ##  \n         \n',
    'L': u'####     \n ##      \n ##      \n ##      \n ##      \n ##  ##  \n### ###  \n         \n',
    'P': u'### ##   \n ##  ##  \n ##  ##  \n ##  ##  \n ## ##   \n ##      \n####     \n         \n',
    'T': u'#### ##  \n# ## ##  \n  ##     \n  ##     \n  ##     \n  ##     \n ####    \n         \n',
    'X': u'##  ##   \n### ##   \n ###     \n  ###    \n   ###   \n##  ###  \n##   ##  \n         \n',
    '\\': u'         \n   #     \n#######  \n #####   \n  # #    \n    #    \n #####   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n         \n         \n#     ## \n##   ##  \n##   ### \n#    ##  \n##   ##  \n',
    'h': u'         \n         \n         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ##  ##  \n',
    'l': u'    #### \n    #### \n    #### \n       # \n #  ###  \n### #### \n### #### \n # # ### \n',
    'p': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    't': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    'x': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n#####    \n    #    \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n',
    "'": u'         \n##       \n  #      \n#  #     \n##  #    \n### #    \n### #    \n### #    \n',
    '+': u'## #     \n## ##### \n##       \n######## \n######## \n######## \n         \n         \n',
    '/': u'### #    \n### #    \n### #    \n#####    \n###      \n         \n         \n         \n',
    '3': u' ## ##   \n##   ##  \n     ##  \n   ###   \n     ##  \n##   ##  \n ## ##   \n         \n',
    '7': u'######   \n##   #   \n   ##    \n  ##     \n  ##     \n  ##     \n  ##     \n         \n',
    ';': u'### #  # \n### #  # \n### #  # \n#####    \n###      \n         \n         \n         \n',
    '?': u'         \n         \n         \n#  ## ## \n## ## ## \n##### ## \n# ### ## \n#  ## ## \n',
    'C': u' ## ##   \n##   ##  \n##       \n##       \n##       \n##   ##  \n ## ##   \n         \n',
    'G': u' ## ##   \n##   ##  \n##       \n##  ###  \n##   ##  \n##   ##  \n ## ##   \n         \n',
    'K': u'##  ###  \n##  ##   \n## ##    \n## ##    \n## ###   \n##  ##   \n##  ###  \n         \n',
    'O': u' ## ##   \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n ## ##   \n         \n',
    'S': u' ## ##   \n##   ##  \n####     \n #####   \n    ###  \n##   ##  \n ## ##   \n         \n',
    'W': u'##   ##  \n##   ##  \n##   ##  \n## # ##  \n# ### #  \n ## ##   \n##   ##  \n         \n',
    '[': u'         \n         \n         \n         \n######## \n######## \n######## \n######## \n',
    '_': u'#### \n#### \n#### \n#### \n#### \n#### \n#### \n#### \n',
    'c': u'         \n         \n         \n##  #### \n ## ##   \n### ##   \n ## #### \n ## ##   \n',
    'g': u'         \n         \n         \n# ###### \n  ##     \n  ####   \n  ##     \n  ###### \n',
    'k': u' # #     \n####     \n####     \n#        \n # # ### \n#### ### \n#### ### \n### #### \n',
    'o': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    's': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    'w': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n   ##### \n  #      \n ####### \n######## \n######## \n###      \n## #     \n',
    '&': u'         \n   ##### \n  #      \n ####### \n######## \n######## \n##       \n##       \n',
    '*': u'### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #    \n### #    \n',
    '.': u' #  #    \n### #    \n## #     \n#   #    \n #  #    \n### #    \n### #    \n### #    \n',
    '2': u'## ##    \n##  ##   \n    ##   \n   ##    \n  ##     \n #   ##  \n######   \n         \n',
    '6': u' ## ###  \n##   ##  \n##       \n## ###   \n##   ##  \n##   ##  \n ## ##   \n         \n',
    ':': u'### #    \n### #    \n### #    \n#####    \n###      \n         \n         \n         \n',
    '>': u'         \n         \n         \n ####  # \n##  ## # \n##  ## # \n##  ## # \n ####  # \n',
    'B': u'### ##   \n ##  ##  \n ##  ##  \n ## ##   \n ##  ##  \n ##  ##  \n### ##   \n         \n',
    'F': u'### ###  \n ##  ##  \n ##      \n ## ##   \n ##      \n ##      \n####     \n         \n',
    'J': u'   ####  \n    ##   \n    ##   \n    ##   \n##  ##   \n##  ##   \n ## #    \n         \n',
    'N': u'###  ##  \n  ## ##  \n # ## #  \n ## ##   \n ##  ##  \n ##  ##  \n###  ##  \n         \n',
    'R': u'### ##   \n ##  ##  \n ##  ##  \n ## ##   \n ## ##   \n ##  ##  \n#### ##  \n         \n',
    'V': u'### ###  \n ##  ##  \n ##  ##  \n ##  ##  \n ### ##  \n  ###    \n   ##    \n         \n',
    'Z': u'### ##   \n##  ##   \n   ##    \n  ##     \n ##      \n##  ##   \n# ####   \n         \n',
    '^': u'######## \n######## \n######## \n######## \n         \n         \n         \n         \n',
    'b': u'         \n         \n         \n####  ## \n     ##  \n##   ### \n     ##  \n#### ##  \n',
    'f': u'         \n         \n         \n## ##### \n     ##  \n     ##  \n     ##  \n     ##  \n',
    'j': u'### #### \n#### ### \n#### ### \n ### ### \n#        \n####     \n####     \n####     \n',
    'n': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    'r': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    'v': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    'z': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n ####    \n #  #    \n### #    \n### #    \n### #  # \n### #  # \n### #  # \n',
    '%': u'         \n ####    \n #  #    \n### #    \n### #    \n### #  # \n### #  # \n### #  # \n',
    ')': u'## #     \n## ##### \n###      \n######## \n######## \n ####### \n         \n         \n',
    '-': u'      ## \n     #   \n    #### \n    #### \n    #### \n         \n####     \n#  #     \n',
    '1': u'   ##    \n  ###    \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    '5': u'######   \n##       \n## ##    \n    ##   \n##  ##   \n##  ##   \n  ###    \n         \n',
    '9': u' ## ##   \n #   ##  \n##   ##  \n ## ###  \n     ##  \n##   ##  \n ## ##   \n         \n',
    '=': u'### #    \n####     \n###      \n##       \n#        \n         \n         \n         \n',
    'A': u'  ##     \n   ##    \n ## ##   \n ##  ##  \n ## ###  \n ##  ##  \n###  ##  \n         \n',
    'E': u'### ###  \n ##  ##  \n ##      \n ## ##   \n ##      \n ##  ##  \n### ###  \n         \n',
    'I': u'  ####   \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'M': u'##   ##  \n ## ##   \n# ### #  \n## # ##  \n##   ##  \n##   ##  \n##   ##  \n         \n',
    'Q': u' ## ##   \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n##  ##   \n ##  ##  \n         \n',
    'U': u'##  ###  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n ## ##   \n         \n',
    'Y': u'##  ##   \n##  ##   \n##  ##   \n ## ##   \n  ##     \n  ##     \n  ##     \n         \n',
    ']': u'  #####  \n ##   ## \n ##   ## \n ##   ## \n ##   ## \n ##   ## \n####  ## \n ##  ##  \n',
    'a': u'         \n         \n         \n   ## ## \n#  ## ## \n####  ## \n ##   ## \n ##   ## \n',
    'e': u'         \n         \n         \n##  #### \n ## ##   \n### #### \n ## ##   \n ## ##   \n',
    'i': u'#### ### \n### #### \n### #### \n### ###  \n       # \n    #### \n    #### \n    #### \n',
    'm': u'####     \n####     \n####     \n####     \n####     \n####     \n####     \n####     \n',
    'q': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    'u': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    'y': u'### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

advenger_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'         \n         \n         \n         \n         \n         \n         \n    ## # \n',
    '(': u'         \n         \n         \n         \n         \n         \n###### # \n ######  \n',
    ',': u'         \n         \n         \n         \n         \n ####### \n######## \n######## \n',
    '0': u'         \n         \n         \n         \n         \n         \n  #   ## \n##  #### \n',
    '4': u'### #    \n###  #   \n####  ## \n#####  # \n#####  # \n#####    \n######   \n######   \n',
    '8': u'####  #  \n##### #  \n#####  # \n ##### # \n ##### # \n#####  # \n###   #  \n#   ##   \n',
    '<': u'  ###### \n # ##### \n ######  \n######   \n###### # \n # ##  # \n##### #  \n##### #  \n',
    '@': u'  #   ## \n# #   ## \n#  #   # \n## #   # \n## #   # \n#  #   # \n  #    # \n##     # \n',
    'D': u'#####    \n ## ##   \n ##  ##  \n ##  ##  \n ##  ##  \n ## ##   \n#####    \n         \n',
    'H': u' ##  ##  \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'L': u'####     \n ##      \n ##      \n ##      \n ##      \n ##  ##  \n#######  \n         \n',
    'P': u'######   \n ##  ##  \n ##  ##  \n #####   \n ##      \n ##      \n####     \n         \n',
    'T': u' # ##### \n## ## ## \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'X': u'###  ##  \n###  ##  \n #####   \n  ###    \n #####   \n##  ###  \n##  ###  \n         \n',
    '\\': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'######## \n######## \n##     # \n#  ###   \n# #      \n# #      \n# #      \n#  #     \n',
    'h': u'#######  \n#####    \n###   ## \n### ##   \n###      \n####     \n######   \n######## \n',
    'l': u'###### # \n###### # \n##### ## \n##### ## \n#####  # \n####   # \n#### #   \n###  #   \n',
    'p': u'###   ## \n#   ##   \n  ##     \n##       \n         \n         \n##    ## \n######## \n',
    't': u'     ### \n     ### \n     ### \n     ### \n      ## \n      ## \n       # \n         \n',
    'x': u' #       \n #       \n#        \n         \n         \n         \n         \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n         \n         \n#        \n #       \n  #      \n#  #     \n##  #    \n',
    "'": u'         \n         \n         \n         \n         \n         \n## ##  # \n###  #   \n',
    '+': u'         \n         \n         \n         \n         \n         \n      ## \n    #### \n',
    '/': u'         \n         \n         \n         \n         \n         \n#  ##### \n #   ### \n',
    '3': u'######## \n######## \n######## \n### #### \n##   ### \n## # ### \n##    ## \n######## \n',
    '7': u' ####### \n######## \n#####    \n###  ### \n##  ##   \n## #     \n##    ## \n##  #### \n',
    ';': u'####  #  \n##### #  \n##### #  \n######   \n######   \n######   \n###### # \n###### # \n',
    '?': u'######## \n######## \n#   #### \n  ## ### \n##   ### \n    #### \n  #####  \n#####    \n',
    'C': u'  ####   \n ##  ##  \n##       \n##       \n##       \n ##  ##  \n  ####   \n         \n',
    'G': u' #####   \n##   ##  \n##       \n## ####  \n##   ##  \n##   ##  \n #####   \n         \n',
    'K': u'### ###  \n ## ##   \n ####    \n ###     \n ####    \n ## ##   \n### ###  \n         \n',
    'O': u' #####   \n### ###  \n##   ##  \n##   ##  \n##   ##  \n### ###  \n #####   \n         \n',
    'S': u' #####   \n##   ##  \n##       \n #####   \n     ##  \n##   ##  \n #####   \n         \n',
    'W': u'##   ##  \n##   ##  \n##   ##  \n## # ##  \n#######  \n### ###  \n##   ##  \n         \n',
    '[': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '_': u'######## \n######## \n # ##### \n######## \n######## \n######## \n######## \n######## \n',
    'c': u'##### \n##### \n# ### \n  ### \n# ### \n  ### \n  ### \n  ### \n',
    'g': u' ###  ## \n###   ## \n### # ## \n##  #  # \n## #   # \n#  #   # \n# #      \n  #      \n',
    'k': u'#        \n#        \n#        \n#        \n #     # \n #     # \n  #    # \n#  #  ## \n',
    'o': u' ###### \n ###### \n #####  \n  ####  \n  ####  \n# ##### \n#  #### \n#  #### \n',
    's': u' #       \n         \n         \n         \n         \n         \n         \n         \n',
    'w': u'####  ## \n#####    \n       # \n######   \n         \n         \n         \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n         \n###   ## \n#####    \n#######  \n######## \n######## \n######## \n',
    '&': u'         \n         \n         \n         \n#        \n#        \n#   #### \n  ###### \n',
    '*': u'         \n         \n         \n         \n         \n         \n##  #    \n###  #   \n',
    '.': u'         \n         \n         \n         \n         \n         \n###### # \n#######  \n',
    '2': u'   #  \n  #   \n    # \n    # \n   ## \n   ## \n   ## \n##### \n',
    '6': u'   ###  \n   ###  \n   ###  \n  ### # \n  ### # \n ### ## \n ### ## \n###  ## \n',
    ':': u'######## \n######## \n######## \n######## \n#     ## \n  #    # \n #     # \n #       \n',
    '>': u'#    ### \n# # #### \n  # #### \n # ####  \n   ####  \n  #### # \n  ####   \n  ####   \n',
    'B': u'######   \n ##  ##  \n ##  ##  \n #####   \n ##  ##  \n ##  ##  \n######   \n         \n',
    'F': u' ####### \n  ##   # \n  ##     \n  ####   \n  ##     \n  ##     \n ####    \n         \n',
    'J': u'     ##  \n     ##  \n     ##  \n     ##  \n##   ##  \n ## ##   \n  ###    \n         \n',
    'N': u'##   ##  \n###  ##  \n#### ##  \n#######  \n## ####  \n##  ###  \n##   ##  \n         \n',
    'R': u'######   \n ##  ##  \n ##  ##  \n #####   \n ## ##   \n ## ##   \n#### ##  \n         \n',
    'V': u'##   ##  \n##   ##  \n##   ##  \n ## ##   \n ## ##   \n  ###    \n  ###    \n         \n',
    'Z': u'#######  \n##  ##   \n   ##    \n  ##     \n ##      \n##   ##  \n#######  \n         \n',
    '^': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'b': u'# #      \n# #      \n# #      \n# #      \n# #      \n# #      \n# #      \n  #      \n',
    'f': u' #####   \n #####   \n ######  \n  ###### \n  ###### \n#  ##### \n#   #### \n##   ### \n',
    'j': u'#  ####  \n#  ####  \n#  ####  \n#  ####  \n#  ####  \n#  ##### \n    #### \n #  #### \n',
    'n': u'    #### \n    #### \n    #### \n   ##### \n######## \n######## \n######## \n### #### \n',
    'r': u'### #    \n### #    \n### #    \n### #    \n### #    \n### #    \n###      \n####     \n',
    'v': u' ####### \n######## \n         \n  ###### \n         \n         \n         \n         \n',
    'z': u'######   \n####   # \n##   ##  \n   ##    \n###      \n         \n         \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n         \n      ## \n      ## \n     ### \n     ### \n    #### \n    ##   \n',
    '%': u'         \n         \n     #   \n    ## # \n  ####   \n#######  \n  #####  \n   ####  \n',
    ')': u'         \n         \n         \n         \n         \n    #### \n  ###### \n######## \n',
    '-': u'         \n         \n         \n         \n         \n###      \n### #    \n##    ## \n',
    '1': u'         \n         \n         \n         \n         \n         \n# #      \n# #      \n',
    '5': u'  ###  # \n##### #  \n####  #  \n#### #   \n####  #  \n##### #  \n##### #  \n#####  # \n',
    '9': u'###### \n###### \n ##### \n ##### \n ##### \n ##### \n ##### \n ####  \n',
    '=': u'######## \n    #### \n  # #### \n##  #### \n    #### \n    #### \n    #### \n    #### \n',
    'A': u'  ###    \n ## ##   \n##   ##  \n##   ##  \n#######  \n##   ##  \n##   ##  \n         \n',
    'E': u'#######  \n ##   #  \n ##      \n ####    \n ##      \n ##   #  \n#######  \n         \n',
    'I': u' ######  \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    'M': u'##   ##  \n### ###  \n#######  \n## # ##  \n##   ##  \n##   ##  \n### ###  \n         \n',
    'Q': u'  ###    \n ## ##   \n##   ##  \n##   ##  \n##   ##  \n ## ##   \n  ####   \n     ##  \n',
    'U': u'##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n #####   \n         \n',
    'Y': u'###  ### \n ##  ##  \n  ####   \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    ']': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'a': u'######## \n######## \n######## \n######## \n######## \n####   # \n###  #   \n### #    \n',
    'e': u'######   \n#######  \n#######  \n######## \n######## \n ####### \n ####### \n  ###### \n',
    'i': u'  ##     \n##       \n       # \n      ## \n     ### \n    #### \n  ###### \n#######  \n',
    'm': u'##### #  \n#####  # \n######   \n#######  \n######## \n######## \n######## \n  ###### \n',
    'q': u'    #  # \n    #  # \n   ##  # \n  ###  # \n ####  # \n#####  # \n####   # \n###  # # \n',
    'u': u'## #     \n # #     \n##  #    \n### #    \n###  #   \n####  #  \n#####  # \n       # \n',
    'y': u' ####### \n   ##### \n #    ## \n  ###    \n     ### \n         \n         \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

char1_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'   ##    \n  #####  \n ##      \n  ####   \n     ##  \n #####   \n   ##    \n         \n',
    '(': u'         \n   ###   \n  ###    \n  ##     \n  ##     \n  ###    \n   ###   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'         \n  ####   \n ##  ##  \n ## ###  \n ### ##  \n ##  ##  \n  ####   \n         \n',
    '4': u'         \n    ##   \n   ###   \n  ####   \n ## ##   \n ######  \n    ##   \n         \n',
    '8': u'         \n  ####   \n ##  ##  \n  ####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '<': u'     ##  \n    ##   \n   ##    \n  ##     \n   ##    \n    ##   \n     ##  \n         \n',
    '@': u'         \n         \n         \n######## \n######## \n         \n         \n         \n',
    'D': u'         \n ####    \n ## ##   \n ##  ##  \n ##  ##  \n ## ##   \n ####    \n         \n',
    'H': u'         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'L': u'         \n ##      \n ##      \n ##      \n ##      \n ##      \n ######  \n         \n',
    'P': u'         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ##      \n ##      \n         \n',
    'T': u'         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    'X': u'         \n ##  ##  \n ##  ##  \n  ####   \n  ####   \n ##  ##  \n ##  ##  \n         \n',
    '\\': u'         \n  ####   \n ##      \n####     \n ##      \n ##  ##  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n         \n######## \n######## \n         \n         \n         \n         \n',
    'h': u'##   \n##   \n##   \n##   \n##   \n##   \n##   \n##   \n',
    'l': u'##       \n##       \n##       \n##       \n##       \n##       \n######## \n######## \n',
    'p': u'######## \n######## \n      ## \n      ## \n      ## \n      ## \n      ## \n      ## \n',
    't': u'##      \n##      \n##      \n##      \n##      \n##      \n##      \n##      \n',
    'x': u'   ##    \n   ##    \n ##  ##  \n ##  ##  \n   ##    \n   ##    \n  ####   \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n######## \n ##  ##  \n         \n',
    "'": u'         \n   ##    \n   ##    \n   ##    \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n #       \n         \n',
    '3': u'         \n ######  \n    ##   \n   ##    \n    ##   \n ##  ##  \n  ####   \n         \n',
    '7': u'         \n ######  \n     ##  \n    ##   \n   ##    \n  ##     \n  ##     \n         \n',
    ';': u'         \n         \n   ##    \n   ##    \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'         \n  ####   \n ##  ##  \n    ##   \n   ##    \n         \n   ##    \n         \n',
    'C': u'         \n  ####   \n ##  ##  \n ##      \n ##      \n ##  ##  \n  ####   \n         \n',
    'G': u'         \n  #####  \n ##      \n ##      \n ## ###  \n ##  ##  \n  #####  \n         \n',
    'K': u'         \n ##  ##  \n ## ##   \n ####    \n ####    \n ## ##   \n ##  ##  \n         \n',
    'O': u'         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'S': u'         \n  ####   \n ##      \n  ####   \n     ##  \n     ##  \n  ####   \n         \n',
    'W': u'         \n ##   ## \n ##   ## \n ## # ## \n ####### \n ### ### \n ##   ## \n         \n',
    '[': u'         \n  ####   \n  ##     \n  ##     \n  ##     \n  ##     \n  ####   \n         \n',
    '_': u'         \n   ##    \n  ##     \n ######  \n  ##     \n   ##    \n         \n         \n',
    'c': u'         \n         \n         \n######## \n######## \n         \n         \n         \n',
    'g': u'##     \n##     \n##     \n##     \n##     \n##     \n##     \n##     \n',
    'k': u'   ##    \n   ##    \n  ###    \n####     \n###      \n         \n         \n         \n',
    'o': u'######## \n######## \n##       \n##       \n##       \n##       \n##       \n##       \n',
    's': u'  ## ##  \n ####### \n ####### \n ####### \n  #####  \n   ###   \n    #    \n         \n',
    'w': u'         \n  ####   \n ######  \n ##  ##  \n ##  ##  \n ######  \n  ####   \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n',
    '&': u'   ###   \n  ## ##  \n   ###   \n  ###    \n ## #### \n ##  ##  \n  ### ## \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n######## \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'         \n  ####   \n ##  ##  \n    ##   \n   ##    \n  ##     \n ######  \n         \n',
    '6': u'         \n  ####   \n ##      \n #####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    ':': u'         \n         \n   ##    \n   ##    \n         \n   ##    \n   ##    \n         \n',
    '>': u' ##      \n  ##     \n   ##    \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    'B': u'         \n #####   \n ##  ##  \n #####   \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'F': u'         \n ######  \n ##      \n #####   \n ##      \n ##      \n ##      \n         \n',
    'J': u'         \n     ##  \n     ##  \n     ##  \n     ##  \n ##  ##  \n  ####   \n         \n',
    'N': u'         \n ##  ##  \n ### ##  \n ######  \n ######  \n ## ###  \n ##  ##  \n         \n',
    'R': u'         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ## ##   \n ##  ##  \n         \n',
    'V': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'Z': u'         \n ######  \n    ##   \n   ##    \n  ##     \n ##      \n ######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ######  \n   ##    \n   ##    \n   ##    \n         \n',
    'b': u'##    \n##    \n##    \n##    \n##    \n##    \n##    \n##    \n',
    'f': u'         \n         \n         \n         \n######## \n######## \n         \n         \n',
    'j': u'   ##    \n   ##    \n   ###   \n    #### \n     ### \n         \n         \n         \n',
    'n': u'      ## \n     ### \n    ###  \n   ###   \n  ###    \n ###     \n###      \n##       \n',
    'r': u'         \n         \n         \n         \n         \n######## \n######## \n         \n',
    'v': u'##    ## \n###  ### \n ######  \n  ####   \n  ####   \n ######  \n###  ### \n##    ## \n',
    'z': u'    #    \n   ###   \n  #####  \n ####### \n  #####  \n   ###   \n    #    \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n         \n',
    '%': u'         \n ##  ##  \n ## ##   \n   ##    \n  ##     \n ##  ##  \n #   ##  \n         \n',
    ')': u'         \n  ###    \n   ###   \n    ##   \n    ##   \n   ###   \n  ###    \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'         \n   ##    \n  ###    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    '5': u'         \n ######  \n ##      \n #####   \n     ##  \n ##  ##  \n  ####   \n         \n',
    '9': u'         \n  ####   \n ##  ##  \n  #####  \n     ##  \n    ##   \n  ###    \n         \n',
    '=': u'         \n         \n ######  \n         \n         \n ######  \n         \n         \n',
    'A': u'         \n   ##    \n  ####   \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n         \n',
    'E': u'         \n ######  \n ##      \n #####   \n ##      \n ##      \n ######  \n         \n',
    'I': u'         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    'M': u'         \n ##   ## \n ### ### \n ####### \n ## # ## \n ##   ## \n ##   ## \n         \n',
    'Q': u'         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ## ##   \n  ## ##  \n         \n',
    'U': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'Y': u'         \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n   ##    \n   ##    \n         \n',
    ']': u'         \n  ####   \n    ##   \n    ##   \n    ##   \n    ##   \n  ####   \n         \n',
    'a': u'    #    \n   ###   \n  #####  \n ####### \n ####### \n   ###   \n  #####  \n         \n',
    'e': u'         \n######## \n######## \n         \n         \n         \n         \n         \n',
    'i': u'         \n         \n         \n###      \n####     \n  ###    \n   ##    \n   ##    \n',
    'm': u'##       \n###      \n ###     \n  ###    \n   ###   \n    ###  \n     ### \n      ## \n',
    'q': u'         \n  ####   \n ######  \n ######  \n ######  \n ######  \n  ####   \n         \n',
    'u': u'         \n         \n         \n     ### \n    #### \n   ###   \n   ##    \n   ##    \n',
    'y': u'##  \n##  \n##  \n##  \n##  \n##  \n##  \n##  \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

char2_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'   ##    \n ######  \n #       \n ######  \n     ##  \n ######  \n   ##    \n         \n',
    '(': u'    ##   \n   ##    \n  ##     \n  ##     \n  ##     \n   ##    \n    ##   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u' ######  \n ##  ##  \n ##  ##  \n###  ##  \n###  ##  \n###  ##  \n#######  \n         \n',
    '4': u'##   ##  \n##   ##  \n##   ##  \n#######  \n    ###  \n    ###  \n    ###  \n         \n',
    '8': u' #####   \n ##  #   \n ##  #   \n#######  \n###  ##  \n###  ##  \n#######  \n         \n',
    '<': u'    ###  \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n    ###  \n         \n',
    '@': u'  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n ##   #  \n  ####   \n         \n',
    'D': u'#######  \n##   ##  \n##   ##  \n###  ##  \n###  ##  \n###  ##  \n#######  \n         \n',
    'H': u' ##  ##  \n ##  ##  \n ##  ##  \n#######  \n###  ##  \n###  ##  \n###  ##  \n         \n',
    'L': u' ##      \n ##      \n ##      \n###      \n###      \n###      \n#######  \n         \n',
    'P': u' ######  \n ##  ##  \n ##  ##  \n#######  \n###      \n###      \n###      \n         \n',
    'T': u'#######  \n  ##     \n  ##     \n  ###    \n  ###    \n  ###    \n  ###    \n         \n',
    'X': u'##   ##  \n##   ##  \n##   ##  \n  ###    \n###  ##  \n###  ##  \n###  ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'######   \n#######  \n     ##  \n##   ##  \n##   ##  \n#######  \n######   \n         \n',
    'h': u'##   ##  \n##   ##  \n##   ##  \n#### ##  \n##   ##  \n##   ##  \n##   ##  \n         \n',
    'l': u'##       \n##       \n##       \n##       \n##       \n#######  \n ######  \n         \n',
    'p': u'######   \n#######  \n     ##  \n######   \n##       \n##       \n##       \n         \n',
    't': u'#####    \n######   \n    ##   \n    ##   \n    ##   \n    ##   \n    ##   \n         \n',
    'x': u'##   ##  \n### ###  \n #####   \n  ###    \n #####   \n### ###  \n##   ##  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u' ##  ##  \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    "'": u'     ##  \n    ##   \n   ##    \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n      ## \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    '3': u'#######  \n     ##  \n     ##  \n  #####  \n    ###  \n    ###  \n#######  \n         \n',
    '7': u'#######  \n##   ##  \n    ##   \n   ##    \n  ###    \n  ###    \n  ###    \n         \n',
    ';': u'         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'#######  \n##   ##  \n    ##   \n   ##    \n  ###    \n         \n  ###    \n         \n',
    'C': u'#######  \n##   ##  \n##       \n###      \n###      \n###  ##  \n#######  \n         \n',
    'G': u' ######  \n ##  ##  \n ##      \n### ###  \n###  ##  \n###  ##  \n#######  \n         \n',
    'K': u'##  ##   \n##  ##   \n##  ##   \n#######  \n###  ##  \n###  ##  \n###  ##  \n         \n',
    'O': u' ######  \n ##  ##  \n ##  ##  \n###  ##  \n###  ##  \n###  ##  \n#######  \n         \n',
    'S': u'#######  \n##   ##  \n##       \n#######  \n    ###  \n##  ###  \n#######  \n         \n',
    'W': u' #  #  # \n #  #  # \n #  #  # \n##  #  # \n##  #  # \n##  #  # \n######## \n         \n',
    '[': u'  ####   \n  ##     \n  ##     \n  ##     \n  ##     \n  ##     \n  ####   \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u' #####   \n#######  \n##   ##  \n##       \n##   ##  \n#######  \n #####   \n         \n',
    'g': u' #####   \n#######  \n##       \n##  ###  \n##   ##  \n#######  \n #####   \n         \n',
    'k': u'##  ##   \n## ##    \n####     \n####     \n## ##    \n##  ##   \n##   ##  \n         \n',
    'o': u' #####   \n#######  \n##   ##  \n##   ##  \n##   ##  \n#######  \n #####   \n         \n',
    's': u' ######  \n#######  \n##       \n #####   \n     ##  \n#######  \n######   \n         \n',
    'w': u'##   ##  \n##   ##  \n## # ##  \n#######  \n#######  \n### ###  \n##   ##  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u' ##  ##  \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n         \n',
    '&': u'  ####   \n ##  ##  \n  ####   \n  ###    \n ##  ### \n ##  ##  \n  ###### \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n######## \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'#######  \n##   ##  \n     ##  \n#######  \n###      \n###      \n#######  \n         \n',
    '6': u'#######  \n##   ##  \n##       \n#######  \n###  ##  \n###  ##  \n#######  \n         \n',
    ':': u'         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '>': u' ###     \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n ###     \n         \n',
    'B': u'######   \n##  ##   \n##  ##   \n#######  \n###  ##  \n###  ##  \n#######  \n         \n',
    'F': u' ######  \n ##      \n ##      \n#####    \n###      \n###      \n###      \n         \n',
    'J': u'   ##    \n   ##    \n   ##    \n   ###   \n   ###   \n## ###   \n ####    \n         \n',
    'N': u' ######  \n ##  ##  \n ##  ##  \n###  ##  \n###  ##  \n###  ##  \n###  ##  \n         \n',
    'R': u'######   \n##  ##   \n##  ##   \n#######  \n###  ##  \n###  ##  \n###  ##  \n         \n',
    'V': u' ##  ##  \n ##  ##  \n ##  ##  \n###  ##  \n###  ##  \n######   \n  ###    \n         \n',
    'Z': u'#######  \n##   ##  \n     ##  \n#######  \n###      \n###  ##  \n#######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n',
    'b': u'######   \n#######  \n     ##  \n######   \n##   ##  \n#######  \n######   \n         \n',
    'f': u'#######  \n#######  \n         \n######   \n##       \n##       \n##       \n         \n',
    'j': u' ######  \n ######  \n    ##   \n##  ##   \n##  ##   \n######   \n ####    \n         \n',
    'n': u'##  ##   \n### ##   \n######   \n######   \n## ###   \n##  ##   \n##  ##   \n         \n',
    'r': u'######   \n#######  \n     ##  \n######   \n##   ##  \n##   ##  \n##   ##  \n         \n',
    'v': u'##   ##  \n##   ##  \n##   ##  \n##   ##  \n### ###  \n #####   \n  ###    \n         \n',
    'z': u'#######  \n#######  \n   ###   \n  ###    \n ###     \n#######  \n#######  \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'   ##    \n   ##    \n  ###    \n  ###    \n  ###    \n         \n  ###    \n         \n',
    '%': u' ##   #  \n ##  ##  \n    ##   \n   ##    \n  ##     \n ##  ##  \n #   ##  \n         \n',
    ')': u'  ##     \n   ##    \n    ##   \n    ##   \n    ##   \n   ##    \n  ##     \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'   ##    \n   ##    \n   ##    \n  ###    \n  ###    \n  ###    \n  ###    \n         \n',
    '5': u'#######  \n##   ##  \n##       \n#######  \n    ###  \n    ###  \n#######  \n         \n',
    '9': u'#######  \n##   ##  \n##   ##  \n#######  \n    ###  \n##  ###  \n#######  \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u' ######  \n ##  ##  \n ##  ##  \n#######  \n###  ##  \n###  ##  \n###  ##  \n         \n',
    'E': u' ######  \n ##      \n ##      \n#####    \n###      \n###      \n#######  \n         \n',
    'I': u'   ##    \n   ##    \n   ##    \n  ###    \n  ###    \n  ###    \n  ###    \n         \n',
    'M': u' ####### \n #  #  # \n #  #  # \n##  #  # \n##  #  # \n##  #  # \n##  #  # \n         \n',
    'Q': u' ######  \n ##   #  \n ##   #  \n###   #  \n###   #  \n### # #  \n#######  \n    ##   \n',
    'U': u' ##  ##  \n ##  ##  \n ##  ##  \n###  ##  \n###  ##  \n###  ##  \n#######  \n         \n',
    'Y': u'##   ##  \n##   ##  \n##   ##  \n#######  \n  ###    \n  ###    \n  ###    \n         \n',
    ']': u'  ####   \n    ##   \n    ##   \n    ##   \n    ##   \n   ###   \n  ####   \n         \n',
    'a': u'    ##   \n  #####  \n  ## ##  \n ##  ##  \n ######  \n##   ##  \n##   ##  \n         \n',
    'e': u' ######  \n#######  \n##       \n#######  \n##       \n#######  \n ######  \n         \n',
    'i': u' ######  \n ######  \n   ##    \n   ##    \n   ##    \n ######  \n ######  \n         \n',
    'm': u'##   ##  \n### ###  \n#######  \n#######  \n## # ##  \n##   ##  \n##   ##  \n         \n',
    'q': u' #####   \n#######  \n##   ##  \n##   ##  \n##   ##  \n#######  \n #### ## \n         \n',
    'u': u'##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n#######  \n #####   \n         \n',
    'y': u' ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n   ##    \n   ##    \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

char3_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'   ##    \n  #####  \n ##      \n  ####   \n     ##  \n #####   \n   ##    \n         \n',
    '(': u'    ##   \n   ##    \n  ##     \n  ##     \n  ##     \n   ##    \n    ##   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'  #####  \n ##   ## \n ##  ### \n ## # ## \n ###  ## \n ##   ## \n  #####  \n         \n',
    '4': u'     ##  \n    ###  \n   ####  \n  #  ##  \n ####### \n     ##  \n     ##  \n         \n',
    '8': u'  #####  \n ##   ## \n ##   ## \n  #####  \n ##   ## \n ##   ## \n  #####  \n         \n',
    '<': u'    ###  \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n    ###  \n         \n',
    '@': u'  ####   \n #    #  \n #  # #  \n #  ###  \n #       \n #    #  \n  ####   \n         \n',
    'D': u' ## ##   \n ### ##  \n ##   ## \n ##   ## \n ##   ## \n ##  ##  \n #####   \n         \n',
    'H': u' ##   ## \n ##   ## \n ##   ## \n ####### \n ##   ## \n ##   ## \n ##   ## \n         \n',
    'L': u' ####    \n  ##     \n ##      \n ##      \n ##   ## \n ##   ## \n ######  \n         \n',
    'P': u' ## ###  \n ###  ## \n ##   ## \n ######  \n ##      \n ##      \n ##      \n         \n',
    'T': u' ######  \n # ## #  \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'X': u' ##   ## \n ##   ## \n  ## ##  \n   ###   \n  ## ##  \n ##   ## \n ##   ## \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u' ####    \n  #  #   \n  #   #  \n  #   #  \n  #   #  \n  #  #   \n ####    \n         \n',
    'h': u' #    #  \n #    #  \n #    #  \n ######  \n #    #  \n #    #  \n #    #  \n         \n',
    'l': u' #       \n #       \n #       \n #       \n #       \n #       \n ######  \n         \n',
    'p': u' #####   \n #    #  \n #    #  \n #####   \n #       \n #       \n #       \n         \n',
    't': u'  #####  \n    #    \n    #    \n    #    \n    #    \n    #    \n    #    \n         \n',
    'x': u' #    #  \n #    #  \n  #  #   \n   ##    \n  #  #   \n #    #  \n #    #  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u' ##  ##  \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    "'": u'    ##   \n    ##   \n   ##    \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n      ## \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    '3': u'  #####  \n ##   ## \n ##   ## \n    ###  \n ##   ## \n ##   ## \n  #####  \n         \n',
    '7': u' ####### \n ##   ## \n     ##  \n    ##   \n   ##    \n   ##    \n  ####   \n         \n',
    ';': u'         \n         \n   ##    \n   ##    \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u' ######  \n ##   ## \n      ## \n     ##  \n   ###   \n         \n   ##    \n   ##    \n',
    'C': u'   ####  \n  ##  ## \n ##      \n ##      \n ##      \n  ##  ## \n   ####  \n         \n',
    'G': u'   ####  \n  ##  ## \n ##      \n ##  ### \n ##   ## \n  ## ### \n   ### # \n         \n',
    'K': u' ##  ##  \n ##  ##  \n ## ##   \n ####    \n ## ##   \n ##  ### \n ##   ## \n         \n',
    'O': u'   ###   \n  ## ##  \n ##   ## \n ##   ## \n ##   ## \n  ## ##  \n   ###   \n         \n',
    'S': u'  #####  \n ##   ## \n ##      \n  #####  \n      ## \n ##   ## \n  #####  \n         \n',
    'W': u' ###  ## \n  ##  ## \n ##   ## \n ## # ## \n ####### \n ### ### \n ##   ## \n         \n',
    '[': u'    ###  \n   ##    \n   ##    \n  ##     \n   ##    \n   ##    \n    ###  \n         \n',
    '_': u'         \n   #     \n  ##   # \n ####### \n ####### \n  ##   # \n   #     \n         \n',
    'c': u'   ###   \n  #   #  \n #       \n #       \n #       \n  #   #  \n   ###   \n         \n',
    'g': u'   ###   \n  #   #  \n #       \n #  ###  \n #    #  \n  #   #  \n   ###   \n         \n',
    'k': u' #    #  \n #   #   \n #  #    \n ###     \n #  #    \n #   #   \n #    #  \n         \n',
    'o': u'   ##    \n  #  #   \n #    #  \n #    #  \n #    #  \n  #  #   \n   ##    \n         \n',
    's': u'  ####   \n #    #  \n #       \n  ####   \n      #  \n #    #  \n  ####   \n         \n',
    'w': u' #    #  \n #    #  \n #    #  \n # ## #  \n # ## #  \n ##  ##  \n #    #  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'  ##  ## \n  ##  ## \n ##  ##  \n         \n         \n         \n         \n         \n',
    '&': u'  ####   \n ##  ##  \n  ####   \n  ###    \n ##  ### \n ##  ##  \n  ###### \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n######## \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'  #####  \n ##   ## \n ##   ## \n    ###  \n  ###    \n ##   ## \n ####### \n         \n',
    '6': u'  ###### \n ##   ## \n ##      \n ######  \n ##   ## \n ##   ## \n  #####  \n         \n',
    ':': u'         \n         \n   ##    \n   ##    \n         \n   ##    \n   ##    \n         \n',
    '>': u' ###     \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n ###     \n         \n',
    'B': u' ## ###  \n ###  ## \n ##   ## \n ######  \n ##   ## \n ##   ## \n ######  \n         \n',
    'F': u' ####### \n  ##   # \n  ##     \n  ####   \n  ##     \n  ##     \n ####    \n         \n',
    'J': u'   ##### \n     ##  \n     ##  \n     ##  \n     ##  \n ##  ##  \n  ####   \n         \n',
    'N': u' ##   ## \n ###  ## \n #### ## \n ## #### \n ##  ### \n ##   ## \n ##   ## \n         \n',
    'R': u' ## ###  \n ###  ## \n ##   ## \n ######  \n ## ##   \n ##  ### \n ##   ## \n         \n',
    'V': u' ###  ## \n  ##  ## \n ##   ## \n ##   ## \n ##  ##  \n  ####   \n   ##    \n         \n',
    'Z': u' ####### \n ##   ## \n     ##  \n   ###   \n  ##  ## \n ##   ## \n ######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ######  \n   ##    \n   ##    \n   ##    \n  ####   \n',
    'b': u' #####   \n  #   #  \n  #   #  \n  ####   \n  #   #  \n  #   #  \n #####   \n         \n',
    'f': u' ######  \n #       \n #       \n ####    \n #       \n #       \n #       \n         \n',
    'j': u'    ###  \n     #   \n     #   \n     #   \n     #   \n #   #   \n  ###    \n         \n',
    'n': u' #    #  \n ##   #  \n # #  #  \n #  # #  \n #   ##  \n #    #  \n #    #  \n         \n',
    'r': u' #####   \n #    #  \n #    #  \n #####   \n #  #    \n #   #   \n #    #  \n         \n',
    'v': u' #    #  \n #    #  \n #    #  \n  #  #   \n  #  #   \n   ##    \n   ##    \n         \n',
    'z': u' ######  \n      #  \n     #   \n   ##    \n  #      \n #       \n ######  \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n   ##    \n         \n',
    '%': u' ##   #  \n ##  ##  \n    ##   \n   ##    \n  ##     \n ##  ##  \n #   ##  \n         \n',
    ')': u'  ##     \n   ##    \n    ##   \n    ##   \n    ##   \n   ##    \n  ##     \n         \n',
    '-': u'         \n         \n         \n ## ###  \n  ### ## \n         \n         \n         \n',
    '1': u'    ##   \n   ###   \n    ##   \n    ##   \n    ##   \n    ##   \n  ###### \n         \n',
    '5': u' ####### \n ##   ## \n ##      \n  #####  \n      ## \n ##   ## \n  #####  \n         \n',
    '9': u'  #####  \n ##   ## \n ##   ## \n  ###### \n      ## \n ##   ## \n ######  \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'   ###   \n  ## ##  \n ##   ## \n ####### \n ##   ## \n ##   ## \n ##   ## \n         \n',
    'E': u' ####### \n  ##   # \n  ##     \n  ####   \n  ##     \n  ##   # \n ####### \n         \n',
    'I': u'  ####   \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'M': u' ##   ## \n ### ### \n ####### \n ## # ## \n ##   ## \n ##   ## \n ##   ## \n         \n',
    'Q': u'   ###   \n  ## ##  \n ##   ## \n ## # ## \n ##  ### \n  ## ##  \n   ### # \n         \n',
    'U': u' ###  ## \n  ##  ## \n ##   ## \n ##   ## \n ##   ## \n ### ##  \n  ####   \n         \n',
    'Y': u'  ##  ## \n ##   ## \n ##   ## \n  ## ##  \n   ###   \n ####    \n ###     \n         \n',
    ']': u' ###     \n   ##    \n   ##    \n    ##   \n   ##    \n   ##    \n ###     \n         \n',
    'a': u'   ##    \n  #  #   \n #    #  \n ######  \n #    #  \n #    #  \n #    #  \n         \n',
    'e': u' ######  \n #       \n #       \n ####    \n #       \n #       \n ######  \n         \n',
    'i': u'   ###   \n    #    \n    #    \n    #    \n    #    \n    #    \n   ###   \n         \n',
    'm': u' #    #  \n ##  ##  \n # ## #  \n # ## #  \n #    #  \n #    #  \n #    #  \n         \n',
    'q': u'   ##    \n  #  #   \n #    #  \n #    #  \n #  # #  \n  #  #   \n   ## #  \n         \n',
    'u': u' #    #  \n #    #  \n #    #  \n #    #  \n #    #  \n #    #  \n  ####   \n         \n',
    'y': u'  #   #  \n  #   #  \n  #   #  \n   ###   \n    #    \n    #    \n    #    \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

char4_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'   ##    \n  #####  \n ##      \n  ####   \n     ##  \n######   \n  ##     \n         \n',
    '(': u'    ##   \n   ##    \n  ##     \n  ##     \n  ##     \n   ##    \n    ##   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'  ####   \n ##  ##  \n ## ###  \n#### ##  \n##   ##  \n##   ##  \n #####   \n         \n',
    '4': u'     ##  \n    ###  \n  #####  \n ##  ##  \n######## \n     ##  \n     ##  \n         \n',
    '8': u'   ###   \n  #  ##  \n ##  ##  \n  ####   \n###  ##  \n##  ##   \n ####    \n         \n',
    '<': u'    ###  \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n    ###  \n         \n',
    '@': u'# ###  # \n# ###    \n####     \n##  ## # \n##  ##   \n ##      \n#   ## # \n#   ##   \n',
    'D': u' ###     \n ####    \n ## ##   \n##   ##  \n##    ## \n##    ## \n#######  \n         \n',
    'H': u'  ## ##  \n  ## ##  \n ##  ##  \n#######  \n##   ##  \n##   ##  \n##   ##  \n         \n',
    'L': u'  ##     \n ##      \n ##      \n##       \n##       \n##       \n######   \n         \n',
    'P': u'  ####   \n ######  \n #   ##  \n##  ##   \n#####    \n##       \n##       \n         \n',
    'T': u'   ###   \n#######  \n  ##     \n  ##     \n  ##     \n  ##     \n  ##     \n         \n',
    'X': u'  ## ##  \n ##  ##  \n #####   \n  ###    \n #####   \n##   ##  \n##   ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'h': u' ###   # \n# ###    \n####   # \n## ##  # \n##  ##   \n ##    # \n#   ## # \n#   ##   \n',
    'l': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'p': u'#####    \n##  ##   \n         \n ## #  # \n#   ##   \n         \n ##    # \n#   ##   \n',
    't': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'x': u' ###   # \n######   \n         \n## ##    \n##   #   \n       # \n#   ##   \n##       \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'  ##  ## \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n##  ##   \n         \n',
    "'": u'    ###  \n    ##   \n    #    \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n      ## \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    '3': u'  ####   \n ##  ##  \n     ##  \n   ###   \n     ##  \n##  ###  \n ####    \n         \n',
    '7': u' ######  \n ##  ##  \n    ##   \n   ##    \n  ##     \n  ##     \n  ##     \n         \n',
    ';': u'         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'  ####   \n ##  ##  \n     ##  \n   ###   \n  ##     \n         \n ###     \n         \n',
    'C': u'   ###   \n ######  \n ##      \n##       \n##   ##  \n##  ###  \n ####    \n         \n',
    'G': u'   ###   \n  #####  \n ##      \n##       \n## ####  \n##  ###  \n #####   \n         \n',
    'K': u'  ## ##  \n ##  ##  \n #####   \n####     \n## ##    \n##  ##   \n##  ###  \n         \n',
    'O': u'   ###   \n  #####  \n ##  ##  \n##   ##  \n##   ##  \n##  ##   \n ####    \n         \n',
    'S': u'   ###   \n  #####  \n ##      \n  ####   \n     ##  \n##   ##  \n #####   \n         \n',
    'W': u'  ## ##  \n ##  ##  \n ##   #  \n##  # #  \n#######  \n###  ##  \n##   ##  \n         \n',
    '[': u'  ####   \n  ##     \n  ##     \n  ##     \n  ##     \n  ##     \n  ####   \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'g': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'k': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'o': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    's': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'w': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u' ##  ##  \n ##  ##  \n  #   #  \n  #   #  \n         \n         \n         \n         \n',
    '&': u'  ####   \n ##  ##  \n  ####   \n  ###    \n ##  ### \n ##  ##  \n  ###### \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n###  ### \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'  ####   \n ##  ##  \n     ##  \n   ###   \n ###     \n###      \n#######  \n         \n',
    '6': u'   ###   \n  ## ##  \n ##      \n######   \n##   ##  \n##   ##  \n #####   \n         \n',
    ':': u'         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '>': u' ###     \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n ###     \n         \n',
    'B': u'####     \n#####    \n##  ##   \n#####    \n##  ##   \n##  ###  \n######   \n         \n',
    'F': u'   ###   \n  #####  \n ##      \n####     \n##       \n##       \n###      \n         \n',
    'J': u'   ####  \n    ##   \n    ##   \n    ##   \n    ##   \n## ##    \n ####    \n         \n',
    'N': u'  ## ##  \n ### ##  \n ######  \n## ####  \n##  ###  \n##   ##  \n##   ##  \n         \n',
    'R': u' #####   \n ######  \n ##  ##  \n #####   \n ####    \n ## ##   \n ##  ##  \n         \n',
    'V': u'  ## ##  \n  ## ##  \n ##  ##  \n##   ##  \n##   ##  \n #####   \n  ##     \n         \n',
    'Z': u' ######  \n###  ##  \n    ##   \n  ###    \n ###     \n####     \n#######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n',
    'b': u'#  ###   \n ##      \n#      # \n#   ##   \n####     \n         \n         \n         \n',
    'f': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'j': u'#  ###   \n ##      \n ###   # \n#   ##   \n####     \n         \n         \n         \n',
    'n': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'r': u'###      \n         \n####   # \n##       \n         \n         \n         \n         \n',
    'v': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'z': u'##       \n       # \n ###   # \n###      \n         \n         \n         \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'  ####   \n  ####   \n   ##    \n   ##    \n         \n         \n   ##    \n         \n',
    '%': u' ##   #  \n ##  ##  \n    ##   \n   ##    \n  ##     \n ##  ##  \n #   ##  \n         \n',
    ')': u'  ##     \n   ##    \n    ##   \n    ##   \n    ##   \n   ##    \n  ##     \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'   ##    \n  ###    \n ####    \n   ##    \n  ##     \n  ##     \n#######  \n         \n',
    '5': u'   ####  \n  ##     \n #####   \n     ##  \n     ##  \n##  ##   \n ####    \n         \n',
    '9': u'  ####   \n ##  ##  \n ##  ##  \n  #####  \n     ##  \n##  ##   \n ####    \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'   ####  \n  #####  \n ##  ##  \n ##  ##  \n##  ###  \n## ####  \n##   ##  \n         \n',
    'E': u'   ###   \n  #####  \n ##      \n####     \n##   ##  \n##  ###  \n######   \n         \n',
    'I': u'  ####   \n   ##    \n   ##    \n  ##     \n  ##     \n  ##     \n ####    \n         \n',
    'M': u'  ##  #  \n  ## ##  \n ######  \n### ###  \n##   ##  \n##   ##  \n##   ##  \n         \n',
    'Q': u'   ###   \n  #####  \n ##  ##  \n##   ##  \n##   ##  \n #####   \n    ###  \n         \n',
    'U': u'  ## ##  \n  ## ##  \n ##  ##  \n##   ##  \n##   ##  \n##   ##  \n #####   \n         \n',
    'Y': u'  #  ##  \n ##  ##  \n #   ##  \n ## ##   \n  ###    \n  ##     \n  ###    \n         \n',
    ']': u'  ####   \n    ##   \n    ##   \n    ##   \n    ##   \n    ##   \n  ####   \n         \n',
    'a': u' ##    # \n#####  # \n#####    \n ##    # \n#      # \n# ##     \n ##    # \n#      # \n',
    'e': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'i': u' ##      \n#   ## # \n#####    \n ##      \n#   ## # \n# ##     \n ##      \n## ##  # \n',
    'm': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'q': u'       # \n ##      \n## ##    \n       # \n ##      \n ###     \n       # \n ##    # \n',
    'u': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'y': u'       # \n#   ##   \n####     \n         \n#   ##   \n##       \n         \n## ##    \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

charact1_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'         \n   ##    \n ######  \n # ##    \n ######  \n   ## #  \n ######  \n   ##    \n',
    '(': u'         \n    ##   \n   ##    \n   ##    \n   ##    \n   ##    \n    ##   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'         \n  #####  \n ##  ##  \n ## ###  \n ### ##  \n ##  ##  \n #####   \n         \n',
    '4': u'         \n    ###  \n  #####  \n ##  ##  \n ####### \n     ##  \n     ##  \n         \n',
    '8': u'         \n ######  \n ##  ##  \n  ####   \n ##  ##  \n ##  ##  \n ######  \n         \n',
    '<': u'         \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n         \n         \n',
    '@': u'         \n ######  \n ##   #  \n ## ###  \n ## ###  \n ##      \n ######  \n         \n',
    'D': u'         \n    ###  \n     ##  \n ######  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'H': u'         \n ##      \n ##      \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'L': u'         \n  ###    \n   ##    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    'P': u'         \n         \n ######  \n ##  ##  \n ##  ##  \n ######  \n ##      \n ##      \n',
    'T': u'         \n   ##    \n ######  \n   ##    \n   ##    \n   ##    \n   ####  \n         \n',
    'X': u'         \n         \n ##  ##  \n  ####   \n   ##    \n  ####   \n ##  ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n #####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'h': u'         \n ##  ##  \n ##  ##  \n ######  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'l': u'         \n ###     \n ###     \n ###     \n ###     \n ###     \n ######  \n         \n',
    'p': u'         \n ######  \n ##  ##  \n ##  ##  \n ######  \n ###     \n ###     \n         \n',
    't': u'         \n ######  \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    'x': u'         \n ##  ##  \n ######  \n   ##    \n ######  \n ##  ##  \n ##  ##  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    "'": u'         \n    ##   \n   ##    \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n     ##  \n    ###  \n   ###   \n  ###    \n ###     \n ##      \n         \n',
    '3': u'         \n ######  \n     ##  \n   ###   \n     ##  \n ##  ##  \n ######  \n         \n',
    '7': u'         \n ######  \n     ##  \n    ##   \n   ##    \n   ##    \n   ##    \n         \n',
    ';': u'         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'         \n ######  \n ##  ##  \n    ###  \n   ##    \n         \n   ##    \n         \n',
    'C': u'         \n         \n ######  \n ##  ##  \n ##      \n ##  ##  \n ######  \n         \n',
    'G': u'         \n         \n ######  \n ##  ##  \n ##  ##  \n ######  \n     ##  \n ######  \n',
    'K': u'         \n ##      \n ##      \n ## ###  \n ####    \n ## ##   \n ##  ##  \n         \n',
    'O': u'         \n         \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'S': u'         \n         \n ######  \n ##      \n ######  \n     ##  \n ######  \n         \n',
    'W': u'         \n         \n ##  ##  \n ##  ##  \n ######  \n ######  \n ##  ##  \n         \n',
    '[': u'         \n   ####  \n   ##    \n   ##    \n   ##    \n   ##    \n   ####  \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u'         \n ######  \n ### ##  \n ###     \n ###     \n ### ##  \n ######  \n         \n',
    'g': u'         \n ######  \n ######  \n ##      \n ## ###  \n ##  ##  \n ######  \n         \n',
    'k': u'         \n ##  ##  \n ## ##   \n ####    \n ####    \n #####   \n ##  ##  \n         \n',
    'o': u'         \n ######  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    's': u'         \n ######  \n ###     \n ######  \n     ##  \n ######  \n ######  \n         \n',
    'w': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n ######  \n ##  ##  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n         \n',
    '&': u'         \n ######  \n ##  ##  \n  ####   \n ## #### \n ##  ##  \n ####### \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n ######  \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'         \n ######  \n ##  ##  \n     ##  \n  ####   \n ##      \n ######  \n         \n',
    '6': u'         \n ######  \n ##      \n ######  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    ':': u'         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '>': u'         \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n         \n         \n',
    'B': u'         \n ##      \n ##      \n ######  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'F': u'         \n   ####  \n   ##    \n ######  \n   ##    \n   ##    \n  ####   \n         \n',
    'J': u'         \n    ##   \n         \n   ###   \n    ##   \n    ##   \n    ##   \n #####   \n',
    'N': u'         \n         \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'R': u'         \n         \n ######  \n ##  ##  \n ##      \n ##      \n ##      \n         \n',
    'V': u'         \n         \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'Z': u'         \n         \n ######  \n    ##   \n   ##    \n  ##     \n ######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ##  ##  \n         \n         \n         \n         \n',
    'b': u'         \n ######  \n ##  ##  \n #####   \n ##  ##  \n ######  \n ######  \n         \n',
    'f': u'         \n ######  \n ######  \n ##      \n ####    \n ##      \n ##      \n         \n',
    'j': u'         \n    ###  \n    ###  \n    ###  \n    ###  \n ## ###  \n ######  \n         \n',
    'n': u'         \n ##  ##  \n ### ##  \n ######  \n ## ###  \n ##  ##  \n ##  ##  \n         \n',
    'r': u'         \n ######  \n ##  ##  \n ##  ##  \n ######  \n #####   \n ##  ##  \n         \n',
    'v': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n  ####   \n   ##    \n         \n',
    'z': u'         \n ######  \n #  ###  \n   ###   \n  ###    \n ###  #  \n ######  \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n  ###    \n  ###    \n  ###    \n  ###    \n         \n  ###    \n         \n',
    '%': u'         \n ##  ##  \n ## ###  \n   ###   \n  ###    \n ### ##  \n ##  ##  \n         \n',
    ')': u'         \n  ##     \n   ##    \n   ##    \n   ##    \n   ##    \n  ##     \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'         \n   ##    \n  ###    \n ####    \n   ##    \n   ##    \n ######  \n         \n',
    '5': u'         \n ######  \n ##      \n ######  \n     ##  \n ##  ##  \n ######  \n         \n',
    '9': u'         \n ######  \n ##  ##  \n ##  ##  \n ######  \n     ##  \n ######  \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'         \n         \n  #####  \n     ##  \n ######  \n ##  ##  \n ######  \n         \n',
    'E': u'         \n         \n ######  \n ##  ##  \n ######  \n ##      \n #####   \n         \n',
    'I': u'         \n   ##    \n         \n  ###    \n   ##    \n   ##    \n ######  \n         \n',
    'M': u'         \n         \n ##  ##  \n ######  \n ######  \n ## ###  \n ## ###  \n         \n',
    'Q': u'         \n         \n ######  \n ##  ##  \n ##  ##  \n ######  \n     ##  \n     ##  \n',
    'U': u'         \n         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'Y': u'         \n         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n    ##   \n #####   \n',
    ']': u'         \n ####    \n   ##    \n   ##    \n   ##    \n   ##    \n ####    \n         \n',
    'a': u'         \n ######  \n ######  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'e': u'         \n ######  \n ######  \n ##      \n ####    \n ##      \n ######  \n         \n',
    'i': u'         \n ######  \n   ##    \n   ##    \n   ##    \n ######  \n ######  \n         \n',
    'm': u'         \n ##  ##  \n ######  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'q': u'         \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n    ###  \n         \n',
    'u': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n ######  \n         \n',
    'y': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n   ##    \n  ####   \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

charact2_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'         \n   ##    \n  #####  \n ## #    \n  ####   \n   # ##  \n #####   \n   ##    \n',
    '(': u'         \n    ##   \n   ##    \n   ##    \n   ##    \n   ##    \n    ##   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'         \n  #####  \n ##  ##  \n ## ###  \n ### ##  \n ##  ##  \n #####   \n         \n',
    '4': u'         \n    ###  \n  #####  \n ##  ##  \n ####### \n     ##  \n     ##  \n         \n',
    '8': u'         \n  ####   \n ##  ##  \n  ####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '<': u'         \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n         \n         \n',
    '@': u'         \n  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n  #####  \n         \n',
    'D': u'         \n     ##  \n     ##  \n  #####  \n ##  ##  \n ##  ##  \n  #####  \n         \n',
    'H': u'         \n ##      \n ##      \n #####   \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'L': u'         \n  ###    \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'P': u'         \n         \n         \n #####   \n ##  ##  \n #####   \n ##      \n ##      \n',
    'T': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n    ###  \n         \n',
    'X': u'         \n         \n         \n ##  ##  \n  ####   \n  ####   \n ##  ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n #####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'h': u'         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'l': u'         \n ##      \n ##      \n ##      \n ##      \n ##      \n ######  \n         \n',
    'p': u'         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ##      \n ##      \n         \n',
    't': u'         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    'x': u'         \n ##  ##  \n  ####   \n   ##    \n  ####   \n ##  ##  \n ##  ##  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    "'": u'         \n    ##   \n   ##    \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n      #  \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    '3': u'         \n ######  \n     ##  \n   ###   \n     ##  \n ##  ##  \n  ####   \n         \n',
    '7': u'         \n ######  \n     ##  \n    ##   \n   ##    \n   ##    \n   ##    \n         \n',
    ';': u'         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'         \n  ####   \n ##  ##  \n    ##   \n   ##    \n         \n   ##    \n         \n',
    'C': u'         \n         \n         \n  #####  \n ##      \n ##      \n  #####  \n         \n',
    'G': u'         \n         \n         \n  #####  \n ##  ##  \n  #####  \n     ##  \n #####   \n',
    'K': u'         \n ##      \n ##      \n ## ###  \n ####    \n ## ##   \n ##  ##  \n         \n',
    'O': u'         \n         \n         \n  ####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'S': u'         \n         \n         \n  #####  \n ####    \n   ####  \n #####   \n         \n',
    'W': u'         \n         \n         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n         \n',
    '[': u'         \n   ####  \n   ##    \n   ##    \n   ##    \n   ##    \n   ####  \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u'         \n  ####   \n ##  ##  \n ##      \n ##      \n ##  ##  \n  ####   \n         \n',
    'g': u'         \n  #####  \n ##      \n ##      \n ## ###  \n ##  ##  \n  ####   \n         \n',
    'k': u'         \n ##  ##  \n ## ##   \n ####    \n ####    \n ## ##   \n ##  ##  \n         \n',
    'o': u'         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    's': u'         \n  #####  \n ##      \n  ####   \n     ##  \n     ##  \n #####   \n         \n',
    'w': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n ######  \n ##  ##  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n         \n',
    '&': u'         \n  ####   \n ##  ##  \n  ####   \n ## #### \n ##  ##  \n  ###### \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n ######  \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'         \n  ####   \n ##  ##  \n     ##  \n  ####   \n ##      \n ######  \n         \n',
    '6': u'         \n  #####  \n ##      \n #####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    ':': u'         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '>': u'         \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n         \n         \n',
    'B': u'         \n ##      \n ##      \n #####   \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'F': u'         \n    ###  \n   ##    \n ######  \n   ##    \n   ##    \n  ####   \n         \n',
    'J': u'         \n    ##   \n         \n   ###   \n    ##   \n    ##   \n    ##   \n ####    \n',
    'N': u'         \n         \n         \n #####   \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'R': u'         \n         \n         \n #####   \n ##  ##  \n ##      \n ##      \n         \n',
    'V': u'         \n         \n         \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'Z': u'         \n         \n         \n ######  \n   ###   \n  ###    \n ######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ##  ##  \n         \n         \n         \n         \n',
    'b': u'         \n #####   \n ##  ##  \n #####   \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'f': u'         \n  #####  \n ##      \n ####    \n ##      \n ##      \n ##      \n         \n',
    'j': u'         \n     ##  \n     ##  \n     ##  \n     ##  \n ##  ##  \n  ####   \n         \n',
    'n': u'         \n ##  ##  \n ### ##  \n ######  \n ## ###  \n ##  ##  \n ##  ##  \n         \n',
    'r': u'         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ## ##   \n ##  ##  \n         \n',
    'v': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'z': u'         \n ######  \n    ##   \n   ##    \n  ##     \n ##      \n ######  \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n         \n',
    '%': u'         \n ##   #  \n ##  ##  \n   ###   \n   ##    \n  ## ##  \n ##  ##  \n         \n',
    ')': u'         \n  ##     \n   ##    \n   ##    \n   ##    \n   ##    \n  ##     \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'         \n   ##    \n  ###    \n ####    \n   ##    \n   ##    \n ######  \n         \n',
    '5': u'         \n ######  \n ##      \n #####   \n     ##  \n ##  ##  \n  ####   \n         \n',
    '9': u'         \n  ####   \n ##  ##  \n ##  ##  \n  #####  \n     ##  \n #####   \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'         \n         \n         \n  #####  \n     ##  \n ######  \n  #####  \n         \n',
    'E': u'         \n         \n         \n  ####   \n ######  \n ##      \n  ####   \n         \n',
    'I': u'         \n   ##    \n         \n  ###    \n   ##    \n   ##    \n ######  \n         \n',
    'M': u'         \n         \n         \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'Q': u'         \n         \n         \n  #####  \n ##  ##  \n  #####  \n     ##  \n     ##  \n',
    'U': u'         \n         \n         \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'Y': u'         \n         \n         \n ##  ##  \n ##  ##  \n  #####  \n    ##   \n #####   \n',
    ']': u'         \n ####    \n   ##    \n   ##    \n   ##    \n   ##    \n ####    \n         \n',
    'a': u'         \n  ####   \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'e': u'         \n  #####  \n ##      \n ####    \n ##      \n ##      \n  #####  \n         \n',
    'i': u'         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    'm': u'         \n ##  ##  \n ######  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'q': u'         \n  ####   \n ##  ##  \n ##  ##  \n ## ###  \n  ####   \n    ###  \n         \n',
    'u': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'y': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n   ##    \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

charact3_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'    ##   \n  #####  \n ## #    \n  ####   \n   # ##  \n #####   \n  ##     \n         \n',
    '(': u'         \n   ####  \n  ##     \n ##      \n ##      \n ##      \n  ###    \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'         \n  #####  \n ##   ## \n####  ## \n## ##### \n##   ##  \n #####   \n         \n',
    '4': u'         \n   ##### \n  ## ### \n ##  ##  \n######   \n   ##    \n   ##    \n         \n',
    '8': u'         \n   ####  \n  ##  ## \n   ## ## \n ## ##   \n##   ##  \n #####   \n         \n',
    '<': u'         \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n         \n         \n',
    '@': u'         \n   ##### \n  ##   # \n ## #### \n##  ###  \n##       \n######   \n         \n',
    'D': u'         \n      ## \n      ## \n  ###### \n ##  ##  \n##   ##  \n#######  \n         \n',
    'H': u'         \n  ##     \n  ##     \n ##      \n ######  \n###  ##  \n##  ##   \n         \n',
    'L': u'         \n     ##  \n     ##  \n    ##   \n    ##   \n   ##    \n #####   \n         \n',
    'P': u'         \n         \n         \n   ##### \n  ##  ## \n ######  \n ##      \n##       \n',
    'T': u'         \n    ##   \n    ##   \n ######  \n   ##    \n  ## ##  \n  #####  \n         \n',
    'X': u'         \n         \n         \n ###  ## \n  ## ##  \n   ###   \n ### ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n  #####  \n  ##  ## \n ##   ## \n###   ## \n##   ##  \n######   \n         \n',
    'h': u'         \n  ##  ## \n ##  ### \n ##  ##  \n#######  \n##  ##   \n##  ##   \n         \n',
    'l': u'         \n   ###   \n  ###    \n  ##     \n ###     \n ##  ##  \n#######  \n         \n',
    'p': u'         \n  #####  \n  ##  ## \n ##  ### \n ######  \n##       \n##       \n         \n',
    't': u'         \n  ###### \n    ##   \n   ##    \n   ##    \n  ##     \n  ##     \n         \n',
    'x': u'         \n  ##  ## \n  ## ##  \n   ###   \n  ####   \n ##  ##  \n##   ##  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n  ##  ## \n######## \n ##  ##  \n######## \n##  ##   \n         \n         \n',
    "'": u'         \n    ##   \n   ##    \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n      ## \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    '3': u'         \n   ##### \n      ## \n  #####  \n    ##   \n##  ##   \n ####    \n         \n',
    '7': u'         \n ####### \n###  ### \n    ##   \n   ##    \n  ##     \n ###     \n         \n',
    ';': u'         \n         \n    ##   \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'         \n  ####   \n ##  ##  \n    ##   \n   ##    \n         \n  ##     \n         \n',
    'C': u'         \n         \n         \n  #####  \n  ##     \n ##      \n ######  \n         \n',
    'G': u'         \n         \n         \n  ###### \n ##  ##  \n######   \n   ##    \n####     \n',
    'K': u'         \n  ##     \n  ##     \n ##  ##  \n #####   \n### ##   \n##   ##  \n         \n',
    'O': u'         \n         \n         \n   ##### \n  ##  ## \n ##  ##  \n #####   \n         \n',
    'S': u'         \n         \n         \n  #####  \n  ##     \n    ##   \n######   \n         \n',
    'W': u'         \n         \n         \n  ##  ## \n  ##  ## \n ######  \n###  ##  \n         \n',
    '[': u'         \n   ##### \n   ##    \n  ##     \n  ##     \n ##      \n######   \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u'         \n  ###### \n ###  ## \n ##      \n##       \n##  ##   \n######   \n         \n',
    'g': u'         \n  ###### \n ###  ## \n ##      \n##  ###  \n##   ##  \n #####   \n         \n',
    'k': u'         \n  ##  ## \n  ##  ## \n ##  ##  \n #####   \n##  ##   \n##   ##  \n         \n',
    'o': u'         \n   ####  \n  ##  ## \n ##   ## \n##   ##  \n##  ##   \n ####    \n         \n',
    's': u'         \n   ####  \n  ##  ## \n  ###    \n    ###  \n##   ##  \n #####   \n         \n',
    'w': u'         \n  ##  ## \n  ##  ## \n ##   ## \n ####### \n#######  \n##   ##  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n  ##  ## \n ##  ##  \n         \n         \n         \n         \n         \n',
    '&': u'         \n    #### \n   ## ## \n   ####  \n  ####   \n ##  ### \n ######  \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n######## \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'         \n   ####  \n  ##  ## \n     ### \n  ####   \n ##      \n#######  \n         \n',
    '6': u'         \n   ##### \n  ##     \n #####   \n###  ##  \n##   ##  \n #####   \n         \n',
    ':': u'         \n         \n    ##   \n         \n         \n   ##    \n         \n         \n',
    '>': u'         \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n         \n         \n',
    'B': u'         \n   ##    \n   ##    \n  ###### \n  ##  ## \n ##  ### \n #####   \n         \n',
    'F': u'         \n    ###  \n   ## ## \n   ##    \n######   \n  ##     \n ##      \n         \n',
    'J': u'         \n     ##  \n         \n    ###  \n     ##  \n    ##   \n##  ##   \n#####    \n',
    'N': u'         \n         \n         \n  #####  \n ###  ## \n ##   ## \n###  ##  \n         \n',
    'R': u'         \n         \n         \n  #####  \n ##  ##  \n ##      \n##       \n         \n',
    'V': u'         \n         \n         \n  ##  ## \n  ## ##  \n ## ##   \n ####    \n         \n',
    'Z': u'         \n         \n         \n ####### \n    ###  \n  ###    \n#######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ##  ##  \n         \n         \n         \n         \n',
    'b': u'         \n  ###### \n ###  ## \n ######  \n###  ##  \n##   ##  \n######   \n         \n',
    'f': u'         \n  ###### \n ###  ## \n ##      \n######   \n##       \n##       \n         \n',
    'j': u'         \n  ###### \n    ##   \n   ##    \n   ##    \n## ##    \n####     \n         \n',
    'n': u'         \n  ##  ## \n  ### ## \n ######  \n ## ###  \n##  ##   \n##  ##   \n         \n',
    'r': u'         \n  #####  \n  ##  ## \n ##  ### \n ######  \n##  ##   \n##   ### \n         \n',
    'v': u'         \n  ##   # \n  ##  ## \n ##  ##  \n ## ##   \n#####    \n###      \n         \n',
    'z': u'         \n  ###### \n ##  ### \n    ##   \n  ##     \n###  ##  \n######   \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n    ##   \n    ##   \n   ##    \n   ##    \n         \n  ##     \n         \n',
    '%': u'         \n ##  ##  \n ## ##   \n   ##    \n  ## ##  \n ##  ##  \n         \n         \n',
    ')': u'         \n   ###   \n     ##  \n     ##  \n     ##  \n    ##   \n ####    \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'         \n     ### \n    ###  \n   ###   \n    ##   \n   ##    \n######   \n         \n',
    '5': u'         \n   ##### \n  ##     \n  ####   \n     ##  \n##  ##   \n ####    \n         \n',
    '9': u'         \n   ####  \n  ##  ## \n ##   ## \n  ###### \n     ##  \n #####   \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'         \n         \n         \n  ###### \n ##  ##  \n##  ###  \n ######  \n         \n',
    'E': u'         \n         \n         \n  #####  \n #####   \n##       \n#######  \n         \n',
    'I': u'         \n    ##   \n         \n    ##   \n    ##   \n   ##    \n #####   \n         \n',
    'M': u'         \n         \n         \n  ##  ## \n ####### \n##   ##  \n##  ##   \n         \n',
    'Q': u'         \n         \n         \n  ###### \n ##  ##  \n #####   \n    ##   \n   ##    \n',
    'U': u'         \n         \n         \n  ##  ## \n  ##  ## \n ##  ##  \n  ####   \n         \n',
    'Y': u'         \n         \n         \n  ##  ## \n ##  ### \n ######  \n    ##   \n  ###    \n',
    ']': u'         \n   ##### \n      ## \n     ##  \n     ##  \n    ##   \n#####    \n         \n',
    'a': u'         \n  ###### \n ###  ## \n ##  ##  \n#######  \n##  ##   \n##  ##   \n         \n',
    'e': u'         \n  ###### \n ###  ## \n ####    \n ##      \n###  ##  \n#######  \n         \n',
    'i': u'         \n   ##### \n    ##   \n    ##   \n   ##    \n   ##    \n #####   \n         \n',
    'm': u'         \n  ##  ## \n  ###### \n ####### \n ##  ##  \n##  ##   \n##  ##   \n         \n',
    'q': u'         \n  ###### \n  ##  ## \n ##  ##  \n ### ##  \n## ###   \n#######  \n         \n',
    'u': u'         \n  ##  ## \n  ##  ## \n ##  ##  \n ##  ##  \n##  ##   \n ####    \n         \n',
    'y': u'         \n ##   ## \n  ## ##  \n   ###   \n   ##    \n  ##     \n  ##     \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

charact4_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'         \n   ##    \n ######  \n # ##    \n ######  \n   ## #  \n ######  \n   ##    \n',
    '(': u'         \n    ##   \n   ##    \n   ##    \n   ##    \n   ##    \n    ##   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'         \n ######  \n ##  ##  \n ## ###  \n ### ##  \n ##  ##  \n ######  \n         \n',
    '4': u'         \n ##      \n ##      \n ## ##   \n ######  \n    ##   \n    ##   \n         \n',
    '8': u'         \n ######  \n ## ###  \n  ####   \n ## ###  \n ## ###  \n ######  \n         \n',
    '<': u'         \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n         \n         \n',
    '@': u'         \n ######  \n ##  ##  \n ## ###  \n ## ###  \n ##      \n ######  \n         \n',
    'D': u'         \n     ##  \n     ##  \n ######  \n ## ###  \n ## ###  \n ######  \n         \n',
    'H': u'         \n ##      \n ##      \n ######  \n ### ##  \n ### ##  \n ### ##  \n         \n',
    'L': u'         \n   ##    \n   ##    \n   ##    \n   ###   \n   ###   \n   ###   \n         \n',
    'P': u'         \n         \n         \n ######  \n ##  ##  \n ######  \n ###     \n ###     \n',
    'T': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ###   \n   ###   \n         \n',
    'X': u'         \n         \n         \n ##  ##  \n  ####   \n  ####   \n ##  ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n #####   \n ##  ##  \n ##  ##  \n ### ##  \n ### ##  \n #####   \n         \n',
    'h': u'         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ### ##  \n ### ##  \n         \n',
    'l': u'         \n  ##     \n  ##     \n  ##     \n ###     \n ###     \n ######  \n         \n',
    'p': u'         \n ######  \n ##  ##  \n ##  ##  \n ######  \n ###     \n ###     \n         \n',
    't': u'         \n ######  \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    'x': u'         \n ## ###  \n ######  \n   ##    \n ######  \n ### ##  \n ### ##  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    "'": u'         \n    ##   \n   ##    \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n      #  \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    '3': u'         \n ######  \n     ##  \n   ####  \n    ###  \n    ###  \n ######  \n         \n',
    '7': u'         \n ######  \n     ##  \n    ##   \n   ##    \n  ###    \n  ###    \n         \n',
    ';': u'         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'         \n ######  \n ##  ##  \n    ##   \n   ###   \n         \n   ##    \n         \n',
    'C': u'         \n         \n         \n ######  \n ###     \n ###     \n ######  \n         \n',
    'G': u'         \n         \n         \n ######  \n ## ###  \n ######  \n     ##  \n ######  \n',
    'K': u'         \n ##      \n ##      \n ## ##   \n ####    \n #####   \n ### ##  \n         \n',
    'O': u'         \n         \n         \n ######  \n ##  ##  \n ## ###  \n ######  \n         \n',
    'S': u'         \n         \n         \n ######  \n ###     \n   ####  \n ######  \n         \n',
    'W': u'         \n         \n         \n ##  ##  \n ######  \n ######  \n ##  ##  \n         \n',
    '[': u'         \n   ####  \n   ##    \n   ##    \n   ##    \n   ##    \n   ####  \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u'         \n ######  \n ## ###  \n ##      \n ##      \n ##  ##  \n ######  \n         \n',
    'g': u'         \n ######  \n ##  ##  \n ##      \n ## ###  \n ##  ##  \n ######  \n         \n',
    'k': u'         \n ##  ##  \n ## ##   \n ####    \n #####   \n ### ##  \n ### ##  \n         \n',
    'o': u'         \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n ## ###  \n ######  \n         \n',
    's': u'         \n ######  \n ### ##  \n ###     \n ######  \n    ###  \n ######  \n         \n',
    'w': u'         \n ##  ##  \n ##  ##  \n ######  \n ######  \n ######  \n ##  ##  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n         \n',
    '&': u'         \n ######  \n ## ###  \n  ####   \n ####### \n ##  ##  \n ####### \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n ######  \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'         \n ######  \n    ###  \n    ###  \n ######  \n ##      \n ######  \n         \n',
    '6': u'         \n ######  \n ### ##  \n ###     \n ######  \n ##  ##  \n ######  \n         \n',
    ':': u'         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '>': u'         \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n         \n         \n',
    'B': u'         \n ##      \n ##      \n ######  \n ### ##  \n ### ##  \n ######  \n         \n',
    'F': u'         \n  #####  \n  ###    \n #####   \n  ###    \n  ###    \n  ###    \n         \n',
    'J': u'         \n    ##   \n         \n    ##   \n    ##   \n   ###   \n   ###   \n #####   \n',
    'N': u'         \n         \n         \n ######  \n ##  ##  \n ### ##  \n ### ##  \n         \n',
    'R': u'         \n         \n         \n ######  \n ##  ##  \n ###     \n ###     \n         \n',
    'V': u'         \n         \n         \n ##  ##  \n ######  \n  ####   \n   ##    \n         \n',
    'Z': u'         \n         \n         \n ######  \n   ###   \n  ###    \n ######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ##  ##  \n         \n         \n         \n         \n',
    'b': u'         \n ######  \n ##  ##  \n #####   \n ### ##  \n ### ##  \n ######  \n         \n',
    'f': u'         \n ######  \n ##      \n ####    \n ###     \n ###     \n ###     \n         \n',
    'j': u'         \n     ##  \n     ##  \n    ###  \n    ###  \n ## ###  \n ######  \n         \n',
    'n': u'         \n ##  ##  \n ### ##  \n ######  \n ######  \n ### ##  \n ### ##  \n         \n',
    'r': u'         \n ######  \n ## ###  \n ## ###  \n #####   \n ## ###  \n ##  ##  \n         \n',
    'v': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n  ####   \n   ##    \n         \n',
    'z': u'         \n ######  \n    ##   \n   ##    \n  ##     \n ######  \n ######  \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n         \n',
    '%': u'         \n ##   #  \n ##  ##  \n   ###   \n   ##    \n  ## ##  \n ##  ##  \n         \n',
    ')': u'         \n  ##     \n   ##    \n   ##    \n   ##    \n   ##    \n  ##     \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'         \n   ##    \n  ###    \n   ##    \n   ##    \n ######  \n ######  \n         \n',
    '5': u'         \n ######  \n ##      \n ######  \n    ###  \n ## ###  \n ######  \n         \n',
    '9': u'         \n ######  \n ##  ##  \n ######  \n    ###  \n    ###  \n    ###  \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'         \n         \n  #####  \n    ###  \n ######  \n ##  ##  \n ######  \n         \n',
    'E': u'         \n         \n #####   \n ##      \n #####   \n ###     \n #####   \n         \n',
    'I': u'         \n   ##    \n         \n   ##    \n   ##    \n   ###   \n   ###   \n         \n',
    'M': u'         \n         \n         \n ##  ##  \n ######  \n ## ###  \n ## ###  \n         \n',
    'Q': u'         \n         \n         \n ######  \n ##  ##  \n ######  \n    ###  \n    ###  \n',
    'U': u'         \n         \n         \n ##  ##  \n ### ##  \n ### ##  \n ######  \n         \n',
    'Y': u'         \n         \n         \n ##  ##  \n ##  ##  \n ######  \n    ###  \n ######  \n',
    ']': u'         \n ####    \n   ##    \n   ##    \n   ##    \n   ##    \n ####    \n         \n',
    'a': u'         \n  ####   \n  ####   \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'e': u'         \n ######  \n ##      \n ####    \n ###     \n ###     \n ######  \n         \n',
    'i': u'         \n  ####   \n  ####   \n   ##    \n   ##    \n  ####   \n  ####   \n         \n',
    'm': u'         \n ##  ##  \n ######  \n ######  \n ## ###  \n ## ###  \n ## ###  \n         \n',
    'q': u'         \n ######  \n ##  ##  \n ##  ##  \n ## ###  \n ######  \n    ###  \n         \n',
    'u': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ### ##  \n ### ##  \n ######  \n         \n',
    'y': u'         \n ##  ##  \n ##  ##  \n ######  \n ######  \n   ##    \n   ##    \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

charact5_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'         \n   ##    \n  #####  \n ## #    \n  ####   \n   # ##  \n #####   \n   ##    \n',
    '(': u'         \n    ##   \n   ##    \n   ##    \n   ##    \n   ##    \n    ##   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'         \n  ####   \n ### ##  \n ## ###  \n ### ##  \n ## ###  \n  ####   \n         \n',
    '4': u'         \n ##  ##  \n ##  ##  \n ######  \n ######  \n     ##  \n     ##  \n         \n',
    '8': u'         \n ######  \n ##  ##  \n  ####   \n ##  ##  \n ##  ##  \n ######  \n         \n',
    '<': u'         \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n         \n         \n',
    '@': u'         \n #####   \n###  ##  \n### ###  \n### ###  \n###      \n ######  \n         \n',
    'D': u'         \n    ###  \n    ###  \n  #####  \n ##  ##  \n ##  ##  \n  #####  \n         \n',
    'H': u'         \n ##      \n ##      \n #####   \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'L': u'         \n  ###    \n  ###    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    'P': u'         \n         \n         \n #####   \n ##  ##  \n #####   \n ##      \n ##      \n',
    'T': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n   ##    \n         \n',
    'X': u'         \n         \n         \n ##  ##  \n  ####   \n  ####   \n ##  ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n######   \n ### ##  \n ### ##  \n ### ##  \n ### ##  \n######   \n         \n',
    'h': u'         \n### ###  \n ## ##   \n #####   \n #####   \n ## ##   \n### ###  \n         \n',
    'l': u'         \n#####    \n ###     \n ###     \n ###     \n ### ##  \n#######  \n         \n',
    'p': u'         \n######   \n ######  \n ##  ##  \n #####   \n ###     \n#####    \n         \n',
    't': u'         \n ######  \n ######  \n # ## #  \n   ##    \n   ##    \n  ####   \n         \n',
    'x': u'         \n ##  ##  \n  ####   \n   ##    \n  ####   \n ######  \n ##  ##  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    "'": u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n      #  \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    '3': u'         \n ######  \n    ###  \n  ####   \n    ###  \n ## ###  \n  ####   \n         \n',
    '7': u'         \n ######  \n ##  ##  \n    ##   \n   ##    \n  ###    \n  ###    \n         \n',
    ';': u'         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'         \n  ####   \n ##  ##  \n    ##   \n   ##    \n         \n   ##    \n         \n',
    'C': u'         \n         \n         \n  #####  \n ###     \n ###     \n  #####  \n         \n',
    'G': u'         \n         \n         \n  #####  \n ##  ##  \n  #####  \n    ###  \n #####   \n',
    'K': u'         \n ##      \n ##  ##  \n #####   \n ####    \n ######  \n ## ###  \n         \n',
    'O': u'         \n         \n         \n  ####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'S': u'         \n         \n         \n  #####  \n ####    \n   ####  \n #####   \n         \n',
    'W': u'         \n         \n         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n         \n',
    '[': u'         \n   ####  \n   ##    \n   ##    \n   ##    \n   ##    \n   ####  \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u'         \n  #####  \n ### ##  \n ###     \n ###     \n ### ##  \n  #####  \n         \n',
    'g': u'         \n ######  \n###  ##  \n###      \n### ###  \n###  ##  \n #####   \n         \n',
    'k': u'         \n###  ##  \n ## ###  \n ####    \n #####   \n ## ###  \n###  ##  \n         \n',
    'o': u'         \n  ####   \n ######  \n ##  ##  \n ##  ##  \n ######  \n  ####   \n         \n',
    's': u'         \n  #####  \n ###  #  \n #####   \n  #####  \n #  ###  \n #####   \n         \n',
    'w': u'         \n ##  ##  \n ##  ##  \n ######  \n ######  \n ######  \n ##  ##  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n         \n',
    '&': u'         \n  ####   \n ##  ##  \n  ####   \n ## #### \n ##  ##  \n  ###### \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n ######  \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'         \n  ####   \n ## ###  \n    ###  \n  ####   \n ###     \n ######  \n         \n',
    '6': u'         \n  ####   \n ##      \n #####   \n ##  ##  \n ######  \n  ####   \n         \n',
    ':': u'         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '>': u'         \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n         \n         \n',
    'B': u'         \n ###     \n ###     \n #####   \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'F': u'         \n    ###  \n   ####  \n   ##    \n  ####   \n   ##    \n  ####   \n         \n',
    'J': u'         \n   ###   \n         \n   ###   \n   ###   \n   ###   \n   ###   \n ####    \n',
    'N': u'         \n         \n         \n #####   \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'R': u'         \n         \n         \n #####   \n ### ##  \n ##      \n ##      \n         \n',
    'V': u'         \n         \n         \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'Z': u'         \n         \n         \n ######  \n   ###   \n  ###    \n ######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ##  ##  \n         \n         \n         \n         \n',
    'b': u'         \n######   \n ### ##  \n #####   \n ### ##  \n ### ##  \n######   \n         \n',
    'f': u'         \n#######  \n ###     \n #####   \n ###     \n ###     \n#####    \n         \n',
    'j': u'         \n  #####  \n   ###   \n   ###   \n   ###   \n## ###   \n ####    \n         \n',
    'n': u'         \n ##  ##  \n ### ##  \n ######  \n ######  \n ## ###  \n ##  ##  \n         \n',
    'r': u'         \n######   \n ######  \n ##  ##  \n #####   \n #####   \n ##  ##  \n         \n',
    'v': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n  ####   \n   ##    \n         \n',
    'z': u'         \n ######  \n #  ##   \n   ##    \n  ##  #  \n ######  \n ######  \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n         \n',
    '%': u'         \n ##   #  \n ##  ##  \n   ###   \n   ##    \n  ## ##  \n ##  ##  \n         \n',
    ')': u'         \n  ##     \n   ##    \n   ##    \n   ##    \n   ##    \n  ##     \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'         \n   ##    \n  ###    \n ####    \n   ##    \n ######  \n ######  \n         \n',
    '5': u'         \n ######  \n ###     \n #####   \n    ###  \n ## ###  \n  ####   \n         \n',
    '9': u'         \n  ####   \n ######  \n ##  ##  \n  #####  \n     ##  \n  ####   \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'         \n         \n         \n  #####  \n     ##  \n ######  \n  #####  \n         \n',
    'E': u'         \n         \n         \n  ####   \n ######  \n ###     \n  ####   \n         \n',
    'I': u'         \n  ###    \n         \n  ###    \n   ##    \n   ##    \n ######  \n         \n',
    'M': u'         \n         \n         \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'Q': u'         \n         \n         \n  #####  \n ##  ##  \n  #####  \n     ##  \n     ##  \n',
    'U': u'         \n         \n         \n ##  ##  \n ##  ##  \n ######  \n  ####   \n         \n',
    'Y': u'         \n         \n         \n ##  ##  \n ##  ##  \n  #####  \n    ###  \n #####   \n',
    ']': u'         \n ####    \n   ##    \n   ##    \n   ##    \n   ##    \n ####    \n         \n',
    'a': u'         \n #####   \n #####   \n ## ##   \n #####   \n ## ##   \n### ###  \n         \n',
    'e': u'         \n#######  \n ###     \n #####   \n ###     \n ###     \n#######  \n         \n',
    'i': u'         \n#######  \n  ###    \n  ###    \n  ###    \n  ###    \n#######  \n         \n',
    'm': u'         \n ##  ##  \n ######  \n ######  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'q': u'         \n  ####   \n ######  \n ##  ##  \n ##  ##  \n #####   \n  #####  \n         \n',
    'u': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n  ####   \n         \n',
    'y': u'         \n ##  ##  \n ##  ##  \n ######  \n  ####   \n   ##    \n  ####   \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

charact6_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'   ##    \n  #####  \n ##      \n  ####   \n     ##  \n #####   \n   ##    \n         \n',
    '(': u'         \n   ##    \n  ##     \n  ##     \n  ##     \n  ##     \n   ##    \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'         \n  ####   \n ##  ##  \n ## ###  \n ### ##  \n ##  ##  \n  ####   \n         \n',
    '4': u'         \n   ####  \n  ## ##  \n ##  ##  \n ####### \n     ##  \n     ##  \n         \n',
    '8': u'         \n  ####   \n ##  ##  \n  ####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '<': u'         \n   ####  \n  ###    \n ##      \n ##      \n  ###    \n   ####  \n         \n',
    '@': u'         \n  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n  #####  \n         \n',
    'D': u'         \n     ##  \n     ##  \n  #####  \n ##  ##  \n ##  ##  \n  #####  \n         \n',
    'H': u'         \n ##      \n ##      \n #####   \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'L': u'         \n  ###    \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'P': u'         \n         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ##      \n ##      \n',
    'T': u'         \n   ##    \n ######  \n   ##    \n   ##    \n   ##    \n    ###  \n         \n',
    'X': u'         \n         \n ##  ##  \n  ####   \n   ##    \n  ####   \n ##  ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n ####    \n ## ##   \n ##  ##  \n ##  ##  \n ## ##   \n ####    \n         \n',
    'h': u'         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'l': u'         \n ##      \n ##      \n ##      \n ##      \n ##      \n ######  \n         \n',
    'p': u'         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ##      \n ##      \n         \n',
    't': u'         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    'x': u'         \n ##  ##  \n  ####   \n   ##    \n  ####   \n ##  ##  \n ##  ##  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    "'": u'         \n    ##   \n   ##    \n  ##     \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n     ##  \n    ###  \n   ###   \n  ###    \n ###     \n ##      \n         \n',
    '3': u'         \n ######  \n     ##  \n   ###   \n     ##  \n ##  ##  \n  ####   \n         \n',
    '7': u'         \n ######  \n ##  ##  \n    ##   \n   ##    \n   ##    \n   ##    \n         \n',
    ';': u'         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'         \n  ####   \n ##  ##  \n    ##   \n   ##    \n         \n   ##    \n         \n',
    'C': u'         \n         \n  ####   \n ##      \n ##      \n ##      \n  ####   \n         \n',
    'G': u'         \n         \n  #####  \n ##  ##  \n ##  ##  \n  #####  \n     ##  \n #####   \n',
    'K': u'         \n ##      \n ##      \n ## ##   \n ####    \n ## ##   \n ##  ##  \n         \n',
    'O': u'         \n         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'S': u'         \n         \n  #####  \n ##      \n  ####   \n     ##  \n #####   \n         \n',
    'W': u'         \n         \n ##  ##  \n ##  ##  \n ######  \n ######  \n ##  ##  \n         \n',
    '[': u'         \n  ####   \n  ##     \n  ##     \n  ##     \n  ##     \n  ####   \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u'         \n  ####   \n ##  ##  \n ##      \n ##      \n ##  ##  \n  ####   \n         \n',
    'g': u'         \n  ####   \n ##  ##  \n ##      \n ## ###  \n ##  ##  \n  ####   \n         \n',
    'k': u'         \n ##  ##  \n ## ##   \n ####    \n ####    \n ## ##   \n ##  ##  \n         \n',
    'o': u'         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    's': u'         \n  #####  \n ###     \n  ###    \n   ###   \n    ###  \n #####   \n         \n',
    'w': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n ######  \n ##  ##  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n',
    '&': u'         \n  ####   \n ##  ##  \n  ####   \n ## ###  \n ## ##   \n  #####  \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n ######  \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'         \n  ####   \n ##  ##  \n     ##  \n  ####   \n ##      \n ######  \n         \n',
    '6': u'         \n  ####   \n ##      \n #####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    ':': u'         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '>': u'         \n ####    \n   ###   \n     ##  \n     ##  \n   ###   \n ####    \n         \n',
    'B': u'         \n ##      \n ##      \n #####   \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'F': u'         \n    ###  \n   ##    \n  #####  \n   ##    \n   ##    \n   ##    \n         \n',
    'J': u'         \n    ##   \n         \n    ##   \n    ##   \n    ##   \n    ##   \n ####    \n',
    'N': u'         \n         \n #####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'R': u'         \n         \n #####   \n ##  ##  \n ##      \n ##      \n ##      \n         \n',
    'V': u'         \n         \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'Z': u'         \n         \n ######  \n    ##   \n   ##    \n  ##     \n ######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ##  ##  \n         \n         \n         \n         \n',
    'b': u'         \n #####   \n ##  ##  \n #####   \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'f': u'         \n ######  \n ##      \n ####    \n ##      \n ##      \n ##      \n         \n',
    'j': u'         \n   ####  \n    ##   \n    ##   \n    ##   \n ## ##   \n  ###    \n         \n',
    'n': u'         \n ##  ##  \n ### ##  \n ######  \n ## ###  \n ##  ##  \n ##  ##  \n         \n',
    'r': u'         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ## ##   \n ##  ##  \n         \n',
    'v': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'z': u'         \n ######  \n    ###  \n   ##    \n  ##     \n ###     \n ######  \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n         \n',
    '%': u'         \n ##  ##  \n #  ##   \n   ##    \n  ##  #  \n ##  ##  \n         \n         \n',
    ')': u'         \n   ##    \n    ##   \n    ##   \n    ##   \n    ##   \n   ##    \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'         \n   ##    \n  ###    \n ####    \n   ##    \n   ##    \n ######  \n         \n',
    '5': u'         \n ######  \n ##      \n #####   \n     ##  \n ##  ##  \n  ####   \n         \n',
    '9': u'         \n  ####   \n ##  ##  \n ##  ##  \n  #####  \n     ##  \n  ####   \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'         \n         \n  ####   \n     ##  \n  #####  \n ##  ##  \n  #####  \n         \n',
    'E': u'         \n         \n  ####   \n ##  ##  \n ######  \n ##      \n  ####   \n         \n',
    'I': u'         \n   ##    \n         \n  ###    \n   ##    \n   ##    \n  ####   \n         \n',
    'M': u'         \n         \n ##  ##  \n ######  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'Q': u'         \n         \n  #####  \n ##  ##  \n ##  ##  \n  #####  \n     ##  \n     ##  \n',
    'U': u'         \n         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  #####  \n         \n',
    'Y': u'         \n         \n ##  ##  \n ##  ##  \n ##  ##  \n  #####  \n    ##   \n ####    \n',
    ']': u'         \n  ####   \n    ##   \n    ##   \n    ##   \n    ##   \n  ####   \n         \n',
    'a': u'         \n   ##    \n  ####   \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'e': u'         \n ######  \n ##      \n ####    \n ##      \n ##      \n ######  \n         \n',
    'i': u'         \n  ####   \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'm': u'         \n ##  ##  \n ######  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'q': u'         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n    ###  \n         \n',
    'u': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'y': u'         \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n   ##    \n   ##    \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

characte_dic = {
    ' ': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '$': u'         \n   ##    \n ######  \n # ##    \n ######  \n   ## #  \n ######  \n   ##    \n',
    '(': u'         \n    ##   \n   ##    \n   ##    \n   ##    \n   ##    \n    ##   \n         \n',
    ',': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '0': u'         \n  #####  \n ##  ##  \n ## ###  \n ### ##  \n ##  ##  \n #####   \n         \n',
    '4': u'         \n    ###  \n  #####  \n ##  ##  \n ####### \n     ##  \n     ##  \n         \n',
    '8': u'         \n ######  \n ##  ##  \n  ####   \n ##  ##  \n ##  ##  \n ######  \n         \n',
    '<': u'         \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n         \n         \n',
    '@': u'         \n ######  \n ##   #  \n ## ###  \n ## ###  \n ##      \n ######  \n         \n',
    'D': u'         \n     ##  \n     ##  \n ######  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'H': u'         \n ##      \n ##      \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'L': u'         \n  ###    \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'P': u'         \n         \n         \n ######  \n ##  ##  \n ######  \n ##      \n ##      \n',
    'T': u'         \n   ##    \n ######  \n   ##    \n   ##    \n   ##    \n   ####  \n         \n',
    'X': u'         \n         \n         \n ##  ##  \n  ####   \n  ####   \n ##  ##  \n         \n',
    '\\': u'    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '`': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    'd': u'         \n #####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'h': u'         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'l': u'         \n ##      \n ##      \n ##      \n ##      \n ##      \n ######  \n         \n',
    'p': u'         \n ######  \n ##  ##  \n ##  ##  \n ######  \n ##      \n ##      \n         \n',
    't': u'         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    'x': u'         \n ##  ##  \n ######  \n   ##    \n ######  \n ##  ##  \n ##  ##  \n         \n',
    '|': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': u'         \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    "'": u'         \n    ##   \n   ##    \n         \n         \n         \n         \n         \n',
    '+': u'         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '/': u'         \n      #  \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    '3': u'         \n ######  \n     ##  \n   ###   \n     ##  \n ##  ##  \n ######  \n         \n',
    '7': u'         \n ######  \n     ##  \n    ##   \n   ##    \n   ##    \n   ##    \n         \n',
    ';': u'         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '?': u'         \n ######  \n ##  ##  \n    ##   \n   ##    \n         \n   ##    \n         \n',
    'C': u'         \n         \n         \n ######  \n ##      \n ##      \n ######  \n         \n',
    'G': u'         \n         \n         \n ######  \n ##  ##  \n ######  \n     ##  \n ######  \n',
    'K': u'         \n ##      \n ##      \n ## ###  \n ####    \n ## ##   \n ##  ##  \n         \n',
    'O': u'         \n         \n         \n ######  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'S': u'         \n         \n         \n ######  \n ###     \n   ####  \n ######  \n         \n',
    'W': u'         \n         \n         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n         \n',
    '[': u'         \n   ####  \n   ##    \n   ##    \n   ##    \n   ##    \n   ####  \n         \n',
    '_': u'         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'c': u'         \n ######  \n ##  ##  \n ##      \n ##      \n ##  ##  \n ######  \n         \n',
    'g': u'         \n ######  \n ##      \n ##      \n ## ###  \n ##  ##  \n ######  \n         \n',
    'k': u'         \n ##  ##  \n ## ##   \n ####    \n ####    \n ## ##   \n ##  ##  \n         \n',
    'o': u'         \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    's': u'         \n ######  \n ##  ##  \n ###     \n ######  \n     ##  \n ######  \n         \n',
    'w': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n ######  \n ##  ##  \n         \n',
    '{': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': u'         \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n         \n',
    '&': u'         \n ######  \n ##  ##  \n  ####   \n ## #### \n ##  ##  \n ####### \n         \n',
    '*': u'         \n ##  ##  \n  ####   \n ######  \n  ####   \n ##  ##  \n         \n         \n',
    '.': u'         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '2': u'         \n ######  \n ##  ##  \n     ##  \n  ####   \n ##      \n ######  \n         \n',
    '6': u'         \n ######  \n ##      \n ######  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    ':': u'         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '>': u'         \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n         \n         \n',
    'B': u'         \n ##      \n ##      \n ######  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'F': u'         \n   ####  \n   ##    \n ######  \n   ##    \n   ##    \n  ####   \n         \n',
    'J': u'         \n    ##   \n         \n   ###   \n    ##   \n    ##   \n    ##   \n #####   \n',
    'N': u'         \n         \n         \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'R': u'         \n         \n         \n ######  \n ##  ##  \n ##      \n ##      \n         \n',
    'V': u'         \n         \n         \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'Z': u'         \n         \n         \n ######  \n   ###   \n  ###    \n ######  \n         \n',
    '^': u'         \n   ##    \n  ####   \n ##  ##  \n         \n         \n         \n         \n',
    'b': u'         \n ######  \n ##  ##  \n #####   \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'f': u'         \n ######  \n ##      \n ####    \n ##      \n ##      \n ##      \n         \n',
    'j': u'         \n     ##  \n     ##  \n     ##  \n     ##  \n ##  ##  \n ######  \n         \n',
    'n': u'         \n ##  ##  \n ### ##  \n ######  \n ## ###  \n ##  ##  \n ##  ##  \n         \n',
    'r': u'         \n ######  \n ##  ##  \n ##  ##  \n ######  \n ## ##   \n ##  ##  \n         \n',
    'v': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'z': u'         \n ######  \n    ##   \n   ##    \n  ##     \n ##      \n ######  \n         \n',
    '~': u'         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': u'         \n   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n         \n',
    '%': u'         \n ##   #  \n ##  ##  \n   ###   \n   ##    \n  ## ##  \n ##  ##  \n         \n',
    ')': u'         \n  ##     \n   ##    \n   ##    \n   ##    \n   ##    \n  ##     \n         \n',
    '-': u'         \n         \n         \n ######  \n         \n         \n         \n         \n',
    '1': u'         \n   ##    \n  ###    \n ####    \n   ##    \n   ##    \n ######  \n         \n',
    '5': u'         \n ######  \n ##      \n ######  \n     ##  \n ##  ##  \n ######  \n         \n',
    '9': u'         \n ######  \n ##  ##  \n ##  ##  \n ######  \n     ##  \n ######  \n         \n',
    '=': u'         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'A': u'         \n         \n         \n  #####  \n     ##  \n ######  \n ######  \n         \n',
    'E': u'         \n         \n         \n ######  \n ######  \n ##      \n ######  \n         \n',
    'I': u'         \n   ##    \n         \n  ###    \n   ##    \n   ##    \n ######  \n         \n',
    'M': u'         \n         \n         \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'Q': u'         \n         \n         \n ######  \n ##  ##  \n ######  \n     ##  \n     ##  \n',
    'U': u'         \n         \n         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'Y': u'         \n         \n         \n ##  ##  \n ##  ##  \n ######  \n    ##   \n #####   \n',
    ']': u'         \n ####    \n   ##    \n   ##    \n   ##    \n   ##    \n ####    \n         \n',
    'a': u'         \n ######  \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'e': u'         \n ######  \n ##      \n ####    \n ##      \n ##      \n ######  \n         \n',
    'i': u'         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    'm': u'         \n ##  ##  \n ######  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'q': u'         \n ######  \n ##  ##  \n ##  ##  \n ## ###  \n #####   \n    ###  \n         \n',
    'u': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    'y': u'         \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n   ##    \n  ####   \n         \n',
    '}': u'         \n         \n         \n         \n         \n         \n         \n         \n'}

chartr_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'     \n     \n ### \n## # \n##   \n ### \n## # \n###  \n #   \n     \n',
    '(': u'   \n   \n # \n#  \n#  \n#  \n#  \n#  \n # \n   \n',
    ',': u'  \n  \n  \n  \n  \n  \n  \n# \n# \n  \n',
    '0': u'     \n     \n ##  \n#  # \n#  # \n#  # \n#  # \n ##  \n     \n     \n',
    '4': u'      \n      \n  ##  \n # #  \n#  #  \n##### \n   #  \n   #  \n      \n      \n',
    '8': u'     \n     \n ##  \n#  # \n ##  \n# ## \n#  # \n ##  \n     \n     \n',
    '<': u'      \n      \n      \n      \n   ## \n ##   \n###   \n   ## \n      \n      \n',
    '@': u'        \n        \n   ##   \n ##  #  \n # ## # \n# # # # \n# ####  \n #   #  \n  ###   \n        \n',
    'D': u'      \n      \n###   \n#  #  \n#   # \n#   # \n#  #  \n###   \n      \n      \n',
    'H': u'      \n      \n#   # \n#   # \n##### \n#   # \n#   # \n#   # \n      \n      \n',
    'L': u'    \n    \n#   \n#   \n#   \n#   \n# # \n### \n    \n    \n',
    'P': u'     \n     \n###  \n#  # \n#  # \n###  \n#    \n#    \n     \n     \n',
    'T': u'      \n      \n##### \n# # # \n  #   \n  #   \n  #   \n ###  \n      \n      \n',
    'X': u'      \n      \n## ## \n # #  \n  #   \n  #   \n # #  \n## ## \n      \n      \n',
    '\\': u'     \n     \n#    \n #   \n #   \n  #  \n  #  \n   # \n   # \n     \n',
    '`': u'  \n  \n# \n# \n  \n  \n  \n  \n  \n  \n',
    'd': u'     \n     \n  ## \n   # \n ### \n#  # \n#  # \n ### \n     \n     \n',
    'h': u'     \n     \n#    \n#    \n###  \n#  # \n#  # \n# ## \n     \n     \n',
    'l': u'  \n  \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'p': u'     \n     \n     \n     \n###  \n#  # \n#  # \n###  \n#    \n##   \n',
    't': u'   \n   \n   \n#  \n## \n#  \n#  \n## \n   \n   \n',
    'x': u'     \n     \n     \n     \n#### \n ##  \n ##  \n#### \n     \n     \n',
    '|': u'  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'      \n      \n  # # \n  ##  \n##### \n # #  \n##### \n ##   \n# #   \n      \n',
    "'": u'  \n  \n# \n# \n  \n  \n  \n  \n  \n  \n',
    '+': u'      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n',
    '/': u'     \n     \n   # \n   # \n  #  \n  #  \n #   \n #   \n#    \n     \n',
    '3': u'     \n     \n ##  \n#  # \n  ## \n ##  \n   # \n###  \n     \n     \n',
    '7': u'     \n     \n#### \n#  # \n  #  \n  #  \n #   \n##   \n     \n     \n',
    ';': u'  \n  \n  \n  \n# \n  \n  \n# \n# \n  \n',
    '?': u'    \n    \n #  \n# # \n  # \n #  \n    \n #  \n    \n    \n',
    'C': u'     \n     \n  ## \n # # \n#    \n#    \n # # \n  ## \n     \n     \n',
    'G': u'      \n      \n  ### \n #  # \n#     \n#  ## \n##  # \n  ### \n      \n      \n',
    'K': u'     \n     \n# ## \n# #  \n##   \n##   \n# #  \n#  # \n     \n     \n',
    'O': u'      \n      \n  #   \n # #  \n#   # \n#   # \n # #  \n  #   \n      \n      \n',
    'S': u'     \n     \n ### \n#  # \n##   \n  ## \n#  # \n###  \n     \n     \n',
    'W': u'         \n         \n##  # ## \n #  #  # \n # ## #  \n # ## #  \n  ## ##  \n  #  #   \n         \n         \n',
    '[': u'   \n   \n## \n#  \n#  \n#  \n#  \n#  \n## \n   \n',
    '_': u'     \n     \n     \n     \n     \n     \n     \n     \n     \n#### \n',
    'c': u'    \n    \n    \n    \n #  \n# # \n#   \n ## \n    \n    \n',
    'g': u'    \n    \n    \n    \n #  \n# # \n #  \n #  \n### \n #  \n',
    'k': u'    \n    \n#   \n#   \n# # \n##  \n##  \n# # \n    \n    \n',
    'o': u'    \n    \n    \n    \n #  \n# # \n# # \n #  \n    \n    \n',
    's': u'   \n   \n   \n   \n # \n#  \n## \n#  \n   \n   \n',
    'w': u'       \n       \n       \n       \n#  # # \n# ## # \n ### # \n #  #  \n       \n       \n',
    '{': u'    \n    \n  # \n #  \n #  \n#   \n #  \n #  \n  # \n    \n',
    '"': u'    \n    \n# # \n# # \n    \n    \n    \n    \n    \n    \n',
    '&': u'      \n      \n ##   \n#  #  \n ###  \n ## # \n#  ## \n ## # \n      \n      \n',
    '*': u'    \n    \n #  \n# # \n# # \n    \n    \n    \n    \n    \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'     \n     \n ##  \n#  # \n   # \n  #  \n # # \n#### \n     \n     \n',
    '6': u'     \n     \n  #  \n #   \n###  \n#  # \n#  # \n ##  \n     \n     \n',
    ':': u'  \n  \n  \n  \n# \n  \n  \n# \n  \n  \n',
    '>': u'      \n      \n      \n      \n##    \n  ##  \n  ### \n##    \n      \n      \n',
    'B': u'     \n     \n###  \n# ## \n###  \n#  # \n#  # \n###  \n     \n     \n',
    'F': u'     \n     \n#### \n#    \n###  \n# #  \n#    \n#    \n     \n     \n',
    'J': u'     \n     \n  ## \n   # \n   # \n   # \n#  # \n###  \n     \n     \n',
    'N': u'      \n      \n#  ## \n##  # \n# # # \n# # # \n#  ## \n##  # \n      \n      \n',
    'R': u'     \n     \n##   \n# #  \n# #  \n##   \n# #  \n#  # \n     \n     \n',
    'V': u'      \n      \n##  # \n#   # \n # #  \n # #  \n  ##  \n  #   \n      \n      \n',
    'Z': u'     \n     \n#### \n#  # \n  #  \n #   \n#  # \n#### \n     \n     \n',
    '^': u'      \n      \n ###  \n#   # \n      \n      \n      \n      \n      \n      \n',
    'b': u'     \n     \n#    \n#    \n###  \n#  # \n#  # \n###  \n     \n     \n',
    'f': u'   \n   \n # \n#  \n## \n#  \n#  \n#  \n   \n   \n',
    'j': u'    \n    \n  # \n    \n  # \n  # \n  # \n  # \n  # \n##  \n',
    'n': u'     \n     \n     \n     \n#### \n#  # \n#  # \n# ## \n     \n     \n',
    'r': u'   \n   \n   \n   \n## \n#  \n#  \n#  \n   \n   \n',
    'v': u'     \n     \n     \n     \n# ## \n#  # \n ##  \n #   \n     \n     \n',
    'z': u'    \n    \n    \n    \n### \n #  \n# # \n### \n    \n    \n',
    '~': u'       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n',
    '!': u'  \n  \n# \n# \n# \n# \n  \n# \n  \n  \n',
    '%': u'        \n        \n #   #  \n# # #   \n# ## #  \n # ## # \n  # # # \n #   #  \n        \n        \n',
    ')': u'   \n   \n#  \n # \n # \n # \n # \n # \n#  \n   \n',
    '-': u'   \n   \n   \n   \n   \n   \n## \n   \n   \n   \n',
    '1': u'  \n  \n# \n# \n# \n# \n# \n# \n  \n  \n',
    '5': u'      \n      \n #### \n #    \n ###  \n    # \n##  # \n ###  \n      \n      \n',
    '9': u'     \n     \n ##  \n#  # \n#  # \n ### \n  #  \n #   \n     \n     \n',
    '=': u'      \n      \n      \n      \n##### \n      \n##### \n      \n      \n      \n',
    'A': u'      \n      \n  #   \n # #  \n # #  \n ###  \n#   # \n#  ## \n      \n      \n',
    'E': u'     \n     \n#### \n#    \n#### \n#  # \n#    \n#### \n     \n     \n',
    'I': u'  \n  \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'M': u'       \n       \n##   # \n##  ## \n##  ## \n# ## # \n# ## # \n### ## \n       \n       \n',
    'Q': u'      \n      \n  #   \n # #  \n#   # \n#   # \n # #  \n  #   \n  ### \n      \n',
    'U': u'      \n      \n#   # \n#   # \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    'Y': u'      \n      \n## ## \n #  # \n # #  \n  #   \n  #   \n ###  \n      \n      \n',
    ']': u'   \n   \n## \n # \n # \n # \n # \n # \n## \n   \n',
    'a': u'    \n    \n    \n    \n #  \n ## \n# # \n ## \n    \n    \n',
    'e': u'    \n    \n    \n    \n #  \n### \n#   \n ## \n    \n    \n',
    'i': u'  \n  \n# \n  \n# \n# \n# \n# \n  \n  \n',
    'm': u'      \n      \n      \n      \n##### \n# # # \n# # # \n# # # \n      \n      \n',
    'q': u'     \n     \n     \n     \n ### \n#  # \n#  # \n ### \n   # \n  ## \n',
    'u': u'     \n     \n     \n     \n# ## \n#  # \n#  # \n ### \n     \n     \n',
    'y': u'     \n     \n     \n     \n## # \n # # \n ##  \n #   \n #   \n#    \n',
    '}': u'    \n    \n#   \n #  \n #  \n  # \n #  \n #  \n#   \n    \n'}

chartri_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'     \n     \n  ## \n ### \n ##  \n  ## \n## # \n ##  \n #   \n     \n',
    '(': u'    \n    \n  # \n #  \n #  \n#   \n#   \n#   \n #  \n    \n',
    ',': u'  \n  \n  \n  \n  \n  \n  \n# \n# \n  \n',
    '0': u'      \n      \n  ##  \n #  # \n#   # \n#   # \n#  #  \n ##   \n      \n      \n',
    '4': u'      \n      \n   #  \n  ##  \n # #  \n##### \n   #  \n  #   \n      \n      \n',
    '8': u'      \n      \n  ##  \n #  # \n ###  \n## ## \n#  #  \n ##   \n      \n      \n',
    '<': u'      \n      \n      \n      \n   ## \n ##   \n###   \n   ## \n      \n      \n',
    '@': u'        \n        \n   ##   \n ##  #  \n # ## # \n# # # # \n# ####  \n #   #  \n  ###   \n        \n',
    'D': u'       \n       \n ###   \n  # ## \n #   # \n #   # \n # ##  \n###    \n       \n       \n',
    'H': u'       \n       \n ## ## \n #  #  \n ####  \n #  #  \n #  #  \n## ##  \n       \n       \n',
    'L': u'     \n     \n ##  \n #   \n #   \n #   \n # # \n#### \n     \n     \n',
    'P': u'      \n      \n ###  \n #  # \n # ## \n ##   \n #    \n##    \n      \n      \n',
    'T': u'      \n      \n##### \n# # # \n  #   \n #    \n #    \n ##   \n      \n      \n',
    'X': u'       \n       \n ## ## \n  # #  \n  ##   \n  ##   \n # #   \n## ##  \n       \n       \n',
    '\\': u'     \n     \n#    \n #   \n #   \n  #  \n  #  \n   # \n   # \n     \n',
    '`': u'  \n  \n# \n# \n  \n  \n  \n  \n  \n  \n',
    'd': u'     \n     \n   # \n   # \n  ## \n # # \n# #  \n # # \n     \n     \n',
    'h': u'      \n      \n #    \n #    \n ###  \n # #  \n#  #  \n#  ## \n      \n      \n',
    'l': u'  \n  \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'p': u'      \n      \n      \n      \n #### \n  # # \n # ## \n ##   \n #    \n##    \n',
    't': u'    \n    \n    \n #  \n### \n#   \n#   \n##  \n    \n    \n',
    'x': u'     \n     \n     \n     \n # # \n ##  \n ##  \n# ## \n     \n     \n',
    '|': u'  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'      \n      \n  # # \n  ##  \n##### \n # #  \n##### \n ##   \n# #   \n      \n',
    "'": u'  \n  \n# \n# \n  \n  \n  \n  \n  \n  \n',
    '+': u'      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n',
    '/': u'      \n      \n    # \n   #  \n   #  \n  #   \n #    \n #    \n#     \n      \n',
    '3': u'      \n      \n  ##  \n #  # \n   ## \n  ##  \n    # \n####  \n      \n      \n',
    '7': u'      \n      \n #### \n #  # \n   #  \n  #   \n #    \n##    \n      \n      \n',
    ';': u'    \n    \n    \n    \n ## \n    \n    \n #  \n##  \n    \n',
    '?': u'     \n     \n ##  \n#  # \n  ## \n #   \n     \n#    \n     \n     \n',
    'C': u'      \n      \n  ### \n #  # \n#     \n#     \n#  #  \n ###  \n      \n      \n',
    'G': u'       \n       \n   ### \n ##  # \n#      \n#   ## \n#   #  \n ###   \n       \n       \n',
    'K': u'       \n       \n ## ## \n #  #  \n # #   \n ###   \n # #   \n##  #  \n       \n       \n',
    'O': u'       \n       \n  ###  \n #   # \n#    # \n#    # \n#   #  \n ###   \n       \n       \n',
    'S': u'     \n     \n  ## \n # # \n ##  \n   # \n#  # \n ##  \n     \n     \n',
    'W': u'         \n         \n##  # ## \n#  ## #  \n # ## #  \n ## ##   \n ## ##   \n #  #    \n         \n         \n',
    '[': u'     \n     \n  ## \n #   \n #   \n #   \n#    \n#    \n##   \n     \n',
    '_': u'     \n     \n     \n     \n     \n     \n     \n     \n     \n#### \n',
    'c': u'    \n    \n    \n    \n ## \n#   \n# # \n #  \n    \n    \n',
    'g': u'      \n      \n      \n      \n  # # \n # #  \n  #   \n####  \n#  #  \n ##   \n',
    'k': u'     \n     \n #   \n #   \n # # \n ##  \n# #  \n#  # \n     \n     \n',
    'o': u'     \n     \n     \n     \n ##  \n#  # \n#  # \n ##  \n     \n     \n',
    's': u'    \n    \n    \n    \n ## \n #  \n  # \n##  \n    \n    \n',
    'w': u'       \n       \n       \n       \n#  # # \n # # # \n ####  \n # #   \n       \n       \n',
    '{': u'    \n    \n  # \n #  \n #  \n#   \n #  \n #  \n  # \n    \n',
    '"': u'    \n    \n# # \n# # \n    \n    \n    \n    \n    \n    \n',
    '&': u'      \n      \n  ##  \n # #  \n # #  \n ## # \n#  #  \n ## # \n      \n      \n',
    '*': u'    \n    \n #  \n# # \n##  \n    \n    \n    \n    \n    \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'      \n      \n  ##  \n #  # \n    # \n  ##  \n #  # \n####  \n      \n      \n',
    '6': u'     \n     \n  ## \n #   \n###  \n#  # \n#  # \n ##  \n     \n     \n',
    ':': u'   \n   \n   \n   \n # \n   \n   \n#  \n   \n   \n',
    '>': u'      \n      \n      \n      \n##    \n  ##  \n  ### \n##    \n      \n      \n',
    'B': u'      \n      \n ###  \n # ## \n ###  \n #  # \n # ## \n###   \n      \n      \n',
    'F': u'      \n      \n #### \n #    \n ###  \n # #  \n #    \n##    \n      \n      \n',
    'J': u'     \n     \n  ## \n   # \n  #  \n  #  \n# #  \n##   \n     \n     \n',
    'N': u'       \n       \n #  ## \n ##  # \n ## #  \n # ##  \n#  ##  \n##  #  \n       \n       \n',
    'R': u'      \n      \n ###  \n #  # \n # ## \n ##   \n # #  \n##  # \n      \n      \n',
    'V': u'      \n      \n## ## \n#   # \n # #  \n ##   \n ##   \n #    \n      \n      \n',
    'Z': u'      \n      \n #### \n # #  \n  #   \n  #   \n # #  \n####  \n      \n      \n',
    '^': u'      \n      \n ###  \n#   # \n      \n      \n      \n      \n      \n      \n',
    'b': u'     \n     \n##   \n #   \n ##  \n## # \n# ## \n #   \n     \n     \n',
    'f': u'      \n      \n   ## \n  #   \n  ##  \n  #   \n  #   \n  #   \n #    \n##    \n',
    'j': u'    \n    \n  # \n    \n ## \n  # \n  # \n #  \n #  \n#   \n',
    'n': u'      \n      \n      \n      \n####  \n # #  \n#  #  \n#  ## \n      \n      \n',
    'r': u'    \n    \n    \n    \n# # \n##  \n#   \n#   \n    \n    \n',
    'v': u'     \n     \n     \n     \n#  # \n # # \n ##  \n #   \n     \n     \n',
    'z': u'     \n     \n     \n     \n ### \n# #  \n # # \n###  \n     \n     \n',
    '~': u'       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n',
    '!': u'   \n   \n # \n # \n # \n#  \n   \n#  \n   \n   \n',
    '%': u'        \n        \n #   #  \n# # #   \n# ## #  \n # ## # \n  # # # \n #   #  \n        \n        \n',
    ')': u'    \n    \n #  \n  # \n  # \n  # \n  # \n #  \n#   \n    \n',
    '-': u'   \n   \n   \n   \n   \n   \n## \n   \n   \n   \n',
    '1': u'   \n   \n # \n## \n # \n # \n # \n## \n   \n   \n',
    '5': u'      \n      \n #### \n #    \n ##   \n   #  \n# ##  \n##    \n      \n      \n',
    '9': u'     \n     \n ##  \n#  # \n#  # \n ##  \n  #  \n##   \n     \n     \n',
    '=': u'      \n      \n      \n      \n##### \n      \n##### \n      \n      \n      \n',
    'A': u'       \n       \n   ##  \n   ##  \n  # #  \n ####  \n #  #  \n##  ## \n       \n       \n',
    'E': u'      \n      \n #### \n #    \n ###  \n # #  \n #  # \n####  \n      \n      \n',
    'I': u'    \n    \n ## \n #  \n #  \n #  \n #  \n##  \n    \n    \n',
    'M': u'        \n        \n #   ## \n ##  #  \n ## ##  \n ## ##  \n# ## #  \n### ##  \n        \n        \n',
    'Q': u'       \n       \n  ###  \n #   # \n#    # \n#    # \n##  #  \n  ##   \n   ### \n       \n',
    'U': u'      \n      \n## ## \n #  # \n#  #  \n#  #  \n#  #  \n ##   \n      \n      \n',
    'Y': u'      \n      \n## ## \n # #  \n ##   \n #    \n #    \n ##   \n      \n      \n',
    ']': u'    \n    \n ## \n  # \n  # \n  # \n #  \n #  \n##  \n    \n',
    'a': u'     \n     \n     \n     \n  ## \n # # \n# #  \n # # \n     \n     \n',
    'e': u'     \n     \n     \n     \n  #  \n ### \n##   \n ### \n     \n     \n',
    'i': u'  \n  \n# \n  \n# \n# \n# \n# \n  \n  \n',
    'm': u'        \n        \n        \n        \n######  \n## # #  \n#  # #  \n# #  ## \n        \n        \n',
    'q': u'     \n     \n     \n     \n  ## \n## # \n# ## \n ##  \n  #  \n  ## \n',
    'u': u'     \n     \n     \n     \n#  # \n#  # \n# #  \n## # \n     \n     \n',
    'y': u'      \n      \n      \n      \n #  # \n  ##  \n  ##  \n  #   \n  #   \n##    \n',
    '}': u'    \n    \n#   \n #  \n #  \n  # \n #  \n #  \n#   \n    \n'}


xbrite_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'    \n    \n ## \n### \n##  \n##  \n ## \n ## \n### \n##  \n #  \n    \n',
    '(': u'   \n   \n # \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n # \n',
    ',': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n# \n# \n',
    '0': u'      \n      \n ###  \n#   # \n#   # \n#   # \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    '4': u'      \n      \n   #  \n  ##  \n # #  \n#  #  \n##### \n   #  \n   #  \n  ### \n      \n      \n',
    '8': u'      \n      \n ###  \n#   # \n#  ## \n ##   \n#  #  \n#   # \n#   # \n ###  \n      \n      \n',
    '<': u'       \n       \n       \n     # \n   ##  \n ##    \n##     \n ##    \n   ##  \n     # \n       \n       \n',
    '@': u'         \n         \n   ####  \n ##   ## \n # ### # \n# # #  # \n# # ## # \n# ## ##  \n##       \n ####    \n         \n         \n',
    'D': u'        \n        \n#####   \n #   #  \n #    # \n #    # \n #    # \n #    # \n #   #  \n#####   \n        \n        \n',
    'H': u'        \n        \n### ### \n #   #  \n #   #  \n #####  \n #   #  \n #   #  \n #   #  \n### ### \n        \n        \n',
    'L': u'      \n      \n###   \n #    \n #    \n #    \n #    \n #    \n #  # \n##### \n      \n      \n',
    'P': u'      \n      \n####  \n #  # \n #  # \n #  # \n ###  \n #    \n #    \n###   \n      \n      \n',
    'T': u'        \n        \n####### \n   #    \n   #    \n   #    \n   #    \n   #    \n   #    \n  ###   \n        \n        \n',
    'X': u'        \n        \n###  ## \n #   #  \n  # #   \n   ##   \n  ###   \n ## #   \n #   #  \n##  ### \n        \n        \n',
    '\\': u'      \n      \n#     \n##    \n #    \n #    \n  #   \n  #   \n   #  \n   #  \n   ## \n    # \n',
    '`': u'  \n  \n# \n# \n# \n  \n  \n  \n  \n  \n  \n  \n',
    'd': u'       \n       \n   ##  \n    #  \n    #  \n ####  \n#   #  \n#   #  \n#   #  \n ##### \n       \n       \n',
    'h': u'       \n       \n##     \n #     \n #     \n ####  \n #  #  \n #  #  \n #  #  \n###### \n       \n       \n',
    'l': u'    \n    \n##  \n #  \n #  \n #  \n #  \n #  \n #  \n### \n    \n    \n',
    'p': u'       \n       \n       \n       \n       \n#####  \n #   # \n #   # \n #   # \n ####  \n #     \n###    \n',
    't': u'    \n    \n #  \n #  \n #  \n### \n #  \n #  \n #  \n ## \n    \n    \n',
    'x': u'       \n       \n       \n       \n       \n### ## \n ## #  \n  ##   \n # ##  \n## ### \n       \n       \n',
    '|': u'  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'       \n       \n  # #  \n  # #  \n###### \n  # #  \n # #   \n###### \n # #   \n # #   \n       \n       \n',
    "'": u'  \n  \n# \n# \n# \n  \n  \n  \n  \n  \n  \n  \n',
    '+': u'        \n        \n        \n   #    \n   #    \n   #    \n####### \n   #    \n   #    \n   #    \n        \n        \n',
    '/': u'      \n      \n    # \n   ## \n   #  \n   #  \n  #   \n  #   \n #    \n #    \n##    \n#     \n',
    '3': u'     \n     \n###  \n#  # \n   # \n ##  \n  ## \n   # \n#  # \n###  \n     \n     \n',
    '7': u'      \n      \n##### \n    # \n   #  \n  #   \n ##   \n #    \n##    \n#     \n      \n      \n',
    ';': u'  \n  \n  \n  \n  \n# \n  \n  \n  \n# \n# \n# \n',
    '?': u'    \n    \n### \n# # \n  # \n #  \n #  \n #  \n    \n #  \n    \n    \n',
    'C': u'       \n       \n  #### \n #   # \n#      \n#      \n#      \n#      \n #   # \n  ###  \n       \n       \n',
    'G': u'        \n        \n  ####  \n #   #  \n#       \n#       \n#   ### \n#    #  \n #   #  \n  ####  \n        \n        \n',
    'K': u'        \n        \n### ##  \n #  ##  \n # ##   \n ##     \n ###    \n # ##   \n #  ##  \n### ### \n        \n        \n',
    'O': u'        \n        \n  ###   \n #   #  \n#     # \n#     # \n#     # \n#     # \n #   #  \n  ###   \n        \n        \n',
    'S': u'     \n     \n ### \n#  # \n#    \n #   \n  ## \n   # \n#  # \n###  \n     \n     \n',
    'W': u'          \n          \n### #  ## \n #  #   # \n #  #  #  \n # # # #  \n # # # #  \n  ## ##   \n  #   #   \n  #   #   \n          \n          \n',
    '[': u'   \n   \n## \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n## \n',
    '_': u'     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n#### \n     \n',
    'c': u'     \n     \n     \n     \n     \n ### \n#  # \n#    \n#    \n ### \n     \n     \n',
    'g': u'      \n      \n      \n      \n      \n #### \n#  #  \n#  #  \n ##   \n##### \n#   # \n####  \n',
    'k': u'       \n       \n##     \n #     \n #     \n #  ## \n # ##  \n ##    \n # ##  \n### ## \n       \n       \n',
    'o': u'      \n      \n      \n      \n      \n ###  \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    's': u'     \n     \n     \n     \n     \n#### \n#  # \n ##  \n#  # \n#### \n     \n     \n',
    'w': u'         \n         \n         \n         \n         \n##  # ## \n # ##  # \n # ## #  \n ##  ##  \n  #  #   \n         \n         \n',
    '{': u'    \n    \n  # \n #  \n #  \n #  \n #  \n##  \n #  \n #  \n #  \n ## \n',
    '"': u'   \n   \n## \n## \n## \n   \n   \n   \n   \n   \n   \n   \n',
    '&': u'       \n       \n ###   \n # #   \n # #   \n ##    \n# # ## \n# ###  \n#  #   \n ## ## \n       \n       \n',
    '*': u'     \n     \n #   \n#### \n ##  \n ##  \n     \n     \n     \n     \n     \n     \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'     \n     \n###  \n#  # \n   # \n   # \n  #  \n #   \n#    \n#### \n     \n     \n',
    '6': u'      \n      \n #### \n #  # \n#     \n####  \n#   # \n#   # \n##  # \n ###  \n      \n      \n',
    ':': u'  \n  \n  \n  \n  \n# \n  \n  \n  \n# \n  \n  \n',
    '>': u'       \n       \n       \n#      \n ##    \n   ##  \n    ## \n   ##  \n ##    \n#      \n       \n       \n',
    'B': u'      \n      \n##### \n #  # \n #  # \n ###  \n # ## \n #  # \n #  # \n##### \n      \n      \n',
    'F': u'      \n      \n##### \n #  # \n # #  \n ###  \n # #  \n #    \n #    \n##    \n      \n      \n',
    'J': u'     \n     \n  ## \n  #  \n  #  \n  #  \n  #  \n  #  \n  #  \n  #  \n# #  \n##   \n',
    'N': u'        \n        \n##  ### \n ##  #  \n ##  #  \n # # #  \n # # #  \n #  ##  \n #   #  \n###  #  \n        \n        \n',
    'R': u'       \n       \n####   \n #  #  \n #  #  \n #  #  \n ###   \n # #   \n #  #  \n### ## \n       \n       \n',
    'V': u'        \n        \n###  ## \n #    # \n #   #  \n  #  #  \n  # #   \n  # #   \n   ##   \n   #    \n        \n        \n',
    'Z': u'      \n      \n##### \n#  #  \n   #  \n  #   \n  #   \n #    \n #  # \n##### \n      \n      \n',
    '^': u'       \n       \n   #   \n  ##   \n  ##   \n #  #  \n #  #  \n##   # \n#    # \n       \n       \n       \n',
    'b': u'       \n       \n##     \n #     \n #     \n ####  \n #   # \n #   # \n #   # \n ####  \n       \n       \n',
    'f': u'     \n     \n ### \n # # \n #   \n###  \n #   \n #   \n #   \n###  \n     \n     \n',
    'j': u'    \n    \n  # \n    \n    \n ## \n  # \n  # \n  # \n  # \n# # \n### \n',
    'n': u'       \n       \n       \n       \n       \n#####  \n #  #  \n #  #  \n #  #  \n###### \n       \n       \n',
    'r': u'     \n     \n     \n     \n     \n#### \n # # \n #   \n #   \n###  \n     \n     \n',
    'v': u'      \n      \n      \n      \n      \n##  # \n #  # \n # #  \n  ##  \n  #   \n      \n      \n',
    'z': u'     \n     \n     \n     \n     \n#### \n# #  \n ##  \n # # \n#### \n     \n     \n',
    '~': u'        \n        \n        \n        \n        \n        \n ###  # \n#   ### \n        \n        \n        \n        \n',
    '!': u'  \n  \n# \n# \n# \n# \n# \n# \n  \n# \n  \n  \n',
    '%': u'       \n       \n #   # \n# # #  \n# ###  \n # #   \n  # #  \n ### # \n # # # \n#   #  \n       \n       \n',
    ')': u'   \n   \n#  \n # \n # \n # \n # \n # \n # \n # \n # \n#  \n',
    '-': u'       \n       \n       \n       \n       \n       \n       \n###### \n       \n       \n       \n       \n',
    '1': u'    \n    \n##  \n #  \n #  \n #  \n #  \n #  \n #  \n### \n    \n    \n',
    '5': u'     \n     \n#### \n#    \n#    \n###  \n   # \n   # \n#  # \n###  \n     \n     \n',
    '9': u'      \n      \n ###  \n#  ## \n#   # \n#   # \n #### \n    # \n#  #  \n###   \n      \n      \n',
    '=': u'       \n       \n       \n       \n       \n       \n###### \n       \n###### \n       \n       \n       \n',
    'A': u'        \n        \n   #    \n  ##    \n  ###   \n  # #   \n ####   \n #   #  \n#    #  \n##  ### \n        \n        \n',
    'E': u'      \n      \n##### \n #  # \n # #  \n ###  \n # #  \n #    \n #  # \n##### \n      \n      \n',
    'I': u'    \n    \n### \n #  \n #  \n #  \n #  \n #  \n #  \n### \n    \n    \n',
    'M': u'         \n         \n##    ## \n ##  ##  \n ##  ##  \n # # ##  \n # ## #  \n # ## #  \n #  # #  \n###  ### \n         \n         \n',
    'Q': u'         \n         \n  ###    \n #   #   \n#     #  \n#     #  \n#     #  \n#     #  \n #   ##  \n  ####   \n    ##   \n      ## \n',
    'U': u'        \n        \n### ### \n #   #  \n #   #  \n #   #  \n #   #  \n #   #  \n #   #  \n  ###   \n        \n        \n',
    'Y': u'        \n        \n###  ## \n #   #  \n  #  #  \n  ###   \n   #    \n   #    \n   #    \n  ###   \n        \n        \n',
    ']': u'   \n   \n## \n # \n # \n # \n # \n # \n # \n # \n # \n## \n',
    'a': u'      \n      \n      \n      \n      \n####  \n   #  \n ###  \n#  #  \n### # \n      \n      \n',
    'e': u'     \n     \n     \n     \n     \n ##  \n#  # \n#### \n#    \n ### \n     \n     \n',
    'i': u'    \n    \n #  \n    \n    \n##  \n #  \n #  \n #  \n### \n    \n    \n',
    'm': u'          \n          \n          \n          \n          \n########  \n #  #  #  \n #  #  #  \n #  #  #  \n######### \n          \n          \n',
    'q': u'       \n       \n       \n       \n       \n ####  \n#   #  \n#   #  \n#   #  \n ####  \n    #  \n   ### \n',
    'u': u'       \n       \n       \n       \n       \n## ##  \n #  #  \n #  #  \n #  #  \n ##### \n       \n       \n',
    'y': u'       \n       \n       \n       \n       \n### ## \n #   # \n #  #  \n  ###  \n  ##   \n  #    \n ##    \n',
    '}': u'    \n    \n#   \n #  \n #  \n #  \n #  \n ## \n #  \n #  \n #  \n##  \n'}

xbriteb_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'     \n ### \n# ## \n# #  \n ##  \n  ## \n  ## \n# ## \n#### \n  #  \n     \n',
    '(': u'   \n # \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n # \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n## \n## \n # \n## \n',
    '0': u'       \n ####  \n #  #  \n#    # \n#    # \n#    # \n#    # \n #  #  \n ####  \n       \n       \n',
    '4': u'      \n  ##  \n  ##  \n # #  \n#  #  \n##### \n   #  \n   #  \n  ### \n      \n      \n',
    '8': u'      \n ###  \n#   # \n#   # \n ###  \n#  ## \n#   # \n#   # \n ###  \n      \n      \n',
    '<': u'       \n       \n     # \n   ##  \n  ##   \n##     \n  ##   \n   ##  \n     # \n       \n       \n',
    '@': u'         \n   ####  \n ##   ## \n # ##  # \n# # ## # \n# # ## # \n# ## ##  \n##       \n ####    \n         \n         \n',
    'D': u'         \n######   \n #    #  \n #     # \n #     # \n #     # \n #     # \n #    #  \n######   \n         \n         \n',
    'H': u'         \n###  ### \n #    #  \n #    #  \n ######  \n #    #  \n #    #  \n #    #  \n###  ### \n         \n         \n',
    'L': u'      \n###   \n #    \n #    \n #    \n #    \n #    \n #  # \n##### \n      \n      \n',
    'P': u'       \n#####  \n #   # \n #   # \n #   # \n ####  \n #     \n #     \n###    \n       \n       \n',
    'T': u'        \n####### \n   #    \n   #    \n   #    \n   #    \n   #    \n   #    \n  ###   \n        \n        \n',
    'X': u'        \n###  ## \n ##  #  \n  # ##  \n   ##   \n  ###   \n ## #   \n #   #  \n##  ### \n        \n        \n',
    '\\': u'      \n#     \n##    \n #    \n #    \n  #   \n  #   \n   #  \n   #  \n   ## \n    # \n',
    '`': u'   \n## \n#  \n## \n## \n   \n   \n   \n   \n   \n   \n',
    'd': u'       \n   ##  \n    #  \n    #  \n ####  \n#   #  \n#   #  \n#   #  \n ##### \n       \n       \n',
    'h': u'        \n##      \n #      \n #      \n #####  \n #   #  \n #   #  \n #   #  \n### ### \n        \n        \n',
    'l': u'    \n##  \n #  \n #  \n #  \n #  \n #  \n #  \n### \n    \n    \n',
    'p': u'       \n       \n       \n       \n#####  \n #   # \n #   # \n #   # \n ####  \n #     \n###    \n',
    't': u'    \n #  \n #  \n #  \n### \n #  \n #  \n #  \n ## \n    \n    \n',
    'x': u'       \n       \n       \n       \n### ## \n ## #  \n  ##   \n # ##  \n## ### \n       \n       \n',
    '|': u'  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'       \n  # #  \n  # #  \n###### \n  # #  \n # #   \n###### \n # #   \n # #   \n       \n       \n',
    "'": u'   \n## \n## \n # \n## \n   \n   \n   \n   \n   \n   \n',
    '+': u'        \n        \n   #    \n   #    \n   #    \n####### \n   #    \n   #    \n   #    \n        \n        \n',
    '/': u'      \n    # \n   ## \n   #  \n   #  \n  #   \n  #   \n #    \n #    \n##    \n#     \n',
    '3': u'     \n###  \n#  # \n   # \n ##  \n   # \n   # \n#  # \n###  \n     \n     \n',
    '7': u'      \n##### \n    # \n   #  \n  #   \n ##   \n #    \n##    \n#     \n      \n      \n',
    ';': u'  \n  \n  \n  \n# \n  \n  \n  \n# \n# \n# \n',
    '?': u'     \n###  \n#  # \n   # \n  ## \n #   \n #   \n     \n #   \n     \n     \n',
    'C': u'       \n  #### \n #   # \n#      \n#      \n#      \n#      \n #   # \n  #### \n       \n       \n',
    'G': u'        \n  ####  \n #   #  \n#       \n#       \n#   ### \n#    #  \n #   #  \n  ####  \n        \n        \n',
    'K': u'        \n### ##  \n #  ##  \n # ##   \n ##     \n # #    \n # ##   \n #  ##  \n### ### \n        \n        \n',
    'O': u'        \n  ###   \n #   #  \n#     # \n#     # \n#     # \n#     # \n #   #  \n  ###   \n        \n        \n',
    'S': u'     \n ### \n#  # \n#    \n #   \n  ## \n   # \n#  # \n###  \n     \n     \n',
    'W': u'           \n###  #  ## \n #  ##  #  \n #  ##  #  \n  # ##  #  \n  ### ##   \n  ##  ##   \n  ##  ##   \n   #  #    \n           \n           \n',
    '[': u'   \n## \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n## \n',
    '_': u'     \n     \n     \n     \n     \n     \n     \n     \n     \n#### \n     \n',
    'c': u'      \n      \n      \n      \n #### \n#   # \n#     \n##    \n #### \n      \n      \n',
    'g': u'      \n      \n      \n      \n #### \n#  #  \n#  #  \n ##   \n##### \n#   # \n####  \n',
    'k': u'       \n##     \n #     \n #     \n # ### \n # ##  \n ##    \n # #   \n### ## \n       \n       \n',
    'o': u'       \n       \n       \n       \n ####  \n##  ## \n#    # \n##  ## \n ####  \n       \n       \n',
    's': u'     \n     \n     \n     \n#### \n#  # \n ##  \n#  # \n#### \n     \n     \n',
    'w': u'          \n          \n          \n          \n### #  ## \n #  ## #  \n ### # #  \n  ## ##   \n  #   #   \n          \n          \n',
    '{': u'    \n ## \n #  \n #  \n #  \n##  \n #  \n #  \n #  \n #  \n ## \n',
    '"': u'    \n# # \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n',
    '&': u'        \n  ##    \n #  #   \n ####   \n# ## ## \n#  # #  \n#  ###  \n##  ##  \n ### ## \n        \n        \n',
    '*': u'     \n ##  \n#### \n#### \n     \n     \n     \n     \n     \n     \n     \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n   \n## \n   \n   \n',
    '2': u'     \n###  \n#  # \n   # \n   # \n  #  \n #   \n#    \n#### \n     \n     \n',
    '6': u'      \n  ### \n #  # \n#     \n####  \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    ':': u'  \n  \n  \n  \n# \n  \n  \n  \n# \n  \n  \n',
    '>': u'       \n       \n#      \n ##    \n  ##   \n    ## \n  ##   \n ##    \n#      \n       \n       \n',
    'B': u'       \n#####  \n #   # \n #   # \n ####  \n #  #  \n #   # \n #   # \n#####  \n       \n       \n',
    'F': u'       \n###### \n #   # \n #  #  \n ####  \n #  #  \n #     \n #     \n###    \n       \n       \n',
    'J': u'     \n ### \n  #  \n  #  \n  #  \n  #  \n  #  \n  #  \n  #  \n# #  \n###  \n',
    'N': u'         \n##   ### \n ##   #  \n ##   #  \n # #  #  \n #  # #  \n #  ###  \n #   ##  \n###   #  \n         \n         \n',
    'R': u'        \n#####   \n #   #  \n #   #  \n #  #   \n ####   \n #  #   \n #  ##  \n###  ## \n        \n        \n',
    'V': u'         \n###   ## \n ##   #  \n  #   #  \n  #  ##  \n   # #   \n   # #   \n   ##    \n    #    \n         \n         \n',
    'Z': u'      \n##### \n#  #  \n   #  \n  #   \n  #   \n #    \n #  # \n##### \n      \n      \n',
    '^': u'       \n   #   \n  ##   \n  ##   \n #  #  \n #  #  \n #  #  \n#    # \n       \n       \n       \n',
    'b': u'       \n##     \n #     \n #     \n ####  \n #   # \n #   # \n #   # \n ####  \n       \n       \n',
    'f': u'     \n ### \n # # \n #   \n###  \n #   \n #   \n #   \n###  \n     \n     \n',
    'j': u'    \n  # \n    \n    \n ## \n  # \n  # \n  # \n  # \n# # \n### \n',
    'n': u'        \n        \n        \n        \n######  \n #   #  \n #   #  \n #   #  \n### ### \n        \n        \n',
    'r': u'     \n     \n     \n     \n#### \n # # \n #   \n #   \n###  \n     \n     \n',
    'v': u'        \n        \n        \n        \n###  ## \n ##  #  \n  # ##  \n   ##   \n   #    \n        \n        \n',
    'z': u'      \n      \n      \n      \n##### \n#  #  \n  #   \n #  # \n##### \n      \n      \n',
    '~': u'       \n       \n       \n       \n       \n###  # \n#  ### \n       \n       \n       \n       \n',
    '!': u'  \n# \n# \n# \n# \n# \n# \n  \n# \n  \n  \n',
    '%': u'       \n #   # \n# # #  \n# ###  \n # #   \n  # #  \n ### # \n # # # \n#   #  \n       \n       \n',
    ')': u'   \n#  \n # \n # \n # \n # \n # \n # \n # \n # \n#  \n',
    '-': u'       \n       \n       \n       \n       \n       \n###### \n       \n       \n       \n       \n',
    '1': u'    \n##  \n #  \n #  \n #  \n #  \n #  \n #  \n### \n    \n    \n',
    '5': u'     \n#### \n#    \n#    \n###  \n  ## \n   # \n#  # \n###  \n     \n     \n',
    '9': u'      \n ###  \n#  ## \n#   # \n#   # \n #### \n    # \n#  #  \n###   \n      \n      \n',
    '=': u'       \n       \n       \n       \n       \n###### \n       \n###### \n       \n       \n       \n',
    'A': u'         \n   #     \n   ##    \n  ###    \n  #  #   \n #####   \n #   ##  \n##    #  \n##   ### \n         \n         \n',
    'E': u'       \n###### \n #   # \n #  #  \n ####  \n #  #  \n #     \n #   # \n###### \n       \n       \n',
    'I': u'    \n### \n #  \n #  \n #  \n #  \n #  \n #  \n### \n    \n    \n',
    'M': u'          \n###   ### \n ##   ##  \n ###  ##  \n # # # #  \n # # # #  \n #  #  #  \n #  #  #  \n###   ### \n          \n          \n',
    'Q': u'         \n  ###    \n #   #   \n#     #  \n#     #  \n#     #  \n#     #  \n #   ##  \n  ####   \n     ##  \n      ## \n',
    'U': u'         \n###  ### \n #    #  \n #    #  \n #    #  \n #    #  \n #    #  \n #    #  \n  ####   \n         \n         \n',
    'Y': u'        \n###  ## \n ##  ## \n  #  #  \n   ##   \n   #    \n   #    \n   #    \n  ###   \n        \n        \n',
    ']': u'   \n## \n # \n # \n # \n # \n # \n # \n # \n # \n## \n',
    'a': u'      \n      \n      \n      \n####  \n   #  \n####  \n#  #  \n##### \n      \n      \n',
    'e': u'      \n      \n      \n      \n ###  \n#   # \n##### \n#     \n #### \n      \n      \n',
    'i': u'    \n #  \n    \n    \n##  \n #  \n #  \n #  \n### \n    \n    \n',
    'm': u'          \n          \n          \n          \n########  \n #  #  #  \n #  #  #  \n #  #  #  \n######### \n          \n          \n',
    'q': u'       \n       \n       \n       \n ####  \n#   #  \n#   #  \n#   #  \n ####  \n    #  \n   ### \n',
    'u': u'        \n        \n        \n        \n##  ##  \n #   #  \n #   #  \n #   #  \n ###### \n        \n        \n',
    'y': u'        \n        \n        \n        \n###  ## \n ##  #  \n  # ##  \n  # #   \n   #    \n   #    \n ##     \n',
    '}': u'    \n##  \n #  \n #  \n #  \n ## \n #  \n #  \n #  \n #  \n##  \n'}

xbritebi_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'      \n  ### \n ## # \n ##   \n  #   \n  ##  \n  ##  \n# ##  \n###   \n #    \n      \n',
    '(': u'    \n  # \n #  \n #  \n#   \n#   \n#   \n#   \n#   \n#   \n#   \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n## \n## \n # \n#  \n',
    '0': u'      \n  ##  \n #  # \n #  # \n#   # \n#   # \n#  #  \n#  #  \n ##   \n      \n      \n',
    '4': u'       \n    ## \n   ### \n  # #  \n #  #  \n###### \n   ##  \n   ##  \n  ###  \n       \n       \n',
    '8': u'      \n  ##  \n #  # \n #  # \n ###  \n # #  \n#   # \n#  #  \n ##   \n      \n      \n',
    '<': u'       \n       \n     # \n   ##  \n###    \n#      \n##     \n ###   \n    #  \n       \n       \n',
    '@': u'       \n  ###  \n #   # \n ### # \n## ### \n# #### \n###### \n#      \n ###   \n       \n       \n',
    'D': u'         \n ######  \n  ##  ## \n  ##   # \n  #    # \n ##    # \n ##   #  \n ##  ##  \n######   \n         \n         \n',
    'H': u'          \n #### ### \n  #   ##  \n  #   ##  \n  ######  \n ##   #   \n ##   #   \n ##   #   \n### ####  \n          \n          \n',
    'L': u'       \n ####  \n  #    \n  #    \n  #    \n ##    \n ##  # \n ##  # \n###### \n       \n       \n',
    'P': u'        \n #####  \n  ##  # \n  ##  # \n  ## ## \n #####  \n ##     \n ##     \n####    \n        \n        \n',
    'T': u'        \n####### \n   #    \n  ##    \n  ##    \n  #     \n  #     \n  #     \n ###    \n        \n        \n',
    'X': u'         \n  ##  ## \n   #  #  \n   #  #  \n   ###   \n  ###    \n ## #    \n #   #   \n##  ###  \n         \n         \n',
    '\\': u'    \n#   \n#   \n#   \n #  \n #  \n #  \n #  \n  # \n  # \n  # \n',
    '`': u'   \n # \n#  \n## \n## \n   \n   \n   \n   \n   \n   \n',
    'd': u'       \n    ## \n    ## \n    ## \n  ###  \n #  #  \n#  ##  \n# ###  \n#####  \n       \n       \n',
    'h': u'       \n ##    \n ##    \n ##    \n # ### \n ### # \n #   # \n##  #  \n##  ## \n       \n       \n',
    'l': u'    \n ## \n #  \n #  \n #  \n #  \n #  \n #  \n##  \n    \n    \n',
    'p': u'       \n       \n       \n       \n ##### \n ### # \n ##  # \n #  #  \n ###   \n#      \n#      \n',
    't': u'     \n  #  \n ##  \n ##  \n#### \n #   \n #   \n#    \n###  \n     \n     \n',
    'x': u'      \n      \n      \n      \n #  # \n  # # \n ###  \n#  #  \n#  ## \n      \n      \n',
    '|': u'    \n  # \n  # \n #  \n #  \n #  \n#   \n#   \n#   \n#   \n#   \n',
    '#': u'       \n   # # \n   # # \n###### \n #  #  \n #  #  \n###### \n# #    \n# #    \n       \n       \n',
    "'": u'   \n## \n## \n # \n#  \n   \n   \n   \n   \n   \n   \n',
    '+': u'       \n       \n   #   \n   #   \n   #   \n###### \n  #    \n  #    \n  #    \n       \n       \n',
    '/': u'        \n      # \n     #  \n    ##  \n    #   \n   #    \n   #    \n  #     \n ##     \n #      \n#       \n',
    '3': u'      \n  ### \n #  # \n    # \n ###  \n   #  \n    # \n#  #  \n####  \n      \n      \n',
    '7': u'       \n###### \n     # \n   ##  \n  #    \n  #    \n #     \n #     \n#      \n       \n       \n',
    ';': u'    \n    \n    \n    \n ## \n    \n    \n #  \n##  \n #  \n#   \n',
    '?': u'     \n###  \n#  # \n#  # \n   # \n ##  \n##   \n     \n##   \n     \n     \n',
    'C': u'        \n   #### \n ##   # \n #      \n#       \n#       \n#       \n##      \n #####  \n        \n        \n',
    'G': u'        \n  ##### \n ##   # \n #      \n#       \n#  #### \n#    #  \n##  ##  \n #####  \n        \n        \n',
    'K': u'         \n #### ## \n  ##  #  \n  #  #   \n  # #    \n ####    \n ## #    \n ##  #   \n### ###  \n         \n         \n',
    'O': u'        \n  ####  \n ##  #  \n #   ## \n#    ## \n#    #  \n#    #  \n#   #   \n ###    \n        \n        \n',
    'S': u'       \n  #### \n #   # \n #     \n  #    \n   ##  \n    #  \n#   #  \n####   \n       \n       \n',
    'W': u'          \n### #  ## \n #  #  #  \n # ##  #  \n # ## ##  \n #### ##  \n ######   \n ## ##    \n #  #     \n          \n          \n',
    '[': u'     \n  ## \n  #  \n ##  \n #   \n #   \n #   \n #   \n##   \n#    \n##   \n',
    '_': u'     \n     \n     \n     \n     \n     \n     \n     \n     \n#### \n     \n',
    'c': u'      \n      \n      \n      \n  ### \n # #  \n#     \n#     \n####  \n      \n      \n',
    'g': u'       \n       \n       \n       \n  #### \n #  #  \n #  #  \n#  ##  \n ## #  \n#  ##  \n####   \n',
    'k': u'       \n ##    \n ##    \n ##    \n ## ## \n # ##  \n ###   \n## #   \n##  ## \n       \n       \n',
    'o': u'      \n      \n      \n      \n  ##  \n #  # \n#   # \n#  #  \n###   \n      \n      \n',
    's': u'     \n     \n     \n     \n#### \n # # \n ##  \n#  # \n###  \n     \n     \n',
    'w': u'         \n         \n         \n         \n##  # ## \n # ## ## \n # ## #  \n ## ##   \n ## #    \n         \n         \n',
    '{': u'     \n  ## \n  #  \n  #  \n  #  \n  #  \n##   \n #   \n#    \n#    \n##   \n',
    '"': u'    \n# # \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n',
    '&': u'        \n   ##   \n  # #   \n  # #   \n ### ## \n#  # #  \n#  # #  \n#   #   \n #####  \n        \n        \n',
    '*': u'     \n  #  \n#### \n# #  \n     \n     \n     \n     \n     \n     \n     \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n   \n## \n   \n   \n',
    '2': u'       \n  ###  \n #   # \n     # \n    ## \n   #   \n ##    \n #     \n###### \n       \n       \n',
    '6': u'      \n  ### \n #  # \n #    \n####  \n#  #  \n#  #  \n#  #  \n ##   \n      \n      \n',
    ':': u'    \n    \n    \n    \n ## \n    \n    \n    \n##  \n    \n    \n',
    '>': u'        \n        \n  #     \n  ###   \n     #  \n      # \n   ###  \n ###    \n#       \n        \n        \n',
    'B': u'        \n ###### \n  ##  # \n  ##  # \n  ####  \n ### #  \n ##   # \n ##  #  \n######  \n        \n        \n',
    'F': u'        \n ###### \n  ##  # \n  #  #  \n  ####  \n ## #   \n ##     \n ##     \n###     \n        \n        \n',
    'J': u'       \n   ### \n    #  \n   ##  \n   ##  \n   ##  \n   #   \n   #   \n  ##   \n# ##   \n###    \n',
    'N': u'          \n ##    ## \n  ##   #  \n  ##   #  \n  # #  #  \n #  # #   \n #   ##   \n #   ##   \n##    #   \n          \n          \n',
    'R': u'        \n ###### \n  ##  # \n  ##  # \n  ####  \n ## #   \n ##  #  \n ##  #  \n#### ## \n        \n        \n',
    'V': u'         \n###   ## \n #    #  \n #    #  \n #   #   \n  # #    \n  # #    \n  ##     \n  ##     \n         \n         \n',
    'Z': u'        \n  ##### \n  #  #  \n #  #   \n   #    \n   #    \n  #     \n #   #  \n######  \n        \n        \n',
    '^': u'       \n       \n   ##  \n  # #  \n  # #  \n ## #  \n#   #  \n#    # \n       \n       \n       \n',
    'b': u'       \n ##    \n ##    \n ##    \n # ### \n ### # \n #   # \n##  #  \n####   \n       \n       \n',
    'f': u'      \n   ## \n  # # \n  #   \n ###  \n #    \n #    \n #    \n #    \n##    \n#     \n',
    'j': u'      \n   ## \n      \n      \n  ### \n   #  \n   #  \n  ##  \n  ##  \n# #   \n##    \n',
    'n': u'       \n       \n       \n       \n### ## \n # # # \n ##  # \n #  #  \n##  ## \n       \n       \n',
    'r': u'      \n      \n      \n      \n## ## \n ##   \n ##   \n #    \n#     \n      \n      \n',
    'v': u'       \n       \n       \n       \n##  ## \n #  ## \n ####  \n  #    \n  #    \n       \n       \n',
    'z': u'       \n       \n       \n       \n ##### \n #  #  \n  ##   \n #  #  \n#####  \n       \n       \n',
    '~': u'       \n       \n       \n       \n       \n #   # \n# ###  \n       \n       \n       \n       \n',
    '!': u'    \n ## \n ## \n #  \n #  \n #  \n #  \n    \n##  \n    \n    \n',
    '%': u'     \n # # \n## # \n##   \n###  \n # # \n ### \n# ## \n#  # \n     \n     \n',
    ')': u'    \n  # \n  # \n  # \n  # \n  # \n  # \n  # \n #  \n #  \n#   \n',
    '-': u'       \n       \n       \n       \n       \n       \n###### \n       \n       \n       \n       \n',
    '1': u'     \n ### \n  ## \n  ## \n  #  \n  #  \n  #  \n ##  \n#### \n     \n     \n',
    '5': u'      \n #### \n #    \n #    \n ##   \n   #  \n   ## \n#  #  \n###   \n      \n      \n',
    '9': u'      \n  ##  \n #  # \n #  # \n #  # \n #### \n   #  \n#  #  \n###   \n      \n      \n',
    '=': u'       \n       \n       \n       \n       \n###### \n       \n###### \n       \n       \n       \n',
    'A': u'         \n     #   \n    ##   \n   ###   \n  #  #   \n  #####  \n  #   #  \n #    #  \n##   ### \n         \n         \n',
    'E': u'        \n ###### \n  ##  # \n  #  #  \n  ####  \n ## #   \n ##     \n ##  #  \n######  \n        \n        \n',
    'I': u'      \n #### \n   #  \n   #  \n  #   \n  #   \n ##   \n ##   \n####  \n      \n      \n',
    'M': u'           \n ##     ## \n  ##  ###  \n  ##  # #  \n  ## ###   \n # #####   \n #  ## #   \n #  #  #   \n##    ###  \n           \n           \n',
    'Q': u'        \n  ####  \n ##  #  \n #   ## \n#    ## \n#    #  \n#    #  \n#   ##  \n ####   \n   ##   \n     ## \n',
    'U': u'       \n###  # \n #   # \n #   # \n#   #  \n#   #  \n#   #  \n#   #  \n ###   \n       \n       \n',
    'Y': u'        \n###  ## \n #   #  \n #   #  \n  # #   \n  ##    \n  #     \n  #     \n####    \n        \n        \n',
    ']': u'     \n  ## \n   # \n  ## \n  #  \n  #  \n  #  \n  #  \n ##  \n #   \n##   \n',
    'a': u'       \n       \n       \n       \n  #### \n #  ## \n#   #  \n# ###  \n###### \n       \n       \n',
    'e': u'     \n     \n     \n     \n  ## \n # # \n###  \n#  # \n#### \n     \n     \n',
    'i': u'    \n ## \n    \n    \n##  \n #  \n #  \n #  \n##  \n    \n    \n',
    'm': u'          \n          \n          \n          \n### ##### \n ###### # \n ## ##  # \n##  #  #  \n##  #  ## \n          \n          \n',
    'q': u'       \n       \n       \n       \n  #### \n #  ## \n#   #  \n# ###  \n### #  \n   ##  \n   ##  \n',
    'u': u'       \n       \n       \n       \n##  ## \n #  ## \n#  ##  \n# # #  \n###### \n       \n       \n',
    'y': u'        \n        \n        \n        \n ##  ## \n  ##  # \n  ## ## \n  ####  \n   #    \n  #     \n##      \n',
    '}': u'     \n  ## \n  ## \n  #  \n  #  \n  ## \n #   \n #   \n #   \n #   \n##   \n'}

xbritei_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'     \n     \n ### \n ### \n  #  \n #   \n ##  \n # # \n###  \n##   \n #   \n     \n',
    '(': u'     \n     \n  ## \n #   \n #   \n#    \n#    \n#    \n#    \n#    \n#    \n#    \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n## \n # \n#  \n',
    '0': u'      \n      \n  ### \n #  # \n #  # \n#   # \n#   # \n#   # \n#  #  \n ##   \n      \n      \n',
    '4': u'      \n      \n   ## \n  # # \n #  # \n#  #  \n##### \n   #  \n   #  \n  ##  \n      \n      \n',
    '8': u'      \n      \n  ### \n #  # \n #  # \n #### \n#  ## \n#   # \n#  ## \n ###  \n      \n      \n',
    '<': u'       \n       \n       \n    ## \n    #  \n  ##   \n##     \n ##    \n   #   \n    #  \n       \n       \n',
    '@': u'         \n         \n   ####  \n ##    # \n # ### # \n# #  # # \n# # ## # \n# ## ##  \n#        \n ####    \n         \n         \n',
    'D': u'         \n         \n ######  \n  #   ## \n  #    # \n  #    # \n  #    # \n #    #  \n #   ##  \n######   \n         \n         \n',
    'H': u'          \n          \n ###  ### \n  #    #  \n  #   ##  \n  #####   \n ##   #   \n #    #   \n #    #   \n###  ###  \n          \n          \n',
    'L': u'       \n       \n ####  \n  #    \n  #    \n  #    \n  #    \n #     \n #   # \n###### \n       \n       \n',
    'P': u'       \n       \n ##### \n  #  # \n  #  # \n  # ## \n ####  \n #     \n #     \n###    \n       \n       \n',
    'T': u'       \n       \n###### \n# #  # \n  #    \n  #    \n  #    \n  #    \n ##    \n###    \n       \n       \n',
    'X': u'         \n         \n  ##  ## \n  ##  #  \n   # #   \n   ##    \n   ##    \n  # ##   \n #   #   \n##  ###  \n         \n         \n',
    '\\': u'    \n    \n#   \n#   \n #  \n #  \n #  \n #  \n #  \n #  \n  # \n  # \n',
    '`': u'   \n   \n # \n#  \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'       \n       \n    ## \n     # \n    #  \n  ###  \n #  #  \n#   #  \n# ###  \n#####  \n       \n       \n',
    'h': u'      \n      \n #    \n #    \n #    \n # ## \n ## # \n##  # \n#  #  \n#  ## \n      \n      \n',
    'l': u'    \n    \n ## \n  # \n #  \n #  \n #  \n #  \n#   \n##  \n    \n    \n',
    'p': u'       \n       \n       \n       \n       \n ##### \n#### # \n ##  # \n #  #  \n ###   \n#      \n#      \n',
    't': u'    \n    \n #  \n #  \n #  \n### \n #  \n#   \n#   \n##  \n    \n    \n',
    'x': u'      \n      \n      \n      \n      \n##  # \n ###  \n  #   \n## #  \n#  ## \n      \n      \n',
    '|': u'   \n   \n # \n # \n # \n # \n#  \n#  \n#  \n#  \n#  \n#  \n',
    '#': u'       \n       \n   # # \n   # # \n###### \n  ##   \n  ##   \n###### \n# #    \n# #    \n       \n       \n',
    "'": u'   \n   \n## \n # \n## \n   \n   \n   \n   \n   \n   \n   \n',
    '+': u'       \n       \n       \n   #   \n   #   \n   #   \n###### \n  #    \n  #    \n  #    \n       \n       \n',
    '/': u'       \n       \n     # \n    #  \n    #  \n   #   \n   #   \n  #    \n  #    \n #     \n#      \n#      \n',
    '3': u'      \n      \n #### \n #  # \n    # \n ###  \n   #  \n    # \n#  #  \n###   \n      \n      \n',
    '7': u'       \n       \n ##### \n     # \n    #  \n  ##   \n  #    \n #     \n #     \n#      \n       \n       \n',
    ';': u'    \n    \n    \n    \n    \n ## \n    \n    \n    \n##  \n #  \n#   \n',
    '?': u'     \n     \n###  \n#  # \n   # \n  #  \n #   \n#    \n     \n#    \n     \n     \n',
    'C': u'        \n        \n   #### \n ##   # \n #      \n#       \n#       \n#       \n##      \n #####  \n        \n        \n',
    'G': u'        \n        \n   #### \n ##   # \n #      \n#       \n#   ### \n#    #  \n##   #  \n #####  \n        \n        \n',
    'K': u'         \n         \n #### ## \n  #   #  \n  # ##   \n  ###    \n  ##     \n #  #    \n #   #   \n### ###  \n         \n         \n',
    'O': u'        \n        \n   ###  \n ##  ## \n #    # \n#     # \n#     # \n#    #  \n##  ##  \n ###    \n        \n        \n',
    'S': u'      \n      \n  ### \n #  # \n #    \n  #   \n   #  \n   #  \n#  #  \n###   \n      \n      \n',
    'W': u'          \n          \n### #  ## \n #  #  #  \n # ##  #  \n # ## #   \n ## # #   \n ## ##    \n #  ##    \n #  #     \n          \n          \n',
    '[': u'     \n     \n  ## \n  #  \n #   \n #   \n #   \n #   \n #   \n#    \n#    \n##   \n',
    '_': u'     \n     \n     \n     \n     \n     \n     \n     \n     \n     \n#### \n     \n',
    'c': u'      \n      \n      \n      \n      \n  ### \n # #  \n#     \n#     \n####  \n      \n      \n',
    'g': u'       \n       \n       \n       \n       \n  #### \n #   # \n #  #  \n#  ##  \n ## #  \n#   #  \n####   \n',
    'k': u'      \n      \n #    \n #    \n #    \n # ## \n ##   \n ##   \n# ##  \n#  ## \n      \n      \n',
    'o': u'      \n      \n      \n      \n      \n  ##  \n #  # \n#   # \n#  #  \n###   \n      \n      \n',
    's': u'     \n     \n     \n     \n     \n ### \n # # \n ##  \n# #  \n###  \n     \n     \n',
    'w': u'         \n         \n         \n         \n         \n##  #  # \n # ##  # \n # ## #  \n ## ##   \n ## ##   \n         \n         \n',
    '{': u'    \n    \n  # \n #  \n #  \n #  \n #  \n#   \n #  \n#   \n#   \n##  \n',
    '"': u'    \n    \n### \n##  \n##  \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'        \n        \n   ##   \n  #  #  \n  #  #  \n ####   \n#  # ## \n#  # #  \n#   ##  \n ###### \n        \n        \n',
    '*': u'     \n     \n  #  \n#### \n ##  \n# #  \n     \n     \n     \n     \n     \n     \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'       \n       \n  ###  \n #   # \n     # \n    #  \n  ##   \n #     \n#      \n#####  \n       \n       \n',
    '6': u'      \n      \n  ### \n ## # \n #    \n####  \n#   # \n#   # \n#  #  \n ##   \n      \n      \n',
    ':': u'   \n   \n   \n   \n   \n # \n   \n   \n   \n#  \n   \n   \n',
    '>': u'       \n       \n       \n #     \n  ##   \n    #  \n     # \n  ###  \n  #    \n##     \n       \n       \n',
    'B': u'       \n       \n ##### \n  #  # \n  #  # \n  ###  \n #  #  \n #   # \n #  #  \n#####  \n       \n       \n',
    'F': u'       \n       \n ##### \n  #  # \n  # #  \n ####  \n #  #  \n #     \n #     \n###    \n       \n       \n',
    'J': u'       \n       \n   ### \n    #  \n    #  \n   #   \n   #   \n   #   \n   #   \n   #   \n# #    \n###    \n',
    'N': u'          \n          \n ##   ### \n  ##   #  \n # #  #   \n #  # #   \n #  # #   \n #   ##   \n #   ##   \n##   #    \n          \n          \n',
    'R': u'        \n        \n ###### \n  #  ## \n  #   # \n  #  #  \n  ###   \n ## #   \n #   #  \n###  ## \n        \n        \n',
    'V': u'        \n        \n###  ## \n #   ## \n #   #  \n #  #   \n #  #   \n # #    \n  ##    \n  #     \n        \n        \n',
    'Z': u'       \n       \n ##### \n #  #  \n    #  \n   #   \n  #    \n #     \n #  #  \n#####  \n       \n       \n',
    '^': u'       \n       \n    #  \n   ##  \n  # #  \n  # #  \n #   # \n #   # \n#    # \n       \n       \n       \n',
    'b': u'      \n      \n #    \n #    \n #    \n #### \n ## # \n##  # \n#  #  \n###   \n      \n      \n',
    'f': u'      \n      \n   ## \n  # # \n  #   \n ###  \n #    \n #    \n #    \n #    \n#     \n#     \n',
    'j': u'      \n      \n    # \n      \n      \n   ## \n   #  \n   #  \n   #  \n   #  \n# #   \n##    \n',
    'n': u'      \n      \n      \n      \n      \n## ## \n ## # \n #  # \n#  #  \n#  ## \n      \n      \n',
    'r': u'      \n      \n      \n      \n      \n## ## \n ## # \n #    \n##    \n#     \n      \n      \n',
    'v': u'       \n       \n       \n       \n       \n##  ## \n #  #  \n  # #  \n  ##   \n  #    \n       \n       \n',
    'z': u'      \n      \n      \n      \n      \n #### \n # #  \n  #   \n # #  \n####  \n      \n      \n',
    '~': u'         \n         \n         \n         \n         \n         \n ###   # \n#   ###  \n         \n         \n         \n         \n',
    '!': u'   \n   \n # \n # \n # \n # \n # \n # \n   \n#  \n   \n   \n',
    '%': u'         \n         \n ###  ## \n # # #   \n # # #   \n ## #    \n   # ##  \n  # # #  \n #  # #  \n#   ###  \n         \n         \n',
    ')': u'    \n    \n  # \n  # \n  # \n  # \n  # \n  # \n  # \n  # \n #  \n#   \n',
    '-': u'       \n       \n       \n       \n       \n       \n       \n###### \n       \n       \n       \n       \n',
    '1': u'     \n     \n ### \n   # \n  #  \n  #  \n  #  \n  #  \n  #  \n#### \n     \n     \n',
    '5': u'      \n      \n #### \n #    \n #    \n ###  \n   #  \n    # \n#  #  \n###   \n      \n      \n',
    '9': u'      \n      \n  ### \n #  # \n##  # \n #  # \n #### \n    # \n#  #  \n###   \n      \n      \n',
    '=': u'       \n       \n       \n       \n       \n       \n###### \n       \n###### \n       \n       \n       \n',
    'A': u'        \n        \n    #   \n   ##   \n   # #  \n  #  #  \n #####  \n#    #  \n#    #  \n##  ### \n        \n        \n',
    'E': u'       \n       \n ##### \n  #  # \n  # #  \n  ###  \n #  #  \n #     \n #  #  \n#####  \n       \n       \n',
    'I': u'     \n     \n ### \n  #  \n  #  \n  #  \n #   \n #   \n #   \n###  \n     \n     \n',
    'M': u'           \n           \n ##    ### \n  ##   ##  \n  ##  ###  \n # #  ##   \n # # # #   \n #  #  #   \n #  #  #   \n##    ###  \n           \n           \n',
    'Q': u'         \n         \n   ###   \n ##  ##  \n #    #  \n#     #  \n#     #  \n#    #   \n##  ##   \n ###     \n    #    \n     ### \n',
    'U': u'        \n        \n###  ## \n #   #  \n #   #  \n#    #  \n#    #  \n#    #  \n#   #   \n ###    \n        \n        \n',
    'Y': u'        \n        \n###  ## \n #   #  \n #  #   \n  ##    \n  ##    \n  #     \n  #     \n ###    \n        \n        \n',
    ']': u'     \n     \n  ## \n   # \n   # \n  #  \n  #  \n  #  \n  #  \n  #  \n #   \n##   \n',
    'a': u'      \n      \n      \n      \n      \n  ### \n #  # \n#   # \n#  #  \n##### \n      \n      \n',
    'e': u'     \n     \n     \n     \n     \n  ## \n # # \n###  \n#  # \n#### \n     \n     \n',
    'i': u'   \n   \n # \n   \n   \n## \n#  \n#  \n#  \n## \n   \n   \n',
    'm': u'         \n         \n         \n         \n         \n######## \n ## ## # \n #  #  # \n#  ## #  \n#  #  ## \n         \n         \n',
    'q': u'      \n      \n      \n      \n      \n  ### \n #  # \n#   # \n#  #  \n####  \n   #  \n   #  \n',
    'u': u'      \n      \n      \n      \n      \n## ## \n #  # \n#  ## \n# ##  \n##### \n      \n      \n',
    'y': u'       \n       \n       \n       \n       \n #   # \n  #  # \n  # ## \n  ###  \n  #    \n  #    \n##     \n',
    '}': u'    \n    \n  # \n  # \n  # \n  # \n  # \n #  \n #  \n #  \n #  \n##  \n'}

xchartr_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'      \n      \n  #   \n #### \n# # # \n# #   \n ###  \n  # # \n# # # \n####  \n  #   \n      \n',
    '(': u'    \n    \n  # \n #  \n#   \n#   \n#   \n#   \n#   \n #  \n  # \n    \n',
    ',': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n# \n  \n',
    '0': u'      \n      \n      \n ###  \n # #  \n#   # \n#   # \n#   # \n # #  \n  #   \n      \n      \n',
    '4': u'       \n       \n       \n    #  \n   ##  \n  # #  \n #  #  \n###### \n    #  \n    #  \n       \n       \n',
    '8': u'      \n      \n      \n  ##  \n #  # \n##  # \n ###  \n#   # \n#   # \n ###  \n      \n      \n',
    '<': u'       \n       \n       \n       \n    ## \n ###   \n#      \n ###   \n    ## \n       \n       \n       \n',
    '@': u'          \n          \n   ####   \n ##    #  \n #  ### # \n#  # #  # \n# #  #  # \n# #  # #  \n#  ####   \n #    ##  \n  ####    \n          \n',
    'D': u'       \n       \n       \n####   \n #  #  \n #   # \n #   # \n #   # \n #  #  \n####   \n       \n       \n',
    'H': u'        \n        \n        \n### ### \n #   #  \n #   #  \n #####  \n #   #  \n #   #  \n### ### \n        \n        \n',
    'L': u'     \n     \n     \n###  \n #   \n #   \n #   \n #   \n # # \n#### \n     \n     \n',
    'P': u'      \n      \n      \n####  \n #  # \n #  # \n #  # \n ###  \n #    \n###   \n      \n      \n',
    'T': u'      \n      \n      \n##### \n# # # \n  #   \n  #   \n  #   \n  #   \n ###  \n      \n      \n',
    'X': u'       \n       \n       \n### ## \n #  #  \n  ##   \n  ##   \n  ##   \n #  #  \n##  ## \n       \n       \n',
    '\\': u'      \n      \n      \n#     \n #    \n #    \n  #   \n  #   \n   #  \n   #  \n    # \n      \n',
    '`': u'  \n  \n# \n# \n# \n  \n  \n  \n  \n  \n  \n  \n',
    'd': u'      \n      \n   ## \n    # \n    # \n  ### \n #  # \n#   # \n##  # \n #### \n      \n      \n',
    'h': u'      \n      \n#     \n#     \n#     \n####  \n#   # \n#   # \n#   # \n## ## \n      \n      \n',
    'l': u'  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'p': u'      \n      \n      \n      \n      \n####  \n#   # \n#   # \n#  ## \n###   \n#     \n##    \n',
    't': u'   \n   \n   \n   \n#  \n## \n#  \n#  \n#  \n## \n   \n   \n',
    'x': u'      \n      \n      \n      \n      \n## ## \n # #  \n  #   \n # #  \n## ## \n      \n      \n',
    '|': u'  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'        \n        \n        \n   # #  \n   # #  \n ###### \n  # #   \n####### \n # #    \n # #    \n        \n        \n',
    "'": u'  \n  \n# \n# \n# \n  \n  \n  \n  \n  \n  \n  \n',
    '+': u'        \n        \n        \n   #    \n   #    \n   #    \n####### \n   #    \n   #    \n   #    \n        \n        \n',
    '/': u'      \n      \n      \n    # \n   #  \n   #  \n  #   \n  #   \n #    \n #    \n#     \n      \n',
    '3': u'      \n      \n      \n ###  \n#   # \n   #  \n  ##  \n    # \n#   # \n ###  \n      \n      \n',
    '7': u'      \n      \n      \n##### \n#   # \n   #  \n  #   \n  #   \n #    \n #    \n      \n      \n',
    ';': u'  \n  \n  \n  \n  \n# \n  \n  \n  \n# \n# \n  \n',
    '?': u'     \n     \n     \n ##  \n#  # \n   # \n  #  \n #   \n     \n #   \n     \n     \n',
    'C': u'       \n       \n       \n  ###  \n #   # \n#      \n#      \n#      \n #   # \n  #### \n       \n       \n',
    'G': u'       \n       \n       \n  ###  \n #  #  \n#      \n#  ### \n#   #  \n #  #  \n  ###  \n       \n       \n',
    'K': u'       \n       \n       \n### ## \n #  #  \n # #   \n ###   \n # #   \n #  #  \n###  # \n       \n       \n',
    'O': u'        \n        \n        \n  ###   \n #   #  \n#     # \n#     # \n#     # \n #   #  \n  ###   \n        \n        \n',
    'S': u'      \n      \n      \n #### \n#   # \n#     \n ###  \n    # \n#   # \n####  \n      \n      \n',
    'W': u'           \n           \n           \n##   #  ## \n #  ##   # \n #  ##  #  \n # #  # #  \n # #  # #  \n  ##  ###  \n  #    #   \n           \n           \n',
    '[': u'   \n   \n   \n## \n#  \n#  \n#  \n#  \n#  \n#  \n## \n   \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n##### \n',
    'c': u'     \n     \n     \n     \n     \n ##  \n#  # \n#    \n#    \n ### \n     \n     \n',
    'g': u'     \n     \n     \n     \n     \n # # \n# #  \n #   \n #   \n ##  \n# ## \n #   \n',
    'k': u'     \n     \n#    \n#    \n#    \n#  # \n# #  \n###  \n#  # \n## # \n     \n     \n',
    'o': u'      \n      \n      \n      \n      \n ###  \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    's': u'    \n    \n    \n    \n    \n ## \n# # \n #  \n# # \n##  \n    \n    \n',
    'w': u'         \n         \n         \n         \n         \n##  # ## \n #  #  # \n # ## #  \n ### ##  \n  #  #   \n         \n         \n',
    '{': u'     \n     \n     \n   # \n  #  \n  #  \n##   \n  #  \n  #  \n  #  \n   # \n     \n',
    '"': u'    \n    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'       \n       \n       \n ##    \n#  #   \n ###   \n ## ## \n#  ##  \n#  ##  \n ## ## \n       \n       \n',
    '*': u'      \n      \n  #   \n##### \n  #   \n # #  \n      \n      \n      \n      \n      \n      \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'      \n      \n      \n ###  \n#   # \n    # \n   #  \n  #   \n #  # \n##### \n      \n      \n',
    '6': u'      \n      \n      \n   #  \n ##   \n#     \n####  \n#   # \n#   # \n ###  \n      \n      \n',
    ':': u'  \n  \n  \n  \n  \n# \n  \n  \n  \n# \n  \n  \n',
    '>': u'       \n       \n       \n       \n##     \n  ###  \n     # \n  ###  \n##     \n       \n       \n       \n',
    'B': u'      \n      \n      \n####  \n #  # \n # #  \n ###  \n #  # \n #  # \n####  \n      \n      \n',
    'F': u'      \n      \n      \n##### \n #  # \n # #  \n ###  \n # #  \n #    \n##    \n      \n      \n',
    'J': u'      \n      \n      \n  ### \n   #  \n   #  \n   #  \n   #  \n#  #  \n###   \n      \n      \n',
    'N': u'       \n       \n       \n##  ## \n ## #  \n ## #  \n # ##  \n # ##  \n # ##  \n##  #  \n       \n       \n',
    'R': u'       \n       \n       \n####   \n #  #  \n #  #  \n ###   \n #  #  \n #  #  \n###  # \n       \n       \n',
    'V': u'        \n        \n        \n##   ## \n #   #  \n #   #  \n  #  #  \n  # #   \n  ###   \n   #    \n        \n        \n',
    'Z': u'      \n      \n      \n##### \n#  #  \n   #  \n  #   \n #    \n#   # \n##### \n      \n      \n',
    '^': u'       \n       \n  ##   \n #  #  \n#    # \n       \n       \n       \n       \n       \n       \n       \n',
    'b': u'      \n      \n#     \n#     \n#     \n####  \n#   # \n#   # \n#  ## \n###   \n      \n      \n',
    'f': u'    \n    \n ## \n# # \n#   \n##  \n#   \n#   \n#   \n##  \n    \n    \n',
    'j': u'    \n    \n  # \n  # \n    \n  # \n  # \n  # \n  # \n  # \n  # \n##  \n',
    'n': u'      \n      \n      \n      \n      \n##### \n#   # \n#   # \n#   # \n## ## \n      \n      \n',
    'r': u'    \n    \n    \n    \n    \n### \n#   \n#   \n#   \n##  \n    \n    \n',
    'v': u'      \n      \n      \n      \n      \n## ## \n #  # \n # #  \n ###  \n  #   \n      \n      \n',
    'z': u'     \n     \n     \n     \n     \n#### \n# #  \n #   \n#  # \n#### \n     \n     \n',
    '~': u'       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n       \n       \n',
    '!': u'  \n  \n  \n# \n# \n# \n# \n# \n  \n# \n  \n  \n',
    '%': u'         \n         \n #    #  \n# #  #   \n# # #    \n# # # #  \n # # # # \n   # # # \n  #  # # \n #    #  \n         \n         \n',
    ')': u'    \n    \n#   \n #  \n  # \n  # \n  # \n  # \n  # \n #  \n#   \n    \n',
    '-': u'   \n   \n   \n   \n   \n   \n   \n## \n   \n   \n   \n   \n',
    '1': u'    \n    \n    \n #  \n##  \n #  \n #  \n #  \n #  \n### \n    \n    \n',
    '5': u'       \n       \n       \n ##### \n #     \n ####  \n     # \n     # \n##  #  \n ###   \n       \n       \n',
    '9': u'      \n      \n      \n ###  \n#   # \n#   # \n#   # \n #### \n   #  \n ##   \n      \n      \n',
    '=': u'       \n       \n       \n       \n       \n###### \n       \n###### \n       \n       \n       \n       \n',
    'A': u'        \n        \n        \n   #    \n  ###   \n  # #   \n #  #   \n #####  \n #   #  \n##   ## \n        \n        \n',
    'E': u'      \n      \n      \n##### \n #    \n #  # \n #### \n #  # \n #    \n##### \n      \n      \n',
    'I': u'    \n    \n    \n### \n #  \n #  \n #  \n #  \n #  \n### \n    \n    \n',
    'M': u'         \n         \n         \n###   ## \n ##  ##  \n ##  ##  \n # ## #  \n # ## #  \n # ## #  \n#### ### \n         \n         \n',
    'Q': u'        \n        \n        \n  ###   \n #   #  \n#     # \n#     # \n#     # \n #   #  \n  ###   \n   #### \n        \n',
    'U': u'        \n        \n        \n### ### \n #   #  \n #   #  \n #   #  \n #   #  \n #  ##  \n  ##    \n        \n        \n',
    'Y': u'        \n        \n        \n###  ## \n #   #  \n  # #   \n   #    \n   #    \n   #    \n  ###   \n        \n        \n',
    ']': u'   \n   \n   \n## \n # \n # \n # \n # \n # \n # \n## \n   \n',
    'a': u'     \n     \n     \n     \n     \n ##  \n  ## \n## # \n#  # \n ### \n     \n     \n',
    'e': u'     \n     \n     \n     \n     \n ##  \n#  # \n#### \n#    \n ### \n     \n     \n',
    'i': u'  \n  \n# \n# \n  \n# \n# \n# \n# \n# \n  \n  \n',
    'm': u'        \n        \n        \n        \n        \n####### \n#  #  # \n#  #  # \n#  #  # \n## ## # \n        \n        \n',
    'q': u'      \n      \n      \n      \n      \n  ### \n##  # \n#   # \n#   # \n #### \n    # \n   ## \n',
    'u': u'      \n      \n      \n      \n      \n#  ## \n#   # \n#   # \n#   # \n #### \n      \n      \n',
    'y': u'      \n      \n      \n      \n      \n## ## \n # #  \n # #  \n  ##  \n  #   \n  #   \n##    \n',
    '}': u'     \n     \n     \n#    \n #   \n #   \n  ## \n #   \n #   \n #   \n#    \n     \n'}

xchartri_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'      \n      \n      \n   #  \n  ### \n # ## \n ##   \n  ##  \n  # # \n# ##  \n ##   \n #    \n      \n',
    '(': u'     \n     \n     \n  ## \n #   \n #   \n #   \n#    \n#    \n#    \n#    \n #   \n     \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n # \n## \n   \n',
    '0': u'      \n      \n      \n      \n  ##  \n #  # \n#   # \n#   # \n#   # \n#  #  \n ##   \n      \n      \n',
    '4': u'       \n       \n       \n       \n    #  \n   ##  \n  # #  \n #  #  \n###### \n   #   \n   #   \n       \n       \n',
    '8': u'      \n      \n      \n      \n  ##  \n #  # \n #  # \n ###  \n#   # \n#  #  \n ##   \n      \n      \n',
    '<': u'       \n       \n       \n       \n       \n    ## \n ###   \n#      \n ###   \n    ## \n       \n       \n       \n',
    '@': u'          \n          \n          \n   ####   \n ##    #  \n #  ### # \n#  # #  # \n# #  #  # \n# #  # #  \n#  ####   \n #    ##  \n  ####    \n          \n',
    'D': u'        \n        \n        \n        \n ####   \n  #  #  \n  #   # \n #    # \n #   #  \n #  ##  \n####    \n        \n        \n',
    'H': u'         \n         \n         \n         \n ### ### \n  #   #  \n  #   #  \n ######  \n #   #   \n #   #   \n### ###  \n         \n         \n',
    'L': u'      \n      \n      \n      \n ###  \n  #   \n  #   \n #    \n #    \n #  # \n##### \n      \n      \n',
    'P': u'       \n       \n       \n       \n ####  \n  #  # \n  #  # \n #  #  \n ###   \n #     \n##     \n       \n       \n',
    'T': u'       \n       \n       \n       \n###### \n# #  # \n  #    \n  #    \n  #    \n  #    \n ##    \n       \n       \n',
    'X': u'        \n        \n        \n        \n ### ## \n  #  #  \n   ##   \n   #    \n  # #   \n #  #   \n##  ##  \n        \n        \n',
    '\\': u'      \n      \n      \n      \n#     \n #    \n #    \n  #   \n  #   \n   #  \n   #  \n    # \n      \n',
    '`': u'   \n   \n   \n # \n#  \n## \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'      \n      \n      \n    # \n    # \n    # \n  ### \n #  # \n#   # \n#  #  \n ## # \n      \n      \n',
    'h': u'       \n       \n       \n ##    \n  #    \n #     \n # ##  \n ## #  \n #  #  \n # #   \n#   ## \n       \n       \n',
    'l': u'   \n   \n   \n## \n # \n # \n # \n#  \n#  \n#  \n## \n   \n   \n',
    'p': u'       \n       \n       \n       \n       \n       \n ##### \n  #  # \n #   # \n #  #  \n ###   \n #     \n###    \n',
    't': u'    \n    \n    \n    \n    \n #  \n### \n#   \n#   \n#   \n##  \n    \n    \n',
    'x': u'       \n       \n       \n       \n       \n       \n ## ## \n  ##   \n  ##   \n # #   \n## ##  \n       \n       \n',
    '|': u'  \n  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'        \n        \n        \n        \n   # #  \n   # #  \n ###### \n  # #   \n####### \n # #    \n # #    \n        \n        \n',
    "'": u'  \n  \n  \n# \n# \n# \n  \n  \n  \n  \n  \n  \n  \n',
    '+': u'        \n        \n        \n        \n   #    \n   #    \n   #    \n####### \n   #    \n   #    \n   #    \n        \n        \n',
    '/': u'        \n        \n        \n        \n      # \n     #  \n    #   \n   #    \n   #    \n  #     \n #      \n#       \n        \n',
    '3': u'       \n       \n       \n       \n  ###  \n #   # \n    ## \n  ##   \n    ## \n#   #  \n ###   \n       \n       \n',
    '7': u'       \n       \n       \n       \n ##### \n #   # \n    #  \n   #   \n  #    \n  #    \n##     \n       \n       \n',
    ';': u'    \n    \n    \n    \n    \n    \n ## \n    \n    \n    \n #  \n##  \n    \n',
    '?': u'     \n     \n     \n     \n ##  \n#  # \n   # \n ##  \n #   \n     \n#    \n     \n     \n',
    'C': u'       \n       \n       \n       \n   ### \n ##  # \n#      \n#      \n#      \n #  #  \n  ##   \n       \n       \n',
    'G': u'        \n        \n        \n        \n   #### \n ##   # \n#       \n#   ### \n#    #  \n #   #  \n  ###   \n        \n        \n',
    'K': u'        \n        \n        \n        \n ### ## \n  #  #  \n  ###   \n ###    \n # #    \n #  #   \n##  ##  \n        \n        \n',
    'O': u'        \n        \n        \n        \n   ##   \n ##  #  \n##    # \n#     # \n#     # \n #  ##  \n  ##    \n        \n        \n',
    'S': u'       \n       \n       \n       \n  #### \n #   # \n #     \n  ##   \n    #  \n#   #  \n ###   \n       \n       \n',
    'W': u'          \n          \n          \n          \n##  #  ## \n #  #  #  \n # ##  #  \n # ## #   \n ##  ##   \n ##  #    \n #   #    \n          \n          \n',
    '[': u'     \n     \n     \n     \n  ## \n #   \n #   \n #   \n #   \n#    \n#    \n##   \n     \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n##### \n',
    'c': u'     \n     \n     \n     \n     \n     \n  ## \n # # \n#    \n#  # \n ##  \n     \n     \n',
    'g': u'       \n       \n       \n       \n       \n       \n  ## # \n #  #  \n  ##   \n  #    \n## ##  \n#   #  \n ###   \n',
    'k': u'      \n      \n      \n ##   \n #    \n #    \n #  # \n ###  \n ##   \n#  #  \n#  ## \n      \n      \n',
    'o': u'     \n     \n     \n     \n     \n     \n  #  \n # # \n#  # \n# #  \n #   \n     \n     \n',
    's': u'     \n     \n     \n     \n     \n     \n  ## \n #   \n  #  \n#  # \n ##  \n     \n     \n',
    'w': u'        \n        \n        \n        \n        \n        \n## #  # \n # #  # \n ###  # \n ## ##  \n #  #   \n        \n        \n',
    '{': u'     \n     \n     \n     \n   # \n  #  \n  #  \n##   \n  #  \n  #  \n  #  \n   # \n     \n',
    '"': u'    \n    \n    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'       \n       \n       \n       \n  ##   \n #  #  \n # #   \n ##  # \n#  # # \n#  ##  \n ##  # \n       \n       \n',
    '*': u'     \n     \n     \n  #  \n# ## \n ##  \n# #  \n     \n     \n     \n     \n     \n     \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'      \n      \n      \n      \n  ##  \n #  # \n    # \n   #  \n  #   \n #  # \n####  \n      \n      \n',
    '6': u'      \n      \n      \n   ## \n  #   \n #    \n# ##  \n##  # \n#   # \n#  #  \n ##   \n      \n      \n',
    ':': u'   \n   \n   \n   \n   \n   \n # \n   \n   \n   \n#  \n   \n   \n',
    '>': u'       \n       \n       \n       \n       \n##     \n  ###  \n     # \n  ###  \n##     \n       \n       \n       \n',
    'B': u'       \n       \n       \n       \n ####  \n  #  # \n  # ## \n ####  \n #   # \n #  #  \n####   \n       \n       \n',
    'F': u'       \n       \n       \n       \n ##### \n  #  # \n  # #  \n ####  \n #  #  \n #     \n###    \n       \n       \n',
    'J': u'      \n      \n      \n      \n   ## \n   #  \n   #  \n   #  \n   #  \n# #   \n##    \n      \n      \n',
    'N': u'         \n         \n         \n         \n ##   ## \n  ##  #  \n # #  #  \n # ## #  \n #  # #  \n #  ##   \n##   #   \n         \n         \n',
    'R': u'        \n        \n        \n        \n ####   \n  #  #  \n  # ##  \n ###    \n #  #   \n #  #   \n###  ## \n        \n        \n',
    'V': u'        \n        \n        \n        \n##   ## \n #   #  \n #   #  \n #  #   \n # #    \n # #    \n  #     \n        \n        \n',
    'Z': u'       \n       \n       \n       \n ##### \n #  #  \n   #   \n   #   \n  #    \n #  #  \n#####  \n       \n       \n',
    '^': u'       \n       \n       \n  ##   \n #  #  \n#    # \n       \n       \n       \n       \n       \n       \n       \n',
    'b': u'      \n      \n      \n##    \n #    \n #    \n ###  \n #  # \n#   # \n#  #  \n ##   \n      \n      \n',
    'f': u'       \n       \n       \n    ## \n   # # \n   #   \n  ###  \n   #   \n  #    \n  #    \n  #    \n  #    \n##     \n',
    'j': u'     \n     \n     \n   # \n     \n     \n  ## \n   # \n  #  \n  #  \n  #  \n  #  \n##   \n',
    'n': u'       \n       \n       \n       \n       \n       \n## ##  \n ## #  \n #  #  \n#  #   \n#  ### \n       \n       \n',
    'r': u'     \n     \n     \n     \n     \n     \n#### \n # # \n #   \n#    \n#    \n     \n     \n',
    'v': u'      \n      \n      \n      \n      \n      \n##  # \n #  # \n # #  \n # #  \n ##   \n      \n      \n',
    'z': u'      \n      \n      \n      \n      \n      \n #### \n # #  \n  #   \n # ## \n####  \n      \n      \n',
    '~': u'       \n       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n       \n       \n',
    '!': u'    \n    \n    \n    \n  # \n ## \n #  \n #  \n #  \n    \n##  \n    \n    \n',
    '%': u'          \n          \n          \n  #    #  \n # #  #   \n#  # #    \n# # # ##  \n ## # # # \n   # #  # \n  #  # #  \n #    #   \n          \n          \n',
    ')': u'     \n     \n     \n  #  \n   # \n   # \n   # \n   # \n   # \n  #  \n  #  \n##   \n     \n',
    '-': u'   \n   \n   \n   \n   \n   \n   \n   \n## \n   \n   \n   \n   \n',
    '1': u'    \n    \n    \n    \n  # \n ## \n  # \n  # \n #  \n #  \n### \n    \n    \n',
    '5': u'       \n       \n       \n       \n  #### \n #     \n ###   \n    #  \n    #  \n#  #   \n###    \n       \n       \n',
    '9': u'      \n      \n      \n      \n  ##  \n #  # \n#   # \n#  ## \n ###  \n  ##  \n##    \n      \n      \n',
    '=': u'       \n       \n       \n       \n       \n       \n###### \n       \n###### \n       \n       \n       \n       \n',
    'A': u'        \n        \n        \n        \n    #   \n   # #  \n   # #  \n  #  #  \n  ####  \n #   #  \n##   ## \n        \n        \n',
    'E': u'       \n       \n       \n       \n ##### \n  #  # \n  # #  \n ####  \n #  #  \n #   # \n#####  \n       \n       \n',
    'I': u'     \n     \n     \n     \n ### \n  #  \n  #  \n  #  \n #   \n #   \n###  \n     \n     \n',
    'M': u'          \n          \n          \n          \n ##    ## \n  #   ##  \n # #  ##  \n # # # #  \n # ##  #  \n # ## #   \n## #  ##  \n          \n          \n',
    'Q': u'        \n        \n        \n        \n   ##   \n ##  #  \n##    # \n#     # \n#     # \n #   #  \n  ###   \n    ### \n        \n',
    'U': u'       \n       \n       \n       \n##  ## \n #  #  \n #  #  \n#   #  \n#   #  \n#  #   \n ##    \n       \n       \n',
    'Y': u'        \n        \n        \n        \n### ### \n #   #  \n #  #   \n  ##    \n  #     \n  #     \n ###    \n        \n        \n',
    ']': u'     \n     \n     \n     \n  ## \n   # \n   # \n  #  \n  #  \n  #  \n  #  \n##   \n     \n',
    'a': u'      \n      \n      \n      \n      \n      \n  ### \n #  # \n#   # \n#  #  \n #### \n      \n      \n',
    'e': u'     \n     \n     \n     \n     \n     \n  #  \n ### \n##   \n#  # \n ##  \n     \n     \n',
    'i': u'   \n   \n   \n # \n   \n   \n## \n#  \n#  \n#  \n## \n   \n   \n',
    'm': u'         \n         \n         \n         \n         \n         \n#### ##  \n # ## #  \n#  #  #  \n#  #  #  \n#  #  ## \n         \n         \n',
    'q': u'      \n      \n      \n      \n      \n      \n  ### \n #  # \n#   # \n#  #  \n ###  \n   #  \n  ### \n',
    'u': u'      \n      \n      \n      \n      \n      \n##  # \n #  # \n#  #  \n#  #  \n##### \n      \n      \n',
    'y': u'       \n       \n       \n       \n       \n       \n ##  # \n  # #  \n  # #  \n  ##   \n  ##   \n  #    \n##     \n',
    '}': u'     \n     \n     \n     \n#    \n #   \n #   \n  ## \n #   \n #   \n #   \n#    \n     \n'}

xcour_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'     \n     \n  #  \n ### \n#    \n ##  \n   # \n#  # \n ##  \n  #  \n     \n',
    '(': u'    \n    \n  # \n #  \n #  \n#   \n#   \n#   \n #  \n #  \n  # \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n # \n # \n#  \n',
    '0': u'     \n     \n ##  \n#  # \n#  # \n#  # \n#  # \n#  # \n ##  \n     \n     \n',
    '4': u'      \n      \n   #  \n  ##  \n # #  \n#  #  \n##### \n   #  \n   #  \n      \n      \n',
    '8': u'     \n     \n ##  \n#  # \n#  # \n ##  \n#  # \n#  # \n ##  \n     \n     \n',
    '<': u'    \n    \n    \n  # \n #  \n#   \n #  \n  # \n    \n    \n    \n',
    '@': u'       \n       \n  ##   \n #  #  \n#  ##  \n# # #  \n# # #  \n#  ### \n#      \n ####  \n       \n',
    'D': u'      \n      \n      \n####  \n #  # \n #  # \n #  # \n #  # \n####  \n      \n      \n',
    'H': u'       \n       \n       \n##  ## \n #  #  \n ####  \n #  #  \n #  #  \n##  ## \n       \n       \n',
    'L': u'      \n      \n      \n###   \n #    \n #    \n #    \n #  # \n##### \n      \n      \n',
    'P': u'      \n      \n      \n####  \n #  # \n #  # \n ###  \n #    \n###   \n      \n      \n',
    'T': u'      \n      \n      \n##### \n# # # \n  #   \n  #   \n  #   \n ###  \n      \n      \n',
    'X': u'      \n      \n      \n## ## \n # #  \n  #   \n  #   \n # #  \n## ## \n      \n      \n',
    '\\': u'      \n      \n#     \n #    \n #    \n  #   \n  #   \n   #  \n   #  \n    # \n      \n',
    '`': u'   \n   \n#  \n#  \n # \n   \n   \n   \n   \n   \n   \n',
    'd': u'      \n      \n  ##  \n   #  \n ###  \n#  #  \n#  #  \n#  #  \n ## # \n      \n      \n',
    'h': u'       \n       \n##     \n #     \n ###   \n #  #  \n #  #  \n #  #  \n### ## \n       \n       \n',
    'l': u'      \n      \n ##   \n  #   \n  #   \n  #   \n  #   \n  #   \n##### \n      \n      \n',
    'p': u'      \n      \n      \n      \n# ##  \n #  # \n #  # \n #  # \n ###  \n #    \n###   \n',
    't': u'      \n      \n #    \n #    \n####  \n #    \n #    \n #  # \n  ##  \n      \n      \n',
    'x': u'      \n      \n      \n      \n## ## \n # #  \n  #   \n # #  \n## ## \n      \n      \n',
    '|': u'  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'       \n       \n  # #  \n  # #  \n ##### \n  # #  \n###### \n # #   \n # #   \n       \n       \n',
    "'": u'   \n   \n # \n # \n#  \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n      \n',
    '/': u'      \n      \n    # \n   #  \n   #  \n  #   \n  #   \n #    \n #    \n#     \n      \n',
    '3': u'     \n     \n ##  \n#  # \n   # \n ##  \n   # \n#  # \n ##  \n     \n     \n',
    '7': u'     \n     \n#### \n#  # \n   # \n  #  \n  #  \n #   \n #   \n     \n     \n',
    ';': u'   \n   \n   \n   \n   \n # \n   \n   \n # \n # \n#  \n',
    '?': u'     \n     \n     \n ##  \n#  # \n  #  \n #   \n     \n #   \n     \n     \n',
    'C': u'     \n     \n     \n ##  \n#  # \n#    \n#    \n#  # \n ##  \n     \n     \n',
    'G': u'     \n     \n     \n ##  \n#  # \n#    \n# ## \n#  # \n ##  \n     \n     \n',
    'K': u'       \n       \n       \n## ##  \n # #   \n ##    \n # #   \n #  #  \n###  # \n       \n       \n',
    'O': u'     \n     \n     \n ##  \n#  # \n#  # \n#  # \n#  # \n ##  \n     \n     \n',
    'S': u'     \n     \n     \n ### \n#    \n ##  \n   # \n#  # \n###  \n     \n     \n',
    'W': u'        \n        \n        \n### ### \n #   #  \n # # #  \n # # #  \n  # #   \n  # #   \n        \n        \n',
    '[': u'   \n   \n## \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n## \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n',
    'c': u'     \n     \n     \n     \n ##  \n#  # \n#    \n#  # \n ##  \n     \n     \n',
    'g': u'      \n      \n      \n      \n ## # \n#  #  \n#  #  \n#  #  \n ###  \n   #  \n###   \n',
    'k': u'      \n      \n##    \n #    \n # ## \n # #  \n ##   \n # #  \n## ## \n      \n      \n',
    'o': u'     \n     \n     \n     \n ##  \n#  # \n#  # \n#  # \n ##  \n     \n     \n',
    's': u'     \n     \n     \n     \n ### \n#    \n ##  \n   # \n###  \n     \n     \n',
    'w': u'       \n       \n       \n       \n# # ## \n# # #  \n# # #  \n # #   \n # #   \n       \n       \n',
    '{': u'    \n    \n  # \n #  \n #  \n #  \n#   \n #  \n #  \n #  \n  # \n',
    '"': u'    \n    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n',
    '&': u'       \n       \n       \n  ##   \n #     \n ##    \n#  # # \n#   #  \n ### # \n       \n       \n',
    '*': u'      \n      \n  #   \n## ## \n  #   \n # #  \n      \n      \n      \n      \n      \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'     \n     \n ##  \n#  # \n   # \n  #  \n #   \n#    \n#### \n     \n     \n',
    '6': u'     \n     \n ### \n#    \n#    \n###  \n#  # \n#  # \n ##  \n     \n     \n',
    ':': u'  \n  \n  \n  \n  \n# \n  \n  \n# \n  \n  \n',
    '>': u'    \n    \n    \n#   \n #  \n  # \n #  \n#   \n    \n    \n    \n',
    'B': u'      \n      \n      \n####  \n #  # \n ###  \n #  # \n #  # \n####  \n      \n      \n',
    'F': u'      \n      \n      \n##### \n #  # \n ###  \n # #  \n #    \n###   \n      \n      \n',
    'J': u'      \n      \n      \n #### \n   #  \n   #  \n#  #  \n#  #  \n ##   \n      \n      \n',
    'N': u'      \n      \n      \n## ## \n #  # \n ## # \n # ## \n #  # \n##  # \n      \n      \n',
    'R': u'       \n       \n       \n####   \n #  #  \n #  #  \n ###   \n #  #  \n###  # \n       \n       \n',
    'V': u'      \n      \n      \n## ## \n#   # \n # #  \n # #  \n # #  \n  #   \n      \n      \n',
    'Z': u'     \n     \n     \n#### \n#  # \n  #  \n #   \n#  # \n#### \n     \n     \n',
    '^': u'      \n      \n  #   \n # #  \n#   # \n      \n      \n      \n      \n      \n      \n',
    'b': u'      \n      \n##    \n #    \n ###  \n #  # \n #  # \n #  # \n####  \n      \n      \n',
    'f': u'     \n     \n  ## \n #   \n#### \n #   \n #   \n #   \n#### \n     \n     \n',
    'j': u'    \n    \n  # \n    \n### \n  # \n  # \n  # \n  # \n  # \n##  \n',
    'n': u'       \n       \n       \n       \n# ##   \n #  #  \n #  #  \n #  #  \n### ## \n       \n       \n',
    'r': u'      \n      \n      \n      \n# ### \n #    \n #    \n #    \n####  \n      \n      \n',
    'v': u'       \n       \n       \n       \n##  ## \n #   # \n  # #  \n  # #  \n   #   \n       \n       \n',
    'z': u'     \n     \n     \n     \n#### \n  #  \n #   \n#  # \n#### \n     \n     \n',
    '~': u'     \n     \n     \n     \n # # \n# #  \n     \n     \n     \n     \n     \n',
    '!': u'  \n  \n# \n# \n# \n# \n# \n  \n# \n  \n  \n',
    '%': u'       \n       \n       \n ##    \n# # #  \n## #   \n  # ## \n # # # \n   ##  \n       \n       \n',
    ')': u'    \n    \n#   \n #  \n #  \n  # \n  # \n  # \n #  \n #  \n#   \n',
    '-': u'     \n     \n     \n     \n     \n#### \n     \n     \n     \n     \n     \n',
    '1': u'     \n     \n  #  \n###  \n  #  \n  #  \n  #  \n  #  \n#### \n     \n     \n',
    '5': u'     \n     \n#### \n#    \n#    \n###  \n   # \n   # \n###  \n     \n     \n',
    '9': u'     \n     \n ##  \n#  # \n#  # \n ### \n   # \n   # \n###  \n     \n     \n',
    '=': u'     \n     \n     \n     \n#### \n     \n#### \n     \n     \n     \n     \n',
    'A': u'       \n       \n       \n ###   \n  # #  \n #  #  \n ####  \n #  #  \n##  ## \n       \n       \n',
    'E': u'      \n      \n      \n##### \n #  # \n ###  \n #    \n #  # \n##### \n      \n      \n',
    'I': u'      \n      \n      \n##### \n  #   \n  #   \n  #   \n  #   \n##### \n      \n      \n',
    'M': u'      \n      \n      \n#   # \n## ## \n# # # \n# # # \n#   # \n## ## \n      \n      \n',
    'Q': u'     \n     \n     \n ##  \n#  # \n#  # \n#  # \n#  # \n ##  \n   # \n     \n',
    'U': u'       \n       \n       \n##  ## \n #  #  \n #  #  \n #  #  \n #  #  \n  ##   \n       \n       \n',
    'Y': u'      \n      \n      \n## ## \n#   # \n # #  \n  #   \n  #   \n ###  \n      \n      \n',
    ']': u'   \n   \n## \n # \n # \n # \n # \n # \n # \n # \n## \n',
    'a': u'      \n      \n      \n      \n ##   \n   #  \n ###  \n#  #  \n ## # \n      \n      \n',
    'e': u'     \n     \n     \n     \n ##  \n#  # \n###  \n#    \n ### \n     \n     \n',
    'i': u'      \n      \n  #   \n      \n ##   \n  #   \n  #   \n  #   \n##### \n      \n      \n',
    'm': u'       \n       \n       \n       \n## #   \n# # #  \n# # #  \n# # #  \n# # ## \n       \n       \n',
    'q': u'      \n      \n      \n      \n ## # \n#  #  \n#  #  \n#  #  \n ###  \n   #  \n  ### \n',
    'u': u'       \n       \n       \n       \n## ##  \n #  #  \n #  #  \n #  #  \n  ## # \n       \n       \n',
    'y': u'      \n      \n      \n      \n## ## \n #  # \n #  # \n #  # \n  ##  \n  #   \n##    \n',
    '}': u'    \n    \n#   \n #  \n #  \n #  \n  # \n #  \n #  \n #  \n#   \n'}

xcourb_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'      \n      \n  #   \n #### \n##  # \n####  \n  ### \n#  ## \n####  \n  #   \n      \n',
    '(': u'    \n    \n  # \n #  \n##  \n##  \n##  \n##  \n #  \n  # \n    \n',
    ',': u'    \n    \n    \n    \n    \n    \n    \n    \n ## \n  # \n##  \n',
    '0': u'      \n      \n ###  \n## ## \n## ## \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    '4': u'       \n       \n   ##  \n  ###  \n # ##  \n## ##  \n###### \n   ##  \n   ##  \n       \n       \n',
    '8': u'      \n      \n ###  \n## ## \n## ## \n ###  \n## ## \n## ## \n ###  \n      \n      \n',
    '<': u'     \n     \n     \n  ## \n ##  \n##   \n ##  \n  ## \n     \n     \n     \n',
    '@': u'       \n       \n ###   \n##  #  \n#  ##  \n# # #  \n# # #  \n#  ### \n##     \n ###   \n       \n',
    'D': u'       \n       \n       \n#####  \n ## ## \n ## ## \n ## ## \n ## ## \n#####  \n       \n       \n',
    'H': u'       \n       \n       \n### ## \n ## ## \n ##### \n ## ## \n ## ## \n ## ## \n       \n       \n',
    'L': u'       \n       \n       \n####   \n ##    \n ##    \n ##    \n ## ## \n###### \n       \n       \n',
    'P': u'       \n       \n       \n#####  \n ## ## \n ## ## \n ####  \n ##    \n####   \n       \n       \n',
    'T': u'       \n       \n       \n###### \n# ## # \n  ##   \n  ##   \n  ##   \n ####  \n       \n       \n',
    'X': u'       \n       \n       \n##  ## \n ####  \n  ##   \n  ##   \n ####  \n##  ## \n       \n       \n',
    '\\': u'     \n     \n#    \n##   \n##   \n ##  \n ##  \n  ## \n  ## \n   # \n     \n',
    '`': u'   \n   \n#  \n## \n # \n   \n   \n   \n   \n   \n   \n',
    'd': u'       \n       \n  ###  \n   ##  \n ####  \n## ##  \n## ##  \n## ##  \n ##### \n       \n       \n',
    'h': u'       \n       \n###    \n ##    \n ####  \n ## ## \n ## ## \n ## ## \n ## ## \n       \n       \n',
    'l': u'       \n       \n ###   \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n###### \n       \n       \n',
    'p': u'       \n       \n       \n       \n#####  \n ## ## \n ## ## \n ## ## \n ####  \n ##    \n####   \n',
    't': u'       \n       \n ##    \n ##    \n#####  \n ##    \n ##    \n ## ## \n  ###  \n       \n       \n',
    'x': u'       \n       \n       \n       \n### ## \n ####  \n  ##   \n ####  \n## ### \n       \n       \n',
    '|': u'   \n   \n## \n## \n## \n## \n## \n## \n## \n## \n## \n',
    '#': u'      \n      \n # #  \n # #  \n##### \n # #  \n##### \n # #  \n # #  \n      \n      \n',
    "'": u'   \n   \n # \n## \n#  \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n      \n',
    '/': u'     \n     \n   # \n  ## \n  ## \n ##  \n ##  \n##   \n##   \n#    \n     \n',
    '3': u'      \n      \n ###  \n## ## \n   ## \n ###  \n   ## \n## ## \n ###  \n      \n      \n',
    '7': u'      \n      \n##### \n## ## \n   ## \n  ##  \n  ##  \n ##   \n ##   \n      \n      \n',
    ';': u'    \n    \n    \n    \n    \n ## \n    \n    \n ## \n  # \n##  \n',
    '?': u'      \n      \n      \n ###  \n#  ## \n  ##  \n ##   \n      \n ##   \n      \n      \n',
    'C': u'      \n      \n      \n #### \n## ## \n##    \n##    \n## ## \n ###  \n      \n      \n',
    'G': u'      \n      \n      \n ###  \n## ## \n##    \n##### \n## ## \n #### \n      \n      \n',
    'K': u'        \n        \n        \n### ##  \n ## #   \n ###    \n ####   \n ## ##  \n#### ## \n        \n        \n',
    'O': u'      \n      \n      \n ###  \n## ## \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    'S': u'      \n      \n      \n #### \n##  # \n####  \n  ### \n#  ## \n####  \n      \n      \n',
    'W': u'        \n        \n        \n## # ## \n # # #  \n #####  \n #####  \n  ###   \n  # #   \n        \n        \n',
    '[': u'    \n    \n### \n##  \n##  \n##  \n##  \n##  \n##  \n### \n    \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n',
    'c': u'      \n      \n      \n      \n ###  \n## ## \n##    \n## ## \n ###  \n      \n      \n',
    'g': u'       \n       \n       \n       \n ## ## \n## ##  \n## ##  \n## ##  \n ####  \n   ##  \n####   \n',
    'k': u'        \n        \n###     \n ##     \n ## ##  \n ####   \n ###    \n ####   \n ## ### \n        \n        \n',
    'o': u'      \n      \n      \n      \n ###  \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    's': u'       \n       \n       \n       \n ####  \n###    \n ####  \n   ### \n#####  \n       \n       \n',
    'w': u'        \n        \n        \n        \n## # ## \n # # #  \n #####  \n  ####  \n  # #   \n        \n        \n',
    '{': u'     \n     \n  ## \n ##  \n ##  \n##   \n ##  \n ##  \n ##  \n  ## \n     \n',
    '"': u'    \n    \n    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n',
    '&': u'       \n       \n       \n  ###  \n ##    \n  ##   \n ##### \n## ##  \n ##### \n       \n       \n',
    '*': u'     \n     \n  #  \n#### \n ##  \n#  # \n     \n     \n     \n     \n     \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n   \n## \n   \n   \n',
    '2': u'      \n      \n ###  \n## ## \n   ## \n  ##  \n ##   \n## ## \n##### \n      \n      \n',
    '6': u'      \n      \n ###  \n## ## \n##    \n####  \n## ## \n## ## \n ###  \n      \n      \n',
    ':': u'   \n   \n   \n   \n   \n## \n   \n   \n## \n   \n   \n',
    '>': u'     \n     \n     \n##   \n ##  \n  ## \n ##  \n##   \n     \n     \n     \n',
    'B': u'       \n       \n       \n#####  \n ## ## \n ####  \n ## ## \n ## ## \n#####  \n       \n       \n',
    'F': u'       \n       \n       \n###### \n ##  # \n ####  \n ##    \n ##    \n####   \n       \n       \n',
    'J': u'       \n       \n       \n ##### \n   ##  \n   ##  \n## ##  \n## ##  \n ###   \n       \n       \n',
    'N': u'        \n        \n        \n### ### \n ##  #  \n ### #  \n #####  \n ## ##  \n### ##  \n        \n        \n',
    'R': u'        \n        \n        \n#####   \n ## ##  \n ## ##  \n ####   \n ## ##  \n#### ## \n        \n        \n',
    'V': u'        \n        \n        \n### ### \n ## ##  \n  # #   \n  ###   \n  ###   \n   #    \n        \n        \n',
    'Z': u'      \n      \n      \n##### \n## ## \n  ##  \n ##   \n## ## \n##### \n      \n      \n',
    '^': u'       \n       \n  ##   \n ####  \n##  ## \n       \n       \n       \n       \n       \n       \n',
    'b': u'       \n       \n###    \n ##    \n ####  \n ## ## \n ## ## \n ## ## \n#####  \n       \n       \n',
    'f': u'      \n      \n  ### \n ##   \n##### \n ##   \n ##   \n ##   \n####  \n      \n      \n',
    'j': u'     \n     \n  ## \n     \n#### \n  ## \n  ## \n  ## \n  ## \n  ## \n###  \n',
    'n': u'       \n       \n       \n       \n## ##  \n ## ## \n ## ## \n ## ## \n ## ## \n       \n       \n',
    'r': u'       \n       \n       \n       \n## ### \n ### # \n ##    \n ##    \n####   \n       \n       \n',
    'v': u'       \n       \n       \n       \n### ## \n ## ## \n  ###  \n  ###  \n   #   \n       \n       \n',
    'z': u'       \n       \n       \n       \n ##### \n   ##  \n  ##   \n ## ## \n###### \n       \n       \n',
    '~': u'      \n      \n      \n      \n ## # \n# ##  \n      \n      \n      \n      \n      \n',
    '!': u'   \n   \n## \n## \n## \n## \n## \n   \n## \n   \n   \n',
    '%': u'      \n      \n      \n###   \n# # # \n####  \n #### \n# # # \n  ### \n      \n      \n',
    ')': u'    \n    \n#   \n #  \n ## \n ## \n ## \n ## \n #  \n#   \n    \n',
    '-': u'      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'       \n       \n  ##   \n####   \n  ##   \n  ##   \n  ##   \n  ##   \n###### \n       \n       \n',
    '5': u'      \n      \n##### \n##    \n####  \n## ## \n   ## \n#  ## \n####  \n      \n      \n',
    '9': u'      \n      \n ###  \n## ## \n## ## \n #### \n   ## \n## ## \n ###  \n      \n      \n',
    '=': u'      \n      \n      \n      \n##### \n      \n##### \n      \n      \n      \n      \n',
    'A': u'        \n        \n        \n ####   \n  ###   \n  # #   \n #####  \n ## ##  \n### ### \n        \n        \n',
    'E': u'       \n       \n       \n###### \n ##  # \n ####  \n ##    \n ## ## \n###### \n       \n       \n',
    'I': u'     \n     \n     \n#### \n ##  \n ##  \n ##  \n ##  \n#### \n     \n     \n',
    'M': u'       \n       \n       \n##   # \n ## ## \n ## ## \n ##### \n # # # \n## # # \n       \n       \n',
    'Q': u'      \n      \n      \n ###  \n## ## \n## ## \n## ## \n## ## \n ###  \n   ## \n      \n',
    'U': u'        \n        \n        \n### ### \n ## ##  \n ## ##  \n ## ##  \n ## ##  \n  ###   \n        \n        \n',
    'Y': u'        \n        \n        \n###  ## \n ##  ## \n  ####  \n   ##   \n   ##   \n  ####  \n        \n        \n',
    ']': u'    \n    \n### \n ## \n ## \n ## \n ## \n ## \n ## \n### \n    \n',
    'a': u'       \n       \n       \n       \n ###   \n## ##  \n ####  \n## ##  \n###### \n       \n       \n',
    'e': u'      \n      \n      \n      \n ###  \n## ## \n##### \n##    \n #### \n      \n      \n',
    'i': u'       \n       \n  ##   \n       \n ###   \n  ##   \n  ##   \n  ##   \n###### \n       \n       \n',
    'm': u'       \n       \n       \n       \n#####  \n ##### \n # # # \n # # # \n # # # \n       \n       \n',
    'q': u'       \n       \n       \n       \n ## ## \n## ##  \n## ##  \n## ##  \n ####  \n   ##  \n  #### \n',
    'u': u'        \n        \n        \n        \n### ##  \n ## ##  \n ## ##  \n ## ##  \n  ##### \n        \n        \n',
    'y': u'        \n        \n        \n        \n### ### \n ## ##  \n ## ##  \n  # #   \n  ###   \n  ##    \n####    \n',
    '}': u'     \n     \n##   \n ##  \n ##  \n  ## \n ##  \n ##  \n ##  \n##   \n     \n'}

xcourbi_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'       \n       \n    #  \n  #### \n ##  # \n ###   \n   ##  \n#  ##  \n####   \n  #    \n       \n',
    '(': u'      \n      \n    # \n  ##  \n ##   \n #    \n##    \n##    \n #    \n ##   \n  #   \n',
    ',': u'    \n    \n    \n    \n    \n    \n    \n    \n ## \n  # \n##  \n',
    '0': u'       \n       \n  ###  \n ## ## \n #  ## \n##  #  \n##  #  \n## #   \n ##    \n       \n       \n',
    '4': u'      \n      \n   ## \n  ### \n # #  \n#  #  \n##### \n####  \n  #   \n      \n      \n',
    '8': u'       \n       \n  ###  \n #  ## \n ## #  \n ###   \n## ##  \n#  ##  \n ###   \n       \n       \n',
    '<': u'      \n      \n      \n   ## \n ##   \n##    \n ##   \n  #   \n      \n      \n      \n',
    '@': u'       \n       \n  ###  \n #   # \n#  ### \n# # #  \n# # #  \n#  ### \n##     \n ###   \n       \n',
    'D': u'        \n        \n        \n #####  \n  ## ## \n  #   # \n ##  ## \n #  ##  \n#####   \n        \n        \n',
    'H': u'         \n         \n         \n  ### ## \n  ##  #  \n  #####  \n ##  #   \n ## ##   \n### ##   \n         \n         \n',
    'L': u'      \n      \n      \n  ### \n  ##  \n  ##  \n ##   \n ## # \n##### \n      \n      \n',
    'P': u'       \n       \n       \n ####  \n  ## # \n  #  # \n ####  \n ##    \n###    \n       \n       \n',
    'T': u'        \n        \n        \n ###### \n#  # #  \n  ##    \n  ##    \n ##     \n####    \n        \n        \n',
    'X': u'        \n        \n        \n #### # \n  ## #  \n   ##   \n  ###   \n ## #   \n##  ##  \n        \n        \n',
    '\\': u'     \n     \n#    \n#    \n #   \n #   \n  #  \n  #  \n   # \n   # \n     \n',
    '`': u'   \n   \n#  \n#  \n # \n   \n   \n   \n   \n   \n   \n',
    'd': u'        \n        \n    ### \n     ## \n  ####  \n ## ##  \n##  ##  \n## ##   \n #####  \n        \n        \n',
    'h': u'       \n       \n ###   \n  ##   \n  # ## \n ##### \n ## ## \n##  #  \n## ### \n       \n       \n',
    'l': u'       \n       \n   ### \n    ## \n   ##  \n   ##  \n  ##   \n  ##   \n#####  \n       \n       \n',
    'p': u'        \n        \n        \n        \n #####  \n  ## ## \n  #  ## \n ## ##  \n ####   \n ##     \n####    \n',
    't': u'      \n      \n  ##  \n ##   \n##### \n ##   \n##    \n## ## \n ###  \n      \n      \n',
    'x': u'        \n        \n        \n        \n ##  ## \n  ####  \n  ###   \n ## ##  \n##  ### \n        \n        \n',
    '|': u'    \n    \n  # \n  # \n  # \n #  \n #  \n#   \n#   \n#   \n    \n',
    '#': u'        \n        \n   # #  \n   # #  \n ###### \n  # #   \n######  \n # #    \n # #    \n        \n        \n',
    "'": u'   \n   \n # \n # \n#  \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n   #  \n  #   \n##### \n  #   \n #    \n      \n      \n      \n',
    '/': u'     \n     \n   # \n   # \n  #  \n  #  \n #   \n #   \n#    \n#    \n     \n',
    '3': u'       \n       \n  ###  \n #  ## \n   ##  \n  ##   \n   ##  \n#  ##  \n####   \n       \n       \n',
    '7': u'      \n      \n##### \n## ## \n  ##  \n ##   \n #    \n##    \n##    \n      \n      \n',
    ';': u'     \n     \n     \n     \n     \n  ## \n     \n     \n ##  \n  #  \n##   \n',
    '?': u'      \n      \n ###  \n#  ## \n  ##  \n ##   \n##    \n      \n##    \n      \n      \n',
    'C': u'       \n       \n       \n  #### \n ##  # \n##     \n##     \n## ##  \n ###   \n       \n       \n',
    'G': u'       \n       \n       \n  #### \n ##  # \n##     \n## ### \n##  #  \n ####  \n       \n       \n',
    'K': u'         \n         \n         \n  ### ## \n   # #   \n  ###    \n  ###    \n ## ##   \n#### ##  \n         \n         \n',
    'O': u'       \n       \n       \n  ###  \n ## ## \n #   # \n##  ## \n##  #  \n ###   \n       \n       \n',
    'S': u'       \n       \n       \n  #### \n ##  # \n ####  \n   ### \n##  #  \n####   \n       \n       \n',
    'W': u'        \n        \n        \n##   ## \n # # #  \n # # #  \n #####  \n ####   \n # #    \n        \n        \n',
    '[': u'       \n       \n  #### \n  ##   \n  ##   \n ##    \n ##    \n ##    \n##     \n##     \n####   \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n',
    'c': u'       \n       \n       \n       \n  ###  \n ## ## \n##     \n## ##  \n ###   \n       \n       \n',
    'g': u'       \n       \n       \n       \n  ## # \n ## ## \n##  ## \n## ##  \n ####  \n   #   \n###    \n',
    'k': u'         \n         \n  ###    \n   ##    \n  ## ### \n  # ##   \n  ###    \n ## #    \n### ##   \n         \n         \n',
    'o': u'       \n       \n       \n       \n  ###  \n ## ## \n##  ## \n## ##  \n ###   \n       \n       \n',
    's': u'       \n       \n       \n       \n  #### \n ##  # \n ####  \n#  ##  \n####   \n       \n       \n',
    'w': u'        \n        \n        \n        \n## # ## \n # # #  \n #####  \n ####   \n # #    \n        \n        \n',
    '{': u'       \n       \n    ## \n   #   \n  ##   \n ###   \n##     \n ##    \n ##    \n #     \n  ##   \n',
    '"': u'     \n     \n # # \n # # \n# #  \n     \n     \n     \n     \n     \n     \n',
    '&': u'       \n       \n       \n   ### \n  ## # \n  ##   \n ##### \n## ##  \n ##### \n       \n       \n',
    '*': u'      \n      \n  #   \n##### \n ##   \n# ##  \n      \n      \n      \n      \n      \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n   \n## \n   \n   \n',
    '2': u'        \n        \n   ###  \n  ## ## \n     ## \n    ##  \n  ##    \n ##  #  \n######  \n        \n        \n',
    '6': u'      \n      \n  ### \n ## # \n #    \n##### \n### # \n##  # \n ###  \n      \n      \n',
    ':': u'    \n    \n    \n    \n    \n ## \n    \n    \n##  \n    \n    \n',
    '>': u'      \n      \n      \n  #   \n  ##  \n   ## \n  ##  \n##    \n      \n      \n      \n',
    'B': u'       \n       \n       \n ####  \n  #  # \n ##### \n ## #  \n##  ## \n#####  \n       \n       \n',
    'F': u'        \n        \n        \n #####  \n  #  ## \n ####   \n ## #   \n##      \n###     \n        \n        \n',
    'J': u'       \n       \n       \n  #### \n   ##  \n   ##  \n#  #   \n# ##   \n###    \n       \n       \n',
    'N': u'        \n        \n        \n ### ## \n  ## #  \n ### #  \n # ##   \n## ##   \n## ##   \n        \n        \n',
    'R': u'       \n       \n       \n ####  \n  # ## \n ## ## \n ###   \n## ##  \n##  ## \n       \n       \n',
    'V': u'       \n       \n       \n### ## \n #  ## \n # ##  \n ###   \n ##    \n #     \n       \n       \n',
    'Z': u'       \n       \n       \n  #### \n #  ## \n   ##  \n  ##   \n ## #  \n#####  \n       \n       \n',
    '^': u'       \n       \n  ##   \n # ##  \n#   ## \n       \n       \n       \n       \n       \n       \n',
    'b': u'       \n       \n ###   \n  ##   \n  ###  \n ## ## \n #  ## \n## ##  \n####   \n       \n       \n',
    'f': u'        \n        \n    ### \n   ##   \n #####  \n  ##    \n  ##    \n ##     \n#####   \n        \n        \n',
    'j': u'        \n        \n     ## \n        \n  ####  \n    ##  \n    #   \n   ##   \n   ##   \n  ##    \n###     \n',
    'n': u'       \n       \n       \n       \n## ##  \n ## ## \n ## #  \n## ##  \n## ### \n       \n       \n',
    'r': u'        \n        \n        \n        \n ### ## \n  ###   \n  ##    \n ##     \n####    \n        \n        \n',
    'v': u'        \n        \n        \n        \n### ### \n ##  #  \n ####   \n  ##    \n  #     \n        \n        \n',
    'z': u'        \n        \n        \n        \n  ##### \n #  ##  \n  ###   \n ##  ## \n######  \n        \n        \n',
    '~': u'      \n      \n      \n      \n ## # \n# ##  \n      \n      \n      \n      \n      \n',
    '!': u'     \n     \n  ## \n  ## \n  #  \n ##  \n ##  \n     \n##   \n     \n     \n',
    '%': u'       \n       \n  ##   \n # # # \n ## #  \n  ##   \n # ##  \n# # #  \n  ##   \n       \n       \n',
    ')': u'      \n      \n  #   \n  ##  \n   #  \n   ## \n   ## \n   #  \n  ##  \n ##   \n#     \n',
    '-': u'      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'       \n       \n    ## \n  #### \n   ##  \n   ##  \n  ##   \n  ##   \n#####  \n       \n       \n',
    '5': u'       \n       \n  #### \n ##    \n ###   \n   ##  \n   ##  \n#  ##  \n###    \n       \n       \n',
    '9': u'       \n       \n  ###  \n ## ## \n #  ## \n ##### \n   ##  \n#  ##  \n ##    \n       \n       \n',
    '=': u'      \n      \n      \n      \n #### \n      \n####  \n      \n      \n      \n      \n',
    'A': u'        \n        \n        \n   ###  \n    ##  \n   # #  \n  ## #  \n ## ##  \n###  ## \n        \n        \n',
    'E': u'       \n       \n       \n ##### \n  #  # \n ####  \n ##    \n##  #  \n#####  \n       \n       \n',
    'I': u'        \n        \n        \n  ##### \n   ##   \n   ##   \n  ##    \n  ##    \n#####   \n        \n        \n',
    'M': u'         \n         \n         \n  ##  ## \n  #####  \n  # # #  \n ##  #   \n ##  #   \n### ###  \n         \n         \n',
    'Q': u'       \n       \n       \n  ###  \n ## ## \n##   # \n##  ## \n##  #  \n ###   \n   ##  \n       \n',
    'U': u'        \n        \n        \n ### ## \n ##  #  \n ## ##  \n##  #   \n##  #   \n ###    \n        \n        \n',
    'Y': u'       \n       \n       \n#### # \n ## #  \n  ##   \n ##    \n ##    \n####   \n       \n       \n',
    ']': u'       \n       \n   ### \n    ## \n   ##  \n   ##  \n   ##  \n  ##   \n  ##   \n  ##   \n###    \n',
    'a': u'       \n       \n       \n       \n  ###  \n    ## \n ##### \n## ##  \n###### \n       \n       \n',
    'e': u'       \n       \n       \n       \n  ###  \n ## ## \n###### \n##     \n ####  \n       \n       \n',
    'i': u'       \n       \n    ## \n       \n  ###  \n   ##  \n   #   \n  ##   \n###### \n       \n       \n',
    'm': u'        \n        \n        \n        \n #####  \n  # # # \n  # # # \n # # #  \n## # ## \n        \n        \n',
    'q': u'        \n        \n        \n        \n  ## ## \n ## ##  \n##  ##  \n##  #   \n ####   \n   ##   \n  ###   \n',
    'u': u'       \n       \n       \n       \n### ## \n ## ## \n##  #  \n## ##  \n ##### \n       \n       \n',
    'y': u'          \n          \n          \n          \n  ### ### \n   ## ##  \n   ## #   \n   ###    \n   ##     \n   #      \n###       \n',
    '}': u'       \n       \n  ##   \n    #  \n   ##  \n   ##  \n    ## \n   #   \n  ##   \n  ##   \n##     \n'}

xcouri_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'       \n       \n    #  \n  #### \n #   # \n  ##   \n    #  \n#   #  \n####   \n  #    \n       \n',
    '(': u'     \n     \n   # \n  #  \n #   \n #   \n#    \n#    \n#    \n #   \n     \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n # \n # \n#  \n',
    '0': u'      \n      \n  ##  \n #  # \n #  # \n#   # \n#  #  \n#  #  \n ##   \n      \n      \n',
    '4': u'      \n      \n   ## \n  # # \n # #  \n#  #  \n##### \n  #   \n ##   \n      \n      \n',
    '8': u'      \n      \n  ##  \n #  # \n #  # \n ###  \n#  #  \n#  #  \n ##   \n      \n      \n',
    '<': u'     \n     \n     \n   # \n ##  \n#    \n #   \n  #  \n     \n     \n     \n',
    '@': u'       \n       \n  ###  \n #   # \n#  ### \n# # #  \n# ###  \n#      \n ###   \n       \n       \n',
    'D': u'       \n       \n       \n ####  \n  #  # \n  #  # \n #   # \n #  #  \n####   \n       \n       \n',
    'H': u'        \n        \n        \n  ## ## \n  #  #  \n  ####  \n #   #  \n #  #   \n##  #   \n        \n        \n',
    'L': u'      \n      \n      \n  ##  \n  #   \n  #   \n #    \n #  # \n####  \n      \n      \n',
    'P': u'       \n       \n       \n ####  \n  #  # \n  #  # \n # ##  \n #     \n###    \n       \n       \n',
    'T': u'        \n        \n        \n ###### \n#  #  # \n   #    \n  #     \n  #     \n ###    \n        \n        \n',
    'X': u'       \n       \n       \n ## ## \n  # #  \n  ##   \n  ##   \n # #   \n## ##  \n       \n       \n',
    '\\': u'   \n   \n#  \n#  \n#  \n#  \n # \n # \n # \n # \n   \n',
    '`': u'   \n   \n#  \n#  \n # \n   \n   \n   \n   \n   \n   \n',
    'd': u'       \n       \n    ## \n     # \n  ###  \n #  #  \n#   #  \n#  #   \n ## #  \n       \n       \n',
    'h': u'       \n       \n  ##   \n   #   \n  # #  \n  #  # \n #   # \n #  #  \n### ## \n       \n       \n',
    'l': u'      \n      \n   ## \n    # \n   #  \n   #  \n   #  \n  #   \n##### \n      \n      \n',
    'p': u'       \n       \n       \n       \n # ##  \n  #  # \n  #  # \n #   # \n ####  \n #     \n##     \n',
    't': u'      \n      \n   #  \n  #   \n##### \n  #   \n #    \n #  # \n  ##  \n      \n      \n',
    'x': u'       \n       \n       \n       \n ## ## \n  # #  \n  #    \n # #   \n## ##  \n       \n       \n',
    '|': u'    \n    \n  # \n  # \n #  \n #  \n #  \n #  \n#   \n#   \n    \n',
    '#': u'        \n        \n   # #  \n   # #  \n ###### \n  # #   \n######  \n # #    \n # #    \n        \n        \n',
    "'": u'   \n   \n # \n # \n#  \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n   #  \n  #   \n##### \n  #   \n #    \n      \n      \n      \n',
    '/': u'      \n      \n    # \n   #  \n   #  \n  #   \n  #   \n #    \n #    \n#     \n      \n',
    '3': u'      \n      \n  ##  \n #  # \n    # \n  ##  \n   #  \n#  #  \n ##   \n      \n      \n',
    '7': u'      \n      \n##### \n#   # \n   #  \n  #   \n #    \n#     \n#     \n      \n      \n',
    ';': u'    \n    \n    \n    \n    \n  # \n    \n    \n #  \n #  \n#   \n',
    '?': u'     \n     \n     \n ##  \n#  # \n  #  \n #   \n     \n#    \n     \n     \n',
    'C': u'      \n      \n      \n  ### \n #  # \n#     \n#     \n#   # \n ###  \n      \n      \n',
    'G': u'      \n      \n      \n  ### \n #  # \n#     \n#  ## \n#   # \n ###  \n      \n      \n',
    'K': u'        \n        \n        \n  ## ## \n  # #   \n  ##    \n # ##   \n #  #   \n###  #  \n        \n        \n',
    'O': u'      \n      \n      \n  ##  \n #  # \n#   # \n#   # \n#  ## \n ###  \n      \n      \n',
    'S': u'      \n      \n      \n  ### \n #  # \n ##   \n   #  \n#   # \n####  \n      \n      \n',
    'W': u'       \n       \n       \n##  ## \n#   #  \n# # #  \n# # #  \n####   \n# #    \n       \n       \n',
    '[': u'     \n     \n  ## \n  #  \n  #  \n #   \n #   \n #   \n#    \n##   \n     \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n',
    'c': u'      \n      \n      \n      \n  ### \n #  # \n#     \n#  #  \n ##   \n      \n      \n',
    'g': u'       \n       \n       \n       \n  #### \n #  #  \n#   #  \n#  #   \n ###   \n   #   \n###    \n',
    'k': u'       \n       \n  ##   \n   #   \n  #  # \n  ###  \n  #    \n # ##  \n##  ## \n       \n       \n',
    'o': u'      \n      \n      \n      \n ###  \n#   # \n#   # \n#  #  \n ##   \n      \n      \n',
    's': u'      \n      \n      \n      \n  ### \n #    \n  ##  \n#  #  \n###   \n      \n      \n',
    'w': u'       \n       \n       \n       \n##  ## \n#   #  \n# # #  \n## #   \n# #    \n       \n       \n',
    '{': u'     \n     \n  ## \n #   \n #   \n#    \n #   \n#    \n#    \n #   \n     \n',
    '"': u'     \n     \n # # \n # # \n# #  \n     \n     \n     \n     \n     \n     \n',
    '&': u'      \n      \n      \n   ## \n  #   \n  #   \n # ## \n#  #  \n ## # \n      \n      \n',
    '*': u'     \n     \n  #  \n## # \n #   \n# #  \n     \n     \n     \n     \n     \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'       \n       \n   ##  \n  #  # \n     # \n    #  \n  ##   \n #     \n#####  \n       \n       \n',
    '6': u'       \n       \n   ### \n  #    \n #     \n ###   \n#   #  \n#  #   \n ##    \n       \n       \n',
    ':': u'   \n   \n   \n   \n   \n # \n   \n   \n#  \n   \n   \n',
    '>': u'     \n     \n     \n #   \n  #  \n   # \n ##  \n#    \n     \n     \n     \n',
    'B': u'       \n       \n       \n ####  \n  #  # \n  ###  \n #   # \n #   # \n#####  \n       \n       \n',
    'F': u'        \n        \n        \n ###### \n  #   # \n  ###   \n #      \n #      \n###     \n        \n        \n',
    'J': u'        \n        \n        \n   #### \n    #   \n    #   \n   #    \n#  #    \n###     \n        \n        \n',
    'N': u'        \n        \n        \n ##  ## \n  #  #  \n  ## #  \n # ##   \n #  #   \n##  #   \n        \n        \n',
    'R': u'       \n       \n       \n ####  \n  #  # \n  #  # \n # ##  \n #  #  \n### ## \n       \n       \n',
    'V': u'       \n       \n       \n### ## \n #  #  \n # #   \n # #   \n ##    \n #     \n       \n       \n',
    'Z': u'       \n       \n       \n  #### \n #  #  \n   #   \n  #    \n #  #  \n####   \n       \n       \n',
    '^': u'     \n     \n  #  \n # # \n#  # \n     \n     \n     \n     \n     \n     \n',
    'b': u'       \n       \n  ##   \n   #   \n  # #  \n  #  # \n #   # \n #  #  \n####   \n       \n       \n',
    'f': u'       \n       \n   ### \n  #    \n ####  \n  #    \n #     \n #     \n###    \n       \n       \n',
    'j': u'       \n       \n     # \n       \n  ###  \n    #  \n    #  \n   #   \n   #   \n   #   \n###    \n',
    'n': u'       \n       \n       \n       \n # ##  \n  #  # \n #   # \n #  #  \n### ## \n       \n       \n',
    'r': u'       \n       \n       \n       \n # ##  \n  #  # \n #     \n #     \n###    \n       \n       \n',
    'v': u'      \n      \n      \n      \n## ## \n #  # \n # #  \n ##   \n #    \n      \n      \n',
    'z': u'      \n      \n      \n      \n #### \n # #  \n  #   \n #  # \n####  \n      \n      \n',
    '~': u'       \n       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n',
    '!': u'    \n    \n  # \n  # \n #  \n #  \n #  \n    \n#   \n    \n    \n',
    '%': u'      \n      \n ##   \n# # # \n## #  \n  #   \n # ## \n# # # \n  ##  \n      \n      \n',
    ')': u'     \n     \n  #  \n   # \n   # \n   # \n   # \n  #  \n #   \n#    \n     \n',
    '-': u'      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'      \n      \n    # \n  ### \n   #  \n   #  \n  #   \n  #   \n####  \n      \n      \n',
    '5': u'      \n      \n  ### \n #    \n ###  \n    # \n    # \n#  #  \n ##   \n      \n      \n',
    '9': u'       \n       \n   ##  \n  #  # \n #   # \n  ###  \n    #  \n   #   \n###    \n       \n       \n',
    '=': u'      \n      \n      \n      \n #### \n      \n####  \n      \n      \n      \n      \n',
    'A': u'       \n       \n       \n  ###  \n   ##  \n  # #  \n  ###  \n #  #  \n##  ## \n       \n       \n',
    'E': u'       \n       \n       \n ##### \n  #  # \n  ##   \n #     \n #  #  \n#####  \n       \n       \n',
    'I': u'       \n       \n       \n ##### \n   #   \n   #   \n  #    \n  #    \n#####  \n       \n       \n',
    'M': u'        \n        \n        \n ##  ## \n ## ##  \n # # #  \n #  #   \n#   #   \n#  ##   \n        \n        \n',
    'Q': u'      \n      \n      \n  ##  \n #  # \n#   # \n#   # \n#  ## \n ###  \n##    \n  ##  \n',
    'U': u'       \n       \n       \n ## ## \n #  #  \n #  #  \n#  #   \n#  #   \n ##    \n       \n       \n',
    'Y': u'       \n       \n       \n##  ## \n #  #  \n # #   \n ##    \n #     \n###    \n       \n       \n',
    ']': u'     \n     \n  ## \n   # \n  #  \n  #  \n  #  \n #   \n #   \n##   \n     \n',
    'a': u'       \n       \n       \n       \n  ###  \n     # \n ##### \n#   #  \n ### # \n       \n       \n',
    'e': u'      \n      \n      \n      \n  ##  \n #  # \n##### \n#     \n ###  \n      \n      \n',
    'i': u'      \n      \n    # \n      \n  ##  \n   #  \n  #   \n  #   \n####  \n      \n      \n',
    'm': u'       \n       \n       \n       \n ## #  \n # # # \n # # # \n# # #  \n# # #  \n       \n       \n',
    'q': u'       \n       \n       \n       \n  ## # \n #  #  \n#   #  \n#  #   \n ###   \n   #   \n  ##   \n',
    'u': u'       \n       \n       \n       \n### ## \n #  #  \n #  #  \n#  #   \n ## #  \n       \n       \n',
    'y': u'       \n       \n       \n       \n ## ## \n  #  # \n  #  # \n  # #  \n  ##   \n  #    \n##     \n',
    '}': u'     \n     \n ##  \n   # \n   # \n  #  \n   # \n  #  \n  #  \n##   \n     \n'}

xhelv_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'      \n      \n      \n  #   \n ###  \n# # # \n# #   \n ###  \n  # # \n# # # \n ###  \n  #   \n      \n',
    '(': u'    \n    \n    \n  # \n #  \n #  \n#   \n#   \n#   \n#   \n #  \n #  \n  # \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n # \n # \n#  \n',
    '0': u'      \n      \n      \n ###  \n#   # \n#   # \n#   # \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    '4': u'      \n      \n      \n   #  \n  ##  \n # #  \n # #  \n#  #  \n##### \n   #  \n   #  \n      \n      \n',
    '8': u'      \n      \n      \n ###  \n#   # \n#   # \n ###  \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    '<': u'    \n    \n    \n    \n    \n  # \n #  \n#   \n #  \n  # \n    \n    \n    \n',
    '@': u'           \n           \n           \n   #####   \n  #     #  \n #  ## # # \n#  #  #  # \n# #   #  # \n# #  #  #  \n# #  #  #  \n#  ## ##   \n #         \n  #####    \n',
    'D': u'       \n       \n       \n####   \n#   #  \n#    # \n#    # \n#    # \n#    # \n#   #  \n####   \n       \n       \n',
    'H': u'       \n       \n       \n#    # \n#    # \n#    # \n###### \n#    # \n#    # \n#    # \n#    # \n       \n       \n',
    'L': u'     \n     \n     \n#    \n#    \n#    \n#    \n#    \n#    \n#    \n#### \n     \n     \n',
    'P': u'      \n      \n      \n####  \n#   # \n#   # \n####  \n#     \n#     \n#     \n#     \n      \n      \n',
    'T': u'      \n      \n      \n##### \n  #   \n  #   \n  #   \n  #   \n  #   \n  #   \n  #   \n      \n      \n',
    'X': u'      \n      \n      \n#   # \n#   # \n # #  \n  #   \n # #  \n # #  \n#   # \n#   # \n      \n      \n',
    '\\': u'    \n    \n    \n#   \n#   \n #  \n #  \n #  \n #  \n  # \n  # \n    \n    \n',
    '`': u'   \n   \n   \n # \n#  \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'      \n      \n      \n    # \n    # \n ## # \n#  ## \n#   # \n#   # \n#  ## \n ## # \n      \n      \n',
    'h': u'      \n      \n      \n#     \n#     \n# ##  \n##  # \n#   # \n#   # \n#   # \n#   # \n      \n      \n',
    'l': u'  \n  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'p': u'      \n      \n      \n      \n      \n# ##  \n##  # \n#   # \n#   # \n##  # \n# ##  \n#     \n#     \n',
    't': u'    \n    \n    \n #  \n #  \n### \n #  \n #  \n #  \n #  \n ## \n    \n    \n',
    'x': u'      \n      \n      \n      \n      \n#   # \n # #  \n  #   \n # #  \n#   # \n#   # \n      \n      \n',
    '|': u'  \n  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'       \n       \n       \n       \n  # #  \n  # #  \n ##### \n  # #  \n#####  \n # #   \n # #   \n       \n       \n',
    "'": u'   \n   \n   \n # \n # \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n      \n',
    '/': u'    \n    \n    \n  # \n  # \n #  \n #  \n #  \n #  \n#   \n#   \n    \n    \n',
    '3': u'      \n      \n      \n ###  \n#   # \n    # \n  ##  \n    # \n    # \n#   # \n ###  \n      \n      \n',
    '7': u'      \n      \n      \n##### \n    # \n   #  \n   #  \n  #   \n  #   \n #    \n #    \n      \n      \n',
    ';': u'   \n   \n   \n   \n   \n # \n   \n   \n   \n   \n # \n # \n#  \n',
    '?': u'     \n     \n     \n ##  \n#  # \n   # \n  #  \n #   \n #   \n     \n #   \n     \n     \n',
    'C': u'       \n       \n       \n ####  \n#    # \n#      \n#      \n#      \n#      \n#    # \n ####  \n       \n       \n',
    'G': u'       \n       \n       \n ####  \n#    # \n#      \n#      \n#   ## \n#    # \n#   ## \n ### # \n       \n       \n',
    'K': u'      \n      \n      \n#   # \n#  #  \n# #   \n###   \n#  #  \n#  #  \n#   # \n#   # \n      \n      \n',
    'O': u'       \n       \n       \n ####  \n#    # \n#    # \n#    # \n#    # \n#    # \n#    # \n ####  \n       \n       \n',
    'S': u'      \n      \n      \n ###  \n#   # \n#     \n ###  \n    # \n#   # \n#   # \n ###  \n      \n      \n',
    'W': u'          \n          \n          \n#   #   # \n#   #   # \n #  #  #  \n #  #  #  \n # # # #  \n  #   #   \n  #   #   \n  #   #   \n          \n          \n',
    '[': u'   \n   \n   \n## \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n## \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n',
    'c': u'     \n     \n     \n     \n     \n ##  \n#  # \n#    \n#    \n#  # \n ##  \n     \n     \n',
    'g': u'      \n      \n      \n      \n      \n ## # \n#  ## \n#   # \n#   # \n#  ## \n ## # \n    # \n ###  \n',
    'k': u'     \n     \n     \n#    \n#    \n#  # \n# #  \n##   \n# #  \n#  # \n#  # \n     \n     \n',
    'o': u'      \n      \n      \n      \n      \n ###  \n#   # \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    's': u'     \n     \n     \n     \n     \n ##  \n#  # \n ##  \n   # \n#  # \n ##  \n     \n     \n',
    'w': u'        \n        \n        \n        \n        \n#  #  # \n#  #  # \n # # #  \n # # #  \n  # #   \n  # #   \n        \n        \n',
    '{': u'    \n    \n    \n  # \n #  \n #  \n #  \n#   \n #  \n #  \n #  \n #  \n  # \n',
    '"': u'    \n    \n    \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'       \n       \n       \n  #    \n # #   \n # #   \n ##    \n# #  # \n#  ##  \n#  ##  \n ##  # \n       \n       \n',
    '*': u'    \n    \n    \n# # \n #  \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'      \n      \n      \n ###  \n#   # \n    # \n    # \n  ##  \n #    \n#     \n##### \n      \n      \n',
    '6': u'      \n      \n      \n ###  \n#   # \n#     \n# ##  \n##  # \n#   # \n#   # \n ###  \n      \n      \n',
    ':': u'  \n  \n  \n  \n  \n# \n  \n  \n  \n  \n# \n  \n  \n',
    '>': u'    \n    \n    \n    \n    \n#   \n #  \n  # \n #  \n#   \n    \n    \n    \n',
    'B': u'      \n      \n      \n####  \n#   # \n#   # \n####  \n#   # \n#   # \n#   # \n####  \n      \n      \n',
    'F': u'      \n      \n      \n##### \n#     \n#     \n####  \n#     \n#     \n#     \n#     \n      \n      \n',
    'J': u'     \n     \n     \n   # \n   # \n   # \n   # \n   # \n   # \n#  # \n ##  \n     \n     \n',
    'N': u'       \n       \n       \n##   # \n##   # \n# #  # \n# #  # \n#  # # \n#  # # \n#   ## \n#   ## \n       \n       \n',
    'R': u'      \n      \n      \n####  \n#   # \n#   # \n####  \n#   # \n#   # \n#   # \n#   # \n      \n      \n',
    'V': u'        \n        \n        \n#     # \n#     # \n #   #  \n #   #  \n #   #  \n  # #   \n  # #   \n   #    \n        \n        \n',
    'Z': u'      \n      \n      \n##### \n    # \n   #  \n  #   \n  #   \n #    \n#     \n##### \n      \n      \n',
    '^': u'      \n      \n      \n  #   \n  #   \n # #  \n # #  \n#   # \n      \n      \n      \n      \n      \n',
    'b': u'      \n      \n      \n#     \n#     \n# ##  \n##  # \n#   # \n#   # \n##  # \n# ##  \n      \n      \n',
    'f': u'     \n     \n     \n  ## \n #   \n###  \n #   \n #   \n #   \n #   \n #   \n     \n     \n',
    'j': u'  \n  \n  \n# \n  \n# \n# \n# \n# \n# \n# \n# \n  \n',
    'n': u'      \n      \n      \n      \n      \n# ##  \n##  # \n#   # \n#   # \n#   # \n#   # \n      \n      \n',
    'r': u'    \n    \n    \n    \n    \n# # \n##  \n#   \n#   \n#   \n#   \n    \n    \n',
    'v': u'      \n      \n      \n      \n      \n#   # \n#   # \n # #  \n # #  \n  #   \n  #   \n      \n      \n',
    'z': u'     \n     \n     \n     \n     \n#### \n   # \n  #  \n #   \n#    \n#### \n     \n     \n',
    '~': u'       \n       \n       \n       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n',
    '!': u'  \n  \n  \n# \n# \n# \n# \n# \n# \n  \n# \n  \n  \n',
    '%': u'         \n         \n         \n ##  #   \n#  # #   \n ## #    \n    #    \n   #     \n   # ##  \n  # #  # \n  #  ##  \n         \n         \n',
    ')': u'    \n    \n    \n#   \n #  \n #  \n  # \n  # \n  # \n  # \n #  \n #  \n#   \n',
    '-': u'      \n      \n      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'   \n   \n   \n # \n## \n # \n # \n # \n # \n # \n # \n   \n   \n',
    '5': u'      \n      \n      \n##### \n#     \n#     \n####  \n    # \n    # \n#   # \n ###  \n      \n      \n',
    '9': u'      \n      \n      \n ###  \n#   # \n#   # \n#  ## \n ## # \n    # \n#   # \n ###  \n      \n      \n',
    '=': u'     \n     \n     \n     \n     \n     \n#### \n     \n#### \n     \n     \n     \n     \n',
    'A': u'        \n        \n        \n   #    \n   #    \n  # #   \n  # #   \n #   #  \n #####  \n#     # \n#     # \n        \n        \n',
    'E': u'      \n      \n      \n##### \n#     \n#     \n##### \n#     \n#     \n#     \n##### \n      \n      \n',
    'I': u'  \n  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'M': u'        \n        \n        \n#     # \n##   ## \n##   ## \n# # # # \n# # # # \n#  #  # \n#  #  # \n#  #  # \n        \n        \n',
    'Q': u'        \n        \n        \n ####   \n#    #  \n#    #  \n#    #  \n#    #  \n#  # #  \n#   ##  \n #####  \n      # \n        \n',
    'U': u'       \n       \n       \n#    # \n#    # \n#    # \n#    # \n#    # \n#    # \n#    # \n ####  \n       \n       \n',
    'Y': u'        \n        \n        \n#     # \n #   #  \n #   #  \n  # #   \n  # #   \n   #    \n   #    \n   #    \n        \n        \n',
    ']': u'   \n   \n   \n## \n # \n # \n # \n # \n # \n # \n # \n # \n## \n',
    'a': u'      \n      \n      \n      \n      \n###   \n   #  \n ###  \n#  #  \n#  #  \n ## # \n      \n      \n',
    'e': u'     \n     \n     \n     \n     \n ##  \n#  # \n#### \n#    \n#  # \n ##  \n     \n     \n',
    'i': u'  \n  \n  \n# \n  \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'm': u'        \n        \n        \n        \n        \n### ##  \n#  #  # \n#  #  # \n#  #  # \n#  #  # \n#  #  # \n        \n        \n',
    'q': u'      \n      \n      \n      \n      \n ## # \n#  ## \n#   # \n#   # \n#  ## \n ## # \n    # \n    # \n',
    'u': u'     \n     \n     \n     \n     \n#  # \n#  # \n#  # \n#  # \n#  # \n ### \n     \n     \n',
    'y': u'     \n     \n     \n     \n     \n#  # \n#  # \n# #  \n# #  \n ##  \n #   \n #   \n#    \n',
    '}': u'    \n    \n    \n#   \n #  \n #  \n #  \n  # \n #  \n #  \n #  \n #  \n#   \n'}

xhelvb_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'      \n      \n      \n  #   \n ###  \n# # # \n###   \n ###  \n  ### \n# # # \n ###  \n  #   \n      \n',
    '(': u'    \n    \n    \n  # \n ## \n #  \n##  \n##  \n##  \n##  \n #  \n ## \n  # \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n # \n # \n # \n#  \n',
    '0': u'      \n      \n      \n ###  \n## ## \n## ## \n## ## \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    '4': u'       \n       \n       \n   ##  \n  ###  \n # ##  \n # ##  \n#  ##  \n###### \n   ##  \n   ##  \n       \n       \n',
    '8': u'      \n      \n      \n ###  \n## ## \n## ## \n ###  \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    '<': u'     \n     \n     \n     \n     \n  ## \n ##  \n##   \n ##  \n  ## \n     \n     \n     \n',
    '@': u'           \n           \n           \n           \n   #####   \n ##     #  \n #  ## # # \n#  #  #  # \n# #   #  # \n# #  #  #  \n#  ## ##   \n #         \n  #####    \n',
    'D': u'       \n       \n       \n####   \n## ##  \n##  ## \n##  ## \n##  ## \n##  ## \n## ##  \n####   \n       \n       \n',
    'H': u'       \n       \n       \n##  ## \n##  ## \n##  ## \n###### \n##  ## \n##  ## \n##  ## \n##  ## \n       \n       \n',
    'L': u'      \n      \n      \n##    \n##    \n##    \n##    \n##    \n##    \n##    \n##### \n      \n      \n',
    'P': u'       \n       \n       \n#####  \n##  ## \n##  ## \n##  ## \n#####  \n##     \n##     \n##     \n       \n       \n',
    'T': u'       \n       \n       \n###### \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n       \n       \n',
    'X': u'        \n        \n        \n##   ## \n##   ## \n ## ##  \n  ###   \n  ###   \n ## ##  \n##   ## \n##   ## \n        \n        \n',
    '\\': u'     \n     \n     \n#    \n#    \n #   \n #   \n  #  \n  #  \n   # \n   # \n     \n     \n',
    '`': u'   \n   \n   \n # \n#  \n## \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'      \n      \n      \n   ## \n   ## \n #### \n## ## \n#  ## \n#  ## \n## ## \n #### \n      \n      \n',
    'h': u'      \n      \n      \n##    \n##    \n####  \n## ## \n## ## \n## ## \n## ## \n## ## \n      \n      \n',
    'l': u'   \n   \n   \n## \n## \n## \n## \n## \n## \n## \n## \n   \n   \n',
    'p': u'      \n      \n      \n      \n      \n# ##  \n## ## \n##  # \n##  # \n## ## \n####  \n##    \n##    \n',
    't': u'    \n    \n    \n##  \n##  \n### \n##  \n##  \n##  \n##  \n ## \n    \n    \n',
    'x': u'       \n       \n       \n       \n       \n##  ## \n ####  \n  ##   \n ####  \n##  ## \n##  ## \n       \n       \n',
    '|': u'  \n  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n# \n',
    '#': u'       \n       \n       \n       \n # #   \n # #   \n###### \n # #   \n#####  \n# #    \n# #    \n       \n       \n',
    "'": u'   \n   \n   \n## \n # \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    '+': u'       \n       \n       \n       \n       \n  ##   \n  ##   \n###### \n  ##   \n  ##   \n       \n       \n       \n',
    '/': u'     \n     \n     \n   # \n   # \n  #  \n  #  \n #   \n #   \n#    \n#    \n     \n     \n',
    '3': u'      \n      \n      \n ###  \n## ## \n   ## \n  ##  \n   ## \n   ## \n## ## \n ###  \n      \n      \n',
    '7': u'      \n      \n      \n##### \n   ## \n   ## \n  ##  \n  ##  \n  ##  \n ##   \n ##   \n      \n      \n',
    ';': u'   \n   \n   \n   \n   \n # \n # \n   \n   \n # \n # \n # \n#  \n',
    '?': u'      \n      \n      \n ###  \n## ## \n   ## \n  ##  \n ##   \n ##   \n      \n ##   \n      \n      \n',
    'C': u'        \n        \n        \n  ####  \n ##  ## \n##    # \n##      \n##      \n##    # \n ##  ## \n  ####  \n        \n        \n',
    'G': u'        \n        \n        \n  ####  \n ##  ## \n##    # \n##      \n##  ### \n##   ## \n ##  ## \n  ### # \n        \n        \n',
    'K': u'        \n        \n        \n##  ##  \n## ##   \n####    \n###     \n####    \n## ##   \n##  ##  \n##   ## \n        \n        \n',
    'O': u'        \n        \n        \n  ###   \n ## ##  \n##   ## \n##   ## \n##   ## \n##   ## \n ## ##  \n  ###   \n        \n        \n',
    'S': u'       \n       \n       \n ####  \n##  ## \n###    \n ####  \n   ### \n#   ## \n##  ## \n ####  \n       \n       \n',
    'W': u'           \n           \n           \n##  ##  ## \n##  ##  ## \n##  ##  ## \n ## ## ##  \n ## ## ##  \n ########  \n  ##  ##   \n  #    #   \n           \n           \n',
    '[': u'    \n    \n    \n### \n##  \n##  \n##  \n##  \n##  \n##  \n##  \n##  \n### \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n',
    'c': u'     \n     \n     \n     \n     \n ### \n## # \n##   \n##   \n## # \n ### \n     \n     \n',
    'g': u'      \n      \n      \n      \n      \n ## # \n## ## \n#  ## \n#  ## \n## ## \n #### \n   ## \n ###  \n',
    'k': u'       \n       \n       \n##     \n##     \n## ##  \n####   \n###    \n####   \n## ##  \n##  ## \n       \n       \n',
    'o': u'      \n      \n      \n      \n      \n ###  \n## ## \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    's': u'      \n      \n      \n      \n      \n ###  \n## ## \n ###  \n   ## \n## ## \n ###  \n      \n      \n',
    'w': u'        \n        \n        \n        \n        \n## # ## \n## # ## \n## # ## \n ## ##  \n ## ##  \n ## ##  \n        \n        \n',
    '{': u'     \n     \n     \n  ## \n ##  \n ##  \n ##  \n##   \n ##  \n ##  \n ##  \n ##  \n  ## \n',
    '"': u'    \n    \n    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'        \n        \n        \n ###    \n## ##   \n## ##   \n ###    \n## #### \n##  ##  \n## ###  \n ### ## \n        \n        \n',
    '*': u'    \n    \n    \n# # \n #  \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n# \n  \n  \n',
    '2': u'      \n      \n      \n ###  \n## ## \n   ## \n   ## \n  ##  \n ##   \n##    \n##### \n      \n      \n',
    '6': u'      \n      \n      \n ###  \n## ## \n##    \n####  \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    ':': u'  \n  \n  \n  \n  \n# \n# \n  \n  \n# \n# \n  \n  \n',
    '>': u'     \n     \n     \n     \n     \n##   \n ##  \n  ## \n ##  \n##   \n     \n     \n     \n',
    'B': u'       \n       \n       \n#####  \n##  ## \n##  ## \n#####  \n##  ## \n##  ## \n##  ## \n#####  \n       \n       \n',
    'F': u'      \n      \n      \n##### \n##    \n##    \n####  \n##    \n##    \n##    \n##    \n      \n      \n',
    'J': u'      \n      \n      \n   ## \n   ## \n   ## \n   ## \n   ## \n   ## \n## ## \n ###  \n      \n      \n',
    'N': u'        \n        \n        \n##   ## \n###  ## \n###  ## \n## # ## \n## # ## \n##  ### \n##  ### \n##   ## \n        \n        \n',
    'R': u'       \n       \n       \n#####  \n##  ## \n##  ## \n##  ## \n#####  \n##  ## \n##  ## \n##  ## \n       \n       \n',
    'V': u'        \n        \n        \n##   ## \n##   ## \n ## ##  \n ## ##  \n ## ##  \n  ###   \n  ###   \n   #    \n        \n        \n',
    'Z': u'       \n       \n       \n###### \n    ## \n   ##  \n  ##   \n ###   \n ##    \n##     \n###### \n       \n       \n',
    '^': u'      \n      \n      \n  #   \n ###  \n## ## \n#   # \n      \n      \n      \n      \n      \n      \n',
    'b': u'      \n      \n      \n##    \n##    \n####  \n## ## \n##  # \n##  # \n## ## \n####  \n      \n      \n',
    'f': u'     \n     \n     \n ### \n##   \n###  \n##   \n##   \n##   \n##   \n##   \n     \n     \n',
    'j': u'   \n   \n   \n## \n   \n## \n## \n## \n## \n## \n## \n## \n#  \n',
    'n': u'      \n      \n      \n      \n      \n# ##  \n## ## \n## ## \n## ## \n## ## \n## ## \n      \n      \n',
    'r': u'     \n     \n     \n     \n     \n# ## \n###  \n##   \n##   \n##   \n##   \n     \n     \n',
    'v': u'      \n      \n      \n      \n      \n## ## \n## ## \n## ## \n # #  \n ###  \n  #   \n      \n      \n',
    'z': u'      \n      \n      \n      \n      \n##### \n   ## \n  ##  \n ##   \n##    \n##### \n      \n      \n',
    '~': u'       \n       \n       \n       \n       \n       \n       \n ## ## \n## ##  \n       \n       \n       \n       \n',
    '!': u'   \n   \n   \n## \n## \n## \n## \n#  \n#  \n   \n## \n   \n   \n',
    '%': u'        \n        \n        \n ##   # \n# ## #  \n ## #   \n   #    \n   #    \n  # ##  \n # # ## \n#   ##  \n        \n        \n',
    ')': u'    \n    \n    \n#   \n##  \n #  \n ## \n ## \n ## \n ## \n #  \n##  \n#   \n',
    '-': u'      \n      \n      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'     \n     \n     \n  ## \n#### \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n     \n     \n',
    '5': u'      \n      \n      \n##### \n##    \n##    \n####  \n   ## \n#  ## \n## ## \n ###  \n      \n      \n',
    '9': u'      \n      \n      \n ###  \n## ## \n## ## \n## ## \n #### \n   ## \n## ## \n ###  \n      \n      \n',
    '=': u'      \n      \n      \n      \n      \n      \n##### \n      \n##### \n      \n      \n      \n      \n',
    'A': u'        \n        \n        \n  ###   \n  ###   \n ## ##  \n ## ##  \n ## ##  \n####### \n##   ## \n##   ## \n        \n        \n',
    'E': u'      \n      \n      \n##### \n##    \n##    \n##### \n##    \n##    \n##    \n##### \n      \n      \n',
    'I': u'   \n   \n   \n## \n## \n## \n## \n## \n## \n## \n## \n   \n   \n',
    'M': u'          \n          \n          \n##     ## \n###   ### \n###   ### \n#### #### \n## # # ## \n## ### ## \n##  #  ## \n##  #  ## \n          \n          \n',
    'Q': u'        \n        \n        \n  ###   \n ## ##  \n##   ## \n##   ## \n##   ## \n## # ## \n ## ##  \n  ####  \n      # \n        \n',
    'U': u'       \n       \n       \n##  ## \n##  ## \n##  ## \n##  ## \n##  ## \n##  ## \n##  ## \n ####  \n       \n       \n',
    'Y': u'         \n         \n         \n##    ## \n##    ## \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n   ##    \n   ##    \n         \n         \n',
    ']': u'    \n    \n    \n### \n ## \n ## \n ## \n ## \n ## \n ## \n ## \n ## \n### \n',
    'a': u'       \n       \n       \n       \n       \n ###   \n#  ##  \n ####  \n## ##  \n## ##  \n ## ## \n       \n       \n',
    'e': u'      \n      \n      \n      \n      \n ###  \n## ## \n##### \n##    \n## ## \n ###  \n      \n      \n',
    'i': u'   \n   \n   \n## \n   \n## \n## \n## \n## \n## \n## \n   \n   \n',
    'm': u'         \n         \n         \n         \n         \n# ## ##  \n## ## ## \n## ## ## \n## ## ## \n## ## ## \n## ## ## \n         \n         \n',
    'q': u'      \n      \n      \n      \n      \n ## # \n## ## \n#  ## \n#  ## \n## ## \n #### \n   ## \n   ## \n',
    'u': u'      \n      \n      \n      \n      \n## ## \n## ## \n## ## \n## ## \n## ## \n ## # \n      \n      \n',
    'y': u'      \n      \n      \n      \n      \n## ## \n## ## \n## ## \n## ## \n #### \n  ##  \n  ##  \n ##   \n',
    '}': u'     \n     \n     \n##   \n ##  \n ##  \n ##  \n  ## \n ##  \n ##  \n ##  \n ##  \n##   \n'}

xhelvbi_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'       \n       \n       \n    #  \n  ###  \n ##### \n # #   \n ####  \n  # #  \n#####  \n ###   \n #     \n       \n',
    '(': u'      \n      \n      \n   ## \n  ##  \n ##   \n ##   \n##    \n##    \n##    \n ##   \n ##   \n  ##  \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n # \n # \n # \n#  \n',
    '0': u'       \n       \n       \n  ###  \n ## ## \n #  ## \n##  ## \n##  ## \n##  #  \n## ##  \n ###   \n       \n       \n',
    '4': u'       \n       \n       \n    ## \n   ### \n  # #  \n # ##  \n#  ##  \n#####  \n  ##   \n  ##   \n       \n       \n',
    '8': u'       \n       \n       \n  ###  \n ## ## \n ## ## \n ####  \n## ##  \n## ##  \n## ##  \n ###   \n       \n       \n',
    '<': u'      \n      \n      \n      \n      \n   ## \n ###  \n##    \n ##   \n  ##  \n      \n      \n      \n',
    '@': u'          \n          \n          \n          \n   ####   \n ##    #  \n #  ### # \n#  # #  # \n# #  #  # \n# # ## #  \n# ## ##   \n #        \n  ####    \n',
    'D': u'         \n         \n         \n  #####  \n  ##  ## \n ##   ## \n ##   ## \n ##  ##  \n##   ##  \n##  ##   \n#####    \n         \n         \n',
    'H': u'         \n         \n         \n  ##  ## \n  ##  ## \n ##  ##  \n ######  \n ##  ##  \n##  ##   \n##  ##   \n##  ##   \n         \n         \n',
    'L': u'      \n      \n      \n  ##  \n  ##  \n ##   \n ##   \n ##   \n##    \n##    \n##### \n      \n      \n',
    'P': u'         \n         \n         \n  #####  \n  ##  ## \n ##   ## \n ##  ##  \n #####   \n##       \n##       \n##       \n         \n         \n',
    'T': u'       \n       \n       \n###### \n  ##   \n ##    \n ##    \n ##    \n##     \n##     \n##     \n       \n       \n',
    'X': u'         \n         \n         \n ##   ## \n ##  ##  \n  # ##   \n  ###    \n  ###    \n ## ##   \n##  ##   \n##  ##   \n         \n         \n',
    '\\': u'   \n   \n   \n#  \n#  \n#  \n#  \n # \n # \n # \n # \n   \n   \n',
    '`': u'   \n   \n   \n # \n#  \n## \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'        \n        \n        \n     ## \n     ## \n  ####  \n ## ##  \n #  ##  \n##  #   \n## ##   \n ####   \n        \n        \n',
    'h': u'       \n       \n       \n  ##   \n  ##   \n ####  \n ## ## \n #  ## \n## ##  \n## ##  \n## ##  \n       \n       \n',
    'l': u'     \n     \n     \n  ## \n  ## \n ##  \n ##  \n ##  \n##   \n##   \n##   \n     \n     \n',
    'p': u'        \n        \n        \n        \n        \n  ####  \n  ## ## \n  #  ## \n ##  #  \n ## ##  \n ####   \n##      \n##      \n',
    't': u'      \n      \n      \n  ##  \n  ##  \n##### \n ##   \n ##   \n##    \n##    \n ##   \n      \n      \n',
    'x': u'        \n        \n        \n        \n        \n ##  ## \n  ####  \n   ##   \n  ###   \n ## ##  \n##  ##  \n        \n        \n',
    '|': u'     \n     \n     \n   # \n   # \n  #  \n  #  \n  #  \n #   \n #   \n #   \n#    \n#    \n',
    '#': u'        \n        \n        \n        \n   # #  \n   # #  \n ###### \n  # #   \n######  \n # #    \n # #    \n        \n        \n',
    "'": u'   \n   \n   \n## \n # \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n      \n      \n  ##  \n  ##  \n##### \n ##   \n ##   \n      \n      \n      \n',
    '/': u'       \n       \n       \n    ## \n   ##  \n   #   \n  ##   \n  #    \n ##    \n #     \n##     \n       \n       \n',
    '3': u'       \n       \n       \n  ###  \n ## ## \n    ## \n  ##   \n   ##  \n   ##  \n## ##  \n ###   \n       \n       \n',
    '7': u'      \n      \n      \n##### \n   ## \n  ##  \n  ##  \n ##   \n ##   \n##    \n##    \n      \n      \n',
    ';': u'    \n    \n    \n    \n    \n  # \n  # \n    \n    \n #  \n #  \n #  \n#   \n',
    '?': u'       \n       \n       \n  ###  \n ## ## \n    ## \n  ###  \n ##    \n ##    \n       \n##     \n       \n       \n',
    'C': u'        \n        \n        \n   ###  \n  ## ## \n ##  ## \n ##     \n##      \n##   #  \n##  ##  \n ####   \n        \n        \n',
    'G': u'         \n         \n         \n   ####  \n  ##  ## \n ##      \n ##      \n##  #### \n##   ##  \n##  ##   \n #####   \n         \n         \n',
    'K': u'         \n         \n         \n  ##  ## \n  ## ##  \n ## ##   \n ####    \n ####    \n##  ##   \n##   ##  \n##   ##  \n         \n         \n',
    'O': u'         \n         \n         \n   ####  \n  ##  ## \n ##   ## \n ##   ## \n##   ##  \n##   ##  \n##  ##   \n ####    \n         \n         \n',
    'S': u'         \n         \n         \n   ####  \n  ##  ## \n  ##     \n  ###    \n   ###   \n##  ##   \n##  ##   \n ####    \n         \n         \n',
    'W': u'           \n           \n           \n##  ##  ## \n##  ##  ## \n##  ## ##  \n## # # ##  \n## # # #   \n ### ###   \n ##  ##    \n ##  ##    \n           \n           \n',
    '[': u'       \n       \n       \n   ### \n   ##  \n  ##   \n  ##   \n  ##   \n ##    \n ##    \n ##    \n##     \n###    \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n',
    'c': u'      \n      \n      \n      \n      \n  ### \n ## # \n##    \n##    \n## ## \n ###  \n      \n      \n',
    'g': u'       \n       \n       \n       \n       \n  #### \n ## ## \n #  ## \n##  #  \n## ##  \n ####  \n  ##   \n###    \n',
    'k': u'       \n       \n       \n  ##   \n  ##   \n ## ## \n ####  \n ###   \n## ##  \n## ##  \n##  ## \n       \n       \n',
    'o': u'       \n       \n       \n       \n       \n  ###  \n ## ## \n##  ## \n##  ## \n## ##  \n ###   \n       \n       \n',
    's': u'       \n       \n       \n       \n       \n  ###  \n ## ## \n  ##   \n   ##  \n## ##  \n ###   \n       \n       \n',
    'w': u'        \n        \n        \n        \n        \n## # ## \n## # ## \n## # ## \n## # #  \n#####   \n #  #   \n        \n        \n',
    '{': u'       \n       \n       \n    ## \n   ##  \n  ##   \n  ##   \n##     \n ##    \n ##    \n ##    \n ##    \n  ##   \n',
    '"': u'       \n       \n       \n ## ## \n #  #  \n#  #   \n       \n       \n       \n       \n       \n       \n       \n',
    '&': u'        \n        \n        \n   ###  \n  ## #  \n  # ##  \n  ###   \n #### # \n##  ### \n## ###  \n ### ## \n        \n        \n',
    '*': u'     \n     \n     \n  #  \n#### \n ##  \n# #  \n     \n     \n     \n     \n     \n     \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n# \n  \n  \n',
    '2': u'       \n       \n       \n  ###  \n ## ## \n    ## \n  ###  \n ##    \n##     \n##     \n#####  \n       \n       \n',
    '6': u'       \n       \n       \n  ###  \n ## ## \n ##    \n#####  \n## ##  \n## ##  \n## ##  \n ###   \n       \n       \n',
    ':': u'   \n   \n   \n   \n   \n # \n # \n   \n   \n#  \n#  \n   \n   \n',
    '>': u'      \n      \n      \n      \n      \n ##   \n  ##  \n   ## \n ###  \n##    \n      \n      \n      \n',
    'B': u'        \n        \n        \n  ##### \n  ##  # \n ##  ## \n #####  \n ##  ## \n##   ## \n##  ##  \n#####   \n        \n        \n',
    'F': u'        \n        \n        \n  ##### \n  ##    \n ##     \n ####   \n ##     \n##      \n##      \n##      \n        \n        \n',
    'J': u'        \n        \n        \n     ## \n     ## \n    ##  \n    ##  \n    ##  \n## ##   \n## ##   \n ###    \n        \n        \n',
    'N': u'          \n          \n          \n  ##   ## \n  ##   ## \n ###  ##  \n #### ##  \n ## # ##  \n##  ###   \n##   ##   \n##   ##   \n          \n          \n',
    'R': u'         \n         \n         \n  #####  \n  ##  ## \n ##   ## \n #####   \n ##  ##  \n##   ##  \n##  ##   \n##  ##   \n         \n         \n',
    'V': u'        \n        \n        \n##   ## \n##   ## \n##  ##  \n##  ##  \n## ##   \n## ##   \n ###    \n ##     \n        \n        \n',
    'Z': u'         \n         \n         \n  ###### \n      ## \n     ##  \n   ###   \n  ###    \n ##      \n##       \n######   \n         \n         \n',
    '^': u'      \n      \n      \n   ## \n  ### \n ## # \n##  # \n      \n      \n      \n      \n      \n      \n',
    'b': u'       \n       \n       \n  ##   \n  ##   \n ####  \n ## ## \n #  ## \n##  #  \n## ##  \n####   \n       \n       \n',
    'f': u'      \n      \n      \n  ### \n ##   \n####  \n ##   \n ##   \n##    \n##    \n##    \n      \n      \n',
    'j': u'      \n      \n      \n   ## \n      \n  ##  \n  ##  \n  ##  \n ##   \n ##   \n ##   \n ##   \n##    \n',
    'n': u'       \n       \n       \n       \n       \n ####  \n ## ## \n #  ## \n## ##  \n## ##  \n## ##  \n       \n       \n',
    'r': u'      \n      \n      \n      \n      \n # ## \n ###  \n ##   \n##    \n##    \n##    \n      \n      \n',
    'v': u'      \n      \n      \n      \n      \n## ## \n## ## \n## ## \n## #  \n###   \n #    \n      \n      \n',
    'z': u'       \n       \n       \n       \n       \n ##### \n    ## \n  ###  \n ##    \n##     \n#####  \n       \n       \n',
    '~': u'      \n      \n      \n      \n      \n      \n ## # \n# ##  \n      \n      \n      \n      \n      \n',
    '!': u'     \n     \n     \n  ## \n  ## \n ##  \n ##  \n #   \n #   \n     \n##   \n     \n     \n',
    '%': u'         \n         \n         \n ##    # \n## #  #  \n ##  #   \n    #    \n   #     \n  # ##   \n # ## #  \n#   ##   \n         \n         \n',
    ')': u'      \n      \n      \n ##   \n  ##  \n  ##  \n   ## \n   ## \n   ## \n  ##  \n  ##  \n ##   \n##    \n',
    '-': u'      \n      \n      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'     \n     \n     \n  ## \n#### \n ##  \n ##  \n ##  \n##   \n##   \n##   \n     \n     \n',
    '5': u'       \n       \n       \n  #### \n  #    \n ##    \n ###   \n   ##  \n   ##  \n## ##  \n ###   \n       \n       \n',
    '9': u'       \n       \n       \n  ###  \n ## ## \n ## ## \n ## ## \n  #### \n    ## \n## ##  \n ###   \n       \n       \n',
    '=': u'      \n      \n      \n      \n      \n      \n #### \n      \n####  \n      \n      \n      \n      \n',
    'A': u'        \n        \n        \n    ##  \n   ###  \n  ## ## \n  ## ## \n ##  ## \n ###### \n##   ## \n##   ## \n        \n        \n',
    'E': u'        \n        \n        \n  ##### \n  ##    \n ##     \n #####  \n ##     \n##      \n##      \n#####   \n        \n        \n',
    'I': u'     \n     \n     \n  ## \n  ## \n ##  \n ##  \n ##  \n##   \n##   \n##   \n     \n     \n',
    'M': u'            \n            \n            \n  ##     ## \n  ##    ### \n ####  ###  \n ## # ####  \n ## ### ##  \n##  ## ##   \n##  ## ##   \n##  #  ##   \n            \n            \n',
    'Q': u'         \n         \n         \n   ####  \n  ##  ## \n ##   ## \n ##   ## \n##   ##  \n##   ##  \n##  ##   \n ####### \n         \n         \n',
    'U': u'         \n         \n         \n  ##  ## \n  ##  ## \n ##  ##  \n ##  ##  \n ##  ##  \n##  ##   \n##  ##   \n ####    \n         \n         \n',
    'Y': u'         \n         \n         \n##    ## \n##   ##  \n ## ##   \n ####    \n  ##     \n  ##     \n ##      \n ##      \n         \n         \n',
    ']': u'       \n       \n       \n   ### \n    ## \n   ##  \n   ##  \n   ##  \n  ##   \n  ##   \n  ##   \n ##    \n###    \n',
    'a': u'       \n       \n       \n       \n       \n  ###  \n #  ## \n  #### \n## ##  \n## ##  \n ## ## \n       \n       \n',
    'e': u'       \n       \n       \n       \n       \n  ###  \n ## ## \n ##### \n##     \n## ##  \n ###   \n       \n       \n',
    'i': u'     \n     \n     \n  ## \n     \n ##  \n ##  \n ##  \n##   \n##   \n##   \n     \n     \n',
    'm': u'          \n          \n          \n          \n          \n # ## ##  \n ## ## ## \n ## ## ## \n## ## ##  \n## ## ##  \n## ## ##  \n          \n          \n',
    'q': u'       \n       \n       \n       \n       \n  #### \n ## ## \n #  ## \n##  #  \n## ##  \n ####  \n  ##   \n  ##   \n',
    'u': u'       \n       \n       \n       \n       \n ## ## \n ## ## \n##  ## \n## ##  \n## ##  \n ## #  \n       \n       \n',
    'y': u'       \n       \n       \n       \n       \n ## ## \n ## ## \n ## ## \n  ###  \n  ##   \n  ##   \n ##    \n##     \n',
    '}': u'       \n       \n       \n  ##   \n   ##  \n   ##  \n   ##  \n    ## \n  ##   \n  ##   \n  ##   \n ##    \n##     \n'}

xhelvi_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'       \n       \n       \n    #  \n  ###  \n # # # \n # #   \n  ###  \n  # #  \n# # #  \n ###   \n #     \n       \n',
    '(': u'     \n     \n     \n   # \n  #  \n #   \n #   \n#    \n#    \n#    \n#    \n#    \n #   \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n   \n   \n # \n # \n#  \n',
    '0': u'       \n       \n       \n  ###  \n ##  # \n #   # \n#    # \n#    # \n#   #  \n#  ##  \n ###   \n       \n       \n',
    '4': u'       \n       \n       \n     # \n    ## \n   # # \n  # #  \n #  #  \n###### \n   #   \n   #   \n       \n       \n',
    '8': u'       \n       \n       \n  ###  \n #   # \n #   # \n ####  \n #  #  \n#   #  \n#   #  \n ###   \n       \n       \n',
    '<': u'     \n     \n     \n     \n     \n   # \n ##  \n#    \n #   \n  #  \n     \n     \n     \n',
    '@': u'           \n           \n           \n    ####   \n  ##    #  \n ##      # \n #  ## # # \n#  #  #  # \n# #   #  # \n# #  ## #  \n#  ## ##   \n #         \n  ####     \n',
    'D': u'        \n        \n        \n  ####  \n  #   # \n  #   # \n #    # \n #   #  \n#    #  \n#   #   \n####    \n        \n        \n',
    'H': u'         \n         \n         \n  #    # \n  #    # \n #    #  \n ######  \n #    #  \n#    #   \n#    #   \n#    #   \n         \n         \n',
    'L': u'     \n     \n     \n  #  \n  #  \n #   \n #   \n #   \n#    \n#    \n#### \n     \n     \n',
    'P': u'        \n        \n        \n  ####  \n  #   # \n #    # \n #####  \n #      \n#       \n#       \n#       \n        \n        \n',
    'T': u'      \n      \n      \n##### \n  #   \n #    \n #    \n #    \n#     \n#     \n#     \n      \n      \n',
    'X': u'         \n         \n         \n  #    # \n  #   #  \n   # #   \n   ##    \n   ##    \n  # #    \n #   #   \n#    #   \n         \n         \n',
    '\\': u'   \n   \n   \n#  \n#  \n#  \n#  \n # \n # \n # \n # \n   \n   \n',
    '`': u'   \n   \n   \n # \n#  \n## \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'       \n       \n       \n     # \n     # \n  ###  \n #  #  \n#   #  \n#  #   \n#  #   \n ###   \n       \n       \n',
    'h': u'       \n       \n       \n  #    \n  #    \n # ##  \n ##  # \n #   # \n#   #  \n#   #  \n#   #  \n       \n       \n',
    'l': u'    \n    \n    \n  # \n  # \n #  \n #  \n #  \n#   \n#   \n#   \n    \n    \n',
    'p': u'       \n       \n       \n       \n       \n  ###  \n  #  # \n  #  # \n #   # \n #  #  \n ###   \n#      \n#      \n',
    't': u'     \n     \n     \n  #  \n  #  \n#### \n #   \n #   \n#    \n#    \n##   \n     \n     \n',
    'x': u'       \n       \n       \n       \n       \n  #  # \n  # #  \n   #   \n  ##   \n #  #  \n#   #  \n       \n       \n',
    '|': u'     \n     \n     \n   # \n   # \n  #  \n  #  \n  #  \n #   \n #   \n #   \n#    \n#    \n',
    '#': u'        \n        \n        \n        \n   # #  \n   # #  \n ###### \n  # #   \n######  \n # #    \n # #    \n        \n        \n',
    "'": u'   \n   \n   \n## \n # \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    '+': u'     \n     \n     \n     \n     \n  #  \n  #  \n#### \n #   \n #   \n     \n     \n     \n',
    '/': u'     \n     \n     \n   # \n   # \n  #  \n  #  \n #   \n #   \n#    \n#    \n     \n     \n',
    '3': u'       \n       \n       \n  ###  \n #   # \n     # \n  ###  \n    #  \n    #  \n#   #  \n ###   \n       \n       \n',
    '7': u'      \n      \n      \n##### \n    # \n   #  \n  #   \n  #   \n #    \n#     \n#     \n      \n      \n',
    ';': u'    \n    \n    \n    \n    \n  # \n    \n    \n    \n    \n #  \n #  \n#   \n',
    '?': u'      \n      \n      \n  ##  \n #  # \n    # \n  ##  \n #    \n #    \n      \n#     \n      \n      \n',
    'C': u'        \n        \n        \n   ###  \n  #   # \n #      \n #      \n#       \n#     # \n#    #  \n ####   \n        \n        \n',
    'G': u'         \n         \n         \n   ####  \n  #    # \n #       \n #       \n#   ###  \n#     #  \n#    #   \n #####   \n         \n         \n',
    'K': u'        \n        \n        \n  #   # \n  #  #  \n #  #   \n ###    \n # #    \n#   #   \n#   #   \n#    #  \n        \n        \n',
    'O': u'         \n         \n         \n   ####  \n  #    # \n  #    # \n #    #  \n #    #  \n#    #   \n#    #   \n ####    \n         \n         \n',
    'S': u'        \n        \n        \n   ###  \n  #   # \n #      \n  ###   \n     #  \n#    #  \n#   #   \n ###    \n        \n        \n',
    'W': u'          \n          \n          \n#   #   # \n#   #   # \n#  ##  #  \n#  ##  #  \n# # # #   \n ##  ##   \n #   #    \n #   #    \n          \n          \n',
    '[': u'       \n       \n       \n   ### \n   #   \n  #    \n  #    \n  #    \n #     \n #     \n #     \n#      \n###    \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n',
    'c': u'      \n      \n      \n      \n      \n  ##  \n #  # \n#     \n#     \n#  #  \n ##   \n      \n      \n',
    'g': u'       \n       \n       \n       \n       \n   ### \n  #  # \n #   # \n #  #  \n #  #  \n  ###  \n#  #   \n ##    \n',
    'k': u'      \n      \n      \n  #   \n  #   \n #  # \n # #  \n ##   \n# #   \n#  #  \n#  #  \n      \n      \n',
    'o': u'       \n       \n       \n       \n       \n  ###  \n #   # \n #   # \n#   #  \n#   #  \n ###   \n       \n       \n',
    's': u'      \n      \n      \n      \n      \n  ##  \n #  # \n  #   \n   #  \n#  #  \n ##   \n      \n      \n',
    'w': u'        \n        \n        \n        \n        \n#  #  # \n#  #  # \n#  #  # \n# ## #  \n #  #   \n #  #   \n        \n        \n',
    '{': u'     \n     \n     \n   # \n  #  \n #   \n #   \n#    \n #   \n #   \n#    \n#    \n #   \n',
    '"': u'     \n     \n     \n # # \n # # \n# #  \n     \n     \n     \n     \n     \n     \n     \n',
    '&': u'        \n        \n        \n   ##   \n  #  #  \n  #  #  \n  ###   \n # #  # \n#   ##  \n#   #   \n ### #  \n        \n        \n',
    '*': u'     \n     \n     \n # # \n ##  \n# #  \n     \n     \n     \n     \n     \n     \n     \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n# \n  \n  \n',
    '2': u'       \n       \n       \n  ###  \n #   # \n     # \n    #  \n  ##   \n #     \n#      \n#####  \n       \n       \n',
    '6': u'       \n       \n       \n  ###  \n #   # \n #     \n####   \n#   #  \n#   #  \n#   #  \n ###   \n       \n       \n',
    ':': u'   \n   \n   \n   \n   \n # \n   \n   \n   \n   \n#  \n   \n   \n',
    '>': u'     \n     \n     \n     \n     \n #   \n  #  \n   # \n ##  \n#    \n     \n     \n     \n',
    'B': u'        \n        \n        \n  ####  \n  #   # \n #    # \n #####  \n #   #  \n#    #  \n#   ##  \n#####   \n        \n        \n',
    'F': u'        \n        \n        \n  ##### \n  #     \n #      \n ####   \n #      \n#       \n#       \n#       \n        \n        \n',
    'J': u'       \n       \n       \n     # \n     # \n    #  \n    #  \n    #  \n#  #   \n#  #   \n ##    \n       \n       \n',
    'N': u'         \n         \n         \n  #    # \n  #    # \n # #  #  \n # #  #  \n # #  #  \n#  # #   \n#   ##   \n#    #   \n         \n         \n',
    'R': u'        \n        \n        \n  ####  \n  #   # \n #    # \n #####  \n #   #  \n#    #  \n#   #   \n#   #   \n        \n        \n',
    'V': u'       \n       \n       \n#    # \n#    # \n#   #  \n#   #  \n#  #   \n#  #   \n# #    \n #     \n       \n       \n',
    'Z': u'        \n        \n        \n  ##### \n     #  \n    #   \n   #    \n  #     \n #      \n#       \n#####   \n        \n        \n',
    '^': u'     \n     \n     \n     \n  #  \n ##  \n#  # \n     \n     \n     \n     \n     \n     \n',
    'b': u'      \n      \n      \n  #   \n  #   \n ###  \n #  # \n #  # \n#   # \n#  #  \n###   \n      \n      \n',
    'f': u'     \n     \n     \n  ## \n #   \n###  \n #   \n #   \n#    \n#    \n#    \n     \n     \n',
    'j': u'     \n     \n     \n   # \n     \n  #  \n  #  \n  #  \n #   \n #   \n #   \n #   \n#    \n',
    'n': u'       \n       \n       \n       \n       \n # ##  \n ##  # \n #   # \n#   #  \n#   #  \n#   #  \n       \n       \n',
    'r': u'      \n      \n      \n      \n      \n # ## \n ##   \n #    \n#     \n#     \n#     \n      \n      \n',
    'v': u'      \n      \n      \n      \n      \n#   # \n#  #  \n#  #  \n# #   \n ##   \n #    \n      \n      \n',
    'z': u'      \n      \n      \n      \n      \n #### \n    # \n   #  \n  #   \n #    \n####  \n      \n      \n',
    '~': u'       \n       \n       \n       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n',
    '!': u'    \n    \n    \n  # \n  # \n  # \n #  \n #  \n #  \n    \n#   \n    \n    \n',
    '%': u'        \n        \n        \n ###  # \n#  # #  \n# # #   \n## #    \n   # ## \n  # # # \n # #  # \n#  ###  \n        \n        \n',
    ')': u'     \n     \n     \n  #  \n   # \n   # \n   # \n   # \n   # \n  #  \n  #  \n #   \n#    \n',
    '-': u'      \n      \n      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'    \n    \n    \n  # \n### \n #  \n #  \n #  \n#   \n#   \n#   \n    \n    \n',
    '5': u'       \n       \n       \n  #### \n  #    \n #     \n ####  \n     # \n#    # \n#   #  \n ###   \n       \n       \n',
    '9': u'       \n       \n       \n  ###  \n #   # \n #   # \n #   # \n  #### \n    #  \n#   #  \n ###   \n       \n       \n',
    '=': u'      \n      \n      \n      \n      \n      \n #### \n      \n####  \n      \n      \n      \n      \n',
    'A': u'        \n        \n        \n     #  \n    ##  \n   # #  \n   # #  \n  #  #  \n ###### \n #    # \n#     # \n        \n        \n',
    'E': u'        \n        \n        \n  ##### \n  #     \n #      \n #####  \n #      \n#       \n#       \n#####   \n        \n        \n',
    'I': u'    \n    \n    \n  # \n  # \n #  \n #  \n #  \n#   \n#   \n#   \n    \n    \n',
    'M': u'         \n         \n         \n  #    # \n  #   ## \n ##   ## \n # # # # \n # # # # \n#  ## #  \n#  #  #  \n#  #  #  \n         \n         \n',
    'Q': u'         \n         \n         \n   ####  \n  #    # \n  #    # \n #    #  \n #    #  \n#  # #   \n#   ##   \n #####   \n      #  \n         \n',
    'U': u'         \n         \n         \n  #    # \n  #    # \n #    #  \n #    #  \n #    #  \n#    #   \n#    #   \n ####    \n         \n         \n',
    'Y': u'        \n        \n        \n#     # \n#    #  \n #  #   \n # #    \n  #     \n #      \n #      \n #      \n        \n        \n',
    ']': u'       \n       \n       \n   ### \n     # \n    #  \n    #  \n    #  \n   #   \n   #   \n   #   \n  #    \n###    \n',
    'a': u'      \n      \n      \n      \n      \n ###  \n    # \n #### \n#  #  \n#  #  \n ## # \n      \n      \n',
    'e': u'      \n      \n      \n      \n      \n  ### \n #  # \n####  \n#     \n#  #  \n ##   \n      \n      \n',
    'i': u'    \n    \n    \n  # \n    \n #  \n #  \n #  \n#   \n#   \n#   \n    \n    \n',
    'm': u'         \n         \n         \n         \n         \n ### ##  \n #  #  # \n #  #  # \n#  #  #  \n#  #  #  \n#  #  #  \n         \n         \n',
    'q': u'      \n      \n      \n      \n      \n  ### \n #  # \n#   # \n#  #  \n#  #  \n ###  \n  #   \n  #   \n',
    'u': u'      \n      \n      \n      \n      \n #  # \n #  # \n#   # \n#  #  \n#  #  \n ###  \n      \n      \n',
    'y': u'      \n      \n      \n      \n      \n #  # \n #  # \n # #  \n # #  \n  #   \n  #   \n #    \n#     \n',
    '}': u'     \n     \n     \n  #  \n   # \n   # \n  #  \n   # \n  #  \n  #  \n  #  \n #   \n#    \n'}

xsans_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'      \n  #   \n #### \n# #   \n# #   \n ###  \n  # # \n  # # \n####  \n  #   \n      \n',
    '(': u'   \n # \n # \n#  \n#  \n#  \n#  \n#  \n # \n # \n   \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n # \n # \n # \n#  \n',
    '0': u'     \n     \n ##  \n#  # \n#  # \n#  # \n#  # \n#  # \n ##  \n     \n     \n',
    '4': u'      \n      \n   #  \n  ##  \n # #  \n#  #  \n##### \n   #  \n   #  \n      \n      \n',
    '8': u'     \n     \n ##  \n#  # \n#  # \n ##  \n#  # \n#  # \n ##  \n     \n     \n',
    '<': u'      \n      \n      \n   ## \n ##   \n#     \n ##   \n   ## \n      \n      \n      \n',
    '@': u'        \n        \n  ###   \n #   #  \n#  ###  \n# #  #  \n#  #### \n #      \n  ####  \n        \n        \n',
    'D': u'       \n       \n####   \n#   #  \n#    # \n#    # \n#    # \n#   #  \n####   \n       \n       \n',
    'H': u'      \n      \n#   # \n#   # \n#   # \n##### \n#   # \n#   # \n#   # \n      \n      \n',
    'L': u'     \n     \n#    \n#    \n#    \n#    \n#    \n#    \n#### \n     \n     \n',
    'P': u'     \n     \n###  \n#  # \n#  # \n###  \n#    \n#    \n#    \n     \n     \n',
    'T': u'      \n      \n##### \n  #   \n  #   \n  #   \n  #   \n  #   \n  #   \n      \n      \n',
    'X': u'      \n      \n#   # \n#   # \n # #  \n  #   \n # #  \n#   # \n#   # \n      \n      \n',
    '\\': u'      \n#     \n#     \n #    \n #    \n  #   \n   #  \n   #  \n    # \n    # \n      \n',
    '`': u'   \n # \n#  \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'     \n   # \n   # \n ### \n#  # \n#  # \n#  # \n# ## \n # # \n     \n     \n',
    'h': u'     \n#    \n#    \n# #  \n## # \n#  # \n#  # \n#  # \n#  # \n     \n     \n',
    'l': u'  \n# \n# \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'p': u'     \n     \n     \n# #  \n## # \n#  # \n#  # \n#  # \n###  \n#    \n#    \n',
    't': u'     \n     \n #   \n#### \n #   \n #   \n #   \n #   \n  ## \n     \n     \n',
    'x': u'     \n     \n     \n#  # \n#  # \n ##  \n ##  \n#  # \n#  # \n     \n     \n',
    '|': u'  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n  \n',
    '#': u'      \n      \n # #  \n # #  \n## ## \n # #  \n## ## \n # #  \n # #  \n      \n      \n',
    "'": u'   \n # \n # \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n      \n',
    '/': u'      \n    # \n    # \n   #  \n   #  \n  #   \n #    \n #    \n#     \n#     \n      \n',
    '3': u'     \n     \n###  \n   # \n   # \n ##  \n   # \n   # \n###  \n     \n     \n',
    '7': u'     \n     \n#### \n   # \n  #  \n  #  \n #   \n #   \n #   \n     \n     \n',
    ';': u'   \n   \n   \n # \n # \n   \n   \n # \n # \n # \n#  \n',
    '?': u'     \n     \n###  \n   # \n   # \n ##  \n     \n #   \n #   \n     \n     \n',
    'C': u'      \n      \n  ### \n #    \n#     \n#     \n#     \n #    \n  ### \n      \n      \n',
    'G': u'      \n      \n  ### \n #    \n#     \n#     \n#   # \n #  # \n  ### \n      \n      \n',
    'K': u'      \n      \n#   # \n#  #  \n# #   \n##    \n# #   \n#  #  \n#   # \n      \n      \n',
    'O': u'       \n       \n  ##   \n #  #  \n#    # \n#    # \n#    # \n #  #  \n  ##   \n       \n       \n',
    'S': u'     \n     \n ### \n#    \n#    \n ##  \n   # \n   # \n###  \n     \n     \n',
    'W': u'        \n        \n#     # \n#  #  # \n#  #  # \n# # # # \n #   #  \n #   #  \n #   #  \n        \n        \n',
    '[': u'   \n## \n#  \n#  \n#  \n#  \n#  \n#  \n#  \n## \n   \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \n      \n      \n##### \n      \n',
    'c': u'     \n     \n     \n ### \n#    \n#    \n#    \n#    \n ### \n     \n     \n',
    'g': u'     \n     \n     \n ### \n#  # \n#  # \n#  # \n# ## \n # # \n   # \n ##  \n',
    'k': u'      \n#     \n#     \n#  #  \n# #   \n##    \n# #   \n#  #  \n#   # \n      \n      \n',
    'o': u'     \n     \n     \n ##  \n#  # \n#  # \n#  # \n#  # \n ##  \n     \n     \n',
    's': u'    \n    \n    \n ## \n#   \n##  \n ## \n  # \n##  \n    \n    \n',
    'w': u'        \n        \n        \n#     # \n#  #  # \n#  #  # \n# # # # \n #   #  \n #   #  \n        \n        \n',
    '{': u'    \n  # \n #  \n #  \n #  \n#   \n #  \n #  \n #  \n  # \n    \n',
    '"': u'    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'       \n       \n ##    \n#  #   \n ##    \n ##  # \n#  # # \n#  ##  \n ##  # \n       \n       \n',
    '*': u'    \n    \n# # \n #  \n# # \n    \n    \n    \n    \n    \n    \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n# \n# \n  \n  \n',
    '2': u'     \n     \n###  \n   # \n   # \n  #  \n #   \n#    \n#### \n     \n     \n',
    '6': u'     \n     \n ### \n#    \n#    \n###  \n#  # \n#  # \n ##  \n     \n     \n',
    ':': u'  \n  \n  \n# \n# \n  \n  \n# \n# \n  \n  \n',
    '>': u'      \n      \n      \n##    \n  ##  \n    # \n  ##  \n##    \n      \n      \n      \n',
    'B': u'     \n     \n###  \n#  # \n#  # \n###  \n#  # \n#  # \n###  \n     \n     \n',
    'F': u'     \n     \n#### \n#    \n#    \n###  \n#    \n#    \n#    \n     \n     \n',
    'J': u'    \n    \n  # \n  # \n  # \n  # \n  # \n  # \n  # \n  # \n##  \n',
    'N': u'       \n       \n#    # \n##   # \n# #  # \n#  # # \n#  # # \n#   ## \n#    # \n       \n       \n',
    'R': u'      \n      \n###   \n#  #  \n#  #  \n###   \n# #   \n#  #  \n#   # \n      \n      \n',
    'V': u'      \n      \n#   # \n#   # \n#   # \n # #  \n # #  \n  #   \n  #   \n      \n      \n',
    'Z': u'     \n     \n#### \n   # \n  #  \n ##  \n #   \n#    \n#### \n     \n     \n',
    '^': u'      \n      \n  #   \n  #   \n # #  \n # #  \n#   # \n#   # \n      \n      \n      \n',
    'b': u'     \n#    \n#    \n# #  \n## # \n#  # \n#  # \n#  # \n###  \n     \n     \n',
    'f': u'     \n  ## \n #   \n#### \n #   \n #   \n #   \n #   \n #   \n     \n     \n',
    'j': u'   \n # \n   \n # \n # \n # \n # \n # \n # \n # \n#  \n',
    'n': u'     \n     \n     \n# #  \n## # \n#  # \n#  # \n#  # \n#  # \n     \n     \n',
    'r': u'    \n    \n    \n# # \n### \n#   \n#   \n#   \n#   \n    \n    \n',
    'v': u'     \n     \n     \n#  # \n#  # \n#  # \n#  # \n ##  \n ##  \n     \n     \n',
    'z': u'     \n     \n     \n#### \n   # \n  #  \n #   \n#    \n#### \n     \n     \n',
    '~': u'       \n       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n',
    '!': u'  \n  \n# \n# \n# \n# \n  \n# \n# \n  \n  \n',
    '%': u'        \n        \n #      \n# #  #  \n #  #   \n   #    \n  #  #  \n #  # # \n     #  \n        \n        \n',
    ')': u'   \n#  \n#  \n # \n # \n # \n # \n # \n#  \n#  \n   \n',
    '-': u'      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'    \n    \n  # \n### \n  # \n  # \n  # \n  # \n  # \n    \n    \n',
    '5': u'     \n     \n#### \n#    \n#    \n###  \n   # \n   # \n###  \n     \n     \n',
    '9': u'     \n     \n ##  \n#  # \n#  # \n ### \n   # \n   # \n###  \n     \n     \n',
    '=': u'      \n      \n      \n      \n##### \n      \n##### \n      \n      \n      \n      \n',
    'A': u'      \n      \n  #   \n  #   \n # #  \n # #  \n##### \n#   # \n#   # \n      \n      \n',
    'E': u'     \n     \n#### \n#    \n#    \n###  \n#    \n#    \n#### \n     \n     \n',
    'I': u'  \n  \n# \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'M': u'        \n        \n##   ## \n##   ## \n# # # # \n# ### # \n#  #  # \n#  #  # \n#     # \n        \n        \n',
    'Q': u'       \n       \n  ##   \n #  #  \n#    # \n#    # \n#    # \n #  #  \n  ##   \n    #  \n     # \n',
    'U': u'      \n      \n#   # \n#   # \n#   # \n#   # \n#   # \n#   # \n ###  \n      \n      \n',
    'Y': u'      \n      \n#   # \n#   # \n # #  \n  #   \n  #   \n  #   \n  #   \n      \n      \n',
    ']': u'   \n## \n # \n # \n # \n # \n # \n # \n # \n## \n   \n',
    'a': u'      \n      \n      \n ##   \n   #  \n ###  \n#  #  \n#  #  \n ## # \n      \n      \n',
    'e': u'     \n     \n     \n ##  \n#  # \n#### \n#    \n#    \n ### \n     \n     \n',
    'i': u'  \n# \n  \n# \n# \n# \n# \n# \n# \n  \n  \n',
    'm': u'        \n        \n        \n# #  #  \n## ## # \n#  #  # \n#  #  # \n#  #  # \n#  #  # \n        \n        \n',
    'q': u'     \n     \n     \n ### \n#  # \n#  # \n#  # \n# ## \n # # \n   # \n   # \n',
    'u': u'     \n     \n     \n#  # \n#  # \n#  # \n#  # \n# ## \n # # \n     \n     \n',
    'y': u'     \n     \n     \n#  # \n#  # \n#  # \n#  # \n ##  \n ##  \n #   \n##   \n',
    '}': u'    \n#   \n #  \n #  \n #  \n  # \n #  \n #  \n #  \n#   \n    \n'}

xsansb_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'       \n   #   \n ##### \n## #   \n## #   \n ####  \n  # ## \n  # ## \n#####  \n  #    \n       \n',
    '(': u'    \n  # \n ## \n##  \n##  \n##  \n##  \n##  \n ## \n  # \n    \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n## \n## \n # \n#  \n',
    '0': u'       \n       \n ####  \n##  ## \n##  ## \n##  ## \n##  ## \n##  ## \n ####  \n       \n       \n',
    '4': u'       \n       \n   ##  \n  ###  \n # ##  \n#  ##  \n###### \n   ##  \n   ##  \n       \n       \n',
    '8': u'       \n       \n ####  \n##  ## \n##  ## \n ####  \n##  ## \n##  ## \n ####  \n       \n       \n',
    '<': u'      \n      \n      \n   ## \n ##   \n##    \n ##   \n   ## \n      \n      \n      \n',
    '@': u'        \n        \n ####   \n##  ##  \n#  ###  \n# # ##  \n#  #### \n##      \n #####  \n        \n        \n',
    'D': u'       \n       \n####   \n## ##  \n##  ## \n##  ## \n##  ## \n## ##  \n####   \n       \n       \n',
    'H': u'       \n       \n##  ## \n##  ## \n##  ## \n###### \n##  ## \n##  ## \n##  ## \n       \n       \n',
    'L': u'      \n      \n##    \n##    \n##    \n##    \n##    \n##    \n##### \n      \n      \n',
    'P': u'      \n      \n####  \n## ## \n## ## \n####  \n##    \n##    \n##    \n      \n      \n',
    'T': u'       \n       \n###### \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n       \n       \n',
    'X': u'      \n      \n## ## \n## ## \n ###  \n  #   \n ###  \n## ## \n## ## \n      \n      \n',
    '\\': u'       \n##     \n##     \n ##    \n ##    \n  ##   \n   ##  \n   ##  \n    ## \n    ## \n       \n',
    '`': u'   \n # \n#  \n## \n## \n   \n   \n   \n   \n   \n   \n',
    'd': u'      \n   ## \n   ## \n #### \n## ## \n## ## \n## ## \n## ## \n ## # \n      \n      \n',
    'h': u'      \n##    \n##    \n## #  \n##### \n## ## \n## ## \n## ## \n## ## \n      \n      \n',
    'l': u'   \n## \n## \n## \n## \n## \n## \n## \n## \n   \n   \n',
    'p': u'      \n      \n      \n# ##  \n## ## \n## ## \n## ## \n## ## \n####  \n##    \n##    \n',
    't': u'     \n     \n ##  \n#### \n ##  \n ##  \n ##  \n ##  \n  ## \n     \n     \n',
    'x': u'     \n     \n     \n## # \n## # \n ##  \n ##  \n# ## \n# ## \n     \n     \n',
    '|': u'   \n## \n## \n## \n## \n## \n## \n## \n## \n## \n   \n',
    '#': u'       \n       \n ## #  \n ## #  \n### ## \n ## #  \n### ## \n ## #  \n ## #  \n       \n       \n',
    "'": u'   \n## \n## \n # \n#  \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n      \n',
    '/': u'       \n    ## \n    ## \n   ##  \n   ##  \n  ##   \n ##    \n ##    \n##     \n##     \n       \n',
    '3': u'       \n       \n ####  \n##  ## \n    ## \n  ###  \n    ## \n##  ## \n ####  \n       \n       \n',
    '7': u'       \n       \n###### \n###### \n    ## \n   ##  \n  ##   \n ##    \n ##    \n       \n       \n',
    ';': u'   \n   \n   \n## \n## \n   \n   \n## \n## \n # \n#  \n',
    '?': u'      \n      \n####  \n   ## \n   ## \n ###  \n      \n ##   \n ##   \n      \n      \n',
    'C': u'       \n       \n  #### \n ##    \n##     \n##     \n##     \n ##    \n  #### \n       \n       \n',
    'G': u'       \n       \n  #### \n ##    \n##     \n##  ## \n##  ## \n ## ## \n  #### \n       \n       \n',
    'K': u'        \n        \n##  ##  \n## ##   \n## #    \n####    \n## ##   \n##  ##  \n##   ## \n        \n        \n',
    'O': u'        \n        \n  ###   \n ## ##  \n##   ## \n##   ## \n##   ## \n ## ##  \n  ###   \n        \n        \n',
    'S': u'      \n      \n #### \n##    \n###   \n ###  \n  ### \n   ## \n####  \n      \n      \n',
    'W': u'          \n          \n##     ## \n##  #  ## \n##  #  ## \n ## ## #  \n ## ## #  \n  ## ##   \n  ## ##   \n          \n          \n',
    '[': u'    \n### \n##  \n##  \n##  \n##  \n##  \n##  \n##  \n### \n    \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n       \n',
    'c': u'     \n     \n     \n ### \n##   \n##   \n##   \n##   \n ### \n     \n     \n',
    'g': u'      \n      \n      \n #### \n## ## \n## ## \n## ## \n## ## \n #### \n   ## \n####  \n',
    'k': u'       \n##     \n##     \n##  #  \n## #   \n###    \n####   \n## ##  \n##  ## \n       \n       \n',
    'o': u'      \n      \n      \n ###  \n## ## \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    's': u'     \n     \n     \n ### \n##   \n###  \n ### \n  ## \n###  \n     \n     \n',
    'w': u'        \n        \n        \n##    # \n## ## # \n## ## # \n## ## # \n ## ##  \n ## ##  \n        \n        \n',
    '{': u'     \n  ## \n ##  \n ##  \n  #  \n##   \n  #  \n ##  \n ##  \n  ## \n     \n',
    '"': u'      \n## ## \n## ## \n#  #  \n#  #  \n      \n      \n      \n      \n      \n      \n',
    '&': u'       \n       \n ###   \n## ##  \n ###   \n ### # \n## ##  \n##  ## \n ### # \n       \n       \n',
    '*': u'      \n      \n## ## \n ##   \n## ## \n      \n      \n      \n      \n      \n      \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n## \n## \n   \n   \n',
    '2': u'       \n       \n ####  \n##  ## \n    ## \n  ###  \n ##    \n##     \n###### \n       \n       \n',
    '6': u'       \n       \n ####  \n##  ## \n##     \n#####  \n##  ## \n##  ## \n ####  \n       \n       \n',
    ':': u'   \n   \n   \n## \n## \n   \n   \n## \n## \n   \n   \n',
    '>': u'      \n      \n      \n##    \n  ##  \n   ## \n  ##  \n##    \n      \n      \n      \n',
    'B': u'      \n      \n####  \n## ## \n## ## \n####  \n## ## \n## ## \n####  \n      \n      \n',
    'F': u'      \n      \n##### \n##    \n##    \n####  \n##    \n##    \n##    \n      \n      \n',
    'J': u'     \n     \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n###  \n',
    'N': u'       \n       \n##   # \n###  # \n#### # \n# #### \n#  ### \n#   ## \n#    # \n       \n       \n',
    'R': u'       \n       \n####   \n## ##  \n## ##  \n####   \n## ##  \n## ##  \n##  ## \n       \n       \n',
    'V': u'       \n       \n##  ## \n##  ## \n##  ## \n ## #  \n ####  \n  ##   \n  ##   \n       \n       \n',
    'Z': u'      \n      \n##### \n   ## \n  ##  \n ###  \n ##   \n##    \n##### \n      \n      \n',
    '^': u'       \n       \n  ##   \n  ##   \n # ##  \n # ##  \n#   ## \n#   ## \n       \n       \n       \n',
    'b': u'      \n##    \n##    \n####  \n## ## \n## ## \n## ## \n## ## \n####  \n      \n      \n',
    'f': u'      \n  ### \n ##   \n##### \n ##   \n ##   \n ##   \n ##   \n ##   \n      \n      \n',
    'j': u'     \n  ## \n     \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n###  \n',
    'n': u'      \n      \n      \n# ##  \n## ## \n## ## \n## ## \n## ## \n## ## \n      \n      \n',
    'r': u'     \n     \n     \n## # \n#### \n##   \n##   \n##   \n##   \n     \n     \n',
    'v': u'       \n       \n       \n##  ## \n##  ## \n ## #  \n ## #  \n  ##   \n  ##   \n       \n       \n',
    'z': u'     \n     \n     \n#### \n  ## \n ##  \n ##  \n##   \n#### \n     \n     \n',
    '~': u'       \n       \n       \n       \n ### # \n# ###  \n       \n       \n       \n       \n       \n',
    '!': u'   \n   \n## \n## \n## \n # \n   \n## \n## \n   \n   \n',
    '%': u'          \n          \n ##   #   \n# ## ##   \n ##  #    \n    #     \n   #  ##  \n  ## # ## \n  #   ##  \n          \n          \n',
    ')': u'    \n#   \n##  \n ## \n ## \n ## \n ## \n ## \n##  \n#   \n    \n',
    '-': u'      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'     \n     \n  ## \n#### \n  ## \n  ## \n  ## \n  ## \n  ## \n     \n     \n',
    '5': u'       \n       \n###### \n##     \n##     \n#####  \n    ## \n##  ## \n ####  \n       \n       \n',
    '9': u'       \n       \n ####  \n##  ## \n##  ## \n ##### \n    ## \n##  ## \n ####  \n       \n       \n',
    '=': u'      \n      \n      \n      \n##### \n      \n##### \n      \n      \n      \n      \n',
    'A': u'       \n       \n  ##   \n  ##   \n # ##  \n # ##  \n###### \n#   ## \n#   ## \n       \n       \n',
    'E': u'      \n      \n##### \n##    \n##    \n####  \n##    \n##    \n##### \n      \n      \n',
    'I': u'   \n   \n## \n## \n## \n## \n## \n## \n## \n   \n   \n',
    'M': u'         \n         \n##    ## \n###  ### \n#### ### \n# ### ## \n#  #  ## \n#  #  ## \n#     ## \n         \n         \n',
    'Q': u'        \n        \n  ###   \n ## ##  \n##   ## \n##   ## \n##   ## \n ## ##  \n  ###   \n    ##  \n     ## \n',
    'U': u'       \n       \n##  ## \n##  ## \n##  ## \n##  ## \n##  ## \n##  ## \n ####  \n       \n       \n',
    'Y': u'       \n       \n##  ## \n##  ## \n ## #  \n  ##   \n  ##   \n  ##   \n  ##   \n       \n       \n',
    ']': u'    \n### \n ## \n ## \n ## \n ## \n ## \n ## \n ## \n### \n    \n',
    'a': u'       \n       \n       \n ###   \n   ##  \n ####  \n## ##  \n## ##  \n ## ## \n       \n       \n',
    'e': u'      \n      \n      \n ###  \n## ## \n## ## \n##### \n##    \n #### \n      \n      \n',
    'i': u'   \n## \n   \n## \n## \n## \n## \n## \n## \n   \n   \n',
    'm': u'         \n         \n         \n# ## ##  \n## ## ## \n## ## ## \n## ## ## \n## ## ## \n## ## ## \n         \n         \n',
    'q': u'      \n      \n      \n #### \n## ## \n## ## \n## ## \n## ## \n #### \n   ## \n   ## \n',
    'u': u'      \n      \n      \n## ## \n## ## \n## ## \n## ## \n## ## \n ## # \n      \n      \n',
    'y': u'       \n       \n       \n##  ## \n##  ## \n ## #  \n ## #  \n  ##   \n  ##   \n ##    \n ##    \n',
    '}': u'     \n##   \n ##  \n ##  \n #   \n  ## \n #   \n ##  \n ##  \n##   \n     \n'}

xsansbi_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'        \n    #   \n  ##### \n ## #   \n ####   \n  ###   \n  ####  \n  # ##  \n#####   \n  #     \n        \n',
    '(': u'      \n   ## \n  ##  \n ##   \n ##   \n##    \n##    \n##    \n##    \n ##   \n      \n',
    ',': u'    \n    \n    \n    \n    \n    \n    \n ## \n ## \n##  \n    \n',
    '0': u'       \n       \n  ###  \n ## ## \n #  ## \n##  ## \n##  #  \n## ##  \n ###   \n       \n       \n',
    '4': u'       \n       \n   ##  \n  ###  \n # ##  \n#  ##  \n###### \n  ##   \n  ##   \n       \n       \n',
    '8': u'        \n        \n  ####  \n ##  ## \n ##  ## \n #####  \n##  ##  \n##  ##  \n ####   \n        \n        \n',
    '<': u'       \n       \n       \n   ### \n ###   \n##     \n ##    \n  ##   \n       \n       \n       \n',
    '@': u'         \n         \n   ####  \n ##   ## \n #  #### \n#  # ##  \n#  ## ## \n#        \n #####   \n         \n         \n',
    'D': u'        \n        \n #####  \n ##  ## \n ##  ## \n###  ## \n##  ##  \n##  ##  \n####    \n        \n        \n',
    'H': u'        \n        \n ##  ## \n ##  ## \n ##  ## \n####### \n##  ##  \n##  ##  \n##  ##  \n        \n        \n',
    'L': u'      \n      \n ##   \n ##   \n ##   \n###   \n##    \n##    \n##### \n      \n      \n',
    'P': u'        \n        \n #####  \n ##  ## \n ##  ## \n#####   \n##      \n##      \n##      \n        \n        \n',
    'T': u'       \n       \n###### \n  ##   \n  ##   \n ###   \n ##    \n ##    \n ##    \n       \n       \n',
    'X': u'         \n         \n  ##  ## \n  ## ##  \n  ####   \n   ##    \n  ####   \n ## ##   \n##  ##   \n         \n         \n',
    '\\': u'     \n##   \n##   \n##   \n ##  \n ##  \n ##  \n  ## \n  ## \n  ## \n     \n',
    '`': u'    \n ## \n##  \n##  \n    \n    \n    \n    \n    \n    \n    \n',
    'd': u'        \n     ## \n     ## \n  ####  \n ## ##  \n##  ##  \n## ##   \n#####   \n## ##   \n        \n        \n',
    'h': u'       \n  ##   \n  ##   \n ## ## \n ##### \n ## ## \n##  #  \n## ##  \n## ##  \n       \n       \n',
    'l': u'     \n  ## \n  ## \n ##  \n ##  \n ##  \n##   \n##   \n##   \n     \n     \n',
    'p': u'        \n        \n        \n  ## ## \n  ##### \n  ## ## \n ##  ## \n ## ##  \n ####   \n##      \n##      \n',
    't': u'      \n      \n  ##  \n##### \n ##   \n ##   \n##    \n##    \n###   \n      \n      \n',
    'x': u'       \n       \n       \n ## ## \n ## ## \n  ###  \n ###   \n## ##  \n## ##  \n       \n       \n',
    '|': u'     \n  ## \n  ## \n  #  \n ##  \n ##  \n ##  \n #   \n##   \n##   \n     \n',
    '#': u'         \n         \n   ## #  \n   ## #  \n #### ## \n  ## #   \n#### ##  \n ## #    \n ## #    \n         \n         \n',
    "'": u'    \n ## \n ## \n##  \n    \n    \n    \n    \n    \n    \n    \n',
    '+': u'       \n       \n       \n   #   \n   #   \n###### \n  #    \n  #    \n       \n       \n       \n',
    '/': u'       \n    ## \n    ## \n   ##  \n   ##  \n  ##   \n ##    \n ##    \n##     \n##     \n       \n',
    '3': u'       \n       \n  ###  \n #  ## \n    ## \n  ###  \n   ##  \n#  ##  \n ###   \n       \n       \n',
    '7': u'       \n       \n ##### \n ##### \n    #  \n  ##   \n ##    \n##     \n##     \n       \n       \n',
    ';': u'     \n     \n     \n  ## \n  ## \n     \n     \n ##  \n ##  \n##   \n     \n',
    '?': u'      \n      \n ###  \n#  ## \n   ## \n ###  \n      \n##    \n##    \n      \n      \n',
    'C': u'       \n       \n   ### \n ###   \n ##    \n##     \n##     \n###    \n ####  \n       \n       \n',
    'G': u'        \n        \n   #### \n ###    \n ##     \n##  ##  \n##  ##  \n### ##  \n ####   \n        \n        \n',
    'K': u'        \n        \n ##  ## \n ## ##  \n ####   \n####    \n## ##   \n##  ##  \n##   ## \n        \n        \n',
    'O': u'         \n         \n   ####  \n ###  ## \n ##   ## \n##    ## \n##   ##  \n##  ###  \n ####    \n         \n         \n',
    'S': u'       \n       \n  #### \n ##    \n ##    \n  ##   \n   ##  \n   ##  \n####   \n       \n       \n',
    'W': u'           \n           \n##      ## \n##  ##  ## \n##  ##  #  \n## ### ##  \n## ### #   \n### ###    \n##  ##     \n           \n           \n',
    '[': u'      \n  ### \n  ##  \n  ##  \n ##   \n ##   \n ##   \n##    \n##    \n###   \n      \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n       \n',
    'c': u'      \n      \n      \n  ### \n ##   \n##    \n##    \n##    \n ###  \n      \n      \n',
    'g': u'       \n       \n       \n  #### \n ## ## \n##  ## \n## ##  \n#####  \n## ##  \n   ##  \n####   \n',
    'k': u'        \n  ##    \n  ##    \n ##  ## \n ## ##  \n ####   \n####    \n## ##   \n##  ##  \n        \n        \n',
    'o': u'       \n       \n       \n  ###  \n ## ## \n##  ## \n##  ## \n## ##  \n ###   \n       \n       \n',
    's': u'       \n       \n       \n  #### \n ##    \n ###   \n  ###  \n   ##  \n####   \n       \n       \n',
    'w': u'         \n         \n         \n##    ## \n## ## ## \n## ## ## \n## ## #  \n######   \n## ##    \n         \n         \n',
    '{': u'       \n    ## \n   ##  \n  ##   \n  ##   \n##     \n  #    \n ##    \n ##    \n  ##   \n       \n',
    '"': u'    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'         \n         \n  ###    \n ## ##   \n  ###    \n ###  ## \n## ## #  \n##  ##   \n ### ##  \n         \n         \n',
    '*': u'       \n       \n ## ## \n  ##   \n## ##  \n       \n       \n       \n       \n       \n       \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n## \n## \n   \n   \n',
    '2': u'       \n       \n  ###  \n #  ## \n    ## \n   ##  \n ##    \n#####  \n#####  \n       \n       \n',
    '6': u'        \n        \n   ###  \n  ##  # \n ##     \n ####   \n##  ##  \n##  ##  \n ####   \n        \n        \n',
    ':': u'    \n    \n    \n ## \n ## \n    \n    \n##  \n##  \n    \n    \n',
    '>': u'       \n       \n       \n  ##   \n   ##  \n    ## \n  ###  \n###    \n       \n       \n       \n',
    'B': u'       \n       \n ####  \n ## ## \n ## ## \n#####  \n##  ## \n##  ## \n#####  \n       \n       \n',
    'F': u'       \n       \n ##### \n ##    \n ##    \n#####  \n##     \n##     \n##     \n       \n       \n',
    'J': u'      \n      \n   ## \n   ## \n   ## \n  ### \n  ##  \n  ##  \n ###  \n###   \n      \n',
    'N': u'        \n        \n ##   # \n ###  # \n ###  # \n # ###  \n## ###  \n#   ##  \n#   ##  \n        \n        \n',
    'R': u'        \n        \n #####  \n ##  ## \n ##  ## \n######  \n## ##   \n##  ##  \n##  ##  \n        \n        \n',
    'V': u'       \n       \n##  ## \n##  ## \n##  #  \n## ##  \n## #   \n###    \n##     \n       \n       \n',
    'Z': u'       \n       \n ##### \n   ### \n   ##  \n  ##   \n ##    \n###    \n#####  \n       \n       \n',
    '^': u'       \n       \n       \n    ## \n   ### \n  # ## \n #  ## \n#   ## \n       \n       \n       \n',
    'b': u'       \n  ##   \n  ##   \n  # ## \n ##### \n ## ## \n##  ## \n## ##  \n####   \n       \n       \n',
    'f': u'       \n   ### \n  ##   \n ##### \n  ##   \n ##    \n ##    \n ##    \n##     \n##     \n##     \n',
    'j': u'       \n    ## \n       \n   ##  \n   ##  \n   ##  \n  ##   \n  ##   \n  ##   \n ##    \n###    \n',
    'n': u'       \n       \n       \n ## ## \n ##### \n ## ## \n##  #  \n## ##  \n## ##  \n       \n       \n',
    'r': u'      \n      \n      \n ## # \n #### \n ##   \n##    \n##    \n##    \n      \n      \n',
    'v': u'       \n       \n       \n##  ## \n##  ## \n## ##  \n## #   \n###    \n##     \n       \n       \n',
    'z': u'       \n       \n       \n ##### \n    ## \n  ###  \n ###   \n##     \n#####  \n       \n       \n',
    '~': u'       \n       \n       \n       \n ### # \n# ###  \n       \n       \n       \n       \n       \n',
    '!': u'     \n     \n  ## \n  ## \n ##  \n ##  \n     \n##   \n##   \n     \n     \n',
    '%': u'         \n         \n ##   #  \n# ## ##  \n ## ##   \n   ##    \n  ## ##  \n ## # ## \n #   ##  \n         \n         \n',
    ')': u'      \n  ##  \n   ## \n   ## \n   ## \n   ## \n  ##  \n  ##  \n ##   \n##    \n      \n',
    '-': u'       \n       \n       \n       \n       \n###### \n       \n       \n       \n       \n       \n',
    '1': u'     \n     \n  ## \n#### \n  ## \n ### \n ##  \n ##  \n ##  \n     \n     \n',
    '5': u'       \n       \n  #### \n ##### \n #     \n ###   \n   ##  \n#  ##  \n ###   \n       \n       \n',
    '9': u'        \n        \n  ####  \n ##  ## \n ##  ## \n  ####  \n    ##  \n#  ##   \n ###    \n        \n        \n',
    '=': u'       \n       \n       \n       \n ##### \n       \n#####  \n       \n       \n       \n       \n',
    'A': u'       \n       \n    ## \n   ### \n  # ## \n ## ## \n ##### \n##  ## \n##  ## \n       \n       \n',
    'E': u'       \n       \n ##### \n ##    \n ##    \n#####  \n##     \n##     \n#####  \n       \n       \n',
    'I': u'    \n    \n ## \n ## \n ## \n### \n##  \n##  \n##  \n    \n    \n',
    'M': u'          \n          \n ##    ## \n ###  ### \n ##### ## \n## ##  ## \n#  ## ##  \n#  #  ##  \n#     ##  \n          \n          \n',
    'Q': u'         \n         \n   ####  \n ###  ## \n ##   ## \n##    ## \n##   ##  \n##  ###  \n ####    \n    ###  \n      ## \n',
    'U': u'        \n        \n ##  ## \n ##  ## \n ##  ## \n##  ##  \n##  ##  \n##  #   \n ###    \n        \n        \n',
    'Y': u'       \n       \n##  ## \n##  ## \n## ##  \n ###   \n ##    \n ##    \n ##    \n       \n       \n',
    ']': u'      \n  ### \n   ## \n   ## \n  ##  \n  ##  \n  ##  \n ##   \n ##   \n###   \n      \n',
    'a': u'       \n       \n       \n  #### \n ## ## \n##  ## \n## ##  \n#####  \n## ##  \n       \n       \n',
    'e': u'      \n      \n      \n  ### \n # ## \n## ## \n####  \n##    \n ###  \n      \n      \n',
    'i': u'     \n  ## \n     \n ##  \n ##  \n ##  \n##   \n##   \n##   \n     \n     \n',
    'm': u'          \n          \n          \n ## ## ## \n ######## \n ## ## ## \n##  #  #  \n## ## ##  \n## ## ##  \n          \n          \n',
    'q': u'       \n       \n       \n  #### \n ## ## \n##  ## \n## ##  \n#####  \n## ##  \n  ##   \n  ##   \n',
    'u': u'       \n       \n       \n ## ## \n ## ## \n #  ## \n## ##  \n#####  \n## ##  \n       \n       \n',
    'y': u'        \n        \n        \n ##  ## \n ##  ## \n ##  ## \n ## ##  \n ## #   \n ###    \n ##     \n##      \n',
    '}': u'       \n  ##   \n   ##  \n   ##  \n   #   \n    ## \n  ##   \n  ##   \n ##    \n##     \n       \n'}

xsansi_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'       \n   #   \n  #### \n # #   \n # #   \n  ##   \n  # #  \n  # #  \n####   \n  #    \n       \n',
    '(': u'     \n   # \n  #  \n #   \n #   \n#    \n#    \n#    \n#    \n #   \n     \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n # \n # \n#  \n   \n',
    '0': u'      \n      \n  ##  \n #  # \n #  # \n#   # \n#  #  \n#  #  \n ##   \n      \n      \n',
    '4': u'      \n      \n   ## \n  # # \n #  # \n#  #  \n##### \n   #  \n   #  \n      \n      \n',
    '8': u'      \n      \n  ##  \n #  # \n #  # \n ###  \n#   # \n#   # \n ###  \n      \n      \n',
    '<': u'       \n       \n       \n    ## \n  ##   \n##     \n  #    \n   #   \n       \n       \n       \n',
    '@': u'        \n        \n   ###  \n  #   # \n #  ### \n#  # #  \n#  #### \n#       \n ####   \n        \n        \n',
    'D': u'       \n       \n ####  \n #   # \n #   # \n##   # \n#    # \n#   #  \n####   \n       \n       \n',
    'H': u'      \n      \n #  # \n #  # \n #  # \n##### \n#  #  \n#  #  \n#  #  \n      \n      \n',
    'L': u'     \n     \n #   \n #   \n #   \n##   \n#    \n#    \n#### \n     \n     \n',
    'P': u'      \n      \n ###  \n #  # \n #  # \n####  \n#     \n#     \n#     \n      \n      \n',
    'T': u'      \n      \n##### \n  #   \n  #   \n ##   \n #    \n #    \n #    \n      \n      \n',
    'X': u'      \n      \n #  # \n #  # \n ###  \n  #   \n ###  \n#  #  \n#  #  \n      \n      \n',
    '\\': u'      \n#     \n#     \n #    \n #    \n  #   \n   #  \n   #  \n    # \n    # \n      \n',
    '`': u'   \n # \n#  \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'       \n     # \n     # \n  ###  \n #  #  \n#   #  \n#  #   \n# ##   \n## #   \n       \n       \n',
    'h': u'      \n  #   \n  #   \n # ## \n ## # \n #  # \n#  #  \n#  #  \n#  #  \n      \n      \n',
    'l': u'    \n  # \n  # \n #  \n #  \n #  \n#   \n#   \n#   \n    \n    \n',
    'p': u'       \n       \n       \n  # ## \n  ## # \n  #  # \n #   # \n #  #  \n ###   \n#      \n#      \n',
    't': u'     \n     \n  #  \n#### \n #   \n #   \n#    \n#    \n##   \n     \n     \n',
    'x': u'       \n       \n       \n  #  # \n  # #  \n  ##   \n  ##   \n # #   \n#  #   \n       \n       \n',
    '|': u'    \n  # \n  # \n  # \n #  \n #  \n #  \n#   \n#   \n#   \n    \n',
    '#': u'        \n        \n   # #  \n   # #  \n ### ## \n  # #   \n### ##  \n # #    \n # #    \n        \n        \n',
    "'": u'   \n # \n # \n#  \n   \n   \n   \n   \n   \n   \n   \n',
    '+': u'       \n       \n       \n   #   \n   #   \n###### \n  #    \n  #    \n       \n       \n       \n',
    '/': u'       \n     # \n     # \n    #  \n   #   \n   #   \n  #    \n #     \n#      \n#      \n       \n',
    '3': u'      \n      \n ###  \n    # \n    # \n  ##  \n   #  \n   #  \n###   \n      \n      \n',
    '7': u'       \n       \n ##### \n     # \n    #  \n   #   \n  #    \n #     \n#      \n       \n       \n',
    ';': u'    \n    \n    \n  # \n  # \n    \n    \n #  \n #  \n#   \n    \n',
    '?': u'     \n     \n ##  \n#  # \n   # \n ##  \n     \n#    \n#    \n     \n     \n',
    'C': u'       \n       \n  #### \n #     \n#      \n#      \n#      \n#      \n ####  \n       \n       \n',
    'G': u'       \n       \n  #### \n #     \n#      \n#   #  \n#   #  \n#   #  \n ###   \n       \n       \n',
    'K': u'       \n       \n #   # \n #  #  \n # #   \n###    \n# #    \n#  #   \n#   #  \n       \n       \n',
    'O': u'       \n       \n  ###  \n #   # \n#    # \n#    # \n#    # \n#   #  \n ###   \n       \n       \n',
    'S': u'      \n      \n  ### \n #    \n #    \n  #   \n   #  \n   #  \n###   \n      \n      \n',
    'W': u'        \n        \n#     # \n#  #  # \n#  #  # \n# ## #  \n# ## #  \n## ##   \n#  #    \n        \n        \n',
    '[': u'     \n  ## \n  #  \n  #  \n #   \n #   \n #   \n#    \n#    \n##   \n     \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \n      \n      \n##### \n      \n',
    'c': u'     \n     \n     \n  ## \n #   \n#    \n#    \n#    \n ##  \n     \n     \n',
    'g': u'      \n      \n      \n  ### \n #  # \n#   # \n#  #  \n# ##  \n## #  \n   #  \n###   \n',
    'k': u'      \n  #   \n  #   \n #  # \n # #  \n ##   \n# #   \n#  #  \n#   # \n      \n      \n',
    'o': u'      \n      \n      \n  ##  \n #  # \n#   # \n#   # \n#  #  \n ##   \n      \n      \n',
    's': u'      \n      \n      \n  ### \n #    \n ##   \n  ##  \n   #  \n###   \n      \n      \n',
    'w': u'        \n        \n        \n#     # \n#  #  # \n#  #  # \n# ## #  \n## ##   \n#  #    \n        \n        \n',
    '{': u'      \n    # \n   #  \n  #   \n  #   \n##    \n  #   \n #    \n #    \n  #   \n      \n',
    '"': u'    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'       \n       \n  ###  \n #  #  \n  ##   \n ##  # \n#  # # \n#  ##  \n###  # \n       \n       \n',
    '*': u'      \n      \n # ## \n  #   \n## #  \n      \n      \n      \n      \n      \n      \n',
    '.': u'  \n  \n  \n  \n  \n  \n  \n# \n# \n  \n  \n',
    '2': u'      \n      \n ###  \n    # \n    # \n  ##  \n #    \n#     \n####  \n      \n      \n',
    '6': u'       \n       \n   ### \n  #    \n #     \n ###   \n#   #  \n#   #  \n ###   \n       \n       \n',
    ':': u'   \n   \n   \n # \n # \n   \n   \n#  \n#  \n   \n   \n',
    '>': u'       \n       \n       \n  #    \n   #   \n    ## \n  ##   \n##     \n       \n       \n       \n',
    'B': u'     \n     \n ##  \n # # \n # # \n###  \n#  # \n#  # \n###  \n     \n     \n',
    'F': u'      \n      \n #### \n #    \n #    \n####  \n#     \n#     \n#     \n      \n      \n',
    'J': u'     \n     \n   # \n   # \n   # \n  ## \n  #  \n  #  \n  #  \n##   \n     \n',
    'N': u'       \n       \n ##  # \n ##  # \n # # # \n # # # \n#  ##  \n#   #  \n#   #  \n       \n       \n',
    'R': u'      \n      \n ###  \n #  # \n #  # \n####  \n# #   \n#  #  \n#   # \n      \n      \n',
    'V': u'      \n      \n#   # \n#   # \n#  #  \n#  #  \n# #   \n##    \n#     \n      \n      \n',
    'Z': u'       \n       \n ##### \n    #  \n   #   \n  #    \n #     \n#      \n#####  \n       \n       \n',
    '^': u'      \n      \n    # \n   ## \n  # # \n #  # \n#   # \n#   # \n      \n      \n      \n',
    'b': u'      \n  #   \n  #   \n # ## \n ## # \n #  # \n#   # \n#  #  \n###   \n      \n      \n',
    'f': u'      \n   ## \n  #   \n #### \n  #   \n #    \n #    \n #    \n#     \n#     \n#     \n',
    'j': u'      \n    # \n      \n   #  \n   #  \n   #  \n  #   \n  #   \n  #   \n #    \n##    \n',
    'n': u'      \n      \n      \n # ## \n ## # \n #  # \n#  #  \n#  #  \n#  #  \n      \n      \n',
    'r': u'     \n     \n     \n # # \n ### \n #   \n#    \n#    \n#    \n     \n     \n',
    'v': u'     \n     \n     \n#  # \n#  # \n#  # \n# #  \n##   \n#    \n     \n     \n',
    'z': u'      \n      \n      \n #### \n   #  \n  #   \n #    \n#     \n####  \n      \n      \n',
    '~': u'       \n       \n       \n       \n ##  # \n#  ##  \n       \n       \n       \n       \n       \n',
    '!': u'    \n    \n  # \n  # \n #  \n #  \n    \n#   \n#   \n    \n    \n',
    '%': u'        \n        \n #      \n# #  #  \n #  #   \n   #    \n  #  #  \n #  # # \n     #  \n        \n        \n',
    ')': u'     \n  #  \n   # \n   # \n   # \n   # \n  #  \n  #  \n #   \n#    \n     \n',
    '-': u'       \n       \n       \n       \n       \n###### \n       \n       \n       \n       \n       \n',
    '1': u'    \n    \n  # \n### \n  # \n ## \n #  \n #  \n #  \n    \n    \n',
    '5': u'       \n       \n  #### \n #     \n ###   \n    #  \n    #  \n   #   \n###    \n       \n       \n',
    '9': u'       \n       \n  ###  \n #   # \n #   # \n  ###  \n    #  \n   #   \n###    \n       \n       \n',
    '=': u'       \n       \n       \n       \n ##### \n       \n#####  \n       \n       \n       \n       \n',
    'A': u'      \n      \n    # \n   ## \n  # # \n #  # \n #### \n#   # \n#   # \n      \n      \n',
    'E': u'      \n      \n #### \n #    \n #    \n####  \n#     \n#     \n####  \n      \n      \n',
    'I': u'   \n   \n # \n # \n # \n## \n#  \n#  \n#  \n   \n   \n',
    'M': u'        \n        \n #    # \n ##  ## \n # ## # \n## #  # \n#  # #  \n#    #  \n#    #  \n        \n        \n',
    'Q': u'       \n       \n  ###  \n #   # \n#    # \n#    # \n#    # \n#   #  \n ###   \n    #  \n     # \n',
    'U': u'       \n       \n #   # \n #   # \n #   # \n#   #  \n#   #  \n#  #   \n ##    \n       \n       \n',
    'Y': u'      \n      \n#   # \n#   # \n#  #  \n ##   \n #    \n #    \n #    \n      \n      \n',
    ']': u'     \n  ## \n   # \n   # \n  #  \n  #  \n  #  \n #   \n #   \n##   \n     \n',
    'a': u'      \n      \n      \n  ### \n #  # \n#   # \n#  #  \n# ##  \n## #  \n      \n      \n',
    'e': u'      \n      \n      \n  ### \n #  # \n#  #  \n###   \n#     \n ###  \n      \n      \n',
    'i': u'    \n  # \n    \n #  \n #  \n #  \n#   \n#   \n#   \n    \n    \n',
    'm': u'         \n         \n         \n # ## ## \n ## ## # \n #  #  # \n#  #  #  \n#  #  #  \n#  #  #  \n         \n         \n',
    'q': u'      \n      \n      \n  ### \n #  # \n#   # \n#  #  \n# ##  \n## #  \n  #   \n  #   \n',
    'u': u'      \n      \n      \n #  # \n #  # \n #  # \n#  #  \n# ##  \n## #  \n      \n      \n',
    'y': u'       \n       \n       \n  #  # \n  #  # \n  #  # \n  # #  \n  # #  \n  ##   \n  #    \n##     \n',
    '}': u'      \n  #   \n   #  \n   #  \n  #   \n   ## \n  #   \n  #   \n #    \n#     \n      \n'}

xtimes_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'      \n      \n  #   \n ###  \n# # # \n###   \n ###  \n  ### \n# # # \n####  \n  #   \n      \n      \n',
    '(': u'    \n    \n    \n  # \n ## \n #  \n##  \n##  \n##  \n##  \n #  \n ## \n  # \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n   \n## \n## \n # \n   \n   \n',
    '0': u'     \n     \n     \n ##  \n## # \n## # \n## # \n## # \n## # \n ##  \n     \n     \n     \n',
    '4': u'      \n      \n      \n   #  \n  ##  \n # #  \n#  #  \n##### \n  ##  \n  ##  \n      \n      \n      \n',
    '8': u'     \n     \n     \n ##  \n## # \n## # \n ##  \n# ## \n# ## \n ##  \n     \n     \n     \n',
    '<': u'      \n      \n      \n      \n      \n   ## \n ###  \n##    \n ###  \n   ## \n      \n      \n      \n',
    '@': u'            \n            \n            \n    #####   \n  ##    ##  \n ## ## # ## \n## ## #  ## \n## #  #  ## \n## #  #  #  \n##  ## ##   \n ##         \n  #####     \n            \n',
    'D': u'        \n        \n        \n######  \n ##  ## \n ##  ## \n ##  ## \n ##  ## \n ##  ## \n######  \n        \n        \n        \n',
    'H': u'         \n         \n         \n###  ### \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n###  ### \n         \n         \n         \n',
    'L': u'       \n       \n       \n####   \n ##    \n ##    \n ##    \n ##  # \n ## ## \n###### \n       \n       \n       \n',
    'P': u'       \n       \n       \n#####  \n ## ## \n ## ## \n ####  \n ##    \n ##    \n####   \n       \n       \n       \n',
    'T': u'       \n       \n       \n###### \n# ## # \n  ##   \n  ##   \n  ##   \n  ##   \n ####  \n       \n       \n       \n',
    'X': u'        \n        \n        \n###  ## \n ##  #  \n  ###   \n  ###   \n  # ##  \n #   ## \n##  ### \n        \n        \n        \n',
    '\\': u'    \n    \n    \n#   \n#   \n##  \n #  \n ## \n  # \n  # \n    \n    \n    \n',
    '`': u'   \n   \n   \n#  \n## \n## \n   \n   \n   \n   \n   \n   \n   \n',
    'd': u'       \n       \n       \n  ###  \n   ##  \n ####  \n## ##  \n## ##  \n## ##  \n ## ## \n       \n       \n       \n',
    'h': u'      \n      \n      \n##    \n##    \n####  \n## #  \n## #  \n## #  \n## ## \n      \n      \n      \n',
    'l': u'   \n   \n   \n## \n## \n## \n## \n## \n## \n## \n   \n   \n   \n',
    'p': u'     \n     \n     \n     \n     \n###  \n## # \n## # \n## # \n###  \n##   \n###  \n     \n',
    't': u'    \n    \n    \n #  \n##  \n### \n##  \n##  \n##  \n ## \n    \n    \n    \n',
    'x': u'     \n     \n     \n     \n     \n## # \n#### \n ##  \n#### \n# ## \n     \n     \n     \n',
    '|': u'  \n  \n  \n# \n# \n# \n# \n# \n# \n# \n# \n# \n  \n',
    '#': u'      \n      \n      \n # #  \n # #  \n##### \n # #  \n##### \n # #  \n # #  \n      \n      \n      \n',
    "'": u'   \n   \n   \n## \n## \n # \n   \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n      \n',
    '/': u'    \n    \n    \n  # \n  # \n ## \n #  \n##  \n#   \n#   \n    \n    \n    \n',
    '3': u'     \n     \n     \n ##  \n# ## \n  ## \n ##  \n  ## \n# ## \n###  \n     \n     \n     \n',
    '7': u'      \n      \n      \n #### \n####  \n#  #  \n  ##  \n  #   \n ##   \n ##   \n      \n      \n      \n',
    ';': u'   \n   \n   \n   \n   \n## \n## \n   \n## \n## \n # \n   \n   \n',
    '?': u'     \n     \n     \n ##  \n# ## \n# ## \n  #  \n     \n ##  \n ##  \n     \n     \n     \n',
    'C': u'       \n       \n       \n ##### \n##  ## \n##     \n##     \n##     \n### ## \n ####  \n       \n       \n       \n',
    'G': u'       \n       \n       \n ##### \n##  ## \n##     \n## ### \n##  ## \n##  ## \n ####  \n       \n       \n       \n',
    'K': u'         \n         \n         \n### ###  \n ##  #   \n ## #    \n ####    \n ## ##   \n ## ###  \n###  ### \n         \n         \n         \n',
    'O': u'       \n       \n       \n ####  \n##  ## \n##  ## \n##  ## \n##  ## \n##  ## \n ####  \n       \n       \n       \n',
    'S': u'      \n      \n      \n #### \n##  # \n###   \n ###  \n  ### \n#  ## \n####  \n      \n      \n      \n',
    'W': u'           \n           \n           \n### ### ## \n ## ##  #  \n ## ## ##  \n ## ## #   \n  ## ###   \n  ## ##    \n   #  #    \n           \n           \n           \n',
    '[': u'    \n    \n    \n### \n##  \n##  \n##  \n##  \n##  \n##  \n##  \n##  \n### \n',
    '_': u'      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n      \n##### \n',
    'c': u'     \n     \n     \n     \n     \n ### \n## # \n##   \n## # \n ### \n     \n     \n     \n',
    'g': u'      \n      \n      \n      \n      \n #### \n## #  \n## #  \n ###  \n##    \n####  \n#  #  \n####  \n',
    'k': u'      \n      \n      \n##    \n##    \n## ## \n## #  \n###   \n## #  \n## ## \n      \n      \n      \n',
    'o': u'      \n      \n      \n      \n      \n ###  \n## ## \n## ## \n## ## \n ###  \n      \n      \n      \n',
    's': u'    \n    \n    \n    \n    \n ## \n##  \n### \n ## \n### \n    \n    \n    \n',
    'w': u'       \n       \n       \n       \n       \n# # ## \n# # #  \n# ###  \n####   \n # #   \n       \n       \n       \n',
    '{': u'     \n     \n     \n  ## \n ##  \n ##  \n #   \n##   \n##   \n #   \n ##  \n ##  \n  ## \n',
    '"': u'    \n    \n    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'        \n        \n        \n  ##    \n ## #   \n ## #   \n ### ## \n## ###  \n##  ##  \n ### ## \n        \n        \n        \n',
    '*': u'      \n      \n      \n  #   \n##### \n ###  \n##### \n  #   \n      \n      \n      \n      \n      \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n   \n## \n## \n   \n   \n   \n',
    '2': u'     \n     \n     \n ##  \n#### \n  ## \n  #  \n #   \n#### \n#### \n     \n     \n     \n',
    '6': u'     \n     \n     \n  ## \n ##  \n##   \n#### \n## # \n## # \n ##  \n     \n     \n     \n',
    ':': u'   \n   \n   \n   \n   \n## \n## \n   \n## \n## \n   \n   \n   \n',
    '>': u'      \n      \n      \n      \n      \n##    \n ###  \n   ## \n ###  \n##    \n      \n      \n      \n',
    'B': u'       \n       \n       \n#####  \n ## ## \n ## ## \n ####  \n ## ## \n ## ## \n#####  \n       \n       \n       \n',
    'F': u'       \n       \n       \n###### \n ##  # \n ## #  \n ####  \n ## #  \n ##    \n####   \n       \n       \n       \n',
    'J': u'     \n     \n     \n#### \n ##  \n ##  \n ##  \n ##  \n ##  \n ##  \n##   \n     \n     \n',
    'N': u'        \n        \n        \n### ### \n ##  #  \n ### #  \n # # #  \n # ###  \n #  ##  \n###  #  \n        \n        \n        \n',
    'R': u'        \n        \n        \n#####   \n ## ##  \n ## ##  \n ####   \n ## #   \n ## ##  \n### ### \n        \n        \n        \n',
    'V': u'         \n         \n         \n####  ## \n ##   #  \n ### #   \n  ## #   \n  ###    \n   ##    \n   #     \n         \n         \n         \n',
    'Z': u'       \n       \n       \n###### \n##  ## \n#  ##  \n  ##   \n ##  # \n##  ## \n###### \n       \n       \n       \n',
    '^': u'      \n      \n      \n  #   \n ###  \n## ## \n#   # \n      \n      \n      \n      \n      \n      \n',
    'b': u'     \n     \n     \n##   \n##   \n###  \n## # \n## # \n## # \n###  \n     \n     \n     \n',
    'f': u'    \n    \n    \n ## \n##  \n### \n##  \n##  \n##  \n### \n    \n    \n    \n',
    'j': u'    \n    \n ## \n ## \n    \n ## \n ## \n ## \n ## \n ## \n ## \n##  \n    \n',
    'n': u'       \n       \n       \n       \n       \n# ##   \n## ##  \n## ##  \n## ##  \n## ### \n       \n       \n       \n',
    'r': u'     \n     \n     \n     \n     \n## # \n#### \n##   \n##   \n##   \n     \n     \n     \n',
    'v': u'      \n      \n      \n      \n      \n## ## \n## #  \n ###  \n ##   \n  #   \n      \n      \n      \n',
    'z': u'     \n     \n     \n     \n     \n#### \n# ## \n ##  \n## # \n#### \n     \n     \n     \n',
    '~': u'      \n      \n      \n      \n      \n      \n ## # \n# ##  \n      \n      \n      \n      \n      \n',
    '!': u'   \n   \n   \n## \n## \n## \n## \n   \n## \n## \n   \n   \n   \n',
    '%': u'        \n        \n        \n ### ## \n## ###  \n### #   \n   #    \n  # ### \n # ## # \n#  ###  \n        \n        \n        \n',
    ')': u'    \n    \n    \n#   \n##  \n #  \n ## \n ## \n ## \n ## \n #  \n##  \n#   \n',
    '-': u'     \n     \n     \n     \n     \n     \n     \n#### \n     \n     \n     \n     \n     \n',
    '1': u'     \n     \n     \n ##  \n###  \n ##  \n ##  \n ##  \n ##  \n#### \n     \n     \n     \n',
    '5': u'     \n     \n     \n###  \n###  \n#    \n###  \n  ## \n# ## \n###  \n     \n     \n     \n',
    '9': u'     \n     \n     \n ##  \n# ## \n# ## \n# ## \n ### \n  #  \n##   \n     \n     \n     \n',
    '=': u'      \n      \n      \n      \n      \n      \n##### \n      \n##### \n      \n      \n      \n      \n',
    'A': u'         \n         \n         \n   #     \n   ##    \n  ###    \n  # ##   \n #####   \n #  ###  \n### #### \n         \n         \n         \n',
    'E': u'       \n       \n       \n###### \n ##  # \n ##    \n ###   \n ##    \n ##  # \n###### \n       \n       \n       \n',
    'I': u'     \n     \n     \n#### \n ##  \n ##  \n ##  \n ##  \n ##  \n#### \n     \n     \n     \n',
    'M': u'          \n          \n          \n###   ### \n ###  ##  \n ### ###  \n # ## ##  \n # ## ##  \n #  # ##  \n###   ### \n          \n          \n          \n',
    'Q': u'       \n       \n       \n ####  \n##  ## \n##  ## \n##  ## \n##  ## \n##  ## \n ####  \n  ##   \n   ### \n       \n',
    'U': u'        \n        \n        \n#### ## \n ##  #  \n ##  #  \n ##  #  \n ##  #  \n ##  #  \n  ###   \n        \n        \n        \n',
    'Y': u'         \n         \n         \n#### ### \n ##   #  \n  ## #   \n  ###    \n   ##    \n   ##    \n  ####   \n         \n         \n         \n',
    ']': u'    \n    \n    \n### \n ## \n ## \n ## \n ## \n ## \n ## \n ## \n ## \n### \n',
    'a': u'      \n      \n      \n      \n      \n ##   \n# ##  \n ###  \n#  #  \n##### \n      \n      \n      \n',
    'e': u'     \n     \n     \n     \n     \n ### \n## # \n#### \n##   \n ### \n     \n     \n     \n',
    'i': u'   \n   \n## \n## \n   \n## \n## \n## \n## \n## \n   \n   \n   \n',
    'm': u'         \n         \n         \n         \n         \n# # ##   \n#######  \n## # ##  \n## # ##  \n## # ### \n         \n         \n         \n',
    'q': u'      \n      \n      \n      \n      \n ###  \n## #  \n## #  \n## #  \n ###  \n  ##  \n  ### \n      \n',
    'u': u'      \n      \n      \n      \n      \n## ## \n## #  \n## #  \n## #  \n ###  \n      \n      \n      \n',
    'y': u'      \n      \n      \n      \n      \n## ## \n## ## \n ###  \n ###  \n  #   \n# #   \n###   \n      \n',
    '}': u'     \n     \n     \n##   \n ##  \n ##  \n  #  \n  ## \n  ## \n  #  \n ##  \n ##  \n##   \n'}

xttyb_dic = {
    ' ': u'  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n  \n',
    '$': u'   #  \n   #  \n #### \n##    \n###   \n ###  \n  ### \n   ## \n####  \n #    \n #    \n',
    '(': u'     \n  ## \n ##  \n##   \n##   \n##   \n##   \n##   \n ##  \n  ## \n     \n',
    ',': u'   \n   \n   \n   \n   \n   \n   \n## \n## \n # \n#  \n',
    '0': u'      \n      \n ###  \n## ## \n## ## \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    '4': u'      \n      \n  ##  \n ###  \n# ##  \n# ##  \n##### \n  ##  \n  ##  \n      \n      \n',
    '8': u'      \n      \n ###  \n## ## \n## ## \n ###  \n## ## \n## ## \n ###  \n      \n      \n',
    '<': u'     \n     \n     \n  ## \n ##  \n##   \n ##  \n  ## \n     \n     \n     \n',
    '@': u'      \n      \n ###  \n#   # \n# ### \n# # # \n# ### \n#     \n #### \n      \n      \n',
    'D': u'      \n      \n####  \n## ## \n##  # \n##  # \n##  # \n## ## \n####  \n      \n      \n',
    'H': u'      \n      \n##  # \n##  # \n##  # \n##### \n##  # \n##  # \n##  # \n      \n      \n',
    'L': u'      \n      \n##    \n##    \n##    \n##    \n##    \n##    \n##### \n      \n      \n',
    'P': u'      \n      \n####  \n##  # \n##  # \n####  \n##    \n##    \n##    \n      \n      \n',
    'T': u'       \n       \n###### \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n       \n       \n',
    'X': u'      \n      \n##  # \n##  # \n ###  \n  #   \n ###  \n#  ## \n#  ## \n      \n      \n',
    '\\': u'       \n##     \n##     \n ##    \n ##    \n  ##   \n   ##  \n   ##  \n    ## \n    ## \n       \n',
    '`': u'   \n # \n#  \n## \n## \n   \n   \n   \n   \n   \n   \n',
    'd': u'      \n   ## \n   ## \n #### \n## ## \n## ## \n## ## \n## ## \n ## # \n      \n      \n',
    'h': u'      \n##    \n##    \n## #  \n##### \n## ## \n## ## \n## ## \n## ## \n      \n      \n',
    'l': u'     \n#### \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n     \n     \n',
    'p': u'      \n      \n      \n# ##  \n## ## \n## ## \n## ## \n## ## \n####  \n##    \n##    \n',
    't': u'      \n      \n ##   \n##### \n ##   \n ##   \n ##   \n ##   \n  ### \n      \n      \n',
    'x': u'       \n       \n       \n### ## \n ## #  \n  ##   \n  ##   \n # ##  \n## ### \n       \n       \n',
    '|': u'   \n## \n## \n## \n## \n## \n## \n## \n## \n## \n   \n',
    '#': u'       \n       \n ## #  \n ## #  \n### ## \n ## #  \n### ## \n ## #  \n ## #  \n       \n       \n',
    "'": u'   \n## \n## \n # \n#  \n   \n   \n   \n   \n   \n   \n',
    '+': u'      \n      \n      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n      \n      \n',
    '/': u'       \n    ## \n    ## \n   ##  \n   ##  \n  ##   \n ##    \n ##    \n##     \n##     \n       \n',
    '3': u'      \n      \n ###  \n## ## \n   ## \n ###  \n   ## \n## ## \n ###  \n      \n      \n',
    '7': u'      \n      \n##### \n##### \n    # \n   #  \n  ##  \n ##   \n ##   \n      \n      \n',
    ';': u'   \n   \n   \n## \n## \n   \n   \n## \n## \n # \n#  \n',
    '?': u'      \n      \n####  \n   ## \n   ## \n ###  \n      \n ##   \n ##   \n      \n      \n',
    'C': u'      \n      \n #### \n### # \n##    \n##    \n##    \n###   \n #### \n      \n      \n',
    'G': u'      \n      \n #### \n###   \n##    \n##  # \n##  # \n### # \n #### \n      \n      \n',
    'K': u'      \n      \n##  # \n## #  \n## #  \n###   \n## #  \n##  # \n##  # \n      \n      \n',
    'O': u'      \n      \n ###  \n##  # \n##  # \n##  # \n##  # \n##  # \n ###  \n      \n      \n',
    'S': u'      \n      \n #### \n##    \n###   \n ###  \n  ### \n   ## \n####  \n      \n      \n',
    'W': u'       \n       \n##   # \n## # # \n## # # \n## # # \n###### \n ## #  \n ## #  \n       \n       \n',
    '[': u'     \n#### \n##   \n##   \n##   \n##   \n##   \n##   \n##   \n#### \n     \n',
    '_': u'       \n       \n       \n       \n       \n       \n       \n       \n       \n###### \n       \n',
    'c': u'     \n     \n     \n ### \n##   \n##   \n##   \n##   \n ### \n     \n     \n',
    'g': u'      \n      \n      \n #### \n## ## \n## ## \n## ## \n## ## \n #### \n   ## \n####  \n',
    'k': u'      \n##    \n##    \n##  # \n## #  \n###   \n####  \n## ## \n##  # \n      \n      \n',
    'o': u'      \n      \n      \n ###  \n## ## \n## ## \n## ## \n## ## \n ###  \n      \n      \n',
    's': u'      \n      \n      \n #### \n##    \n####  \n #### \n   ## \n####  \n      \n      \n',
    'w': u'       \n       \n       \n##   # \n## # # \n## # # \n## # # \n ## #  \n ## #  \n       \n       \n',
    '{': u'      \n  ### \n ##   \n ##   \n  #   \n##    \n  #   \n ##   \n ##   \n  ### \n      \n',
    '"': u'    \n# # \n# # \n# # \n    \n    \n    \n    \n    \n    \n    \n',
    '&': u'      \n      \n ##   \n## #  \n## #  \n ##   \n## ## \n## #  \n ## # \n      \n      \n',
    '*': u'      \n      \n## ## \n ##   \n## ## \n      \n      \n      \n      \n      \n      \n',
    '.': u'   \n   \n   \n   \n   \n   \n   \n## \n## \n   \n   \n',
    '2': u'      \n      \n ###  \n## ## \n   ## \n  ##  \n ##   \n##    \n##### \n      \n      \n',
    '6': u'      \n      \n ###  \n## ## \n##    \n####  \n## ## \n## ## \n ###  \n      \n      \n',
    ':': u'   \n   \n   \n## \n## \n   \n   \n## \n## \n   \n   \n',
    '>': u'     \n     \n     \n##   \n ##  \n  ## \n ##  \n##   \n     \n     \n     \n',
    'B': u'      \n      \n####  \n##  # \n##  # \n####  \n##  # \n##  # \n####  \n      \n      \n',
    'F': u'      \n      \n##### \n##    \n##    \n####  \n##    \n##    \n##    \n      \n      \n',
    'J': u'     \n     \n ### \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n###  \n',
    'N': u'      \n      \n#   # \n##  # \n### # \n##### \n# ### \n#  ## \n#   # \n      \n      \n',
    'R': u'      \n      \n####  \n##  # \n##  # \n####  \n## #  \n##  # \n##  # \n      \n      \n',
    'V': u'       \n       \n##   # \n##   # \n##  ## \n ## #  \n ####  \n  ##   \n  ##   \n       \n       \n',
    'Z': u'      \n      \n##### \n   ## \n  ##  \n ###  \n ##   \n##    \n##### \n      \n      \n',
    '^': u'       \n       \n  ##   \n  ##   \n # ##  \n # ##  \n#   ## \n#   ## \n       \n       \n       \n',
    'b': u'      \n##    \n##    \n####  \n## ## \n## ## \n## ## \n## ## \n####  \n      \n      \n',
    'f': u'      \n  ### \n ##   \n##### \n ##   \n ##   \n ##   \n ##   \n ##   \n      \n      \n',
    'j': u'     \n  ## \n     \n#### \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n###  \n',
    'n': u'      \n      \n      \n# ##  \n## ## \n## ## \n## ## \n## ## \n## ## \n      \n      \n',
    'r': u'      \n      \n      \n## ## \n##### \n##    \n##    \n##    \n##    \n      \n      \n',
    'v': u'       \n       \n       \n##  ## \n##  ## \n ## #  \n ####  \n  ##   \n  ##   \n       \n       \n',
    'z': u'      \n      \n      \n##### \n  ### \n ###  \n###   \n##    \n##### \n      \n      \n',
    '~': u'       \n       \n       \n       \n ### # \n# ###  \n       \n       \n       \n       \n       \n',
    '!': u'   \n   \n## \n## \n## \n # \n   \n## \n## \n   \n   \n',
    '%': u'       \n       \n #     \n# #  # \n #  #  \n  ##   \n #  #  \n#  # # \n    #  \n       \n       \n',
    ')': u'     \n##   \n ##  \n  ## \n  ## \n  ## \n  ## \n  ## \n ##  \n##   \n     \n',
    '-': u'      \n      \n      \n      \n      \n##### \n      \n      \n      \n      \n      \n',
    '1': u'     \n     \n  ## \n#### \n  ## \n  ## \n  ## \n  ## \n  ## \n     \n     \n',
    '5': u'      \n      \n##### \n##    \n##    \n####  \n   ## \n## ## \n ###  \n      \n      \n',
    '9': u'      \n      \n ###  \n## ## \n## ## \n #### \n   ## \n## ## \n ###  \n      \n      \n',
    '=': u'      \n      \n      \n      \n##### \n      \n##### \n      \n      \n      \n      \n',
    'A': u'       \n       \n  ##   \n  ##   \n # ##  \n # ##  \n###### \n#   ## \n#   ## \n       \n       \n',
    'E': u'     \n     \n#### \n##   \n##   \n#### \n##   \n##   \n#### \n     \n     \n',
    'I': u'     \n     \n#### \n ##  \n ##  \n ##  \n ##  \n ##  \n#### \n     \n     \n',
    'M': u'       \n       \n#    # \n##  ## \n###### \n###### \n# # ## \n# # ## \n#   ## \n       \n       \n',
    'Q': u'      \n      \n ###  \n##  # \n##  # \n##  # \n##  # \n##  # \n ###  \n  ##  \n   ## \n',
    'U': u'      \n      \n##  # \n##  # \n##  # \n##  # \n##  # \n##  # \n ###  \n      \n      \n',
    'Y': u'       \n       \n##   # \n##   # \n ## #  \n  ##   \n  ##   \n  ##   \n  ##   \n       \n       \n',
    ']': u'     \n#### \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n#### \n     \n',
    'a': u'      \n      \n      \n ###  \n   ## \n #### \n## ## \n## ## \n ## # \n      \n      \n',
    'e': u'      \n      \n      \n ###  \n## ## \n## ## \n##### \n##    \n #### \n      \n      \n',
    'i': u'     \n  ## \n     \n#### \n  ## \n  ## \n  ## \n  ## \n  ## \n     \n     \n',
    'm': u'      \n      \n      \n####  \n# # # \n# # # \n# # # \n# # # \n# # # \n      \n      \n',
    'q': u'      \n      \n      \n #### \n## ## \n## ## \n## ## \n## ## \n #### \n   ## \n   ## \n',
    'u': u'      \n      \n      \n## ## \n## ## \n## ## \n## ## \n## ## \n ## # \n      \n      \n',
    'y': u'      \n      \n      \n##  # \n##  # \n## ## \n # #  \n ###  \n  ##  \n  #   \n ##   \n',
    '}': u'      \n###   \n  ##  \n  ##  \n  #   \n   ## \n  #   \n  ##  \n  ##  \n###   \n      \n'}

heroboti_dic = {
    'q': '##### #  \n# #####  \n# # #### \n# # # ## \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n',
    '*': '##       \n####     \n# ####   \n# # #### \n# # # ## \n# # # #  \n# # # #  \n# # # #  \n',
    '9': '## # ## \n## # ## \n## # ## \n## # ## \n## # ## \n## # ## \n# # ### \n# # # # \n',
    ',': '# # # #  \n# # # #  \n# # # #  \n# # # ## \n# # #### \n# ####   \n####     \n##       \n',
    '<': ' ## # ## \n### # ## \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n # # ### \n # # # # \n',
    'G': '         \n  #####  \n ####### \n ##   ## \n ####### \n      ## \n  ###### \n  #####  \n',
    'S': '         \n  ###    \n ##      \n ######  \n  ###### \n      ## \n ####### \n ######  \n',
    'a': '         \n         \n         \n         \n##       \n####     \n# ####   \n# # #### \n',
    'D': '         \n      ## \n  ### ## \n #### ## \n ##   ## \n ##   ## \n ######  \n  #####  \n',
    '&': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n',
    'z': '# # # \n  ##  \n# # # \n  ##  \n# # # \n  ##  \n# # # \n  ##  \n',
    'w': '# # # #  \n# # # #  \n# #   #  \n# # # #  \n# #   #  \n# #   #  \n#     #  \n# # # #  \n',
    ')': '       # \n     # # \n   # ##  \n # ## #  \n ## # #  \n# # # #  \n# # # #  \n# # # #  \n',
    'J': '         \n     ### \n     ### \n      ## \n ##   ## \n ##   ## \n ####### \n  #####  \n',
    'F': '         \n  #####  \n ####### \n ##   ## \n ##      \n ####    \n ####    \n ##      \n',
    '8': '######## \n ####### \n ## # ## \n ## # ## \n ## # ## \n ## # ## \n ## # ## \n ## # ## \n',
    'U': '         \n         \n ##   ## \n ##   ## \n ##   ## \n ##   ## \n ####### \n  #####  \n',
    '{': '         \n  ###### \n ####### \n ##      \n ######  \n ##   ## \n ####### \n  #####  \n',
    '"': '         \n  #####  \n ####### \n ##   ## \n ####### \n ##   ## \n ####### \n  #####  \n',
    'y': '# # # ## \n# #  ### \n#  # ### \n # # ### \n # # ##  \n # ## #  \n ## # #  \n# # # #  \n',
    'B': '         \n ##      \n ## ###  \n ## #### \n ##   ## \n ##   ## \n ####### \n  #####  \n',
    '^': '         \n ##      \n ##      \n ## ##   \n ## ##   \n ####### \n  ###### \n    ##   \n',
    'C': '         \n         \n   ####  \n  #####  \n ###     \n ##      \n ####### \n  ###### \n',
    '@': ' # ## #  \n   # ##  \n     # # \n       # \n         \n         \n         \n         \n',
    '5': '######## \n ####### \n ## # #  \n ## # #  \n ## # #  \n ## # #  \n # # # # \n # # # # \n',
    '3': '         \n         \n         \n         \n # # # # \n # # # # \n # # # # \n # # # # \n',
    ']': '         \n ######  \n ####### \n      ## \n    #### \n      ## \n ####### \n ######  \n',
    'M': '         \n         \n  ## ##  \n ####### \n ## # ## \n ## # ## \n ##   ## \n ##   ## \n',
    '_': '         \n ####### \n ####### \n ###     \n  #####  \n     ### \n ####### \n ######  \n',
    'Q': '         \n  #####  \n ####### \n ##   ## \n #### ## \n  ### ## \n      ## \n      ## \n',
    '2': '# # #   \n# # #   \n# # #   \n# # #   \n# # # # \n# # # # \n# # # # \n# # # # \n',
    '%': '## \n## \n## \n## \n## \n## \n## \n## \n',
    "'": '         \n         \n         \n         \n         \n         \n         \n         \n',
    'e': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # ## \n# # #### \n# #####  \n##### #  \n',
    '.': '######## \n######## \n######## \n######## \n         \n         \n         \n         \n',
    '/': '######## \n######## \n######## \n######## \n  ###### \n  ###### \n  ###### \n  ###### \n',
    ':': '## # ## \n## # ## \n## # ## \n## # ## \n## # ## \n## # ## \n## # ## \n## # ## \n',
    'r': '# # # #  \n# # # #  \n# # # #  \n### # #  \n##### #  \n# #####  \n# # #### \n# # # ## \n',
    'L': '         \n ##      \n ##      \n ##      \n ##      \n ##      \n ####### \n  ###### \n',
    't': '# # #### \n# #####  \n##### #  \n### # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n',
    '(': '##  ##   \n #   #   \n  ##  ## \n   #   # \n##  ##   \n #   #   \n  ##  ## \n   #   # \n',
    'P': '         \n  #####  \n ####### \n ##   ## \n ## #### \n ## ###  \n ##      \n ##      \n',
    '-': '######## \n ####### \n # ##### \n # # ### \n # # #   \n # # #   \n # # #   \n # # #   \n',
    'u': '# # # #  \n# # # #  \n# #   #  \n# # # #  \n# #   #  \n# #   #  \n#     #  \n# # # #  \n',
    'v': '# # # #  \n#     #  \n#   # #  \n#   # #  \n# # # #  \n#   # #  \n# # # #  \n# # # #  \n',
    '>': '######## \n######## \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n # # ### \n # # # # \n',
    'd': '### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    '$': '         \n  #####  \n ####### \n ##   ## \n ##   ## \n ##   ## \n ####### \n  #####  \n',
    'A': '         \n         \n   ##### \n  ###### \n ###  ## \n ##   ## \n ####### \n  #####  \n',
    'O': '         \n         \n  #####  \n ####### \n ##   ## \n ##   ## \n ####### \n  #####  \n',
    '\\': '         \n ######  \n ####### \n     ### \n  #####  \n ###     \n ####### \n  ###### \n',
    'I': '         \n   ##    \n   ##    \n         \n   ##    \n   ##    \n   ##    \n   ##    \n',
    'V': '         \n         \n ##   ## \n ##   ## \n ##  ### \n ## ###  \n #####   \n  ###    \n',
    'g': '### # #  \n##### #  \n# #####  \n# # #### \n# # # ## \n# # # #  \n# # # #  \n# # # #  \n',
    '`': '         \n  ###### \n ####### \n ##      \n ######  \n ##   ## \n ####### \n  #####  \n',
    'x': '# # # #  \n# # # #  \n#   # #  \n# # # #  \n#   # #  \n#   # #  \n#     #  \n# # # #  \n',
    'm': '##### #  \n##### #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    '7': '######## \n######## \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n ## # ## \n ## # ## \n',
    'E': '         \n         \n  #####  \n ####### \n ##  ### \n ##  ##  \n ####    \n  #####  \n',
    'Z': '         \n         \n ####### \n ####### \n    ###  \n   ###   \n ####### \n ####### \n',
    'i': '### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n##### #  \n##### #  \n',
    'l': '# # # ## \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n# # #### \n# # #### \n',
    ';': '######## \n ####### \n ## # #  \n ## # #  \n ## # #  \n ## # #  \n ## #  # \n ## # ## \n',
    'K': '         \n ##      \n ##   ## \n ##  ### \n ######  \n ######  \n ##  ### \n ##   ## \n',
    '4': ' ###### \n ###### \n ###### \n ###### \n####### \n# ##### \n# # ### \n# # # # \n',
    'c': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n######## \n######## \n',
    'N': '         \n         \n #####   \n ######  \n ##  ### \n ##   ## \n ##   ## \n ##   ## \n',
    '1': '###### \n###### \n###### \n###### \n###### \n###### \n###### \n###### \n',
    'Y': '         \n ##   ## \n ##   ## \n ####### \n  ###### \n      ## \n ####### \n ######  \n',
    'o': '#######  \n#######  \n### # #  \n### # #  \n### # #  \n### # #  \n# # # #  \n# # # #  \n',
    'j': '# # # #  \n# # # #  \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n# ###### \n# ###### \n',
    'f': '# # # ## \n# # #### \n# #####  \n##### #  \n### # #  \n# # # #  \n# # # #  \n# # # #  \n',
    '+': '# # # #  \n# # # #  \n# # # #  \n ## # #  \n # ## #  \n   # ##  \n     # # \n       # \n',
    ' ': '         \n  ###### \n ####### \n ##      \n ######  \n ##   ## \n ####### \n  #####  \n',
    'n': '# ###### \n# ###### \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n# # # #  \n# # # #  \n',
    '6': '######## \n######## \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n # # # # \n # # # # \n',
    'k': '# # # #  \n# # # #  \n### # #  \n### # #  \n### # #  \n### # #  \n#######  \n#######  \n',
    's': '# # # #  \n# # # #  \n# # # #  \n# # # ## \n# # #### \n# #####  \n##### #  \n### # #  \n',
    'h': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n### # #  \n##### #  \n# #####  \n# # ###  \n',
    '?': '         \n         \n         \n         \n       # \n     # # \n   # ##  \n # ## #  \n',
    'H': '         \n ##      \n #####   \n ######  \n ##  ### \n ##   ## \n ##   ## \n ##   ## \n',
    '}': '         \n  ###### \n ####### \n ##      \n ######  \n ##   ## \n ####### \n  #####  \n',
    'b': '# # #### \n# ####   \n####     \n##       \n         \n         \n         \n         \n',
    '|': '         \n  ###### \n ####### \n ##      \n ######  \n ##   ## \n ####### \n  #####  \n',
    'W': '         \n         \n ##   ## \n ##   ## \n ## # ## \n ## # ## \n ####### \n  ## ##  \n',
    'X': '         \n         \n ##   ## \n ### ### \n  #####  \n  #####  \n ### ### \n ##   ## \n',
    'T': '         \n ##      \n ####    \n ####    \n ##      \n ##   ## \n ####### \n  #####  \n',
    '~': '         \n  ###### \n ####### \n ##      \n ######  \n ##   ## \n ####### \n  #####  \n',
    '[': '         \n  ###    \n  ###    \n   ##    \n   ##    \n   ##    \n  ####   \n  ####   \n',
    '!': '         \n ######  \n ####### \n      ## \n      ## \n      ## \n      ## \n      ## \n',
    'R': '         \n         \n  #####  \n ####### \n ##   ## \n ##      \n ##      \n ##      \n',
    '#': '         \n  #####  \n ####### \n ##   ## \n  ###### \n      ## \n ####### \n ######  \n',
    '0': '# # #   \n# # #   \n# # #   \n# # #   \n# # #   \n# # #   \n# # #   \n# # #   \n',
    '=': '## # ## \n## # ## \n## # #  \n## # #  \n## # #  \n## # #  \n# # # # \n# # # # \n',
    'p': '# # #### \n# # #### \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n# # # ## \n'}

high_noo_dic = {
    'q': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n### # #  \n',
    '*': '  ## \n  ## \n  ## \n  ## \n  ## \n  ## \n#### \n#### \n',
    '9': '##    ## \n##    ## \n######## \n######## \n      ## \n      ## \n      ## \n      ## \n',
    ',': '##     # \n##       \n##       \n##       \n##       \n##    #  \n##    ## \n##    ## \n',
    '<': '   ##    \n# # ## # \n     #   \n  #      \n#    # # \n###   ## \n#    # # \n###   ## \n',
    'G': '######## \n       # \n   ##  # \n####  ## \n###  ### \n##  #### \n#  ##### \n    #### \n',
    'S': '######## \n         \n  #####  \n#######  \n#######  \n  #####  \n   ####  \n#      # \n',
    'a': '#   ##   \n#    # # \n     #   \n#    #   \n#  ##### \n# ## # # \n     # # \n# # ##   \n',
    'D': '######## \n####   # \n###   ## \n##  # ## \n#  ## ## \n       # \n##### ## \n####   # \n',
    '&': '##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n',
    'z': '######   \n######   \n######   \n######   \n######   \n######   \n#####    \n### #    \n',
    'w': '# ##   \n# ##   \n# ##   \n# ##   \n# ##   \n# ##   \n# ##   \n# ##   \n',
    ')': '######## \n######## \n######## \n######## \n         \n         \n         \n         \n',
    'J': '######## \n###  ### \n##  # ## \n#  ### # \n#      # \n#  ### # \n#  ### # \n    #    \n',
    'F': '######## \n#     ## \n  #### # \n  ###### \n      ## \n  #### # \n  #### # \n#     ## \n',
    '8': '######## \n######## \n######## \n######## \n#####    \n#####    \n#####    \n#####    \n',
    'U': '######## \n    #### \n#  ##### \n#  ##### \n#  ##### \n#  ##### \n#  ####  \n         \n',
    '{': '######## \n    #    \n#  ### # \n   ### # \n#  ### # \n#  # # # \n#   #  # \n#  ### # \n',
    '"': '######## \n    #    \n#  ### # \n##  # ## \n###  ### \n###  ### \n###  ### \n##    ## \n',
    'y': '# ###### \n# ###### \n# ###### \n ####### \n ####### \n ####### \n # ##### \n # # ### \n',
    'B': '######## \n#     ## \n  #### # \n###### # \n#     ## \n  ###### \n  #### # \n       # \n',
    '^': '######## \n    #    \n#  ### # \n#  ### # \n#  ### # \n#  ### # \n#  ### # \n##    ## \n',
    'C': '######## \n#     ## \n  #### # \n### ## # \n###   ## \n### ## # \n  #### # \n#     ## \n',
    '@': '#   ###  \n# ####   \n#   ##   \n  #      \n#   #### \n# #  ##  \n         \n         \n',
    '5': '#####    \n####     \n###      \n##       \n##       \n##       \n##     # \n##    ## \n',
    '3': '##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n#     ## \n',
    ']': '######## \n         \n ##  ##  \n###  ### \n###  ### \n###  ### \n###  ### \n##    ## \n',
    'M': '######## \n      ## \n#  ##  # \n#  ####  \n#  ####  \n#  ####  \n#  ##  # \n      ## \n',
    '_': '######## \n    #    \n#  ### # \n#  ### # \n#  ### # \n#  ### # \n##  # ## \n###  ### \n',
    'Q': '######## \n    #    \n#  ### # \n#  ### # \n#      # \n   ### # \n#  ### # \n    #    \n',
    '2': '   ##### \n    #### \n     ### \n      ## \n      ## \n      ## \n#     ## \n##    ## \n',
    '%': '##    ## \n##    ## \n##    ## \n##    ## \n##       \n##       \n##       \n##       \n',
    "'": '         \n         \n         \n         \n         \n         \n######## \n######## \n',
    'e': '# ## ##  \n  #      \n#    # # \n###  ##  \n#   ## # \n# ##     \n# #####  \n     #   \n',
    '.': '##     # \n###      \n####     \n#####    \n######   \n#######  \n######## \n######## \n',
    '/': '###      \n##       \n#        \n         \n         \n         \n     ### \n    #### \n',
    ':': '#  ##    \n#####    \n# ###    \n### #    \n#   # #  \n##    #  \n#  ####  \n## #  #  \n',
    'r': '# ##     \n# ##     \n# ##     \n# ##     \n# ##     \n# ##     \n# ##     \n# ##     \n',
    'L': '######## \n##     # \n#  ###   \n  ###### \n  ###### \n  ###### \n#  ###   \n##     # \n',
    't': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n#######  \n',
    '(': '######   \n######   \n######   \n######   \n######   \n######   \n######## \n######## \n',
    'P': '######## \n##     # \n#  ###   \n  #####  \n  ###### \n  ###    \n#  ##    \n##     # \n',
    '-': '######## \n######## \n ####### \n  ###### \n   ##### \n    #### \n     ### \n#     ## \n',
    'u': '###  \n###  \n###  \n###  \n###  \n###  \n###  \n###  \n',
    'v': '# # #  \n# # #  \n# # #  \n# # #  \n# # #  \n# # #  \n# # #  \n# #### \n',
    '>': '         \n#####  # \n#   #  # \n  #      \n     #   \n# #    # \n    #    \n##  #### \n',
    'd': '     #   \n ## #### \n# ###### \n# #  # # \n    ##   \n         \n#   #  # \n  #   ## \n',
    '$': '         \n         \n         \n         \n         \n         \n##    ## \n##    ## \n',
    'A': '######## \n#### ### \n###  ### \n##   ### \n###  ### \n###  ### \n###  ### \n#      # \n',
    'O': '######## \n         \n#  ####  \n#  ## ## \n#     ## \n#  ## ## \n#  ##### \n    #### \n',
    '\\': '######## \n#      # \n  #####  \n  ###### \n#      # \n#######  \n  #####  \n#      # \n',
    'I': '######## \n#     ## \n  #### # \n  #### # \n#      # \n###### # \n  #### # \n#     ## \n',
    'V': '######## \n#  ### # \n#   #  # \n#  # # # \n#  ### # \n#  ### # \n#  ### # \n    #    \n',
    'g': '#    ##  \n  # #### \n# # ## # \n  # ##   \n# # ## # \n  ####   \n  #  ### \n#   ###  \n',
    '`': '######## \n    #    \n#  ### # \n   ### # \n#  ### # \n#  # # # \n#   #  # \n#  ### # \n',
    'x': '# ## # \n# ## # \n# ## # \n# ## # \n# ## # \n# ## # \n# ## # \n# ## # \n',
    'm': ' # #   # \n # #   # \n # # # # \n #   # # \n #   # # \n # # # # \n # # # # \n######## \n',
    '7': '##       \n##       \n##       \n###      \n####     \n#####    \n######## \n######## \n',
    'E': '######## \n       # \n  ###### \n  #   ## \n   ### # \n###### # \n  #### # \n#     ## \n',
    'Z': '######## \n##    ## \n#  ### # \n  #####  \n  #####  \n  ### #  \n#  ### # \n##    #  \n',
    'i': ' # # ##  \n# #  # # \n#   #### \n    ##   \n    #  # \n  #      \n #  ##   \n# #      \n',
    'l': '         \n         \n         \n         \n  ###### \n  ###### \n         \n         \n',
    ';': '      ## \n  #   ## \n      ## \n  #   ## \n#    # # \n         \n         \n# #    # \n',
    'K': '######## \n       # \n#  ####  \n#  ####  \n#      # \n#  ####  \n#  ####  \n       # \n',
    '4': '      ## \n      ## \n      ## \n     ### \n    #### \n   ##### \n######## \n######## \n',
    'c': '     #   \n ###   # \n#  #  ## \n     #   \n    ## # \n  #  ##  \n#  ###   \n  #  ##  \n',
    'N': '######## \n         \n#  ####  \n#  ## ## \n#     ## \n#  ## ## \n#  ####  \n         \n',
    '1': '         \n         \n         \n#        \n##       \n###      \n######## \n######## \n',
    'Y': '######## \n       # \n#  ####  \n#  ####  \n#      # \n#  ##### \n#  ##### \n    #### \n',
    'o': '# ##   # \n# ##   # \n# ##   # \n# ##   # \n# ##   # \n# ##   # \n# ##   # \n# ###### \n',
    'j': '#        \n ##      \n   ##  # \n# # # #  \n         \n ##   ## \n#   # #  \n  #      \n',
    'f': '#   ###  \n  ###### \n      ## \n# # ## # \n   ##  # \n  #  ### \n    # ## \n  # ##   \n',
    '+': '      ## \n      ## \n      ## \n      ## \n      ## \n      ## \n######## \n # ##### \n',
    ' ': '######## \n    #    \n#  ### # \n   ### # \n#  ### # \n#  # # # \n#   #  # \n#  ### # \n',
    'n': ' #  ###  \n #  ###  \n #  ###  \n #  ###  \n #  ###  \n #  ###  \n #  ###  \n#######  \n',
    '6': '##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n##    ## \n##     # \n',
    'k': '    ## # \n# # # #  \n         \n# ## ##  \n#   # #  \n# ##     \n   ##    \n# # ## # \n',
    's': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # ## \n',
    'h': '   # ##  \n# # # ## \n    ##   \n  # ##   \n#    ##  \n  #  #   \n    #### \n    #### \n',
    '?': '         \n  # # ## \n#   #  # \n  # #    \n    ## # \n#      # \n    ## # \n  # # #  \n',
    'H': '######## \n      ## \n  #### # \n  #### # \n#     ## \n   ### # \n  #### # \n#     ## \n',
    '}': '######## \n    #    \n#  ### # \n   ### # \n#  ### # \n#  # # # \n#   #  # \n#  ### # \n',
    'b': '  # ###  \n     # # \n  ##  #  \n         \n#    #   \n#    ##  \n#    # # \n ##  #   \n',
    '|': '######## \n    #    \n#  ### # \n   ### # \n#  ### # \n#  # # # \n#   #  # \n#  ### # \n',
    'W': '######## \n#  ##    \n#   ## # \n#  # # # \n#  # # # \n#  # # # \n#  ##  # \n    ## # \n',
    'X': '######## \n##    ## \n#  ### # \n  #####  \n  #####  \n  #####  \n#  ### # \n##    ## \n',
    'T': '######## \n    #    \n#  ### # \n#  ## ## \n#   ###  \n#  ## ## \n#  ### # \n    #    \n',
    '~': '######## \n    #    \n#  ### # \n   ### # \n#  ### # \n#  # # # \n#   #  # \n#  ### # \n',
    '[': '######## \n       # \n#  ####  \n#  ####  \n#      # \n#  ## ## \n#  ### # \n    #    \n',
    '!': '######## \n    #    \n#  ### # \n##  # ## \n###  ### \n##  # ## \n#  ### # \n    #    \n',
    'R': '######## \n#      # \n###  ### \n###  ### \n###  ### \n###  ### \n #   ### \n#      # \n',
    '#': '######## \n         \n  ###  # \n####  ## \n###  ### \n##  #### \n#  ####  \n         \n',
    '0': '#### \n#### \n#### \n#### \n#### \n#### \n#### \n ### \n',
    '=': '#  ##    \n ##  # # \n#    #   \n# #  ### \n#    #   \n  #   #  \n   #  #  \n# #    # \n',
    'p': '    # #  \n# # # #  \n# # # #  \n# # # #  \n    # #  \n# # # #  \n# # # #  \n# ###### \n'}

hills_dic = {
    'q': '# # # ## \n# # # ## \n# # #### \n# # ###  \n# ### ## \n# # ###  \n# # # #  \n### # #  \n',
    '*': ' # # ##  \n#  ##  # \n# # # #  \n# # # #  \n# # # ## \n### # #  \n##### #  \n### ###  \n',
    '9': '         \n         \n         \n         \n         \n         \n         \n         \n',
    ',': '         \n ##      \n# ##     \n### # #  \n# ### #  \n### ###  \n##### ## \n#######  \n',
    '<': '         \n         \n       # \n     # # \n   # ##  \n#  ##  # \n# #  ##  \n# # # #  \n',
    'G': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'S': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'a': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'D': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '&': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'z': '# # # ## \n# # # #  \n# # # ## \n# # # #  \n# # # ## \n# # # #  \n# # # #  \n### # #  \n',
    'w': '# # # #  \n# # # #  \n# # # #  \n# ### #  \n# #####  \n# ### #  \n#######  \n# ### #  \n',
    ')': '      #  \n      #  \n    # #  \n    # #  \n  # # #  \n  # # #  \n# # # #  \n# # # #  \n',
    'J': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'F': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '8': '         \n         \n         \n         \n         \n         \n         \n      #  \n',
    'U': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '{': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'y': '# #####  \n# ### #  \n# ### #  \n# # # #  \n# # # #  \n# # # #  \n# # # ## \n### # ## \n',
    'B': '         \n         \n         \n         \n       # \n     # # \n   # ##  \n # ##  # \n',
    '^': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'C': '         \n         \n         \n         \n #       \n## #     \n ### #   \n## # # # \n',
    '@': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '5': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '3': '         \n         \n         \n #       \n# # #    \n### # #  \n ####### \n### # #  \n',
    ']': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'M': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '_': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'Q': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '2': '         \n         \n   # # # \n # ##  # \n ##  ### \n#  ##  # \n# #  ### \n# # # #  \n',
    '%': '         \n         \n         \n         \n         \n         \n         \n         \n',
    "'": '         \n         \n         \n         \n         \n         \n         \n         \n',
    'e': ' #       \n# ##     \n## ###   \n##### ## \n### ###  \n# ### ## \n# # ###  \n### # #  \n',
    '.': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '/': '         \n         \n         \n         \n         \n         \n         \n#        \n',
    ':': '         \n         \n         \n         \n         \n         \n         \n      #  \n',
    'r': '# ### #  \n### # #  \n# # # ## \n# # # ## \n# # # ## \n# # ###  \n# ### ## \n# # ###  \n',
    'L': '         \n         \n         \n         \n         \n         \n         \n         \n',
    't': '### #### \n# #####  \n# ###### \n### ###  \n# ### #  \n### #### \n# ### ## \n# # ###  \n',
    '(': '         \n         \n         \n         \n         \n         \n         \n      #  \n',
    'P': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '-': '         \n         \n         \n         \n         \n##       \n# #      \n# # # #  \n',
    'u': '# # # #  \n# # # #  \n# # # #  \n#######  \n# # # ## \n### ###  \n##### ## \n### ###  \n',
    'v': '#     #  \n# # # #  \n# # # #  \n# # ###  \n# # # #  \n### # #  \n# # # ## \n# # # ## \n',
    '>': '         \n         \n         \n #       \n ###     \n#  ###   \n ##  ### \n##### ## \n',
    'd': '## # ##  \n # ##  # \n#### ##  \n #### ## \n# # ## # \n# # # #  \n# # # #  \n# # # #  \n',
    '$': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'A': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'O': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '\\': '         \n         \n         \n         \n         \n   #     \n # # #   \n # # # # \n',
    'I': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'V': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'g': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '`': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'x': '# # # #  \n# # # #  \n# # # #  \n# # ###  \n# # #### \n# # ###  \n# ### ## \n# #####  \n',
    'm': '   #     \n # # #   \n # # ### \n # ##  # \n ##  ### \n ## # #  \n# #  ##  \n# # # #  \n',
    '7': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'E': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'Z': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'i': '         \n         \n         \n         \n         \n         \n         \n      ## \n',
    'l': '         \n         \n       # \n      #  \n    #  # \n  #  ##  \n# # #  # \n# # # #  \n',
    ';': '         \n         \n         \n         \n         \n    # #  \n  # # #  \n# # # #  \n',
    'K': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '4': '         \n         \n         \n         \n         \n         \n#        \n# #      \n',
    'c': '     # # \n  #  ##  \n#  ## #  \n# # # #  \n# #  ##  \n# # # #  \n# # # #  \n# # # #  \n',
    'N': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '1': '         \n         \n         \n       # \n  #  ##  \n# # # #  \n# # # #  \n# # # #  \n',
    'Y': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'o': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'j': '         \n         \n         \n         \n         \n         \n##       \n### #    \n',
    'f': '         \n         \n         \n         \n##       \n# ##     \n####     \n# ####   \n',
    '+': '# ## # # \n### ###  \n# ### ## \n### ###  \n# ### ## \n### # ## \n# ### ## \n# # #### \n',
    ' ': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'n': '         \n         \n         \n##       \n #       \n###      \n# ##     \n### ##   \n',
    '6': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'k': '         \n         \n         \n         \n         \n         \n         \n         \n',
    's': '# # # ## \n# ###### \n# ###### \n# # # ## \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n',
    'h': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '?': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'H': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '}': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'b': '         \n         \n         \n      #  \n      #  \n    # #  \n    # #  \n  # # #  \n',
    '|': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'W': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'X': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'T': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '~': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '[': '         \n         \n         \n         \n         \n         \n       # \n     ### \n',
    '!': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'R': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '0': '         \n         \n         \n         \n         \n         \n  # # #  \n# # # #  \n',
    '=': '         \n         \n #     # \n # # # # \n # # ##  \n#  ##  # \n ## # #  \n#  ## ## \n',
    'p': '    # #  \n    # #  \n  # # #  \n### # #  \n# # # #  \n### # #  \n# ### #  \n### ###  \n'}

home_pak_dic = {
    'q': '         \n  #####  \n ### ### \n ### ### \n ####### \n ######  \n  ### ## \n         \n',
    '*': '         \n ##  ##  \n  ####   \n######## \n  ####   \n ##  ##  \n         \n         \n',
    '9': '         \n  #####  \n ### ### \n  ###### \n     ### \n    ###  \n  ####   \n         \n',
    ',': '         \n         \n         \n         \n         \n   ###   \n   ###   \n  ###    \n',
    '<': '    ###  \n   ###   \n   ##    \n ###     \n  ###    \n   ###   \n    ###  \n         \n',
    'G': '##       \n###      \n ###     \n  ###    \n   ###   \n    ###  \n     ### \n      ## \n',
    'S': '   ##    \n   ##    \n   ##    \n######## \n######## \n   ##    \n   ##    \n   ##    \n',
    'a': '         \n   ###   \n  #####  \n ### ### \n ### ### \n ####### \n ### ### \n         \n',
    'D': '   ##    \n   ##    \n   ##    \n#####    \n#####    \n   ##    \n   ##    \n   ##    \n',
    '&': '   ###   \n  ## ##  \n   ###   \n  ###    \n ## #### \n ##  ##  \n  ### ## \n         \n',
    'z': '         \n ####### \n    ###  \n   ###   \n  ###    \n ###     \n # ##### \n         \n',
    'w': '         \n ### ### \n ### ### \n ####### \n ####### \n ### ### \n ##   ## \n         \n',
    ')': '         \n ###     \n  ###    \n   ##    \n   ##    \n  ###    \n ###     \n         \n',
    'J': '#        \n##       \n###      \n####     \n#####    \n######   \n#######  \n######## \n',
    'F': '      ## \n     ### \n    ###  \n   ###   \n  ###    \n ###     \n###      \n##       \n',
    '8': '         \n  #####  \n ### ### \n  #####  \n ### ### \n ### ### \n  #####  \n         \n',
    'U': '         \n         \n         \n         \n######## \n######## \n######## \n######## \n',
    '{': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': '         \n  ## ##  \n  ## ##  \n  ## ##  \n         \n         \n         \n         \n',
    'y': '         \n ### ### \n ### ### \n  #####  \n   ###   \n   ###   \n   ###   \n         \n',
    'B': '## \n## \n## \n## \n## \n## \n## \n## \n',
    '^': '    #    \n   ##    \n  ###### \n ####### \n  ###### \n   ##    \n    #    \n         \n',
    'C': '   ##    \n   ##    \n  ###    \n####     \n###      \n         \n         \n         \n',
    '@': '         \n  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n  #####  \n         \n',
    '5': '         \n ####### \n ###     \n ######  \n     ### \n ### ### \n  #####  \n         \n',
    '3': '         \n ####### \n    ###  \n   ###   \n    ###  \n ##  ### \n  #####  \n         \n',
    ']': '   ###   \n   ###   \n   ###   \n ####### \n  #####  \n   ###   \n    #    \n         \n',
    'M': '######## \n######## \n         \n         \n         \n         \n         \n         \n',
    '_': '    #    \n    ##   \n ######  \n ####### \n ######  \n    ##   \n    #    \n         \n',
    'Q': '         \n         \n         \n     ### \n    #### \n   ###   \n   ##    \n   ##    \n',
    '2': '         \n  #####  \n ##  ### \n    ###  \n   ###   \n  ###    \n ####### \n         \n',
    '%': '         \n ##  ##  \n ## ##   \n   ##    \n  ##     \n ##  ##  \n #   ##  \n         \n',
    "'": '    ##   \n    ##   \n   ##    \n  ##     \n         \n         \n         \n         \n',
    'e': '         \n ####### \n # ##    \n ######  \n ####    \n ####    \n ####### \n         \n',
    '.': '         \n         \n         \n         \n         \n  ###    \n  ###    \n         \n',
    '/': '         \n     ### \n    ###  \n   ###   \n  ###    \n ###     \n ##      \n         \n',
    ':': '         \n         \n   ###   \n   ###   \n         \n   ###   \n   ###   \n         \n',
    'r': '         \n ######  \n ### ### \n ### ### \n ######  \n ### ### \n ### ### \n         \n',
    'L': '####     \n####     \n###      \n##       \n         \n         \n         \n         \n',
    't': '         \n ####### \n   ###   \n   ###   \n   ###   \n   ###   \n   ###   \n         \n',
    '(': '         \n    ###  \n   ###   \n   ##    \n   ##    \n   ###   \n    ###  \n         \n',
    'P': '  #####  \n #     # \n # ### # \n # #   # \n # ### # \n #     # \n  #####  \n         \n',
    '-': '         \n         \n         \n ######  \n         \n         \n         \n         \n',
    'u': '         \n ### ### \n ### ### \n ### ### \n ### ### \n ####### \n  ### ## \n         \n',
    'v': '         \n ### ### \n ### ### \n ### ### \n ### ### \n  #####  \n   ###   \n         \n',
    '>': ' ###     \n  ###    \n   ###   \n    ###  \n   ###   \n  ###    \n ###     \n         \n',
    'd': '         \n #####   \n # # ##  \n ### ### \n ### ### \n ######  \n #####   \n         \n',
    '$': '   ##    \n  #####  \n ##      \n  ####   \n     ##  \n #####   \n   ##    \n         \n',
    'A': '##    \n##    \n##    \n##### \n##### \n##    \n##    \n##    \n',
    'O': '         \n         \n         \n         \n##       \n###      \n####     \n####     \n',
    '\\': '    #    \n   ###   \n  #####  \n ####### \n   ###   \n   ###   \n   ###   \n         \n',
    'I': '         \n         \n         \n         \n      ## \n     ### \n    #### \n    #### \n',
    'V': '##       \n##       \n##       \n##       \n##       \n##       \n##       \n##       \n',
    'g': '         \n  #####  \n ### ### \n ###     \n ### ### \n ### ### \n  ### ## \n         \n',
    '`': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'x': '         \n ### ### \n ### ### \n  #####  \n  #####  \n ### ### \n ### ### \n         \n',
    'm': '         \n ##   ## \n ### ### \n ####### \n ####### \n ### ### \n ### ### \n         \n',
    '7': '         \n ####### \n     ### \n    ###  \n   ###   \n  ###    \n  ###    \n         \n',
    'E': '         \n         \n         \n###      \n####     \n  ###    \n   ##    \n   ##    \n',
    'Z': '   ##    \n   ##    \n   ###   \n    #### \n     ### \n         \n         \n         \n',
    'i': '         \n ####### \n   ###   \n   ###   \n   ###   \n   ###   \n ####### \n         \n',
    'l': '         \n ####    \n ####    \n ####    \n # ##    \n ####    \n ####### \n         \n',
    ';': '         \n         \n   ###   \n   ###   \n         \n   ###   \n   ###   \n  ###    \n',
    'K': '    #### \n    #### \n     ### \n      ## \n         \n         \n         \n         \n',
    '4': '         \n    ###  \n   ####  \n  #####  \n ## ###  \n ####### \n    ###  \n         \n',
    'c': '         \n  #####  \n # # ### \n ###     \n ###     \n ### ### \n   ####  \n         \n',
    'N': '         \n         \n         \n         \n         \n         \n######## \n######## \n',
    '1': '         \n   ###   \n  ####   \n   ###   \n   ###   \n   ###   \n ####### \n         \n',
    'Y': '####     \n####     \n####     \n####     \n####     \n####     \n####     \n####     \n',
    'o': '         \n  #####  \n ### ### \n ### ### \n ### ### \n ####### \n  #####  \n         \n',
    'j': '         \n     ### \n     ### \n     ### \n     ### \n ### ### \n  #####  \n         \n',
    'f': '         \n ####### \n ####    \n ######  \n ####    \n # ##    \n ####    \n         \n',
    '+': '         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    ' ': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'n': '         \n #### ## \n #### ## \n ####### \n ####### \n ### ### \n ### ### \n         \n',
    '6': '         \n  #####  \n ###     \n ######  \n ### ### \n ### ### \n  #####  \n         \n',
    'k': '         \n ### ### \n ### ##  \n #####   \n #####   \n ### ##  \n ### ### \n         \n',
    's': '         \n  #####  \n ### ### \n  ###    \n    ###  \n ### ### \n  #####  \n         \n',
    'h': '         \n ### ### \n ### ### \n ####### \n ### ### \n ### ### \n ### ### \n         \n',
    '?': '         \n  #####  \n ### ### \n    ###  \n   ###   \n         \n   ###   \n         \n',
    'H': '       # \n      ## \n     ### \n    #### \n   ##### \n  ###### \n ####### \n######## \n',
    '}': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'b': '         \n ######  \n ### ### \n ######  \n ### ### \n ### ### \n ######  \n         \n',
    '|': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'W': '         \n         \n         \n######## \n######## \n   ##    \n   ##    \n   ##    \n',
    'X': '   ##    \n   ##    \n   ##    \n######## \n######## \n         \n         \n         \n',
    'T': '         \n         \n  ####   \n ######  \n ######  \n ######  \n  ####   \n         \n',
    '~': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '[': ' ####    \n ##      \n ####    \n ##      \n ######  \n   ##    \n   ####  \n         \n',
    '!': '         \n  #####  \n  #####  \n  #####  \n   ###   \n         \n   ###   \n         \n',
    'R': '         \n         \n         \n######## \n######## \n         \n         \n         \n',
    '#': '         \n  ## ##  \n ####### \n  ## ##  \n ####### \n  ## ##  \n         \n         \n',
    '0': '         \n  #####  \n ##  ### \n ## #### \n #### ## \n ###  ## \n  #####  \n         \n',
    '=': '         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'p': '         \n ######  \n ### ### \n ### ### \n ######  \n ###     \n ###     \n         \n'}

house_of_dic = {
    'q': '         \n  ####   \n######## \n######## \n######   \n######   \n####     \n##       \n',
    '*': '# ##    \n ###    \n ###    \n ###    \n ###    \n ###    \n###     \n##      \n',
    '9': '  #### \n ####  \n###    \n###    \n###    \n####   \n  #### \n    ## \n',
    ',': '### ###  \n######   \n ## #    \n ## ##   \n  ####   \n   ###   \n   ###   \n   ###   \n',
    '<': ' #####   \n#######  \n#     #  \n#        \n#        \n#        \n#        \n#        \n',
    'G': '         \n  ####   \n ##  ##  \n ##      \n ######  \n ### ##  \n  #####  \n         \n',
    'S': '         \n   ##### \n  ##     \n   ###   \n     ##  \n ##  ##  \n #####   \n         \n',
    'a': '       # \n       # \n       # \n       # \n   ##  # \n   ## ## \n    ###  \n         \n',
    'D': '         \n #####   \n  ## ##  \n  ## ##  \n  ## ##  \n  ## ##  \n #####   \n         \n',
    '&': '         \n  #####  \n ### ##  \n  #####  \n     ##  \n ##  ##  \n  ####   \n         \n',
    'z': '         \n         \n  ####   \n######## \n######## \n######## \n######## \n######## \n',
    'w': '# # # #  \n# # # #  \n# # #  # \n# #  # # \n# #  # # \n     # # \n       # \n         \n',
    ')': ' ####### \n ###     \n ###     \n ###     \n ###     \n ###     \n###      \n###      \n',
    'J': '         \n ######  \n ## ##   \n    ##   \n    ##   \n    ##   \n ## ##   \n  ####   \n',
    'F': '         \n ######  \n ##      \n ##      \n ####    \n ##      \n ##      \n         \n',
    '8': '###      \n####     \n  ###    \n         \n         \n         \n #       \n##       \n',
    'U': '         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ## ###  \n  ### ## \n         \n',
    '{': '         \n  ####   \n ##  ##  \n    ##   \n     ##  \n ##  ##  \n  ####   \n         \n',
    '"': '         \n ####### \n  ##     \n #####   \n     ##  \n ##  ##  \n  ####   \n         \n',
    'y': '         \n         \n         \n##       \n######## \n######## \n######## \n######## \n',
    'B': '         \n #####   \n ### ##  \n # ####  \n ###  ## \n ###  ## \n ######  \n         \n',
    '^': '         \n   ###   \n  ####   \n ## ##   \n    ##   \n    ##   \n   ####  \n         \n',
    'C': '         \n  ####   \n ### ##  \n ##      \n ##      \n ### ##  \n  ####   \n         \n',
    '@': '####     \n#####    \n#  ###   \n#   ###  \n#   ###  \n#  ###   \n######   \n# ###    \n',
    '5': '      ## \n         \n         \n         \n  ###    \n   ###   \n    #### \n     ### \n',
    '3': '  #### \n ###   \n###    \n###    \n###    \n ###   \n  ###  \n   ### \n',
    ']': '         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'M': '         \n ##   ## \n ### ### \n # ##### \n ##   ## \n ##   ## \n ##   ## \n         \n',
    '_': '         \n  ####   \n ##  ##  \n    ##   \n   ##    \n  ##     \n ####### \n         \n',
    'Q': '         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ## ###  \n  ### ## \n         \n',
    '2': '  ###    \n  ###    \n  ###    \n  ###    \n  ###    \n ####    \n### ##   \n##   ##  \n',
    '%': '         \n   ###   \n  ## ##  \n  #####  \n ##   ## \n ##   ## \n  #####  \n         \n',
    "'": ' ####   \n ###    \n###     \n###     \n###     \n###     \n###     \n####### \n',
    'e': '##    ## \n######## \n #    ## \n##    ## \n##    ## \n######## \n##    ## \n##    ## \n',
    '.': '   ###   \n   ###   \n   ###   \n   ###   \n   ###   \n  ###    \n####     \n##       \n',
    '/': ' ####   \n## ###  \n## ###  \n   ###  \n   ###  \n  ###   \n  ###   \n  ###   \n',
    ':': '##       \n         \n         \n         \n    ##   \n   ###   \n#####    \n####     \n',
    'r': '         \n         \n         \n         \n      ## \n    #### \n    #### \n      ## \n',
    'L': '         \n ###     \n  ##     \n   #     \n  ##     \n  ##     \n ######  \n         \n',
    't': '         \n         \n         \n      ## \n######## \n######## \n######## \n######## \n',
    '(': '   ###   \n   ###   \n  ###    \n  ###    \n  ###    \n  ###    \n  ###    \n#####    \n',
    'P': '         \n ######  \n  ##  ## \n  ##  ## \n  #####  \n  ##     \n ####    \n         \n',
    '-': '###    \n###    \n###    \n###    \n###    \n ###   \n  #### \n     # \n',
    'u': '         \n         \n         \n         \n         \n      #  \n  # # #  \n         \n',
    'v': '         \n      #  \n    # #  \n  # # #  \n# # # #  \n# # # #  \n# #      \n         \n',
    '>': '###      \n#        \n#        \n#        \n#        \n#        \n         \n         \n',
    'd': '####  ## \n         \n  ###### \n         \n##  #### \n         \n####  ## \n         \n',
    '$': '         \n ####### \n     ##  \n    ##   \n   ##    \n   ##    \n   ##    \n         \n',
    'A': '         \n  ####   \n ######  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    'O': '         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '\\': '         \n         \n   ##    \n   ##    \n         \n   ##    \n   ##    \n         \n',
    'I': '         \n #####   \n   ##    \n   ##    \n   ##    \n   ##    \n #####   \n         \n',
    'V': '         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'g': '  # #    \n# # # #  \n#     #  \n         \n#     #  \n# # # #  \n######## \n######## \n',
    '`': '         \n  ####   \n ##  ##  \n    ##   \n     ##  \n ##  ##  \n  ####   \n         \n',
    'x': '# #   ## \n#        \n #       \n # #     \n # #     \n # #     \n #       \n         \n',
    'm': '# # # #  \n# # # #  \n######## \n######## \n######## \n######## \n######## \n######## \n',
    '7': '    ## \n  #### \n ###   \n###    \n###    \n####   \n ####  \n   ### \n',
    'E': '         \n ######  \n ##      \n ##      \n  ###    \n ##      \n ######  \n         \n',
    'Z': '         \n ####### \n     ##  \n    ##   \n   ##    \n  ##     \n ####### \n         \n',
    'i': '# # #### \n# # #### \n# # #### \n# # #### \n# # #### \n# # # ## \n# # # #  \n# # # #  \n',
    'l': '# # # #  \n# # # #  \n# # # ## \n# # #### \n# # #### \n# # #### \n# # #### \n# # #### \n',
    ';': ' ###    \n####### \n#  #### \n      # \n      # \n      # \n   ## # \n    ### \n',
    'K': '         \n ##  ##  \n ## ##   \n ####    \n ## ##   \n ##  ##  \n ##  ##  \n         \n',
    '4': '####     \n ####    \n  ###    \n         \n         \n         \n         \n         \n',
    'c': '####  ## \n         \n  ###### \n         \n##  #### \n         \n####  ## \n         \n',
    'N': '         \n ##   ## \n # #  ## \n #### ## \n ## #### \n ##  ### \n ##   ## \n         \n',
    '1': '###   \n###   \n###   \n###   \n###   \n###   \n #### \n  ### \n',
    'Y': '         \n ##   ## \n ##   ## \n  #####  \n    ##   \n ## ##   \n  ###    \n         \n',
    'o': '##### #  \n##### #  \n##### #  \n##### #  \n##### #  \n### # #  \n# # # #  \n# # # #  \n',
    'j': '######## \n######## \n######## \n######## \n######## \n######## \n# # # #  \n# # # #  \n',
    'f': '         \n      #  \n    # #  \n  # # #  \n  # # #  \n# # # #  \n# # # ## \n# # #### \n',
    '+': '    ## \n  #### \n ###   \n###    \n###    \n###    \n###    \n###    \n',
    ' ': '         \n  ####   \n ##  ##  \n    ##   \n     ##  \n ##  ##  \n  ####   \n         \n',
    'n': '# #   #  \n# # # #  \n### # #  \n##### #  \n##### #  \n##### #  \n##### #  \n##### #  \n',
    '6': '##       \n####     \n ####    \n  ###    \n  ###    \n  ###    \n####     \n##       \n',
    'k': '##### #  \n##### #  \n##### #  \n##### #  \n##### #  \n### # #  \n# # # #  \n      #  \n',
    's': '         \n         \n  ####   \n######## \n######## \n######## \n######## \n######## \n',
    'h': '         \n#        \n# #      \n# # #    \n# # #    \n# # # #  \n### # #  \n##### #  \n',
    '?': '  #### \n ##### \n###  # \n###  # \n###  # \n ### # \n  #### \n    ## \n',
    'H': '         \n ### ##  \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n         \n',
    '}': '         \n  ####   \n ##  ##  \n    ##   \n     ##  \n ##  ##  \n  ####   \n         \n',
    'b': '####     \n# ##     \n# ##     \n#  ##    \n#  ##    \n   ### # \n    #### \n         \n',
    '|': '         \n  ####   \n ##  ##  \n    ##   \n     ##  \n ##  ##  \n  ####   \n         \n',
    'W': '         \n ### ### \n ##   ## \n ##   ## \n ##   ## \n ####### \n  ## ##  \n         \n',
    'X': '         \n ##   ## \n  ## ##  \n   ###   \n   ###   \n  ## ##  \n ##   ## \n         \n',
    'T': '         \n ####### \n   ##    \n   ##    \n   ##    \n   ##    \n  ###    \n         \n',
    '~': '         \n  ####   \n ##  ##  \n    ##   \n     ##  \n ##  ##  \n  ####   \n         \n',
    '[': '         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '!': '         \n   ##    \n  ##     \n #   ##  \n ####### \n     ##  \n     ##  \n         \n',
    'R': '         \n #####   \n  ## ##  \n  ## ##  \n  ####   \n  ## ##  \n  ##  ## \n         \n',
    '#': '         \n  #####  \n ##      \n ##      \n ######  \n ##   ## \n  #####  \n         \n',
    '0': '###    \n ###   \n ###   \n ###   \n####   \n####   \n###    \n###    \n',
    '=': '       # \n       # \n       # \n       # \n       # \n  ### ## \n    ###  \n         \n',
    'p': '         \n  ####   \n######## \n######## \n  ###### \n  ###### \n    #### \n      ## \n'}

hypa_bal_dic = {
    'q': '   ### # \n   ##    \n ###   # \n# ##  ## \n#   ## # \n ## ###  \n   ### # \n# # ## # \n',
    '*': '#   #    \n   #     \n##### #  \n# # #  # \n    #### \n#   ## # \n   ##    \n## # #   \n',
    '9': '# ##  ## \n##  #    \n# # ## # \n  #  ##  \n   ### # \n#  #   # \n# ##  ## \n# #   #  \n',
    ',': '   # ##  \n   ## #  \n# # ##   \n ## ## # \n   ### # \n## #     \n    # ## \n# #      \n',
    '<': '  #  #   \n   ### # \n#  #   # \n# ##  ## \n##  #    \n### #    \n  #      \n  #  #   \n',
    'G': '######   \n##  ##   \n##       \n## ####  \n##  ##   \n##  ##   \n######   \n         \n',
    'S': '######   \n##       \n##       \n######   \n    ##   \n    ##   \n######   \n         \n',
    'a': '# ##  ## \n##  #    \n### #    \n  #      \n  #  #   \n   ### # \n#  #   # \n# ##  ## \n',
    'D': '####     \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n####     \n         \n',
    '&': ' ##    # \n#   #    \n#   #    \n ##      \n # ##    \n#   #    \n ##   #  \n # ##  # \n',
    'z': ' #  ##   \n   ##  # \n   ## ## \n##  #    \n# ##   # \n# ##  ## \n####     \n  ## ##  \n',
    'w': ' ## ###  \n   ### # \n#   ## # \n      #  \n## # #   \n# # ##   \n ## #  # \n   ### # \n',
    ')': '#   #    \n   #     \n##### #  \n# #      \n   ####  \n#  ##  # \n ## #    \n   ### # \n',
    'J': '######   \n    ##   \n    ##   \n    ##   \n##  ##   \n##  ##   \n######   \n         \n',
    'F': '######   \n##       \n##       \n####     \n##       \n##       \n##       \n         \n',
    '8': '   ### # \n#  #   # \n# ##  ## \n##  #    \n# # ## # \n  #  # # \n   ### # \n#  #   # \n',
    'U': '##  ##   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n######   \n         \n',
    '{': ' ##    # \n#   #    \n ## #    \n ##   #  \n # ##    \n#   #    \n ##   #  \n # ##  # \n',
    '"': '#        \n#   # #  \n#    # # \n#      # \n ## #    \n#   #    \n ##   #  \n # ##  # \n',
    'y': '         \n## # #   \n##  #    \n# ##   # \n# ##  ## \n#   ## # \n       # \n## # #   \n',
    'B': '####     \n##  ##   \n##  ##   \n####     \n##  ##   \n##  ##   \n####     \n         \n',
    '^': ' ##    # \n#      # \n ##    # \n ##    # \n ##    # \n ##    # \n#        \n ## # #  \n',
    'C': '######   \n##       \n##       \n##       \n##       \n##       \n######   \n         \n',
    '@': '# # #  # \n       # \n#  #   # \n# ##  ## \n##  #    \n# # #  # \n         \n#  #   # \n',
    '5': '# #      \n         \n# #   #  \n   #   # \n  #      \n  #  #   \n   ### # \n#  #   # \n',
    '3': '# # ## # \n  #  # # \n   ### # \n   ##    \n ## #  # \n   ##  # \n#   ## # \n  #  # # \n',
    ']': ' ##    # \n#   #    \n#   #    \n#   #    \n#   #    \n#   #    \n ##   #  \n # ##  # \n',
    'M': '##  ##   \n######   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n         \n',
    '_': ' ##    # \n#   #    \n # ##    \n ##    # \n#    # # \n#    # # \n#        \n# # # #  \n',
    'Q': '######   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n####     \n##  ##   \n         \n',
    '2': '# # #  # \n # # ### \n#   ## # \n  #  ##  \n   ### # \n##  # #  \n####     \n   #     \n',
    '%': ' ##    # \n#   #    \n#   #    \n ##   #  \n#   #    \n#   #    \n ##   #  \n # ##  # \n',
    "'": '# # #  # \n         \n#    # # \n# ##   # \n#    # # \n# ##  #  \n ##      \n# #  # # \n',
    'e': '# #      \n   # ### \n# # ## # \n ## # #  \n   ### # \n####     \n    # #  \n##  ###  \n',
    '.': '#   #  # \n   ##  # \n# # ##   \n ### ### \n   ### # \n## #     \n    # ## \n# #      \n',
    '/': ' ###  #  \n#    #   \n# ##  ## \n# #      \n   ### # \n#    #   \n# ## #   \n #  ##   \n',
    ':': '         \n##  #    \n  #      \n  #  #   \n   ### # \n #  #    \n  # #  # \n      #  \n',
    'r': ' ## #### \n   ### # \n ## #  # \n         \n##  #  # \n   #     \n#  #     \n   # ##  \n',
    'L': '##       \n##       \n##       \n##       \n##       \n##       \n######   \n         \n',
    't': '####   # \n# ##  ## \n#   ## # \n ## ###  \n   ### # \n# # ## # \n ## #### \n   ### # \n',
    '(': '# ##   # \n## #     \n   ##    \n# #      \n   ##    \n#  ##  # \n         \n## # #   \n',
    'P': '######   \n##  ##   \n##  ##   \n######   \n##       \n##       \n##       \n         \n',
    '-': ' ## #    \n#    #   \n# ##  ## \n# #      \n   ### # \n#    #   \n# ## #   \n #  ##   \n',
    'u': '### #  # \n         \n  ##     \n      #  \n# # #  # \n         \n#   ## # \n ## #### \n',
    'v': '   ### # \n# # ## # \n ## #### \n   ### # \n#   ## # \n      ## \n## # #   \n# # ## # \n',
    '>': ' ## #    \n  # #  # \n #       \n####     \n    # ## \n# # #  # \n######## \n#  #   # \n',
    'd': '   ### # \n#    # # \n# ##  ## \n# #   #  \n         \n  #      \n    #    \n   ### # \n',
    '$': '#        \n ## #    \n # ##    \n ##   #  \n ##    # \n ##    # \n ##    # \n # ##  # \n',
    'A': '######   \n##  ##   \n##  ##   \n######   \n##  ##   \n##  ##   \n##  ##   \n         \n',
    'O': '######   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n######   \n         \n',
    '\\': '         \n  ##     \n  ##     \n         \n  ##     \n  ##     \n         \n         \n',
    'I': '######   \n  ##     \n  ##     \n  ##     \n  ##     \n  ##     \n######   \n         \n',
    'V': '##  ##   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n  ##     \n         \n',
    'g': '   ## #  \n# # ## # \n ## # ## \n   ### # \n####     \n    # #  \n##  ###  \n ## # ## \n',
    '`': ' ##    # \n#   #    \n ## #    \n ##   #  \n # ##    \n#   #    \n ##   #  \n # ##  # \n',
    'x': '#   # #  \n  # #  # \n       # \n## #     \n    ###  \n# ##   # \n# ##  ## \n#   ## # \n',
    'm': ' #  ##   \n   ##  # \n   ## ## \n#   ## # \n     #   \n## # #   \n# # #  # \n#######  \n',
    '7': '  #  #   \n   ### # \n#  #   # \n# ##  ## \n##  #    \n### #    \n  #      \n  #  #   \n',
    'E': '######   \n##       \n##       \n####     \n##       \n##       \n######   \n         \n',
    'Z': '######   \n    ##   \n    ##   \n  ##     \n##       \n##       \n######   \n         \n',
    'i': '         \n   #  #  \n# ##   # \n# ##  ## \n#   ## # \n ## # #  \n   ### # \n##  #    \n',
    'l': '# # ## # \n ## #    \n   ### # \n## #     \n    #  # \n#   ## # \n ## ## # \n   ### # \n',
    ';': '####     \n   # ##  \n ## #    \n# #   #  \n    #### \n# #      \n     ##  \n  #      \n',
    'K': '##  ##   \n##  ##   \n####     \n####     \n##  ##   \n##  ##   \n##  ##   \n         \n',
    '4': '   ### # \n#  #     \n####  #  \n### ###  \n  #  ##  \n   ### # \n## #     \n### ## # \n',
    'c': ' ## ## # \n   ### # \n####     \n #  ##   \n#    # # \n# ## #   \n# # ## # \n ## ##   \n',
    'N': '##  ##   \n##  ##   \n######   \n######   \n######   \n##  ##   \n##  ##   \n         \n',
    '1': '#    #   \n# ## #   \n# # # #  \n# # #  # \n### #  # \n#   ## # \n  #  # # \n   ### # \n',
    'Y': '##  ##   \n##  ##   \n##  ##   \n  ##     \n  ##     \n  ##     \n  ##     \n         \n',
    'o': '# #      \n         \n   #   # \n# ##  ## \n# # # #  \n   #     \n  ##  #  \n# #      \n',
    'j': '# ##   # \n# ##  ## \n#   ## # \n ## # ## \n   ### # \n### ###  \n ## #  # \n   ### # \n',
    'f': ' ## # #  \n   ### # \n# ##   # \n# ##  ## \n    #  # \n       # \n #  ##   \n ## # #  \n',
    '+': ' #  ##   \n   ##### \n   ### # \n##  #  # \n######## \n## #     \n      ## \n #  ##   \n',
    ' ': ' ##    # \n#   #    \n ## #    \n ##   #  \n # ##    \n#   #    \n ##   #  \n # ##  # \n',
    'n': '#   ## # \n  ##  ## \n   ### # \n# # #  # \n       # \n#   ## # \n   ## #  \n   ### # \n',
    '6': '# ##  ## \n##  #    \n#  ##    \n#  #   # \n# ##  ## \n##  #    \n### #    \n  #      \n',
    'k': '### ###  \n ## #  # \n   ### # \n# #   #  \n         \n  #      \n #  ## # \n   ### # \n',
    's': '# # #  # \n#   #### \n## #     \n   #  #  \n# # ## # \n ## ###  \n   ### # \n  ###    \n',
    'h': '   ### # \n# ##   # \n# ##  ## \n  # #  # \n#######  \n #  ##   \n ## # #  \n   ## #  \n',
    '?': '# ##  ## \n##  #    \n# # #  # \n#   #### \n#  #   # \n# ##  ## \n## #     \n    #  # \n',
    'H': '##  ##   \n##  ##   \n##  ##   \n######   \n##  ##   \n##  ##   \n##  ##   \n         \n',
    '}': ' ##    # \n#   #    \n ## #    \n ##   #  \n # ##    \n#   #    \n ##   #  \n # ##  # \n',
    'b': '### #    \n##  #    \n  #      \n  #  #   \n   ### # \n#  #   # \n# ##  ## \n# # ## # \n',
    '|': ' ##    # \n#   #    \n ## #    \n ##   #  \n # ##    \n#   #    \n ##   #  \n # ##  # \n',
    'W': '##  ##   \n##  ##   \n##  ##   \n##  ##   \n##  ##   \n######   \n##  ##   \n         \n',
    'X': '##  ##   \n##  ##   \n  ##     \n  ##     \n  ##     \n##  ##   \n##  ##   \n         \n',
    'T': '######   \n  ##     \n  ##     \n  ##     \n  ##     \n  ##     \n  ##     \n         \n',
    '~': ' ##    # \n#   #    \n ## #    \n ##   #  \n # ##    \n#   #    \n ##   #  \n # ##  # \n',
    '[': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '!': '#    # # \n#    # # \n#    # # \n#   #    \n#   #    \n#        \n ## #    \n # # ##  \n',
    'R': '######   \n##  ##   \n##  ##   \n######   \n####     \n##  ##   \n##  ##   \n         \n',
    '#': ' ##    # \n#   #    \n#   # #  \n#      # \n#   #    \n#   #    \n ##   #  \n # ##  # \n',
    '0': '#   #  # \n   ##  # \n# #      \n #####   \n#    #   \n# ##  ## \n# #      \n   ### # \n',
    '=': '   ### # \n#  #   # \n# ##  ## \n# #   #  \n         \n #  ##   \n    #    \n   ## #  \n',
    'p': '   # ##  \n# # ## # \n ## #### \n   ### # \n  ##     \n   # ##  \n# # ## # \n ## ###  \n'}

hyper_dic = {
    'q': '         \n  ####   \n ######  \n ######  \n ######  \n ######  \n  ####   \n         \n',
    '*': '   #     \n # # #   \n  ###    \n#######  \n  ###    \n # # #   \n   #     \n         \n',
    '9': ' #####   \n##   ##  \n##   ##  \n ######  \n     ##  \n    ##   \n ####    \n         \n',
    ',': '         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '<': '    ###  \n   ###   \n  ###    \n ###     \n  ###    \n   ###   \n    ###  \n         \n',
    'G': '  ####   \n ##  ##  \n##       \n##  ###  \n##   ##  \n ##  ##  \n  ####   \n         \n',
    'S': ' ####    \n##  ##   \n##       \n #####   \n     ##  \n##   ##  \n #####   \n         \n',
    'a': '    #    \n   ###   \n  #####  \n ####### \n ####### \n   ###   \n  #####  \n         \n',
    'D': '#####    \n##  ##   \n##   ##  \n##   ##  \n##   ##  \n##  ##   \n#####    \n         \n',
    '&': ' ####    \n##  ##   \n ####    \n ###     \n##  ###  \n##  ##   \n ######  \n         \n',
    'z': '    #    \n   ###   \n  #####  \n ####### \n  #####  \n   ###   \n    #    \n         \n',
    'w': '         \n  ####   \n ######  \n ##  ##  \n ##  ##  \n ######  \n  ####   \n         \n',
    ')': ' ###     \n  ###    \n   ###   \n   ###   \n   ###   \n  ###    \n ###     \n         \n',
    'J': '    ###  \n     ##  \n     ##  \n #   ##  \n##   ##  \n##   ##  \n #####   \n         \n',
    'F': ' ######  \n ##      \n ##      \n #####   \n ##      \n ##      \n ##      \n         \n',
    '8': ' ####    \n##   #   \n###  #   \n ####    \n#  ####  \n#    ##  \n #####   \n         \n',
    'U': '##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n #####   \n         \n',
    '{': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': '##  ##   \n##  ##   \n         \n         \n         \n         \n         \n         \n',
    'y': '##  \n##  \n##  \n##  \n##  \n##  \n##  \n##  \n',
    'B': '######   \n##   ##  \n##   ##  \n######   \n##   ##  \n##   ##  \n######   \n         \n',
    '^': '         \n# #### # \n# #  # # \n# #### # \n# #  # # \n# #### # \n         \n         \n',
    'C': '  ####   \n ##  ##  \n##       \n##       \n##       \n ##  ##  \n  ####   \n         \n',
    '@': '         \n         \n         \n######## \n######## \n         \n         \n         \n',
    '5': '######   \n##       \n######   \n     ##  \n     ##  \n##   ##  \n #####   \n         \n',
    '3': ' ######  \n    ##   \n   ##    \n  ####   \n     ##  \n##   ##  \n #####   \n         \n',
    ']': '         \n  #  ### \n ##  #   \n  #  ### \n  #      \n ### ### \n         \n         \n',
    'M': '##   ##  \n### ###  \n#######  \n#######  \n## # ##  \n##   ##  \n##   ##  \n         \n',
    '_': '         \n###  # # \n     # # \n###  # # \n  #      \n###  # # \n         \n         \n',
    'Q': ' #####   \n##   ##  \n##   ##  \n##   ##  \n## ####  \n##  ##   \n #### #  \n         \n',
    '2': ' #####   \n##   ##  \n    ###  \n  ####   \n ###     \n###   #  \n#######  \n         \n',
    '%': '##   #   \n##  ##   \n   ##    \n  ##     \n ##      \n##  ##   \n#   ##   \n         \n',
    "'": '   ###   \n  ###    \n ###     \n         \n         \n         \n         \n         \n',
    'e': '         \n######## \n######## \n         \n         \n         \n         \n         \n',
    '.': '         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '/': '     ##  \n    ###  \n   ###   \n  ###    \n ###     \n###      \n##       \n         \n',
    ':': '         \n   ##    \n   ##    \n         \n         \n   ##    \n   ##    \n         \n',
    'r': '         \n         \n         \n         \n         \n######## \n######## \n         \n',
    'L': ' ##      \n ##      \n ##      \n ##      \n ##      \n ##   #  \n ######  \n         \n',
    't': '##      \n##      \n##      \n##      \n##      \n##      \n##      \n##      \n',
    '(': '   ###   \n  ###    \n ###     \n ###     \n ###     \n  ###    \n   ###   \n         \n',
    'P': '######   \n##   ##  \n##   ##  \n##   ##  \n######   \n##       \n##       \n         \n',
    '-': '         \n         \n         \n ######  \n ######  \n         \n         \n         \n',
    'u': '         \n         \n         \n     ### \n    #### \n   ###   \n   ##    \n   ##    \n',
    'v': '##    ## \n###  ### \n ######  \n  ####   \n  ####   \n ######  \n###  ### \n##    ## \n',
    '>': ' ###     \n  ###    \n   ###   \n    ###  \n   ###   \n  ###    \n ###     \n         \n',
    'd': '         \n         \n######## \n######## \n         \n         \n         \n         \n',
    '$': '  ##     \n #####   \n##       \n ####    \n    ##   \n#####    \n  ##     \n         \n',
    'A': '  ###    \n ## ##   \n##   ##  \n##   ##  \n#######  \n##   ##  \n##   ##  \n         \n',
    'O': ' #####   \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n##   ##  \n #####   \n         \n',
    '\\': '         \n# ####   \n  #      \n# #      \n# #      \n# ####   \n         \n         \n',
    'I': ' ######  \n # ## #  \n   ##    \n   ##    \n   ##    \n # ## #  \n ######  \n         \n',
    'V': '##   ##  \n##   ##  \n##   ##  \n### ###  \n #####   \n  ###    \n   #     \n         \n',
    'g': '##     \n##     \n##     \n##     \n##     \n##     \n##     \n##     \n',
    '`': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'x': '   ##    \n   ##    \n ##  ##  \n ##  ##  \n   ##    \n   ##    \n  ####   \n         \n',
    'm': '##       \n###      \n ###     \n  ###    \n   ###   \n    ###  \n     ### \n      ## \n',
    '7': '#######  \n##   ##  \n    ##   \n   ##    \n  ##     \n  ##     \n  ##     \n         \n',
    'E': ' ######  \n ##      \n ##      \n #####   \n ##      \n ##      \n ######  \n         \n',
    'Z': '#######  \n    ###  \n   ###   \n  ###    \n ###     \n###      \n#######  \n         \n',
    'i': '         \n         \n         \n###      \n####     \n  ###    \n   ##    \n   ##    \n',
    'l': '##       \n##       \n##       \n##       \n##       \n##       \n######## \n######## \n',
    ';': '         \n   ##    \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    'K': '##   ##  \n##  ##   \n## ##    \n####     \n#####    \n## ###   \n##  ###  \n         \n',
    '4': '   ###   \n  ####   \n ## ##   \n##  ##   \n#######  \n    ##   \n   ####  \n         \n',
    'c': '         \n         \n         \n######## \n######## \n         \n         \n         \n',
    'N': '##   ##  \n###  ##  \n#### ##  \n#######  \n## ####  \n##  ###  \n##   ##  \n         \n',
    '1': '   ##    \n  ###    \n   ##    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    'Y': ' ##  ##  \n ##  ##  \n  #  #   \n  ####   \n   ##    \n   ##    \n   ##    \n         \n',
    'o': '######## \n######## \n##       \n##       \n##       \n##       \n##       \n##       \n',
    'j': '   ##    \n   ##    \n   ###   \n    #### \n     ### \n         \n         \n         \n',
    'f': '         \n         \n         \n         \n######## \n######## \n         \n         \n',
    '+': '         \n   ##    \n   ##    \n ######  \n ######  \n   ##    \n   ##    \n         \n',
    ' ': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'n': '      ## \n     ### \n    ###  \n   ###   \n  ###    \n ###     \n###      \n##       \n',
    '6': '  ####   \n ##      \n##       \n######   \n##   ##  \n##   ##  \n #####   \n         \n',
    'k': '   ##    \n   ##    \n  ###    \n####     \n###      \n         \n         \n         \n',
    's': '  ## ##  \n ####### \n ####### \n ####### \n  #####  \n   ###   \n    #    \n         \n',
    'h': '##   \n##   \n##   \n##   \n##   \n##   \n##   \n##   \n',
    '?': ' ######  \n ######  \n     ##  \n   ####  \n   ##    \n         \n   ##    \n         \n',
    'H': '### ###  \n##   ##  \n##   ##  \n#######  \n##   ##  \n##   ##  \n### ###  \n         \n',
    '}': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'b': '##    \n##    \n##    \n##    \n##    \n##    \n##    \n##    \n',
    '|': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'W': '##   ##  \n##   ##  \n## # ##  \n#######  \n#######  \n ## ##   \n #   #   \n         \n',
    'X': '##   ##  \n### ###  \n #####   \n  ###    \n #####   \n### ###  \n##   ##  \n         \n',
    'T': ' ######  \n # ## #  \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    '~': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '[': '         \n#### ### \n#  # #   \n#### ### \n#  #     \n#  # ### \n         \n         \n',
    '!': '   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n   ##    \n         \n',
    'R': '######   \n##   ##  \n##   ##  \n##  ###  \n#####    \n## ###   \n##  ###  \n         \n',
    '#': ' ##  ##  \n######## \n######## \n ##  ##  \n######## \n######## \n ##  ##  \n         \n',
    '0': '  ###    \n #  ##   \n##   ##  \n##   ##  \n##   ##  \n ##  #   \n  ###    \n         \n',
    '=': '         \n#######  \n#######  \n         \n#######  \n#######  \n         \n         \n',
    'p': '######## \n######## \n      ## \n      ## \n      ## \n      ## \n      ## \n      ## \n'}

inc_raw_dic = {
    'q': '##     # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#     ## \n####   # \n',
    '*': '         \n  #  ##  \n  ####   \n######## \n  ####   \n ##  #   \n         \n         \n',
    '9': ' #####  \n##  ##  \n##  ##  \n######  \n    ##  \n    ##  \n##  ##  \n#####   \n',
    ',': '         \n         \n         \n         \n         \n    #    \n   ##    \n  ##     \n',
    '<': '    ##  \n  ##    \n ##     \n##      \n##      \n ##     \n  ##    \n   ##   \n',
    'G': ' #####  \n##  ##  \n##      \n## ###  \n##  ##  \n##  ##  \n##  ##  \n#####   \n',
    'S': ' #####  \n##  ##  \n##      \n ####   \n    ##  \n    ##  \n##  ##  \n#####   \n',
    'a': '##     # \n#  ##  # \n#  ##  # \n#      # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ## ## \n',
    'D': ' #####  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n## ##   \n####    \n',
    '&': '  ####  \n #   #  \n#    #  \n# ## #  \n# ## #  \n#    #  \n#   #   \n####    \n',
    'z': '##     # \n#####  # \n####  ## \n###  ### \n##  #### \n#  ##### \n#  ##### \n#     ## \n',
    'w': '## ###   \n#  ###   \n#  ###   \n#  ###   \n#  # #   \n#        \n#   #    \n#  ### # \n',
    ')': ' #     \n ##    \n  ##   \n  ##   \n  ##   \n  ##   \n ##    \n#      \n',
    'J': '   ###  \n   ##   \n   ##   \n   ##   \n   ##   \n   ##   \n## ##   \n####    \n',
    'F': ' #####  \n##      \n##      \n####    \n##      \n##      \n##      \n##      \n',
    '8': ' #####  \n##  ##  \n##  ##  \n ####   \n##  ##  \n##  ##  \n##  ##  \n#####   \n',
    'U': ' #  ##  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n######  \n#####   \n',
    '{': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': '  #   #  \n ##  ##  \n #   #   \n         \n         \n         \n         \n         \n',
    'y': '## ##  # \n#  ##  # \n#  ##  # \n##    ## \n###  ### \n###  ### \n###  ### \n### #### \n',
    'B': ' #####  \n##  ##  \n##  ##  \n#####   \n##  ##  \n##  ##  \n##  ##  \n#####   \n',
    '^': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'C': ' #####  \n##  ##  \n##      \n##      \n##      \n##      \n##  ##  \n#####   \n',
    '@': '######## \n######## \n######## \n######## \n######## \n######## \n######## \n######## \n',
    '5': ' #####  \n##      \n######  \n    ##  \n    ##  \n    ##  \n##  ##  \n#####   \n',
    '3': ' #####  \n##  ##  \n    ##  \n  ###   \n    ##  \n##  ##  \n##  ##  \n#####   \n',
    ']': ' ###   \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n  ##   \n###    \n',
    'M': ' #   ## \n### ### \n####### \n## # ## \n##   ## \n##   ## \n##   ## \n##   #  \n',
    '_': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'Q': ' #####  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n#####   \n   ###  \n',
    '2': ' #####  \n##  ##  \n    ##  \n   ##   \n ##     \n##      \n##      \n#####   \n',
    '%': '  #   #  \n #   ##  \n    ##   \n   ##    \n  ##     \n ##   #  \n##   #   \n#        \n',
    "'": '      #  \n    ##   \n   #     \n         \n         \n         \n         \n         \n',
    'e': '##     # \n#  ##### \n#  ##### \n#    ### \n#  ##### \n#  ##### \n#  ##### \n#     ## \n',
    '.': '         \n         \n         \n         \n         \n    #    \n   ##    \n   #     \n',
    '/': '         \n       # \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n#        \n',
    ':': '         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    'r': '##     # \n#  ##  # \n#  ##  # \n#     ## \n#    ### \n#  #  ## \n#  #  ## \n#  #  ## \n',
    'L': ' #      \n##      \n##      \n##      \n##      \n##      \n##      \n#####   \n',
    't': '##     # \n###  ### \n###  ### \n###  ### \n###  ### \n###  ### \n###  ### \n### #### \n',
    '(': '   #   \n ##    \n##     \n##     \n##     \n##     \n ##    \n  #    \n',
    'P': ' #####  \n##  ##  \n##  ##  \n##  ##  \n#####   \n##      \n##      \n##      \n',
    '-': '         \n         \n         \n ######  \n         \n         \n         \n         \n',
    'u': '## ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#      # \n#     ## \n',
    'v': '## ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#     ## \n#    ### \n',
    '>': ' ##     \n  ##    \n   ##   \n    ##  \n    ##  \n   ##   \n  ##    \n##      \n',
    'd': '##     # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  #  ## \n#    ### \n',
    '$': '         \n         \n   ###   \n  ####   \n  ####   \n  ###    \n         \n         \n',
    'A': ' #####  \n##  ##  \n##  ##  \n######  \n##  ##  \n##  ##  \n##  ##  \n##  #   \n',
    'O': ' #####  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n#####   \n',
    '\\': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'I': ' ###   \n ##    \n ##    \n ##    \n ##    \n ##    \n ##    \n###    \n',
    'V': ' #  ##  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n##  ##  \n#####   \n####    \n',
    'g': '##     # \n#  ##  # \n#  ##### \n#  #   # \n#  ##  # \n#  ##  # \n#  ##  # \n#     ## \n',
    '`': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'x': '## ##  # \n#  ##  # \n##    ## \n###  ### \n##    ## \n#  ##  # \n#  ##  # \n#  ## ## \n',
    'm': '## ###   \n#   #    \n#        \n#  # #   \n#  ###   \n#  ###   \n#  ###   \n#  ### # \n',
    '7': ' ######  \n##   ##  \n    ##   \n   ##    \n   ##    \n   ##    \n   ##    \n   #     \n',
    'E': ' #####  \n##      \n##      \n####    \n##      \n##      \n##      \n#####   \n',
    'Z': ' #####  \n    ##  \n   ##   \n  ##    \n ##     \n##      \n##      \n#####   \n',
    'i': '###   ## \n###  ### \n###  ### \n###  ### \n###  ### \n###  ### \n###  ### \n##   ### \n',
    'l': '## ##### \n#  ##### \n#  ##### \n#  ##### \n#  ##### \n#  ##### \n#  ##### \n#     ## \n',
    ';': '         \n         \n    #    \n         \n         \n    #    \n   ##    \n  #      \n',
    'K': ' #  ##  \n## ##   \n####    \n###     \n####    \n## ##   \n## ##   \n## ##   \n',
    '4': '    ##  \n   ###  \n  ####  \n##  ##  \n####### \n    ##  \n    ##  \n    #   \n',
    'c': '##     # \n#  ##  # \n#  ##### \n#  ##### \n#  ##### \n#  ##### \n#  ##  # \n#     ## \n',
    'N': ' #  ##  \n##  ##  \n### ##  \n######  \n######  \n## ###  \n##  ##  \n##  #   \n',
    '1': '   #    \n  ##    \n ###    \n  ##    \n  ##    \n  ##    \n  ##    \n#####   \n',
    'Y': ' #  ##  \n##  ##  \n##  ##  \n ####   \n  ##    \n  ##    \n  ##    \n  #     \n',
    'o': '##     # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ##  # \n#     ## \n',
    'j': '####   # \n####  ## \n####  ## \n####  ## \n####  ## \n####  ## \n#  #  ## \n#    ### \n',
    'f': '##     # \n#  ##### \n#  ##### \n#    ### \n#  ##### \n#  ##### \n#  ##### \n#  ##### \n',
    '+': '         \n    #    \n   ##    \n ######  \n   ##    \n   #     \n         \n         \n',
    ' ': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'n': '## ##  # \n#  ##  # \n#   #  # \n#      # \n#      # \n#  #   # \n#  ##  # \n#  ## ## \n',
    '6': ' #####  \n##  ##  \n##      \n######  \n##  ##  \n##  ##  \n##  ##  \n#####   \n',
    'k': '## ##  # \n#  #  ## \n#    ### \n#   #### \n#    ### \n#  #  ## \n#  #  ## \n#  #  ## \n',
    's': '##     # \n#  ##  # \n#  ##### \n##    ## \n#####  # \n#####  # \n#  ##  # \n#     ## \n',
    'h': '## ##  # \n#  ##  # \n#  ##  # \n#      # \n#  ##  # \n#  ##  # \n#  ##  # \n#  ## ## \n',
    '?': '  #####  \n ##  ##  \n     ##  \n    ##   \n   ##    \n         \n   ##    \n   #     \n',
    'H': ' #  ##  \n##  ##  \n##  ##  \n######  \n##  ##  \n##  ##  \n##  ##  \n##  #   \n',
    '}': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'b': '##     # \n#  ##  # \n#  ##  # \n#     ## \n#  ##  # \n#  ##  # \n#  ##  # \n#     ## \n',
    '|': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'W': ' #   ## \n##   ## \n##   ## \n##   ## \n## # ## \n####### \n### ### \n##   #  \n',
    'X': ' #  ##  \n##  ##  \n ####   \n  ##    \n ####   \n##  ##  \n##  ##  \n##  #   \n',
    'T': '#####  \n ##    \n ##    \n ##    \n ##    \n ##    \n ##    \n #     \n',
    '~': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '[': ' ###   \n##     \n##     \n##     \n##     \n##     \n##     \n###    \n',
    '!': '    #    \n   ##    \n   ##    \n   ##    \n   ##    \n         \n   ##    \n   #     \n',
    'R': ' #####  \n##  ##  \n##  ##  \n#####   \n####    \n## ##   \n## ##   \n## ##   \n',
    '#': '  #   #  \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n######## \n ##  ##  \n #   #   \n',
    '0': ' #####  \n##  ##  \n##  ##  \n## ###  \n### ##  \n##  ##  \n##  ##  \n#####   \n',
    '=': '         \n         \n  #####  \n         \n #####   \n         \n         \n         \n',
    'p': '##     # \n#  ##  # \n#  ##  # \n#  ##  # \n#     ## \n#  ##### \n#  ##### \n#  ##### \n'}

italics_dic = {
    'q': '   ###   \n  #   #  \n  #   #  \n #   #   \n # # #   \n #  ##   \n  ### #  \n         \n',
    '*': '         \n #    #  \n  ####   \n######## \n  ####   \n      #  \n         \n         \n',
    '9': '   ###   \n  #   #  \n  #   #  \n   ###   \n     #   \n     #   \n ####    \n         \n',
    ',': '         \n         \n         \n         \n         \n    #    \n    #    \n   #     \n',
    '<': '    ###  \n   #     \n  #      \n #       \n  #      \n   #     \n    ###  \n         \n',
    'G': '         \n         \n  ####   \n #    #  \n #   #   \n  ####   \n     #   \n ####    \n',
    'S': '         \n         \n     #   \n    # #  \n   #  #  \n  #   #  \n # ###   \n         \n',
    'a': '      #  \n     ##  \n    # #  \n   #  #  \n ######  \n  #   #  \n #    #  \n         \n',
    'D': '         \n      #  \n      #  \n   ###   \n  #  #   \n #   #   \n #### #  \n         \n',
    '&': '  ####   \n #    #  \n  #  #   \n  ###    \n #   ### \n #    #  \n  ###### \n         \n',
    'z': ' ######  \n     #   \n    #    \n   #     \n   #     \n  #   #  \n #####   \n         \n',
    'w': ' ##   #  \n  #   #  \n  #   #  \n # # #   \n # # #   \n ## ##   \n #   #   \n         \n',
    ')': '   #     \n    #    \n     #   \n     #   \n     #   \n    #    \n   #     \n         \n',
    'J': '         \n     #   \n         \n     #   \n     #   \n    #    \n    #    \n ###     \n',
    'F': '         \n   ###   \n  #      \n  #      \n ####    \n #       \n #       \n         \n',
    '8': '   ###   \n  #   #  \n  #   #  \n   ##    \n #   #   \n #   #   \n  ###    \n         \n',
    'U': '         \n         \n  #   #  \n  #   #  \n #   #   \n #   #   \n #### #  \n         \n',
    '{': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '"': '  #  #   \n  #  #   \n  #  #   \n         \n         \n         \n         \n         \n',
    'y': ' ##   #  \n  #   #  \n  #  #   \n   # #   \n    #    \n   #     \n ##      \n         \n',
    'B': '         \n ##      \n  #      \n  ####   \n #    #  \n #   #   \n #####   \n         \n',
    '^': '         \n   ##    \n  ####   \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n',
    'C': '         \n         \n   ###   \n  #      \n #       \n #       \n  ####   \n         \n',
    '@': '  ####   \n #  # #  \n # # #   \n #  #    \n #       \n #    #  \n  ####   \n         \n',
    '5': '   ####  \n  #      \n  ####   \n      #  \n      #  \n     ##  \n ####    \n         \n',
    '3': '   ###   \n      #  \n     ##  \n  ###    \n     #   \n     #   \n ####    \n         \n',
    ']': '  ####   \n     #   \n     #   \n     #   \n     #   \n     #   \n  ####   \n         \n',
    'M': '         \n         \n  #### # \n #  # #  \n#  #  #  \n#  #  #  \n#  #  #  \n         \n',
    '_': '         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'Q': '         \n         \n  ### #  \n #   ##  \n #    #  \n  ####   \n     #   \n     #   \n',
    '2': '   ###   \n  #   #  \n     #   \n    #    \n   #     \n  #      \n #####   \n         \n',
    '%': ' ##   #  \n ##  #   \n    #    \n   #     \n  #      \n #   ##  \n#    ##  \n         \n',
    "'": '      #  \n     #   \n    #    \n         \n         \n         \n         \n         \n',
    'e': ' # ####  \n   #     \n  #      \n ####    \n  # #    \n #       \n #####   \n         \n',
    '.': '         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '/': '         \n      #  \n     #   \n    #    \n   #     \n  #      \n #       \n         \n',
    ':': '         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    'r': ' #####   \n   #  #  \n   #  #  \n  ####   \n  #  #   \n #   #   \n #   ##  \n         \n',
    'L': '         \n    ##   \n   # #   \n  #  #   \n  # #    \n  ##     \n # ####  \n         \n',
    't': ' ######  \n   #     \n   #     \n   #     \n  #      \n  #      \n  #      \n         \n',
    '(': '    #    \n   #     \n  #      \n  #      \n  #      \n   #     \n    #    \n         \n',
    'P': '         \n         \n  # ##   \n  #   #  \n  #  #   \n # ##    \n #       \n #       \n',
    '-': '         \n         \n         \n ######  \n         \n         \n         \n         \n',
    'u': ' ##   #  \n  #   #  \n  #   #  \n #   #   \n #   #   \n #   #   \n  ###    \n         \n',
    'v': ' ###  #  \n #    #  \n   #  #  \n   # #   \n   # #   \n   # #   \n    #    \n         \n',
    '>': ' ###     \n    #    \n     #   \n      #  \n     #   \n    #    \n ###     \n         \n',
    'd': ' ######  \n   #  #  \n  #   #  \n  #   #  \n #   #   \n #   #   \n ####    \n         \n',
    '$': '    #    \n  #####  \n #       \n  ####   \n      #  \n #####   \n   #     \n         \n',
    'A': '         \n         \n   ##    \n  #  #   \n #  ##   \n #  #    \n  #####  \n         \n',
    'O': '         \n         \n   ###   \n  #   #  \n #   #   \n #   #   \n  ###    \n         \n',
    '\\': '    ##   \n   #  #  \n  #      \n #####   \n  #      \n #    #  \n######   \n         \n',
    'I': '         \n    #    \n         \n    #    \n    #    \n   #     \n   #     \n         \n',
    'V': '         \n         \n  #   #  \n  #   #  \n  #  #   \n  # #    \n   #     \n         \n',
    'g': '   ###   \n  ##  #  \n  #   #  \n #       \n #  ###  \n #   #   \n ####    \n         \n',
    '`': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'x': ' ##   #  \n  #  #   \n  # #    \n   ##    \n   ##    \n  # #    \n #  ###  \n         \n',
    'm': ' ##   #  \n  ## ##  \n  # # #  \n  # # #  \n # # #   \n #   #   \n #   ##  \n         \n',
    '7': '  #####  \n  #   #  \n     #   \n    #    \n   #     \n   #     \n   #     \n         \n',
    'E': '         \n         \n   ###   \n  #  #   \n ####    \n #       \n #####   \n         \n',
    'Z': '         \n         \n  #####  \n    #    \n   #     \n  #      \n ######  \n         \n',
    'i': '  #####  \n    #    \n    #    \n    #    \n   #     \n   #     \n #####   \n         \n',
    'l': '    #    \n    #    \n    #    \n   #     \n   #     \n   #     \n ######  \n         \n',
    ';': '         \n         \n   ##    \n         \n    #    \n    #    \n #       \n         \n',
    'K': '         \n   #     \n   #     \n  #  #   \n  ###    \n ## ##   \n #    #  \n         \n',
    '4': '     ##  \n    # #  \n   #  #  \n #    #  \n ####### \n     #   \n     #   \n         \n',
    'c': '   ####  \n  #   #  \n  #      \n #       \n #       \n #   #   \n  ####   \n         \n',
    'N': '         \n         \n # ####  \n  #   #  \n  #  #   \n #   #   \n #   #   \n         \n',
    '1': '    #    \n  ###    \n    #    \n    #    \n   #     \n   #     \n######   \n         \n',
    'Y': '         \n         \n  #  ##  \n  #  #   \n  #  #   \n  ####   \n    #    \n ####    \n',
    'o': '   ###   \n  #   #  \n  #   #  \n #   #   \n #   #   \n #   #   \n  ###    \n         \n',
    'j': ' ######  \n    #    \n    #    \n    #    \n   ##    \n#  #     \n####     \n         \n',
    'f': '   ####  \n   #     \n   #     \n #####   \n   ##    \n  #      \n  #      \n         \n',
    '+': '         \n    #    \n    #    \n  #####  \n    #    \n    #    \n         \n         \n',
    ' ': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'n': ' ### ##  \n   ## #  \n   #  #  \n  #  #   \n  #  #   \n  #  #   \n ##  ##  \n         \n',
    '6': '    ###  \n   #     \n  #      \n  ###    \n #   #   \n #   #   \n  ###    \n         \n',
    'k': ' ##   #  \n  #  #   \n  # #    \n # #     \n # #     \n #  #    \n#    #   \n         \n',
    's': '   ###   \n  #   #  \n# #      \n   ##    \n     #   \n #   #   \n  ###    \n         \n',
    'h': '   #  #  \n   #  #  \n   #  #  \n ######  \n  #  #   \n  #  #   \n ## ##   \n         \n',
    '?': '   ###   \n  #   #  \n      #  \n     #   \n    #    \n         \n    #    \n         \n',
    'H': '         \n  #      \n  #      \n  #####  \n  #  #   \n #   #   \n #   #   \n         \n',
    '}': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'b': ' ######  \n   #  #  \n   #  #  \n  ####   \n  #  #   \n #   #   \n ####    \n         \n',
    '|': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'W': '         \n         \n #     # \n#     #  \n#  #  #  \n# # ##   \n#    #   \n         \n',
    'X': '         \n         \n  #   ## \n  ## #   \n    #    \n   ##    \n ##  ##  \n         \n',
    'T': '         \n     #   \n   ####  \n    #    \n   #     \n   #     \n    ###  \n         \n',
    '~': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '[': '  ####   \n  #      \n  #      \n  #      \n  #      \n  #      \n  ####   \n         \n',
    '!': '   #     \n   #     \n   #     \n   #     \n         \n         \n   #     \n         \n',
    'R': '         \n         \n  #  ##  \n  ###    \n  #      \n #       \n #       \n         \n',
    '#': '  #  #   \n  #  #   \n######## \n  #  #   \n######## \n  #  #   \n  #  #   \n         \n',
    '0': '    #### \n   #  ## \n  #  # # \n  # # #  \n # #  #  \n ##  #   \n  ###    \n         \n',
    '=': '         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    'p': ' #####   \n   #  #  \n   #  #  \n  ####   \n  #      \n #       \n #       \n         \n'}

kgames_i_dic = {
    'q': '# # #  # \n# # #  # \n # # # # \n # # # # \n         \n         \n         \n         \n',
    '*': '#######  \n#   #### \n#    ### \n#    ### \n#     ## \n#     ## \n#      # \n##    ## \n',
    '9': '# # ##   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n',
    ',': '##   ### \n##   ### \n##   ### \n##   ### \n##   ### \n##   ### \n##   ### \n### #### \n',
    '<': '# # ##   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n######   \n######   \n',
    'G': '         \n  #####  \n ##      \n ##      \n ## ###  \n ##  ##  \n  #####  \n         \n',
    'S': '         \n  ####   \n ##      \n  ####   \n     ##  \n     ##  \n  ####   \n         \n',
    'a': '         \n         \n         \n         \n######## \n######## \n# # # #  \n# # # #  \n',
    'D': '         \n ####    \n ## ##   \n ##  ##  \n ##  ##  \n ## ##   \n ####    \n         \n',
    '&': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'z': ' # # # # \n # # # # \n # #     \n # #     \n # #     \n ####### \n######## \n# # # #  \n',
    'w': '# # #### \n# #  # # \n# # #### \n# #  # # \n# # #### \n# #  # # \n# # #### \n# #  # # \n',
    ')': ' ### \n ### \n ### \n ### \n ### \n ### \n ### \n#### \n',
    'J': '         \n     ##  \n     ##  \n     ##  \n     ##  \n ##  ##  \n  ####   \n         \n',
    'F': '         \n ######  \n ##      \n #####   \n ##      \n ##      \n ##      \n         \n',
    '8': '## #  \n## #  \n## #  \n## #  \n## #  \n## #  \n## #  \n## #  \n',
    'U': '         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ######  \n         \n',
    '{': '#####    \n######   \n  ####   \n  ####   \n   ####  \n   ####  \n   ####  \n  ###### \n',
    '"': '         \n         \n   ##### \n    #### \n    #### \n   ##### \n#######  \n#####    \n',
    'y': '# #####  \n#  # ##  \n# #####  \n#  # ##  \n# #####  \n#  # ##  \n# #####  \n#  # ##  \n',
    'B': '         \n #####   \n ##  ##  \n #####   \n ##  ##  \n ##  ##  \n #####   \n         \n',
    '^': '         \n         \n         \n         \n         \n         \n         \n       # \n',
    'C': '         \n  ####   \n ##  ##  \n ##      \n ##      \n ##  ##  \n  ####   \n         \n',
    '@': '         \n         \n         \n         \n######## \n######## \n### # #  \n### # #  \n',
    '5': ' # #     \n ###     \n# ##     \n# ##     \n# ## # # \n#  # # # \n# # # #  \n# # # #  \n',
    '3': '#######  \n #####   \n #####   \n #####   \n #####   \n #####   \n #####   \n#######  \n',
    ']': ' #####  \n #####  \n #####  \n #####  \n #####  \n #####  \n #####  \n####### \n',
    'M': '         \n ##   ## \n ### ### \n ####### \n ## # ## \n ##   ## \n ##   ## \n         \n',
    '_': '  ###### \n ####### \n ####    \n ####    \n####     \n####     \n####     \n#####    \n',
    'Q': '         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ## ##   \n  ## ##  \n         \n',
    '2': '####     \n###      \n###      \n##       \n##       \n#        \n#        \n         \n',
    '%': '         \n         \n         \n         \n         \n#        \n#        \n##       \n',
    "'": '         \n         \n         \n         \n         \n         \n         \n         \n',
    'e': '         \n         \n         \n         \n######## \n###### # \n# # #  # \n# # #  # \n',
    '.': '   ####  \n   ####  \n   ####  \n # ####  \n##  #### \n##  #### \n##   ### \n###    # \n',
    '/': '      ## \n      ## \n      ## \n      ## \n     ### \n#   #### \n######## \n######   \n',
    ':': ' ## #  \n ## #  \n ## #  \n ## #  \n ## #  \n ## #  \n ##### \n###### \n',
    'r': '### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### # ## \n# # # #  \n# # # #  \n',
    'L': '         \n ##      \n ##      \n ##      \n ##      \n ##      \n ######  \n         \n',
    't': '##### #  \n # ## #  \n##### #  \n # ## #  \n##### #  \n # ## #  \n##### #  \n # ## #  \n',
    '(': ' #####   \n #####   \n #####   \n #####   \n #####   \n #####   \n #####   \n#######  \n',
    'P': '         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ##      \n ##      \n         \n',
    '-': '#        \n#        \n#        \n#        \n#        \n######## \n######## \n######## \n',
    'u': '##### #  \n # ## #  \n##### #  \n # ## #  \n# # # #  \n# # # #  \n######## \n######## \n',
    'v': ' # # # # \n # # # # \n# # # #  \n# # # #  \n# # #### \n# #  # # \n# # #### \n# #  # # \n',
    '>': ' # # # # \n # # # # \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n',
    'd': '######## \n###### # \n# # #  # \n# # #  # \n# # #  # \n# # #  # \n# # #  # \n# # #  # \n',
    '$': '      #  \n         \n         \n         \n       # \n#     ## \n######## \n######## \n',
    'A': '         \n   ##    \n  ####   \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n         \n',
    'O': '         \n  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '\\': '#######  \n  ###### \n    #### \n    #### \n    #### \n   ##### \n#######  \n#####    \n',
    'I': '         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    'V': '         \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'g': '# # # #  \n# # # #  \n # # # # \n # # # # \n         \n         \n         \n         \n',
    '`': '#####    \n######   \n  ####   \n  ####   \n   ####  \n   ####  \n   ####  \n  ###### \n',
    'x': '# # #### \n# #  # # \n# # #### \n# #  # # \n# # # #  \n# # # #  \n######## \n######## \n',
    'm': '### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### # ## \n### # #  \n### # #  \n',
    '7': '     # # \n     # # \n     ##  \n     ##  \n # # ##  \n # # ##  \n# # # #  \n# # # #  \n',
    'E': '         \n ######  \n ##      \n #####   \n ##      \n ##      \n ######  \n         \n',
    'Z': '         \n ######  \n    ##   \n   ##    \n  ##     \n ##      \n ######  \n         \n',
    'i': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n # # # # \n # # # # \n',
    'l': '### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n',
    ';': '# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n######## \n######## \n',
    'K': '         \n ##  ##  \n ## ##   \n ####    \n ####    \n ## ##   \n ##  ##  \n         \n',
    '4': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'c': '######## \n######## \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n# # # #  \n',
    'N': '         \n ##  ##  \n ### ##  \n ######  \n ######  \n ## ###  \n ##  ##  \n         \n',
    '1': '   ##### \n     ### \n      ## \n#     ## \n#     ## \n##   ### \n######## \n#######  \n',
    'Y': '         \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n   ##    \n   ##    \n         \n',
    'o': '# # # #  \n# # # #  \n ## #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n',
    'j': '# # #  # \n# # #  # \n# # #  # \n# # #  # \n# # #  # \n# # #  # \n # # # # \n # # # # \n',
    'f': '### # #  \n### # #  \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n',
    '+': '      ## \n      ## \n#     ## \n#     ## \n##    ## \n##    ## \n###   ## \n#### ### \n',
    ' ': '#####    \n######   \n  ####   \n  ####   \n   ####  \n   ####  \n   ####  \n  ###### \n',
    'n': '### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n# # #  # \n# # #  # \n',
    '6': '         \n         \n         \n         \n # # # # \n # # # # \n# # # #  \n# # # #  \n',
    'k': '# # #  # \n# # #  # \n ## #  # \n### #  # \n### #  # \n### #  # \n### #  # \n### #  # \n',
    's': ' # # # # \n # # # # \n# # # #  \n# # # #  \n##### #  \n # ## #  \n##### #  \n # ## #  \n',
    'h': '### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n## # # # \n # # # # \n',
    '?': ' # # #   \n # ###   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n# # ##   \n',
    'H': '         \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    '}': '#####    \n######   \n  ####   \n  ####   \n   ####  \n   ####  \n   ####  \n  ###### \n',
    'b': '######## \n######## \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n### # #  \n',
    '|': '#####    \n######   \n  ####   \n  ####   \n   ####  \n   ####  \n   ####  \n  ###### \n',
    'W': '         \n ##   ## \n ##   ## \n ## # ## \n ####### \n ### ### \n ##   ## \n         \n',
    'X': '         \n ##  ##  \n ##  ##  \n  ####   \n  ####   \n ##  ##  \n ##  ##  \n         \n',
    'T': '         \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    '~': '#####    \n######   \n  ####   \n  ####   \n   ####  \n   ####  \n   ####  \n  ###### \n',
    '[': '       # \n         \n         \n    ##   \n    ###  \n    #### \n     ### \n      ## \n',
    '!': '#####   \n#####   \n ####   \n #####  \n  ####  \n  ##### \n   #### \n     ## \n',
    'R': '         \n #####   \n ##  ##  \n ##  ##  \n #####   \n ## ##   \n ##  ##  \n         \n',
    '#': '    #### \n    #### \n#   #### \n#   #### \n    #### \n    #### \n    #### \n   ##### \n',
    '0': '## ##### \n## ##### \n##  #### \n##  #### \n#    ### \n#    ### \n      ## \n         \n',
    '=': '# # # \n# # # \n## #  \n## #  \n## #  \n## #  \n## #  \n## #  \n',
    'p': '### # #  \n### # #  \n## # # # \n # # # # \n         \n         \n         \n         \n'}


dic_4x4_offr = {
    '=': '         \n         \n ######  \n         \n ######  \n         \n         \n         \n',
    's': '  ## ##  \n ####### \n ####### \n ####### \n  #####  \n   ###   \n    #    \n         \n',
    'E': ' ######  \n ##      \n ##      \n ####    \n ##      \n ##      \n ######  \n         \n',
    '7': ' ######  \n ##  ##  \n    ##   \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    'N': ' ##  ##  \n ### ##  \n ######  \n ######  \n ## ###  \n ##  ##  \n ##  ##  \n         \n',
    'y': '##  \n##  \n##  \n##  \n##  \n##  \n##  \n##  \n',
    '>': ' ###     \n   ##    \n    ##   \n     ##  \n    ##   \n   ##    \n ###     \n         \n',
    '.': '         \n         \n         \n         \n         \n   ##    \n   ##    \n         \n',
    '_': '         \n   #     \n  ##     \n ####### \n ####### \n  ##     \n   #     \n         \n',
    'f': '         \n         \n         \n         \n######## \n######## \n         \n         \n',
    'H': ' ##  ##  \n ##  ##  \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    'z': '    #    \n   ###   \n  #####  \n ####### \n  #####  \n   ###   \n    #    \n         \n',
    'I': '  ####   \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n  ####   \n         \n',
    'T': ' ######  \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n   ##    \n         \n',
    'r': '         \n         \n         \n         \n         \n######## \n######## \n         \n',
    'c': '         \n         \n         \n######## \n######## \n         \n         \n         \n',
    'U': ' ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '1': '   ##    \n   ##    \n  ###    \n   ##    \n   ##    \n   ##    \n ######  \n         \n',
    ']': '  ####   \n    ##   \n    ##   \n    ##   \n    ##   \n    ##   \n  ####   \n         \n',
    'G': '  ####   \n ##  ##  \n ##      \n ## ###  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    'R': ' #####   \n ##  ##  \n ##  ##  \n #####   \n ####    \n ## ##   \n ##  ##  \n         \n',
    'V': ' ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n         \n',
    'X': ' ##  ##  \n ##  ##  \n  ####   \n   ##    \n  ####   \n ##  ##  \n ##  ##  \n         \n',
    '!': '   ##    \n   ##    \n   ##    \n   ##    \n         \n         \n   ##    \n         \n',
    'u': '         \n         \n         \n     ### \n    #### \n   ###   \n   ##    \n   ##    \n',
    ',': '         \n         \n         \n         \n         \n   ##    \n   ##    \n  ##     \n',
    '@': '         \n         \n         \n######## \n######## \n         \n         \n         \n',
    'J': '   ####  \n    ##   \n    ##   \n    ##   \n    ##   \n ## ##   \n  ###    \n         \n',
    'Y': ' ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n   ##    \n   ##    \n   ##    \n         \n',
    'q': '         \n  ####   \n ######  \n ######  \n ######  \n ######  \n  ####   \n         \n',
    'w': '         \n  ####   \n ######  \n ##  ##  \n ##  ##  \n ######  \n  ####   \n         \n',
    '\\': '    ##   \n   #  #  \n  ##     \n #####   \n  ##     \n ##   #  \n######   \n         \n',
    '|': '  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n ##   #  \n  ####   \n         \n',
    'P': ' #####   \n ##  ##  \n ##  ##  \n #####   \n ##      \n ##      \n ##      \n         \n',
    'x': '   ##    \n   ##    \n ##  ##  \n ##  ##  \n   ##    \n   ##    \n  ####   \n         \n',
    'C': '  ####   \n ##  ##  \n ##      \n ##      \n ##      \n ##  ##  \n  ####   \n         \n',
    '^': '         \n   ##    \n  ####   \n ######  \n   ##    \n   ##    \n   ##    \n   ##    \n',
    '4': '     ##  \n    ###  \n   ####  \n ##  ##  \n ####### \n     ##  \n     ##  \n         \n',
    '(': '    ##   \n   ##    \n  ##     \n  ##     \n  ##     \n   ##    \n    ##   \n         \n',
    '~': '  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n ##   #  \n  ####   \n         \n',
    '#': ' ##  ##  \n ##  ##  \n######## \n ##  ##  \n######## \n ##  ##  \n ##  ##  \n         \n',
    '/': '         \n      ## \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n         \n',
    'k': '   ##    \n   ##    \n  ###    \n####     \n###      \n         \n         \n         \n',
    '8': '  ####   \n ##  ##  \n ##  ##  \n  ####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '"': ' ##  ##  \n ##  ##  \n ##  ##  \n         \n         \n         \n         \n         \n',
    'A': '   ##    \n  ####   \n ##  ##  \n ######  \n ##  ##  \n ##  ##  \n ##  ##  \n         \n',
    ':': '         \n         \n   ##    \n         \n         \n   ##    \n         \n         \n',
    '*': '         \n ##  ##  \n  ####   \n######## \n  ####   \n ##  ##  \n         \n         \n',
    'g': '##     \n##     \n##     \n##     \n##     \n##     \n##     \n##     \n',
    ' ': '  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n ##   #  \n  ####   \n         \n',
    'n': '      ## \n     ### \n    ###  \n   ###   \n  ###    \n ###     \n###      \n##       \n',
    'L': ' ##      \n ##      \n ##      \n ##      \n ##      \n ##      \n ######  \n         \n',
    '{': '  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n ##   #  \n  ####   \n         \n',
    'K': ' ##  ##  \n ## ##   \n ####    \n ###     \n ####    \n ## ##   \n ##  ##  \n         \n',
    '`': '  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n ##   #  \n  ####   \n         \n',
    'S': '  ####   \n ##  ##  \n ##      \n  ####   \n     ##  \n ##  ##  \n  ####   \n         \n',
    '0': '  ####   \n ##  ##  \n ## ###  \n ### ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '}': '  ####   \n ##  ##  \n ## ###  \n ## ###  \n ##      \n ##   #  \n  ####   \n         \n',
    'a': '    #    \n   ###   \n  #####  \n ####### \n ####### \n   ###   \n  #####  \n         \n',
    'B': ' #####   \n ##  ##  \n ##  ##  \n #####   \n ##  ##  \n ##  ##  \n #####   \n         \n',
    'd': '         \n         \n######## \n######## \n         \n         \n         \n         \n',
    '2': '  ####   \n ##  ##  \n     ##  \n    ##   \n  ##     \n ##      \n ######  \n         \n',
    '[': '  ####   \n  ##     \n  ##     \n  ##     \n  ##     \n  ##     \n  ####   \n         \n',
    'Q': '  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n    ###  \n         \n',
    'm': '##       \n###      \n ###     \n  ###    \n   ###   \n    ###  \n     ### \n      ## \n',
    'M': ' ##   ## \n ### ### \n ####### \n ## # ## \n ##   ## \n ##   ## \n ##   ## \n         \n',
    'h': '##   \n##   \n##   \n##   \n##   \n##   \n##   \n##   \n',
    'F': ' ######  \n ##      \n ##      \n ####    \n ##      \n ##      \n ##      \n         \n',
    '-': '         \n         \n         \n ######  \n         \n         \n         \n         \n',
    'Z': ' ######  \n     ##  \n    ##   \n   ##    \n  ##     \n ##      \n ######  \n         \n',
    't': '##      \n##      \n##      \n##      \n##      \n##      \n##      \n##      \n',
    '9': '  ####   \n ##  ##  \n ##  ##  \n  #####  \n     ##  \n ##  ##  \n  ####   \n         \n',
    'O': '  ####   \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '<': '    ###  \n   ##    \n  ##     \n ##      \n  ##     \n   ##    \n    ###  \n         \n',
    ';': '         \n         \n   ##    \n         \n         \n   ##    \n   ##    \n  ##     \n',
    ')': '  ##     \n   ##    \n    ##   \n    ##   \n    ##   \n   ##    \n  ##     \n         \n',
    '6': '  ####   \n ##  ##  \n ##      \n #####   \n ##  ##  \n ##  ##  \n  ####   \n         \n',
    '3': '  ####   \n ##  ##  \n     ##  \n   ###   \n     ##  \n ##  ##  \n  ####   \n         \n',
    'W': ' ##   ## \n ##   ## \n ##   ## \n ## # ## \n ####### \n ### ### \n ##   ## \n         \n',
    'e': '         \n######## \n######## \n         \n         \n         \n         \n         \n',
    '$': '   ##    \n  #####  \n ##      \n  ####   \n     ##  \n #####   \n   ##    \n         \n',
    '+': '         \n   ##    \n   ##    \n ######  \n   ##    \n   ##    \n         \n         \n',
    '?': '  ####   \n ##  ##  \n     ##  \n    ##   \n   ##    \n         \n   ##    \n         \n',
    'v': '##    ## \n###  ### \n ######  \n  ####   \n  ####   \n ######  \n###  ### \n##    ## \n',
    "'": '     ##  \n    ##   \n   ##    \n         \n         \n         \n         \n         \n',
    '5': ' ######  \n ##      \n #####   \n     ##  \n     ##  \n ##  ##  \n  ####   \n         \n',
    'p': '######## \n######## \n      ## \n      ## \n      ## \n      ## \n      ## \n      ## \n',
    'b': '##    \n##    \n##    \n##    \n##    \n##    \n##    \n##    \n',
    'l': '##       \n##       \n##       \n##       \n##       \n##       \n######## \n######## \n',
    '&': '  ####   \n ##  ##  \n  ####   \n  ###    \n ##  ### \n ##  ##  \n  ###### \n         \n',
    'j': '   ##    \n   ##    \n   ###   \n    #### \n     ### \n         \n         \n         \n',
    'D': ' ####    \n ## ##   \n ##  ##  \n ##  ##  \n ##  ##  \n ## ##   \n ####    \n         \n',
    'o': '######## \n######## \n##       \n##       \n##       \n##       \n##       \n##       \n',
    '%': ' ##   #  \n ##  ##  \n    ##   \n   ##    \n  ##     \n ##  ##  \n #   ##  \n         \n',
    'i': '         \n         \n         \n###      \n####     \n  ###    \n   ##    \n   ##    \n'}

dic_5x7 = {
    '=': '      \n      \n####  \n      \n####  \n      \n      \n',
    's': '       \n       \n ###   \n##     \n  ##   \n###    \n       \n',
    'E': '####  \n#     \n###   \n#     \n#     '
    '\n####  \n      \n',
    '7': '####  \n   #  \n  #   \n  #   \n #    \n #    \n      \n',
    'N': '#  #  \n## #  \n## #  \n# ##  \n# ##  \n#  #  \n      \n',
    'y': '      \n      \n#  #  \n#  #  \n # #  \n  #   \n #    \n',
    '>': '      \n#     \n #    \n  #   \n #    \n#     \n      \n',
    '.': '      \n      \n      \n      \n ##   \n ##   \n      \n',
    '_': '      \n      \n      \n      \n      \n####  \n      \n',
    'f': '  #   \n # #  \n #    \n###   \n #    \n #    \n      \n',
    'H': '#  #  \n#  #  \n####  \n#  #  \n#  #  \n#  #  \n      \n',
    'z': '      \n      \n####  \n  #   \n #    \n####  \n      \n',
    'I': '###   \n #    \n #    \n #    \n #    \n###   \n      \n',
    'T': '###   \n #    \n #    \n #    \n #    \n #    \n      \n',
    'r': '      \n      \n###   \n#  #  \n#     \n#     \n      \n',
    'c': '      \n      \n ##   \n#     \n#     \n ##   \n      \n',
    'U': '#  #  \n#  #  \n#  #  \n#  #  \n#  #  \n ##   \n      \n',
    '1': ' #    \n##    \n #    \n #    \n #    \n###   \n      \n',
    ']': '###   \n  #   \n  #   \n  #   \n  #   \n###   \n      \n',
    'G': ' ##   \n#  #  \n#     \n# ##  \n#  #  \n ###  \n      \n',
    'R': '###   \n#  #  \n#  #  \n###   \n# #   \n#  #  \n      \n',
    'V': '#  #  \n#  #  \n#  #  \n#  #  \n ##   \n ##   \n      \n',
    'X': '#  #  \n#  #  \n ##   \n ##   \n#  #  \n#  #  \n      \n',
    '!': '  #   \n  #   \n  #   \n  #   \n      \n  #   \n      \n',
    'u': '      \n      \n#  #  \n#  #  \n#  #  \n ###  \n      \n',
    ',': '      \n      \n      \n      \n ##   \n #    \n#     \n',
    '@': ' ##   \n#  #  \n# ##  \n# ##  \n#     \n ##   \n      \n',
    'J': '   #  \n   #  \n   #  \n   #  \n#  #  \n ##   \n      \n',
    'Y': '# #   \n# #   \n# #   \n #    \n #    \n #    \n      \n',
    'q': '      \n      \n ###  \n#  #  \n#  #  \n ###  \n   #  \n',
    'w': '      \n      \n#  #  \n#  #  \n####  \n####  \n      \n',
    '\\': '      \n#     \n #    \n  #   \n   #  \n      \n      \n',
    '|': ' #    \n #    \n #    \n #    \n #    \n #    \n      \n',
    'P': '###   \n#  #  \n#  #  \n###   \n#     \n#     \n      \n',
    'x': '      \n      \n#  #  \n ##   \n ##   \n#  #  \n      \n',
    'C': ' ##   \n#  #  \n#     \n#     \n#  #  \n ##   \n      \n',
    '^': ' #    \n# #   \n      \n      \n      \n      \n      \n',
    '4': '  #   \n ##   \n# #   \n####  \n  #   \n  #   \n      \n',
    '(': '  #   \n #    \n #    \n #    \n #    \n  #   \n      \n',
    '~': ' # #  \n# #   \n      \n      \n      \n      \n      \n',
    '#': '      \n # #  \n##### \n # #  \n##### \n # #  \n      \n',
    '/': '      \n   #  \n  #   \n #    \n#     \n      \n      \n',
    'k': '#     \n#     \n# #   \n##    \n# #   \n#  #  \n      \n',
    '8': ' ##   \n#  #  \n ##   \n#  #  \n#  #  \n ##   \n      \n',
    '"': ' # #  \n # #  \n # #  \n      \n      \n      \n      \n',
    'A': ' ##   \n#  #  \n#  #  \n####  \n#  #  \n#  #  \n      \n',
    ':': '      \n ##   \n ##   \n      \n ##   \n ##   \n      \n',
    '*': '      \n# #   \n #    \n###   \n #    \n# #   \n      \n',
    'g': '      \n      \n ###  \n#  #  \n ##   \n#     \n ###  \n',
    ' ': '      \n      \n      \n      \n      \n      \n      \n',
    'n': '      \n      \n###   \n#  #  \n#  #  \n#  #  \n      \n',
    'L': '#     \n#     \n#     \n#     \n#     \n####  \n      \n',
    '{': '  #   \n #    \n##    \n #    \n #    \n  #   \n      \n',
    'K': '#  #  \n# #   \n##    \n##    \n# #   \n#  #  \n      \n',
    '`': '##    \n #    \n  #   \n      \n      \n      \n      \n',
    'S': ' ##   \n#  #  \n #    \n  #   \n#  #  \n ##   \n      \n',
    '0': ' #    \n# #   \n# #   \n# #   \n# #   \n #    \n      \n',
    '}': '#      \n #     \n ##    \n #     \n #     \n#      \n       \n',
    'a': '      \n      \n ###  \n#  #  \n# ##  \n # #  \n      \n',
    'B': '###   \n#  #  \n###   \n#  #  \n#  #  \n###   \n      \n',
    'd': '   #  \n   #  \n ###  \n#  #  \n#  #  \n ###  \n      \n',
    '2': ' ##   \n#  #  \n   #  \n  #   \n #    \n####  \n      \n',
    '[': '###   \n#     \n#     \n#     \n#     \n###   \n      \n',
    'Q': ' ##   \n#  #  \n#  #  \n#  #  \n## #  \n ##   \n   #  \n',
    'm': '      \n      \n# #   \n####  \n#  #  \n#  #  \n      \n',
    'M': '#  #  \n####  \n####  \n#  #  \n#  #  \n#  #  \n      \n',
    'h': '#     \n#     \n###   \n#  #  \n#  #  \n#  #  \n      \n',
    'F': '####  \n#     \n###   \n#     \n#     \n#     \n      \n',
    '-': '      \n      \n      \n####  \n      \n      \n      \n',
    'Z': '####  \n   #  \n  #   \n #    \n#     \n####  \n      \n',
    't': ' #    \n #    \n###   \n #    \n #    \n  ##  \n      \n',
    '9': ' ##   \n#  #  \n#  #  \n ###  \n   #  \n ##   \n      \n',
    'O': ' ##   \n#  #  \n#  #  \n#  #  \n#  #  \n ##   \n      \n',
    '<': '      \n  #   \n #    \n#     \n #    \n  #   \n      \n',
    ';': '      \n ##   \n ##   \n      \n ##   \n #    \n#     \n',
    ')': ' #    \n  #   \n  #   \n  #   \n  #   \n #    \n      \n',
    '6': ' ##   \n#     \n###   \n#  #  \n#  #  \n ##   \n      \n',
    '3': '####  \n   #  \n ##   \n   #  \n#  #  \n ##   \n      \n',
    'W': '#  #  \n#  #  \n#  #  \n####  \n####  \n#  #  \n      \n',
    'e': '      \n      \n ##   \n# ##  \n##    \n ##   \n      \n',
    '$': '      \n ###  \n# #   \n ###  \n  # # \n ###  \n      \n',
    '+': '      \n  #   \n  #   \n##### \n  #   \n  #   \n      \n',
    '?': ' #    \n# #   \n  #   \n #    \n      \n #    \n      \n',
    'v': '      \n      \n# #   \n# #   \n# #   \n #    \n      \n',
    "'": ' ##   \n #    \n#     \n      \n      \n      \n      \n',
    '5': '####  \n#     \n###   \n   #  \n#  #  \n ##   \n      \n',
    'p': '      \n      \n###   \n#  #  \n#  #  \n###   \n#     \n',
    'b': '#     \n#     \n###   \n#  #  \n#  #  \n###   \n      \n',
    'l': '##    \n #    \n #    \n #    \n #    \n###   \n      \n',
    '&': '      \n #    \n# #   \n #    \n# #   \n # #  \n      \n',
    'j': '  #   \n      \n  #   \n  #   \n  #   \n# #   \n #    \n',
    'D': '###   \n#  #  \n#  #  \n#  #  \n#  #  \n###   \n      \n',
    'o': '      \n      \n ##   \n#  #  \n#  #  \n ##   \n      \n',
    '%': '#     \n#  #  \n  #   \n #    \n#  #  \n   #  \n      \n',
    'i': ' #    \n      \n##    \n #    \n #    \n###   \n      \n'}

dic_5x8 = {
    '=': '  ##  \n      \n      \n      \n  ##  \n  ##  \n      \n  ##  \n',
    's': ' ###  \n      \n      \n      \n   #  \n      \n   #  \n   #  \n',
    'E': '  ##  \n      \n      \n  ##  \n #  # \n #  # \n #### \n #  # \n',
    '7': ' # #  \n #### \n   #  \n   #  \n      \n      \n      \n #### \n',
    'N': '      \n      \n      \n ###  \n  #   \n  #   \n  #   \n  #   \n',
    'y': '      \n      \n      \n  ##  \n #  # \n #  # \n  ##  \n      \n',
    '>': '  ##  \n      \n      \n      \n      \n  ##  \n  ##  \n      \n',
    '.': '      \n  ##  \n  #   \n #    \n      \n      \n      \n      \n',
    '_': '      \n      \n #  # \n #  # \n  ##  \n  ##  \n #  # \n #  # \n',
    'f': '  #   \n # #  \n # #  \n      \n      \n      \n      \n      \n',
    'H': ' #    \n #  # \n  ##  \n      \n      \n      \n ###  \n #  # \n',
    'z': '      \n      \n      \n      \n ###  \n #  # \n ###  \n #    \n',
    'I': ' #  # \n #  # \n #  # \n ###  \n      \n      \n      \n #### \n',
    'T': ' #  # \n ## # \n #### \n # ## \n # ## \n #  # \n      \n      \n',
    'r': '      \n      \n      \n  #   \n      \n ##   \n  #   \n  #   \n',
    'c': ' #    \n #    \n ###  \n      \n      \n      \n #    \n #    \n',
    'U': '      \n  ##  \n #  # \n #  # \n #  # \n #  # \n  ##  \n      \n',
    '1': '      \n    # \n    # \n   #  \n  #   \n #    \n #    \n      \n',
    ']': ' #  # \n #  # \n #  # \n #  # \n  ##  \n  ##  \n      \n      \n',
    'G': ' #  # \n ###  \n      \n      \n      \n  ##  \n #  # \n #    \n',
    'R': ' #    \n #    \n #    \n ###  \n      \n      \n      \n #  # \n',
    'V': '      \n      \n ###  \n #  # \n #  # \n ###  \n #    \n #    \n',
    'X': '  ##  \n    # \n      \n      \n ###  \n #  # \n #  # \n ###  \n',
    '!': '      \n      \n      \n  #   \n  #   \n  #   \n  #   \n      \n',
    'u': ' ###  \n #  # \n #  # \n      \n      \n      \n ##   \n  #   \n',
    ',': ' #  # \n      \n      \n      \n      \n  #   \n  #   \n##### \n',
    '@': ' #    \n #    \n  #   \n   #  \n      \n      \n      \n      \n',
    'J': ' #    \n ###  \n #    \n #    \n #### \n      \n      \n      \n',
    'Y': ' # ## \n #  # \n      \n      \n      \n  ##  \n #  # \n  #   \n',
    'q': '      \n      \n #    \n #    \n ###  \n #  # \n #  # \n #  # \n',
    'w': '      \n # #  \n# # # \n# # # \n#   # \n      \n      \n      \n',
    '\\': ' #  # \n #  # \n #  # \n #  # \n  ##  \n      \n      \n      \n',
    '|': '    # \n    # \n      \n      \n      \n      \n # #  \n ## # \n',
    'P': ' #  # \n  ##  \n      \n      \n      \n #  # \n # #  \n ##   \n',
    'x': '      \n      \n ###  \n #  # \n #  # \n #  # \n      \n      \n',
    'C': '      \n  #   \n # #  \n   #  \n  #   \n      \n  #   \n      \n',
    '^': '      \n #  # \n #  # \n #  # \n #### \n #### \n #  # \n      \n',
    '4': ' ###  \n      \n      \n      \n  ##  \n #  # \n    # \n  ##  \n',
    '(': '      \n  ##  \n  #   \n #    \n      \n      \n      \n      \n',
    '~': ' ##   \n   #  \n ###  \n      \n      \n      \n  #   \n  #   \n',
    '#': '      \n      \n      \n      \n # #  \n # #  \n##### \n # #  \n',
    '/': '      \n      \n #### \n      \n      \n      \n      \n      \n',
    'k': ' #  # \n ###  \n      \n      \n      \n      \n      \n  ##  \n',
    '8': ' #    \n ###  \n    # \n #  # \n  ##  \n      \n      \n      \n',
    '"': '  #   \n      \n      \n      \n # #  \n # #  \n # #  \n      \n',
    'A': ' ###  \n      \n ###  \n      \n      \n      \n      \n      \n',
    ':': '      \n #### \n    # \n   #  \n   #  \n  #   \n  #   \n      \n',
    '*': '      \n      \n      \n #    \n  #   \n  #   \n  #   \n #    \n',
    'g': '      \n      \n      \n      \n      \n      \n      \n #### \n',
    ' ': '      \n      \n      \n      \n      \n      \n      \n      \n',
    'n': '      \n  ##  \n #### \n #    \n  ##  \n      \n      \n      \n',
    'L': '      \n  ##  \n #  # \n #    \n # ## \n #  # \n  ##  \n      \n',
    '{': ' #    \n      \n      \n      \n      \n  ### \n #  # \n  ### \n',
    'K': ' #### \n #    \n ###  \n #    \n #    \n #    \n      \n      \n',
    '`': '      \n      \n      \n#   # \n#   # \n # #  \n  #   \n  #   \n',
    'S': ' #### \n #### \n #  # \n #  # \n #  # \n      \n      \n      \n',
    '0': '      \n      \n      \n  #   \n ###  \n  #   \n      \n      \n',
    '}': ' #    \n #    \n      \n      \n      \n      \n      \n ###  \n',
    'a': '  #   \n      \n      \n      \n #### \n    # \n   #  \n  #   \n',
    'B': ' #    \n  #   \n   #  \n   #  \n  #   \n #    \n      \n      \n',
    'd': '  #   \n   #  \n    # \n    # \n      \n      \n      \n ###  \n',
    '2': '      \n      \n  #   \n # #  \n # #  \n # #  \n # #  \n  #   \n',
    '[': '  #   \n  #   \n  #   \n  #   \n      \n      \n      \n #  # \n',
    'Q': ' # #  \n # #  \n #  # \n      \n      \n      \n #    \n #    \n',
    'm': '  # # \n # ## \n # ## \n  # # \n      \n      \n      \n      \n',
    'M': '      \n      \n #  # \n #  # \n #### \n #  # \n #  # \n #  # \n',
    'h': '      \n      \n ##   \n #    \n  #   \n      \n      \n      \n',
    'F': ' #  # \n      \n      \n      \n ###  \n #  # \n ###  \n #  # \n',
    '-': '  #   \n  #   \n      \n      \n      \n      \n      \n      \n',
    'Z': '   #  \n #  # \n  ##  \n      \n      \n      \n##### \n  #   \n',
    't': '   #  \n # #  \n  #   \n      \n      \n #    \n #    \n #  # \n',
    '9': '  ##  \n #    \n # #  \n ## # \n #  # \n  ##  \n      \n      \n',
    'O': ' ###  \n      \n      \n      \n  ### \n    # \n    # \n    # \n',
    '<': '      \n      \n      \n  ##  \n #  # \n # ## \n  # # \n    # \n',
    ';': '      \n      \n  ##  \n #  # \n  ##  \n #  # \n #  # \n  ##  \n',
    ')': '      \n      \n   #  \n  #   \n  #   \n  #   \n   #  \n      \n',
    '6': '    # \n #  # \n  ##  \n      \n      \n      \n   #  \n  ##  \n',
    '3': '      \n      \n      \n  #   \n ##   \n  #   \n  #   \n  #   \n',
    'W': '      \n      \n      \n  ##  \n #  # \n #  # \n ## # \n # ## \n',
    'e': '   #  \n   #  \n   #  \n   #  \n ###  \n      \n      \n      \n',
    '$': '##### \n # #  \n # #  \n      \n      \n  #   \n ###  \n# #   \n',
    '+': '      \n      \n      \n      \n #  # \n  ##  \n #### \n  ##  \n',
    '?': '  ##  \n  #   \n #    \n      \n      \n      \n   #  \n  #   \n',
    'v': '  #   \n  #   \n  #   \n ###  \n      \n      \n      \n      \n',
    "'": ' # #  \n # #  \n  #   \n # #  \n # #  \n  # # \n      \n      \n',
    '5': ' #    \n #### \n      \n      \n      \n  ##  \n #  # \n   #  \n',
    'p': '      \n      \n      \n  ##  \n #  # \n  ### \n    # \n  ##  \n',
    'b': ' #    \n #### \n      \n      \n      \n ###  \n #    \n #    \n',
    'l': ' #    \n #    \n  ##  \n      \n      \n      \n    # \n    # \n',
    '&': ' # #  \n  #   \n # #  \n   #  \n      \n      \n      \n  #   \n',
    'j': '  # # \n      \n      \n      \n #    \n #    \n ###  \n #  # \n',
    'D': '      \n  ##  \n #  # \n#  ## \n# # # \n# # # \n#  #  \n #    \n',
    'o': '   #  \n  # # \n  #   \n ###  \n  #   \n  #   \n      \n      \n',
    '%': ' ###  \n  # # \n ###  \n  #   \n      \n      \n      \n #    \n',
    'i': '      \n      \n      \n      \n      \n  # # \n # ## \n # ## \n'}

dic_6x9 = {
    '=': '       \n       \n       \n ##### \n       \n ##### \n       \n       \n       \n',
    's': '       \n       \n       \n ####  \n ##    \n   ##  \n ####  \n       \n       \n',
    'E': '       \n ####  \n #     \n ###   \n #     \n #     \n ####  \n       \n       \n',
    '7': '       \n ####  \n #  #  \n    #  \n   ##  \n  ##   \n  #    \n       \n       \n',
    'N': '       \n #  #  \n ## #  \n # ##  \n #  #  \n #  #  \n #  #  \n       \n       \n',
    'y': '       \n       \n       \n #  #  \n #  #  \n ## #  \n   ##  \n #  #  \n  ##   \n',
    '>': '       \n       \n ##    \n   ##  \n     # \n   ##  \n ##    \n       \n       \n',
    '.': '       \n       \n       \n       \n       \n  ##   \n  ##   \n       \n       \n',
    '_': '       \n       \n       \n       \n       \n       \n       \n       \n ##### \n',
    'f': '   #   \n  ###  \n  #    \n ###   \n  #    \n  #    \n  #    \n       \n       \n',
    'H': '       \n #  #  \n #  #  \n ####  \n #  #  \n #  #  \n #  #  \n       \n       \n',
    'z': '       \n       \n       \n ####  \n   ##  \n ##    \n ####  \n       \n       \n',
    'I': '       \n ###   \n  #    \n  #    \n  #    \n  #    \n ###   \n       \n       \n',
    'T': '       \n ##### \n   #   \n   #   \n   #   \n   #   \n   #   \n       \n       \n',
    'r': '       \n       \n       \n # #   \n ## #  \n #     \n #     \n       \n       \n',
    'c': '       \n       \n       \n  ###  \n #     \n #     \n  ###  \n       \n       \n',
    'U': '       \n #  #  \n #  #  \n #  #  \n #  #  \n #  #  \n  ##   \n       \n       \n',
    '1': '       \n  #    \n ##    \n  #    \n  #    \n  #    \n ###   \n       \n       \n',
    ']': '       \n ###   \n   #   \n   #   \n   #   \n   #   \n ###   \n       \n       \n',
    'G': '       \n  ##   \n #  #  \n #     \n # ##  \n #  #  \n  ##   \n       \n       \n',
    'R': '       \n ###   \n #  #  \n #  #  \n ###   \n #  #  \n #  #  \n       \n       \n',
    'V': '       \n #  #  \n #  #  \n #  #  \n ####  \n  ##   \n  ##   \n       \n       \n',
    'X': '       \n #   # \n  # #  \n   #   \n  # #  \n  # #  \n #   # \n       \n       \n',
    '!': '       \n   #   \n   #   \n   #   \n   #   \n       \n   #   \n       \n       \n',
    'u': '       \n       \n       \n #  #  \n #  #  \n #  #  \n  ###  \n       \n       \n',
    ',': '       \n       \n       \n       \n       \n  ##   \n   #   \n   #   \n  #    \n',
    '@': '       \n  ###  \n #  #  \n # # # \n # ##  \n #     \n  ###  \n       \n       \n',
    'J': '       \n  ###  \n    #  \n    #  \n    #  \n #  #  \n  ###  \n       \n       \n',
    'Y': '       \n #   # \n #   # \n  # #  \n   #   \n   #   \n   #   \n       \n       \n',
    'q': '       \n       \n       \n  ###  \n #  #  \n #  #  \n  ###  \n    #  \n    #  \n',
    'w': '       \n       \n       \n #   # \n # # # \n # # # \n  # #  \n       \n       \n',
    '\\': '       \n #     \n #     \n  #    \n   #   \n    #  \n    #  \n       \n       \n',
    '|': '       \n  #    \n  #    \n  #    \n       \n  #    \n  #    \n  #    \n       \n',
    'P': '       \n ###   \n #  #  \n #  #  \n ###   \n #     \n #     \n       \n       \n',
    'x': '       \n       \n       \n #  #  \n  ##   \n  ##   \n #  #  \n       \n       \n',
    'C': '       \n  ##   \n #  #  \n #     \n #     \n #  #  \n  ##   \n       \n       \n',
    '^': '       \n   #   \n  # #  \n #   # \n       \n       \n       \n       \n       \n',
    '4': '       \n   ##  \n  # #  \n #  #  \n ##### \n    #  \n    #  \n       \n       \n',
    '(': '       \n   #   \n  #    \n  #    \n  #    \n  #    \n  #    \n   #   \n       \n',
    '~': '       \n       \n  # #  \n # #   \n       \n       \n       \n       \n       \n',
    '#': '       \n  # #  \n  # #  \n ##### \n  # #  \n ##### \n  # #  \n  # #  \n       \n',
    '/': '       \n    #  \n    #  \n   #   \n  #    \n #     \n #     \n       \n       \n',
    'k': ' #     \n #     \n #  #  \n # #   \n ###   \n #  #  \n #  #  \n       \n       \n',
    '8': '       \n  ##   \n #  #  \n  ##   \n #  #  \n #  #  \n  ##   \n       \n       \n',
    '"': '       \n  # #  \n  # #  \n  # #  \n       \n       \n       \n       \n       \n',
    'A': '       \n   #   \n  # #  \n #   # \n ##### \n #   # \n #   # \n       \n       \n',
    ':': '       \n       \n  ##   \n  ##   \n       \n  ##   \n  ##   \n       \n       \n',
    '*': '       \n       \n #   # \n  # #  \n ##### \n  # #  \n #   # \n       \n       \n',
    'g': '       \n       \n       \n  ##   \n #  #  \n # ##  \n  # #  \n    #  \n  ##   \n',
    ' ': '       \n       \n       \n       \n       \n       \n       \n       \n       \n',
    'n': '       \n       \n       \n ###   \n #  #  \n #  #  \n #  #  \n       \n       \n',
    'L': '       \n #     \n #     \n #     \n #     \n #     \n ####  \n       \n       \n',
    '{': '   #   \n  #    \n  #    \n ##    \n  #    \n  #    \n   #   \n       \n       \n',
    'K': '       \n #  #  \n # #   \n ##    \n # #   \n #  #  \n #  #  \n       \n       \n',
    '`': '       \n  ##   \n  #    \n  #    \n   #   \n       \n       \n       \n       \n',
    'S': '       \n  ##   \n #  #  \n  #    \n   #   \n #  #  \n  ##   \n       \n       \n',
    '0': '       \n  ##   \n #  #  \n # ##  \n ## #  \n #  #  \n  ##   \n       \n       \n',
    '}': ' #     \n  #    \n  #    \n  ##   \n  #    \n  #    \n #     \n       \n       \n',
    'a': '       \n       \n       \n  ###  \n #  #  \n #  #  \n  #### \n       \n       \n',
    'B': '       \n ####  \n #   # \n ####  \n #   # \n #   # \n ####  \n       \n       \n',
    'd': '    #  \n    #  \n    #  \n  ###  \n #  #  \n #  #  \n  ###  \n       \n       \n',
    '2': '       \n  ##   \n #  #  \n    #  \n  ##   \n #     \n ####  \n       \n       \n',
    '[': '       \n ###   \n #     \n #     \n #     \n #     \n ###   \n       \n       \n',
    'Q': '       \n  ##   \n #  #  \n #  #  \n ## #  \n # ##  \n  ##   \n    #  \n       \n',
    'm': '       \n       \n       \n ## #  \n # # # \n # # # \n #   # \n       \n       \n',
    'M': '       \n #   # \n ## ## \n # # # \n # # # \n #   # \n #   # \n       \n       \n',
    'h': ' #     \n #     \n #     \n # #   \n ## #  \n #  #  \n #  #  \n       \n       \n',
    'F': '       \n ####  \n #     \n ###   \n #     \n #     \n #     \n       \n       \n',
    '-': '       \n       \n       \n       \n ##### \n       \n       \n       \n       \n',
    'Z': '       \n ####  \n    #  \n   #   \n  #    \n #     \n ####  \n       \n       \n',
    't': '  #    \n  #    \n ###   \n  #    \n  # #  \n  # #  \n   #   \n       \n       \n',
    '9': '       \n  ##   \n #  #  \n # ##  \n  # #  \n    #  \n  ##   \n       \n       \n',
    'O': '       \n  ##   \n #  #  \n #  #  \n #  #  \n #  #  \n  ##   \n       \n       \n',
    '<': '       \n       \n    ## \n  ##   \n #     \n  ##   \n    ## \n       \n       \n',
    ';': '       \n       \n  ##   \n  ##   \n       \n  ##   \n   #   \n   #   \n  #    \n',
    ')': '       \n  #    \n   #   \n   #   \n   #   \n   #   \n   #   \n  #    \n       \n',
    '6': '       \n  ##   \n #     \n # #   \n ## #  \n #  #  \n  ##   \n       \n       \n',
    '3': '       \n ####  \n    #  \n  ###  \n    #  \n    #  \n ####  \n       \n       \n',
    'W': '       \n #   # \n #   # \n # # # \n # # # \n ## ## \n #   # \n       \n       \n',
    'e': '       \n       \n       \n  ##   \n # ##  \n ##    \n  ###  \n       \n       \n',
    '$': '   #   \n  ###  \n # # # \n # #   \n  ###  \n   # # \n # # # \n  ###  \n   #   \n',
    '+': '       \n       \n   #   \n   #   \n ##### \n   #   \n   #   \n       \n       \n',
    '?': '  ##   \n #  #  \n    #  \n  ##   \n  #    \n       \n  #    \n       \n       \n',
    'v': '       \n       \n       \n #  #  \n #  #  \n  ##   \n  ##   \n       \n       \n',
    "'": '       \n  ##   \n   #   \n   #   \n  #    \n       \n       \n       \n       \n',
    '5': '       \n ####  \n #     \n # #   \n ## #  \n    #  \n ####  \n       \n       \n',
    'p': '       \n       \n       \n ###   \n #  #  \n #  #  \n ###   \n #     \n #     \n',
    'b': ' #     \n #     \n #     \n ###   \n #  #  \n #  #  \n ###   \n       \n       \n',
    'l': '       \n  ##   \n   #   \n   #   \n   #   \n   #   \n  ###  \n       \n       \n',
    '&': '       \n  ##   \n #  #  \n #  #  \n  ##   \n #  ## \n #  #  \n  ## # \n       \n',
    'j': '       \n   #   \n       \n  ##   \n   #   \n   #   \n   #   \n ###   \n  #    \n',
    'D': '       \n ###   \n #  #  \n #  #  \n #  #  \n #  #  \n ###   \n       \n       \n',
    'o': '       \n       \n       \n  ##   \n #  #  \n #  #  \n  ##   \n       \n       \n',
    '%': ' #     \n# # #  \n #  #  \n   #   \n  #    \n #  #  \n # # # \n    #  \n       \n',
    'i': '       \n   #   \n       \n  ##   \n   #   \n   #   \n  ###  \n       \n       \n'}

dic_6x10 = {
    '=': '       \n       \n       \n ##### \n       \n ##### \n       \n       \n       \n       \n',
    's': '       \n       \n       \n  ###  \n #     \n  ###  \n     # \n ####  \n       \n       \n',
    'E': '       \n ##### \n #     \n #     \n ####  \n #     \n #     \n ##### \n       \n       \n',
    '7': '       \n ##### \n     # \n    #  \n    #  \n   #   \n  #    \n  #    \n       \n       \n',
    'N': '       \n #   # \n #   # \n ##  # \n # # # \n #  ## \n #   # \n #   # \n       \n       \n',
    'y': '       \n       \n       \n #   # \n #   # \n #  ## \n  ## # \n     # \n #   # \n  ###  \n',
    '>': '       \n #     \n  #    \n   #   \n    #  \n   #   \n  #    \n #     \n       \n       \n',
    '.': '       \n       \n       \n       \n       \n       \n   #   \n  ###  \n   #   \n       \n',
    '_': '       \n       \n       \n       \n       \n       \n       \n       \n ##### \n       \n',
    'f': '       \n   ##  \n  #  # \n  #    \n ####  \n  #    \n  #    \n  #    \n       \n       \n',
    'H': '       \n #   # \n #   # \n #   # \n ##### \n #   # \n #   # \n #   # \n       \n       \n',
    'z': '       \n       \n       \n ##### \n    #  \n   #   \n  #    \n ##### \n       \n       \n',
    'I': '       \n  ###  \n   #   \n   #   \n   #   \n   #   \n   #   \n  ###  \n       \n       \n',
    'T': '       \n ##### \n   #   \n   #   \n   #   \n   #   \n   #   \n   #   \n       \n       \n',
    'r': '       \n       \n       \n # ##  \n ##  # \n #     \n #     \n #     \n       \n       \n',
    'c': '       \n       \n       \n  ###  \n #   # \n #     \n #   # \n  ###  \n       \n       \n',
    'U': '       \n #   # \n #   # \n #   # \n #   # \n #   # \n #   # \n  ###  \n       \n       \n',
    '1': '       \n   #   \n  ##   \n # #   \n   #   \n   #   \n   #   \n ##### \n       \n       \n',
    ']': '       \n  ###  \n    #  \n    #  \n    #  \n    #  \n    #  \n  ###  \n       \n       \n',
    'G': '       \n  ###  \n #   # \n #     \n #     \n #  ## \n #   # \n  ###  \n       \n       \n',
    'R': '       \n ####  \n #   # \n #   # \n ####  \n # #   \n #  #  \n #   # \n       \n       \n',
    'V': '       \n #   # \n #   # \n #   # \n  # #  \n  # #  \n  # #  \n   #   \n       \n       \n',
    'X': '       \n #   # \n #   # \n  # #  \n   #   \n  # #  \n #   # \n #   # \n       \n       \n',
    '!': '       \n   #   \n   #   \n   #   \n   #   \n   #   \n       \n   #   \n       \n       \n',
    'u': '       \n       \n       \n #   # \n #   # \n #   # \n #  ## \n  ## # \n       \n       \n',
    ',': '       \n       \n       \n       \n       \n       \n   ##  \n   #   \n  #    \n       \n',
    '@': '       \n  ###  \n #   # \n #  ## \n # # # \n # ##  \n #     \n  ###  \n       \n       \n',
    'J': '       \n   ### \n     # \n     # \n     # \n     # \n #   # \n  ###  \n       \n       \n',
    'Y': '       \n #   # \n #   # \n  # #  \n   #   \n   #   \n   #   \n   #   \n       \n       \n',
    'q': '       \n       \n       \n  ## # \n #  ## \n #  ## \n  ## # \n     # \n     # \n     # \n',
    'w': '       \n       \n       \n #   # \n #   # \n # # # \n # # # \n  # #  \n       \n       \n',
    '\\': '       \n #     \n #     \n  #    \n   #   \n    #  \n     # \n     # \n       \n       \n',
    '|': '       \n   #   \n   #   \n   #   \n   #   \n   #   \n   #   \n   #   \n       \n       \n',
    'P': '       \n ####  \n #   # \n #   # \n ####  \n #     \n #     \n #     \n       \n       \n',
    'x': '       \n       \n       \n #   # \n  # #  \n   #   \n  # #  \n #   # \n       \n       \n',
    'C': '       \n  ###  \n #   # \n #     \n #     \n #     \n #   # \n  ###  \n       \n       \n',
    '^': '       \n   #   \n  # #  \n #   # \n       \n       \n       \n       \n       \n       \n',
    '4': '       \n    #  \n   ##  \n  # #  \n #  #  \n ##### \n    #  \n    #  \n       \n       \n',
    '(': '       \n    #  \n   #   \n  #    \n  #    \n  #    \n   #   \n    #  \n       \n       \n',
    '~': '       \n  #  # \n # # # \n #  #  \n       \n       \n       \n       \n       \n       \n',
    '#': '       \n  # #  \n  # #  \n ##### \n  # #  \n ##### \n  # #  \n  # #  \n       \n       \n',
    '/': '       \n     # \n     # \n    #  \n   #   \n  #    \n #     \n #     \n       \n       \n',
    'k': '       \n #     \n #     \n #   # \n #  #  \n ###   \n #  #  \n #   # \n       \n       \n',
    '8': '       \n  ###  \n #   # \n #   # \n  ###  \n #   # \n #   # \n  ###  \n       \n       \n',
    '"': '       \n  # #  \n  # #  \n  # #  \n       \n       \n       \n       \n       \n       \n',
    'A': '       \n   #   \n  # #  \n #   # \n #   # \n ##### \n #   # \n #   # \n       \n       \n',
    ':': '       \n       \n   #   \n  ###  \n   #   \n       \n   #   \n  ###  \n   #   \n       \n',
    '*': '       \n       \n #   # \n  # #  \n ##### \n  # #  \n #   # \n       \n       \n       \n',
    'g': '       \n       \n       \n  ## # \n #  #  \n  ##   \n #     \n  ###  \n #   # \n  ###  \n',
    ' ': '       \n       \n       \n       \n       \n       \n       \n       \n       \n       \n',
    'n': '       \n       \n       \n # ##  \n ##  # \n #   # \n #   # \n #   # \n       \n       \n',
    'L': '       \n #     \n #     \n #     \n #     \n #     \n #     \n ##### \n       \n       \n',
    '{': '       \n    ## \n   #   \n    #  \n  ##   \n    #  \n   #   \n    ## \n       \n       \n',
    'K': '       \n #   # \n #  #  \n # #   \n ##    \n # #   \n #  #  \n #   # \n       \n       \n',
    '`': '       \n  ##   \n   #   \n    #  \n       \n       \n       \n       \n       \n       \n',
    'S': '       \n  ###  \n #   # \n #     \n  ###  \n     # \n #   # \n  ###  \n       \n       \n',
    '0': '       \n   #   \n  # #  \n #   # \n #   # \n #   # \n  # #  \n   #   \n       \n       \n',
    '}': '       \n ##    \n   #   \n  #    \n   ##  \n  #    \n   #   \n ##    \n       \n       \n',
    'a': '       \n       \n       \n  ###  \n     # \n  #### \n #   # \n  #### \n       \n       \n',
    'B': '       \n ####  \n  #  # \n  #  # \n  ###  \n  #  # \n  #  # \n ####  \n       \n       \n',
    'd': '       \n     # \n     # \n  ## # \n #  ## \n #   # \n #  ## \n  ## # \n       \n       \n',
    '2': '       \n  ###  \n #   # \n     # \n   ##  \n  #    \n #     \n ##### \n       \n       \n',
    '[': '       \n  ###  \n  #    \n  #    \n  #    \n  #    \n  #    \n  ###  \n       \n       \n',
    'Q': '       \n  ###  \n #   # \n #   # \n #   # \n #   # \n # # # \n  ###  \n     # \n       \n',
    'm': '       \n       \n       \n ## #  \n # # # \n # # # \n # # # \n #   # \n       \n       \n',
    'M': '       \n #   # \n #   # \n ## ## \n # # # \n #   # \n #   # \n #   # \n       \n       \n',
    'h': '       \n #     \n #     \n # ##  \n ##  # \n #   # \n #   # \n #   # \n       \n       \n',
    'F': '       \n ##### \n #     \n #     \n ####  \n #     \n #     \n #     \n       \n       \n',
    '-': '       \n       \n       \n       \n ##### \n       \n       \n       \n       \n       \n',
    'Z': '       \n ##### \n     # \n    #  \n   #   \n  #    \n #     \n ##### \n       \n       \n',
    't': '       \n  #    \n  #    \n ####  \n  #    \n  #    \n  #  # \n   ##  \n       \n       \n',
    '9': '       \n  ###  \n #   # \n #  ## \n  ## # \n     # \n    #  \n  ##   \n       \n       \n',
    'O': '       \n  ###  \n #   # \n #   # \n #   # \n #   # \n #   # \n  ###  \n       \n       \n',
    '<': '       \n     # \n    #  \n   #   \n  #    \n   #   \n    #  \n     # \n       \n       \n',
    ';': '       \n       \n   #   \n  ###  \n   #   \n       \n   ##  \n   #   \n  #    \n       \n',
    ')': '       \n  #    \n   #   \n    #  \n    #  \n    #  \n   #   \n  #    \n       \n       \n',
    '6': '       \n   ##  \n  #    \n #     \n # ##  \n ##  # \n #   # \n  ###  \n       \n       \n',
    '3': '       \n ##### \n     # \n    #  \n   ##  \n     # \n #   # \n  ###  \n       \n       \n',
    'W': '       \n #   # \n #   # \n #   # \n # # # \n # # # \n ## ## \n #   # \n       \n       \n',
    'e': '       \n       \n       \n  ###  \n #   # \n ##### \n #     \n  ###  \n       \n       \n',
    '$': '       \n   #   \n  ###  \n # #   \n  ###  \n   # # \n  ###  \n   #   \n       \n       \n',
    '+': '       \n       \n   #   \n   #   \n ##### \n   #   \n   #   \n       \n       \n       \n',
    '?': '       \n  ###  \n #   # \n    #  \n   #   \n   #   \n       \n   #   \n       \n       \n',
    'v': '       \n       \n       \n #   # \n #   # \n  # #  \n  # #  \n   #   \n       \n       \n',
    "'": '       \n   ##  \n   #   \n  #    \n       \n       \n       \n       \n       \n       \n',
    '5': '       \n ##### \n #     \n # ##  \n ##  # \n     # \n #   # \n  ###  \n       \n       \n',
    'p': '       \n       \n       \n # ##  \n ##  # \n ##  # \n # ##  \n #     \n #     \n #     \n',
    'b': '       \n #     \n #     \n # ##  \n ##  # \n #   # \n ##  # \n # ##  \n       \n       \n',
    'l': '       \n  ##   \n   #   \n   #   \n   #   \n   #   \n   #   \n  ###  \n       \n       \n',
    '&': '       \n  #    \n # #   \n # #   \n  #    \n # # # \n #  #  \n  ## # \n       \n       \n',
    'j': '       \n    #  \n       \n   ##  \n    #  \n    #  \n    #  \n #  #  \n #  #  \n  ##   \n',
    'D': '       \n ####  \n  #  # \n  #  # \n  #  # \n  #  # \n  #  # \n ####  \n       \n       \n',
    'o': '       \n       \n       \n  ###  \n #   # \n #   # \n #   # \n  ###  \n       \n       \n',
    '%': '       \n  #  # \n # # # \n  # #  \n   #   \n  # #  \n # # # \n #  #  \n       \n       \n',
    'i': '       \n   #   \n       \n  ##   \n   #   \n   #   \n   #   \n  ###  \n       \n       \n'}

dic_64f1 = {
    '=': '         \n ######  \n ######  \n         \n ######  \n ######  \n ######  \n         \n',
    's': ' ### ##  \n  #      \n    # ## \n#  #  #  \n  ####   \n###  ### \n  # #  # \n     # # \n',
    'E': '####     \n##       \n#####    \n##       \n##       \n#######  \n#######  \n#######  \n',
    '7': '#######  \n    ###  \n   ####  \n  ####   \n #####   \n#####    \n#####    \n####     \n',
    'N': '###  ##  \n###  ##  \n#### ##  \n#######  \n#######  \n### ###  \n###  ##  \n###  ##  \n',
    'y': '###      \n # #     \n### #  # \n   #   # \n  ####   \n# ###  # \n #       \n###  ### \n',
    '>': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '.': '         \n         \n         \n         \n         \n         \n  ###    \n   ##    \n',
    '_': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'f': ' # #  ## \n# #      \n #    ## \n# ##  ## \n      #  \n# #      \n #  ###  \n# ##   # \n',
    'H': '###  ##  \n###  ##  \n###  ##  \n#######  \n###  ##  \n###  ##  \n###  ##  \n###  ##  \n',
    'z': '    ###  \n#  # ##  \n##    #  \n #  #### \n #     # \n # #  #  \n #   #   \n  #      \n',
    'I': '#######  \n  ###    \n  ###    \n  ###    \n  ###    \n#######  \n#######  \n#######  \n',
    'T': '#######  \n#######  \n#######  \n  ###    \n  ###    \n  ###    \n  ###    \n  ###    \n',
    'r': '## #  ## \n  #      \n##  ###  \n # # # # \n #  ## # \n #    #  \n #   # # \n # #  #  \n',
    'c': '#  ###  \n#  ###  \n#   # # \n#    ## \n# # #   \n#  #  # \n#  #### \n#  ###  \n',
    'U': '###  ##  \n###  ##  \n###  ##  \n###  ##  \n###  ##  \n#######  \n#######  \n#######  \n',
    '1': '  ###    \n ####    \n  ###    \n  ###    \n  ###    \n#######  \n#######  \n#######  \n',
    ']': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'G': ' #####   \n###      \n### ##   \n###  ##  \n###  ##  \n#######  \n#######  \n #####   \n',
    'R': '######   \n###  ##  \n###  ##  \n#######  \n######   \n### ###  \n### ###  \n### ###  \n',
    'V': '###  ##  \n###  ##  \n###  ##  \n###  ##  \n###  ##  \n #####   \n #####   \n  ###    \n',
    'X': '###  ##  \n###  ##  \n###  ##  \n  ####   \n  ####   \n#######  \n###  ##  \n###  ##  \n',
    '!': '     ##  \n    ###  \n   ###   \n  ###    \n  ###    \n         \n ###     \n ###     \n',
    'u': '#  # ##  \n ### ##  \n  #      \n    #  # \n##  ## # \n #  #### \n #   #   \n #   # # \n',
    ',': '         \n         \n         \n         \n  ###    \n  ###    \n   ##    \n  ##     \n',
    '@': '  #      \n  ####   \n # ###   \n  #####  \n##   ##  \n #     # \n # #  ## \n # # #   \n',
    'J': '     ##  \n     ##  \n###  ##  \n###  ##  \n###  ##  \n#######  \n#######  \n #####   \n',
    'Y': '###  ##  \n###  ##  \n#######  \n #####   \n  ###    \n  ###    \n  ###    \n  ###    \n',
    'q': ' #     # \n #  ##   \n #  #  # \n #  ###  \n #   ### \n  #      \n##    #  \n##    #  \n',
    'w': '#  ## #  \n  ####   \n# #      \n  ###### \n  #####  \n###  ### \n   ## ## \n ### ##  \n',
    '\\': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '|': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'P': '######   \n###  ##  \n###  ##  \n#######  \n######   \n####     \n####     \n####     \n',
    'x': '  #      \n   ## ## \n###      \n # #   # \n# #      \n # #     \n# ##   # \n     ### \n',
    'C': ' #####   \n###  ##  \n##       \n##   ##  \n###  ##  \n#######  \n#######  \n #####   \n',
    '^': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '4': '   ###   \n  ####   \n #####   \n## ###   \n#######  \n#######  \n   ###   \n   ###   \n',
    '(': '  ###  \n ###   \n###    \n##     \n##     \n###    \n ###   \n  ###  \n',
    '~': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '/': '      #  \n     ##  \n    ###  \n   ###   \n  ###    \n ###     \n###      \n##       \n',
    'k': '## # #   \n##   #   \n## # #   \n###      \n #  #### \n# #      \n  ###### \n###  ### \n',
    '8': ' #####   \n### ###  \n #####   \n### ###  \n### ###  \n#######  \n#######  \n #####   \n',
    '"': '  ## ##  \n  ## ##  \n  ## ##  \n         \n         \n         \n         \n         \n',
    'A': '  ###    \n #####   \n ## ##   \n##   ##  \n##   ##  \n## ####  \n## ####  \n## ####  \n',
    ':': '         \n  ###    \n  ###    \n         \n         \n  ###    \n  ###    \n  ###    \n',
    '*': '         \n #  # #  \n  # ##   \n ##      \n     ##  \n  ## #   \n # #  #  \n         \n',
    'g': '  ## #   \n### #  # \n  # ## # \n      #  \n    ##   \n # #  #  \n  # #    \n## ##    \n',
    ' ': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'n': ' #   # # \n      #  \n   ##### \n    #  # \n### ##   \n##     # \n## # #   \n##   #   \n',
    'L': '##       \n##       \n##       \n##       \n##       \n#######  \n#######  \n#######  \n',
    '{': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'K': '###  #   \n### ##   \n#####    \n#####    \n######   \n### ###  \n### ###  \n### ###  \n',
    '`': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'S': ' #####   \n###      \n #####   \n    ###  \n    ###  \n#######  \n#######  \n######   \n',
    '0': ' #####   \n###  ##  \n### ###  \n#### ##  \n###  ##  \n#######  \n#######  \n #####   \n',
    '}': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'a': '  #      \n #  ## # \n #  #### \n #   #   \n #   # # \n  #####  \n # #     \n###  ### \n',
    'B': '#####    \n##  ##   \n#####    \n##  ##   \n##  ###  \n#######  \n######   \n######   \n',
    'd': ' #      \n#  #  # \n# #  ## \n #      \n#  ## # \n#     # \n#   #   \n#   # # \n',
    '2': ' #####   \n##  ###  \n   ###   \n ####    \n#####    \n#######  \n#######  \n#######  \n',
    '[': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'Q': ' #####   \n###  ##  \n###  ##  \n###  ##  \n### ##   \n######   \n#######  \n ######  \n',
    'm': ' # ##  # \n #   # # \n # #  ## \n  # #### \n## #     \n # # # # \n #  ##   \n # #  ## \n',
    'M': '##   ##  \n### ###  \n#######  \n#######  \n#######  \n###  ##  \n###  ##  \n###  ##  \n',
    'h': '# #      \n  ###### \n###  ### \n    #### \n  ##   # \n  ## ##  \n  ## ### \n  ##     \n',
    'F': '#######  \n####     \n######   \n####     \n####     \n####     \n####     \n####     \n',
    '-': '         \n         \n         \n ######  \n ######  \n         \n         \n         \n',
    'Z': ' ######  \n   ###   \n  ###    \n ###     \n####     \n#######  \n#######  \n#######  \n',
    't': ' ### ##  \n# ## ### \n  # #    \n  ####   \n###  ### \n   ##  # \n   #   # \n   #   # \n',
    '9': ' #####   \n###  ##  \n ######  \n    ###  \n#######  \n######   \n#####    \n####     \n',
    'O': ' #####   \n###  ##  \n###  ##  \n###  ##  \n###  ##  \n#######  \n#######  \n #####   \n',
    '<': '         \n         \n         \n         \n         \n         \n         \n         \n',
    ';': '         \n  ###    \n  ###    \n         \n         \n  ###    \n  ###    \n ###     \n',
    ')': '###    \n ###   \n  ###  \n   ##  \n   ##  \n  ###  \n ###   \n###    \n',
    '6': ' #####   \n###      \n######   \n###  ##  \n###  ##  \n#######  \n#######  \n #####   \n',
    '3': ' ######  \n     ##  \n   ###   \n##   ##  \n##   ##  \n#######  \n#######  \n #####   \n',
    'W': '###  ##  \n###  ##  \n###  ##  \n###  ##  \n#######  \n#######  \n### ###  \n##   ##  \n',
    'e': '  #      \n  #      \n #    ## \n#  ### # \n#  ### # \n#  ### # \n  ####   \n#   #    \n',
    '$': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '+': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '?': '  ####   \n ## ###  \n ## ###  \n    ##   \n         \n   ##    \n  ###    \n  ###    \n',
    'v': ' #  ## # \n  #      \n## # #   \n # ##  # \n # #     \n #   # # \n  ### #  \n  #      \n',
    "'": '  ###    \n  ###    \n   ##    \n  ##     \n         \n         \n         \n         \n',
    '5': '#######  \n###      \n######   \n     ##  \n###  ##  \n###  ##  \n#######  \n #####   \n',
    'p': '#  #  ## \n   #  #  \n#  # ##  \n ### ##  \n  #      \n    # ## \n##   #   \n #  #  # \n',
    'b': '  ### # \n# # ### \n#  #    \n#   # # \n#  ###  \n #      \n#    ## \n#  #### \n',
    'l': '   #     \n  ##   # \n  ## ##  \n  ## ### \n  ##     \n  # #### \n##  #    \n #     # \n',
    '&': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'j': ' #  #### \n #  ###  \n #   # # \n      #  \n   ##### \n    #  # \n### ##   \n##     # \n',
    'D': '#####    \n### ##   \n###  ##  \n###  ##  \n### ###  \n#######  \n#######  \n######   \n',
    'o': '## #     \n###      \n #  #### \n# ##     \n###      \n # #     \n###  ### \n  # ##   \n',
    '%': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'i': '  # #### \n##  #    \n #     # \n # ##  # \n #   # # \n # #  ## \n  # #### \n## # #   \n'}

a_zooloo_dic = {
    '=': '####     \n####     \n####     \n####     \n####     \n####     \n####     \n####     \n',
    's': ' ###    \n ###    \n ###    \n ###    \n#####   \n#####   \n #####  \n #####  \n',
    'E': '######   \n ######  \n ##      \n######   \n#####    \n###      \n#######  \n #####   \n',
    '7': '#######  \n ######  \n    ###  \n ####### \n#######  \n  ###    \n ###     \n###      \n',
    'N': '##  ##   \n### ###  \n### ###  \n#### ##  \n## ####  \n### ###  \n### ###  \n ##  ##  \n',
    'y': '###      \n###      \n### ###  \n### ###  \n#######  \n#######  \n #####   \n #####   \n',
    '>': '#### \n#### \n#### \n#### \n#### \n#### \n#### \n#### \n',
    '.': '         \n         \n         \n         \n         \n  ####   \n  ####   \n  ####   \n',
    '_': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'f': ' #####   \n #####   \n#######  \n#######  \n### # #  \n### # #  \n##       \n##       \n',
    'H': ' ## ##   \n### ###  \n### ###  \n#######  \n#######  \n### ###  \n### ###  \n ## ##   \n',
    'z': '### ###  \n### ###  \n#######  \n#######  \n#######  \n#######  \n##   ##  \n##   ##  \n',
    'I': ' ####   \n######  \n  ###   \n  ###   \n ###    \n ###    \n#####   \n #####  \n',
    'T': '######   \n ######  \n  ###    \n  ###    \n  ###    \n  ###    \n  ###    \n #####   \n',
    'r': ' ####   \n ####   \n######  \n######  \n  ###   \n  ###   \n  ###   \n  ###   \n',
    'c': '### ###  \n### ###  \n#######  \n#######  \n### ###  \n### ###  \n ##  ##  \n ##  ##  \n',
    'U': ' ##  ##  \n### ###  \n### ###  \n##  ###  \n###  ##  \n### ###  \n#######  \n #####   \n',
    '1': '   ##    \n  ###    \n ####    \n  ###    \n  ###    \n  ###    \n#######  \n#######  \n',
    ']': '#####   \n #####  \n   ###  \n   ##   \n   ##   \n   ###  \n #####  \n#####   \n',
    'G': ' #####   \n#######  \n###      \n##  ###  \n##   ##  \n### ###  \n#######  \n ######  \n',
    'R': '######   \n### ###  \n###  ##  \n### ###  \n######   \n### ###  \n ### ### \n ### ### \n',
    'V': ' ## ##   \n### ###  \n### ###  \n##  ###  \n##  ###  \n### ###  \n######   \n ####    \n',
    'X': '### ###  \n### ###  \n ######  \n   ###   \n  ###    \n #####   \n### ###  \n### ###  \n',
    '!': ' #####  \n #####  \n #####  \n ####   \n   ##   \n###     \n####    \n ##     \n',
    'u': '   ###   \n   ###   \n## ####  \n## ####  \n#######  \n#######  \n #####   \n #####   \n',
    ',': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '@': '         \n         \n         \n######## \n######## \n         \n         \n         \n',
    'J': ' #####   \n#######  \n   ###   \n   ##    \n   ###   \n## ####  \n#######  \n #####   \n',
    'Y': ' ## ##   \n### ###  \n### ###  \n#######  \n ## ###  \n    ###  \n#######  \n #####   \n',
    'q': '#######  \n#######  \n### ###  \n### ###  \n### ###  \n### ###  \n ## ##   \n ## ##   \n',
    'w': '####     \n####     \n######   \n######   \n### ###  \n### ###  \n### ###  \n### ###  \n',
    '\\': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '|': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'P': '######   \n### ###  \n###  ##  \n### ###  \n######   \n###      \n ###     \n ###     \n',
    'x': ' ###     \n ###     \n ###     \n ###     \n ###     \n ###     \n###      \n###      \n',
    'C': ' #####   \n#######  \n### # #  \n##       \n##       \n### # #  \n#######  \n #####   \n',
    '^': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '4': '   ####  \n  #####  \n ### ##  \n###  ##  \n#######  \n#######  \n    ###  \n    ##   \n',
    '(': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '~': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '#': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '/': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'k': '#####    \n#####    \n###      \n###      \n#######  \n#######  \n #####   \n #####   \n',
    '8': ' #####   \n### ###  \n### ###  \n #####   \n### ###  \n### ###  \n#######  \n #####   \n',
    '"': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'A': '  ###    \n #####   \n### ###  \n### ###  \n### ###  \n#######  \n### ###  \n ##  ##  \n',
    ':': '         \n         \n         \n######## \n######## \n####     \n####     \n####     \n',
    '*': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'g': '##       \n##       \n### # #  \n### # #  \n#######  \n#######  \n #####   \n #####   \n',
    ' ': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'n': ' #####   \n #####   \n#######  \n#######  \n###      \n###      \n##  ###  \n##  ###  \n',
    'L': ' ###     \n ###     \n ###     \n###      \n###      \n### ###  \n#######  \n #####   \n',
    '{': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'K': '### ###  \n ## ###  \n #####   \n#####    \n####     \n######   \n### ###  \n### ###  \n',
    '`': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'S': ' ######  \n######   \n##       \n#####    \n #####   \n    ###  \n ######  \n######   \n',
    '0': ' #####   \n#######  \n### ###  \n### ###  \n### ###  \n### ###  \n#######  \n #####   \n',
    '}': '         \n         \n         \n         \n         \n         \n         \n         \n',
    'a': '    #### \n    #### \n    #### \n######## \n######## \n         \n         \n         \n',
    'B': '######   \n ## ###  \n ## ###  \n #####   \n### ##   \n### ###  \n#######  \n######   \n',
    'd': '######   \n######   \n ## ###  \n ## ###  \n ## ###  \n ## ###  \n #####   \n #####   \n',
    '2': ' #####   \n#######  \n### ###  \n   ####  \n  ####   \n ####    \n#######  \n#######  \n',
    '[': ' #####  \n#####   \n###     \n ##     \n ##     \n###     \n#####   \n #####  \n',
    'Q': ' #####   \n#######  \n###  ##  \n##   ##  \n##  ###  \n#######  \n #####   \n   ####  \n',
    'm': '######   \n######   \n###      \n###      \n####     \n####     \n ###     \n ###     \n',
    'M': '### ###  \n#######  \n#######  \n##   ##  \n### ###  \n### ###  \n ## ##   \n ## ##   \n',
    'h': '#####    \n#####    \n #####   \n #####   \n ## ###  \n ## ###  \n ##  ##  \n ##  ##  \n',
    'F': '######   \n ######  \n ##      \n ######  \n######   \n###      \n####     \n ###     \n',
    '-': '         \n         \n         \n######   \n ######  \n         \n         \n         \n',
    'Z': ' #####   \n#######  \n    ###  \n   ###   \n#######  \n ###     \n#######  \n######   \n',
    't': ' #####   \n #####   \n#######  \n#######  \n   ###   \n   ###   \n   ##    \n   ##    \n',
    '9': ' #####   \n#######  \n### ###  \n#######  \n ######  \n    ###  \n ######  \n######   \n',
    'O': ' #####   \n### ###  \n### ###  \n##   ##  \n##   ##  \n### ###  \n#######  \n #####   \n',
    '<': '         \n         \n         \n######## \n######## \n    #### \n    #### \n    #### \n',
    ';': '         \n         \n         \n######## \n######## \n         \n         \n         \n',
    ')': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '6': ' ######  \n######   \n###      \n######   \n#######  \n### ###  \n#######  \n #####   \n',
    '3': ' #####   \n#######  \n    ###  \n   ###   \n  ####   \n    ###  \n#######  \n #####   \n',
    'W': ' ### ### \n ### ### \n###  ### \n### ###  \n#######  \n#######  \n### ###  \n##   ##  \n',
    'e': '### ##   \n### ##   \n### ###  \n### ###  \n#######  \n#######  \n######   \n######   \n',
    '$': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '+': '         \n         \n         \n         \n         \n         \n         \n         \n',
    '?': '####     \n####     \n####     \n######## \n######## \n         \n         \n         \n',
    'v': '### ###  \n### ###  \n ## ###  \n ## ###  \n #####   \n #####   \n#####    \n#####    \n',
    "'": '   ####  \n  ####   \n  ###    \n  ##     \n         \n         \n         \n         \n',
    '5': '#######  \n######   \n##       \n######   \n ######  \n    ###  \n#######  \n #####   \n',
    'p': ' ## ##   \n ## ##   \n### ###  \n### ###  \n### ###  \n### ###  \n#######  \n#######  \n',
    'b': '  ###    \n  ###    \n #####   \n #####   \n### ###  \n### ###  \n### ###  \n### ###  \n',
    'l': '######   \n######   \n 