# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.resource.bicep import BicepMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-resource-bicep
# USAGE
    python decompile_bicep.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = BicepMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.decompile_operation_group.bicep(
        decompile_operation_request={
            "template": '{\r\n "$schema": "https://schema.management.azure.com/schemas/2019-04-01/deploymentTemplate.json#",\r\n "contentVersion": "1.0.0.0",\r\n "metadata": {\r\n "_generator": {\r\n "name": "bicep",\r\n "version": "0.15.31.15270",\r\n "templateHash": "9249505596133208719"\r\n }\r\n },\r\n "parameters": {\r\n "storageAccountName": {\r\n "type": "string"\r\n }\r\n },\r\n "resources": []\r\n}'
        },
    )
    print(response)


# x-ms-original-file: 2023-11-01/DecompileBicep.json
if __name__ == "__main__":
    main()
