# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.security.aio import SecurityCenter

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSecurityCenterAutomationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SecurityCenter, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_automations_list(self, resource_group):
        response = self.client.automations.list(
            api_version="2023-12-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_automations_list_by_resource_group(self, resource_group):
        response = self.client.automations.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2023-12-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_automations_get(self, resource_group):
        response = await self.client.automations.get(
            resource_group_name=resource_group.name,
            automation_name="str",
            api_version="2023-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_automations_create_or_update(self, resource_group):
        response = await self.client.automations.create_or_update(
            resource_group_name=resource_group.name,
            automation_name="str",
            automation={
                "actions": ["automation_action"],
                "description": "str",
                "etag": "str",
                "id": "str",
                "isEnabled": bool,
                "kind": "str",
                "location": "str",
                "name": "str",
                "scopes": [{"description": "str", "scopePath": "str"}],
                "sources": [
                    {
                        "eventSource": "str",
                        "ruleSets": [
                            {
                                "rules": [
                                    {
                                        "expectedValue": "str",
                                        "operator": "str",
                                        "propertyJPath": "str",
                                        "propertyType": "str",
                                    }
                                ]
                            }
                        ],
                    }
                ],
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2023-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_automations_update(self, resource_group):
        response = await self.client.automations.update(
            resource_group_name=resource_group.name,
            automation_name="str",
            automation={
                "actions": ["automation_action"],
                "description": "str",
                "isEnabled": bool,
                "scopes": [{"description": "str", "scopePath": "str"}],
                "sources": [
                    {
                        "eventSource": "str",
                        "ruleSets": [
                            {
                                "rules": [
                                    {
                                        "expectedValue": "str",
                                        "operator": "str",
                                        "propertyJPath": "str",
                                        "propertyType": "str",
                                    }
                                ]
                            }
                        ],
                    }
                ],
                "tags": {"str": "str"},
            },
            api_version="2023-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_automations_delete(self, resource_group):
        response = await self.client.automations.delete(
            resource_group_name=resource_group.name,
            automation_name="str",
            api_version="2023-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_automations_validate(self, resource_group):
        response = await self.client.automations.validate(
            resource_group_name=resource_group.name,
            automation_name="str",
            automation={
                "actions": ["automation_action"],
                "description": "str",
                "etag": "str",
                "id": "str",
                "isEnabled": bool,
                "kind": "str",
                "location": "str",
                "name": "str",
                "scopes": [{"description": "str", "scopePath": "str"}],
                "sources": [
                    {
                        "eventSource": "str",
                        "ruleSets": [
                            {
                                "rules": [
                                    {
                                        "expectedValue": "str",
                                        "operator": "str",
                                        "propertyJPath": "str",
                                        "propertyType": "str",
                                    }
                                ]
                            }
                        ],
                    }
                ],
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2023-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...
