/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import nu.validator.io.BoundedInputStream;
import nu.validator.io.StreamBoundException;
import nu.validator.servlet.DelegatingServletInputStream;

public final class InboundSizeLimitFilter
implements Filter {
    private long sizeLimit;

    public InboundSizeLimitFilter(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public InboundSizeLimitFilter() {
        this(Long.MAX_VALUE);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        chain.doFilter(new RequestWrapper(request), res);
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
    }

    private final class RequestWrapper
    extends HttpServletRequestWrapper {
        private ServletInputStream stream;

        public RequestWrapper(HttpServletRequest req) throws IOException {
            super(req);
            this.stream = null;
        }

        @Override
        public ServletInputStream getInputStream() throws IOException {
            if (this.stream == null) {
                if ((long)super.getContentLength() > InboundSizeLimitFilter.this.sizeLimit) {
                    throw new StreamBoundException("Resource size exceeds limit.");
                }
                this.stream = new DelegatingServletInputStream(new BoundedInputStream(super.getInputStream(), InboundSizeLimitFilter.this.sizeLimit, super.getHeader("Content-Location")));
            }
            return this.stream;
        }
    }
}

