/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.selectors;

import org.w3c.css.selectors.Selector;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;

public abstract class AttributeSelector
implements Selector {
    private String prefix;
    private String name;
    private String modifier;
    private String _prefixed_name = null;
    private String _ending_string = null;
    static final String[] allowed_modifier = new String[]{"i", "s"};

    static final boolean isValidModifier(String modifier) {
        for (String s : allowed_modifier) {
            if (!s.equals(modifier)) continue;
            return true;
        }
        return false;
    }

    public AttributeSelector() {
    }

    public AttributeSelector(String name) {
        this(name, null, null);
    }

    public AttributeSelector(String name, String prefix, String modifier) {
        this.name = name;
        this.prefix = prefix;
        this.modifier = modifier;
    }

    public AttributeSelector(String name, String prefix) {
        this(name, prefix, null);
    }

    public void setName(String name) {
        this.name = name;
        this._prefixed_name = null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
        this._prefixed_name = null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setModifier(String modifier, ApplContext ac) throws InvalidParamException {
        if (!AttributeSelector.isValidModifier(modifier)) {
            throw new InvalidParamException("value", modifier, this.getPrefixedName(), ac);
        }
        this.modifier = modifier;
    }

    public String getModifier() {
        return this.modifier;
    }

    public abstract void applyAttribute(ApplContext var1, AttributeSelector var2);

    public String getPrefixedName() {
        if (this._prefixed_name == null) {
            if (this.prefix == null) {
                this._prefixed_name = this.name;
            } else {
                StringBuilder sb = new StringBuilder();
                this._prefixed_name = sb.append(this.prefix).append('|').append(this.name).toString();
            }
        }
        return this._prefixed_name;
    }

    public String getEndingString() {
        if (this._ending_string == null) {
            if (this.modifier == null) {
                this._ending_string = "]";
            } else {
                StringBuilder sb = new StringBuilder();
                this._ending_string = sb.append(" ").append(this.modifier).append(']').toString();
            }
        }
        return this._ending_string;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[').append(this.getPrefixedName()).append(this.getEndingString());
        return sb.toString();
    }
}

