package WordList::Char::ZH::HSK6;

our $DATE = '2016-02-04'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("num_words_contains_whitespace",0,"num_words",977,"num_words_contains_unicode",977,"shortest_word_len",1,"longest_word_len",1,"avg_word_len",1,"num_words_contains_nonword_chars",0); # STATS

1;
# ABSTRACT: HSK (level 6 only) characters

=pod

=encoding UTF-8

=head1 NAME

WordList::Char::ZH::HSK6 - HSK (level 6 only) characters

=head1 VERSION

This document describes version 0.01 of WordList::Char::ZH::HSK6 (from Perl distribution WordList-ZH-HSK), released on 2016-02-04.

=head1 SYNOPSIS

 use WordList::Char::ZH::HSK6;

 my $wl = WordList::Char::ZH::HSK6->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 1     |
 | longest_word_len                 | 1     |
 | num_words                        | 977   |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 977   |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 1     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ZH-HSK>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ZH-HSK>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ZH-HSK>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<WordList::Char::ZH::HSK>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
丁
丐
丘
丙
丛
丧
串
丸
乌
乞
乳
予
井
亡
亦
亭
仁
仇
仓
仗
仙
仪
仰
伍
伏
伐
伦
伪
伯
伶
伺
佣
佳
侃
侄
侈
侠
侣
侥
侦
侧
侨
侮
侵
俐
俘
俭
俯
倔
倘
倦
债
倾
偏
储
僵
僻
儒
兆
党
兜
兢
兽
冤
凄
凑
凝
凡
凶
凸
凹
刊
刑
券
刹
剂
削
剑
剔
剖
剥
副
割
劈
劫
勃
勉
勘
勾
协
卑
卓
卸
叛
叠
叨
叭
叮
叹
叼
吁
吉
吊
君
吝
吞
吟
吩
吼
呈
呕
呵
呻
咀
咋
咐
咙
咽
哀
哄
哆
哇
哑
哗
哦
哨
哺
哼
唆
唇
唐
唠
唤
唾
啃
啥
啦
啬
啰
啸
喇
喉
喘
喧
喻
嗅
嗦
嗨
嘈
嘛
嘱
嘲
嘿
噪
嚷
嚼
圣
坑
坛
坝
坟
坠
坡
垂
垄
垫
埋
堂
堕
堡
堤
堪
塌
塔
塞
墅
墓
墟
墨
壤
壮
壳
央
夺
奉
奏
奔
奠
奢
奥
奴
妄
妆
妒
妥
姆
娃
娇
婪
婴
媳
嫂
嫉
嫌
孔
孤
宅
宇
宏
宗
宙
审
宪
宫
宰
宵
寝
寸
寺
尖
尬
尴
尸
屁
屏
屑
屡
履
岂
岔
岗
岩
岳
峡
峭
峰
峻
崇
崖
崩
崭
嵌
川
州
巡
巢
巩
巷
帆
帐
帖
帜
帝
幢
庄
庇
庙
庞
庸
廉
廊
廓
异
弊
弥
弦
彰
役
径
徊
徒
徘
徙
御
循
忌
忠
忧
怒
怖
怠
怯
恍
恒
恕
恩
恰
悟
患
悦
悬
悼
惋
惑
惕
惦
惧
惨
惩
惫
惮
惰
惹
愈
愚
愣
愤
慈
慨
慷
憋
截
扁
扎
扑
扒
扛
扣
扭
扯
抑
抒
抗
抚
抛
抵
抹
拄
拌
拓
拔
拖
拘
拙
拟
拢
拣
拧
拨
拽
挎
挖
挚
挠
挪
挫
挽
捆
捉
捍
捎
捏
捕
捞
捣
捧
捷
掀
掏
掐
掘
掠
探
掩
掰
掷
揉
揍
揭
援
搀
搁
搂
搅
搏
搓
搭
携
摊
摧
撇
撑
撒
撤
撼
擅
擎
攀
攒
攻
敞
敷
斑
斟
斥
斩
斯
旋
旗
旨
旱
旷
旺
昂
昌
昏
昔
昧
昼
晃
晋
晓
晤
晨
晰
晶
晾
暄
暧
暴
曝
曲
朴
朽
杆
杖
杜
杠
杰
枉
枕
枚
枝
枯
柬
柱
栋
栏
株
栽
框
桑
桨
梁
梢
械
棉
棍
棕
椎
椭
榜
榨
横
橙
欲
欺
歧
歹
殃
残
殖
殴
殿
毁
毅
氏
氓
氧
汰
汹
沃
沐
沛
沧
沫
沮
沸
沼
沾
沿
泄
泊
泌
泡
波
泣
泥
泰
泻
泽
洁
津
洪
洽
浊
浑
浮
浴
浸
涉
涌
涕
涛
涩
涮
液
涵
淀
淆
淋
混
淹
添
渔
渗
渠
渡
渣
港
渺
湖
湾
溃
溅
溉
溜
溪
溶
滋
滔
滞
滤
滥
滨
漆
潇
潜
澄
澈
濒
瀑
灌
灭
灶
灿
炉
炊
炎
炫
烁
烘
烛
烹
焦
焰
煌
煎
熄
熏
熨
爆
爽
牢
牧
牲
牵
牺
犬
犯
狈
狠
狭
狱
狼
猎
猛
珠
琢
瓣
瓦
瓷
甘
甭
田
畅
畏
畔
畜
番
畴
疆
疏
疙
疤
疫
疾
症
痕
痪
痹
瘤
瘩
瘫
瘸
瘾
癌
皆
皇
皱
盈
监
盗
盛
盟
盯
盲
眨
眯
眶
督
睦
睬
睹
瞄
瞒
瞩
瞪
瞬
瞻
砖
砸
碌
碑
碳
磁
磅
磋
磕
磨
祖
祥
祸
禽
秃
秤
稀
稚
稠
稻
稼
稿
穴
窃
窍
窜
窝
竖
竭
端
笼
筋
筐
筒
策
筛
筹
箭
篷
簸
粉
粒
粥
粹
紊
纠
纤
纬
纵
纹
纺
纽
绅
绎
绑
绒
绘
绣
缀
缉
缔
缘
缚
缝
缠
缴
罐
罕
罢
罩
罪
署
翔
翘
翼
耀
耍
耕
耗
耸
耻
聋
肆
肖
肢
肪
肴
肺
肿
胀
胎
胞
脂
脉
腔
腥
腹
腻
腾
膛
膜
膝
膨
臂
臣
舆
舌
舔
舟
舰
舱
舶
艇
艘
芒
芽
苍
苏
苟
若
茂
茎
茫
荒
荡
荤
莫
菌
萌
萎
董
葬
蒂
蒙
蒸
蓄
蓬
蔑
蔓
蔚
蔼
蔽
蕴
蕾
薪
藐
虏
虐
蚀
蚁
蚂
蛮
蜡
融
蠢
衅
衍
衔
衰
衷
袍
袖
袭
袱
裂
裕
裳
覆
觅
誉
誓
譬
讥
讯
讳
讶
讼
诈
诞
诧
诫
诬
诱
诵
诸
诺
诽
谋
谍
谎
谐
谜
谣
谤
谬
谱
谴
谷
贤
贩
贪
贫
贬
贯
贼
贿
赁
赂
赋
赌
赖
赠
赤
赴
趴
跌
跨
跪
踊
踏
踪
蹈
蹋
蹦
蹬
躁
躬
轨
轰
辉
辐
辕
辖
辙
辜
辟
辨
辫
辰
辱
辽
迁
迄
迈
迸
逆
逊
逝
逢
逮
逼
遏
遣
遥
遭
遮
郁
郎
郑
鄙
酌
酗
酝
酬
酷
酿
野
鉴
钉
钙
钝
钞
钦
钩
钻
铜
铭
铸
铺
锈
锋
锐
锤
锦
锲
镇
镶
闷
阂
阐
阔
阱
陈
陋
陡
陵
陶
陷
隆
隐
隘
隙
障
隧
隶
雀
雅
雇
雌
雕
雹
霍
霜
霞
露
霸
鞠
韧
顽
颁
颂
颇
颈
颖
额
颠
颤
饥
饪
饲
饶
馅
馈
馋
驰
驱
驳
驻
骚
魂
魄
魔
鲁
鸣
鸦
鸽
黎
