/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker;

import com.fizzed.rocker.RenderingException;
import com.fizzed.rocker.RockerContent;
import com.fizzed.rocker.RockerModel;
import com.fizzed.rocker.RockerOutput;
import com.fizzed.rocker.RockerOutputFactory;
import com.fizzed.rocker.RockerTemplateCustomizer;
import com.fizzed.rocker.TemplateBindException;
import java.lang.reflect.Method;
import java.util.Map;

public class BindableRockerModel
implements RockerModel {
    private final String templatePath;
    private final String templateClassName;
    private final RockerModel model;

    public BindableRockerModel(String templatePath, String templateClassName, RockerModel model) {
        this.templatePath = templatePath;
        this.templateClassName = templateClassName;
        this.model = model;
    }

    public BindableRockerModel bind(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            this.bind(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public BindableRockerModel relaxedBind(Map<String, Object> values) {
        try {
            Method f = this.model.getClass().getMethod("getArgumentNames", new Class[0]);
            for (String k : (String[])f.invoke(null, new Object[0])) {
                if (!values.containsKey(k)) {
                    throw new TemplateBindException(this.templatePath, this.templateClassName, "Unable to set property '" + k + "'");
                }
                this.bind(k, values.get(k));
            }
            return this;
        }
        catch (Exception e) {
            throw new TemplateBindException(this.templatePath, this.model.getClass().getCanonicalName(), "Unable to read getArgumentNames static method from template");
        }
    }

    public BindableRockerModel bind(String name, Object value) {
        Class<?>[] types;
        Class<?> firstType;
        Method setter = null;
        try {
            Method[] methods;
            for (Method method : methods = this.model.getClass().getMethods()) {
                Class<?>[] parameterTypes;
                if (!method.getName().equals(name) || (parameterTypes = method.getParameterTypes()) == null || parameterTypes.length != 1) continue;
                setter = method;
                break;
            }
        }
        catch (SecurityException e) {
            throw new TemplateBindException(this.templatePath, this.templateClassName, "Security exception while binding property '" + name + "'", e);
        }
        if (setter == null) {
            throw new TemplateBindException(this.templatePath, this.templateClassName, "Property '" + name + "' not found");
        }
        if (value != null && !(firstType = (types = setter.getParameterTypes())[0]).isAssignableFrom(value.getClass())) {
            throw new TemplateBindException(this.templatePath, this.templateClassName, "Value type " + value.getClass().getCanonicalName() + " is not assignable to property " + name + "(" + firstType.getCanonicalName() + ")");
        }
        try {
            setter.invoke((Object)this.model, value);
        }
        catch (Exception e) {
            throw new TemplateBindException(this.templatePath, this.templateClassName, "Unable to set property '" + name + "'", e);
        }
        return this;
    }

    @Override
    public RockerOutput render() throws RenderingException {
        return this.model.render();
    }

    public <T extends RockerOutput> T render(RockerOutputFactory<T> outputFactory) throws RenderingException {
        return this.model.render(outputFactory);
    }

    public <T extends RockerOutput> T render(RockerOutputFactory<T> outputFactory, RockerTemplateCustomizer templateCustomizer) throws RenderingException {
        return this.model.render(outputFactory, templateCustomizer);
    }

    public RockerModel getModel() {
        return this.model;
    }

    public BindableRockerModel __body(RockerContent __body) {
        return this.bind("__body", __body);
    }
}

