/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.AbstractBeanContextConditional;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Primary;
import io.micronaut.context.exceptions.BeanInstantiationException;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.naming.Named;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.value.ValueResolver;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanFactory;
import io.micronaut.inject.DelegatingBeanDefinition;
import io.micronaut.inject.DisposableBeanDefinition;
import io.micronaut.inject.InitializingBeanDefinition;
import io.micronaut.inject.InjectionPoint;
import io.micronaut.inject.ParametrizedBeanFactory;
import io.micronaut.inject.ValidatedBeanDefinition;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Internal
class BeanDefinitionDelegate<T>
extends AbstractBeanContextConditional
implements DelegatingBeanDefinition<T>,
BeanFactory<T>,
NameResolver,
ValueResolver<String> {
    static final String PRIMARY_ATTRIBUTE = Primary.class.getName();
    protected final BeanDefinition<T> definition;
    @Nullable
    protected Map<String, Object> attributes;
    @Nullable
    protected final Qualifier qualifier;

    private BeanDefinitionDelegate(BeanDefinition<T> definition) {
        this(definition, null);
    }

    private BeanDefinitionDelegate(BeanDefinition<T> definition, @Nullable Qualifier qualifier) {
        this.definition = definition;
        this.qualifier = qualifier;
    }

    @Nullable
    public Qualifier getQualifier() {
        return this.qualifier;
    }

    @Nullable
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    @Nullable
    public Qualifier<T> resolveDynamicQualifier() {
        if (this.qualifier != null) {
            return this.qualifier;
        }
        if (this.attributes == null) {
            return null;
        }
        Object o = this.attributes.get(NAMED_ATTRIBUTE);
        if (o instanceof CharSequence) {
            return Qualifiers.byName(o.toString());
        }
        return null;
    }

    BeanDefinition<T> getDelegate() {
        return this.definition;
    }

    @Override
    public boolean isProxy() {
        return this.definition.isProxy();
    }

    @Override
    public boolean isIterable() {
        return this.definition.isIterable();
    }

    @Override
    public boolean isPrimary() {
        return this.definition.isPrimary() || this.isPrimaryThroughAttribute();
    }

    private boolean isPrimaryThroughAttribute() {
        if (this.attributes == null) {
            return false;
        }
        Object o = this.attributes.get(PRIMARY_ATTRIBUTE);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    @Override
    public T build(BeanResolutionContext resolutionContext, BeanContext context, BeanDefinition<T> definition) throws BeanInstantiationException {
        LinkedHashMap<String, Object> oldAttributes = null;
        if (CollectionUtils.isNotEmpty(this.attributes)) {
            LinkedHashMap<String, Object> oldAttrs = new LinkedHashMap<String, Object>(this.attributes.size());
            this.attributes.forEach((key, value) -> {
                Object previous = resolutionContext.setAttribute((CharSequence)key, value);
                if (previous != null) {
                    oldAttrs.put((String)key, previous);
                }
            });
            oldAttributes = oldAttrs;
        }
        try {
            if (this.definition instanceof ParametrizedBeanFactory) {
                ParametrizedBeanFactory parametrizedBeanFactory = (ParametrizedBeanFactory)((Object)this.definition);
                Map<String, Object> fulfilled = this.getParametersValues(resolutionContext, (DefaultBeanContext)context, definition, parametrizedBeanFactory);
                T t = parametrizedBeanFactory.build(resolutionContext, context, definition, fulfilled);
                return t;
            }
            if (this.definition instanceof BeanFactory) {
                T t = ((BeanFactory)((Object)this.definition)).build(resolutionContext, context, definition);
                return t;
            }
            throw new IllegalStateException("Cannot construct a dynamically registered singleton");
        }
        finally {
            if (this.attributes != null) {
                for (String key2 : this.attributes.keySet()) {
                    resolutionContext.removeAttribute(key2);
                }
            }
            if (oldAttributes != null) {
                oldAttributes.forEach(resolutionContext::setAttribute);
            }
        }
    }

    @Nullable
    private Map<String, Object> getParametersValues(BeanResolutionContext resolutionContext, DefaultBeanContext context, BeanDefinition<T> definition, ParametrizedBeanFactory<T> parametrizedBeanFactory) {
        Argument<?>[] requiredArguments = parametrizedBeanFactory.getRequiredArguments();
        LinkedHashMap<String, Object> fulfilled = new LinkedHashMap<String, Object>(requiredArguments.length);
        for (Argument<?> argument : requiredArguments) {
            String argumentName = argument.getName();
            Object value = this.resolveValueAsName(argument);
            if (value == null) {
                Qualifier<?> qualifier = this.resolveQualifier(argument);
                if (qualifier == null && !this.isPrimary()) continue;
                try (BeanResolutionContext.Path ignored = resolutionContext.getPath().pushConstructorResolve(definition, argument);){
                    value = context.findBean(resolutionContext, argument, qualifier).orElse(null);
                }
            }
            if (value == null) continue;
            fulfilled.put(argumentName, value);
        }
        return fulfilled;
    }

    @Nullable
    private <K> Qualifier<K> resolveQualifier(Argument<K> argument) {
        Qualifier qualifier;
        Map qualifierMapValue;
        Map map = qualifierMapValue = this.attributes == null ? Collections.emptyMap() : this.attributes.get("javax.inject.Qualifier");
        if (qualifierMapValue instanceof Map && (qualifier = (Qualifier)qualifierMapValue.get(argument)) != null) {
            return qualifier;
        }
        return this.resolveDynamicQualifier();
    }

    @Nullable
    private Object resolveValueAsName(Argument<?> argument) {
        Object named = this.attributes == null ? null : this.attributes.get(Named.class.getName());
        Object value = null;
        if (named != null) {
            value = ConversionService.SHARED.convert(named, argument).orElse(null);
        }
        if (value == null && this.isPrimary()) {
            value = ConversionService.SHARED.convert((Object)"Primary", argument).orElse(null);
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanDefinitionDelegate that = (BeanDefinitionDelegate)o;
        return Objects.equals(this.definition, that.definition) && Objects.equals(this.resolveName().orElse(null), that.resolveName().orElse(null));
    }

    public int hashCode() {
        return Objects.hash(this.definition, this.resolveName().orElse(null));
    }

    @Override
    public BeanDefinition<T> getTarget() {
        return this.definition;
    }

    @Override
    public Optional<String> resolveName() {
        return this.get(Named.class.getName(), String.class);
    }

    public void put(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>(2, 1.0f);
        }
        this.attributes.put(name, value);
    }

    @Override
    public <K> Optional<K> get(String name, ArgumentConversionContext<K> conversionContext) {
        if (this.attributes == null) {
            return Optional.empty();
        }
        Object value = this.attributes.get(name);
        if (value != null && conversionContext.getArgument().getType().isInstance(value)) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.definition.toString();
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition) {
        return BeanDefinitionDelegate.create(definition, null);
    }

    static <T> BeanDefinitionDelegate<T> create(BeanDefinition<T> definition, Qualifier qualifier) {
        if (definition instanceof InitializingBeanDefinition || definition instanceof DisposableBeanDefinition) {
            if (definition instanceof ValidatedBeanDefinition) {
                return new LifeCycleValidatingDelegate(definition, qualifier);
            }
            return new LifeCycleDelegate(definition, qualifier);
        }
        if (definition instanceof ValidatedBeanDefinition) {
            return new ValidatingDelegate(definition, qualifier);
        }
        return new BeanDefinitionDelegate<T>(definition, qualifier);
    }

    @Override
    @NonNull
    public String getName() {
        return this.definition.getName();
    }

    private static final class LifeCycleValidatingDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyValidatingBeanDefinition<T>,
    ProxyInitializingBeanDefinition<T>,
    ProxyDisposableBeanDefinition<T> {
        private LifeCycleValidatingDelegate(BeanDefinition<T> definition, Qualifier qualifier) {
            super(definition, qualifier);
        }
    }

    private static final class ValidatingDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyValidatingBeanDefinition<T> {
        private ValidatingDelegate(BeanDefinition<T> definition, Qualifier qualifier) {
            super(definition, qualifier);
        }
    }

    private static final class LifeCycleDelegate<T>
    extends BeanDefinitionDelegate<T>
    implements ProxyInitializingBeanDefinition<T>,
    ProxyDisposableBeanDefinition<T> {
        private LifeCycleDelegate(BeanDefinition<T> definition, Qualifier qualifier) {
            super(definition, qualifier);
        }
    }

    static interface ProxyValidatingBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    ValidatedBeanDefinition<T> {
        @Override
        default public T validate(BeanResolutionContext resolutionContext, T instance) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof ValidatedBeanDefinition) {
                return ((ValidatedBeanDefinition)definition).validate(resolutionContext, instance);
            }
            return instance;
        }

        @Override
        default public <V> void validateBeanArgument(@NonNull BeanResolutionContext resolutionContext, @NonNull InjectionPoint injectionPoint, @NonNull Argument<V> argument, int index2, @Nullable V value) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof ValidatedBeanDefinition) {
                ((ValidatedBeanDefinition)definition).validateBeanArgument(resolutionContext, injectionPoint, argument, index2, value);
            }
        }
    }

    static interface ProxyDisposableBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    DisposableBeanDefinition<T> {
        @Override
        default public T dispose(BeanResolutionContext resolutionContext, BeanContext context, T bean2) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof DisposableBeanDefinition) {
                return ((DisposableBeanDefinition)definition).dispose(resolutionContext, context, bean2);
            }
            return bean2;
        }
    }

    static interface ProxyInitializingBeanDefinition<T>
    extends DelegatingBeanDefinition<T>,
    InitializingBeanDefinition<T> {
        @Override
        default public T initialize(BeanResolutionContext resolutionContext, BeanContext context, T bean2) {
            BeanDefinition definition = this.getTarget();
            if (definition instanceof InitializingBeanDefinition) {
                return ((InitializingBeanDefinition)definition).initialize(resolutionContext, context, bean2);
            }
            return bean2;
        }
    }
}

