/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.client.netty.websocket;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.bind.BoundExecutable;
import io.micronaut.core.bind.DefaultExecutableBinder;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.type.Argument;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.http.bind.RequestBinderRegistry;
import io.micronaut.http.codec.MediaTypeCodecRegistry;
import io.micronaut.http.netty.websocket.AbstractNettyWebSocketHandler;
import io.micronaut.http.netty.websocket.NettyWebSocketSession;
import io.micronaut.http.uri.UriMatchInfo;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.websocket.CloseReason;
import io.micronaut.websocket.WebSocketPongMessage;
import io.micronaut.websocket.annotation.ClientWebSocket;
import io.micronaut.websocket.bind.WebSocketState;
import io.micronaut.websocket.context.WebSocketBean;
import io.micronaut.websocket.exceptions.WebSocketClientException;
import io.micronaut.websocket.exceptions.WebSocketSessionException;
import io.micronaut.websocket.interceptor.WebSocketSessionAware;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

@Internal
public class NettyWebSocketClientHandler<T>
extends AbstractNettyWebSocketHandler {
    private final WebSocketClientHandshaker handshaker;
    private final WebSocketBean<T> genericWebSocketBean;
    private final Sinks.One<T> completion = Sinks.one();
    private final UriMatchInfo matchInfo;
    private final MediaTypeCodecRegistry codecRegistry;
    private NettyWebSocketSession clientSession;
    private FullHttpResponse handshakeResponse;
    private Argument<?> clientBodyArgument;
    private Argument<?> clientPongArgument;

    public NettyWebSocketClientHandler(MutableHttpRequest<?> request, WebSocketBean<T> webSocketBean, WebSocketClientHandshaker handshaker, RequestBinderRegistry requestBinderRegistry, MediaTypeCodecRegistry mediaTypeCodecRegistry) {
        super(null, requestBinderRegistry, mediaTypeCodecRegistry, webSocketBean, request, Collections.emptyMap(), handshaker.version(), handshaker.actualSubprotocol(), null);
        this.codecRegistry = mediaTypeCodecRegistry;
        this.handshaker = handshaker;
        this.genericWebSocketBean = webSocketBean;
        String clientPath = webSocketBean.getBeanDefinition().stringValue(ClientWebSocket.class).orElse("");
        UriMatchTemplate matchTemplate = UriMatchTemplate.of(clientPath);
        this.matchInfo = matchTemplate.match(request.getPath()).orElse(null);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (idleStateEvent.state() == IdleState.ALL_IDLE && this.clientSession != null && this.clientSession.isOpen()) {
                this.clientSession.close(CloseReason.NORMAL);
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public Argument<?> getBodyArgument() {
        return this.clientBodyArgument;
    }

    @Override
    public Argument<?> getPongArgument() {
        return this.clientPongArgument;
    }

    @Override
    public NettyWebSocketSession getSession() {
        return this.clientSession;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        this.handshaker.handshake(ctx.channel()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
            if (future.isSuccess()) {
                ctx.channel().config().setAutoRead(true);
                ctx.read();
            } else {
                this.completion.tryEmitError(future.cause());
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
        Channel ch = ctx.channel();
        if (!this.handshaker.isHandshakeComplete()) {
            DefaultExecutableBinder<WebSocketState> binder;
            BoundExecutable bound;
            List<Argument<?>> unboundArguments;
            FullHttpResponse res;
            this.handshakeResponse = res = (FullHttpResponse)msg;
            try {
                this.handshaker.finishHandshake(ch, res);
            }
            catch (Exception e) {
                try {
                    this.completion.tryEmitError(new WebSocketClientException("Error finishing WebSocket handshake: " + e.getMessage(), e));
                }
                finally {
                    ch.writeAndFlush(new CloseWebSocketFrame(CloseReason.INTERNAL_ERROR.getCode(), CloseReason.INTERNAL_ERROR.getReason()));
                    ch.close();
                }
                return;
            }
            this.clientSession = this.createWebSocketSession(ctx);
            T targetBean = this.genericWebSocketBean.getTarget();
            if (targetBean instanceof WebSocketSessionAware) {
                ((WebSocketSessionAware)targetBean).setWebSocketSession(this.clientSession);
            }
            if ((unboundArguments = (bound = (binder = new DefaultExecutableBinder<WebSocketState>()).tryBind(this.messageHandler.getExecutableMethod(), this.webSocketBinder, new WebSocketState(this.clientSession, this.originatingRequest))).getUnboundArguments()).size() != 1) {
                this.clientBodyArgument = null;
                try {
                    this.completion.tryEmitError(new WebSocketClientException("WebSocket @OnMessage method " + targetBean.getClass().getSimpleName() + "." + this.messageHandler.getExecutableMethod() + " should define exactly 1 message parameter, but found 2 possible candidates: " + unboundArguments));
                }
                finally {
                    if (this.getSession().isOpen()) {
                        this.getSession().close(CloseReason.INTERNAL_ERROR);
                    }
                }
                return;
            }
            this.clientBodyArgument = unboundArguments.iterator().next();
            if (this.pongHandler != null) {
                BoundExecutable boundPong = binder.tryBind(this.pongHandler.getExecutableMethod(), this.webSocketBinder, new WebSocketState(this.clientSession, this.originatingRequest));
                List<Argument<?>> unboundPongArguments = boundPong.getUnboundArguments();
                if (unboundPongArguments.size() == 1 && unboundPongArguments.get(0).isAssignableFrom(WebSocketPongMessage.class)) {
                    this.clientPongArgument = unboundPongArguments.get(0);
                } else {
                    this.clientPongArgument = null;
                    try {
                        this.completion.tryEmitError(new WebSocketClientException("WebSocket @OnMessage pong handler method " + targetBean.getClass().getSimpleName() + "." + this.messageHandler.getExecutableMethod() + " should define exactly 1 pong message parameter, but found: " + unboundArguments));
                    }
                    finally {
                        if (this.getSession().isOpen()) {
                            this.getSession().close(CloseReason.INTERNAL_ERROR);
                        }
                    }
                    return;
                }
            }
            Flux.from(this.callOpenMethod(ctx)).subscribe(o -> {}, error2 -> this.completion.tryEmitError(new WebSocketSessionException("Error opening WebSocket client session: " + error2.getMessage(), (Throwable)error2)), () -> this.completion.tryEmitValue(targetBean));
            return;
        }
        if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    @Override
    protected NettyWebSocketSession createWebSocketSession(ChannelHandlerContext ctx) {
        if (ctx != null) {
            return new NettyWebSocketSession(this.handshakeResponse.headers().get(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT), ctx.channel(), this.originatingRequest, this.codecRegistry, this.handshaker.version().toHttpHeaderValue(), ctx.pipeline().get(SslHandler.class) != null){

                @Override
                public ConvertibleValues<Object> getUriVariables() {
                    if (NettyWebSocketClientHandler.this.matchInfo != null) {
                        return ConvertibleValues.of(NettyWebSocketClientHandler.this.matchInfo.getVariableValues());
                    }
                    return ConvertibleValues.empty();
                }
            };
        }
        return null;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.completion.tryEmitError(cause);
        super.exceptionCaught(ctx, cause);
    }

    public final Mono<T> getHandshakeCompletedMono() {
        return this.completion.asMono();
    }

    @Override
    protected void handleCloseReason(ChannelHandlerContext ctx, CloseReason cr, boolean writeCloseReason) {
        if (!this.handshaker.isHandshakeComplete()) {
            this.completion.tryEmitError(new WebSocketClientException("Error opening WebSocket client session: " + cr.getReason()));
            return;
        }
        super.handleCloseReason(ctx, cr, writeCloseReason);
    }
}

