/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;

public abstract class AnnotatedNodeASTTransformation
implements ASTTransformation {
    private final Set<String> interestingAnnotationNames;
    private final boolean removeAnnotations;
    private SourceUnit sourceUnit;

    protected AnnotatedNodeASTTransformation(Set<String> interestingAnnotationNames, boolean removeAnnotations) {
        this.interestingAnnotationNames = interestingAnnotationNames;
        this.removeAnnotations = removeAnnotations;
    }

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.sourceUnit = source;
        ArrayList<AnnotationNode> annotationNodes = new ArrayList<AnnotationNode>();
        ClassVisitor classVisitor = new ClassVisitor(source, annotationNodes);
        for (ASTNode node : nodes) {
            if (!(node instanceof ModuleNode)) continue;
            ModuleNode module = (ModuleNode)node;
            this.visitAnnotatedNode(module.getPackage(), annotationNodes);
            for (ImportNode importNode2 : module.getImports()) {
                this.visitAnnotatedNode(importNode2, annotationNodes);
            }
            for (ImportNode importNode2 : module.getStarImports()) {
                this.visitAnnotatedNode(importNode2, annotationNodes);
            }
            module.getStaticImports().forEach((name, importNode) -> this.visitAnnotatedNode((AnnotatedNode)importNode, (List<AnnotationNode>)annotationNodes));
            module.getStaticStarImports().forEach((name, importNode) -> this.visitAnnotatedNode((AnnotatedNode)importNode, (List<AnnotationNode>)annotationNodes));
            for (ClassNode classNode : module.getClasses()) {
                this.visitAnnotatedNode(classNode, annotationNodes);
                classNode.visitContents(classVisitor);
            }
        }
        this.processAnnotationNodes(annotationNodes);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    protected abstract void processAnnotationNodes(List<AnnotationNode> var1);

    private void visitAnnotatedNode(AnnotatedNode annotatedNode, List<AnnotationNode> annotatedNodes) {
        if (annotatedNode != null) {
            Iterator<AnnotationNode> annotationNodes = annotatedNode.getAnnotations().iterator();
            while (annotationNodes.hasNext()) {
                AnnotationNode annotationNode = annotationNodes.next();
                if (!this.interestingAnnotationNames.contains(annotationNode.getClassNode().getName())) continue;
                annotatedNodes.add(annotationNode);
                if (!this.removeAnnotations) continue;
                annotationNodes.remove();
            }
        }
    }

    private class ClassVisitor
    extends ClassCodeVisitorSupport {
        private final SourceUnit source;
        private final List<AnnotationNode> annotationNodes;

        ClassVisitor(SourceUnit source, List<AnnotationNode> annotationNodes) {
            this.source = source;
            this.annotationNodes = annotationNodes;
        }

        @Override
        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        @Override
        public void visitAnnotations(AnnotatedNode node) {
            AnnotatedNodeASTTransformation.this.visitAnnotatedNode(node, this.annotationNodes);
        }
    }
}

