/*
 * Decompiled with CFR 0.152.
 */
package org.grails.compiler.injection;

import grails.util.GrailsNameUtils;
import grails.util.Mixin;
import grails.util.MixinTargetAware;
import groovy.lang.GroovyObjectSupport;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.codehaus.groovy.transform.TransformWithPriority;
import org.grails.compiler.injection.GrailsASTUtils;

@Deprecated
@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class MixinTransformation
implements ASTTransformation,
TransformWithPriority {
    public static final ClassNode GROOVY_OBJECT_CLASS_NODE = new ClassNode(GroovyObjectSupport.class);
    private static final ClassNode MY_TYPE = new ClassNode(Mixin.class);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();
    public static final String OBJECT_CLASS = "java.lang.Object";

    @Override
    public void visit(ASTNode[] astNodes, SourceUnit source) {
        if (!(astNodes[0] instanceof AnnotationNode) || !(astNodes[1] instanceof AnnotatedNode)) {
            throw new RuntimeException("Internal error: wrong types: $node.class / $parent.class");
        }
        AnnotatedNode parent = (AnnotatedNode)astNodes[1];
        AnnotationNode node = (AnnotationNode)astNodes[0];
        if (!MY_TYPE.equals(node.getClassNode()) || !(parent instanceof ClassNode)) {
            return;
        }
        ClassNode classNode = (ClassNode)parent;
        String cName = classNode.getName();
        if (classNode.isInterface()) {
            throw new RuntimeException("Error processing interface '" + cName + "'. " + MY_TYPE_NAME + " not allowed for interfaces.");
        }
        ListExpression values = this.getListOfClasses(node);
        this.weaveMixinsIntoClass(classNode, values);
    }

    public void weaveMixinsIntoClass(ClassNode classNode, ListExpression values) {
        if (values != null) {
            for (Expression current : values.getExpressions()) {
                if (!(current instanceof ClassExpression)) continue;
                ClassExpression ce = (ClassExpression)current;
                ClassNode mixinClassNode = ce.getType();
                String fieldName = "$" + GrailsNameUtils.getPropertyName(mixinClassNode.getName());
                if (classNode != null && classNode.getField(fieldName) == null) {
                    boolean isTargetAware = GrailsASTUtils.findInterface(mixinClassNode, new ClassNode(MixinTargetAware.class)) != null;
                    ConstructorCallExpression initialValue = isTargetAware ? new ConstructorCallExpression(mixinClassNode, new MapExpression(Arrays.asList(new MapEntryExpression(new ConstantExpression("target"), new VariableExpression("this"))))) : new ConstructorCallExpression(mixinClassNode, GrailsASTUtils.ZERO_ARGUMENTS);
                    classNode.addField(fieldName, 2, mixinClassNode, initialValue);
                }
                VariableExpression fieldReference = new VariableExpression(fieldName, mixinClassNode);
                while (!mixinClassNode.getName().equals(OBJECT_CLASS)) {
                    List<MethodNode> mixinMethods = mixinClassNode.getMethods();
                    for (MethodNode mixinMethod : mixinMethods) {
                        if (!this.isCandidateMethod(mixinMethod) || this.hasDeclaredMethod(classNode, mixinMethod)) continue;
                        if (mixinMethod.isStatic()) {
                            GrailsASTUtils.addCompileStaticAnnotation(GrailsASTUtils.addDelegateStaticMethod(classNode, mixinMethod));
                            continue;
                        }
                        GrailsASTUtils.addCompileStaticAnnotation(GrailsASTUtils.addDelegateInstanceMethod(classNode, (Expression)fieldReference, mixinMethod, false));
                    }
                    mixinClassNode = mixinClassNode.getSuperClass();
                }
            }
        }
    }

    protected boolean hasDeclaredMethod(ClassNode classNode, MethodNode mixinMethod) {
        return classNode.hasDeclaredMethod(mixinMethod.getName(), mixinMethod.getParameters());
    }

    protected ListExpression getListOfClasses(AnnotationNode node) {
        Expression value = node.getMember("value");
        ListExpression values = null;
        if (value instanceof ListExpression) {
            values = (ListExpression)value;
        } else if (value instanceof ClassExpression) {
            values = new ListExpression();
            values.addExpression(value);
        }
        return values;
    }

    protected boolean isCandidateMethod(MethodNode declaredMethod) {
        return MixinTransformation.isAddableMethod(declaredMethod);
    }

    public static boolean isAddableMethod(MethodNode declaredMethod) {
        ClassNode groovyMethods = GROOVY_OBJECT_CLASS_NODE;
        String methodName = declaredMethod.getName();
        return !declaredMethod.isSynthetic() && !methodName.contains("$") && Modifier.isPublic(declaredMethod.getModifiers()) && !Modifier.isAbstract(declaredMethod.getModifiers()) && !groovyMethods.hasMethod(declaredMethod.getName(), declaredMethod.getParameters());
    }

    @Override
    public int priority() {
        return 2146483612;
    }
}

