/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.support;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public abstract class EventTriggerCaller {
    private static final Log LOG = LogFactory.getLog(EventTriggerCaller.class);
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private boolean invertBooleanReturnValue = true;
    private static final EventTriggerCaller noopCaller = new NoopCaller();

    public static EventTriggerCaller buildCaller(String eventMethodName, Class<?> clazz) {
        return EventTriggerCaller.buildCaller(eventMethodName, clazz, null, null);
    }

    public static EventTriggerCaller buildCaller(String eventMethodName, Class<?> clazz, MetaClass metaClass, Class<?>[] preferredArgumentTypes) {
        EventTriggerCaller caller = EventTriggerCaller.resolveMethodCaller(eventMethodName, clazz, preferredArgumentTypes);
        if (caller == null) {
            caller = EventTriggerCaller.resolveFieldClosureCaller(eventMethodName, clazz);
        }
        if (caller == null) {
            caller = EventTriggerCaller.resolveMetaClassCallers(eventMethodName, clazz, metaClass);
        }
        return caller;
    }

    private static EventTriggerCaller resolveMetaClassCallers(String eventMethodName, Class<?> clazz, MetaClass metaClass) {
        EventTriggerCaller caller;
        if (metaClass == null) {
            metaClass = GroovySystem.getMetaClassRegistry().getMetaClass(clazz);
        }
        if ((caller = EventTriggerCaller.resolveMetaMethodCaller(eventMethodName, metaClass)) == null) {
            caller = EventTriggerCaller.resolveMetaPropertyClosureCaller(eventMethodName, metaClass);
        }
        return caller;
    }

    private static EventTriggerCaller resolveMetaPropertyClosureCaller(String eventMethodName, MetaClass metaClass) {
        MetaProperty metaProperty = metaClass.getMetaProperty(eventMethodName);
        if (metaProperty != null) {
            return new MetaPropertyClosureCaller(metaProperty);
        }
        return null;
    }

    private static EventTriggerCaller resolveMetaMethodCaller(String eventMethodName, MetaClass metaClass) {
        MetaMethod metaMethod = metaClass.getMetaMethod(eventMethodName, EMPTY_ARRAY);
        if (metaMethod != null) {
            return new MetaMethodCaller(metaMethod);
        }
        return null;
    }

    private static EventTriggerCaller resolveFieldClosureCaller(String eventMethodName, Class<?> clazz) {
        Field field = ReflectionUtils.findField(clazz, eventMethodName);
        if (field != null) {
            ReflectionUtils.makeAccessible(field);
            return new FieldClosureCaller(field);
        }
        return null;
    }

    private static EventTriggerCaller resolveMethodCaller(String eventMethodName, Class<?> clazz, Class<?>[] preferredArgumentTypes) {
        Method method = ReflectionUtils.findMethod(clazz, eventMethodName, preferredArgumentTypes);
        if (method == null && preferredArgumentTypes != null && (method = ReflectionUtils.findMethod(clazz, eventMethodName)) == null) {
            method = ReflectionUtils.findMethod(clazz, eventMethodName, null);
        }
        if (method != null) {
            ReflectionUtils.makeAccessible(method);
            return new MethodCaller(method);
        }
        return null;
    }

    public static EventTriggerCaller wrapNullInNoopCaller(EventTriggerCaller caller) {
        return caller != null ? caller : noopCaller;
    }

    public final boolean call(Object entity) {
        return this.call(entity, EMPTY_ARRAY);
    }

    public abstract boolean call(Object var1, Object[] var2);

    public boolean isNoOperationCaller() {
        return false;
    }

    public boolean asBoolean() {
        return !this.isNoOperationCaller();
    }

    boolean resolveReturnValue(Object retval) {
        if (retval instanceof Boolean) {
            boolean returnValue = (Boolean)retval;
            return this.invertBooleanReturnValue ? !returnValue : returnValue;
        }
        return false;
    }

    public boolean isInvertBooleanReturnValue() {
        return this.invertBooleanReturnValue;
    }

    public void setInvertBooleanReturnValue(boolean invertBooleanReturnValue) {
        this.invertBooleanReturnValue = invertBooleanReturnValue;
    }

    private static class MetaPropertyClosureCaller
    extends ClosureCaller {
        MetaProperty metaProperty;

        MetaPropertyClosureCaller(MetaProperty metaProperty) {
            this.metaProperty = metaProperty;
            if (Modifier.isStatic(metaProperty.getModifiers())) {
                this.cloneFirst = true;
            }
        }

        @Override
        public boolean call(Object entity, Object[] argumentArray) {
            Object fieldval = this.metaProperty.getProperty(entity);
            if (fieldval instanceof Closure) {
                return this.resolveReturnValue(this.callClosure(entity, (Closure)fieldval, argumentArray));
            }
            LOG.error("Field " + String.valueOf(this.metaProperty) + " is not Closure.");
            return false;
        }
    }

    private static class MetaMethodCaller
    extends EventTriggerCaller {
        MetaMethod method;
        int numberOfParameters;

        MetaMethodCaller(MetaMethod method) {
            this.method = method;
            this.numberOfParameters = method.getParameterTypes().length;
        }

        @Override
        public boolean call(Object entity, Object[] argumentArray) {
            Object retval = this.method.doMethodInvoke(entity, this.numberOfParameters > 0 ? argumentArray : EMPTY_ARRAY);
            return this.resolveReturnValue(retval);
        }
    }

    private static class FieldClosureCaller
    extends ClosureCaller {
        Field field;

        FieldClosureCaller(Field field) {
            this.field = field;
            if (Modifier.isStatic(field.getModifiers())) {
                this.cloneFirst = true;
            }
        }

        @Override
        public boolean call(Object entity, Object[] argumentArray) {
            Object fieldval = ReflectionUtils.getField(this.field, entity);
            if (fieldval instanceof Closure) {
                return this.resolveReturnValue(this.callClosure(entity, (Closure)fieldval, argumentArray));
            }
            LOG.error("Field " + String.valueOf(this.field) + " is not Closure or method.");
            return false;
        }
    }

    private static class MethodCaller
    extends EventTriggerCaller {
        Method method;
        int numberOfParameters;

        MethodCaller(Method method) {
            this.method = method;
            this.numberOfParameters = method.getParameterTypes().length;
        }

        @Override
        public boolean call(Object entity, Object[] argumentArray) {
            Object[] arguments = new Object[this.numberOfParameters];
            if (argumentArray != null) {
                for (int i2 = 0; i2 < argumentArray.length && i2 < arguments.length; ++i2) {
                    arguments[i2] = argumentArray[i2];
                }
            }
            Object retval = ReflectionUtils.invokeMethod(this.method, entity, arguments);
            return this.resolveReturnValue(retval);
        }
    }

    private static class NoopCaller
    extends EventTriggerCaller {
        private NoopCaller() {
        }

        @Override
        public boolean call(Object entity, Object[] argumentArray) {
            return false;
        }

        @Override
        public boolean isNoOperationCaller() {
            return true;
        }
    }

    private static abstract class ClosureCaller
    extends EventTriggerCaller {
        boolean cloneFirst = false;

        private ClosureCaller() {
        }

        Object callClosure(Object entity, Closure<?> callable, Object[] argumentArray) {
            if (this.cloneFirst) {
                callable = (Closure)callable.clone();
            }
            callable.setResolveStrategy(1);
            callable.setDelegate(entity);
            return callable.call(callable.getMaximumNumberOfParameters() > 0 ? argumentArray : EMPTY_ARRAY);
        }
    }
}

