/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.asciidoctor;

import jakarta.inject.Singleton;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Coordinate;
import org.grails.forge.build.dependencies.CoordinateResolver;
import org.grails.forge.build.gradle.GradlePlugin;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.asciidoctor.template.asciidocGradle;
import org.grails.forge.feature.asciidoctor.template.indexAdoc;
import org.grails.forge.template.RockerTemplate;

@Singleton
public class Asciidoctor
implements Feature {
    private final CoordinateResolver coordinateResolver;

    public Asciidoctor(CoordinateResolver coordinateResolver) {
        this.coordinateResolver = coordinateResolver;
    }

    @Override
    public String getName() {
        return "asciidoctor";
    }

    @Override
    public String getTitle() {
        return "AsciiDoc";
    }

    @Override
    public String getDescription() {
        return "Add support for creating AsciiDoc documentation.";
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        String asciidoctorjVersion = this.coordinateResolver.resolve("asciidoctorj").map(Coordinate::getVersion).orElse("3.0.0");
        String asciidoctorjDiagramVersion = this.coordinateResolver.resolve("asciidoctorj-diagram").map(Coordinate::getVersion).orElse("2.3.1");
        generatorContext.addTemplate("asciidocGradle", new RockerTemplate("gradle/asciidoc.gradle", asciidocGradle.template(asciidoctorjVersion, asciidoctorjDiagramVersion)));
        generatorContext.addBuildPlugin(GradlePlugin.builder().id("org.asciidoctor.jvm.convert").lookupArtifactId("asciidoctor-gradle-jvm").build());
        generatorContext.addTemplate("indexAdoc", new RockerTemplate("src/docs/asciidoc/index.adoc", indexAdoc.template()));
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public String getCategory() {
        return "Documentation";
    }
}

