/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.database;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.build.dependencies.Dependency;
import org.grails.forge.feature.database.DatabaseDriverFeature;
import org.grails.forge.feature.database.HibernateGorm;
import org.grails.forge.feature.database.TestContainers;

@Singleton
public class MySQL
extends DatabaseDriverFeature {
    public MySQL(HibernateGorm hibernateGorm, TestContainers testContainers) {
        super(hibernateGorm, testContainers);
    }

    @Override
    @NonNull
    public String getName() {
        return "mysql";
    }

    @Override
    public String getTitle() {
        return "MySQL";
    }

    @Override
    public String getDescription() {
        return "Add MySQL driver and default configuration";
    }

    @Override
    public String getJdbcDevUrl() {
        return "jdbc:mysql://localhost:3306/devDb?tcpKeepAlive=true";
    }

    @Override
    public String getJdbcTestUrl() {
        return "jdbc:mysql://localhost:3306/testDb?tcpKeepAlive=true";
    }

    @Override
    public String getJdbcProdUrl() {
        return "jdbc:mysql://localhost:3306/prodDb?tcpKeepAlive=true";
    }

    @Override
    public String getDriverClass() {
        return "com.mysql.cj.jdbc.Driver";
    }

    @Override
    public String getDefaultUser() {
        return "root";
    }

    @Override
    public String getDefaultPassword() {
        return "";
    }

    @Override
    public String getDataDialect() {
        return "MYSQL";
    }

    @Override
    public boolean embedded() {
        return false;
    }

    @Override
    public void apply(GeneratorContext generatorContext) {
        generatorContext.addDependency(Dependency.builder().groupId("com.mysql").artifactId("mysql-connector-j").runtimeOnly());
    }
}

