/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.util;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.template.URLTemplate;

public class IOFeatureUtil {
    static final String JAR_EXTENSION = ".jar";

    public static void walk(Path path, BiFunction<String, URLTemplate, GeneratorContext> addTemplate) throws IOException, ProviderNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        int sep = path.toString().lastIndexOf("!/");
        if (sep == -1) {
            IOFeatureUtil.walkFiles(path, classLoader, addTemplate);
        } else {
            String jarPath = path.toString().substring(0, sep);
            if (jarPath.endsWith(JAR_EXTENSION)) {
                ClassLoader loader = null;
                try (FileSystem zipFs = FileSystems.newFileSystem(Paths.get(URI.create(jarPath)), loader);){
                    IOFeatureUtil.walkFiles(zipFs.getPath(path.toString().substring(sep + 1), new String[0]), classLoader, addTemplate);
                }
            }
        }
    }

    private static void walkFiles(Path path, ClassLoader classLoader, BiFunction<String, URLTemplate, GeneratorContext> addTemplate) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(file -> path.getParent().relativize((Path)file).toString()).forEach(relativePath -> addTemplate.apply((String)relativePath, new URLTemplate((String)relativePath, classLoader.getResource((String)relativePath))));
            }
        }
    }
}

