/*
 * Decompiled with CFR 0.152.
 */
package org.grails.gsp.compiler;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GrailsLayoutPreprocessor {
    Pattern parameterPattern = Pattern.compile("<parameter(\\s+name[^>]+?)(/*?)>", 34);
    Pattern metaPattern = Pattern.compile("<meta(\\s[^>]+?)(/*?)>", 34);
    Pattern titlePattern = Pattern.compile("<title(\\s[^>]*)?>(.*?)</title>", 34);
    Pattern headPattern = Pattern.compile("<head(\\s[^>]*)?>(.*?)</head>", 34);
    Pattern bodyPattern = Pattern.compile("<body(\\s[^>]*)?>(.*?)</body>", 34);
    Pattern contentPattern = Pattern.compile("<content(\\s+tag[^>]+)>(.*?)</content>", 34);
    public static final String XML_CLOSING_FOR_EMPTY_TAG_ATTRIBUTE_NAME = "gsp_sm_xmlClosingForEmptyTag";

    public String addGspGrailsLayoutCapturing(String gspSource) {
        StringBuffer sb = this.addHeadCapturing(gspSource);
        sb = this.addBodyCapturing(sb);
        sb = this.addContentCapturing(sb);
        return sb.toString();
    }

    StringBuffer addHeadCapturing(String gspSource) {
        StringBuffer sb = new StringBuffer((int)((double)gspSource.length() * 1.2));
        Matcher m = this.headPattern.matcher(gspSource);
        if (m.find()) {
            m.appendReplacement(sb, "");
            sb.append("<grailsLayout:captureHead");
            if (m.group(1) != null) {
                sb.append(m.group(1));
            }
            sb.append(">");
            sb.append(this.addMetaCapturing(this.addTitleCapturing(m.group(2))));
            sb.append("</grailsLayout:captureHead>");
            m.appendTail(sb);
        } else if (!this.bodyPattern.matcher(gspSource).find()) {
            sb.append(this.addMetaCapturing(this.addTitleCapturing(gspSource)));
        } else {
            sb.append(gspSource);
        }
        return sb;
    }

    String addMetaCapturing(String headContent) {
        Matcher m = this.metaPattern.matcher(headContent);
        String result = this.parameterPattern.matcher(m.replaceAll("<grailsLayout:captureMeta gsp_sm_xmlClosingForEmptyTag=\"$2\"$1/>")).replaceAll("<grailsLayout:parameter$1/>");
        return result;
    }

    String addTitleCapturing(String headContent) {
        Matcher m = this.titlePattern.matcher(headContent);
        return m.replaceAll("<grailsLayout:wrapTitleTag><grailsLayout:captureTitle$1>$2</grailsLayout:captureTitle></grailsLayout:wrapTitleTag>");
    }

    StringBuffer addBodyCapturing(StringBuffer sb) {
        Matcher m = this.bodyPattern.matcher(sb);
        return new StringBuffer(m.replaceAll("<grailsLayout:captureBody$1>$2</grailsLayout:captureBody>"));
    }

    StringBuffer addContentCapturing(StringBuffer sb) {
        Matcher m = this.contentPattern.matcher(sb);
        return new StringBuffer(m.replaceAll("<grailsLayout:captureContent$1>$2</grailsLayout:captureContent>"));
    }
}

