/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.plugins.GrailsPlugin;
import grails.plugins.PluginFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BasePluginFilter
implements PluginFilter {
    private final Set<String> suppliedNames;
    private final List<GrailsPlugin> explicitlyNamedPlugins = new ArrayList<GrailsPlugin>();
    private final List<GrailsPlugin> derivedPlugins = new ArrayList<GrailsPlugin>();
    protected Map<String, GrailsPlugin> nameMap;
    private Set<String> addedNames;
    private List<GrailsPlugin> originalPlugins;

    public BasePluginFilter(Set<String> suppliedNames) {
        this.suppliedNames = suppliedNames;
    }

    public BasePluginFilter(String[] included) {
        this.suppliedNames = new HashSet<String>();
        for (int i2 = 0; i2 < included.length; ++i2) {
            this.suppliedNames.add(included[i2].trim());
        }
    }

    protected abstract void addPluginDependencies(List var1, GrailsPlugin var2);

    protected abstract List<GrailsPlugin> getPluginList(List var1, List var2);

    @Override
    public List<GrailsPlugin> filterPluginList(List<GrailsPlugin> original) {
        this.originalPlugins = Collections.unmodifiableList(original);
        this.addedNames = new HashSet<String>();
        this.buildNameMap();
        this.buildExplicitlyNamedList();
        this.buildDerivedPluginList();
        ArrayList<GrailsPlugin> pluginList = new ArrayList<GrailsPlugin>();
        pluginList.addAll(this.explicitlyNamedPlugins);
        pluginList.addAll(this.derivedPlugins);
        return this.getPluginList(this.originalPlugins, pluginList);
    }

    private void buildDerivedPluginList() {
        for (int i2 = 0; i2 < this.explicitlyNamedPlugins.size(); ++i2) {
            GrailsPlugin plugin2 = this.explicitlyNamedPlugins.get(i2);
            this.addPluginDependencies(this.derivedPlugins, plugin2);
        }
    }

    protected boolean isDependentOn(GrailsPlugin plugin2, String pluginName) {
        String[] dependencyNames = plugin2.getDependencyNames();
        for (int i2 = 0; i2 < dependencyNames.length; ++i2) {
            String dependencyName = dependencyNames[i2];
            if (!pluginName.equals(dependencyName)) continue;
            return true;
        }
        return false;
    }

    private void buildExplicitlyNamedList() {
        for (GrailsPlugin plugin2 : this.originalPlugins) {
            String name = plugin2.getName();
            if (!this.suppliedNames.contains(name)) continue;
            this.explicitlyNamedPlugins.add(plugin2);
            this.addedNames.add(name);
        }
    }

    private void buildNameMap() {
        this.nameMap = new HashMap<String, GrailsPlugin>();
        for (GrailsPlugin plugin2 : this.originalPlugins) {
            this.nameMap.put(plugin2.getName(), plugin2);
        }
    }

    protected void registerDependency(List additionalList, GrailsPlugin plugin2) {
        if (!this.addedNames.contains(plugin2.getName())) {
            this.addedNames.add(plugin2.getName());
            additionalList.add(plugin2);
            this.addPluginDependencies(additionalList, plugin2);
        }
    }

    protected Collection getAllPlugins() {
        return Collections.unmodifiableCollection(this.nameMap.values());
    }

    protected GrailsPlugin getNamedPlugin(String name) {
        return this.nameMap.get(name);
    }

    protected Set<String> getSuppliedNames() {
        return this.suppliedNames;
    }
}

