/*
 * Decompiled with CFR 0.152.
 */
package org.grails.taglib.encoder;

import java.io.IOException;
import java.io.Writer;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.buffer.CodecPrintWriter;
import org.grails.buffer.GrailsLazyProxyPrintWriter;
import org.grails.buffer.GrailsWrappedWriter;
import org.grails.encoder.EncodedAppender;
import org.grails.encoder.EncodedAppenderFactory;
import org.grails.encoder.EncodedAppenderWriterFactory;
import org.grails.encoder.Encoder;
import org.grails.encoder.EncoderAware;
import org.grails.encoder.EncodingStateRegistry;
import org.grails.encoder.StreamingEncoder;
import org.grails.encoder.StreamingEncoderWriter;
import org.grails.taglib.encoder.OutputContext;
import org.grails.taglib.encoder.OutputContextLookupHelper;
import org.grails.taglib.encoder.OutputEncodingStackAttributes;

public final class OutputEncodingStack {
    public static final Log log = LogFactory.getLog(OutputEncodingStack.class);
    private static final String ATTRIBUTE_NAME_OUTPUT_STACK = "org.grails.taglib.encoder.OUTPUT_ENCODING_STACK";
    private final OutputContext outputContext;
    private Stack<StackEntry> stack = new Stack();
    private OutputProxyWriter taglibWriter;
    private OutputProxyWriter outWriter;
    private OutputProxyWriter staticWriter;
    private OutputProxyWriter expressionWriter;
    private boolean autoSync;
    private EncodingStateRegistry encodingStateRegistry;
    private OutputProxyWriterGroup writerGroup = new OutputProxyWriterGroup();

    public static OutputEncodingStack currentStack() {
        return OutputEncodingStack.currentStack(true);
    }

    public static OutputEncodingStack currentStack(OutputContext outputContext) {
        return OutputEncodingStack.currentStack(outputContext, true);
    }

    public static OutputEncodingStack currentStack(boolean allowCreate) {
        return OutputEncodingStack.currentStack(OutputContextLookupHelper.lookupOutputContext(), allowCreate);
    }

    public static OutputEncodingStack currentStack(OutputContext outputContext, boolean allowCreate) {
        OutputEncodingStack outputStack = OutputEncodingStack.lookupStack(outputContext);
        if (outputStack == null && allowCreate) {
            outputStack = OutputEncodingStack.currentStack(outputContext, allowCreate, null, allowCreate, false);
        }
        return outputStack;
    }

    public static OutputEncodingStack currentStack(boolean allowCreate, Writer topWriter, boolean autoSync, boolean pushTop) {
        return OutputEncodingStack.currentStack(OutputContextLookupHelper.lookupOutputContext(), allowCreate, topWriter, autoSync, pushTop);
    }

    public static OutputEncodingStack currentStack(OutputContext outputContext, boolean allowCreate, Writer topWriter, boolean autoSync, boolean pushTop) {
        return OutputEncodingStack.currentStack(new OutputEncodingStackAttributes.Builder().outputContext(outputContext).allowCreate(allowCreate).topWriter(topWriter).autoSync(autoSync).pushTop(pushTop).build());
    }

    public static OutputEncodingStack currentStack(OutputEncodingStackAttributes attributes) {
        OutputEncodingStack outputStack = OutputEncodingStack.lookupStack(attributes.getOutputContext());
        if (outputStack != null) {
            if (attributes.isPushTop()) {
                outputStack.push(attributes, false);
            }
            return outputStack;
        }
        if (attributes.isAllowCreate()) {
            return OutputEncodingStack.createNew(attributes);
        }
        return null;
    }

    private static final OutputEncodingStack createNew(OutputEncodingStackAttributes attributes) {
        if (attributes.getTopWriter() == null) {
            attributes = new OutputEncodingStackAttributes.Builder(attributes).topWriter(OutputEncodingStack.lookupCurrentWriter(attributes.getOutputContext())).build();
        }
        OutputEncodingStack instance = new OutputEncodingStack(attributes);
        attributes.getOutputContext().setCurrentOutputEncodingStack(instance);
        return instance;
    }

    private static OutputEncodingStack lookupStack(OutputContext outputContext) {
        OutputEncodingStack outputStack = outputContext.getCurrentOutputEncodingStack();
        return outputStack;
    }

    public static final Writer currentWriter() {
        OutputEncodingStack outputStack = OutputEncodingStack.currentStack(false);
        if (outputStack != null) {
            return outputStack.getOutWriter();
        }
        return OutputEncodingStack.lookupCurrentWriter();
    }

    private static Writer lookupCurrentWriter() {
        OutputContext outputContext = OutputContextLookupHelper.lookupOutputContext();
        return OutputEncodingStack.lookupCurrentWriter(outputContext);
    }

    private static Writer lookupCurrentWriter(OutputContext outputContext) {
        if (outputContext != null) {
            return outputContext.getCurrentWriter();
        }
        return null;
    }

    private OutputEncodingStack(OutputEncodingStackAttributes attributes) {
        this.outWriter = new OutputProxyWriter(this.writerGroup, new GrailsLazyProxyPrintWriter.DestinationFactory(){

            @Override
            public Writer activateDestination() throws IOException {
                StackEntry stackEntry = OutputEncodingStack.this.stack.peek();
                return OutputEncodingStack.this.createEncodingWriter(stackEntry.unwrappedTarget, stackEntry.outEncoder, OutputEncodingStack.this.encodingStateRegistry, "scriptlet");
            }
        });
        this.staticWriter = new OutputProxyWriter(this.writerGroup, new GrailsLazyProxyPrintWriter.DestinationFactory(){

            @Override
            public Writer activateDestination() throws IOException {
                StackEntry stackEntry = OutputEncodingStack.this.stack.peek();
                if (stackEntry.staticEncoder == null) {
                    return stackEntry.unwrappedTarget;
                }
                return OutputEncodingStack.this.createEncodingWriter(stackEntry.unwrappedTarget, stackEntry.staticEncoder, OutputEncodingStack.this.encodingStateRegistry, "staticparts");
            }
        });
        this.expressionWriter = new OutputProxyWriter(this.writerGroup, new GrailsLazyProxyPrintWriter.DestinationFactory(){

            @Override
            public Writer activateDestination() throws IOException {
                StackEntry stackEntry = OutputEncodingStack.this.stack.peek();
                return OutputEncodingStack.this.createEncodingWriter(stackEntry.unwrappedTarget, stackEntry.expressionEncoder, OutputEncodingStack.this.encodingStateRegistry, "expression");
            }
        });
        this.taglibWriter = new OutputProxyWriter(this.writerGroup, new GrailsLazyProxyPrintWriter.DestinationFactory(){

            @Override
            public Writer activateDestination() throws IOException {
                StackEntry stackEntry = OutputEncodingStack.this.stack.peek();
                return OutputEncodingStack.this.createEncodingWriter(stackEntry.unwrappedTarget, stackEntry.taglibEncoder != null ? stackEntry.taglibEncoder : stackEntry.defaultTaglibEncoder, OutputEncodingStack.this.encodingStateRegistry, "taglib");
            }
        });
        this.autoSync = attributes.isAutoSync();
        this.push(attributes, false);
        if (!this.autoSync) {
            this.applyWriterThreadLocals(this.outWriter);
        }
        this.encodingStateRegistry = attributes.getOutputContext().getEncodingStateRegistry();
        this.outputContext = attributes.getOutputContext() != null ? attributes.getOutputContext() : OutputContextLookupHelper.lookupOutputContext();
    }

    private Writer unwrapTargetWriter(Writer targetWriter) {
        if (targetWriter instanceof GrailsWrappedWriter && ((GrailsWrappedWriter)((Object)targetWriter)).isAllowUnwrappingOut()) {
            return ((GrailsWrappedWriter)((Object)targetWriter)).unwrap();
        }
        return targetWriter;
    }

    public void push(Writer newWriter) {
        this.push(newWriter, false);
    }

    public void push(Writer newWriter, boolean checkExisting) {
        OutputEncodingStackAttributes.Builder attributesBuilder = new OutputEncodingStackAttributes.Builder();
        attributesBuilder.inheritPreviousEncoders(true);
        attributesBuilder.topWriter(newWriter);
        this.push(attributesBuilder.build(), checkExisting);
    }

    public void push(OutputEncodingStackAttributes attributes) {
        this.push(attributes, false);
    }

    public void push(OutputEncodingStackAttributes attributes, boolean checkExisting) {
        this.writerGroup.reset();
        if (checkExisting) {
            this.checkExistingStack(attributes.getTopWriter());
        }
        StackEntry previousStackEntry = null;
        if (this.stack.size() > 0) {
            previousStackEntry = this.stack.peek();
        }
        Writer topWriter = attributes.getTopWriter();
        Writer unwrappedWriter = null;
        if (topWriter != null) {
            if (topWriter instanceof OutputProxyWriter) {
                topWriter = ((OutputProxyWriter)topWriter).getOut();
            }
            unwrappedWriter = this.unwrapTargetWriter(topWriter);
        } else if (previousStackEntry != null) {
            topWriter = previousStackEntry.originalTarget;
            unwrappedWriter = previousStackEntry.unwrappedTarget;
        } else {
            throw new NullPointerException("attributes.getTopWriter() is null and there is no previous stack item");
        }
        StackEntry stackEntry = new StackEntry(topWriter, unwrappedWriter);
        stackEntry.outEncoder = this.applyEncoder(attributes.getOutEncoder(), previousStackEntry != null ? previousStackEntry.outEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        stackEntry.staticEncoder = this.applyEncoder(attributes.getStaticEncoder(), previousStackEntry != null ? previousStackEntry.staticEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        stackEntry.expressionEncoder = this.applyEncoder(attributes.getExpressionEncoder(), previousStackEntry != null ? previousStackEntry.expressionEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        stackEntry.taglibEncoder = this.applyEncoder(attributes.getTaglibEncoder(), previousStackEntry != null ? previousStackEntry.taglibEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        stackEntry.defaultTaglibEncoder = this.applyEncoder(attributes.getDefaultTaglibEncoder(), previousStackEntry != null ? previousStackEntry.defaultTaglibEncoder : null, attributes.isInheritPreviousEncoders(), attributes.isReplaceOnly());
        this.stack.push(stackEntry);
        this.resetWriters();
        if (this.autoSync) {
            this.applyWriterThreadLocals(attributes.getTopWriter());
        }
    }

    private Encoder applyEncoder(Encoder newEncoder, Encoder previousEncoder, boolean allowInheriting, boolean replaceOnly) {
        if (newEncoder != null && (!replaceOnly || previousEncoder == null || replaceOnly && previousEncoder.isSafe())) {
            return newEncoder;
        }
        if (allowInheriting) {
            return previousEncoder;
        }
        return null;
    }

    private void checkExistingStack(Writer topWriter) {
        if (topWriter != null) {
            for (StackEntry item : this.stack) {
                if (item.originalTarget != topWriter) continue;
                log.warn("Pushed a writer to stack a second time. Writer type " + topWriter.getClass().getName(), new Exception());
            }
        }
    }

    private void resetWriters() {
        this.outWriter.setDestinationActivated(false);
        this.staticWriter.setDestinationActivated(false);
        this.expressionWriter.setDestinationActivated(false);
        this.taglibWriter.setDestinationActivated(false);
    }

    private Writer createEncodingWriter(Writer out, Encoder encoder, EncodingStateRegistry encodingStateRegistry, String codecWriterName) {
        Writer encodingWriter = out instanceof EncodedAppenderWriterFactory ? ((EncodedAppenderWriterFactory)((Object)out)).getWriterForEncoder(encoder, encodingStateRegistry) : (encoder instanceof StreamingEncoder ? new StreamingEncoderWriter(out, (StreamingEncoder)encoder, encodingStateRegistry) : new CodecPrintWriter(out, encoder, encodingStateRegistry));
        return encodingWriter;
    }

    public void pop() {
        this.pop(this.autoSync);
    }

    public void pop(boolean forceSync) {
        this.writerGroup.reset();
        this.stack.pop();
        this.resetWriters();
        if (this.stack.size() > 0) {
            StackEntry stackEntry = this.stack.peek();
            if (forceSync) {
                this.applyWriterThreadLocals(stackEntry.originalTarget);
            }
        }
    }

    public OutputProxyWriter getOutWriter() {
        return this.outWriter;
    }

    public OutputProxyWriter getStaticWriter() {
        return this.staticWriter;
    }

    public OutputProxyWriter getExpressionWriter() {
        return this.expressionWriter;
    }

    public OutputProxyWriter getTaglibWriter() {
        return this.taglibWriter;
    }

    public Encoder getOutEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().outEncoder : null;
    }

    public Encoder getStaticEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().staticEncoder : null;
    }

    public Encoder getExpressionEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().expressionEncoder : null;
    }

    public Encoder getTaglibEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().taglibEncoder : null;
    }

    public Encoder getDefaultTaglibEncoder() {
        return this.stack.size() > 0 ? this.stack.peek().defaultTaglibEncoder : null;
    }

    public Writer getCurrentOriginalWriter() {
        return this.stack.peek().originalTarget;
    }

    public void restoreThreadLocalsToOriginals() {
        Writer originalTopWriter = ((StackEntry)this.stack.firstElement()).originalTarget;
        this.applyWriterThreadLocals(originalTopWriter);
    }

    private void applyWriterThreadLocals(Writer writer) {
        if (this.outputContext != null) {
            this.outputContext.setCurrentWriter(writer);
        }
    }

    public void flushActiveWriter() {
        this.writerGroup.flushActive();
    }

    public OutputContext getOutputContext() {
        return this.outputContext;
    }

    public class OutputProxyWriter
    extends GrailsLazyProxyPrintWriter
    implements EncodedAppenderFactory,
    EncoderAware {
        OutputProxyWriterGroup writerGroup;

        OutputProxyWriter(OutputProxyWriterGroup writerGroup, GrailsLazyProxyPrintWriter.DestinationFactory factory) {
            super(factory);
            this.writerGroup = writerGroup;
        }

        public OutputEncodingStack getOutputStack() {
            return OutputEncodingStack.this;
        }

        @Override
        public Writer getOut() {
            this.writerGroup.activateWriter(this);
            return super.getOut();
        }

        @Override
        public EncodedAppender getEncodedAppender() {
            Writer out = this.getOut();
            if (out instanceof EncodedAppenderFactory) {
                return ((EncodedAppenderFactory)((Object)out)).getEncodedAppender();
            }
            if (out instanceof EncodedAppender) {
                return (EncodedAppender)((Object)this.getOut());
            }
            return null;
        }

        @Override
        public Encoder getEncoder() {
            Writer out = this.getOut();
            if (out instanceof EncoderAware) {
                return ((EncoderAware)((Object)out)).getEncoder();
            }
            return null;
        }
    }

    static class OutputProxyWriterGroup {
        OutputProxyWriter activeWriter;

        OutputProxyWriterGroup() {
        }

        void reset() {
            this.activateWriter(null);
        }

        void activateWriter(OutputProxyWriter newWriter) {
            if (newWriter != this.activeWriter) {
                this.flushActive();
                this.activeWriter = newWriter;
            }
        }

        void flushActive() {
            if (this.activeWriter != null) {
                this.activeWriter.flush();
            }
        }
    }

    private static class StackEntry
    implements Cloneable {
        Writer originalTarget;
        Writer unwrappedTarget;
        Encoder staticEncoder;
        Encoder taglibEncoder;
        Encoder defaultTaglibEncoder;
        Encoder outEncoder;
        Encoder expressionEncoder;

        StackEntry(Writer originalTarget, Writer unwrappedTarget) {
            this.originalTarget = originalTarget;
            this.unwrappedTarget = unwrappedTarget;
        }

        public StackEntry clone() {
            StackEntry newEntry = new StackEntry(this.originalTarget, this.unwrappedTarget);
            newEntry.staticEncoder = this.staticEncoder;
            newEntry.outEncoder = this.outEncoder;
            newEntry.taglibEncoder = this.taglibEncoder;
            newEntry.defaultTaglibEncoder = this.defaultTaglibEncoder;
            newEntry.expressionEncoder = this.expressionEncoder;
            return newEntry;
        }
    }
}

