/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.json.parser;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.grails.web.json.JSONArray;
import org.grails.web.json.JSONElement;
import org.grails.web.json.JSONObject;
import org.grails.web.json.parser.JsonParserConstants;
import org.grails.web.json.parser.JsonParserTokenManager;
import org.grails.web.json.parser.ParseException;
import org.grails.web.json.parser.SimpleCharStream;
import org.grails.web.json.parser.StringUnmarshaller;
import org.grails.web.json.parser.Token;

public final class JSONParser
implements JsonParserConstants {
    public JsonParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[12];
    private static int[] jj_la1_0;
    private List jj_expentries = new ArrayList();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public final Object parse() throws ParseException {
        Object json = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                json = this.JsonObject();
                break;
            }
            case 25: {
                json = this.JsonArray();
                break;
            }
            case 6: 
            case 10: 
            case 11: 
            case 27: 
            case 28: 
            case 29: {
                json = this.JsonPrimitive();
                break;
            }
            case 22: {
                json = this.JsonNull();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return json;
    }

    public final JSONElement parseJSON() throws ParseException {
        JSONElement json = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                json = this.JsonObject();
                break;
            }
            case 25: {
                json = this.JsonArray();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return json;
    }

    private final JSONObject JsonObject() throws ParseException {
        JSONObject o = new JSONObject();
        this.jj_consume_token(20);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 11: {
                this.Members(o);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.jj_consume_token(21);
        return o;
    }

    private final Object JsonNull() throws ParseException {
        Object o = null;
        this.jj_consume_token(22);
        return o;
    }

    private final void Members(JSONObject o) throws ParseException {
        this.Pair(o);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: {
                this.jj_consume_token(23);
                this.Members(o);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
    }

    private final void Pair(JSONObject o) throws ParseException {
        String property = this.JsonString();
        this.jj_consume_token(24);
        Object value = this.JsonValue();
        o.put(property, value);
    }

    private final JSONArray JsonArray() throws ParseException {
        JSONArray array = new JSONArray();
        this.jj_consume_token(25);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: 
            case 10: 
            case 11: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                this.Elements(array);
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        this.jj_consume_token(26);
        return array;
    }

    private final void Elements(JSONArray array) throws ParseException {
        while (this.addElementAndGetNextToken(array) == 23) {
            this.jj_consume_token(23);
        }
        this.jj_la1[5] = this.jj_gen;
    }

    private final int addElementAndGetNextToken(JSONArray array) throws ParseException {
        array.add(this.JsonValue());
        return this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk;
    }

    private final Object JsonValue() throws ParseException {
        Object o = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 11: {
                o = this.JsonString();
                break;
            }
            case 6: 
            case 29: {
                o = this.JsonNumber();
                break;
            }
            case 20: {
                o = this.JsonObject();
                break;
            }
            case 25: {
                o = this.JsonArray();
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                o = Boolean.TRUE;
                break;
            }
            case 28: {
                this.jj_consume_token(28);
                o = Boolean.FALSE;
                break;
            }
            case 22: {
                this.jj_consume_token(22);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return o;
    }

    private final Object JsonPrimitive() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10: 
            case 11: {
                String value = this.JsonString();
                return value;
            }
            case 6: 
            case 29: {
                Object value = this.JsonNumber();
                return value;
            }
            case 27: {
                this.jj_consume_token(27);
                return Boolean.TRUE;
            }
            case 28: {
                this.jj_consume_token(28);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[7] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final Object JsonNumber() throws ParseException {
        String intpart = null;
        String fracpart = null;
        String exppart = null;
        intpart = this.JsonInt();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                fracpart = this.JsonFrac();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                exppart = this.JsonExp();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        Number n = exppart != null ? new BigDecimal(intpart + fracpart + exppart) : (fracpart != null ? (Number)Double.valueOf(intpart + fracpart) : (Number)(intpart.length() < 10 ? (Number)Integer.valueOf(intpart) : (Number)(intpart.length() < 19 ? Long.valueOf(intpart) : new BigInteger(intpart))));
        return n;
    }

    private final String JsonInt() throws ParseException {
        boolean negative = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                this.jj_consume_token(29);
                negative = true;
                break;
            }
            default: {
                this.jj_la1[10] = this.jj_gen;
            }
        }
        String digits = this.Digits();
        if (negative) {
            return "-" + digits;
        }
        return digits;
    }

    private final String JsonFrac() throws ParseException {
        this.jj_consume_token(30);
        String digits = this.Digits();
        return "." + digits;
    }

    private final String JsonExp() throws ParseException {
        Token t = this.jj_consume_token(5);
        String digits = this.Digits();
        return t.image + digits;
    }

    private final String Digits() throws ParseException {
        Token t = this.jj_consume_token(6);
        return t.image;
    }

    private final String JsonString() throws ParseException {
        Token t = switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 10 -> this.jj_consume_token(10);
            case 11 -> this.jj_consume_token(11);
            default -> {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
        return StringUnmarshaller.unmarshall(t.image);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{978324544, 0x2100000, 3072, 0x800000, 978324544, 0x800000, 978324544, 939527232, 0x40000000, 32, 0x20000000, 3072};
    }

    public JSONParser(InputStream stream) {
        this(stream, null);
    }

    public JSONParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 12; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 12; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public JSONParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new JsonParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 12; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 12; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public JSONParser(JsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 12; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    public void ReInit(JsonParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i2 = 0; i2 < 12; ++i2) {
            this.jj_la1[i2] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index2) {
        Token t = this.token;
        for (int i2 = 0; i2 < index2; ++i2) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i2;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[31];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i2 = 0; i2 < 12; ++i2) {
            if (this.jj_la1[i2] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i2] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i2 = 0; i2 < 31; ++i2) {
            if (!la1tokens[i2]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i2;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i3 = 0; i3 < this.jj_expentries.size(); ++i3) {
            exptokseq[i3] = (int[])this.jj_expentries.get(i3);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        JSONParser.jj_la1_init_0();
    }
}

