/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.namespace;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.namespace.NamespaceStateManager;
import org.apache.hadoop.hbase.namespace.NamespaceTableAndRegionInfo;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NamespaceAuditor {
    private static final Logger LOG = LoggerFactory.getLogger(NamespaceAuditor.class);
    private NamespaceStateManager stateManager;
    private MasterServices masterServices;

    public NamespaceAuditor(MasterServices masterServices) {
        this.masterServices = masterServices;
        this.stateManager = new NamespaceStateManager(masterServices);
    }

    public void start() throws IOException {
        this.stateManager.start();
        LOG.info("NamespaceAuditor started.");
    }

    public void checkQuotaToCreateTable(TableName tName, int regions) throws IOException {
        if (this.stateManager.isInitialized()) {
            if (this.masterServices.getTableDescriptors().exists(tName)) {
                throw new TableExistsException(tName);
            }
            this.stateManager.checkAndUpdateNamespaceTableCount(tName, regions);
        } else {
            this.checkTableTypeAndThrowException(tName);
        }
    }

    public void checkQuotaToUpdateRegion(TableName tName, int regions) throws IOException {
        if (this.stateManager.isInitialized()) {
            this.stateManager.checkAndUpdateNamespaceRegionCount(tName, regions);
        } else {
            this.checkTableTypeAndThrowException(tName);
        }
    }

    private void checkTableTypeAndThrowException(TableName name) throws IOException {
        if (!name.isSystemTable()) {
            throw new HBaseIOException(name + " is being created even before namespace auditor has been initialized.");
        }
        LOG.debug("Namespace auditor checks not performed for table " + name.getNameAsString());
    }

    public int getRegionCountOfTable(TableName tName) throws IOException {
        if (this.stateManager.isInitialized()) {
            NamespaceTableAndRegionInfo state = this.stateManager.getState(tName.getNamespaceAsString());
            return state != null ? state.getRegionCountOfTable(tName) : -1;
        }
        this.checkTableTypeAndThrowException(tName);
        return -1;
    }

    public void checkQuotaToSplitRegion(RegionInfo hri) throws IOException {
        if (!this.stateManager.isInitialized()) {
            throw new IOException("Split operation is being performed even before namespace auditor is initialized.");
        }
        if (!this.stateManager.checkAndUpdateNamespaceRegionCount(hri.getTable(), hri.getRegionName(), 1)) {
            throw new QuotaExceededException("Region split not possible for :" + hri.getEncodedName() + " as quota limits are exceeded ");
        }
    }

    public void updateQuotaForRegionMerge(RegionInfo mergedRegion) throws IOException {
        if (!this.stateManager.isInitialized()) {
            throw new IOException("Merge operation is being performed even before namespace auditor is initialized.");
        }
        if (!this.stateManager.checkAndUpdateNamespaceRegionCount(mergedRegion.getTable(), mergedRegion.getRegionName(), -1)) {
            throw new QuotaExceededException("Region merge not possible for :" + mergedRegion.getEncodedName() + " as quota limits are exceeded ");
        }
    }

    public void addNamespace(NamespaceDescriptor ns) throws IOException {
        this.stateManager.addNamespace(ns.getName());
    }

    public void deleteNamespace(String namespace) throws IOException {
        this.stateManager.deleteNamespace(namespace);
    }

    public void removeFromNamespaceUsage(TableName tableName) throws IOException {
        this.stateManager.removeTable(tableName);
    }

    public void removeRegionFromNamespaceUsage(RegionInfo hri) throws IOException {
        this.stateManager.removeRegionFromTable(hri);
    }

    public NamespaceTableAndRegionInfo getState(String namespace) {
        if (this.stateManager.isInitialized()) {
            return this.stateManager.getState(namespace);
        }
        return null;
    }

    public boolean isInitialized() {
        return this.stateManager.isInitialized();
    }
}

