/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools;

import com.google.common.base.Joiner;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.tools.GetConf;
import org.apache.hadoop.hdfs.util.HostsFileWriter;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Test;

public class TestGetConf {
    FileSystem localFileSys;

    private void setupNameServices(HdfsConfiguration conf, int nameServiceIdCount) {
        StringBuilder nsList = new StringBuilder();
        for (int i = 0; i < nameServiceIdCount; ++i) {
            if (nsList.length() > 0) {
                nsList.append(",");
            }
            nsList.append(TestGetConf.getNameServiceId(i));
        }
        conf.set("dfs.nameservices", nsList.toString());
    }

    private String[] setupAddress(HdfsConfiguration conf, String key, int nameServiceIdCount, int portOffset) {
        String[] values = new String[nameServiceIdCount];
        int i = 0;
        while (i < nameServiceIdCount) {
            String nsID = TestGetConf.getNameServiceId(i);
            String specificKey = DFSUtil.addKeySuffixes((String)key, (String[])new String[]{nsID});
            values[i] = "nn" + i + ":" + portOffset;
            conf.set(specificKey, values[i]);
            ++i;
            ++portOffset;
        }
        return values;
    }

    private void setupStaticHostResolution(int nameServiceIdCount) {
        for (int i = 0; i < nameServiceIdCount; ++i) {
            NetUtils.addStaticResolution((String)("nn" + i), (String)"localhost");
        }
    }

    private String[] toStringArray(List<DFSUtil.ConfiguredNNAddress> list) {
        String[] ret = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            ret[i] = NetUtils.getHostPortString((InetSocketAddress)list.get(i).getAddress());
        }
        return ret;
    }

    private Map<String, Map<String, InetSocketAddress>> getAddressListFromConf(TestType type, HdfsConfiguration conf) throws IOException {
        switch (type) {
            case NAMENODE: {
                return DFSUtil.getNNServiceRpcAddressesForCluster((Configuration)conf);
            }
            case BACKUP: {
                return DFSUtil.getBackupNodeAddresses((Configuration)conf);
            }
            case SECONDARY: {
                return DFSUtil.getSecondaryNameNodeAddresses((Configuration)conf);
            }
            case NNRPCADDRESSES: {
                return DFSUtil.getNNServiceRpcAddressesForCluster((Configuration)conf);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runTool(HdfsConfiguration conf, String[] args, boolean success) throws Exception {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(o, true);
        try {
            int ret = ToolRunner.run((Tool)new GetConf((Configuration)conf, out, out), (String[])args);
            out.flush();
            System.err.println("Output: " + o.toString());
            Assert.assertEquals((String)("Expected " + (success ? "success" : "failure") + " for args: " + Joiner.on((String)" ").join((Object[])args) + "\n" + "Output: " + o.toString()), (Object)success, (Object)(ret == 0 ? 1 : 0));
            String string = o.toString();
            return string;
        }
        finally {
            o.close();
            out.close();
        }
    }

    private String getAddressListFromTool(TestType type, HdfsConfiguration conf, boolean success) throws Exception {
        String[] args = new String[1];
        switch (type) {
            case NAMENODE: {
                args[0] = GetConf.Command.NAMENODE.getName();
                break;
            }
            case BACKUP: {
                args[0] = GetConf.Command.BACKUP.getName();
                break;
            }
            case SECONDARY: {
                args[0] = GetConf.Command.SECONDARY.getName();
                break;
            }
            case NNRPCADDRESSES: {
                args[0] = GetConf.Command.NNRPCADDRESSES.getName();
            }
        }
        return this.runTool(conf, args, success);
    }

    private void getAddressListFromTool(TestType type, HdfsConfiguration conf, boolean checkPort, List<DFSUtil.ConfiguredNNAddress> expected) throws Exception {
        String out = this.getAddressListFromTool(type, conf, expected.size() != 0);
        ArrayList<String> values = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(out);
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken().trim();
            values.add(s);
        }
        Object[] actual = values.toArray(new String[values.size()]);
        int i = 0;
        Object[] expectedHosts = new String[expected.size()];
        for (DFSUtil.ConfiguredNNAddress cnn : expected) {
            InetSocketAddress addr = cnn.getAddress();
            if (!checkPort) {
                expectedHosts[i++] = addr.getHostName();
                continue;
            }
            expectedHosts[i++] = addr.getHostName() + ":" + addr.getPort();
        }
        Assert.assertTrue((boolean)Arrays.equals(expectedHosts, actual));
    }

    private void verifyAddresses(HdfsConfiguration conf, TestType type, boolean checkPort, String ... expected) throws Exception {
        Map<String, Map<String, InetSocketAddress>> map = this.getAddressListFromConf(type, conf);
        List list = DFSUtil.flattenAddressMap(map);
        Object[] actual = this.toStringArray(list);
        Arrays.sort(actual);
        Arrays.sort(expected);
        Assert.assertArrayEquals((Object[])expected, (Object[])actual);
        this.getAddressListFromTool(type, conf, checkPort, list);
    }

    private static String getNameServiceId(int index) {
        return "ns" + index;
    }

    @Test(timeout=10000L)
    public void testEmptyConf() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        this.getAddressListFromTool(TestType.NAMENODE, conf, false);
        System.out.println(this.getAddressListFromTool(TestType.BACKUP, conf, false));
        this.getAddressListFromTool(TestType.SECONDARY, conf, false);
        this.getAddressListFromTool(TestType.NNRPCADDRESSES, conf, false);
        for (GetConf.Command cmd : GetConf.Command.values()) {
            String arg = cmd.getName();
            GetConf.CommandHandler handler = GetConf.Command.getHandler((String)arg);
            Assert.assertNotNull((String)("missing handler: " + cmd), (Object)handler);
            if (handler.key == null) continue;
            String[] args = new String[]{handler.key};
            this.runTool(conf, args, false);
        }
    }

    @Test(timeout=10000L)
    public void testInvalidArgument() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        String[] args = new String[]{"-invalidArgument"};
        String ret = this.runTool(conf, args, false);
        Assert.assertTrue((boolean)ret.contains(GetConf.USAGE));
    }

    @Test(timeout=10000L)
    public void testNonFederation() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        conf.set("fs.defaultFS", "hdfs://localhost:1000");
        this.verifyAddresses(conf, TestType.NAMENODE, false, "localhost:1000");
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, "localhost:1000");
        conf.set("dfs.namenode.backup.address", "localhost:1001");
        this.verifyAddresses(conf, TestType.BACKUP, false, "localhost:1001");
        conf.set("dfs.namenode.secondary.http-address", "localhost:1002");
        this.verifyAddresses(conf, TestType.SECONDARY, false, "localhost:1002");
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.servicerpc-address", "localhost:1000");
        conf.set("dfs.namenode.rpc-address", "localhost:1001");
        this.verifyAddresses(conf, TestType.NAMENODE, false, "localhost:1000");
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, "localhost:1000");
        conf = new HdfsConfiguration();
        conf.set("dfs.namenode.rpc-address", "localhost:1001");
        this.verifyAddresses(conf, TestType.NAMENODE, false, "localhost:1001");
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, "localhost:1001");
    }

    @Test(timeout=10000L)
    public void testFederation() throws Exception {
        int nsCount = 10;
        HdfsConfiguration conf = new HdfsConfiguration(false);
        this.setupNameServices(conf, 10);
        String[] nnAddresses = this.setupAddress(conf, "dfs.namenode.servicerpc-address", 10, 1000);
        this.setupAddress(conf, "dfs.namenode.rpc-address", 10, 1500);
        this.setupStaticHostResolution(10);
        String[] backupAddresses = this.setupAddress(conf, "dfs.namenode.backup.address", 10, 2000);
        String[] secondaryAddresses = this.setupAddress(conf, "dfs.namenode.secondary.http-address", 10, 3000);
        this.verifyAddresses(conf, TestType.NAMENODE, false, nnAddresses);
        this.verifyAddresses(conf, TestType.BACKUP, false, backupAddresses);
        this.verifyAddresses(conf, TestType.SECONDARY, false, secondaryAddresses);
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, nnAddresses);
        conf = new HdfsConfiguration(false);
        this.setupNameServices(conf, 10);
        nnAddresses = this.setupAddress(conf, "dfs.namenode.rpc-address", 10, 1000);
        backupAddresses = this.setupAddress(conf, "dfs.namenode.backup.address", 10, 2000);
        secondaryAddresses = this.setupAddress(conf, "dfs.namenode.secondary.http-address", 10, 3000);
        this.verifyAddresses(conf, TestType.NAMENODE, false, nnAddresses);
        this.verifyAddresses(conf, TestType.BACKUP, false, backupAddresses);
        this.verifyAddresses(conf, TestType.SECONDARY, false, secondaryAddresses);
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, nnAddresses);
    }

    @Test(timeout=10000L)
    public void testGetSpecificKey() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("mykey", " myval ");
        String[] args = new String[]{"-confKey", "mykey"};
        String toolResult = this.runTool(conf, args, true);
        Assert.assertEquals((Object)String.format("myval%n", new Object[0]), (Object)toolResult);
    }

    @Test(timeout=10000L)
    public void testExtraArgsThrowsError() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.set("mykey", "myval");
        String[] args = new String[]{"-namenodes", "unexpected-arg"};
        Assert.assertTrue((boolean)this.runTool(conf, args, false).contains("Did not expect argument: unexpected-arg"));
    }

    @Test(timeout=10000L)
    public void testTool() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration(false);
        for (GetConf.Command cmd : GetConf.Command.values()) {
            GetConf.CommandHandler handler = GetConf.Command.getHandler((String)cmd.getName());
            if (handler.key == null || "-confKey".equals(cmd.getName())) continue;
            String[] args = new String[]{cmd.getName()};
            conf.set(handler.key, "value");
            Assert.assertTrue((boolean)this.runTool(conf, args, true).contains("value"));
        }
    }

    @Test
    public void TestGetConfExcludeCommand() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize((Configuration)conf, "GetConf");
        Path excludeFile = hostsFileWriter.getExcludeFile();
        String[] args = new String[]{"-excludeFile"};
        String ret = this.runTool(conf, args, true);
        Assert.assertEquals((Object)excludeFile.toUri().getPath(), (Object)ret.trim());
        hostsFileWriter.cleanup();
    }

    @Test
    public void TestGetConfIncludeCommand() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        HostsFileWriter hostsFileWriter = new HostsFileWriter();
        hostsFileWriter.initialize((Configuration)conf, "GetConf");
        Path hostsFile = hostsFileWriter.getIncludeFile();
        String[] args = new String[]{"-includeFile"};
        String ret = this.runTool(conf, args, true);
        Assert.assertEquals((Object)hostsFile.toUri().getPath(), (Object)ret.trim());
        hostsFileWriter.cleanup();
    }

    @Test
    public void testIncludeInternalNameServices() throws Exception {
        int nsCount = 10;
        int remoteNsCount = 4;
        HdfsConfiguration conf = new HdfsConfiguration();
        this.setupNameServices(conf, 10);
        this.setupAddress(conf, "dfs.namenode.servicerpc-address", 10, 1000);
        this.setupAddress(conf, "dfs.namenode.rpc-address", 10, 1500);
        conf.set("dfs.internal.nameservices", "ns1");
        this.setupStaticHostResolution(10);
        String[] includedNN = new String[]{"nn1:1001"};
        this.verifyAddresses(conf, TestType.NAMENODE, false, includedNN);
        this.verifyAddresses(conf, TestType.NNRPCADDRESSES, true, includedNN);
    }

    static enum TestType {
        NAMENODE,
        BACKUP,
        SECONDARY,
        NNRPCADDRESSES;

    }
}

