/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Cluster;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class JobUtil {
    protected JobUtil() {
    }

    public static Path getStagingDir(Configuration conf) throws IOException, InterruptedException {
        return JobSubmissionFiles.getStagingDir((Cluster)new Cluster(conf), (Configuration)conf);
    }

    public static Path getQualifiedStagingDir(Configuration conf) throws IOException, InterruptedException {
        Cluster cluster = new Cluster(conf);
        Path stagingDir = JobSubmissionFiles.getStagingDir((Cluster)cluster, (Configuration)conf);
        return cluster.getFileSystem().makeQualified(stagingDir);
    }
}

