/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Size;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.mapreduce.RegionSizeCalculator;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MiscTests.class, SmallTests.class})
public class TestRegionSizeCalculator {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionSizeCalculator.class);
    private Configuration configuration = new Configuration();
    private final long megabyte = 0x100000L;
    private final ServerName sn = ServerName.valueOf((String)"local-rs", (int)16020, (long)-1L);

    @Test
    public void testSimpleTestCase() throws Exception {
        RegionLocator regionLocator = this.mockRegionLocator("region1", "region2", "region3");
        Admin admin = this.mockAdmin(this.mockRegion("region1", 123, 321), this.mockRegion("region3", 1232, 2321), this.mockRegion("region2", 54321, 12345), this.mockRegion("region4", 6789, 0), this.mockRegion("region5", 0, 4567));
        RegionSizeCalculator calculator = new RegionSizeCalculator(regionLocator, admin);
        Assert.assertEquals((long)465567744L, (long)calculator.getRegionSize(Bytes.toBytes((String)"region1")));
        Assert.assertEquals((long)69904367616L, (long)calculator.getRegionSize(Bytes.toBytes((String)"region2")));
        Assert.assertEquals((long)3725590528L, (long)calculator.getRegionSize(Bytes.toBytes((String)"region3")));
        Assert.assertEquals((long)7118782464L, (long)calculator.getRegionSize(Bytes.toBytes((String)"region4")));
        Assert.assertEquals((long)4788846592L, (long)calculator.getRegionSize(Bytes.toBytes((String)"region5")));
        Assert.assertEquals((long)0L, (long)calculator.getRegionSize(Bytes.toBytes((String)"otherTableRegion")));
        Assert.assertEquals((long)5L, (long)calculator.getRegionSizeMap().size());
    }

    @Test
    public void testLargeRegion() throws Exception {
        RegionLocator regionLocator = this.mockRegionLocator("largeRegion");
        Admin admin = this.mockAdmin(this.mockRegion("largeRegion", Integer.MAX_VALUE, Integer.MAX_VALUE));
        RegionSizeCalculator calculator = new RegionSizeCalculator(regionLocator, admin);
        Assert.assertEquals((long)0xFFFFFFFE00000L, (long)calculator.getRegionSize(Bytes.toBytes((String)"largeRegion")));
    }

    @Test
    public void testDisabled() throws Exception {
        String regionName = "cz.goout:/index.html";
        RegionLocator table = this.mockRegionLocator(regionName);
        Admin admin = this.mockAdmin(this.mockRegion(regionName, 999, 888));
        RegionSizeCalculator calculator = new RegionSizeCalculator(table, admin);
        Assert.assertEquals((long)1978662912L, (long)calculator.getRegionSize(Bytes.toBytes((String)regionName)));
        this.configuration.setBoolean("hbase.regionsizecalculator.enable", false);
        RegionSizeCalculator disabledCalculator = new RegionSizeCalculator(table, admin);
        Assert.assertEquals((long)0L, (long)disabledCalculator.getRegionSize(Bytes.toBytes((String)regionName)));
        Assert.assertEquals((long)0L, (long)disabledCalculator.getRegionSizeMap().size());
    }

    @Test
    public void testRegionWithNullServerName() throws Exception {
        RegionLocator regionLocator = this.mockRegionLocator(null, Collections.singletonList("someBigRegion"));
        Admin admin = this.mockAdmin(this.mockRegion("someBigRegion", Integer.MAX_VALUE, Integer.MAX_VALUE));
        RegionSizeCalculator calculator = new RegionSizeCalculator(regionLocator, admin);
        Assert.assertEquals((long)0L, (long)calculator.getRegionSize(Bytes.toBytes((String)"someBigRegion")));
    }

    private RegionLocator mockRegionLocator(String ... regionNames) throws IOException {
        return this.mockRegionLocator(this.sn, Arrays.asList(regionNames));
    }

    private RegionLocator mockRegionLocator(ServerName serverName, List<String> regionNames) throws IOException {
        RegionLocator mockedTable = (RegionLocator)Mockito.mock(RegionLocator.class);
        Mockito.when((Object)mockedTable.getName()).thenReturn((Object)TableName.valueOf((String)"sizeTestTable"));
        ArrayList<HRegionLocation> regionLocations = new ArrayList<HRegionLocation>(regionNames.size());
        Mockito.when((Object)mockedTable.getAllRegionLocations()).thenReturn(regionLocations);
        for (String regionName : regionNames) {
            HRegionInfo info = (HRegionInfo)Mockito.mock(HRegionInfo.class);
            Mockito.when((Object)info.getRegionName()).thenReturn((Object)Bytes.toBytes((String)regionName));
            regionLocations.add(new HRegionLocation((RegionInfo)info, serverName));
        }
        return mockedTable;
    }

    private Admin mockAdmin(RegionMetrics ... regionLoadArray) throws Exception {
        Admin mockAdmin = (Admin)Mockito.mock(Admin.class);
        ArrayList<RegionMetrics> regionLoads = new ArrayList<RegionMetrics>(Arrays.asList(regionLoadArray));
        Mockito.when((Object)mockAdmin.getConfiguration()).thenReturn((Object)this.configuration);
        Mockito.when((Object)mockAdmin.getRegionMetrics(this.sn, TableName.valueOf((String)"sizeTestTable"))).thenReturn(regionLoads);
        return mockAdmin;
    }

    private RegionMetrics mockRegion(String regionName, int fileSizeMb, int memStoreSize) {
        RegionMetrics region = (RegionMetrics)Mockito.mock(RegionMetrics.class);
        Mockito.when((Object)region.getRegionName()).thenReturn((Object)regionName.getBytes());
        Mockito.when((Object)region.getNameAsString()).thenReturn((Object)regionName);
        Mockito.when((Object)region.getStoreFileSize()).thenReturn((Object)new Size((double)fileSizeMb, Size.Unit.MEGABYTE));
        Mockito.when((Object)region.getMemStoreSize()).thenReturn((Object)new Size((double)memStoreSize, Size.Unit.MEGABYTE));
        return region;
    }
}

