/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestNewStartedRegionServerVersion {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestNewStartedRegionServerVersion.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestNewStartedRegionServerVersion.class);
    private static HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws InterruptedException {
        Thread t = new Thread(() -> {
            for (int i = 0; i < 3; ++i) {
                try {
                    JVMClusterUtil.RegionServerThread newRS = UTIL.getMiniHBaseCluster().startRegionServer();
                    newRS.waitForServerOnline();
                    continue;
                }
                catch (IOException e) {
                    LOG.error("Failed to start a new RS", (Throwable)e);
                }
            }
        });
        t.start();
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        while (t.isAlive()) {
            List serverNames = master.getServerManager().getOnlineServersList();
            for (ServerName serverName : serverNames) {
                Assert.assertNotEquals((long)0L, (long)master.getServerManager().getVersionNumber(serverName));
            }
            Thread.sleep(100L);
        }
    }
}

