/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.snapshot.SnapshotInfo;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestSnapshotStats {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotStats.class);
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Admin admin;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() throws Exception {
        this.TEST_UTIL.startMiniCluster(1);
        this.admin = this.TEST_UTIL.getAdmin();
    }

    @After
    public void tearDown() throws IOException {
        this.admin.close();
        this.TEST_UTIL.shutdownMiniCluster();
        this.TEST_UTIL.getTestFileSystem().delete(this.TEST_UTIL.getDataTestDir(), true);
    }

    @Test
    public void testSnapshotTableWithoutAnyData() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"info")).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        this.admin.createTable(tableDescriptorBuilder.build());
        Assert.assertTrue((boolean)this.admin.tableExists(tableName));
        String snapshotName = "snapshot_" + this.name.getMethodName();
        this.admin.snapshot(snapshotName, tableName);
        Optional<SnapshotDescription> optional = this.admin.listSnapshots().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
        Assert.assertTrue((boolean)optional.isPresent());
        SnapshotDescription snapshotDescription = optional.get();
        SnapshotInfo.SnapshotStats snapshotStats = SnapshotInfo.getSnapshotStats((Configuration)this.TEST_UTIL.getConfiguration(), (SnapshotDescription)snapshotDescription);
        Assert.assertEquals((long)0L, (long)snapshotStats.getStoreFilesSize());
        Assert.assertEquals((float)0.0f, (float)snapshotStats.getSharedStoreFilePercentage(), (float)0.0f);
        this.admin.deleteSnapshot(snapshotName);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
    }

    @Test
    public void testSnapshotMobTableWithoutAnyData() throws IOException {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        TableDescriptorBuilder tableDescriptorBuilder = TableDescriptorBuilder.newBuilder((TableName)tableName);
        ColumnFamilyDescriptor columnFamilyDescriptor = ColumnFamilyDescriptorBuilder.newBuilder((byte[])Bytes.toBytes((String)"info")).setMobEnabled(true).build();
        tableDescriptorBuilder.setColumnFamily(columnFamilyDescriptor);
        this.admin.createTable(tableDescriptorBuilder.build());
        Assert.assertTrue((boolean)this.admin.tableExists(tableName));
        String snapshotName = "snapshot_" + this.name.getMethodName();
        this.admin.snapshot(snapshotName, tableName);
        Optional<SnapshotDescription> optional = this.admin.listSnapshots().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
        Assert.assertTrue((boolean)optional.isPresent());
        SnapshotDescription snapshotDescription = optional.get();
        SnapshotInfo.SnapshotStats snapshotStats = SnapshotInfo.getSnapshotStats((Configuration)this.TEST_UTIL.getConfiguration(), (SnapshotDescription)snapshotDescription);
        Assert.assertEquals((long)0L, (long)snapshotStats.getStoreFilesSize());
        Assert.assertEquals((float)0.0f, (float)snapshotStats.getSharedStoreFilePercentage(), (float)0.0f);
        Assert.assertEquals((float)0.0f, (float)snapshotStats.getMobStoreFilePercentage(), (float)0.0f);
        this.admin.deleteSnapshot(snapshotName);
        this.admin.disableTable(tableName);
        this.admin.deleteTable(tableName);
    }
}

