/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.HBaseConfTool;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestHBaseConfTool {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHBaseConfTool.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBaseConfTool() {
        String[] args = new String[]{"hbase.master.logcleaner.ttl"};
        PrintStream stdout = System.out;
        try {
            DummyPrintStream printStream = new DummyPrintStream(System.out);
            System.setOut(printStream);
            HBaseConfTool.main((String[])args);
            List<String> printedLines = printStream.getPrintedLines();
            Assert.assertNotNull(printedLines);
            Assert.assertEquals((long)1L, (long)printedLines.size());
            Assert.assertEquals((Object)String.valueOf(600000L), (Object)printedLines.get(0));
        }
        finally {
            System.setOut(stdout);
        }
    }

    static class DummyPrintStream
    extends PrintStream {
        private List<String> printedLines = new LinkedList<String>();

        public DummyPrintStream(PrintStream printStream) {
            super(printStream);
        }

        @Override
        public void println(String line) {
            this.printedLines.add(line);
            super.println(line);
        }

        public List<String> getPrintedLines() {
            return this.printedLines;
        }
    }
}

