/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rsgroup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.rsgroup.RSGroupInfo;
import org.apache.hadoop.hbase.rsgroup.TestRSGroupsBase;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRSGroupsBasics
extends TestRSGroupsBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRSGroupsBasics.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestRSGroupsBasics.class);

    @BeforeClass
    public static void setUp() throws Exception {
        TestRSGroupsBasics.setUpTestBeforeClass();
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TestRSGroupsBasics.tearDownAfterClass();
    }

    @Before
    public void beforeMethod() throws Exception {
        this.setUpBeforeMethod();
    }

    @After
    public void afterMethod() throws Exception {
        this.tearDownAfterMethod();
    }

    @Test
    public void testBasicStartUp() throws IOException {
        RSGroupInfo defaultInfo = rsGroupAdmin.getRSGroupInfo("default");
        Assert.assertEquals((long)4L, (long)defaultInfo.getServers().size());
        int count = master.getAssignmentManager().getRegionStates().getRegionAssignments().size();
        Assert.assertEquals((long)3L, (long)count);
    }

    @Test
    public void testCreateAndDrop() throws Exception {
        TEST_UTIL.createTable(this.tableName, Bytes.toBytes((String)"cf"));
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBasics.this.getTableRegionMap().get(TestRSGroupsBasics.this.tableName) != null;
            }
        });
        TEST_UTIL.deleteTable(this.tableName);
    }

    @Test
    public void testCreateMultiRegion() throws IOException {
        byte[] end = new byte[]{1, 3, 5, 7, 9};
        byte[] start = new byte[]{0, 2, 4, 6, 8};
        byte[][] f = new byte[][]{Bytes.toBytes((String)"f")};
        TEST_UTIL.createTable(this.tableName, (byte[][])f, 1, start, end, 10);
    }

    @Test
    public void testNamespaceCreateAndAssign() throws Exception {
        LOG.info("testNamespaceCreateAndAssign");
        String nsName = "Group_foo";
        TableName tableName = TableName.valueOf((String)nsName, (String)"Group_testCreateAndAssign");
        RSGroupInfo appInfo = this.addGroup("appInfo", 1);
        admin.createNamespace(NamespaceDescriptor.create((String)nsName).addConfiguration("hbase.rsgroup.name", "appInfo").build());
        final TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        admin.createTable(desc);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBasics.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
        ServerName targetServer = this.getServerName((Address)appInfo.getServers().iterator().next());
        Assert.assertEquals((long)1L, (long)admin.getRegions(targetServer).size());
    }

    @Test
    public void testCreateWhenRsgroupNoOnlineServers() throws Exception {
        LOG.info("testCreateWhenRsgroupNoOnlineServers");
        RSGroupInfo appInfo = this.addGroup("appInfo", 1);
        Iterator iterator = appInfo.getServers().iterator();
        ArrayList<ServerName> serversToDecommission = new ArrayList<ServerName>();
        ServerName targetServer = this.getServerName((Address)iterator.next());
        Assert.assertTrue((boolean)master.getServerManager().getOnlineServers().containsKey(targetServer));
        serversToDecommission.add(targetServer);
        admin.decommissionRegionServers(serversToDecommission, true);
        Assert.assertEquals((long)1L, (long)admin.listDecommissionedRegionServers().size());
        TableName tableName = TableName.valueOf((String)"Group_ns", (String)this.name.getMethodName());
        admin.createNamespace(NamespaceDescriptor.create((String)tableName.getNamespaceAsString()).addConfiguration("hbase.rsgroup.name", appInfo.getName()).build());
        final TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        try {
            admin.createTable(desc);
            Assert.fail((String)"Shouldn't create table successfully!");
        }
        catch (Exception e) {
            LOG.debug("create table error", (Throwable)e);
        }
        admin.recommissionRegionServer(targetServer, null);
        Assert.assertEquals((long)0L, (long)admin.listDecommissionedRegionServers().size());
        admin.createTable(desc);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBasics.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
    }

    @Test
    public void testDefaultNamespaceCreateAndAssign() throws Exception {
        LOG.info("testDefaultNamespaceCreateAndAssign");
        String tableName = "Group_testCreateAndAssign";
        admin.modifyNamespace(NamespaceDescriptor.create((String)"default").addConfiguration("hbase.rsgroup.name", "default").build());
        final TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableName)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"f")).build();
        admin.createTable(desc);
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBasics.this.getTableRegionMap().get(desc.getTableName()) != null;
            }
        });
    }

    @Test
    public void testCloneSnapshot() throws Exception {
        byte[] FAMILY = Bytes.toBytes((String)"test");
        String snapshotName = this.tableName.getNameAsString() + "_snap";
        TableName clonedTableName = TableName.valueOf((String)(this.tableName.getNameAsString() + "_clone"));
        TEST_UTIL.createTable(this.tableName, FAMILY);
        admin.snapshot(snapshotName, this.tableName);
        admin.cloneSnapshot(snapshotName, clonedTableName);
    }

    @Test
    public void testClearDeadServers() throws Exception {
        LOG.info("testClearDeadServers");
        int serverCountToMoveToNewGroup = 3;
        RSGroupInfo newGroup = this.addGroup(this.getGroupName(this.name.getMethodName()), 3);
        NUM_DEAD_SERVERS = cluster.getClusterMetrics().getDeadServerNames().size();
        ServerName serverToStop = this.getServerName((Address)newGroup.getServers().iterator().next());
        try {
            admin.stopRegionServer(serverToStop.getAddress().toString());
            ++NUM_DEAD_SERVERS;
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.cluster.getClusterMetrics().getDeadServerNames().size() == TestRSGroupsBase.NUM_DEAD_SERVERS && !TestRSGroupsBase.master.getServerManager().areDeadServersInProgress();
            }
        });
        Assert.assertFalse((boolean)cluster.getClusterMetrics().getLiveServerMetrics().containsKey(serverToStop));
        Assert.assertTrue((boolean)cluster.getClusterMetrics().getDeadServerNames().contains(serverToStop));
        Assert.assertTrue((boolean)newGroup.getServers().contains(serverToStop.getAddress()));
        List notClearedServers = admin.clearDeadServers((List)Lists.newArrayList((Object[])new ServerName[]{serverToStop}));
        Assert.assertEquals((long)0L, (long)notClearedServers.size());
        Set newGroupServers = rsGroupAdmin.getRSGroupInfo(newGroup.getName()).getServers();
        Assert.assertFalse((boolean)newGroupServers.contains(serverToStop.getAddress()));
        Assert.assertEquals((long)2L, (long)newGroupServers.size());
    }

    @Test
    public void testClearNotProcessedDeadServer() throws Exception {
        LOG.info("testClearNotProcessedDeadServer");
        NUM_DEAD_SERVERS = cluster.getClusterMetrics().getDeadServerNames().size();
        boolean serverCountToMoveToDeadServerGroup = true;
        RSGroupInfo deadServerGroup = this.addGroup("deadServerGroup", 1);
        ServerName serverToStop = this.getServerName((Address)deadServerGroup.getServers().iterator().next());
        try {
            admin.stopRegionServer(serverToStop.getAddress().toString());
            ++NUM_DEAD_SERVERS;
        }
        catch (Exception exception) {
            // empty catch block
        }
        TEST_UTIL.waitFor(60000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return TestRSGroupsBase.cluster.getClusterMetrics().getDeadServerNames().size() == TestRSGroupsBase.NUM_DEAD_SERVERS;
            }
        });
        Set ServersInDeadServerGroup = rsGroupAdmin.getRSGroupInfo(deadServerGroup.getName()).getServers();
        Assert.assertEquals((long)1L, (long)ServersInDeadServerGroup.size());
        Assert.assertTrue((boolean)ServersInDeadServerGroup.contains(serverToStop.getAddress()));
    }

    @Test
    public void testRSGroupsWithHBaseQuota() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", true);
        this.restartHBaseCluster();
        try {
            TEST_UTIL.waitFor(90000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

                public boolean evaluate() throws Exception {
                    return TestRSGroupsBase.admin.isTableAvailable(QuotaTableUtil.QUOTA_TABLE_NAME);
                }
            });
        }
        finally {
            TEST_UTIL.getConfiguration().setBoolean("hbase.quota.enabled", false);
            this.restartHBaseCluster();
        }
    }

    private void restartHBaseCluster() throws Exception {
        LOG.info("\n\nShutting down cluster");
        TEST_UTIL.shutdownMiniHBaseCluster();
        LOG.info("\n\nSleeping a bit");
        Thread.sleep(2000L);
        TEST_UTIL.restartHBaseCluster(3);
        TestRSGroupsBasics.initialize();
    }
}

